/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sido.gen;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import net.sf.sido.gen.GenerationConfiguration;
import net.sf.sido.gen.GenerationInput;
import net.sf.sido.gen.model.GenerationContext;
import net.sf.sido.gen.model.GenerationListener;
import net.sf.sido.gen.model.GenerationModel;
import net.sf.sido.gen.model.GenerationOutput;
import net.sf.sido.gen.model.GenerationResult;
import net.sf.sido.parser.NamedInput;
import net.sf.sido.parser.SidoParser;
import net.sf.sido.parser.SidoParserFactory;
import net.sf.sido.parser.discovery.SidoDiscoveryLogger;
import net.sf.sido.parser.discovery.support.DefaultSidoDiscovery;
import net.sf.sido.schema.Sido;
import net.sf.sido.schema.SidoContext;
import net.sf.sido.schema.SidoSchema;
import net.sf.sido.schema.SidoType;
import net.sf.sido.schema.support.DefaultSidoContext;
import org.apache.commons.lang3.StringUtils;

public class GenerationTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(GenerationConfiguration configuration, GenerationListener listener) throws IOException {
        configuration.validate();
        GenerationModel generationModel = this.lookupGenerationModel(configuration, listener);
        listener.log("Using generator: %s --> %s", new Object[]{configuration.getModelId(), generationModel});
        SidoContext formerContext = Sido.setContext((SidoContext)new DefaultSidoContext());
        try {
            this.generate(configuration, listener, generationModel);
        }
        finally {
            Sido.setContext((SidoContext)formerContext);
        }
    }

    protected <R extends GenerationResult> void generate(GenerationConfiguration configuration, GenerationListener listener, GenerationModel<R> generationModel) throws IOException {
        SidoContext context = Sido.getContext();
        this.loadExistingSchemas(context, configuration, listener);
        Collection<InputSchema> inputSchemas = this.loadSchemasToGenerate(context, configuration, listener);
        GenerationContext generationContext = new GenerationContext(configuration.getOptions());
        Collection schemas = Collections2.transform(inputSchemas, InputSchema.getSchemaFn);
        R result = this.generateAll(schemas, generationModel, generationContext, listener);
        result.write(configuration.getOutput(), listener);
        if (configuration.mustWriteRegistration()) {
            this.writeRegistration(inputSchemas, generationModel, configuration, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRegistration(Collection<InputSchema> inputSchemas, GenerationModel<?> generationModel, GenerationConfiguration configuration, GenerationListener listener) throws IOException {
        GenerationOutput registrationOutput = configuration.getRegistrationOutput();
        PrintWriter index = registrationOutput.createInPackage("", "META-INF/sido/sido.schemas");
        try {
            for (InputSchema schema : inputSchemas) {
                index.format("%s\tmodel=%s%n", schema.getSchema().getUid(), generationModel.getId());
            }
        }
        finally {
            index.close();
        }
        for (InputSchema schema : inputSchemas) {
            PrintWriter writer = registrationOutput.createInPackage("", String.format("META-INF/sido/%s", schema.getSchema().getUid()));
            try {
                writer.print(schema.getInput().getInput());
            }
            finally {
                writer.close();
            }
        }
    }

    protected <R extends GenerationResult> R generateAll(Collection<SidoSchema> schemas, GenerationModel<R> generationModel, GenerationContext generationContext, GenerationListener listener) {
        GenerationResult result = generationModel.createResultInstance();
        listener.log("Result instance is %s", new Object[]{result});
        listener.log("Generating all schemas and types", new Object[0]);
        for (SidoSchema schema : schemas) {
            this.generateSchema(result, schema, generationModel, generationContext, listener);
        }
        return (R)result;
    }

    protected <R extends GenerationResult> void generateSchema(R result, SidoSchema schema, GenerationModel<R> generationModel, GenerationContext generationContext, GenerationListener listener) {
        listener.log("Generating schema %s", new Object[]{schema.getUid()});
        for (SidoType type : schema.getTypes()) {
            this.generateType(result, type, generationModel, generationContext, listener);
        }
    }

    protected <R extends GenerationResult> void generateType(R result, SidoType type, GenerationModel<R> generationModel, GenerationContext generationContext, GenerationListener listener) {
        listener.log("Generating type %s", new Object[]{type.getQualifiedName()});
        generationModel.generate(result, type, generationContext, listener);
    }

    protected Collection<InputSchema> loadSchemasToGenerate(SidoContext context, GenerationConfiguration configuration, GenerationListener listener) {
        Collection<GenerationInput> files = configuration.getInputs();
        Collection inputs = Collections2.transform(files, (Function)new Function<GenerationInput, NamedInput>(){

            public NamedInput apply(GenerationInput file) {
                try {
                    return file.getNamedInput();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        SidoParser parser = SidoParserFactory.createParser((SidoContext)context);
        Collection schemas = parser.parse(inputs);
        ArrayList<InputSchema> inputSchemas = new ArrayList<InputSchema>();
        Iterator i1 = inputs.iterator();
        Iterator i2 = schemas.iterator();
        while (i1.hasNext()) {
            inputSchemas.add(new InputSchema((NamedInput)i1.next(), (SidoSchema)i2.next()));
        }
        return inputSchemas;
    }

    protected void loadExistingSchemas(SidoContext context, GenerationConfiguration configuration, final GenerationListener listener) {
        DefaultSidoDiscovery discovery = new DefaultSidoDiscovery();
        Collection discoveryResults = discovery.discover(context, new SidoDiscoveryLogger(){

            public void log(String format, Object ... parameters) {
                listener.log(format, parameters);
            }
        });
    }

    protected <R extends GenerationResult> GenerationModel<R> lookupGenerationModel(GenerationConfiguration configuration, GenerationListener listener) {
        GenerationModel generator;
        String modelId = configuration.getModelId();
        listener.log("Looking for model generator [%s]", new Object[]{modelId});
        ServiceLoader<GenerationModel> loader = ServiceLoader.load(GenerationModel.class, Thread.currentThread().getContextClassLoader());
        Iterator<GenerationModel> i = loader.iterator();
        GenerationModel modelGenerator = null;
        while (i.hasNext()) {
            generator = i.next();
            listener.log("Found generator: %s --> %s", new Object[]{generator.getId(), generator});
            if (!StringUtils.equals((CharSequence)modelId, (CharSequence)generator.getId())) continue;
            modelGenerator = generator;
        }
        if (modelGenerator == null) {
            throw new RuntimeException("Cannot find any generator for model " + modelId);
        }
        generator = modelGenerator;
        return generator;
    }

    protected static class InputSchema {
        public static final Function<InputSchema, SidoSchema> getSchemaFn = new Function<InputSchema, SidoSchema>(){

            public SidoSchema apply(InputSchema o) {
                return o.getSchema();
            }
        };
        private final NamedInput input;
        private final SidoSchema schema;

        public InputSchema(NamedInput input, SidoSchema schema) {
            this.input = input;
            this.schema = schema;
        }

        public NamedInput getInput() {
            return this.input;
        }

        public SidoSchema getSchema() {
            return this.schema;
        }
    }
}

