/*
 * Decompiled with CFR 0.152.
 */
package statemap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EmptyStackException;
import statemap.State7;
import statemap.StateUndefinedException;
import statemap.TransitionHandle;
import statemap.TransitionUndefinedException;

public abstract class FSMContext7
implements Serializable {
    protected transient String _name = "FSMContext";
    protected transient State7 _state;
    protected transient String _transition;
    protected transient State7 _previousState;
    protected transient Deque<State7> _stateStack;
    protected transient boolean _debugFlag;
    protected transient PrintStream _debugStream;
    private transient PropertyChangeSupport _listeners;
    public static final String STATE_PROPERTY = "State";
    protected static final int DEFAULT_TRANSITION_ID = 0;
    protected static final String DEFAULT_NAME = "Default";
    protected static final String SYSTEM_DEFAULT = "defaultTransition";
    protected static final String STATE_NAME_FORMAT = "%s_%s";
    protected static final String ENTRY_NAME = "%s_%s__Entry_";
    protected static final String EXIT_NAME = "%s_%s__Exit_";
    protected static final String TRANSITION_NAME_FORMAT = "%s_%s_%s";
    protected static final MethodType NO_ARGS_TYPE = MethodType.methodType(Void.TYPE);
    private static final long serialVersionUID = 458752L;

    protected FSMContext7(State7 initState) {
        this._state = initState;
        this._transition = "";
        this._previousState = null;
        this._stateStack = null;
        this._debugFlag = false;
        this._debugStream = System.err;
        this._listeners = new PropertyChangeSupport(this);
    }

    protected abstract void executeAction(MethodHandle var1);

    private void readObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        istream.defaultReadObject();
        this._listeners = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this._name;
    }

    public boolean getDebugFlag() {
        return this._debugFlag && this._debugStream != null;
    }

    public PrintStream getDebugStream() {
        return this._debugStream == null ? System.err : this._debugStream;
    }

    public boolean isInTransition() {
        return this._state == null;
    }

    public State7 getState() throws StateUndefinedException {
        if (this._state == null) {
            throw new StateUndefinedException();
        }
        return this._state;
    }

    public State7 getPreviousState() throws NullPointerException {
        return this._previousState;
    }

    public String getTransition() {
        return this._transition;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0 && !name.equals(this._name)) {
            this._name = name;
        }
    }

    public void setDebugFlag(boolean flag) {
        this._debugFlag = flag;
    }

    public void setDebugStream(PrintStream stream) {
        this._debugStream = stream;
    }

    public void setState(State7 state) {
        if (this._debugFlag) {
            this._debugStream.println("ENTERING STATE  : " + state.getName());
        }
        if (this._state != null) {
            this._previousState = this._state;
        }
        this._state = state;
        this._listeners.firePropertyChange(STATE_PROPERTY, this._previousState, this._state);
    }

    public void clearState() {
        this._previousState = this._state;
        this._state = null;
    }

    public void pushState(State7 state) {
        if (this._state == null) {
            throw new NullPointerException();
        }
        if (this._debugFlag) {
            this._debugStream.println("PUSH TO STATE   : " + state.getName());
        }
        if (this._stateStack == null) {
            this._stateStack = new ArrayDeque<State7>();
        }
        this._previousState = this._state;
        this._stateStack.push(this._state);
        this._state = state;
        this._listeners.firePropertyChange(STATE_PROPERTY, this._previousState, this._state);
    }

    public void popState() throws EmptyStackException {
        if (this._stateStack == null || this._stateStack.isEmpty()) {
            if (this._debugFlag) {
                this._debugStream.println("POPPING ON EMPTY STATE STACK.");
            }
            throw new EmptyStackException();
        }
        if (this._state != null) {
            this._previousState = this._state;
        }
        this._state = this._stateStack.pop();
        if (this._stateStack.isEmpty()) {
            this._stateStack = null;
        }
        if (this._debugFlag) {
            this._debugStream.println("POP TO STATE    : " + this._state.getName());
        }
        this._listeners.firePropertyChange(STATE_PROPERTY, this._previousState, this._state);
    }

    public void emptyStateStack() {
        if (this._stateStack != null) {
            this._stateStack.clear();
            this._stateStack = null;
        }
    }

    public void enterStartState() {
        this.enterState();
    }

    public void addStateChangeListener(PropertyChangeListener listener) {
        this._listeners.addPropertyChangeListener(STATE_PROPERTY, listener);
    }

    public void removeStateChangeListener(PropertyChangeListener listener) {
        this._listeners.removePropertyChangeListener(STATE_PROPERTY, listener);
    }

    protected void defaultTransition() {
        if (this._debugFlag) {
            this._debugStream.println("TRANSITION      : Default");
        }
        throw new TransitionUndefinedException("State: " + this.stateName() + ", Transition: " + this.getTransition());
    }

    protected String stateName() {
        return this._state != null ? this._state.getName() : (this._previousState != null ? this._previousState.getName() : "(state unknown)");
    }

    protected void enterState() {
        MethodHandle mh = this._state.enterState();
        if (mh != null) {
            this.executeAction(mh);
        }
    }

    protected void exitState() {
        MethodHandle mh = this._state.exitState();
        if (mh != null) {
            this.executeAction(mh);
        }
    }

    protected static MethodHandle lookupMethod(MethodHandles.Lookup lookup, Class<?> clazz, String name, MethodType mt) {
        MethodHandle retval = null;
        try {
            retval = lookup.findVirtual(clazz, name, mt);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | SecurityException exception) {
            // empty catch block
        }
        return retval;
    }

    protected static TransitionHandle lookupTransition(MethodHandles.Lookup lookup, Class<?> clazz, String mapName, String stateName, String transName, MethodType mt) {
        String mn = String.format(TRANSITION_NAME_FORMAT, mapName, stateName, transName);
        boolean isDefault = false;
        MethodHandle mh = FSMContext7.lookupMethod(lookup, clazz, mn, mt);
        if (mh == null && (mh = FSMContext7.lookupMethod(lookup, clazz, mn = String.format(TRANSITION_NAME_FORMAT, mapName, DEFAULT_NAME, transName), mt)) == null) {
            isDefault = true;
            mt = NO_ARGS_TYPE;
            mn = String.format(TRANSITION_NAME_FORMAT, mapName, stateName, DEFAULT_NAME);
            mh = FSMContext7.lookupMethod(lookup, clazz, mn, mt);
            if (mh == null && (mh = FSMContext7.lookupMethod(lookup, clazz, mn = String.format(TRANSITION_NAME_FORMAT, mapName, DEFAULT_NAME, DEFAULT_NAME), mt)) == null) {
                mh = FSMContext7.lookupMethod(lookup, clazz, SYSTEM_DEFAULT, mt);
            }
        }
        return new TransitionHandle(isDefault, mh);
    }
}

