/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc;

import java.util.ArrayList;
import java.util.List;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;
import net.sf.smc.model.TargetLanguage;
import net.sf.smc.parser.SmcMessage;

public final class SmcSyntaxChecker
extends SmcVisitor {
    private final String mFSMName;
    private final TargetLanguage mTargetLanguage;
    private final List<SmcMessage> mMessages;
    private boolean mCheckFlag;

    public SmcSyntaxChecker(String fsm, TargetLanguage targetLanguage) {
        this.mFSMName = fsm;
        this.mTargetLanguage = targetLanguage;
        this.mMessages = new ArrayList<SmcMessage>();
        this.mCheckFlag = true;
    }

    public boolean isValid() {
        return this.mCheckFlag;
    }

    public List<SmcMessage> getMessages() {
        return this.mMessages;
    }

    public void visit(SmcFSM fsm) {
        String startState = fsm.getStartState();
        String context = fsm.getContext();
        String header = fsm.getHeader();
        if (startState == null || startState.length() == 0) {
            this.mMessages.add(new SmcMessage(this.mFSMName, 0, 1, "\"%start\" missing."));
            this.mCheckFlag = false;
        }
        if (context.length() == 0) {
            this.mMessages.add(new SmcMessage(this.mFSMName, 0, 1, "\"%class\" missing."));
            this.mCheckFlag = false;
        }
        if (this.mTargetLanguage == TargetLanguage.C_PLUS_PLUS && (header == null || header.length() == 0)) {
            this.mMessages.add(new SmcMessage(this.mFSMName, 0, 1, "\"%header\" missing."));
            this.mCheckFlag = false;
        }
        for (SmcMap map : fsm.getMaps()) {
            map.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcMap map) {
        for (SmcState state : map.getStates()) {
            state.accept((SmcVisitor)this);
        }
        if (map.hasDefaultState()) {
            map.getDefaultState().accept((SmcVisitor)this);
        }
    }

    public void visit(SmcState state) {
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcTransition transition) {
        List guards = transition.getGuards();
        int guardCount = guards.size();
        if (this.mTargetLanguage == TargetLanguage.TCL) {
            for (SmcParameter parameter : transition.getParameters()) {
                parameter.accept((SmcVisitor)this);
            }
        }
        if (guardCount > 1) {
            SmcState state = transition.getState();
            String mapName = state.getMap().getName();
            String stateName = state.getClassName();
            String transName = transition.getName();
            ArrayList<String> conditions = new ArrayList<String>(guardCount);
            for (SmcGuard guard : guards) {
                String condition = guard.getCondition();
                if (conditions.contains(condition)) {
                    StringBuilder text = new StringBuilder(500);
                    text.append("State ");
                    text.append(mapName);
                    text.append("::");
                    text.append(stateName);
                    text.append(" has multiple transitions with ");
                    text.append("same name (\"");
                    text.append(transName);
                    text.append("\") and guard (\"");
                    text.append(condition);
                    text.append("\").");
                    this.mMessages.add(new SmcMessage(this.mFSMName, guard.getLineNumber(), 1, text.toString()));
                    this.mCheckFlag = false;
                    continue;
                }
                conditions.add(condition);
            }
        }
        for (SmcGuard guard : guards) {
            guard.accept((SmcVisitor)this);
        }
    }

    public void visit(SmcGuard guard) {
        String endState = guard.getEndState();
        if (guard.getTransType() != SmcElement.TransType.TRANS_POP) {
            if (endState.compareToIgnoreCase("default") == 0) {
                this.mMessages.add(new SmcMessage(this.mFSMName, guard.getLineNumber(), 1, "may not transition to the default state."));
                this.mCheckFlag = false;
            } else if (endState.compareTo("nil") != 0 && !this.findState(endState, guard)) {
                this.mMessages.add(new SmcMessage(this.mFSMName, guard.getLineNumber(), 1, "no such state as \"" + endState + "\"."));
                this.mCheckFlag = false;
            }
        }
        if (guard.getTransType() == SmcElement.TransType.TRANS_PUSH) {
            endState = guard.getPushState();
            if (endState.compareTo("nil") == 0) {
                this.mMessages.add(new SmcMessage(this.mFSMName, guard.getLineNumber(), 1, "may not push to nil state."));
                this.mCheckFlag = false;
            } else if (!this.findState(endState, guard)) {
                this.mMessages.add(new SmcMessage(this.mFSMName, guard.getLineNumber(), 1, "no such state as \"" + endState + "\"."));
                this.mCheckFlag = false;
            }
        }
    }

    public void visit(SmcParameter parameter) {
        String typeName = parameter.getType();
        if (this.mTargetLanguage == TargetLanguage.TCL && !typeName.equals("value") && !typeName.equals("reference")) {
            this.mMessages.add(new SmcMessage(this.mFSMName, parameter.getLineNumber(), 1, "Tcl parameter type not \"value\" or \"reference\" but \"" + typeName + "\"."));
            this.mCheckFlag = false;
        }
    }

    private boolean findState(String endState, SmcGuard guard) {
        int index = endState.indexOf("::");
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        boolean retval = false;
        if (index < 0) {
            retval = map.isKnownState(endState);
        } else {
            String mapName = endState.substring(0, index);
            String stateName = endState.substring(index + 2);
            if (mapName.equals(map.getName())) {
                retval = stateName.equals(state.getName()) ? true : map.isKnownState(stateName);
            } else if ((map = map.getFSM().findMap(mapName)) != null) {
                retval = map.isKnownState(stateName);
            }
        }
        return retval;
    }
}

