/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import net.sf.smc.Smc;
import net.sf.smc.SmcSyntaxChecker;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcVisitor;
import net.sf.smc.model.TargetLanguage;
import net.sf.smc.parser.SmcMessage;
import net.sf.smc.parser.SmcParser;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="smc", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public final class SmcMojo
extends AbstractMojo {
    public static final String SM_SUFFIX = ".sm";
    public static final String NO_DEBUG_OUTPUT = "-1";
    public static final String DEFAULT_GRAPH_LEVEL = "0";
    private static final int NANOS_PER_MILLI = 1000000;
    @Parameter(property="targetLanguage", required=true)
    private String targetLanguage;
    @Parameter(property="sourceDirectory", required=true, defaultValue="${project.basedir}/src/main/smc")
    private File sourceDirectory;
    @Parameter(property="targetDirectory", required=true, defaultValue="${project.build.directory}/generated-sources/smc")
    private File targetDirectory;
    @Parameter(property="sources")
    private String[] sources;
    @Parameter(property="suffix")
    private String suffix;
    @Parameter(property="hsuffix")
    private String hsuffix;
    @Parameter(property="headerd")
    private File headerd;
    @Parameter(property="debugLevel", defaultValue="-1")
    private int debugLevel;
    @Parameter(property="nostreams", defaultValue="false")
    private boolean nostreams;
    @Parameter(property="crtp", defaultValue="false")
    private boolean crtp;
    @Parameter(property="sync", defaultValue="false")
    private boolean sync;
    @Parameter(property="noex", defaultValue="false")
    private boolean noex;
    @Parameter(property="nocatch", defaultValue="false")
    private boolean nocatch;
    @Parameter(property="stack", defaultValue="0")
    private int stateStackSize;
    @Parameter(property="serial", defaultValue="false")
    private boolean serial;
    @Parameter(property="reflect", defaultValue="false")
    private boolean reflection;
    @Parameter(property="generic", defaultValue="false")
    private boolean generic;
    @Parameter(property="generic7", defaultValue="false")
    private boolean generic7;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="vverbose", defaultValue="false")
    private boolean vverbose;
    @Parameter(property="glevel", defaultValue="0")
    private int glevel;
    @Parameter(property="cast")
    private String cast;
    @Parameter(property="access", defaultValue="public")
    private String access;
    @Parameter(property="protocol", defaultValue="false")
    private boolean protocol;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private Smc.Language mTargetLanguage;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Instant startTime = Instant.now();
        if (this.getLog().isDebugEnabled()) {
            this.outputSettings();
        }
        this.validateSettings();
        this.compileAll();
        if (this.verbose) {
            Instant finishTime = Instant.now();
            Duration delta = Duration.between(startTime, finishTime);
            this.getLog().info((CharSequence)String.format("[total %d.%03d ms]", delta.getSeconds(), delta.getNano() / 1000000));
        }
        if (this.mTargetLanguage.hasHeaderFile() && !this.sourceDirectory.equals(this.headerd)) {
            this.project.addCompileSourceRoot(this.headerd.getAbsolutePath());
        }
        this.project.addCompileSourceRoot(this.targetDirectory.getAbsolutePath());
    }

    public void setTargetLanguage(String language) {
        this.targetLanguage = language;
    }

    public void setSourceDirectory(File dir) {
        this.sourceDirectory = dir;
    }

    public void setTargetDirectory(File dir) {
        this.targetDirectory = dir;
    }

    public void setSources(String[] sources) {
        this.sources = sources;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setHsuffix(String headerSuffix) {
        this.hsuffix = headerSuffix;
    }

    public void setHeaderd(File dir) {
        this.headerd = dir;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public void setNostreams(boolean nostreams) {
        this.nostreams = nostreams;
    }

    public void setCrtp(boolean crtp) {
        this.crtp = crtp;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void setNoex(boolean noex) {
        this.noex = noex;
    }

    public void setNocatch(boolean nocatch) {
        this.nocatch = nocatch;
    }

    public void setStateStackSize(int stateStackSize) {
        this.stateStackSize = stateStackSize;
    }

    public void setSerial(boolean serial) {
        this.serial = serial;
    }

    public void setReflection(boolean reflection) {
        this.reflection = reflection;
    }

    public void setGeneric(boolean generic) {
        this.generic = generic;
    }

    public void setGeneric7(boolean generic7) {
        this.generic7 = generic7;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVverbose(boolean vverbose) {
        this.vverbose = vverbose;
    }

    public void setGraphLevel(int glevel) {
        this.glevel = glevel;
    }

    public void setCast(String cast) {
        this.cast = cast;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setProtocol(boolean protocol) {
        this.protocol = protocol;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    private void outputSettings() {
        StringBuilder output = new StringBuilder(2048);
        output.append("SmcMojo configuration:").append("\n targetLanguage=").append(this.targetLanguage).append("\nsourceDirectory=").append(this.sourceDirectory).append("\ntargetDirectory=").append(this.targetDirectory).append("\n        sources=").append(Arrays.toString(this.sources)).append("\n         suffix=").append(this.suffix).append("\n        hsuffix=").append(this.hsuffix).append("\n        headerd=").append(this.headerd).append("\n     debugLevel=").append(this.debugLevel).append("\n      nostreams=").append(this.nostreams).append("\n           crtp=").append(this.crtp).append("\n           sync=").append(this.sync).append("\n           noex=").append(this.noex).append("\n        nocatch=").append(this.nocatch).append("\n stateStackSize=").append(this.stateStackSize).append("\n         serial=").append(this.serial).append("\n     reflection=").append(this.reflection).append("\n        generic=").append(this.generic).append("\n       generic7=").append(this.generic7).append("\n        verbose=").append(this.verbose).append("\n       vverbose=").append(this.vverbose).append("\n     graphLevel=").append(this.glevel).append("\n           cast=").append(this.cast).append("\n         access=").append(this.access).append("\n       protocol=").append(this.protocol);
        this.getLog().debug((CharSequence)output.toString());
    }

    private void validateSettings() throws MojoExecutionException {
        this.mTargetLanguage = Smc.findTargetLanguage((String)this.targetLanguage);
        if (this.mTargetLanguage == null) {
            throw new MojoExecutionException("SMC does not support " + this.targetLanguage + " target language");
        }
        this.isValidDirectory(this.sourceDirectory, false, true, false);
        this.isValidDirectory(this.targetDirectory, true, false, true);
        if (this.sources.length == 0) {
            this.sources = this.sourceDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(SmcMojo.SM_SUFFIX);
                }
            });
        }
        int numSources = this.sources.length;
        for (int i = 0; i < numSources; ++i) {
            this.isValidSource(this.sources[i]);
        }
        this.suffix = this.suffix != null && this.suffix.isEmpty() ? null : this.suffix;
        String string = this.hsuffix = this.hsuffix != null && this.hsuffix.isEmpty() ? null : this.hsuffix;
        if (this.hsuffix != null && !Smc.supportsOption((String)"-hsuffix", (Smc.Language)this.mTargetLanguage)) {
            throw new MojoExecutionException(this.targetLanguage + " does not support " + "-hsuffix".substring(1) + " property");
        }
        if (this.headerd != null) {
            if (!Smc.supportsOption((String)"-headerd", (Smc.Language)this.mTargetLanguage)) {
                throw new MojoExecutionException(this.targetLanguage + " does not support " + "-headerd".substring(1) + " property");
            }
            this.isValidDirectory(this.headerd, true, false, true);
        }
        this.debugLevel = this.isValidDebugLevel(this.debugLevel);
        this.isValidProperty("-nostreams", this.nostreams);
        this.isValidProperty("-crtp", this.crtp);
        this.isValidProperty("-sync", this.sync);
        this.isValidProperty("-noex", this.noex);
        this.isValidProperty("-nocatch", this.nocatch);
        this.isValidStackSize();
        this.isValidProperty("-serial", this.serial);
        this.isValidProperty("-reflect", this.reflection);
        this.isValidProperty("-generic", this.generic);
        this.isValidProperty("-generic7", this.generic7);
        this.isValidCast();
        this.isValidAccessLevel();
        this.isValidGraphLevel();
        this.isValidProperty("-protocol", this.protocol);
    }

    private void isValidDirectory(File path, boolean create, boolean readable, boolean writable) throws MojoExecutionException {
        try {
            if (create && !path.exists() && !path.mkdirs()) {
                throw new MojoExecutionException("failed to create " + path);
            }
            System.out.format("Created directory %s.%n", path);
            if (!path.exists()) {
                throw new MojoExecutionException("\"" + path + "\" does not exist");
            }
            if (!path.isDirectory()) {
                throw new MojoExecutionException("\"" + path + "\" is not a directory");
            }
            if (readable && !path.canRead()) {
                throw new MojoExecutionException("\"" + path + "\" is not readble");
            }
            if (writable && !path.canWrite()) {
                throw new MojoExecutionException("\"" + path + "\" is not writable");
            }
        }
        catch (SecurityException securex) {
            throw new MojoExecutionException("unable to access \"" + path + "\"", (Exception)securex);
        }
    }

    private void isValidSource(String srcName) throws MojoExecutionException {
        File srcFile = new File(this.sourceDirectory, srcName);
        if (!srcName.endsWith(SM_SUFFIX)) {
            throw new MojoExecutionException("\"" + srcName + "\" suffix is not \"" + SM_SUFFIX + "\"");
        }
        if (!srcFile.exists()) {
            throw new MojoExecutionException("\"" + srcFile + "\" does not exist");
        }
        if (!srcFile.canRead()) {
            throw new MojoExecutionException("\"" + srcFile + "\" is not readable");
        }
    }

    private int isValidDebugLevel(int level) {
        int retval = level;
        if (level < -1) {
            retval = -1;
        } else if (level > 1) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("debugLevel " + level + " > max allowed; resetting to maximum."));
            }
            retval = 1;
        }
        return retval;
    }

    private void isValidAccessLevel() throws MojoExecutionException {
        if (this.access != null && !this.access.isEmpty()) {
            if (!Smc.supportsOption((String)"-access", (Smc.Language)this.mTargetLanguage)) {
                throw new MojoExecutionException(this.targetLanguage + " does not support access property");
            }
            if (!Smc.isValidAccessLevel((String)this.access, (Smc.Language)this.mTargetLanguage)) {
                throw new MojoExecutionException(this.targetLanguage + " does not support " + this.access + " level");
            }
        }
    }

    private void isValidCast() throws MojoExecutionException {
        if (this.cast != null && !this.cast.isEmpty()) {
            if (!Smc.supportsOption((String)"-cast", (Smc.Language)this.mTargetLanguage)) {
                throw new MojoExecutionException(this.targetLanguage + " does not support cast property");
            }
            if (!Smc.isValidCast((String)this.cast)) {
                throw new MojoExecutionException(this.targetLanguage + " does not support " + this.cast);
            }
        }
    }

    private void isValidStackSize() throws MojoExecutionException {
        if (!this.targetLanguage.equals(TargetLanguage.C_PLUS_PLUS.suffix())) {
            // empty if block
        }
        if (this.stateStackSize < 0) {
            throw new MojoExecutionException("stack must >= 0");
        }
    }

    private void isValidGraphLevel() throws MojoExecutionException {
        if (this.targetLanguage.equals(TargetLanguage.GRAPH.suffix()) && !Smc.isValidGraphLevel((int)this.glevel)) {
            throw new MojoExecutionException("glevel must be 0, 1, or 2");
        }
    }

    private void isValidProperty(String property, boolean flag) throws MojoExecutionException {
        if (flag && !Smc.supportsOption((String)property, (Smc.Language)this.mTargetLanguage)) {
            throw new MojoExecutionException(this.targetLanguage + " does not support " + property.substring(1) + " property");
        }
    }

    private void compileAll() throws MojoExecutionException {
        int numSources = this.sources.length;
        boolean failureFlag = false;
        for (int i = 0; i < numSources; ++i) {
            try {
                this.compile(this.sources[i]);
                continue;
            }
            catch (MojoFailureException mojoex) {
                failureFlag = true;
                this.getLog().error((CharSequence)mojoex.getLocalizedMessage());
                if (mojoex.getCause() == null) continue;
                this.getLog().error(mojoex.getCause());
            }
        }
        if (failureFlag) {
            throw new MojoExecutionException("SMC compile failures");
        }
    }

    private void compile(String source) throws MojoFailureException {
        SmcFSM fsm = this.parse(source, Smc.getFileName((String)source));
        this.syntaxCheck(source, fsm);
        this.emit(source, fsm);
    }

    private SmcFSM parse(String source, String baseName) throws MojoFailureException {
        SmcFSM retval;
        Instant startTime = Instant.now();
        File sourceFile = new File(this.sourceDirectory, source);
        SmcParser parser = null;
        if (this.verbose) {
            this.getLog().info((CharSequence)("[parsing started " + source + "]"));
        }
        try {
            parser = new SmcParser(baseName, (InputStream)new FileInputStream(sourceFile), this.mTargetLanguage.language(), this.vverbose);
            retval = parser.parse();
        }
        catch (IOException | IllegalAccessException | InvocationTargetException jex) {
            String message = parser == null || parser.getMessages().isEmpty() ? jex.getLocalizedMessage() : this.outputMessages(source, parser.getMessages());
            throw new MojoFailureException(message, (Throwable)jex);
        }
        if (this.verbose) {
            Instant finishTime = Instant.now();
            Duration delta = Duration.between(startTime, finishTime);
            this.getLog().info((CharSequence)String.format("[parsing completed %s %d.%03d ms]", source, delta.getSeconds(), delta.getNano() / 1000000));
        }
        return retval;
    }

    private void syntaxCheck(String source, SmcFSM fsm) throws MojoFailureException {
        SmcSyntaxChecker checker = new SmcSyntaxChecker(source, this.mTargetLanguage.language());
        Instant startTime = Instant.now();
        if (this.verbose) {
            this.getLog().info((CharSequence)("[checking started " + source + "]"));
        }
        fsm.accept((SmcVisitor)checker);
        if (!checker.isValid()) {
            throw new MojoFailureException(this.outputMessages(source, checker.getMessages()));
        }
        if (this.verbose) {
            Instant finishTime = Instant.now();
            Duration delta = Duration.between(startTime, finishTime);
            this.getLog().info((CharSequence)String.format("[checking completed %s %d.%03d ms]", source, delta.getSeconds(), delta.getNano() / 1000000));
        }
    }

    private void emit(String source, SmcFSM fsm) throws MojoFailureException {
        Instant startTime = Instant.now();
        String baseName = fsm.getFsmClassName();
        SmcOptions options = this.setOptions(source, fsm);
        SmcCodeGenerator emitter = null;
        if (this.verbose) {
            this.getLog().info((CharSequence)("[emitting started " + source + "]"));
        }
        try {
            Throwable throwable;
            if (this.mTargetLanguage.hasHeaderFile()) {
                emitter = this.headerEmitter(fsm, options);
                throwable = null;
                try (PrintStream hstream = emitter.target();){
                    fsm.accept((SmcVisitor)emitter);
                    if (this.verbose) {
                        this.getLog().info((CharSequence)String.format("[wrote %s]", emitter.targetFile()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            emitter = this.sourceEmitter(fsm, options);
            throwable = null;
            try (PrintStream srcStream = emitter.target();){
                fsm.accept((SmcVisitor)emitter);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            if (this.verbose) {
                this.getLog().info((CharSequence)String.format("[wrote %s]", emitter.targetFile()));
            }
        }
        catch (IOException ioex) {
            throw new MojoFailureException("error emitting " + (emitter == null ? "(not set)" : emitter.targetFile()), (Throwable)ioex);
        }
        if (this.verbose) {
            Instant finishTime = Instant.now();
            Duration delta = Duration.between(startTime, finishTime);
            this.getLog().info((CharSequence)String.format("[emitting completed %s %d.%03d ms]", source, delta.getSeconds(), delta.getNano() / 1000000));
        }
    }

    private SmcOptions setOptions(String source, SmcFSM fsm) {
        boolean java7Flag;
        boolean bl = java7Flag = this.mTargetLanguage.language() == TargetLanguage.JAVA7;
        if (this.mTargetLanguage.hasHeaderFile()) {
            if (this.hsuffix == null) {
                this.hsuffix = "h";
            }
            if (this.headerd == null) {
                this.headerd = this.targetDirectory;
            }
        }
        if (this.access.equalsIgnoreCase("package")) {
            this.access = "/* package */";
        }
        return new SmcOptions("smc", "v. 6.6.3", source, fsm.getTargetFileName(), this.sourceDirectory.getPath(), this.headerd == null ? "" : this.headerd.getPath(), this.hsuffix, this.cast, this.glevel, this.serial, this.debugLevel, this.noex, this.nocatch, this.nostreams, this.crtp, this.stateStackSize, this.reflection, this.sync, this.generic, java7Flag, this.access, this.protocol);
    }

    private SmcCodeGenerator sourceEmitter(SmcFSM fsm, SmcOptions options) throws IOException {
        String targetFilePath = this.targetPath(this.targetDirectory, fsm);
        String targetFileBase = fsm.getTargetFileName();
        SmcCodeGenerator retval = this.mTargetLanguage.generator(options);
        new File(targetFilePath).mkdirs();
        retval.setTarget(new PrintStream(new FileOutputStream(retval.setTargetFile(targetFilePath, targetFileBase, this.suffix))));
        return retval;
    }

    private SmcCodeGenerator headerEmitter(SmcFSM fsm, SmcOptions options) throws IOException {
        String targetFilePath = this.targetPath(this.headerd, fsm);
        String targetFileBase = fsm.getTargetFileName();
        SmcCodeGenerator retval = this.mTargetLanguage.headerGenerator(options);
        retval.setTarget(new PrintStream(new FileOutputStream(retval.setTargetFile(targetFilePath, targetFileBase, this.hsuffix))));
        return retval;
    }

    private String targetPath(File targetDir, SmcFSM fsm) {
        String pkgName = fsm.getPackage();
        StringBuilder retval = new StringBuilder(targetDir.getPath());
        if (pkgName == null) {
            pkgName = "";
        }
        retval.append(File.separatorChar).append(pkgName.replace('.', File.separatorChar)).append(File.separatorChar);
        return retval.toString();
    }

    private String outputMessages(String source, List<SmcMessage> messages) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (SmcMessage msg : messages) {
            pw.format("%s:%d: %s - %s%n", source, msg.getLineNumber(), msg.getLevel() == 0 ? "warning" : "error", msg.getText());
        }
        return sw.toString();
    }
}

