/*
 * ex: set ro:
 * DO NOT EDIT.
 * generated by smc (http://smc.sourceforge.net/)
 * from file : TcpConnection.sm.sm
 */


//
// The contents of this file are subject to the Mozilla Public
// License Version 1.1 (the "License"); you may not use this file
// except in compliance with the License. You may obtain a copy
// of the License at http://www.mozilla.org/MPL/
// 
// Software distributed under the License is distributed on an
// "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
// implied. See the License for the specific language governing
// rights and limitations under the License.
// 
// The Original Code is State Machine Compiler (SMC).
// 
// The Initial Developer of the Original Code is Charles W. Rapp.
// Portions created by Charles W. Rapp are
// Copyright (C) 2000 - 2003, 2019. Charles W. Rapp.
// All Rights Reserved.
// 
// Contributor(s): 
//
// Name
//  TcpConnection.sm
//
// Description
//  The TCP/IP state transition diagram.
//


package net.sf.smc.generator;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import statemap.FSMContext7;
import statemap.State7;
import statemap.TransitionHandle;

public class TcpConnectionContext
    extends FSMContext7
{
//---------------------------------------------------------------
// Member methods.
//

    //-----------------------------------------------------------
    // Constructors.
    //

    public TcpConnectionContext(final TcpConnection owner)
    {
        this (owner, sStates[MainMap_CLOSED_STATE_ID]);
    }

    public TcpConnectionContext(final TcpConnection owner, final int initStateId)
    {
        this (owner, sStates[initStateId]);    }

    public TcpConnectionContext(final TcpConnection owner, final State7 initState)
    {
        super (initState);

        ctxt = owner;
    }

    //
    // end of Constructors.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // FSMContext7 Abstract Method Override.
    //

    @Override
    protected void executeAction(final MethodHandle mh)
    {
        try
        {
            mh.invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
    }

    //
    // end of FSMContext7 Abstract Method Override.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // Transitions.
    //

    public void ACK(TcpSegment segment)
    {
        mTransition = "ACK";
        try
        {
            final TransitionHandle th =
                getState().transition(ACK11_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Accepted()
    {
        mTransition = "Accepted";
        try
        {
            final TransitionHandle th =
                getState().transition(Accepted6_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void AckTimeout()
    {
        mTransition = "AckTimeout";
        try
        {
            final TransitionHandle th =
                getState().transition(AckTimeout12_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Close()
    {
        mTransition = "Close";
        try
        {
            final TransitionHandle th =
                getState().transition(Close5_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void CloseAckTimeout()
    {
        mTransition = "CloseAckTimeout";
        try
        {
            final TransitionHandle th =
                getState().transition(CloseAckTimeout20_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void CloseTimeout()
    {
        mTransition = "CloseTimeout";
        try
        {
            final TransitionHandle th =
                getState().transition(CloseTimeout22_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void ConnAckTimeout()
    {
        mTransition = "ConnAckTimeout";
        try
        {
            final TransitionHandle th =
                getState().transition(ConnAckTimeout14_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void FIN(TcpSegment segment)
    {
        mTransition = "FIN";
        try
        {
            final TransitionHandle th =
                getState().transition(FIN15_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void FIN_ACK(TcpSegment segment)
    {
        mTransition = "FIN_ACK";
        try
        {
            final TransitionHandle th =
                getState().transition(FIN_ACK21_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Open(InetSocketAddress address)
    {
        mTransition = "Open";
        try
        {
            final TransitionHandle th =
                getState().transition(Open2_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, address);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Open(int port)
    {
        mTransition = "Open";
        try
        {
            final TransitionHandle th =
                getState().transition(Open1_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, port);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Open(TcpSegment segment)
    {
        mTransition = "Open";
        try
        {
            final TransitionHandle th =
                getState().transition(Open3_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Open(InetAddress address, int port)
    {
        mTransition = "Open";
        try
        {
            final TransitionHandle th =
                getState().transition(Open23_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, address, port);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void OpenFailed(String reason)
    {
        mTransition = "OpenFailed";
        try
        {
            final TransitionHandle th =
                getState().transition(OpenFailed7_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, reason);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Opened(InetSocketAddress address)
    {
        mTransition = "Opened";
        try
        {
            final TransitionHandle th =
                getState().transition(Opened8_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, address);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void PSH(TcpSegment segment)
    {
        mTransition = "PSH";
        try
        {
            final TransitionHandle th =
                getState().transition(PSH16_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void PSH_ACK(TcpSegment segment)
    {
        mTransition = "PSH_ACK";
        try
        {
            final TransitionHandle th =
                getState().transition(PSH_ACK18_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void RST(TcpSegment segment)
    {
        mTransition = "RST";
        try
        {
            final TransitionHandle th =
                getState().transition(RST10_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void RST_ACK(TcpSegment segment)
    {
        mTransition = "RST_ACK";
        try
        {
            final TransitionHandle th =
                getState().transition(RST_ACK25_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void SYN(TcpSegment segment)
    {
        mTransition = "SYN";
        try
        {
            final TransitionHandle th =
                getState().transition(SYN9_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void SYN_ACK(TcpSegment segment)
    {
        mTransition = "SYN_ACK";
        try
        {
            final TransitionHandle th =
                getState().transition(SYN_ACK13_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void TransAckTimeout()
    {
        mTransition = "TransAckTimeout";
        try
        {
            final TransitionHandle th =
                getState().transition(TransAckTimeout19_TRANSITION_ID);

            (th.handle()).invokeExact(this);
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void Transmit(byte[] data, int offset, int size)
    {
        mTransition = "Transmit";
        try
        {
            final TransitionHandle th =
                getState().transition(Transmit17_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, data, offset, size);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void UNDEF(TcpSegment segment)
    {
        mTransition = "UNDEF";
        try
        {
            final TransitionHandle th =
                getState().transition(UNDEF4_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    public void URG(TcpSegment segment)
    {
        mTransition = "URG";
        try
        {
            final TransitionHandle th =
                getState().transition(URG24_TRANSITION_ID);

            if (th.isDefault())
            {
                (th.handle()).invokeExact(this);
            }
            else
            {
                (th.handle()).invokeExact(this, segment);
            }
        }
        catch (Throwable tex)
        {
            debugOutput(tex);

            if (RuntimeException.class.isInstance(tex))
            {
                throw ((RuntimeException) tex);
            }
        }
        mTransition = "";
    }

    //
    // end of Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.Default State Transitions.
    //

    private void MainMap_Default_Open(int port)
    {
        final int stateId = mState.getId();

        try
        {
            clearState();
            ctxt.openFailed("already open");
        }
        finally
        {
            setState(sStates[stateId]);
        }


    }


    private void MainMap_Default_Open(InetAddress address, int port)
    {
        final int stateId = mState.getId();

        try
        {
            clearState();
            ctxt.openFailed("already open");
        }
        finally
        {
            setState(sStates[stateId]);
        }


    }


    private void MainMap_Default_Transmit(byte[] data, int offset, int size)
    {
        final int stateId = mState.getId();

        try
        {
            clearState();
            ctxt.transmitFailed("connection not established");
        }
        finally
        {
            setState(sStates[stateId]);
        }


    }


    private void MainMap_Default_FIN(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_SYN(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_PSH(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_URG(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_FIN_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_SYN_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_PSH_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
    }


    private void MainMap_Default_UNDEF(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if (!(segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.RST, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("connection reset");
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
    }


    private void MainMap_Default_RST(TcpSegment segment)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.closed("connection reset by peer");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_Default_RST_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.closed("connection reset by peer");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_Default_ConnAckTimeout()
    {
        final int stateId = mState.getId();


    }


    private void MainMap_Default_TransAckTimeout()
    {
        final int stateId = mState.getId();


    }


    private void MainMap_Default_CloseAckTimeout()
    {
        final int stateId = mState.getId();


    }


    private void MainMap_Default_CloseTimeout()
    {
        final int stateId = mState.getId();


    }


    //
    // end of MainMap.Default State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.CLOSED State Transitions.
    //

    private void MainMap_CLOSED_Close()
    {
        final int stateId = mState.getId();


    }


    private void MainMap_CLOSED_Open(InetSocketAddress address)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.openClientSocket(address);
        }
        finally
        {
            setState(sStates[MainMap_ClientOpening_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_CLOSED_Open(int port)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.openServerSocket(port);
        }
        finally
        {
            setState(sStates[MainMap_ServiceOpening_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_CLOSED_Open(TcpSegment segment)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.sendAcceptSynAck(segment);
        }
        finally
        {
            setState(sStates[MainMap_SYN_RCVD_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_CLOSED_UNDEF(TcpSegment segment)
    {
        final int stateId = mState.getId();


    }


    //
    // end of MainMap.CLOSED State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.ServiceOpening State Transitions.
    //

    private void MainMap_ServiceOpening_Accepted()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.openSuccess();
        }
        finally
        {
            setState(sStates[MainMap_LISTEN_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_ServiceOpening_OpenFailed(String reason)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.openFailed(reason);
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    //
    // end of MainMap.ServiceOpening State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.ClientOpening State Transitions.
    //

    private void MainMap_ClientOpening_OpenFailed(String reason)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.openFailed(reason);
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_ClientOpening_Opened(InetSocketAddress address)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.send(TcpSegment.SYN, null, 0, 0, address, null);
        }
        finally
        {
            setState(sStates[MainMap_SYN_SENT_STATE_ID]);
        }

        enterState();

    }


    //
    // end of MainMap.ClientOpening State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.LISTEN State Transitions.
    //

    private void MainMap_LISTEN_Close()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.closed("");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_LISTEN_RST(TcpSegment segment)
    {
        final int stateId = mState.getId();


    }


    private void MainMap_LISTEN_SYN(TcpSegment segment)
    {
        final int stateId = mState.getId();

        try
        {
            clearState();
            ctxt.accept(segment);
        }
        finally
        {
            setState(sStates[stateId]);
        }


    }


    //
    // end of MainMap.LISTEN State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.SYN_RCVD State Entry/Exit Actions.
    //

    private void MainMap_SYN_RCVD__Entry_()
    {
        ctxt.startTimer("ACK_TIMER", TcpConnection.ACK_TIMEOUT);
    }

    private void MainMap_SYN_RCVD__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.SYN_RCVD State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.SYN_RCVD State Transitions.
    //

    private void MainMap_SYN_RCVD_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                clearState();
                ctxt.accepted();
            }
            finally
            {
                setState(sStates[MainMap_ESTABLISHED_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_ACK(segment);
        }

    }


    private void MainMap_SYN_RCVD_AckTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.openFailed("acknowledge timeout");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_SYN_RCVD_Close()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.send(TcpSegment.FIN, null, 0, 0, null, null);
        }
        finally
        {
            setState(sStates[MainMap_FIN_WAIT_1_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_SYN_RCVD_RST(TcpSegment segment)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.clearListener();
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    //
    // end of MainMap.SYN_RCVD State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.SYN_SENT State Entry/Exit Actions.
    //

    private void MainMap_SYN_SENT__Entry_()
    {
        ctxt.startTimer("CONN_ACK_TIMER", TcpConnection.ACK_TIMEOUT);
    }

    private void MainMap_SYN_SENT__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.SYN_SENT State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.SYN_SENT State Transitions.
    //

    private void MainMap_SYN_SENT_Close()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.closed("");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_SYN_SENT_ConnAckTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.openFailed("acknowledge timeout");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_SYN_SENT_SYN_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                clearState();
                ctxt.setDestinationPort(segment);
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
                ctxt.openSuccess();
            }
            finally
            {
                setState(sStates[MainMap_ESTABLISHED_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_SYN_ACK(segment);
        }

    }


    //
    // end of MainMap.SYN_SENT State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.ESTABLISHED State Transitions.
    //

    private void MainMap_ESTABLISHED_Close()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.send(TcpSegment.FIN, null, 0, 0, null, null);
        }
        finally
        {
            setState(sStates[MainMap_FIN_WAIT_1_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_ESTABLISHED_FIN(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
                ctxt.halfClosed();
            }
            finally
            {
                setState(sStates[MainMap_CLOSE_WAIT_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_FIN(segment);
        }

    }


    private void MainMap_ESTABLISHED_PSH(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            try
            {
                clearState();
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
                ctxt.receive(segment);
            }
            finally
            {
                setState(sStates[stateId]);
            }

        }
        else
        {
            MainMap_Default_PSH(segment);
        }

    }


    private void MainMap_ESTABLISHED_Transmit(byte[] data, int offset, int size)
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.send(TcpSegment.PSH, data, offset, size, null, null);
        }
        finally
        {
            setState(sStates[MainMap_Transmitting_STATE_ID]);
        }

        enterState();

    }


    //
    // end of MainMap.ESTABLISHED State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.Transmitting State Entry/Exit Actions.
    //

    private void MainMap_Transmitting__Entry_()
    {
        ctxt.startTimer("TRANS_ACK_TIMER", TcpConnection.ACK_TIMEOUT);
    }

    private void MainMap_Transmitting__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.Transmitting State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.Transmitting State Transitions.
    //

    private void MainMap_Transmitting_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                clearState();
                ctxt.transmitted();
            }
            finally
            {
                setState(sStates[MainMap_ESTABLISHED_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_ACK(segment);
        }

    }


    private void MainMap_Transmitting_Close()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.send(TcpSegment.FIN, null, 0, 0, null, null);
        }
        finally
        {
            setState(sStates[MainMap_FIN_WAIT_1_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_Transmitting_FIN(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
                ctxt.halfClosed();
            }
            finally
            {
                setState(sStates[MainMap_CLOSE_WAIT_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_FIN(segment);
        }

    }


    private void MainMap_Transmitting_PSH_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
                ctxt.transmitted();
                ctxt.receive(segment);
            }
            finally
            {
                setState(sStates[MainMap_ESTABLISHED_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_PSH_ACK(segment);
        }

    }


    private void MainMap_Transmitting_TransAckTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.transmitFailed("peer did not acknowledge");
            ctxt.closed("connection lost");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    //
    // end of MainMap.Transmitting State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.CLOSE_WAIT State Transitions.
    //

    private void MainMap_CLOSE_WAIT_Close()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.send(TcpSegment.FIN, null, 0, 0, null, null);
        }
        finally
        {
            setState(sStates[MainMap_LAST_ACK_STATE_ID]);
        }

        enterState();

    }


    //
    // end of MainMap.CLOSE_WAIT State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.LAST_ACK State Entry/Exit Actions.
    //

    private void MainMap_LAST_ACK__Entry_()
    {
        ctxt.startTimer("CLOSE_ACK_TIMER", TcpConnection.ACK_TIMEOUT);
    }

    private void MainMap_LAST_ACK__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.LAST_ACK State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.LAST_ACK State Transitions.
    //

    private void MainMap_LAST_ACK_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.FIN_ACK, null, 0, 0, segment);
                ctxt.closeSocket();
                ctxt.closed("");
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_ACK(segment);
        }

    }


    private void MainMap_LAST_ACK_CloseAckTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
            ctxt.closed("");
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    //
    // end of MainMap.LAST_ACK State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.FIN_WAIT_1 State Entry/Exit Actions.
    //

    private void MainMap_FIN_WAIT_1__Entry_()
    {
        ctxt.startTimer("CLOSE_ACK_TIMER", TcpConnection.ACK_TIMEOUT);
    }

    private void MainMap_FIN_WAIT_1__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.FIN_WAIT_1 State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.FIN_WAIT_1 State Transitions.
    //

    private void MainMap_FIN_WAIT_1_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(sStates[MainMap_FIN_WAIT_2_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_ACK(segment);
        }

    }


    private void MainMap_FIN_WAIT_1_CloseAckTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
        }
        finally
        {
            setState(sStates[MainMap_FIN_WAIT_2_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_FIN_WAIT_1_FIN(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
            }
            finally
            {
                setState(sStates[MainMap_CLOSING_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_FIN(segment);
        }

    }


    private void MainMap_FIN_WAIT_1_FIN_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
            }
            finally
            {
                setState(sStates[MainMap_TIME_WAIT_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_FIN_ACK(segment);
        }

    }


    //
    // end of MainMap.FIN_WAIT_1 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.FIN_WAIT_2 State Entry/Exit Actions.
    //

    private void MainMap_FIN_WAIT_2__Entry_()
    {
        ctxt.startTimer("CLOSE_ACK_TIMER", TcpConnection.ACK_TIMEOUT);
    }

    private void MainMap_FIN_WAIT_2__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.FIN_WAIT_2 State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.FIN_WAIT_2 State Transitions.
    //

    private void MainMap_FIN_WAIT_2_CloseAckTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_FIN_WAIT_2_FIN(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()))
        {
            exitState();

            try
            {
                clearState();
                ctxt.send(TcpSegment.ACK, null, 0, 0, segment);
            }
            finally
            {
                setState(sStates[MainMap_TIME_WAIT_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_FIN(segment);
        }

    }


    private void MainMap_FIN_WAIT_2_UNDEF(TcpSegment segment)
    {
        final int stateId = mState.getId();


    }


    //
    // end of MainMap.FIN_WAIT_2 State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.CLOSING State Entry/Exit Actions.
    //

    private void MainMap_CLOSING__Entry_()
    {
        ctxt.startTimer("CLOSE_ACK_TIMER", TcpConnection.ACK_TIMEOUT);
    }

    private void MainMap_CLOSING__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.CLOSING State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.CLOSING State Transitions.
    //

    private void MainMap_CLOSING_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                // No actions.
            }
            finally
            {
                setState(sStates[MainMap_TIME_WAIT_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_ACK(segment);
        }

    }


    private void MainMap_CLOSING_CloseAckTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
        }
        finally
        {
            setState(sStates[MainMap_TIME_WAIT_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_CLOSING_UNDEF(TcpSegment segment)
    {
        final int stateId = mState.getId();


    }


    //
    // end of MainMap.CLOSING State Transitions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.TIME_WAIT State Entry/Exit Actions.
    //

    private void MainMap_TIME_WAIT__Entry_()
    {
        ctxt.startTimer("CLOSE_TIMER", TcpConnection.CLOSE_TIMEOUT);
    }

    private void MainMap_TIME_WAIT__Exit_()
    {
        ctxt.stopTimer();
    }

    //
    // end of MainMap.TIME_WAIT State Entry/Exit Actions.
    //-----------------------------------------------------------

    //-----------------------------------------------------------
    // MainMap.TIME_WAIT State Transitions.
    //

    private void MainMap_TIME_WAIT_CloseTimeout()
    {
        final int stateId = mState.getId();

        exitState();

        try
        {
            clearState();
            ctxt.closeSocket();
        }
        finally
        {
            setState(sStates[MainMap_CLOSED_STATE_ID]);
        }

        enterState();

    }


    private void MainMap_TIME_WAIT_FIN_ACK(TcpSegment segment)
    {
        final int stateId = mState.getId();

        if ((segment.getSourceAddress()).equals(ctxt.getFarAddress()) &&
       segment.getAcknowledgeNumber() == ctxt.getSequenceNumber())
        {
            exitState();

            try
            {
                clearState();
                ctxt.closeSocket();
            }
            finally
            {
                setState(sStates[MainMap_CLOSED_STATE_ID]);
            }

            enterState();
        }
        else
        {
            MainMap_Default_FIN_ACK(segment);
        }

    }


    private void MainMap_TIME_WAIT_UNDEF(TcpSegment segment)
    {
        final int stateId = mState.getId();


    }


    //
    // end of MainMap.TIME_WAIT State Transitions.
    //-----------------------------------------------------------

//---------------------------------------------------------------
// Member data.
//

    transient private TcpConnection ctxt;

    //-----------------------------------------------------------
    // Constants.
    //

    private static final long serialVersionUID = 1L;

    public static final int MainMap_CLOSED_STATE_ID = 0;
    public static final int MainMap_ServiceOpening_STATE_ID = 1;
    public static final int MainMap_ClientOpening_STATE_ID = 2;
    public static final int MainMap_LISTEN_STATE_ID = 3;
    public static final int MainMap_SYN_RCVD_STATE_ID = 4;
    public static final int MainMap_SYN_SENT_STATE_ID = 5;
    public static final int MainMap_ESTABLISHED_STATE_ID = 6;
    public static final int MainMap_Transmitting_STATE_ID = 7;
    public static final int MainMap_CLOSE_WAIT_STATE_ID = 8;
    public static final int MainMap_LAST_ACK_STATE_ID = 9;
    public static final int MainMap_FIN_WAIT_1_STATE_ID = 10;
    public static final int MainMap_FIN_WAIT_2_STATE_ID = 11;
    public static final int MainMap_CLOSING_STATE_ID = 12;
    public static final int MainMap_TIME_WAIT_STATE_ID = 13;

    private static final int STATE_COUNT = 14;

    private static final int ACK11_TRANSITION_ID = 1;
    private static final int Accepted6_TRANSITION_ID = 2;
    private static final int AckTimeout12_TRANSITION_ID = 3;
    private static final int Close5_TRANSITION_ID = 4;
    private static final int CloseAckTimeout20_TRANSITION_ID = 5;
    private static final int CloseTimeout22_TRANSITION_ID = 6;
    private static final int ConnAckTimeout14_TRANSITION_ID = 7;
    private static final int FIN15_TRANSITION_ID = 8;
    private static final int FIN_ACK21_TRANSITION_ID = 9;
    private static final int Open2_TRANSITION_ID = 10;
    private static final int Open1_TRANSITION_ID = 11;
    private static final int Open3_TRANSITION_ID = 12;
    private static final int Open23_TRANSITION_ID = 13;
    private static final int OpenFailed7_TRANSITION_ID = 14;
    private static final int Opened8_TRANSITION_ID = 15;
    private static final int PSH16_TRANSITION_ID = 16;
    private static final int PSH_ACK18_TRANSITION_ID = 17;
    private static final int RST10_TRANSITION_ID = 18;
    private static final int RST_ACK25_TRANSITION_ID = 19;
    private static final int SYN9_TRANSITION_ID = 20;
    private static final int SYN_ACK13_TRANSITION_ID = 21;
    private static final int TransAckTimeout19_TRANSITION_ID = 22;
    private static final int Transmit17_TRANSITION_ID = 23;
    private static final int UNDEF4_TRANSITION_ID = 24;
    private static final int URG24_TRANSITION_ID = 25;

    private static final int TRANSITION_COUNT = 26;

    private static final MethodType[] TRANSITION_TYPES =
    {
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, TcpSegment.class),
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, InetSocketAddress.class),
        MethodType.methodType(void.class, int.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, InetAddress.class, int.class),
        MethodType.methodType(void.class, String.class),
        MethodType.methodType(void.class, InetSocketAddress.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, TcpSegment.class),
        NO_ARGS_TYPE,
        MethodType.methodType(void.class, byte[].class, int.class, int.class),
        MethodType.methodType(void.class, TcpSegment.class),
        MethodType.methodType(void.class, TcpSegment.class)
    };

    private static final String[] MAP_NAMES =
    {
        "MainMap"
    };

    private static final String[][] STATE_NAMES =
    {
        new String[]
        {
            "CLOSED",
            "ServiceOpening",
            "ClientOpening",
            "LISTEN",
            "SYN_RCVD",
            "SYN_SENT",
            "ESTABLISHED",
            "Transmitting",
            "CLOSE_WAIT",
            "LAST_ACK",
            "FIN_WAIT_1",
            "FIN_WAIT_2",
            "CLOSING",
            "TIME_WAIT"
        }
    };

    private static String[][] STATE_TRANSITIONS =
    {
        new String[]
        {
            "Close",
            "Open",
            "Open",
            "Open",
            "UNDEF"
        },

        new String[]
        {
            "Accepted",
            "OpenFailed"
        },

        new String[]
        {
            "OpenFailed",
            "Opened"
        },

        new String[]
        {
            "Close",
            "RST",
            "SYN"
        },

        new String[]
        {
            "ACK",
            "AckTimeout",
            "Close",
            "RST"
        },

        new String[]
        {
            "Close",
            "ConnAckTimeout",
            "SYN_ACK"
        },

        new String[]
        {
            "Close",
            "FIN",
            "PSH",
            "Transmit"
        },

        new String[]
        {
            "ACK",
            "Close",
            "FIN",
            "PSH_ACK",
            "TransAckTimeout"
        },

        new String[]
        {
            "Close"
        },

        new String[]
        {
            "ACK",
            "CloseAckTimeout"
        },

        new String[]
        {
            "ACK",
            "CloseAckTimeout",
            "FIN",
            "FIN_ACK"
        },

        new String[]
        {
            "CloseAckTimeout",
            "FIN",
            "UNDEF"
        },

        new String[]
        {
            "ACK",
            "CloseAckTimeout",
            "UNDEF"
        },

        new String[]
        {
            "CloseTimeout",
            "FIN_ACK",
            "UNDEF"
        }
    };

    private static final String[] TRANSITION_NAMES =
    {
        "Default",
        "ACK",
        "Accepted",
        "AckTimeout",
        "Close",
        "CloseAckTimeout",
        "CloseTimeout",
        "ConnAckTimeout",
        "FIN",
        "FIN_ACK",
        "Open",
        "Open",
        "Open",
        "Open",
        "OpenFailed",
        "Opened",
        "PSH",
        "PSH_ACK",
        "RST",
        "RST_ACK",
        "SYN",
        "SYN_ACK",
        "TransAckTimeout",
        "Transmit",
        "UNDEF",
        "URG"
    };

    private static final State7[] sStates = new State7[STATE_COUNT];

    static
    {
        final Lookup lookup = MethodHandles.lookup();
        final Class<?> clazz = TcpConnectionContext.class;
        final int mapSize = MAP_NAMES.length;
        int stateSize;
        int mapIndex;
        int stateIndex;
        int transIndex;
        int stateId = 0;
        String mapName;
        String stateName;
        String transName;
        String methodName;
        MethodType transType;
        MethodHandle entryHandle;
        MethodHandle exitHandle;
        TransitionHandle[] transitions;

        for (mapIndex = 0; mapIndex < mapSize; ++mapIndex)
        {
            mapName = MAP_NAMES[mapIndex];
            stateSize = STATE_NAMES[mapIndex].length;

            for (stateIndex = 0; stateIndex < stateSize; ++stateIndex, ++stateId)
            {
                stateName = STATE_NAMES[mapIndex][stateIndex];
                transitions = new TransitionHandle[TRANSITION_COUNT];

                methodName = String.format(ENTRY_NAME, mapName, stateName);
                entryHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);
                methodName = String.format(EXIT_NAME, mapName, stateName);
                exitHandle = lookupMethod(lookup, clazz, methodName, NO_ARGS_TYPE);

                for (transIndex = 1; transIndex < TRANSITION_COUNT; ++transIndex)
                {
                    transName = TRANSITION_NAMES[transIndex];
                    transType = TRANSITION_TYPES[transIndex];
                    transitions[transIndex] =
                        lookupTransition(lookup, clazz, mapName, stateName, transName, transType);
                }

                sStates[stateId] =
                    new State7(
                        String.format(STATE_NAME_FORMAT, mapName, stateName),
                        stateId,
                        entryHandle,
                        exitHandle,
                        transitions,
                        STATE_TRANSITIONS[stateId]);
            }
        }
    }
}

/*
 * Local variables:
 *  buffer-read-only: t
 * End:
 */
