/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.batch;

import de.lessvoid.nifty.batch.BatchRenderFont;
import de.lessvoid.nifty.batch.BatchRenderImage;
import de.lessvoid.nifty.batch.TextureAtlasGenerator;
import de.lessvoid.nifty.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.ColorValueParser;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jglfont.BitmapFontFactory;
import org.jglfont.spi.BitmapFontRenderer;

public class BatchRenderDevice
implements RenderDevice {
    private static Logger log = Logger.getLogger(BatchRenderDevice.class.getName());
    private NiftyResourceLoader resourceLoader;
    private int viewportWidth = -1;
    private int viewportHeight = -1;
    private long time;
    private long frames;
    private long lastFrames;
    private int glyphCount;
    private int quadCount;
    private boolean displayFPS = false;
    private boolean logFPS = false;
    private RenderFont fpsFont;
    private BlendMode currentBlendMode = null;
    private boolean currentClipping = false;
    private int currentClippingX0 = 0;
    private int currentClippingY0 = 0;
    private int currentClippingX1 = 0;
    private int currentClippingY1 = 0;
    private StringBuilder buffer = new StringBuilder();
    private int completeClippedCounter;
    private final BitmapFontFactory factory;
    private final BatchRenderBackend renderBackend;
    private TextureAtlasGenerator generator;
    private Color fontColor = new Color("#f00");
    private boolean activeBatch;
    private BatchRenderImage thePlainImage;
    private final int atlasWidth;
    private final int atlasHeight;
    private final Set<BatchRenderFont> fontCache = new HashSet<BatchRenderFont>();
    private final FontRenderer fontRenderer;

    public BatchRenderDevice(BatchRenderBackend renderBackend, int atlasWidth, int atlasHeight) {
        this.renderBackend = renderBackend;
        this.atlasWidth = atlasWidth;
        this.atlasHeight = atlasHeight;
        this.time = System.currentTimeMillis();
        this.frames = 0L;
        this.generator = new TextureAtlasGenerator(atlasWidth, atlasHeight);
        this.fontRenderer = new FontRenderer(this);
        this.factory = new BitmapFontFactory((BitmapFontRenderer)this.fontRenderer);
        renderBackend.createAtlasTexture(atlasWidth, atlasHeight);
    }

    public void enableLogFPS() {
        this.logFPS = true;
    }

    @Override
    public void setResourceLoader(NiftyResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        if (this.displayFPS) {
            this.fpsFont = this.createFont("fps.fnt");
        }
        this.renderBackend.setResourceLoader(resourceLoader);
    }

    @Override
    public int getWidth() {
        if (this.viewportWidth == -1) {
            this.getViewport();
        }
        return this.viewportWidth;
    }

    @Override
    public int getHeight() {
        if (this.viewportHeight == -1) {
            this.getViewport();
        }
        return this.viewportHeight;
    }

    private void getViewport() {
        this.viewportWidth = this.renderBackend.getWidth();
        this.viewportHeight = this.renderBackend.getHeight();
    }

    @Override
    public void beginFrame() {
        log.finest("beginFrame()");
        this.currentBlendMode = BlendMode.BLEND;
        this.currentClipping = false;
        this.currentClippingX0 = 0;
        this.currentClippingY0 = 0;
        this.currentClippingX1 = this.getWidth();
        this.currentClippingY1 = this.getHeight();
        this.completeClippedCounter = 0;
        this.renderBackend.beginFrame();
        this.activeBatch = false;
        this.quadCount = 0;
        this.glyphCount = 0;
    }

    @Override
    public void endFrame() {
        log.finest("endFrame");
        log.fine("completely clipped elements: " + this.completeClippedCounter);
        if (this.displayFPS) {
            this.renderFont(this.fpsFont, this.buffer.toString(), 10, this.getHeight() - this.fpsFont.getHeight() - 10, this.fontColor, 1.0f, 1.0f);
        }
        int batches = this.renderBackend.render();
        ++this.frames;
        long diff = System.currentTimeMillis() - this.time;
        if (diff >= 1000L) {
            this.time += diff;
            this.lastFrames = this.frames;
            this.buffer.setLength(0);
            this.buffer.append("FPS: ");
            this.buffer.append(this.lastFrames);
            this.buffer.append(" (");
            this.buffer.append(String.format("%f", Float.valueOf(1000.0f / (float)this.lastFrames)));
            this.buffer.append(" ms)");
            this.buffer.append(", Total Tri: ");
            this.buffer.append(this.quadCount * 2);
            this.buffer.append(" (Text: ");
            this.buffer.append(this.glyphCount * 2);
            this.buffer.append(")");
            this.buffer.append(", Total Vert: ");
            this.buffer.append(this.quadCount * 4);
            this.buffer.append(" (Text: ");
            this.buffer.append(this.glyphCount * 4);
            this.buffer.append("), Batches: ");
            this.buffer.append(batches);
            if (this.logFPS) {
                System.out.println(this.buffer.toString());
            }
            this.frames = 0L;
        }
        this.viewportWidth = -1;
        this.viewportHeight = -1;
    }

    @Override
    public void clear() {
        log.finest("clear()");
        this.renderBackend.clear();
    }

    @Override
    public RenderImage createImage(String filename, boolean filterLinear) {
        BatchRenderBackend.Image image = this.renderBackend.loadImage(filename);
        return new BatchRenderImage(image, this.generator, filename, this.renderBackend);
    }

    @Override
    public RenderFont createFont(String filename) {
        try {
            BatchRenderFont batchRenderFont = new BatchRenderFont(this, filename, this.factory, this.resourceLoader);
            this.fontCache.add(batchRenderFont);
            return batchRenderFont;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void disposeFont(BatchRenderFont batchRenderFont) {
        this.fontCache.remove(batchRenderFont);
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, Color color) {
        log.finest("renderQuad()");
        BatchRenderImage plainImage = this.getPlainImage();
        this.addQuad(x, y, width, height, color, color, color, color, plainImage.getX(), plainImage.getY(), plainImage.getWidth(), plainImage.getHeight());
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, Color topLeft, Color topRight, Color bottomRight, Color bottomLeft) {
        log.finest("renderQuad2()");
        BatchRenderImage plainImage = this.getPlainImage();
        this.addQuad(x, y, width, height, topLeft, topRight, bottomLeft, bottomRight, plainImage.getX(), plainImage.getY(), plainImage.getWidth(), plainImage.getHeight());
    }

    @Override
    public void renderImage(RenderImage image, int x, int y, int width, int height, Color c, float scale) {
        log.finest("renderImage()");
        if (width < 0) {
            log.warning("Attempt to render image with negative width");
            return;
        }
        if (height < 0) {
            log.warning("Attempt to render image with negative height");
            return;
        }
        BatchRenderImage img = (BatchRenderImage)image;
        if (!img.isUploaded()) {
            img.upload();
        }
        float centerX = (float)x + (float)width / 2.0f;
        float centerY = (float)y + (float)height / 2.0f;
        int ix = Math.round(centerX - (float)width * scale / 2.0f);
        int iy = Math.round(centerY - (float)height * scale / 2.0f);
        int iw = Math.round((float)width * scale);
        int ih = Math.round((float)height * scale);
        this.addQuad(ix, iy, iw, ih, c, c, c, c, img.getX(), img.getY(), img.getWidth(), img.getHeight());
    }

    @Override
    public void renderImage(RenderImage image, int x, int y, int w, int h, int srcX, int srcY, int srcW, int srcH, Color c, float scale, int centerX, int centerY) {
        log.finest("renderImage2()");
        if (w < 0) {
            log.warning("Attempt to render image with negative width");
            return;
        }
        if (h < 0) {
            log.warning("Attempt to render image with negative height");
            return;
        }
        int ix = Math.round(-scale * (float)centerX + scale * (float)x + (float)centerX);
        int iy = Math.round(-scale * (float)centerY + scale * (float)y + (float)centerY);
        int iw = Math.round((float)w * scale);
        int ih = Math.round((float)h * scale);
        BatchRenderImage img = (BatchRenderImage)image;
        if (!img.isUploaded()) {
            img.upload();
        }
        this.addQuad(ix, iy, iw, ih, c, c, c, c, img.getX() + srcX, img.getY() + srcY, srcW, srcH);
    }

    @Override
    public void renderFont(RenderFont font, String text, int x, int y, Color color, float sizeX, float sizeY) {
        log.finest("renderFont()");
        BatchRenderFont renderFont = (BatchRenderFont)font;
        renderFont.getBitmapFont().renderText(x, y, text, sizeX, sizeY, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @Override
    public void enableClip(int x0, int y0, int x1, int y1) {
        log.finest("enableClip()");
        if (this.currentClipping && this.currentClippingX0 == x0 && this.currentClippingY0 == y0 && this.currentClippingX1 == x1 && this.currentClippingY1 == y1) {
            return;
        }
        this.currentClipping = true;
        this.currentClippingX0 = x0;
        this.currentClippingY0 = y0;
        this.currentClippingX1 = x1;
        this.currentClippingY1 = y1;
    }

    @Override
    public void disableClip() {
        log.finest("disableClip()");
        if (!this.currentClipping) {
            return;
        }
        this.currentClipping = false;
        this.currentClippingX0 = 0;
        this.currentClippingY0 = 0;
        this.currentClippingX1 = this.getWidth();
        this.currentClippingY1 = this.getHeight();
    }

    @Override
    public void setBlendMode(BlendMode renderMode) {
        log.finest("setBlendMode()");
        if (renderMode.equals((Object)this.currentBlendMode)) {
            return;
        }
        this.currentBlendMode = renderMode;
        this.addNewBatch();
    }

    @Override
    public MouseCursor createMouseCursor(String filename, int hotspotX, int hotspotY) throws IOException {
        return this.renderBackend.createMouseCursor(filename, hotspotX, hotspotY);
    }

    @Override
    public void enableMouseCursor(MouseCursor mouseCursor) {
        this.renderBackend.enableMouseCursor(mouseCursor);
    }

    @Override
    public void disableMouseCursor() {
        this.renderBackend.disableMouseCursor();
    }

    public void resetTextureAtlas() {
        this.thePlainImage.unload();
        this.generator.reset();
        this.renderBackend.clearAtlasTexture(this.atlasWidth, this.atlasHeight);
        this.fontRenderer.unload();
    }

    private BatchRenderImage getPlainImage() {
        if (this.thePlainImage == null) {
            this.thePlainImage = (BatchRenderImage)this.createImage("de/lessvoid/nifty/batch/nifty.png", true);
        }
        if (!this.thePlainImage.isUploaded()) {
            this.thePlainImage.upload();
        }
        return this.thePlainImage;
    }

    private void addNewBatch() {
        this.renderBackend.beginBatch(this.currentBlendMode);
    }

    private void addQuad(float x, float y, float width, float height, Color color1, Color color2, Color color3, Color color4, int textureX, int textureY, int textureWidth, int textureHeight) {
        float newHeight;
        float newWidth;
        float newY;
        float newX;
        if (this.isOutsideClippingRectangle(x, y, width, height)) {
            ++this.completeClippedCounter;
            return;
        }
        if (this.isInsideClippingRectangle(x, y, width, height)) {
            this.addQuadInternal(x, y, width, height, color1, color2, color3, color4, textureX, textureY, textureWidth, textureHeight);
            return;
        }
        int newTextureX = textureX;
        int newTextureY = textureY;
        int newTextureWidth = textureWidth;
        int newTextureHeight = textureHeight;
        if (x >= (float)this.currentClippingX0) {
            newX = x;
            newTextureX = textureX;
        } else {
            newX = this.currentClippingX0;
            newTextureX = (int)((float)textureX + ((float)this.currentClippingX0 - x) / width * (float)textureWidth);
        }
        if (y >= (float)this.currentClippingY0) {
            newY = y;
            newTextureY = textureY;
        } else {
            newY = this.currentClippingY0;
            newTextureY = (int)((float)textureY + ((float)this.currentClippingY0 - y) / height * (float)textureHeight);
        }
        if (x + width <= (float)this.currentClippingX1) {
            newWidth = x + width - newX;
            newTextureWidth = textureX + textureWidth - newTextureX;
        } else {
            newWidth = (float)this.currentClippingX1 - newX;
            newTextureWidth = (int)(newWidth / width * (float)textureWidth);
        }
        if (y + height <= (float)this.currentClippingY1) {
            newHeight = y + height - newY;
            newTextureHeight = textureY + textureHeight - newTextureY;
        } else {
            newHeight = (float)this.currentClippingY1 - newY;
            newTextureHeight = (int)(newHeight / height * (float)textureHeight);
        }
        this.addQuadInternal(newX, newY, newWidth, newHeight, color1, color2, color3, color4, newTextureX, newTextureY, newTextureWidth, newTextureHeight);
    }

    private void addQuadInternal(float x, float y, float width, float height, Color color1, Color color2, Color color3, Color color4, int textureX, int textureY, int textureWidth, int textureHeight) {
        if (!this.activeBatch) {
            this.renderBackend.beginBatch(this.currentBlendMode);
            this.activeBatch = true;
        }
        this.renderBackend.addQuad(x, y, width, height, color1, color2, color3, color4, this.calcU(textureX, this.atlasWidth), this.calcU(textureY, this.atlasHeight), this.calcU(textureWidth - 1, this.atlasWidth), this.calcU(textureHeight - 1, this.atlasHeight));
        ++this.quadCount;
    }

    private float calcU(int value, int max) {
        return 0.5f / (float)max + (float)value / (float)max;
    }

    private boolean isOutsideClippingRectangle(float x, float y, float width, float height) {
        if (x > (float)this.currentClippingX1) {
            return true;
        }
        if (x + width < (float)this.currentClippingX0) {
            return true;
        }
        if (y > (float)this.currentClippingY1) {
            return true;
        }
        return y + height < (float)this.currentClippingY0;
    }

    private boolean isInsideClippingRectangle(float x, float y, float width, float height) {
        return x >= (float)this.currentClippingX0 && x <= (float)this.currentClippingX1 && x + width >= (float)this.currentClippingX0 && x + width <= (float)this.currentClippingX1 && y >= (float)this.currentClippingY0 && y <= (float)this.currentClippingY1 && y + height >= (float)this.currentClippingY0 && y + height <= (float)this.currentClippingY1;
    }

    private static class BitmapInfo {
        private final BatchRenderImage image;
        private final Map<Character, CharRenderInfo> characterIndices = new Hashtable<Character, CharRenderInfo>();
        private TextureAtlasGenerator.Result result;

        public BitmapInfo(BatchRenderImage image) {
            this.image = image;
        }

        private void upload() {
            if (this.image.isUploaded()) {
                return;
            }
            this.image.upload();
            this.result = new TextureAtlasGenerator.Result(this.image.getX(), this.image.getY(), this.image.getWidth(), this.image.getHeight());
        }

        private void unload() {
            this.image.markAsUnloaded();
        }

        public void renderCharacter(char c, int x, int y, float sx, float sy, Color textColor) {
            int atlasX0 = this.result.getX();
            int atlasY0 = this.result.getY();
            int atlasImageW = this.result.getOriginalImageWidth();
            int atlasImageH = this.result.getOriginalImageHeight();
            this.characterIndices.get(Character.valueOf(c)).renderQuad(x, y, sx, sy, textColor, atlasX0, atlasY0, atlasImageW, atlasImageH);
        }

        public void addCharRenderInfo(Character c, CharRenderInfo renderInfo) {
            this.characterIndices.put(c, renderInfo);
        }
    }

    private class CharRenderInfo {
        final int xoff;
        final int yoff;
        final int w;
        final int h;
        final float u0;
        final float v0;

        public CharRenderInfo(int xoff, int yoff, int w, int h, float u0, float v0) {
            this.xoff = xoff;
            this.yoff = yoff;
            this.w = w;
            this.h = h;
            this.u0 = u0;
            this.v0 = v0;
        }

        public void renderQuad(int x, int y, float sx, float sy, Color textColor, int atlasX0, int atlasY0, int atlasImageW, int atlasImageH) {
            BatchRenderDevice.this.glyphCount++;
            BatchRenderDevice.this.addQuad((float)x + (float)Math.floor((float)this.xoff * sx), (float)y + (float)Math.floor((float)this.yoff * sy), (float)this.w * sx, (float)this.h * sy, textColor, textColor, textColor, textColor, (int)((float)atlasX0 + this.u0 * (float)atlasImageW), (int)((float)atlasY0 + this.v0 * (float)atlasImageH), this.w, this.h);
        }
    }

    private class FontRenderer
    implements BitmapFontRenderer {
        private final Map<String, BitmapInfo> textureInfos = new HashMap<String, BitmapInfo>();
        private final ColorValueParser colorValueParser = new ColorValueParser();
        private BatchRenderDevice batchRenderDevice;
        private final Color textColor = Color.BLACK;
        private boolean hasColor;

        public FontRenderer(BatchRenderDevice batchRenderDevice2) {
            this.batchRenderDevice = batchRenderDevice2;
        }

        public void unload() {
            for (BitmapInfo info : this.textureInfos.values()) {
                info.unload();
            }
        }

        public void registerBitmap(String bitmapId, InputStream data, String filename) throws IOException {
            this.textureInfos.put(bitmapId, new BitmapInfo((BatchRenderImage)this.batchRenderDevice.createImage(filename, true)));
        }

        public void registerGlyph(String bitmapId, char c, int xoff, int yoff, int w, int h, float u0, float v0, float u1, float v1) {
            BitmapInfo textureInfo = this.textureInfos.get(bitmapId);
            textureInfo.addCharRenderInfo(Character.valueOf(c), new CharRenderInfo(xoff, yoff, w, h, u0, v0));
        }

        public void prepare() {
        }

        public void beforeRender() {
            for (BitmapInfo info : this.textureInfos.values()) {
                info.upload();
            }
        }

        public int preProcess(String text, int offset) {
            this.hasColor = false;
            int index = offset;
            this.colorValueParser.isColor(text, index);
            while (this.colorValueParser.isColor()) {
                this.textColor.setRed(this.colorValueParser.getColor().getRed());
                this.textColor.setGreen(this.colorValueParser.getColor().getGreen());
                this.textColor.setBlue(this.colorValueParser.getColor().getBlue());
                this.textColor.setAlpha(this.colorValueParser.getColor().getAlpha());
                this.hasColor = true;
                index = this.colorValueParser.getNextIndex();
                if (index >= text.length()) {
                    return index;
                }
                this.colorValueParser.isColor(text, index);
            }
            return index;
        }

        public void render(String bitmapId, int x, int y, char c, float sx, float sy, float r, float g, float b, float a) {
            if (!this.hasColor) {
                this.textColor.setRed(r);
                this.textColor.setGreen(g);
                this.textColor.setBlue(b);
                this.textColor.setAlpha(a);
            }
            this.textureInfos.get(bitmapId).renderCharacter(c, x, y, sx, sy, this.textColor);
        }

        public void afterRender() {
        }
    }
}

