/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.batch;

import de.lessvoid.nifty.batch.BatchRenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import org.jglfont.BitmapFont;
import org.jglfont.BitmapFontFactory;

public class BatchRenderFont
implements RenderFont {
    private final BatchRenderDevice batchRenderDevice;
    private final BitmapFont font;

    public BatchRenderFont(BatchRenderDevice batchRenderDevice, String name, BitmapFontFactory factory, NiftyResourceLoader resourceLoader) throws IOException {
        this.batchRenderDevice = batchRenderDevice;
        this.font = factory.loadFont(resourceLoader.getResourceAsStream(name), name);
    }

    @Override
    public int getHeight() {
        return this.font.getHeight();
    }

    @Override
    public int getWidth(String text) {
        return this.font.getStringWidth(text);
    }

    @Override
    public int getWidth(String text, float size) {
        return this.font.getStringWidth(text, size);
    }

    @Override
    public int getCharacterAdvance(char currentCharacter, char nextCharacter, float size) {
        return this.font.getCharacterWidth(currentCharacter, nextCharacter, size);
    }

    @Override
    public void dispose() {
        this.batchRenderDevice.disposeFont(this);
    }

    public BitmapFont getBitmapFont() {
        return this.font;
    }
}

