/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.sound.SoundHandle;

public class PlaySound
implements EffectImpl {
    private boolean done;
    private boolean repeat;
    private SoundHandle soundHandle;
    private Nifty nifty;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.nifty = nifty;
        this.soundHandle = nifty.getSoundSystem().getSound(parameter.getProperty("sound"));
        this.repeat = Boolean.valueOf(parameter.getProperty("repeat", "false"));
        this.done = false;
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        if (normalizedTime > 0.0f && this.soundHandle != null) {
            if (!this.done) {
                this.playSound();
                this.done = true;
            } else if (this.repeat && !this.soundHandle.isPlaying()) {
                this.playSound();
            }
        }
    }

    private void playSound() {
        this.soundHandle.setVolume(this.nifty.getSoundSystem().getSoundVolume());
        this.soundHandle.play();
    }

    @Override
    public void deactivate() {
    }
}

