

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 

package ingenias.editor;

import ingenias.editor.actions.*;
import ingenias.editor.actions.diagram.*;
import ingenias.editor.entities.*;
import ingenias.editor.events.DiagramChangeHandler;
import ingenias.editor.events.DiagramCreationAction;
import ingenias.editor.*;
import ingenias.editor.models.*;
import ingenias.editor.widget.GraphicsUtils;
import ingenias.editor.editionmode.EmbeddedAndPopupCellEditor;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import org.jgraph.graph.BasicMarqueeHandler;

public class ProjectMenuCreator {
	private IDEState ids=null;	
	private Frame owner=null;
	private GUIResources resources=null; 

	public ProjectMenuCreator(IDEState ids, 			
			Frame owner, GUIResources resources
	){
		this.ids=ids;  		
		this.owner=owner;
		this.resources=resources;
	}

  public Vector<DiagramCreationAction> getDiagramCreation(){
   
   Vector<DiagramCreationAction> actions=new Vector<DiagramCreationAction>();
   DiagramCreationAction ma=null;
   
    if (ids.getDiagramFilter().isValidDiagram("FilterDiagram")){
   // Menu to add a FilterDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add FilterDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				FilterDiagramModelJGraph mjg =
					new FilterDiagramModelJGraph(new
							FilterDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				FilterDiagramActionsFactory ema=new  FilterDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mFilterDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("GenericDiseaseSpecDiag")){
   // Menu to add a GenericDiseaseSpecDiag model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add GenericDiseaseSpecDiag";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				GenericDiseaseSpecDiagModelJGraph mjg =
					new GenericDiseaseSpecDiagModelJGraph(new
							GenericDiseaseSpecDiagDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				GenericDiseaseSpecDiagActionsFactory ema=new  GenericDiseaseSpecDiagActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mGenericDiseaseSpecDiag.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("BuildingDiagram")){
   // Menu to add a BuildingDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add BuildingDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				BuildingDiagramModelJGraph mjg =
					new BuildingDiagramModelJGraph(new
							BuildingDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				BuildingDiagramActionsFactory ema=new  BuildingDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mBuildingDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("ActivityDiagram")){
   // Menu to add a ActivityDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add ActivityDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				ActivityDiagramModelJGraph mjg =
					new ActivityDiagramModelJGraph(new
							ActivityDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				ActivityDiagramActionsFactory ema=new  ActivityDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mActivityDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("ADLSpecDiagram")){
   // Menu to add a ADLSpecDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add ADLSpecDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				ADLSpecDiagramModelJGraph mjg =
					new ADLSpecDiagramModelJGraph(new
							ADLSpecDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				ADLSpecDiagramActionsFactory ema=new  ADLSpecDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mADLSpecDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("DeviceBehavoirDiagram")){
   // Menu to add a DeviceBehavoirDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add DeviceBehavoirDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				DeviceBehavoirDiagramModelJGraph mjg =
					new DeviceBehavoirDiagramModelJGraph(new
							DeviceBehavoirDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				DeviceBehavoirDiagramActionsFactory ema=new  DeviceBehavoirDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mDeviceBehavoirDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("InteractionDiagram")){
   // Menu to add a InteractionDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add InteractionDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				InteractionDiagramModelJGraph mjg =
					new InteractionDiagramModelJGraph(new
							InteractionDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				InteractionDiagramActionsFactory ema=new  InteractionDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mInteractionDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("SimulationDiagram")){
   // Menu to add a SimulationDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add SimulationDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				SimulationDiagramModelJGraph mjg =
					new SimulationDiagramModelJGraph(new
							SimulationDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				SimulationDiagramActionsFactory ema=new  SimulationDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mSimulationDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("SymptomEvolutionDiagram")){
   // Menu to add a SymptomEvolutionDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add SymptomEvolutionDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				SymptomEvolutionDiagramModelJGraph mjg =
					new SymptomEvolutionDiagramModelJGraph(new
							SymptomEvolutionDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				SymptomEvolutionDiagramActionsFactory ema=new  SymptomEvolutionDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mSymptomEvolutionDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("FloorSpecDiagram")){
   // Menu to add a FloorSpecDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add FloorSpecDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				FloorSpecDiagramModelJGraph mjg =
					new FloorSpecDiagramModelJGraph(new
							FloorSpecDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				FloorSpecDiagramActionsFactory ema=new  FloorSpecDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mFloorSpecDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("DeviceDiagram")){
   // Menu to add a DeviceDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add DeviceDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				DeviceDiagramModelJGraph mjg =
					new DeviceDiagramModelJGraph(new
							DeviceDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				DeviceDiagramActionsFactory ema=new  DeviceDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mDeviceDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("SocialSpecDiagram")){
   // Menu to add a SocialSpecDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add SocialSpecDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				SocialSpecDiagramModelJGraph mjg =
					new SocialSpecDiagramModelJGraph(new
							SocialSpecDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				SocialSpecDiagramActionsFactory ema=new  SocialSpecDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mSocialSpecDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("RandomTaskDiagram")){
   // Menu to add a RandomTaskDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add RandomTaskDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				RandomTaskDiagramModelJGraph mjg =
					new RandomTaskDiagramModelJGraph(new
							RandomTaskDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				RandomTaskDiagramActionsFactory ema=new  RandomTaskDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mRandomTaskDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("ParkinsonSpecDiagram")){
   // Menu to add a ParkinsonSpecDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add ParkinsonSpecDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				ParkinsonSpecDiagramModelJGraph mjg =
					new ParkinsonSpecDiagramModelJGraph(new
							ParkinsonSpecDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				ParkinsonSpecDiagramActionsFactory ema=new  ParkinsonSpecDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mParkinsonSpecDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("ArithmeticDiagram1")){
   // Menu to add a ArithmeticDiagram1 model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add ArithmeticDiagram1";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				ArithmeticDiagram1ModelJGraph mjg =
					new ArithmeticDiagram1ModelJGraph(new
							ArithmeticDiagram1DataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				ArithmeticDiagram1ActionsFactory ema=new  ArithmeticDiagram1ActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mArithmeticDiagram1.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("HumanProfileSpecDiagram")){
   // Menu to add a HumanProfileSpecDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add HumanProfileSpecDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				HumanProfileSpecDiagramModelJGraph mjg =
					new HumanProfileSpecDiagramModelJGraph(new
							HumanProfileSpecDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				HumanProfileSpecDiagramActionsFactory ema=new  HumanProfileSpecDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mHumanProfileSpecDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("MedicationTimeDiagram")){
   // Menu to add a MedicationTimeDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add MedicationTimeDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				MedicationTimeDiagramModelJGraph mjg =
					new MedicationTimeDiagramModelJGraph(new
							MedicationTimeDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				MedicationTimeDiagramActionsFactory ema=new  MedicationTimeDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mMedicationTimeDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("RoomSpecDiagram")){
   // Menu to add a RoomSpecDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add RoomSpecDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				RoomSpecDiagramModelJGraph mjg =
					new RoomSpecDiagramModelJGraph(new
							RoomSpecDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				RoomSpecDiagramActionsFactory ema=new  RoomSpecDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mRoomSpecDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("SequentialTaskDiagram")){
   // Menu to add a SequentialTaskDiagram model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add SequentialTaskDiagram";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				SequentialTaskDiagramModelJGraph mjg =
					new SequentialTaskDiagramModelJGraph(new
							SequentialTaskDiagramDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				SequentialTaskDiagramActionsFactory ema=new  SequentialTaskDiagramActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mSequentialTaskDiagram.png";
			}
		};
		actions.add(ma);
   }

   
    if (ids.getDiagramFilter().isValidDiagram("NormDefinition")){
   // Menu to add a NormDefinition model instance
		ma=new DiagramCreationAction(){
			public String getActionName(){
				return "Add NormDefinition";
			}
			public ModelJGraph execute(String diagramName,Object[] path, IDEState ids){
				NormDefinitionModelJGraph mjg =
					new NormDefinitionModelJGraph(new
							NormDefinitionDataEntity(
									diagramName), diagramName, ids.om, new Model(ids),
									new BasicMarqueeHandler(), ids.prefs );
				NormDefinitionActionsFactory ema=new  NormDefinitionActionsFactory(resources,ids);
				mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
		   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
				mjg.setMarqueeHandler(marquee);
				ids.gm.addModel(path, diagramName, mjg);
				ids.addNewDiagram(mjg);
				return mjg;
			}
			public String getIconName() {
				// TODO Auto-generated method stub
				return "images/mNormDefinition.png";
			}
		};
		actions.add(ma);
   }

   
   return actions;
}

  public JPopupMenu menuProjectTree(MouseEvent me1) {
 final CommonMenuEntriesActionFactory cme=new CommonMenuEntriesActionFactory(resources,ids);
		JPopupMenu menu = new JPopupMenu();
		final MouseEvent me = me1;

		TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
		if (tp != null) {   
			DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) 
			tp.getLastPathComponent();

			if (tp != null && dmtn.getUserObject()instanceof String) {
				// Menu to add a EnvironmentModel model instance
 
   if (ids.getDiagramFilter().isValidDiagram("FilterDiagram")){
				menu.add(
						new AbstractAction("Add FilterDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											FilterDiagramModelJGraph mjg =
												new FilterDiagramModelJGraph(new
												FilterDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											FilterDiagramActionsFactory ema=new  FilterDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("GenericDiseaseSpecDiag")){
				menu.add(
						new AbstractAction("Add GenericDiseaseSpecDiag") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											GenericDiseaseSpecDiagModelJGraph mjg =
												new GenericDiseaseSpecDiagModelJGraph(new
												GenericDiseaseSpecDiagDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											GenericDiseaseSpecDiagActionsFactory ema=new  GenericDiseaseSpecDiagActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("BuildingDiagram")){
				menu.add(
						new AbstractAction("Add BuildingDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											BuildingDiagramModelJGraph mjg =
												new BuildingDiagramModelJGraph(new
												BuildingDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											BuildingDiagramActionsFactory ema=new  BuildingDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("ActivityDiagram")){
				menu.add(
						new AbstractAction("Add ActivityDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											ActivityDiagramModelJGraph mjg =
												new ActivityDiagramModelJGraph(new
												ActivityDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											ActivityDiagramActionsFactory ema=new  ActivityDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("ADLSpecDiagram")){
				menu.add(
						new AbstractAction("Add ADLSpecDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											ADLSpecDiagramModelJGraph mjg =
												new ADLSpecDiagramModelJGraph(new
												ADLSpecDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											ADLSpecDiagramActionsFactory ema=new  ADLSpecDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("DeviceBehavoirDiagram")){
				menu.add(
						new AbstractAction("Add DeviceBehavoirDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											DeviceBehavoirDiagramModelJGraph mjg =
												new DeviceBehavoirDiagramModelJGraph(new
												DeviceBehavoirDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											DeviceBehavoirDiagramActionsFactory ema=new  DeviceBehavoirDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("InteractionDiagram")){
				menu.add(
						new AbstractAction("Add InteractionDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											InteractionDiagramModelJGraph mjg =
												new InteractionDiagramModelJGraph(new
												InteractionDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											InteractionDiagramActionsFactory ema=new  InteractionDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("SimulationDiagram")){
				menu.add(
						new AbstractAction("Add SimulationDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											SimulationDiagramModelJGraph mjg =
												new SimulationDiagramModelJGraph(new
												SimulationDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											SimulationDiagramActionsFactory ema=new  SimulationDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("SymptomEvolutionDiagram")){
				menu.add(
						new AbstractAction("Add SymptomEvolutionDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											SymptomEvolutionDiagramModelJGraph mjg =
												new SymptomEvolutionDiagramModelJGraph(new
												SymptomEvolutionDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											SymptomEvolutionDiagramActionsFactory ema=new  SymptomEvolutionDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("FloorSpecDiagram")){
				menu.add(
						new AbstractAction("Add FloorSpecDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											FloorSpecDiagramModelJGraph mjg =
												new FloorSpecDiagramModelJGraph(new
												FloorSpecDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											FloorSpecDiagramActionsFactory ema=new  FloorSpecDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("DeviceDiagram")){
				menu.add(
						new AbstractAction("Add DeviceDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											DeviceDiagramModelJGraph mjg =
												new DeviceDiagramModelJGraph(new
												DeviceDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											DeviceDiagramActionsFactory ema=new  DeviceDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("SocialSpecDiagram")){
				menu.add(
						new AbstractAction("Add SocialSpecDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											SocialSpecDiagramModelJGraph mjg =
												new SocialSpecDiagramModelJGraph(new
												SocialSpecDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											SocialSpecDiagramActionsFactory ema=new  SocialSpecDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("RandomTaskDiagram")){
				menu.add(
						new AbstractAction("Add RandomTaskDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											RandomTaskDiagramModelJGraph mjg =
												new RandomTaskDiagramModelJGraph(new
												RandomTaskDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											RandomTaskDiagramActionsFactory ema=new  RandomTaskDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("ParkinsonSpecDiagram")){
				menu.add(
						new AbstractAction("Add ParkinsonSpecDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											ParkinsonSpecDiagramModelJGraph mjg =
												new ParkinsonSpecDiagramModelJGraph(new
												ParkinsonSpecDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											ParkinsonSpecDiagramActionsFactory ema=new  ParkinsonSpecDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("ArithmeticDiagram1")){
				menu.add(
						new AbstractAction("Add ArithmeticDiagram1") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											ArithmeticDiagram1ModelJGraph mjg =
												new ArithmeticDiagram1ModelJGraph(new
												ArithmeticDiagram1DataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											ArithmeticDiagram1ActionsFactory ema=new  ArithmeticDiagram1ActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("HumanProfileSpecDiagram")){
				menu.add(
						new AbstractAction("Add HumanProfileSpecDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											HumanProfileSpecDiagramModelJGraph mjg =
												new HumanProfileSpecDiagramModelJGraph(new
												HumanProfileSpecDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											HumanProfileSpecDiagramActionsFactory ema=new  HumanProfileSpecDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("MedicationTimeDiagram")){
				menu.add(
						new AbstractAction("Add MedicationTimeDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											MedicationTimeDiagramModelJGraph mjg =
												new MedicationTimeDiagramModelJGraph(new
												MedicationTimeDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											MedicationTimeDiagramActionsFactory ema=new  MedicationTimeDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("RoomSpecDiagram")){
				menu.add(
						new AbstractAction("Add RoomSpecDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											RoomSpecDiagramModelJGraph mjg =
												new RoomSpecDiagramModelJGraph(new
												RoomSpecDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											RoomSpecDiagramActionsFactory ema=new  RoomSpecDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("SequentialTaskDiagram")){
				menu.add(
						new AbstractAction("Add SequentialTaskDiagram") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											SequentialTaskDiagramModelJGraph mjg =
												new SequentialTaskDiagramModelJGraph(new
												SequentialTaskDiagramDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											SequentialTaskDiagramActionsFactory ema=new  SequentialTaskDiagramActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

   if (ids.getDiagramFilter().isValidDiagram("NormDefinition")){
				menu.add(
						new AbstractAction("Add NormDefinition") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
								getLastPathComponent();
								if (tp != null && dmtn.getUserObject()instanceof String) {
									String diagramName = JOptionPane.showInputDialog(owner,
											"Type graph name",
											"New graph",
											JOptionPane.QUESTION_MESSAGE);
									if (diagramName != null && ids.gm.existsModel(diagramName)) {

										JOptionPane.showMessageDialog(owner,
												"There exists a model with the same name. Please, select another",
												"Warning",
												JOptionPane.WARNING_MESSAGE);
									}
									else
										if (diagramName != null) {
											NormDefinitionModelJGraph mjg =
												new NormDefinitionModelJGraph(new
												NormDefinitionDataEntity(
												diagramName), diagramName, ids.om, new Model(ids),
												new BasicMarqueeHandler(), ids.prefs );
											NormDefinitionActionsFactory ema=new  NormDefinitionActionsFactory(resources,ids);
											mjg.setUI(new EmbeddedAndPopupCellEditor(ids,resources));
									   	        MarqueeHandler marquee=new MarqueeHandler(mjg, resources,ids,ema);
											mjg.setMarqueeHandler(marquee);
											ids.gm.addModel(tp.getPath(), diagramName, mjg);
											ids.addNewDiagram(mjg);
										
										}
								}

							}
						});
}
 
  

	menu.add(
						new AbstractAction("Add package") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								if (tp != null) {
									String nombre =
										JOptionPane.showInputDialog(owner,
												"Type a new package's name",
												"New package",
												JOptionPane.QUESTION_MESSAGE);
									if (nombre != null) {
										ids.gm.addPackage(tp.getPath(), nombre);

										ids.gm.arbolProyecto.repaint();
										ids.gm.arbolProyecto.expandPath(tp);
										ids.gm.arbolProyecto.scrollPathToVisible(tp);
										ids.addNewPackage(tp.getPath(),nombre);
									
									}
								}
							}
						});
} 
			else {

				// Edit
				menu.add(
						new AbstractAction("Edit diagram properties") {
							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								if (tp != null) {

									DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
									getLastPathComponent();

									Object uo = dmtn.getUserObject();

									if (!String.class.isAssignableFrom(uo.getClass())) {
										boolean duplicated = true;
										while (duplicated) {
											ModelDataEntity mde = ( (ModelJGraph) uo).getProperties();

											ingenias.editor.editiondialog.GeneralEditionFrame gef = new ingenias.
											editor.editiondialog.GeneralEditionFrame(ids.editor, ids.om, ids.gm, owner,
													"Edit diagram properties",
													mde);
											ModelJGraph mjg =
												ids.gm.getModel(mde.getId());
											//	              Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
											gef.setLocation(GraphicsUtils.getCenter(resources.getMainFrame(),gef.getSize()));
											gef.pack();
											gef.show();
											duplicated =
												ids.gm.isDuplicated(mde.getId());
											if (duplicated) {
												JOptionPane.showMessageDialog(owner,
														"There exists a model with the same name. Please, select another",
														"Warning", JOptionPane.WARNING_MESSAGE);
											} else {
												if (gef.getStatus()==gef.ACCEPTED){
													ids.gm.arbolProyecto.storeTreeExpansionPaths();
													( (DefaultTreeModel) ids.gm.arbolProyecto.getModel()).reload();
													ids.gm.arbolProyecto.restoreTreeExpansionPath();
													ids.diagramPropertiesChanged(mjg);
													ids.setChanged(true);
													resources.setChanged();
												}
											}
										}
										
									}
								}
							}
						});
			}
			if (tp.getPathCount()>1){
			       menu.add(
				new AbstractAction("rename") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								if (tp != null) {
									DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode) tp.
									getLastPathComponent();
									Object uo = dmtn.getUserObject();
									
									String result = JOptionPane.showInputDialog(owner,
											"Type in the new name", 
											uo.toString());
									if (result != null && !result.equals("")) {
										if (String.class.isAssignableFrom(uo.getClass())) {
											dmtn.setUserObject(result);

											ids.setChanged(true);
											ids.packageRenamed(result);											
										}
										else {
											if (ids.gm.existsModel(result)) {
												JOptionPane.showMessageDialog(owner,
														"There exists a model with the same name. Please, select another",
														"Warning",
														JOptionPane.WARNING_MESSAGE);
											}
											else {

												ModelJGraph mjg = (ModelJGraph) uo;
												String oldid=mjg.getID();
												mjg.setId(result);
												mjg.setName(result);												
												ids.om.renameModelID(oldid,result);												
												ids.diagramRenamed(mjg);
												ids.setChanged(true);
												resources.setChanged();				
											}
										}
									}
								}
							}
						});

				menu.add(
						new AbstractAction("remove package/model") {

							public void actionPerformed(ActionEvent e) {
								TreePath tp = ids.gm.arbolProyecto.getSelectionPath();
								if (tp != null) {
									int result = JOptionPane.showConfirmDialog(owner,
											"This will remove permanently " + tp.getLastPathComponent() +
											". Are you sure?",
											"removing package", JOptionPane.YES_NO_OPTION);
									if (result == JOptionPane.OK_OPTION) {
										ModelJGraph mj = ids.gm.getModel(tp.getPath());
										if (mj != null) {
											ids.editor.closeTab(mj.getID());
										}
										ids.gm.arbolProyecto.storeTreeExpansionPaths();
										ids.gm.removePackage(tp.getPath());

										( (DefaultTreeModel) ids.gm.arbolProyecto.getModel()).reload();
										ids.gm.arbolProyecto.repaint();
										ids.gm.arbolProyecto.restoreTreeExpansionPath();
										ids.diagramDeleted(mj);
										ids.setChanged(true);
										resources.setChanged();  
									}
								}
							}
						});
			}
		}
		return menu;
};
	
	

}



