
/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;

public class ProjectTreeRenderer extends javax.swing.tree.DefaultTreeCellRenderer{
// Meta-models icons

static ImageIcon modeloFilterDiagram=new ImageIcon(ImageLoader.getImage("images/mFilterDiagram.png"));

static ImageIcon modeloGenericDiseaseSpecDiag=new ImageIcon(ImageLoader.getImage("images/mGenericDiseaseSpecDiag.png"));

static ImageIcon modeloBuildingDiagram=new ImageIcon(ImageLoader.getImage("images/mBuildingDiagram.png"));

static ImageIcon modeloActivityDiagram=new ImageIcon(ImageLoader.getImage("images/mActivityDiagram.png"));

static ImageIcon modeloADLSpecDiagram=new ImageIcon(ImageLoader.getImage("images/mADLSpecDiagram.png"));

static ImageIcon modeloDeviceBehavoirDiagram=new ImageIcon(ImageLoader.getImage("images/mDeviceBehavoirDiagram.png"));

static ImageIcon modeloInteractionDiagram=new ImageIcon(ImageLoader.getImage("images/mInteractionDiagram.png"));

static ImageIcon modeloSimulationDiagram=new ImageIcon(ImageLoader.getImage("images/mSimulationDiagram.png"));

static ImageIcon modeloSymptomEvolutionDiagram=new ImageIcon(ImageLoader.getImage("images/mSymptomEvolutionDiagram.png"));

static ImageIcon modeloFloorSpecDiagram=new ImageIcon(ImageLoader.getImage("images/mFloorSpecDiagram.png"));

static ImageIcon modeloDeviceDiagram=new ImageIcon(ImageLoader.getImage("images/mDeviceDiagram.png"));

static ImageIcon modeloSocialSpecDiagram=new ImageIcon(ImageLoader.getImage("images/mSocialSpecDiagram.png"));

static ImageIcon modeloRandomTaskDiagram=new ImageIcon(ImageLoader.getImage("images/mRandomTaskDiagram.png"));

static ImageIcon modeloParkinsonSpecDiagram=new ImageIcon(ImageLoader.getImage("images/mParkinsonSpecDiagram.png"));

static ImageIcon modeloArithmeticDiagram1=new ImageIcon(ImageLoader.getImage("images/mArithmeticDiagram1.png"));

static ImageIcon modeloHumanProfileSpecDiagram=new ImageIcon(ImageLoader.getImage("images/mHumanProfileSpecDiagram.png"));

static ImageIcon modeloMedicationTimeDiagram=new ImageIcon(ImageLoader.getImage("images/mMedicationTimeDiagram.png"));

static ImageIcon modeloRoomSpecDiagram=new ImageIcon(ImageLoader.getImage("images/mRoomSpecDiagram.png"));

static ImageIcon modeloSequentialTaskDiagram=new ImageIcon(ImageLoader.getImage("images/mSequentialTaskDiagram.png"));

static ImageIcon modeloNormDefinition=new ImageIcon(ImageLoader.getImage("images/mNormDefinition.png"));


// Object icons
 
 static ImageIcon DishwasherIcon=new ImageIcon(ImageLoader.getImage("images/mDishwasher.png"));
	
 static ImageIcon PerceptionEventIcon=new ImageIcon(ImageLoader.getImage("images/mPerceptionEvent.png"));
	
 static ImageIcon DeviceVarIcon=new ImageIcon(ImageLoader.getImage("images/vars/DeviceVar16.png"));
	
 static ImageIcon ArithmeticExpressionIcon=new ImageIcon(ImageLoader.getImage("images/mArithmeticExpression.png"));
	
 static ImageIcon SwitchLightActionIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/devices/LightAction16.png"));
	
 static ImageIcon SeatVarIcon=new ImageIcon(ImageLoader.getImage("images/vars/SeatVar16.png"));
	
 static ImageIcon ShowerIcon=new ImageIcon(ImageLoader.getImage("images/objects/Shower16.png"));
	
 static ImageIcon ProgramStateIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/devices/ProgramState16.png"));
	
 static ImageIcon FOWashbasinIcon=new ImageIcon(ImageLoader.getImage("images/objects/WashBasin16.png"));
	
 static ImageIcon FDelayFilterIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/DelayFilter16.png"));
	
 static ImageIcon CObjWeightIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CObjWeight16.png"));
	
 static ImageIcon VarIcon=new ImageIcon(ImageLoader.getImage("images/mVar.png"));
	
 static ImageIcon WorldInitializationIcon=new ImageIcon(ImageLoader.getImage("images/sim/WorldInitialization16.png"));
	
 static ImageIcon HumanProfileIcon=new ImageIcon(ImageLoader.getImage("images/mHumanProfile.png"));
	
 static ImageIcon FOBathIcon=new ImageIcon(ImageLoader.getImage("images/objects/Bath16.png"));
	
 static ImageIcon PDSymtomIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/Symptom16.png"));
	
 static ImageIcon HumanNormIcon=new ImageIcon(ImageLoader.getImage("images/mHumanNorm.png"));
	
 static ImageIcon DiseaseProfileIcon=new ImageIcon(ImageLoader.getImage("images/mDiseaseProfile.png"));
	
 static ImageIcon BGetUpFromBedIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/GetUpFromBed16.png"));
	
 static ImageIcon GenericDiseaseIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile16.png"));
	
 static ImageIcon CSayIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CSay16.png"));
	
 static ImageIcon SwipeTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Swipe16.png"));
	
 static ImageIcon StopBehaviourEventIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/events/StopBehaviourEvent16.png"));
	
 static ImageIcon SVerticalSpaceIcon=new ImageIcon(ImageLoader.getImage("images/mSVerticalSpace.png"));
	
 static ImageIcon PersonalInfoIcon=new ImageIcon(ImageLoader.getImage("images/profiles/SocialProfile/PersonalInfo16.png"));
	
 static ImageIcon CAlwaysIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CAlways16.png"));
	
 static ImageIcon ObjectVarIcon=new ImageIcon(ImageLoader.getImage("images/vars/ObjectVar16.png"));
	
 static ImageIcon MedsTakenEventIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/events/MedsTakenEvent16.png"));
	
 static ImageIcon ExtractorIcon=new ImageIcon(ImageLoader.getImage("images/mExtractor.png"));
	
 static ImageIcon SSpatialIcon=new ImageIcon(ImageLoader.getImage("images/mSSpatial.png"));
	
 static ImageIcon FBedIcon=new ImageIcon(ImageLoader.getImage("images/objects/Bed16.png"));
	
 static ImageIcon BECollisionIcon=new ImageIcon(ImageLoader.getImage("images/mBECollision.png"));
	
 static ImageIcon SociAALEntityIcon=new ImageIcon(ImageLoader.getImage("images/mSociAALEntity.png"));
	
 static ImageIcon DComputerIcon=new ImageIcon(ImageLoader.getImage("images/mDComputer.png"));
	
 static ImageIcon ShirtIcon=new ImageIcon(ImageLoader.getImage("images/mShirt.png"));
	
 static ImageIcon ShoesIcon=new ImageIcon(ImageLoader.getImage("images/mShoes.png"));
	
 static ImageIcon AndroidEmulatorIcon=new ImageIcon(ImageLoader.getImage("images/devices/Emulator16.png"));
	
 static ImageIcon PlayAnimationTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/PlayAnim16.png"));
	
 static ImageIcon SymptomChangedEventIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/events/SymptomChangeEvent16.png"));
	
 static ImageIcon BridgeIcon=new ImageIcon(ImageLoader.getImage("images/mBridge.png"));
	
 static ImageIcon EMobileDeviceIcon=new ImageIcon(ImageLoader.getImage("images/mEMobileDevice.png"));
	
 static ImageIcon FOSinkIcon=new ImageIcon(ImageLoader.getImage("images/objects/KitchenSink16.png"));
	
 static ImageIcon CProbIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CProb16.png"));
	
 static ImageIcon EWaterBottleIcon=new ImageIcon(ImageLoader.getImage("images/mEWaterBottle.png"));
	
 static ImageIcon BENewObjInFieldOfVisionIcon=new ImageIcon(ImageLoader.getImage("images/mBENewObjInFieldOfVision.png"));
	
 static ImageIcon SBathroomIcon=new ImageIcon(ImageLoader.getImage("images/space/bathroom16.png"));
	
 static ImageIcon CrutchIcon=new ImageIcon(ImageLoader.getImage("images/objects/Crutch16.png"));
	
 static ImageIcon StaircaseIcon=new ImageIcon(ImageLoader.getImage("images/space/staircase16.png"));
	
 static ImageIcon FChangeTargetObjFilterIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/ChangeTargetObj16.png"));
	
 static ImageIcon SBedroomIcon=new ImageIcon(ImageLoader.getImage("images/space/bedroom16.png"));
	
 static ImageIcon AEDivIcon=new ImageIcon(ImageLoader.getImage("images/mAEDiv.png"));
	
 static ImageIcon VibrateEventIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/events/VibrateEvent16.png"));
	
 static ImageIcon WearableVarIcon=new ImageIcon(ImageLoader.getImage("images/vars/WearableVar16.png"));
	
 static ImageIcon DoorStateConditionIcon=new ImageIcon(ImageLoader.getImage("images/conditions/DoorState16.png"));
	
 static ImageIcon WaitForBodyCloseIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/WaitForBodyClose16.png"));
	
 static ImageIcon BPickUpTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/PickUp16.png"));
	
 static ImageIcon DoorbellIcon=new ImageIcon(ImageLoader.getImage("images/mDoorbell.png"));
	
 static ImageIcon SAreaIcon=new ImageIcon(ImageLoader.getImage("images/space/area16.png"));
	
 static ImageIcon CloseTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Close16.png"));
	
 static ImageIcon PartOfBodyIcon=new ImageIcon(ImageLoader.getImage("images/entities/PartsOfBody16.png"));
	
 static ImageIcon LightStateConditionIcon=new ImageIcon(ImageLoader.getImage("images/conditions/LightState16.png"));
	
 static ImageIcon PrimitiveVarIcon=new ImageIcon(ImageLoader.getImage("images/vars/PrimitiveVar16.png"));
	
 static ImageIcon AEAddSubIcon=new ImageIcon(ImageLoader.getImage("images/mAEAddSub.png"));
	
 static ImageIcon FSofaIcon=new ImageIcon(ImageLoader.getImage("images/objects/Sofa16.png"));
	
 static ImageIcon EPublicEventIcon=new ImageIcon(ImageLoader.getImage("images/mEPublicEvent.png"));
	
 static ImageIcon PutOnTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/PutOn16.png"));
	
 static ImageIcon SFloorIcon=new ImageIcon(ImageLoader.getImage("images/space/floor16.png"));
	
 static ImageIcon HIGHSympLevelStateIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/HIGHSympLevelState16.png"));
	
 static ImageIcon AEInvIcon=new ImageIcon(ImageLoader.getImage("images/mAEInv.png"));
	
 static ImageIcon EMobileObjectIcon=new ImageIcon(ImageLoader.getImage("images/mEMobileObject.png"));
	
 static ImageIcon SayTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Say16.png"));
	
 static ImageIcon HearingEventIcon=new ImageIcon(ImageLoader.getImage("images/mHearingEvent.png"));
	
 static ImageIcon BEObjOutFielOfVisionIcon=new ImageIcon(ImageLoader.getImage("images/mBEObjOutFielOfVision.png"));
	
 static ImageIcon ERemoteControlIcon=new ImageIcon(ImageLoader.getImage("images/mERemoteControl.png"));
	
 static ImageIcon SymptomLevelStateIcon=new ImageIcon(ImageLoader.getImage("images/mSymptomLevelState.png"));
	
 static ImageIcon EMobileFurnitureIcon=new ImageIcon(ImageLoader.getImage("images/mEMobileFurniture.png"));
	
 static ImageIcon ParamIcon=new ImageIcon(ImageLoader.getImage("images/mParam.png"));
	
 static ImageIcon MessageListenedEventIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/events/MessageListenedEvent16.png"));
	
 static ImageIcon SDateIcon=new ImageIcon(ImageLoader.getImage("images/time/Date16.png"));
	
 static ImageIcon BUseTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/UseTask16.png"));
	
 static ImageIcon BodyEventIcon=new ImageIcon(ImageLoader.getImage("images/mBodyEvent.png"));
	
 static ImageIcon CompConditionIcon=new ImageIcon(ImageLoader.getImage("images/mCompCondition.png"));
	
 static ImageIcon TrousersIcon=new ImageIcon(ImageLoader.getImage("images/mTrousers.png"));
	
 static ImageIcon FallingEventIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/events/FallingEvent16.png"));
	
 static ImageIcon EFixedDeviceIcon=new ImageIcon(ImageLoader.getImage("images/mEFixedDevice.png"));
	
 static ImageIcon ConditionIcon=new ImageIcon(ImageLoader.getImage("images/mCondition.png"));
	
 static ImageIcon CReceiveHelpIcon=new ImageIcon(ImageLoader.getImage("images/conditions/ReceiveHelp16.png"));
	
 static ImageIcon WearableParamIcon=new ImageIcon(ImageLoader.getImage("images/params/WearableParam16.png"));
	
 static ImageIcon WashMachineIcon=new ImageIcon(ImageLoader.getImage("images/mWashMachine.png"));
	
 static ImageIcon FlyCamInitIcon=new ImageIcon(ImageLoader.getImage("images/sim/ScreenAndCamPos16.png"));
	
 static ImageIcon VibrateDeviceActionIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/devices/VibrateAction16.png"));
	
 static ImageIcon ApplianceIcon=new ImageIcon(ImageLoader.getImage("images/mAppliance.png"));
	
 static ImageIcon MedInjectionIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/MedInjection16.png"));
	
 static ImageIcon ADLProfileIcon=new ImageIcon(ImageLoader.getImage("images/profiles/ADLProfile16.png"));
	
 static ImageIcon DTVIcon=new ImageIcon(ImageLoader.getImage("images/mDTV.png"));
	
 static ImageIcon BSimpleTaskIcon=new ImageIcon(ImageLoader.getImage("images/mBSimpleTask.png"));
	
 static ImageIcon EWearableIcon=new ImageIcon(ImageLoader.getImage("images/mEWearable.png"));
	
 static ImageIcon DeviceParamIcon=new ImageIcon(ImageLoader.getImage("images/params/DeviceParam16.png"));
	
 static ImageIcon EMedicineIcon=new ImageIcon(ImageLoader.getImage("images/mEMedicine.png"));
	
 static ImageIcon AENumConstIcon=new ImageIcon(ImageLoader.getImage("images/mAENumConst.png"));
	
 static ImageIcon LOWTaskFilterRIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/LOWTaskFilterR16.png"));
	
 static ImageIcon TakeOffTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/TakeOff16.png"));
	
 static ImageIcon EatableItemIcon=new ImageIcon(ImageLoader.getImage("images/mEatableItem.png"));
	
 static ImageIcon EPhysicalEntityIcon=new ImageIcon(ImageLoader.getImage("images/mEPhysicalEntity.png"));
	
 static ImageIcon SocialProfileIcon=new ImageIcon(ImageLoader.getImage("images/profiles/SocialProfile16.png"));
	
 static ImageIcon NotConditionIcon=new ImageIcon(ImageLoader.getImage("images/conditions/NotCondition16.png"));
	
 static ImageIcon BEObjectMovingIcon=new ImageIcon(ImageLoader.getImage("images/mBEObjectMoving.png"));
	
 static ImageIcon DropObjIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/ObjDropped16.png"));
	
 static ImageIcon EFixedObjectIcon=new ImageIcon(ImageLoader.getImage("images/mEFixedObject.png"));
	
 static ImageIcon IsThingInRoomConditionIcon=new ImageIcon(ImageLoader.getImage("images/conditions/ObjLoc16.png"));
	
 static ImageIcon PlaceParamIcon=new ImageIcon(ImageLoader.getImage("images/params/PlaceParam16.png"));
	
 static ImageIcon CTimerIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CTimer16.png"));
	
 static ImageIcon HumanIcon=new ImageIcon(ImageLoader.getImage("images/entities/Human16.png"));
	
 static ImageIcon CInsideIcon=new ImageIcon(ImageLoader.getImage("images/conditions/inside16.png"));
	
 static ImageIcon AEMultIcon=new ImageIcon(ImageLoader.getImage("images/mAEMult.png"));
	
 static ImageIcon VisionEventIcon=new ImageIcon(ImageLoader.getImage("images/mVisionEvent.png"));
	
 static ImageIcon SeatParamIcon=new ImageIcon(ImageLoader.getImage("images/params/SeatParam16.png"));
	
 static ImageIcon EASubSubSubIcon=new ImageIcon(ImageLoader.getImage("images/mEASubSubSub.png"));
	
 static ImageIcon ELivingBeingIcon=new ImageIcon(ImageLoader.getImage("images/mELivingBeing.png"));
	
 static ImageIcon SwitchLightTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/PressSwitch16.png"));
	
 static ImageIcon SpatialVarIcon=new ImageIcon(ImageLoader.getImage("images/vars/SpatialVar16.png"));
	
 static ImageIcon LiftIcon=new ImageIcon(ImageLoader.getImage("images/space/lift16.png"));
	
 static ImageIcon StandUpIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/StandUp16.png"));
	
 static ImageIcon FallTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Fall16.png"));
	
 static ImageIcon EPrivateEventIcon=new ImageIcon(ImageLoader.getImage("images/mEPrivateEvent.png"));
	
 static ImageIcon NONESympLevelStateIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/NONESympLevelState16.png"));
	
 static ImageIcon MEDIUMTaskFilterRIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/MEDIUMTaskFilterR16.png"));
	
 static ImageIcon GoToBodyLocIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/GoToBodyLoc16.png"));
	
 static ImageIcon TaskFilterRefIcon=new ImageIcon(ImageLoader.getImage("images/mTaskFilterRef.png"));
	
 static ImageIcon GoIntoBedIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/GoIntoBed16.png"));
	
 static ImageIcon AEVariableIcon=new ImageIcon(ImageLoader.getImage("images/mAEVariable.png"));
	
 static ImageIcon FTaskSelectorFilterIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/TaskSelectorFilter16.png"));
	
 static ImageIcon BSimpleDurationTaskIcon=new ImageIcon(ImageLoader.getImage("images/mBSimpleDurationTask.png"));
	
 static ImageIcon WalkerIcon=new ImageIcon(ImageLoader.getImage("images/objects/Walker16.png"));
	
 static ImageIcon OpenTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Open16.png"));
	
 static ImageIcon SCorridorIcon=new ImageIcon(ImageLoader.getImage("images/space/corridor16.png"));
	
 static ImageIcon FModifyPlaceFilterIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/ChangePlace16.png"));
	
 static ImageIcon FTableIcon=new ImageIcon(ImageLoader.getImage("images/objects/Table16.png"));
	
 static ImageIcon DrinkItemIcon=new ImageIcon(ImageLoader.getImage("images/mDrinkItem.png"));
	
 static ImageIcon FallSleepIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/FallSleepTask16.png"));
	
 static ImageIcon BActivityIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/activities/Activity16.png"));
	
 static ImageIcon AnotherActionHappensIcon=new ImageIcon(ImageLoader.getImage("images/mAnotherActionHappens.png"));
	
 static ImageIcon WaitTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Wait16.png"));
	
 static ImageIcon HumanParamIcon=new ImageIcon(ImageLoader.getImage("images/params/HumanParam16.png"));
	
 static ImageIcon BEventIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/events/event16.png"));
	
 static ImageIcon BDeviceActionIcon=new ImageIcon(ImageLoader.getImage("images/mBDeviceAction.png"));
	
 static ImageIcon FChairIcon=new ImageIcon(ImageLoader.getImage("images/objects/Chair16.png"));
	
 static ImageIcon SLivingroomIcon=new ImageIcon(ImageLoader.getImage("images/space/livingroom16.png"));
	
 static ImageIcon DeviceEventIcon=new ImageIcon(ImageLoader.getImage("images/mDeviceEvent.png"));
	
 static ImageIcon TimeIntervalIcon=new ImageIcon(ImageLoader.getImage("images/profiles/ADLProfile/timeInterval16.png"));
	
 static ImageIcon IncomingCallActionIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/devices/IncomingCallAction16.png"));
	
 static ImageIcon PresenceSensorStateConditionIcon=new ImageIcon(ImageLoader.getImage("images/conditions/PresenceSensorState16.png"));
	
 static ImageIcon SRoomIcon=new ImageIcon(ImageLoader.getImage("images/mSRoom.png"));
	
 static ImageIcon MEDIUMSympLevelStateIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/MEDIUMSympLevelState16.png"));
	
 static ImageIcon BodyStateConditionIcon=new ImageIcon(ImageLoader.getImage("images/conditions/BodyState16.png"));
	
 static ImageIcon EBehaviourEventIcon=new ImageIcon(ImageLoader.getImage("images/mEBehaviourEvent.png"));
	
 static ImageIcon FReplaceTaskFilterIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/ReplaceTaskFilter16.png"));
	
 static ImageIcon BTaskIcon=new ImageIcon(ImageLoader.getImage("images/mBTask.png"));
	
 static ImageIcon LOWSympLevelStateIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/LOWSympLevelState16.png"));
	
 static ImageIcon FUnableFilterIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/FUnableFilter16.png"));
	
 static ImageIcon FChangeToolFilterIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/ChangeToolFilter16.png"));
	
 static ImageIcon AESubIcon=new ImageIcon(ImageLoader.getImage("images/mAESub.png"));
	
 static ImageIcon HumanVarIcon=new ImageIcon(ImageLoader.getImage("images/vars/HumanVar16.png"));
	
 static ImageIcon AESubSubIcon=new ImageIcon(ImageLoader.getImage("images/mAESubSub.png"));
	
 static ImageIcon CSymptomIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/CSymptom16.png"));
	
 static ImageIcon ParkinsonsProfileIcon=new ImageIcon(ImageLoader.getImage("images/profiles/PDProfile16.png"));
	
 static ImageIcon EventProcessorIcon=new ImageIcon(ImageLoader.getImage("images/profiles/InteractionProfile/EventProcessor16.png"));
	
 static ImageIcon ObjectParamIcon=new ImageIcon(ImageLoader.getImage("images/params/ObjectParam16.png"));
	
 static ImageIcon FSeatIcon=new ImageIcon(ImageLoader.getImage("images/mFSeat.png"));
	
 static ImageIcon BLeaveTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Leave16.png"));
	
 static ImageIcon CDayOfTheWeekIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CDayOfTheDay16.png"));
	
 static ImageIcon PrimitiveParamIcon=new ImageIcon(ImageLoader.getImage("images/params/PrimitiveParam16.png"));
	
 static ImageIcon CallStateEventIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/events/CallState16.png"));
	
 static ImageIcon SKitchenIcon=new ImageIcon(ImageLoader.getImage("images/space/kitchen16.png"));
	
 static ImageIcon FOWaterIcon=new ImageIcon(ImageLoader.getImage("images/objects/wc16.png"));
	
 static ImageIcon EatIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Eat16.png"));
	
 static ImageIcon TouchEventIcon=new ImageIcon(ImageLoader.getImage("images/mTouchEvent.png"));
	
 static ImageIcon ShocksIcon=new ImageIcon(ImageLoader.getImage("images/mShocks.png"));
	
 static ImageIcon BSequentialTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/CTSequential16.png"));
	
 static ImageIcon InitProgramPoolIcon=new ImageIcon(ImageLoader.getImage("images/sim/ProgramDeviceInitialization16.png"));
	
 static ImageIcon StartBehaviourEventIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/events/StartBehaviourEvent16.png"));
	
 static ImageIcon HumanInitializationIcon=new ImageIcon(ImageLoader.getImage("images/sim/HumanInitialization16.png"));
	
 static ImageIcon BehaviourIcon=new ImageIcon(ImageLoader.getImage("images/mBehaviour.png"));
	
 static ImageIcon BEVibrationIcon=new ImageIcon(ImageLoader.getImage("images/mBEVibration.png"));
	
 static ImageIcon CTimeIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CTime16.png"));
	
 static ImageIcon ConsecutiveActionsIcon=new ImageIcon(ImageLoader.getImage("images/mConsecutiveActions.png"));
	
 static ImageIcon DiseaseStageIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/GStage16.png"));
	
 static ImageIcon AndroidApplicationIcon=new ImageIcon(ImageLoader.getImage("images/devices/AndroidApp16.png"));
	
 static ImageIcon AEAdditionIcon=new ImageIcon(ImageLoader.getImage("images/mAEAddition.png"));
	
 static ImageIcon BRandomTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/CTRandom16.png"));
	
 static ImageIcon SitDownIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/SitDown16.png"));
	
 static ImageIcon SocialNetworkIcon=new ImageIcon(ImageLoader.getImage("images/profiles/SocialProfile/socialnetwork16.png"));
	
 static ImageIcon CEventIcon=new ImageIcon(ImageLoader.getImage("images/conditions/CEvent16.png"));
	
 static ImageIcon InitialPreDefPosIcon=new ImageIcon(ImageLoader.getImage("images/sim/PreDefPos16.png"));
	
 static ImageIcon ClockTimeIcon=new ImageIcon(ImageLoader.getImage("images/time/ClockTime16.png"));
	
 static ImageIcon AEMulDivIcon=new ImageIcon(ImageLoader.getImage("images/mAEMulDiv.png"));
	
 static ImageIcon FModifyFilterIcon=new ImageIcon(ImageLoader.getImage("images/mFModifyFilter.png"));
	
 static ImageIcon InteractionProfileIcon=new ImageIcon(ImageLoader.getImage("images/profiles/InteractionProfile16.png"));
	
 static ImageIcon TapXYTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/TapXY16.png"));
	
 static ImageIcon CameraInitIcon=new ImageIcon(ImageLoader.getImage("images/sim/VideoCameraInit16.png"));
	
 static ImageIcon MedIntakeIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/MedIntake16.png"));
	
 static ImageIcon BWakeUpTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/WakeUp16.png"));
	
 static ImageIcon HIGHTaskFilterRIcon=new ImageIcon(ImageLoader.getImage("images/profiles/filter/HIGHTaskFilterR16.png"));
	
 static ImageIcon FTaskFilterIcon=new ImageIcon(ImageLoader.getImage("images/mFTaskFilter.png"));
	
 static ImageIcon MedicationIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/Medication16.png"));
	
 static ImageIcon BCompTaskIcon=new ImageIcon(ImageLoader.getImage("images/mBCompTask.png"));
	
 static ImageIcon TextToSpeachActionIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/devices/TTSAction16.png"));
	
 static ImageIcon ESleepersIcon=new ImageIcon(ImageLoader.getImage("images/mESleepers.png"));
	
 static ImageIcon MedicationTimeIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/MedicationTime16.png"));
	
 static ImageIcon PDDiseaseStageIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/PDStage16.png"));
	
 static ImageIcon ESmartPhoneIcon=new ImageIcon(ImageLoader.getImage("images/devices/Smartphone16.png"));
	
 static ImageIcon PyjamasIcon=new ImageIcon(ImageLoader.getImage("images/mPyjamas.png"));
	
 static ImageIcon GSymptomIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/Symptom16.png"));
	
 static ImageIcon EMobilePhysicalEntityIcon=new ImageIcon(ImageLoader.getImage("images/mEMobilePhysicalEntity.png"));
	
 static ImageIcon DrinkIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/Drink16.png"));
	
 static ImageIcon WalkingHelperIcon=new ImageIcon(ImageLoader.getImage("images/mWalkingHelper.png"));
	
 static ImageIcon SBuildingIcon=new ImageIcon(ImageLoader.getImage("images/space/building16.png"));
	
 static ImageIcon EFixedFurnitureIcon=new ImageIcon(ImageLoader.getImage("images/mEFixedFurniture.png"));
	
 static ImageIcon BGoToTaskIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/tasks/GoToTask16.png"));
	
 static ImageIcon SymptomInitializationIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/SymptomInitialization16.png"));
	
 static ImageIcon AESubtractionIcon=new ImageIcon(ImageLoader.getImage("images/mAESubtraction.png"));
	
 static ImageIcon COutsideIcon=new ImageIcon(ImageLoader.getImage("images/conditions/outside16.png"));
	
 static ImageIcon ObjDroppedEventIcon=new ImageIcon(ImageLoader.getImage("images/profiles/DiseaseProfile/events/ObjDroppedEvent16.png"));
	
 static ImageIcon FWardrobeIcon=new ImageIcon(ImageLoader.getImage("images/objects/Wardrobe16.png"));
	
 static ImageIcon ProfessionIcon=new ImageIcon(ImageLoader.getImage("images/profiles/SocialProfile/Profession16.png"));
	
 static ImageIcon IFFlowControlIcon=new ImageIcon(ImageLoader.getImage("images/behaviour/activities/ifFlowOperator16.png"));
	
 static ImageIcon DFixedSensorIcon=new ImageIcon(ImageLoader.getImage("images/mDFixedSensor.png"));
	
 static ImageIcon CaneIcon=new ImageIcon(ImageLoader.getImage("images/objects/Cane16.png"));
	
 static ImageIcon EToolIcon=new ImageIcon(ImageLoader.getImage("images/mETool.png"));
	
 static ImageIcon BEBodyCollisionIcon=new ImageIcon(ImageLoader.getImage("images/mBEBodyCollision.png"));
	
 static ImageIcon EClothingIcon=new ImageIcon(ImageLoader.getImage("images/mEClothing.png"));
	
 static ImageIcon NormHoldingConditionIcon=new ImageIcon(ImageLoader.getImage("images/mNormHoldingCondition.png"));
	
 static ImageIcon EFixedPhysicalEntityIcon=new ImageIcon(ImageLoader.getImage("images/mEFixedPhysicalEntity.png"));
	

	static ImageIcon ConventionalFolderIcon=new ImageIcon(ImageLoader.getImage("images/folder.png"));

	static ImageIcon RootFolderIcon=new ImageIcon(ImageLoader.getImage("images/world.png"));


  public ProjectTreeRenderer() {

  super();

  }


    public Component getTreeCellRendererComponent(
                        JTree tree,
                        Object value,
                        boolean sel,
                        boolean expanded,
                        boolean leaf,
                        int row,
                        boolean hasFocus) {

       		super.getTreeCellRendererComponent(
				tree, value, sel,
				expanded, leaf, row,
				hasFocus);
		ImageIcon img=this.selectIcon(value);
		if (row==0)
			img=RootFolderIcon;

		if (img!=null) {
			setIcon(img);
			return this;
		} else
			return super.getTreeCellRendererComponent(tree,value,sel,expanded,leaf,row,hasFocus);
    }



  public static ImageIcon selectIcon(Object value) {
        DefaultMutableTreeNode node =
            (DefaultMutableTreeNode)value;
        return selectIconByUserObject(node.getUserObject());
    }

    public static String getIconNameByUserObject(Object userObject) {
	if (userObject.getClass().equals(String.class))
			return "images/folder.png";


	
        if (userObject.getClass().equals(Dishwasher.class))
          return "images/mDishwasher.png";
	
        if (userObject.getClass().equals(PerceptionEvent.class))
          return "images/mPerceptionEvent.png";
	
        if (userObject.getClass().equals(DeviceVar.class))
          return "images/vars/DeviceVar16.png";
	
        if (userObject.getClass().equals(ArithmeticExpression.class))
          return "images/mArithmeticExpression.png";
	
        if (userObject.getClass().equals(SwitchLightAction.class))
          return "images/behaviour/devices/LightAction16.png";
	
        if (userObject.getClass().equals(SeatVar.class))
          return "images/vars/SeatVar16.png";
	
        if (userObject.getClass().equals(Shower.class))
          return "images/objects/Shower16.png";
	
        if (userObject.getClass().equals(ProgramState.class))
          return "images/behaviour/devices/ProgramState16.png";
	
        if (userObject.getClass().equals(FOWashbasin.class))
          return "images/objects/WashBasin16.png";
	
        if (userObject.getClass().equals(FDelayFilter.class))
          return "images/profiles/filter/DelayFilter16.png";
	
        if (userObject.getClass().equals(CObjWeight.class))
          return "images/conditions/CObjWeight16.png";
	
        if (userObject.getClass().equals(Var.class))
          return "images/mVar.png";
	
        if (userObject.getClass().equals(WorldInitialization.class))
          return "images/sim/WorldInitialization16.png";
	
        if (userObject.getClass().equals(HumanProfile.class))
          return "images/mHumanProfile.png";
	
        if (userObject.getClass().equals(FOBath.class))
          return "images/objects/Bath16.png";
	
        if (userObject.getClass().equals(PDSymtom.class))
          return "images/profiles/DiseaseProfile/Symptom16.png";
	
        if (userObject.getClass().equals(HumanNorm.class))
          return "images/mHumanNorm.png";
	
        if (userObject.getClass().equals(DiseaseProfile.class))
          return "images/mDiseaseProfile.png";
	
        if (userObject.getClass().equals(BGetUpFromBed.class))
          return "images/behaviour/tasks/GetUpFromBed16.png";
	
        if (userObject.getClass().equals(GenericDisease.class))
          return "images/profiles/DiseaseProfile16.png";
	
        if (userObject.getClass().equals(CSay.class))
          return "images/conditions/CSay16.png";
	
        if (userObject.getClass().equals(SwipeTask.class))
          return "images/behaviour/tasks/Swipe16.png";
	
        if (userObject.getClass().equals(StopBehaviourEvent.class))
          return "images/behaviour/events/StopBehaviourEvent16.png";
	
        if (userObject.getClass().equals(SVerticalSpace.class))
          return "images/mSVerticalSpace.png";
	
        if (userObject.getClass().equals(PersonalInfo.class))
          return "images/profiles/SocialProfile/PersonalInfo16.png";
	
        if (userObject.getClass().equals(CAlways.class))
          return "images/conditions/CAlways16.png";
	
        if (userObject.getClass().equals(ObjectVar.class))
          return "images/vars/ObjectVar16.png";
	
        if (userObject.getClass().equals(MedsTakenEvent.class))
          return "images/profiles/DiseaseProfile/events/MedsTakenEvent16.png";
	
        if (userObject.getClass().equals(Extractor.class))
          return "images/mExtractor.png";
	
        if (userObject.getClass().equals(SSpatial.class))
          return "images/mSSpatial.png";
	
        if (userObject.getClass().equals(FBed.class))
          return "images/objects/Bed16.png";
	
        if (userObject.getClass().equals(BECollision.class))
          return "images/mBECollision.png";
	
        if (userObject.getClass().equals(SociAALEntity.class))
          return "images/mSociAALEntity.png";
	
        if (userObject.getClass().equals(DComputer.class))
          return "images/mDComputer.png";
	
        if (userObject.getClass().equals(Shirt.class))
          return "images/mShirt.png";
	
        if (userObject.getClass().equals(Shoes.class))
          return "images/mShoes.png";
	
        if (userObject.getClass().equals(AndroidEmulator.class))
          return "images/devices/Emulator16.png";
	
        if (userObject.getClass().equals(PlayAnimationTask.class))
          return "images/behaviour/tasks/PlayAnim16.png";
	
        if (userObject.getClass().equals(SymptomChangedEvent.class))
          return "images/profiles/DiseaseProfile/events/SymptomChangeEvent16.png";
	
        if (userObject.getClass().equals(Bridge.class))
          return "images/mBridge.png";
	
        if (userObject.getClass().equals(EMobileDevice.class))
          return "images/mEMobileDevice.png";
	
        if (userObject.getClass().equals(FOSink.class))
          return "images/objects/KitchenSink16.png";
	
        if (userObject.getClass().equals(CProb.class))
          return "images/conditions/CProb16.png";
	
        if (userObject.getClass().equals(EWaterBottle.class))
          return "images/mEWaterBottle.png";
	
        if (userObject.getClass().equals(BENewObjInFieldOfVision.class))
          return "images/mBENewObjInFieldOfVision.png";
	
        if (userObject.getClass().equals(SBathroom.class))
          return "images/space/bathroom16.png";
	
        if (userObject.getClass().equals(Crutch.class))
          return "images/objects/Crutch16.png";
	
        if (userObject.getClass().equals(Staircase.class))
          return "images/space/staircase16.png";
	
        if (userObject.getClass().equals(FChangeTargetObjFilter.class))
          return "images/profiles/filter/ChangeTargetObj16.png";
	
        if (userObject.getClass().equals(SBedroom.class))
          return "images/space/bedroom16.png";
	
        if (userObject.getClass().equals(AEDiv.class))
          return "images/mAEDiv.png";
	
        if (userObject.getClass().equals(VibrateEvent.class))
          return "images/behaviour/events/VibrateEvent16.png";
	
        if (userObject.getClass().equals(WearableVar.class))
          return "images/vars/WearableVar16.png";
	
        if (userObject.getClass().equals(DoorStateCondition.class))
          return "images/conditions/DoorState16.png";
	
        if (userObject.getClass().equals(WaitForBodyClose.class))
          return "images/behaviour/tasks/WaitForBodyClose16.png";
	
        if (userObject.getClass().equals(BPickUpTask.class))
          return "images/behaviour/tasks/PickUp16.png";
	
        if (userObject.getClass().equals(Doorbell.class))
          return "images/mDoorbell.png";
	
        if (userObject.getClass().equals(SArea.class))
          return "images/space/area16.png";
	
        if (userObject.getClass().equals(CloseTask.class))
          return "images/behaviour/tasks/Close16.png";
	
        if (userObject.getClass().equals(PartOfBody.class))
          return "images/entities/PartsOfBody16.png";
	
        if (userObject.getClass().equals(LightStateCondition.class))
          return "images/conditions/LightState16.png";
	
        if (userObject.getClass().equals(PrimitiveVar.class))
          return "images/vars/PrimitiveVar16.png";
	
        if (userObject.getClass().equals(AEAddSub.class))
          return "images/mAEAddSub.png";
	
        if (userObject.getClass().equals(FSofa.class))
          return "images/objects/Sofa16.png";
	
        if (userObject.getClass().equals(EPublicEvent.class))
          return "images/mEPublicEvent.png";
	
        if (userObject.getClass().equals(PutOnTask.class))
          return "images/behaviour/tasks/PutOn16.png";
	
        if (userObject.getClass().equals(SFloor.class))
          return "images/space/floor16.png";
	
        if (userObject.getClass().equals(HIGHSympLevelState.class))
          return "images/profiles/DiseaseProfile/HIGHSympLevelState16.png";
	
        if (userObject.getClass().equals(AEInv.class))
          return "images/mAEInv.png";
	
        if (userObject.getClass().equals(EMobileObject.class))
          return "images/mEMobileObject.png";
	
        if (userObject.getClass().equals(SayTask.class))
          return "images/behaviour/tasks/Say16.png";
	
        if (userObject.getClass().equals(HearingEvent.class))
          return "images/mHearingEvent.png";
	
        if (userObject.getClass().equals(BEObjOutFielOfVision.class))
          return "images/mBEObjOutFielOfVision.png";
	
        if (userObject.getClass().equals(ERemoteControl.class))
          return "images/mERemoteControl.png";
	
        if (userObject.getClass().equals(SymptomLevelState.class))
          return "images/mSymptomLevelState.png";
	
        if (userObject.getClass().equals(EMobileFurniture.class))
          return "images/mEMobileFurniture.png";
	
        if (userObject.getClass().equals(Param.class))
          return "images/mParam.png";
	
        if (userObject.getClass().equals(MessageListenedEvent.class))
          return "images/behaviour/events/MessageListenedEvent16.png";
	
        if (userObject.getClass().equals(SDate.class))
          return "images/time/Date16.png";
	
        if (userObject.getClass().equals(BUseTask.class))
          return "images/behaviour/tasks/UseTask16.png";
	
        if (userObject.getClass().equals(BodyEvent.class))
          return "images/mBodyEvent.png";
	
        if (userObject.getClass().equals(CompCondition.class))
          return "images/mCompCondition.png";
	
        if (userObject.getClass().equals(Trousers.class))
          return "images/mTrousers.png";
	
        if (userObject.getClass().equals(FallingEvent.class))
          return "images/profiles/DiseaseProfile/events/FallingEvent16.png";
	
        if (userObject.getClass().equals(EFixedDevice.class))
          return "images/mEFixedDevice.png";
	
        if (userObject.getClass().equals(Condition.class))
          return "images/mCondition.png";
	
        if (userObject.getClass().equals(CReceiveHelp.class))
          return "images/conditions/ReceiveHelp16.png";
	
        if (userObject.getClass().equals(WearableParam.class))
          return "images/params/WearableParam16.png";
	
        if (userObject.getClass().equals(WashMachine.class))
          return "images/mWashMachine.png";
	
        if (userObject.getClass().equals(FlyCamInit.class))
          return "images/sim/ScreenAndCamPos16.png";
	
        if (userObject.getClass().equals(VibrateDeviceAction.class))
          return "images/behaviour/devices/VibrateAction16.png";
	
        if (userObject.getClass().equals(Appliance.class))
          return "images/mAppliance.png";
	
        if (userObject.getClass().equals(MedInjection.class))
          return "images/profiles/DiseaseProfile/MedInjection16.png";
	
        if (userObject.getClass().equals(ADLProfile.class))
          return "images/profiles/ADLProfile16.png";
	
        if (userObject.getClass().equals(DTV.class))
          return "images/mDTV.png";
	
        if (userObject.getClass().equals(BSimpleTask.class))
          return "images/mBSimpleTask.png";
	
        if (userObject.getClass().equals(EWearable.class))
          return "images/mEWearable.png";
	
        if (userObject.getClass().equals(DeviceParam.class))
          return "images/params/DeviceParam16.png";
	
        if (userObject.getClass().equals(EMedicine.class))
          return "images/mEMedicine.png";
	
        if (userObject.getClass().equals(AENumConst.class))
          return "images/mAENumConst.png";
	
        if (userObject.getClass().equals(LOWTaskFilterR.class))
          return "images/profiles/filter/LOWTaskFilterR16.png";
	
        if (userObject.getClass().equals(TakeOffTask.class))
          return "images/behaviour/tasks/TakeOff16.png";
	
        if (userObject.getClass().equals(EatableItem.class))
          return "images/mEatableItem.png";
	
        if (userObject.getClass().equals(EPhysicalEntity.class))
          return "images/mEPhysicalEntity.png";
	
        if (userObject.getClass().equals(SocialProfile.class))
          return "images/profiles/SocialProfile16.png";
	
        if (userObject.getClass().equals(NotCondition.class))
          return "images/conditions/NotCondition16.png";
	
        if (userObject.getClass().equals(BEObjectMoving.class))
          return "images/mBEObjectMoving.png";
	
        if (userObject.getClass().equals(DropObj.class))
          return "images/behaviour/tasks/ObjDropped16.png";
	
        if (userObject.getClass().equals(EFixedObject.class))
          return "images/mEFixedObject.png";
	
        if (userObject.getClass().equals(IsThingInRoomCondition.class))
          return "images/conditions/ObjLoc16.png";
	
        if (userObject.getClass().equals(PlaceParam.class))
          return "images/params/PlaceParam16.png";
	
        if (userObject.getClass().equals(CTimer.class))
          return "images/conditions/CTimer16.png";
	
        if (userObject.getClass().equals(Human.class))
          return "images/entities/Human16.png";
	
        if (userObject.getClass().equals(CInside.class))
          return "images/conditions/inside16.png";
	
        if (userObject.getClass().equals(AEMult.class))
          return "images/mAEMult.png";
	
        if (userObject.getClass().equals(VisionEvent.class))
          return "images/mVisionEvent.png";
	
        if (userObject.getClass().equals(SeatParam.class))
          return "images/params/SeatParam16.png";
	
        if (userObject.getClass().equals(EASubSubSub.class))
          return "images/mEASubSubSub.png";
	
        if (userObject.getClass().equals(ELivingBeing.class))
          return "images/mELivingBeing.png";
	
        if (userObject.getClass().equals(SwitchLightTask.class))
          return "images/behaviour/tasks/PressSwitch16.png";
	
        if (userObject.getClass().equals(SpatialVar.class))
          return "images/vars/SpatialVar16.png";
	
        if (userObject.getClass().equals(Lift.class))
          return "images/space/lift16.png";
	
        if (userObject.getClass().equals(StandUp.class))
          return "images/behaviour/tasks/StandUp16.png";
	
        if (userObject.getClass().equals(FallTask.class))
          return "images/behaviour/tasks/Fall16.png";
	
        if (userObject.getClass().equals(EPrivateEvent.class))
          return "images/mEPrivateEvent.png";
	
        if (userObject.getClass().equals(NONESympLevelState.class))
          return "images/profiles/DiseaseProfile/NONESympLevelState16.png";
	
        if (userObject.getClass().equals(MEDIUMTaskFilterR.class))
          return "images/profiles/filter/MEDIUMTaskFilterR16.png";
	
        if (userObject.getClass().equals(GoToBodyLoc.class))
          return "images/behaviour/tasks/GoToBodyLoc16.png";
	
        if (userObject.getClass().equals(TaskFilterRef.class))
          return "images/mTaskFilterRef.png";
	
        if (userObject.getClass().equals(GoIntoBed.class))
          return "images/behaviour/tasks/GoIntoBed16.png";
	
        if (userObject.getClass().equals(AEVariable.class))
          return "images/mAEVariable.png";
	
        if (userObject.getClass().equals(FTaskSelectorFilter.class))
          return "images/profiles/filter/TaskSelectorFilter16.png";
	
        if (userObject.getClass().equals(BSimpleDurationTask.class))
          return "images/mBSimpleDurationTask.png";
	
        if (userObject.getClass().equals(Walker.class))
          return "images/objects/Walker16.png";
	
        if (userObject.getClass().equals(OpenTask.class))
          return "images/behaviour/tasks/Open16.png";
	
        if (userObject.getClass().equals(SCorridor.class))
          return "images/space/corridor16.png";
	
        if (userObject.getClass().equals(FModifyPlaceFilter.class))
          return "images/profiles/filter/ChangePlace16.png";
	
        if (userObject.getClass().equals(FTable.class))
          return "images/objects/Table16.png";
	
        if (userObject.getClass().equals(DrinkItem.class))
          return "images/mDrinkItem.png";
	
        if (userObject.getClass().equals(FallSleep.class))
          return "images/behaviour/tasks/FallSleepTask16.png";
	
        if (userObject.getClass().equals(BActivity.class))
          return "images/behaviour/activities/Activity16.png";
	
        if (userObject.getClass().equals(AnotherActionHappens.class))
          return "images/mAnotherActionHappens.png";
	
        if (userObject.getClass().equals(WaitTask.class))
          return "images/behaviour/tasks/Wait16.png";
	
        if (userObject.getClass().equals(HumanParam.class))
          return "images/params/HumanParam16.png";
	
        if (userObject.getClass().equals(BEvent.class))
          return "images/behaviour/events/event16.png";
	
        if (userObject.getClass().equals(BDeviceAction.class))
          return "images/mBDeviceAction.png";
	
        if (userObject.getClass().equals(FChair.class))
          return "images/objects/Chair16.png";
	
        if (userObject.getClass().equals(SLivingroom.class))
          return "images/space/livingroom16.png";
	
        if (userObject.getClass().equals(DeviceEvent.class))
          return "images/mDeviceEvent.png";
	
        if (userObject.getClass().equals(TimeInterval.class))
          return "images/profiles/ADLProfile/timeInterval16.png";
	
        if (userObject.getClass().equals(IncomingCallAction.class))
          return "images/behaviour/devices/IncomingCallAction16.png";
	
        if (userObject.getClass().equals(PresenceSensorStateCondition.class))
          return "images/conditions/PresenceSensorState16.png";
	
        if (userObject.getClass().equals(SRoom.class))
          return "images/mSRoom.png";
	
        if (userObject.getClass().equals(MEDIUMSympLevelState.class))
          return "images/profiles/DiseaseProfile/MEDIUMSympLevelState16.png";
	
        if (userObject.getClass().equals(BodyStateCondition.class))
          return "images/conditions/BodyState16.png";
	
        if (userObject.getClass().equals(EBehaviourEvent.class))
          return "images/mEBehaviourEvent.png";
	
        if (userObject.getClass().equals(FReplaceTaskFilter.class))
          return "images/profiles/filter/ReplaceTaskFilter16.png";
	
        if (userObject.getClass().equals(BTask.class))
          return "images/mBTask.png";
	
        if (userObject.getClass().equals(LOWSympLevelState.class))
          return "images/profiles/DiseaseProfile/LOWSympLevelState16.png";
	
        if (userObject.getClass().equals(FUnableFilter.class))
          return "images/profiles/filter/FUnableFilter16.png";
	
        if (userObject.getClass().equals(FChangeToolFilter.class))
          return "images/profiles/filter/ChangeToolFilter16.png";
	
        if (userObject.getClass().equals(AESub.class))
          return "images/mAESub.png";
	
        if (userObject.getClass().equals(HumanVar.class))
          return "images/vars/HumanVar16.png";
	
        if (userObject.getClass().equals(AESubSub.class))
          return "images/mAESubSub.png";
	
        if (userObject.getClass().equals(CSymptom.class))
          return "images/profiles/DiseaseProfile/CSymptom16.png";
	
        if (userObject.getClass().equals(ParkinsonsProfile.class))
          return "images/profiles/PDProfile16.png";
	
        if (userObject.getClass().equals(EventProcessor.class))
          return "images/profiles/InteractionProfile/EventProcessor16.png";
	
        if (userObject.getClass().equals(ObjectParam.class))
          return "images/params/ObjectParam16.png";
	
        if (userObject.getClass().equals(FSeat.class))
          return "images/mFSeat.png";
	
        if (userObject.getClass().equals(BLeaveTask.class))
          return "images/behaviour/tasks/Leave16.png";
	
        if (userObject.getClass().equals(CDayOfTheWeek.class))
          return "images/conditions/CDayOfTheDay16.png";
	
        if (userObject.getClass().equals(PrimitiveParam.class))
          return "images/params/PrimitiveParam16.png";
	
        if (userObject.getClass().equals(CallStateEvent.class))
          return "images/behaviour/events/CallState16.png";
	
        if (userObject.getClass().equals(SKitchen.class))
          return "images/space/kitchen16.png";
	
        if (userObject.getClass().equals(FOWater.class))
          return "images/objects/wc16.png";
	
        if (userObject.getClass().equals(Eat.class))
          return "images/behaviour/tasks/Eat16.png";
	
        if (userObject.getClass().equals(TouchEvent.class))
          return "images/mTouchEvent.png";
	
        if (userObject.getClass().equals(Shocks.class))
          return "images/mShocks.png";
	
        if (userObject.getClass().equals(BSequentialTask.class))
          return "images/behaviour/tasks/CTSequential16.png";
	
        if (userObject.getClass().equals(InitProgramPool.class))
          return "images/sim/ProgramDeviceInitialization16.png";
	
        if (userObject.getClass().equals(StartBehaviourEvent.class))
          return "images/behaviour/events/StartBehaviourEvent16.png";
	
        if (userObject.getClass().equals(HumanInitialization.class))
          return "images/sim/HumanInitialization16.png";
	
        if (userObject.getClass().equals(Behaviour.class))
          return "images/mBehaviour.png";
	
        if (userObject.getClass().equals(BEVibration.class))
          return "images/mBEVibration.png";
	
        if (userObject.getClass().equals(CTime.class))
          return "images/conditions/CTime16.png";
	
        if (userObject.getClass().equals(ConsecutiveActions.class))
          return "images/mConsecutiveActions.png";
	
        if (userObject.getClass().equals(DiseaseStage.class))
          return "images/profiles/DiseaseProfile/GStage16.png";
	
        if (userObject.getClass().equals(AndroidApplication.class))
          return "images/devices/AndroidApp16.png";
	
        if (userObject.getClass().equals(AEAddition.class))
          return "images/mAEAddition.png";
	
        if (userObject.getClass().equals(BRandomTask.class))
          return "images/behaviour/tasks/CTRandom16.png";
	
        if (userObject.getClass().equals(SitDown.class))
          return "images/behaviour/tasks/SitDown16.png";
	
        if (userObject.getClass().equals(SocialNetwork.class))
          return "images/profiles/SocialProfile/socialnetwork16.png";
	
        if (userObject.getClass().equals(CEvent.class))
          return "images/conditions/CEvent16.png";
	
        if (userObject.getClass().equals(InitialPreDefPos.class))
          return "images/sim/PreDefPos16.png";
	
        if (userObject.getClass().equals(ClockTime.class))
          return "images/time/ClockTime16.png";
	
        if (userObject.getClass().equals(AEMulDiv.class))
          return "images/mAEMulDiv.png";
	
        if (userObject.getClass().equals(FModifyFilter.class))
          return "images/mFModifyFilter.png";
	
        if (userObject.getClass().equals(InteractionProfile.class))
          return "images/profiles/InteractionProfile16.png";
	
        if (userObject.getClass().equals(TapXYTask.class))
          return "images/behaviour/tasks/TapXY16.png";
	
        if (userObject.getClass().equals(CameraInit.class))
          return "images/sim/VideoCameraInit16.png";
	
        if (userObject.getClass().equals(MedIntake.class))
          return "images/profiles/DiseaseProfile/MedIntake16.png";
	
        if (userObject.getClass().equals(BWakeUpTask.class))
          return "images/behaviour/tasks/WakeUp16.png";
	
        if (userObject.getClass().equals(HIGHTaskFilterR.class))
          return "images/profiles/filter/HIGHTaskFilterR16.png";
	
        if (userObject.getClass().equals(FTaskFilter.class))
          return "images/mFTaskFilter.png";
	
        if (userObject.getClass().equals(Medication.class))
          return "images/profiles/DiseaseProfile/Medication16.png";
	
        if (userObject.getClass().equals(BCompTask.class))
          return "images/mBCompTask.png";
	
        if (userObject.getClass().equals(TextToSpeachAction.class))
          return "images/behaviour/devices/TTSAction16.png";
	
        if (userObject.getClass().equals(ESleepers.class))
          return "images/mESleepers.png";
	
        if (userObject.getClass().equals(MedicationTime.class))
          return "images/profiles/DiseaseProfile/MedicationTime16.png";
	
        if (userObject.getClass().equals(PDDiseaseStage.class))
          return "images/profiles/DiseaseProfile/PDStage16.png";
	
        if (userObject.getClass().equals(ESmartPhone.class))
          return "images/devices/Smartphone16.png";
	
        if (userObject.getClass().equals(Pyjamas.class))
          return "images/mPyjamas.png";
	
        if (userObject.getClass().equals(GSymptom.class))
          return "images/profiles/DiseaseProfile/Symptom16.png";
	
        if (userObject.getClass().equals(EMobilePhysicalEntity.class))
          return "images/mEMobilePhysicalEntity.png";
	
        if (userObject.getClass().equals(Drink.class))
          return "images/behaviour/tasks/Drink16.png";
	
        if (userObject.getClass().equals(WalkingHelper.class))
          return "images/mWalkingHelper.png";
	
        if (userObject.getClass().equals(SBuilding.class))
          return "images/space/building16.png";
	
        if (userObject.getClass().equals(EFixedFurniture.class))
          return "images/mEFixedFurniture.png";
	
        if (userObject.getClass().equals(BGoToTask.class))
          return "images/behaviour/tasks/GoToTask16.png";
	
        if (userObject.getClass().equals(SymptomInitialization.class))
          return "images/profiles/DiseaseProfile/SymptomInitialization16.png";
	
        if (userObject.getClass().equals(AESubtraction.class))
          return "images/mAESubtraction.png";
	
        if (userObject.getClass().equals(COutside.class))
          return "images/conditions/outside16.png";
	
        if (userObject.getClass().equals(ObjDroppedEvent.class))
          return "images/profiles/DiseaseProfile/events/ObjDroppedEvent16.png";
	
        if (userObject.getClass().equals(FWardrobe.class))
          return "images/objects/Wardrobe16.png";
	
        if (userObject.getClass().equals(Profession.class))
          return "images/profiles/SocialProfile/Profession16.png";
	
        if (userObject.getClass().equals(IFFlowControl.class))
          return "images/behaviour/activities/ifFlowOperator16.png";
	
        if (userObject.getClass().equals(DFixedSensor.class))
          return "images/mDFixedSensor.png";
	
        if (userObject.getClass().equals(Cane.class))
          return "images/objects/Cane16.png";
	
        if (userObject.getClass().equals(ETool.class))
          return "images/mETool.png";
	
        if (userObject.getClass().equals(BEBodyCollision.class))
          return "images/mBEBodyCollision.png";
	
        if (userObject.getClass().equals(EClothing.class))
          return "images/mEClothing.png";
	
        if (userObject.getClass().equals(NormHoldingCondition.class))
          return "images/mNormHoldingCondition.png";
	
        if (userObject.getClass().equals(EFixedPhysicalEntity.class))
          return "images/mEFixedPhysicalEntity.png";
	


        if (userObject.getClass().equals(ingenias.editor.models.FilterDiagramModelJGraph.class))
            return "images/mFilterDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.GenericDiseaseSpecDiagModelJGraph.class))
            return "images/mGenericDiseaseSpecDiag.png";

        if (userObject.getClass().equals(ingenias.editor.models.BuildingDiagramModelJGraph.class))
            return "images/mBuildingDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.ActivityDiagramModelJGraph.class))
            return "images/mActivityDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.ADLSpecDiagramModelJGraph.class))
            return "images/mADLSpecDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.DeviceBehavoirDiagramModelJGraph.class))
            return "images/mDeviceBehavoirDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.InteractionDiagramModelJGraph.class))
            return "images/mInteractionDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.SimulationDiagramModelJGraph.class))
            return "images/mSimulationDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.SymptomEvolutionDiagramModelJGraph.class))
            return "images/mSymptomEvolutionDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.FloorSpecDiagramModelJGraph.class))
            return "images/mFloorSpecDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.DeviceDiagramModelJGraph.class))
            return "images/mDeviceDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.SocialSpecDiagramModelJGraph.class))
            return "images/mSocialSpecDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.RandomTaskDiagramModelJGraph.class))
            return "images/mRandomTaskDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.ParkinsonSpecDiagramModelJGraph.class))
            return "images/mParkinsonSpecDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.ArithmeticDiagram1ModelJGraph.class))
            return "images/mArithmeticDiagram1.png";

        if (userObject.getClass().equals(ingenias.editor.models.HumanProfileSpecDiagramModelJGraph.class))
            return "images/mHumanProfileSpecDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.MedicationTimeDiagramModelJGraph.class))
            return "images/mMedicationTimeDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.RoomSpecDiagramModelJGraph.class))
            return "images/mRoomSpecDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.SequentialTaskDiagramModelJGraph.class))
            return "images/mSequentialTaskDiagram.png";

        if (userObject.getClass().equals(ingenias.editor.models.NormDefinitionModelJGraph.class))
            return "images/mNormDefinition.png";

        return null;
    }

    public static ImageIcon selectIconByUserObject(Object userObject) {
   
	if (userObject.getClass().equals(String.class))
			return ConventionalFolderIcon;


	
        if (userObject.getClass().equals(Dishwasher.class))
          return DishwasherIcon;
	
        if (userObject.getClass().equals(PerceptionEvent.class))
          return PerceptionEventIcon;
	
        if (userObject.getClass().equals(DeviceVar.class))
          return DeviceVarIcon;
	
        if (userObject.getClass().equals(ArithmeticExpression.class))
          return ArithmeticExpressionIcon;
	
        if (userObject.getClass().equals(SwitchLightAction.class))
          return SwitchLightActionIcon;
	
        if (userObject.getClass().equals(SeatVar.class))
          return SeatVarIcon;
	
        if (userObject.getClass().equals(Shower.class))
          return ShowerIcon;
	
        if (userObject.getClass().equals(ProgramState.class))
          return ProgramStateIcon;
	
        if (userObject.getClass().equals(FOWashbasin.class))
          return FOWashbasinIcon;
	
        if (userObject.getClass().equals(FDelayFilter.class))
          return FDelayFilterIcon;
	
        if (userObject.getClass().equals(CObjWeight.class))
          return CObjWeightIcon;
	
        if (userObject.getClass().equals(Var.class))
          return VarIcon;
	
        if (userObject.getClass().equals(WorldInitialization.class))
          return WorldInitializationIcon;
	
        if (userObject.getClass().equals(HumanProfile.class))
          return HumanProfileIcon;
	
        if (userObject.getClass().equals(FOBath.class))
          return FOBathIcon;
	
        if (userObject.getClass().equals(PDSymtom.class))
          return PDSymtomIcon;
	
        if (userObject.getClass().equals(HumanNorm.class))
          return HumanNormIcon;
	
        if (userObject.getClass().equals(DiseaseProfile.class))
          return DiseaseProfileIcon;
	
        if (userObject.getClass().equals(BGetUpFromBed.class))
          return BGetUpFromBedIcon;
	
        if (userObject.getClass().equals(GenericDisease.class))
          return GenericDiseaseIcon;
	
        if (userObject.getClass().equals(CSay.class))
          return CSayIcon;
	
        if (userObject.getClass().equals(SwipeTask.class))
          return SwipeTaskIcon;
	
        if (userObject.getClass().equals(StopBehaviourEvent.class))
          return StopBehaviourEventIcon;
	
        if (userObject.getClass().equals(SVerticalSpace.class))
          return SVerticalSpaceIcon;
	
        if (userObject.getClass().equals(PersonalInfo.class))
          return PersonalInfoIcon;
	
        if (userObject.getClass().equals(CAlways.class))
          return CAlwaysIcon;
	
        if (userObject.getClass().equals(ObjectVar.class))
          return ObjectVarIcon;
	
        if (userObject.getClass().equals(MedsTakenEvent.class))
          return MedsTakenEventIcon;
	
        if (userObject.getClass().equals(Extractor.class))
          return ExtractorIcon;
	
        if (userObject.getClass().equals(SSpatial.class))
          return SSpatialIcon;
	
        if (userObject.getClass().equals(FBed.class))
          return FBedIcon;
	
        if (userObject.getClass().equals(BECollision.class))
          return BECollisionIcon;
	
        if (userObject.getClass().equals(SociAALEntity.class))
          return SociAALEntityIcon;
	
        if (userObject.getClass().equals(DComputer.class))
          return DComputerIcon;
	
        if (userObject.getClass().equals(Shirt.class))
          return ShirtIcon;
	
        if (userObject.getClass().equals(Shoes.class))
          return ShoesIcon;
	
        if (userObject.getClass().equals(AndroidEmulator.class))
          return AndroidEmulatorIcon;
	
        if (userObject.getClass().equals(PlayAnimationTask.class))
          return PlayAnimationTaskIcon;
	
        if (userObject.getClass().equals(SymptomChangedEvent.class))
          return SymptomChangedEventIcon;
	
        if (userObject.getClass().equals(Bridge.class))
          return BridgeIcon;
	
        if (userObject.getClass().equals(EMobileDevice.class))
          return EMobileDeviceIcon;
	
        if (userObject.getClass().equals(FOSink.class))
          return FOSinkIcon;
	
        if (userObject.getClass().equals(CProb.class))
          return CProbIcon;
	
        if (userObject.getClass().equals(EWaterBottle.class))
          return EWaterBottleIcon;
	
        if (userObject.getClass().equals(BENewObjInFieldOfVision.class))
          return BENewObjInFieldOfVisionIcon;
	
        if (userObject.getClass().equals(SBathroom.class))
          return SBathroomIcon;
	
        if (userObject.getClass().equals(Crutch.class))
          return CrutchIcon;
	
        if (userObject.getClass().equals(Staircase.class))
          return StaircaseIcon;
	
        if (userObject.getClass().equals(FChangeTargetObjFilter.class))
          return FChangeTargetObjFilterIcon;
	
        if (userObject.getClass().equals(SBedroom.class))
          return SBedroomIcon;
	
        if (userObject.getClass().equals(AEDiv.class))
          return AEDivIcon;
	
        if (userObject.getClass().equals(VibrateEvent.class))
          return VibrateEventIcon;
	
        if (userObject.getClass().equals(WearableVar.class))
          return WearableVarIcon;
	
        if (userObject.getClass().equals(DoorStateCondition.class))
          return DoorStateConditionIcon;
	
        if (userObject.getClass().equals(WaitForBodyClose.class))
          return WaitForBodyCloseIcon;
	
        if (userObject.getClass().equals(BPickUpTask.class))
          return BPickUpTaskIcon;
	
        if (userObject.getClass().equals(Doorbell.class))
          return DoorbellIcon;
	
        if (userObject.getClass().equals(SArea.class))
          return SAreaIcon;
	
        if (userObject.getClass().equals(CloseTask.class))
          return CloseTaskIcon;
	
        if (userObject.getClass().equals(PartOfBody.class))
          return PartOfBodyIcon;
	
        if (userObject.getClass().equals(LightStateCondition.class))
          return LightStateConditionIcon;
	
        if (userObject.getClass().equals(PrimitiveVar.class))
          return PrimitiveVarIcon;
	
        if (userObject.getClass().equals(AEAddSub.class))
          return AEAddSubIcon;
	
        if (userObject.getClass().equals(FSofa.class))
          return FSofaIcon;
	
        if (userObject.getClass().equals(EPublicEvent.class))
          return EPublicEventIcon;
	
        if (userObject.getClass().equals(PutOnTask.class))
          return PutOnTaskIcon;
	
        if (userObject.getClass().equals(SFloor.class))
          return SFloorIcon;
	
        if (userObject.getClass().equals(HIGHSympLevelState.class))
          return HIGHSympLevelStateIcon;
	
        if (userObject.getClass().equals(AEInv.class))
          return AEInvIcon;
	
        if (userObject.getClass().equals(EMobileObject.class))
          return EMobileObjectIcon;
	
        if (userObject.getClass().equals(SayTask.class))
          return SayTaskIcon;
	
        if (userObject.getClass().equals(HearingEvent.class))
          return HearingEventIcon;
	
        if (userObject.getClass().equals(BEObjOutFielOfVision.class))
          return BEObjOutFielOfVisionIcon;
	
        if (userObject.getClass().equals(ERemoteControl.class))
          return ERemoteControlIcon;
	
        if (userObject.getClass().equals(SymptomLevelState.class))
          return SymptomLevelStateIcon;
	
        if (userObject.getClass().equals(EMobileFurniture.class))
          return EMobileFurnitureIcon;
	
        if (userObject.getClass().equals(Param.class))
          return ParamIcon;
	
        if (userObject.getClass().equals(MessageListenedEvent.class))
          return MessageListenedEventIcon;
	
        if (userObject.getClass().equals(SDate.class))
          return SDateIcon;
	
        if (userObject.getClass().equals(BUseTask.class))
          return BUseTaskIcon;
	
        if (userObject.getClass().equals(BodyEvent.class))
          return BodyEventIcon;
	
        if (userObject.getClass().equals(CompCondition.class))
          return CompConditionIcon;
	
        if (userObject.getClass().equals(Trousers.class))
          return TrousersIcon;
	
        if (userObject.getClass().equals(FallingEvent.class))
          return FallingEventIcon;
	
        if (userObject.getClass().equals(EFixedDevice.class))
          return EFixedDeviceIcon;
	
        if (userObject.getClass().equals(Condition.class))
          return ConditionIcon;
	
        if (userObject.getClass().equals(CReceiveHelp.class))
          return CReceiveHelpIcon;
	
        if (userObject.getClass().equals(WearableParam.class))
          return WearableParamIcon;
	
        if (userObject.getClass().equals(WashMachine.class))
          return WashMachineIcon;
	
        if (userObject.getClass().equals(FlyCamInit.class))
          return FlyCamInitIcon;
	
        if (userObject.getClass().equals(VibrateDeviceAction.class))
          return VibrateDeviceActionIcon;
	
        if (userObject.getClass().equals(Appliance.class))
          return ApplianceIcon;
	
        if (userObject.getClass().equals(MedInjection.class))
          return MedInjectionIcon;
	
        if (userObject.getClass().equals(ADLProfile.class))
          return ADLProfileIcon;
	
        if (userObject.getClass().equals(DTV.class))
          return DTVIcon;
	
        if (userObject.getClass().equals(BSimpleTask.class))
          return BSimpleTaskIcon;
	
        if (userObject.getClass().equals(EWearable.class))
          return EWearableIcon;
	
        if (userObject.getClass().equals(DeviceParam.class))
          return DeviceParamIcon;
	
        if (userObject.getClass().equals(EMedicine.class))
          return EMedicineIcon;
	
        if (userObject.getClass().equals(AENumConst.class))
          return AENumConstIcon;
	
        if (userObject.getClass().equals(LOWTaskFilterR.class))
          return LOWTaskFilterRIcon;
	
        if (userObject.getClass().equals(TakeOffTask.class))
          return TakeOffTaskIcon;
	
        if (userObject.getClass().equals(EatableItem.class))
          return EatableItemIcon;
	
        if (userObject.getClass().equals(EPhysicalEntity.class))
          return EPhysicalEntityIcon;
	
        if (userObject.getClass().equals(SocialProfile.class))
          return SocialProfileIcon;
	
        if (userObject.getClass().equals(NotCondition.class))
          return NotConditionIcon;
	
        if (userObject.getClass().equals(BEObjectMoving.class))
          return BEObjectMovingIcon;
	
        if (userObject.getClass().equals(DropObj.class))
          return DropObjIcon;
	
        if (userObject.getClass().equals(EFixedObject.class))
          return EFixedObjectIcon;
	
        if (userObject.getClass().equals(IsThingInRoomCondition.class))
          return IsThingInRoomConditionIcon;
	
        if (userObject.getClass().equals(PlaceParam.class))
          return PlaceParamIcon;
	
        if (userObject.getClass().equals(CTimer.class))
          return CTimerIcon;
	
        if (userObject.getClass().equals(Human.class))
          return HumanIcon;
	
        if (userObject.getClass().equals(CInside.class))
          return CInsideIcon;
	
        if (userObject.getClass().equals(AEMult.class))
          return AEMultIcon;
	
        if (userObject.getClass().equals(VisionEvent.class))
          return VisionEventIcon;
	
        if (userObject.getClass().equals(SeatParam.class))
          return SeatParamIcon;
	
        if (userObject.getClass().equals(EASubSubSub.class))
          return EASubSubSubIcon;
	
        if (userObject.getClass().equals(ELivingBeing.class))
          return ELivingBeingIcon;
	
        if (userObject.getClass().equals(SwitchLightTask.class))
          return SwitchLightTaskIcon;
	
        if (userObject.getClass().equals(SpatialVar.class))
          return SpatialVarIcon;
	
        if (userObject.getClass().equals(Lift.class))
          return LiftIcon;
	
        if (userObject.getClass().equals(StandUp.class))
          return StandUpIcon;
	
        if (userObject.getClass().equals(FallTask.class))
          return FallTaskIcon;
	
        if (userObject.getClass().equals(EPrivateEvent.class))
          return EPrivateEventIcon;
	
        if (userObject.getClass().equals(NONESympLevelState.class))
          return NONESympLevelStateIcon;
	
        if (userObject.getClass().equals(MEDIUMTaskFilterR.class))
          return MEDIUMTaskFilterRIcon;
	
        if (userObject.getClass().equals(GoToBodyLoc.class))
          return GoToBodyLocIcon;
	
        if (userObject.getClass().equals(TaskFilterRef.class))
          return TaskFilterRefIcon;
	
        if (userObject.getClass().equals(GoIntoBed.class))
          return GoIntoBedIcon;
	
        if (userObject.getClass().equals(AEVariable.class))
          return AEVariableIcon;
	
        if (userObject.getClass().equals(FTaskSelectorFilter.class))
          return FTaskSelectorFilterIcon;
	
        if (userObject.getClass().equals(BSimpleDurationTask.class))
          return BSimpleDurationTaskIcon;
	
        if (userObject.getClass().equals(Walker.class))
          return WalkerIcon;
	
        if (userObject.getClass().equals(OpenTask.class))
          return OpenTaskIcon;
	
        if (userObject.getClass().equals(SCorridor.class))
          return SCorridorIcon;
	
        if (userObject.getClass().equals(FModifyPlaceFilter.class))
          return FModifyPlaceFilterIcon;
	
        if (userObject.getClass().equals(FTable.class))
          return FTableIcon;
	
        if (userObject.getClass().equals(DrinkItem.class))
          return DrinkItemIcon;
	
        if (userObject.getClass().equals(FallSleep.class))
          return FallSleepIcon;
	
        if (userObject.getClass().equals(BActivity.class))
          return BActivityIcon;
	
        if (userObject.getClass().equals(AnotherActionHappens.class))
          return AnotherActionHappensIcon;
	
        if (userObject.getClass().equals(WaitTask.class))
          return WaitTaskIcon;
	
        if (userObject.getClass().equals(HumanParam.class))
          return HumanParamIcon;
	
        if (userObject.getClass().equals(BEvent.class))
          return BEventIcon;
	
        if (userObject.getClass().equals(BDeviceAction.class))
          return BDeviceActionIcon;
	
        if (userObject.getClass().equals(FChair.class))
          return FChairIcon;
	
        if (userObject.getClass().equals(SLivingroom.class))
          return SLivingroomIcon;
	
        if (userObject.getClass().equals(DeviceEvent.class))
          return DeviceEventIcon;
	
        if (userObject.getClass().equals(TimeInterval.class))
          return TimeIntervalIcon;
	
        if (userObject.getClass().equals(IncomingCallAction.class))
          return IncomingCallActionIcon;
	
        if (userObject.getClass().equals(PresenceSensorStateCondition.class))
          return PresenceSensorStateConditionIcon;
	
        if (userObject.getClass().equals(SRoom.class))
          return SRoomIcon;
	
        if (userObject.getClass().equals(MEDIUMSympLevelState.class))
          return MEDIUMSympLevelStateIcon;
	
        if (userObject.getClass().equals(BodyStateCondition.class))
          return BodyStateConditionIcon;
	
        if (userObject.getClass().equals(EBehaviourEvent.class))
          return EBehaviourEventIcon;
	
        if (userObject.getClass().equals(FReplaceTaskFilter.class))
          return FReplaceTaskFilterIcon;
	
        if (userObject.getClass().equals(BTask.class))
          return BTaskIcon;
	
        if (userObject.getClass().equals(LOWSympLevelState.class))
          return LOWSympLevelStateIcon;
	
        if (userObject.getClass().equals(FUnableFilter.class))
          return FUnableFilterIcon;
	
        if (userObject.getClass().equals(FChangeToolFilter.class))
          return FChangeToolFilterIcon;
	
        if (userObject.getClass().equals(AESub.class))
          return AESubIcon;
	
        if (userObject.getClass().equals(HumanVar.class))
          return HumanVarIcon;
	
        if (userObject.getClass().equals(AESubSub.class))
          return AESubSubIcon;
	
        if (userObject.getClass().equals(CSymptom.class))
          return CSymptomIcon;
	
        if (userObject.getClass().equals(ParkinsonsProfile.class))
          return ParkinsonsProfileIcon;
	
        if (userObject.getClass().equals(EventProcessor.class))
          return EventProcessorIcon;
	
        if (userObject.getClass().equals(ObjectParam.class))
          return ObjectParamIcon;
	
        if (userObject.getClass().equals(FSeat.class))
          return FSeatIcon;
	
        if (userObject.getClass().equals(BLeaveTask.class))
          return BLeaveTaskIcon;
	
        if (userObject.getClass().equals(CDayOfTheWeek.class))
          return CDayOfTheWeekIcon;
	
        if (userObject.getClass().equals(PrimitiveParam.class))
          return PrimitiveParamIcon;
	
        if (userObject.getClass().equals(CallStateEvent.class))
          return CallStateEventIcon;
	
        if (userObject.getClass().equals(SKitchen.class))
          return SKitchenIcon;
	
        if (userObject.getClass().equals(FOWater.class))
          return FOWaterIcon;
	
        if (userObject.getClass().equals(Eat.class))
          return EatIcon;
	
        if (userObject.getClass().equals(TouchEvent.class))
          return TouchEventIcon;
	
        if (userObject.getClass().equals(Shocks.class))
          return ShocksIcon;
	
        if (userObject.getClass().equals(BSequentialTask.class))
          return BSequentialTaskIcon;
	
        if (userObject.getClass().equals(InitProgramPool.class))
          return InitProgramPoolIcon;
	
        if (userObject.getClass().equals(StartBehaviourEvent.class))
          return StartBehaviourEventIcon;
	
        if (userObject.getClass().equals(HumanInitialization.class))
          return HumanInitializationIcon;
	
        if (userObject.getClass().equals(Behaviour.class))
          return BehaviourIcon;
	
        if (userObject.getClass().equals(BEVibration.class))
          return BEVibrationIcon;
	
        if (userObject.getClass().equals(CTime.class))
          return CTimeIcon;
	
        if (userObject.getClass().equals(ConsecutiveActions.class))
          return ConsecutiveActionsIcon;
	
        if (userObject.getClass().equals(DiseaseStage.class))
          return DiseaseStageIcon;
	
        if (userObject.getClass().equals(AndroidApplication.class))
          return AndroidApplicationIcon;
	
        if (userObject.getClass().equals(AEAddition.class))
          return AEAdditionIcon;
	
        if (userObject.getClass().equals(BRandomTask.class))
          return BRandomTaskIcon;
	
        if (userObject.getClass().equals(SitDown.class))
          return SitDownIcon;
	
        if (userObject.getClass().equals(SocialNetwork.class))
          return SocialNetworkIcon;
	
        if (userObject.getClass().equals(CEvent.class))
          return CEventIcon;
	
        if (userObject.getClass().equals(InitialPreDefPos.class))
          return InitialPreDefPosIcon;
	
        if (userObject.getClass().equals(ClockTime.class))
          return ClockTimeIcon;
	
        if (userObject.getClass().equals(AEMulDiv.class))
          return AEMulDivIcon;
	
        if (userObject.getClass().equals(FModifyFilter.class))
          return FModifyFilterIcon;
	
        if (userObject.getClass().equals(InteractionProfile.class))
          return InteractionProfileIcon;
	
        if (userObject.getClass().equals(TapXYTask.class))
          return TapXYTaskIcon;
	
        if (userObject.getClass().equals(CameraInit.class))
          return CameraInitIcon;
	
        if (userObject.getClass().equals(MedIntake.class))
          return MedIntakeIcon;
	
        if (userObject.getClass().equals(BWakeUpTask.class))
          return BWakeUpTaskIcon;
	
        if (userObject.getClass().equals(HIGHTaskFilterR.class))
          return HIGHTaskFilterRIcon;
	
        if (userObject.getClass().equals(FTaskFilter.class))
          return FTaskFilterIcon;
	
        if (userObject.getClass().equals(Medication.class))
          return MedicationIcon;
	
        if (userObject.getClass().equals(BCompTask.class))
          return BCompTaskIcon;
	
        if (userObject.getClass().equals(TextToSpeachAction.class))
          return TextToSpeachActionIcon;
	
        if (userObject.getClass().equals(ESleepers.class))
          return ESleepersIcon;
	
        if (userObject.getClass().equals(MedicationTime.class))
          return MedicationTimeIcon;
	
        if (userObject.getClass().equals(PDDiseaseStage.class))
          return PDDiseaseStageIcon;
	
        if (userObject.getClass().equals(ESmartPhone.class))
          return ESmartPhoneIcon;
	
        if (userObject.getClass().equals(Pyjamas.class))
          return PyjamasIcon;
	
        if (userObject.getClass().equals(GSymptom.class))
          return GSymptomIcon;
	
        if (userObject.getClass().equals(EMobilePhysicalEntity.class))
          return EMobilePhysicalEntityIcon;
	
        if (userObject.getClass().equals(Drink.class))
          return DrinkIcon;
	
        if (userObject.getClass().equals(WalkingHelper.class))
          return WalkingHelperIcon;
	
        if (userObject.getClass().equals(SBuilding.class))
          return SBuildingIcon;
	
        if (userObject.getClass().equals(EFixedFurniture.class))
          return EFixedFurnitureIcon;
	
        if (userObject.getClass().equals(BGoToTask.class))
          return BGoToTaskIcon;
	
        if (userObject.getClass().equals(SymptomInitialization.class))
          return SymptomInitializationIcon;
	
        if (userObject.getClass().equals(AESubtraction.class))
          return AESubtractionIcon;
	
        if (userObject.getClass().equals(COutside.class))
          return COutsideIcon;
	
        if (userObject.getClass().equals(ObjDroppedEvent.class))
          return ObjDroppedEventIcon;
	
        if (userObject.getClass().equals(FWardrobe.class))
          return FWardrobeIcon;
	
        if (userObject.getClass().equals(Profession.class))
          return ProfessionIcon;
	
        if (userObject.getClass().equals(IFFlowControl.class))
          return IFFlowControlIcon;
	
        if (userObject.getClass().equals(DFixedSensor.class))
          return DFixedSensorIcon;
	
        if (userObject.getClass().equals(Cane.class))
          return CaneIcon;
	
        if (userObject.getClass().equals(ETool.class))
          return EToolIcon;
	
        if (userObject.getClass().equals(BEBodyCollision.class))
          return BEBodyCollisionIcon;
	
        if (userObject.getClass().equals(EClothing.class))
          return EClothingIcon;
	
        if (userObject.getClass().equals(NormHoldingCondition.class))
          return NormHoldingConditionIcon;
	
        if (userObject.getClass().equals(EFixedPhysicalEntity.class))
          return EFixedPhysicalEntityIcon;
	


        if (userObject.getClass().equals(ingenias.editor.models.FilterDiagramModelJGraph.class))
            return modeloFilterDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.GenericDiseaseSpecDiagModelJGraph.class))
            return modeloGenericDiseaseSpecDiag;

        if (userObject.getClass().equals(ingenias.editor.models.BuildingDiagramModelJGraph.class))
            return modeloBuildingDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.ActivityDiagramModelJGraph.class))
            return modeloActivityDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.ADLSpecDiagramModelJGraph.class))
            return modeloADLSpecDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.DeviceBehavoirDiagramModelJGraph.class))
            return modeloDeviceBehavoirDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.InteractionDiagramModelJGraph.class))
            return modeloInteractionDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.SimulationDiagramModelJGraph.class))
            return modeloSimulationDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.SymptomEvolutionDiagramModelJGraph.class))
            return modeloSymptomEvolutionDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.FloorSpecDiagramModelJGraph.class))
            return modeloFloorSpecDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.DeviceDiagramModelJGraph.class))
            return modeloDeviceDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.SocialSpecDiagramModelJGraph.class))
            return modeloSocialSpecDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.RandomTaskDiagramModelJGraph.class))
            return modeloRandomTaskDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.ParkinsonSpecDiagramModelJGraph.class))
            return modeloParkinsonSpecDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.ArithmeticDiagram1ModelJGraph.class))
            return modeloArithmeticDiagram1;

        if (userObject.getClass().equals(ingenias.editor.models.HumanProfileSpecDiagramModelJGraph.class))
            return modeloHumanProfileSpecDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.MedicationTimeDiagramModelJGraph.class))
            return modeloMedicationTimeDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.RoomSpecDiagramModelJGraph.class))
            return modeloRoomSpecDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.SequentialTaskDiagramModelJGraph.class))
            return modeloSequentialTaskDiagram;

        if (userObject.getClass().equals(ingenias.editor.models.NormDefinitionModelJGraph.class))
            return modeloNormDefinition;

        return null;
      }

}


