


/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes
 * 
 *   Modifications over original code from Jon Barrileaux.
 *   It has been significantly modified to enhance drawing speed.
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/


package ingenias.editor.cell;



import org.jgraph.JGraph;
import org.jgraph.graph.*;

import javax.swing.*;
import javax.swing.border.Border;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.*;

import ingenias.editor.TypedVector;
import ingenias.editor.entities.*;
import ingenias.editor.entities.*;

import org.swixml.SwingEngine;

import ingenias.editor.entities.Entity;
import ingenias.editor.entities.ViewPreferences.ViewType;


public class SwipeTaskRenderer extends CompositeRenderer implements CellViewRenderer, Serializable {

  
	private static ViewPreferences.ViewType current = ViewPreferences.ViewType.INGENIAS;

  static {

    try {

    	ViewPreferences.ViewType index=ViewPreferences.ViewType.INGENIAS;
	index=ViewPreferences.ViewType.INGENIAS;
	
	index=ViewPreferences.ViewType.INGENIAS;
	RenderComponentManager.loadRenderFile("SwipeTask",
	index,"/rendererxml/SwipeTaskINGENIASPanel.xml");
	
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }

  }

    /**
     * Constructs a renderer that may be used to render vertices.
     */
    public SwipeTaskRenderer() {
    }
    
      public JComponent getConcreteSubComponent(String fieldname, Entity ent, Map map) {
	  Map<String,JComponent> currentMap=(Map)  RenderComponentManager.retrieveIDs("SwipeTask",ent.getPrefs(map).getView());
	  return currentMap.get(fieldname);
  		}

    public Dimension getSize() {
    return RenderComponentManager.getSize("SwipeTask",current);
    }

    public boolean supportsAttribute(Object key) {
    	return true;
        }

  public static void setEntity(SwipeTask ent, Map attributes){
  Map currentMap=(Map)  RenderComponentManager.retrieveIDs("SwipeTask",ent.getPrefs(attributes).getView());
  current=ent.getPrefs(attributes).getView();
		if (ent != null
				&& currentMap.get("_attributes_") != null
				&& currentMap.get("_attributes_") instanceof ingenias.editor.rendererxml.AttributesPanel) {

			((ingenias.editor.rendererxml.AttributesPanel) currentMap
					.get("_attributes_")).setEntity(ent);

		}

	

      
      if (currentMap.get("EndXField")!=null){
	   if (ent!=null && ent.getEndXField()!=null){
		if (currentMap.get("EndXField") instanceof javax.swing.JLabel){
		((javax.swing.JLabel)( currentMap).get("EndXField")).setText(ent.getEndXField().toString());
		} else {
		 if (currentMap.get("EndXField") instanceof javax.swing.text.JTextComponent)
		 ((javax.swing.text.JTextComponent)( currentMap).get("EndXField")).setText(ent.getEndXField().toString());
		
	      } 
	   } else  {
	     if (currentMap.get("EndXField") instanceof javax.swing.JLabel)
	     ((javax.swing.JLabel)( currentMap).get("EndXField")).setText("");
	     else {
		if (!(currentMap.get("EndXField") instanceof ingenias.editor.rendererxml.CollectionPanel)) 
		((javax.swing.text.JTextComponent)( currentMap).get("EndXField")).setText("");
	     }
         }
	  }
	if (currentMap.get("EndXField")!=null && 
				currentMap.get("EndXField") instanceof ingenias.editor.rendererxml.LinkLabel) {
			try {
				Field field;
				field = ent.getClass().getField("EndXField");
				if (ModelEntity.class.isAssignableFrom(field.getType())){
					try {							
						ModelEntity mde=(ModelEntity)field.get(ent);
						if (mde!=null)
							( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
								"EndXField")).setLink(new java.net.URL("http","app","/"+mde.getModelID()));
					} catch (MalformedURLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (SecurityException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else
					if (Entity.class.isAssignableFrom(field.getType())){
						try {
							Entity mde=(Entity)field.get(ent);
							if (mde!=null)
								( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
									"EndXField")).setLink(new java.net.URL("http","ent","/"+mde.getId()));
						} catch (MalformedURLException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}  catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			} catch (NoSuchFieldException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SecurityException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

	   
      if (currentMap.get("CanBeInterruptedField")!=null){
	   if (ent!=null && ent.getCanBeInterruptedField()!=null){
		if (currentMap.get("CanBeInterruptedField") instanceof javax.swing.JLabel){
		((javax.swing.JLabel)( currentMap).get("CanBeInterruptedField")).setText(ent.getCanBeInterruptedField().toString());
		} else {
		 if (currentMap.get("CanBeInterruptedField") instanceof javax.swing.text.JTextComponent)
		 ((javax.swing.text.JTextComponent)( currentMap).get("CanBeInterruptedField")).setText(ent.getCanBeInterruptedField().toString());
		
	      } 
	   } else  {
	     if (currentMap.get("CanBeInterruptedField") instanceof javax.swing.JLabel)
	     ((javax.swing.JLabel)( currentMap).get("CanBeInterruptedField")).setText("");
	     else {
		if (!(currentMap.get("CanBeInterruptedField") instanceof ingenias.editor.rendererxml.CollectionPanel)) 
		((javax.swing.text.JTextComponent)( currentMap).get("CanBeInterruptedField")).setText("");
	     }
         }
	  }
	if (currentMap.get("CanBeInterruptedField")!=null && 
				currentMap.get("CanBeInterruptedField") instanceof ingenias.editor.rendererxml.LinkLabel) {
			try {
				Field field;
				field = ent.getClass().getField("CanBeInterruptedField");
				if (ModelEntity.class.isAssignableFrom(field.getType())){
					try {							
						ModelEntity mde=(ModelEntity)field.get(ent);
						if (mde!=null)
							( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
								"CanBeInterruptedField")).setLink(new java.net.URL("http","app","/"+mde.getModelID()));
					} catch (MalformedURLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (SecurityException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else
					if (Entity.class.isAssignableFrom(field.getType())){
						try {
							Entity mde=(Entity)field.get(ent);
							if (mde!=null)
								( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
									"CanBeInterruptedField")).setLink(new java.net.URL("http","ent","/"+mde.getId()));
						} catch (MalformedURLException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}  catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			} catch (NoSuchFieldException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SecurityException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

	   
      if (currentMap.get("TargetSmartphone")!=null){
	   if (ent!=null && ent.getTargetSmartphone()!=null){
		if (currentMap.get("TargetSmartphone") instanceof javax.swing.JLabel){
		((javax.swing.JLabel)( currentMap).get("TargetSmartphone")).setText(ent.getTargetSmartphone().toString());
		} else {
		 if (currentMap.get("TargetSmartphone") instanceof javax.swing.text.JTextComponent)
		 ((javax.swing.text.JTextComponent)( currentMap).get("TargetSmartphone")).setText(ent.getTargetSmartphone().toString());
		
	      } 
	   } else  {
	     if (currentMap.get("TargetSmartphone") instanceof javax.swing.JLabel)
	     ((javax.swing.JLabel)( currentMap).get("TargetSmartphone")).setText("");
	     else {
		if (!(currentMap.get("TargetSmartphone") instanceof ingenias.editor.rendererxml.CollectionPanel)) 
		((javax.swing.text.JTextComponent)( currentMap).get("TargetSmartphone")).setText("");
	     }
         }
	  }
	if (currentMap.get("TargetSmartphone")!=null && 
				currentMap.get("TargetSmartphone") instanceof ingenias.editor.rendererxml.LinkLabel) {
			try {
				Field field;
				field = ent.getClass().getField("TargetSmartphone");
				if (ModelEntity.class.isAssignableFrom(field.getType())){
					try {							
						ModelEntity mde=(ModelEntity)field.get(ent);
						if (mde!=null)
							( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
								"TargetSmartphone")).setLink(new java.net.URL("http","app","/"+mde.getModelID()));
					} catch (MalformedURLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (SecurityException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else
					if (Entity.class.isAssignableFrom(field.getType())){
						try {
							Entity mde=(Entity)field.get(ent);
							if (mde!=null)
								( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
									"TargetSmartphone")).setLink(new java.net.URL("http","ent","/"+mde.getId()));
						} catch (MalformedURLException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}  catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			} catch (NoSuchFieldException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SecurityException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

	   
      if (currentMap.get("StartYField")!=null){
	   if (ent!=null && ent.getStartYField()!=null){
		if (currentMap.get("StartYField") instanceof javax.swing.JLabel){
		((javax.swing.JLabel)( currentMap).get("StartYField")).setText(ent.getStartYField().toString());
		} else {
		 if (currentMap.get("StartYField") instanceof javax.swing.text.JTextComponent)
		 ((javax.swing.text.JTextComponent)( currentMap).get("StartYField")).setText(ent.getStartYField().toString());
		
	      } 
	   } else  {
	     if (currentMap.get("StartYField") instanceof javax.swing.JLabel)
	     ((javax.swing.JLabel)( currentMap).get("StartYField")).setText("");
	     else {
		if (!(currentMap.get("StartYField") instanceof ingenias.editor.rendererxml.CollectionPanel)) 
		((javax.swing.text.JTextComponent)( currentMap).get("StartYField")).setText("");
	     }
         }
	  }
	if (currentMap.get("StartYField")!=null && 
				currentMap.get("StartYField") instanceof ingenias.editor.rendererxml.LinkLabel) {
			try {
				Field field;
				field = ent.getClass().getField("StartYField");
				if (ModelEntity.class.isAssignableFrom(field.getType())){
					try {							
						ModelEntity mde=(ModelEntity)field.get(ent);
						if (mde!=null)
							( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
								"StartYField")).setLink(new java.net.URL("http","app","/"+mde.getModelID()));
					} catch (MalformedURLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (SecurityException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else
					if (Entity.class.isAssignableFrom(field.getType())){
						try {
							Entity mde=(Entity)field.get(ent);
							if (mde!=null)
								( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
									"StartYField")).setLink(new java.net.URL("http","ent","/"+mde.getId()));
						} catch (MalformedURLException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}  catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			} catch (NoSuchFieldException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SecurityException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

	   
      if (currentMap.get("StartXField")!=null){
	   if (ent!=null && ent.getStartXField()!=null){
		if (currentMap.get("StartXField") instanceof javax.swing.JLabel){
		((javax.swing.JLabel)( currentMap).get("StartXField")).setText(ent.getStartXField().toString());
		} else {
		 if (currentMap.get("StartXField") instanceof javax.swing.text.JTextComponent)
		 ((javax.swing.text.JTextComponent)( currentMap).get("StartXField")).setText(ent.getStartXField().toString());
		
	      } 
	   } else  {
	     if (currentMap.get("StartXField") instanceof javax.swing.JLabel)
	     ((javax.swing.JLabel)( currentMap).get("StartXField")).setText("");
	     else {
		if (!(currentMap.get("StartXField") instanceof ingenias.editor.rendererxml.CollectionPanel)) 
		((javax.swing.text.JTextComponent)( currentMap).get("StartXField")).setText("");
	     }
         }
	  }
	if (currentMap.get("StartXField")!=null && 
				currentMap.get("StartXField") instanceof ingenias.editor.rendererxml.LinkLabel) {
			try {
				Field field;
				field = ent.getClass().getField("StartXField");
				if (ModelEntity.class.isAssignableFrom(field.getType())){
					try {							
						ModelEntity mde=(ModelEntity)field.get(ent);
						if (mde!=null)
							( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
								"StartXField")).setLink(new java.net.URL("http","app","/"+mde.getModelID()));
					} catch (MalformedURLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (SecurityException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else
					if (Entity.class.isAssignableFrom(field.getType())){
						try {
							Entity mde=(Entity)field.get(ent);
							if (mde!=null)
								( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
									"StartXField")).setLink(new java.net.URL("http","ent","/"+mde.getId()));
						} catch (MalformedURLException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}  catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			} catch (NoSuchFieldException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SecurityException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

	   
      if (currentMap.get("EndYField")!=null){
	   if (ent!=null && ent.getEndYField()!=null){
		if (currentMap.get("EndYField") instanceof javax.swing.JLabel){
		((javax.swing.JLabel)( currentMap).get("EndYField")).setText(ent.getEndYField().toString());
		} else {
		 if (currentMap.get("EndYField") instanceof javax.swing.text.JTextComponent)
		 ((javax.swing.text.JTextComponent)( currentMap).get("EndYField")).setText(ent.getEndYField().toString());
		
	      } 
	   } else  {
	     if (currentMap.get("EndYField") instanceof javax.swing.JLabel)
	     ((javax.swing.JLabel)( currentMap).get("EndYField")).setText("");
	     else {
		if (!(currentMap.get("EndYField") instanceof ingenias.editor.rendererxml.CollectionPanel)) 
		((javax.swing.text.JTextComponent)( currentMap).get("EndYField")).setText("");
	     }
         }
	  }
	if (currentMap.get("EndYField")!=null && 
				currentMap.get("EndYField") instanceof ingenias.editor.rendererxml.LinkLabel) {
			try {
				Field field;
				field = ent.getClass().getField("EndYField");
				if (ModelEntity.class.isAssignableFrom(field.getType())){
					try {							
						ModelEntity mde=(ModelEntity)field.get(ent);
						if (mde!=null)
							( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
								"EndYField")).setLink(new java.net.URL("http","app","/"+mde.getModelID()));
					} catch (MalformedURLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (SecurityException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else
					if (Entity.class.isAssignableFrom(field.getType())){
						try {
							Entity mde=(Entity)field.get(ent);
							if (mde!=null)
								( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
									"EndYField")).setLink(new java.net.URL("http","ent","/"+mde.getId()));
						} catch (MalformedURLException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}  catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			} catch (NoSuchFieldException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SecurityException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

	   
      if (currentMap.get("Id")!=null){
	   if (ent!=null && ent.getId()!=null){
		if (currentMap.get("Id") instanceof javax.swing.JLabel){
		((javax.swing.JLabel)( currentMap).get("Id")).setText(ent.getId().toString());
		} else {
		 if (currentMap.get("Id") instanceof javax.swing.text.JTextComponent)
		 ((javax.swing.text.JTextComponent)( currentMap).get("Id")).setText(ent.getId().toString());
		
	      } 
	   } else  {
	     if (currentMap.get("Id") instanceof javax.swing.JLabel)
	     ((javax.swing.JLabel)( currentMap).get("Id")).setText("");
	     else {
		if (!(currentMap.get("Id") instanceof ingenias.editor.rendererxml.CollectionPanel)) 
		((javax.swing.text.JTextComponent)( currentMap).get("Id")).setText("");
	     }
         }
	  }
	if (currentMap.get("Id")!=null && 
				currentMap.get("Id") instanceof ingenias.editor.rendererxml.LinkLabel) {
			try {
				Field field;
				field = ent.getClass().getField("Id");
				if (ModelEntity.class.isAssignableFrom(field.getType())){
					try {							
						ModelEntity mde=(ModelEntity)field.get(ent);
						if (mde!=null)
							( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
								"Id")).setLink(new java.net.URL("http","app","/"+mde.getModelID()));
					} catch (MalformedURLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (SecurityException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				} else
					if (Entity.class.isAssignableFrom(field.getType())){
						try {
							Entity mde=(Entity)field.get(ent);
							if (mde!=null)
								( (ingenias.editor.rendererxml.LinkLabel) currentMap.get(
									"Id")).setLink(new java.net.URL("http","ent","/"+mde.getId()));
						} catch (MalformedURLException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}  catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			} catch (NoSuchFieldException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SecurityException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

	   
      
    
  }


	public Component getRendererComponent(JGraph graph,
			CellView view, boolean sel,
			boolean focus, boolean preview)
	{
	return RenderComponentManager.retrievePanel("SwipeTask",
	((Entity)((DefaultGraphCell)(view.getCell())).getUserObject()).getPrefs(graph.getModel().getAttributes(view.getCell())).getView());
		
	}
	
		
	public Component getRendererComponent(JGraph graph,
			CellView view, boolean sel,
			boolean focus, boolean preview, ViewType vt)
	{
	return RenderComponentManager.retrievePanel("SwipeTask",	vt);
		
	}
	

	
	public static JPanel setCurrent(ViewPreferences.ViewType c) {
	
		current = ViewPreferences.ViewType.INGENIAS;
	
		return (JPanel) RenderComponentManager.retrievePanel("SwipeTask",current);
	}
	

}
