

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.cellfactories;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;

public class ArithmeticDiagram1CellViewFactory implements CellViewFactory {

public ArithmeticDiagram1CellViewFactory() {}
 

 	public org.jgraph.graph.CellView createView(GraphModel model, Object cell) {
		
			org.jgraph.graph.CellView view = null;
			if (model.isPort(cell))
				view = new PortView(cell);
			else if (model.isEdge(cell))
				view = createEdgeView(cell);
			else
				view = createVertexView(cell);
			return view;
		}

  // Modificar agregando nuevas clases VIEW segun se vayan a?endo

  protected org.jgraph.graph.VertexView createVertexView(Object v) {
    Object userObject = ( (DefaultGraphCell) v).getUserObject();

   // Diagram Objects start here


   if (userObject.getClass().equals(AENumConst.class)){
           return new ingenias.editor.cell.AENumConstView(v);
   }

   if (userObject.getClass().equals(AEAddition.class)){
           return new ingenias.editor.cell.AEAdditionView(v);
   }

   if (userObject.getClass().equals(AEVariable.class)){
           return new ingenias.editor.cell.AEVariableView(v);
   }

   if (userObject.getClass().equals(AEMult.class)){
           return new ingenias.editor.cell.AEMultView(v);
   }

   if (userObject.getClass().equals(AEDiv.class)){
           return new ingenias.editor.cell.AEDivView(v);
   }

   if (userObject.getClass().equals(AEInv.class)){
           return new ingenias.editor.cell.AEInvView(v);
   }

   if (userObject.getClass().equals(AESubtraction.class)){
           return new ingenias.editor.cell.AESubtractionView(v);
   }


   // Diagram Relationships start here

   if (v.getClass().equals(ProducesEventEdge.class)){
           return new ingenias.editor.cell.ProducesEventView(v);
   }

   if (v.getClass().equals(condEdge.class)){
           return new ingenias.editor.cell.condView(v);
   }

   if (v.getClass().equals(ProfileOfEdge.class)){
           return new ingenias.editor.cell.ProfileOfView(v);
   }

   if (v.getClass().equals(TIStartTimeEdge.class)){
           return new ingenias.editor.cell.TIStartTimeView(v);
   }

   if (v.getClass().equals(medEdge.class)){
           return new ingenias.editor.cell.medView(v);
   }

   if (v.getClass().equals(socialRelationsEdge.class)){
           return new ingenias.editor.cell.socialRelationsView(v);
   }

   if (v.getClass().equals(WorkAsEdge.class)){
           return new ingenias.editor.cell.WorkAsView(v);
   }

   if (v.getClass().equals(LiveInEdge.class)){
           return new ingenias.editor.cell.LiveInView(v);
   }

   if (v.getClass().equals(RelatedEventEdge.class)){
           return new ingenias.editor.cell.RelatedEventView(v);
   }

   if (v.getClass().equals(ActivityAttachedEdge.class)){
           return new ingenias.editor.cell.ActivityAttachedView(v);
   }

   if (v.getClass().equals(ConditionNeededEdge.class)){
           return new ingenias.editor.cell.ConditionNeededView(v);
   }

   if (v.getClass().equals(ConnectsEdge.class)){
           return new ingenias.editor.cell.ConnectsView(v);
   }

   if (v.getClass().equals(SBhasFloorEdge.class)){
           return new ingenias.editor.cell.SBhasFloorView(v);
   }

   if (v.getClass().equals(toolEdge.class)){
           return new ingenias.editor.cell.toolView(v);
   }

   if (v.getClass().equals(FPreconditionEdge.class)){
           return new ingenias.editor.cell.FPreconditionView(v);
   }

   if (v.getClass().equals(AllowedTaskEdge.class)){
           return new ingenias.editor.cell.AllowedTaskView(v);
   }

   if (v.getClass().equals(relatedConditionEdge.class)){
           return new ingenias.editor.cell.relatedConditionView(v);
   }

   if (v.getClass().equals(aeinv_opEdge.class)){
           return new ingenias.editor.cell.aeinv_opView(v);
   }

   if (v.getClass().equals(aemd_op2Edge.class)){
           return new ingenias.editor.cell.aemd_op2View(v);
   }

   if (v.getClass().equals(aeas_op2Edge.class)){
           return new ingenias.editor.cell.aeas_op2View(v);
   }

   if (v.getClass().equals(aeas_op1Edge.class)){
           return new ingenias.editor.cell.aeas_op1View(v);
   }

   if (v.getClass().equals(aemd_op1Edge.class)){
           return new ingenias.editor.cell.aemd_op1View(v);
   }

   if (v.getClass().equals(RelatedHumanEdge.class)){
           return new ingenias.editor.cell.RelatedHumanView(v);
   }

   if (v.getClass().equals(InitialLocationEdge.class)){
           return new ingenias.editor.cell.InitialLocationView(v);
   }

   if (v.getClass().equals(InitialActivityEdge.class)){
           return new ingenias.editor.cell.InitialActivityView(v);
   }

   if (v.getClass().equals(InitialDateEdge.class)){
           return new ingenias.editor.cell.InitialDateView(v);
   }

   if (v.getClass().equals(deviceEdge.class)){
           return new ingenias.editor.cell.deviceView(v);
   }

   if (v.getClass().equals(CameraFaceToHumanEdge.class)){
           return new ingenias.editor.cell.CameraFaceToHumanView(v);
   }

   if (v.getClass().equals(InitializedSymptomEdge.class)){
           return new ingenias.editor.cell.InitializedSymptomView(v);
   }

   if (v.getClass().equals(InitializesSymptomEdge.class)){
           return new ingenias.editor.cell.InitializesSymptomView(v);
   }

   if (v.getClass().equals(RoleEdge.class)){
           return new ingenias.editor.cell.RoleView(v);
   }

   if (v.getClass().equals(DeonticAssignementEdge.class)){
           return new ingenias.editor.cell.DeonticAssignementView(v);
   }

   if (v.getClass().equals(ActionResponsibleEdge.class)){
           return new ingenias.editor.cell.ActionResponsibleView(v);
   }

   if (v.getClass().equals(ActionHappeningAfterwardsEdge.class)){
           return new ingenias.editor.cell.ActionHappeningAfterwardsView(v);
   }

   if (v.getClass().equals(AffectedActionEdge.class)){
           return new ingenias.editor.cell.AffectedActionView(v);
   }

   if (v.getClass().equals(goToBodySpeedVarEdge.class)){
           return new ingenias.editor.cell.goToBodySpeedVarView(v);
   }

   if (v.getClass().equals(leaveObjVarEdge.class)){
           return new ingenias.editor.cell.leaveObjVarView(v);
   }

   if (v.getClass().equals(closeObjVarEdge.class)){
           return new ingenias.editor.cell.closeObjVarView(v);
   }

   if (v.getClass().equals(pickUpObjVarEdge.class)){
           return new ingenias.editor.cell.pickUpObjVarView(v);
   }

   if (v.getClass().equals(waitForHumanVarEdge.class)){
           return new ingenias.editor.cell.waitForHumanVarView(v);
   }

   if (v.getClass().equals(durationVarEdge.class)){
           return new ingenias.editor.cell.durationVarView(v);
   }

   if (v.getClass().equals(goToSpeedVarEdge.class)){
           return new ingenias.editor.cell.goToSpeedVarView(v);
   }

   if (v.getClass().equals(messageVarEdge.class)){
           return new ingenias.editor.cell.messageVarView(v);
   }

   if (v.getClass().equals(tapXVarEdge.class)){
           return new ingenias.editor.cell.tapXVarView(v);
   }

   if (v.getClass().equals(sitDownOnSeatVarEdge.class)){
           return new ingenias.editor.cell.sitDownOnSeatVarView(v);
   }

   if (v.getClass().equals(putOnWearableVarEdge.class)){
           return new ingenias.editor.cell.putOnWearableVarView(v);
   }

   if (v.getClass().equals(goToPlaceVarEdge.class)){
           return new ingenias.editor.cell.goToPlaceVarView(v);
   }

   if (v.getClass().equals(tapDeviceVarEdge.class)){
           return new ingenias.editor.cell.tapDeviceVarView(v);
   }

   if (v.getClass().equals(openObjVarEdge.class)){
           return new ingenias.editor.cell.openObjVarView(v);
   }

   if (v.getClass().equals(animVarEdge.class)){
           return new ingenias.editor.cell.animVarView(v);
   }

   if (v.getClass().equals(useObjVarEdge.class)){
           return new ingenias.editor.cell.useObjVarView(v);
   }

   if (v.getClass().equals(goToBodyVarEdge.class)){
           return new ingenias.editor.cell.goToBodyVarView(v);
   }

   if (v.getClass().equals(leaveObjDestinyVarEdge.class)){
           return new ingenias.editor.cell.leaveObjDestinyVarView(v);
   }

   if (v.getClass().equals(tapYVarEdge.class)){
           return new ingenias.editor.cell.tapYVarView(v);
   }

   if (v.getClass().equals(switchRoomVarEdge.class)){
           return new ingenias.editor.cell.switchRoomVarView(v);
   }

   if (v.getClass().equals(putOffWearableVarEdge.class)){
           return new ingenias.editor.cell.putOffWearableVarView(v);
   }

   if (v.getClass().equals(dropObjVarEdge.class)){
           return new ingenias.editor.cell.dropObjVarView(v);
   }


    return null;
  }

  protected org.jgraph.graph.EdgeView createEdgeView(Object v) {
  return new org.jgraph.graph.EdgeView(v);

//         if (v instanceof ExecuteEdge){
//           return new ExecuteView(v,this,cm);
//         }

  }

 


}
