

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.cellfactories;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;

public class FilterDiagramCellViewFactory implements CellViewFactory {

public FilterDiagramCellViewFactory() {}
 

 	public org.jgraph.graph.CellView createView(GraphModel model, Object cell) {
		
			org.jgraph.graph.CellView view = null;
			if (model.isPort(cell))
				view = new PortView(cell);
			else if (model.isEdge(cell))
				view = createEdgeView(cell);
			else
				view = createVertexView(cell);
			return view;
		}

  // Modificar agregando nuevas clases VIEW segun se vayan a?endo

  protected org.jgraph.graph.VertexView createVertexView(Object v) {
    Object userObject = ( (DefaultGraphCell) v).getUserObject();

   // Diagram Objects start here


   if (userObject.getClass().equals(IsThingInRoomCondition.class)){
           return new ingenias.editor.cell.IsThingInRoomConditionView(v);
   }

   if (userObject.getClass().equals(CReceiveHelp.class)){
           return new ingenias.editor.cell.CReceiveHelpView(v);
   }

   if (userObject.getClass().equals(CAlways.class)){
           return new ingenias.editor.cell.CAlwaysView(v);
   }

   if (userObject.getClass().equals(CSymptom.class)){
           return new ingenias.editor.cell.CSymptomView(v);
   }

   if (userObject.getClass().equals(CTimer.class)){
           return new ingenias.editor.cell.CTimerView(v);
   }

   if (userObject.getClass().equals(CTime.class)){
           return new ingenias.editor.cell.CTimeView(v);
   }

   if (userObject.getClass().equals(CInside.class)){
           return new ingenias.editor.cell.CInsideView(v);
   }

   if (userObject.getClass().equals(BodyStateCondition.class)){
           return new ingenias.editor.cell.BodyStateConditionView(v);
   }

   if (userObject.getClass().equals(CProb.class)){
           return new ingenias.editor.cell.CProbView(v);
   }

   if (userObject.getClass().equals(CEvent.class)){
           return new ingenias.editor.cell.CEventView(v);
   }

   if (userObject.getClass().equals(DoorStateCondition.class)){
           return new ingenias.editor.cell.DoorStateConditionView(v);
   }

   if (userObject.getClass().equals(PresenceSensorStateCondition.class)){
           return new ingenias.editor.cell.PresenceSensorStateConditionView(v);
   }

   if (userObject.getClass().equals(CSay.class)){
           return new ingenias.editor.cell.CSayView(v);
   }

   if (userObject.getClass().equals(COutside.class)){
           return new ingenias.editor.cell.COutsideView(v);
   }

   if (userObject.getClass().equals(CObjWeight.class)){
           return new ingenias.editor.cell.CObjWeightView(v);
   }

   if (userObject.getClass().equals(LightStateCondition.class)){
           return new ingenias.editor.cell.LightStateConditionView(v);
   }

   if (userObject.getClass().equals(CDayOfTheWeek.class)){
           return new ingenias.editor.cell.CDayOfTheWeekView(v);
   }

   if (userObject.getClass().equals(NotCondition.class)){
           return new ingenias.editor.cell.NotConditionView(v);
   }

   if (userObject.getClass().equals(CSymptom.class)){
           return new ingenias.editor.cell.CSymptomView(v);
   }

   if (userObject.getClass().equals(SwipeTask.class)){
           return new ingenias.editor.cell.SwipeTaskView(v);
   }

   if (userObject.getClass().equals(GoToBodyLoc.class)){
           return new ingenias.editor.cell.GoToBodyLocView(v);
   }

   if (userObject.getClass().equals(DropObj.class)){
           return new ingenias.editor.cell.DropObjView(v);
   }

   if (userObject.getClass().equals(OpenTask.class)){
           return new ingenias.editor.cell.OpenTaskView(v);
   }

   if (userObject.getClass().equals(BGoToTask.class)){
           return new ingenias.editor.cell.BGoToTaskView(v);
   }

   if (userObject.getClass().equals(SayTask.class)){
           return new ingenias.editor.cell.SayTaskView(v);
   }

   if (userObject.getClass().equals(TapXYTask.class)){
           return new ingenias.editor.cell.TapXYTaskView(v);
   }

   if (userObject.getClass().equals(WaitForBodyClose.class)){
           return new ingenias.editor.cell.WaitForBodyCloseView(v);
   }

   if (userObject.getClass().equals(CloseTask.class)){
           return new ingenias.editor.cell.CloseTaskView(v);
   }

   if (userObject.getClass().equals(FallTask.class)){
           return new ingenias.editor.cell.FallTaskView(v);
   }

   if (userObject.getClass().equals(SwitchLightTask.class)){
           return new ingenias.editor.cell.SwitchLightTaskView(v);
   }

   if (userObject.getClass().equals(FTaskSelectorFilter.class)){
           return new ingenias.editor.cell.FTaskSelectorFilterView(v);
   }

   if (userObject.getClass().equals(FReplaceTaskFilter.class)){
           return new ingenias.editor.cell.FReplaceTaskFilterView(v);
   }

   if (userObject.getClass().equals(FUnableFilter.class)){
           return new ingenias.editor.cell.FUnableFilterView(v);
   }

   if (userObject.getClass().equals(FChangeTargetObjFilter.class)){
           return new ingenias.editor.cell.FChangeTargetObjFilterView(v);
   }

   if (userObject.getClass().equals(FModifyPlaceFilter.class)){
           return new ingenias.editor.cell.FModifyPlaceFilterView(v);
   }

   if (userObject.getClass().equals(FChangeToolFilter.class)){
           return new ingenias.editor.cell.FChangeToolFilterView(v);
   }

   if (userObject.getClass().equals(FDelayFilter.class)){
           return new ingenias.editor.cell.FDelayFilterView(v);
   }

   if (userObject.getClass().equals(TakeOffTask.class)){
           return new ingenias.editor.cell.TakeOffTaskView(v);
   }

   if (userObject.getClass().equals(WaitTask.class)){
           return new ingenias.editor.cell.WaitTaskView(v);
   }

   if (userObject.getClass().equals(BPickUpTask.class)){
           return new ingenias.editor.cell.BPickUpTaskView(v);
   }

   if (userObject.getClass().equals(FallSleep.class)){
           return new ingenias.editor.cell.FallSleepView(v);
   }

   if (userObject.getClass().equals(Drink.class)){
           return new ingenias.editor.cell.DrinkView(v);
   }

   if (userObject.getClass().equals(BWakeUpTask.class)){
           return new ingenias.editor.cell.BWakeUpTaskView(v);
   }

   if (userObject.getClass().equals(PutOnTask.class)){
           return new ingenias.editor.cell.PutOnTaskView(v);
   }

   if (userObject.getClass().equals(StandUp.class)){
           return new ingenias.editor.cell.StandUpView(v);
   }

   if (userObject.getClass().equals(PlayAnimationTask.class)){
           return new ingenias.editor.cell.PlayAnimationTaskView(v);
   }

   if (userObject.getClass().equals(SitDown.class)){
           return new ingenias.editor.cell.SitDownView(v);
   }

   if (userObject.getClass().equals(GoIntoBed.class)){
           return new ingenias.editor.cell.GoIntoBedView(v);
   }

   if (userObject.getClass().equals(Eat.class)){
           return new ingenias.editor.cell.EatView(v);
   }

   if (userObject.getClass().equals(BUseTask.class)){
           return new ingenias.editor.cell.BUseTaskView(v);
   }

   if (userObject.getClass().equals(BLeaveTask.class)){
           return new ingenias.editor.cell.BLeaveTaskView(v);
   }

   if (userObject.getClass().equals(BGetUpFromBed.class)){
           return new ingenias.editor.cell.BGetUpFromBedView(v);
   }

   if (userObject.getClass().equals(BSequentialTask.class)){
           return new ingenias.editor.cell.BSequentialTaskView(v);
   }

   if (userObject.getClass().equals(BRandomTask.class)){
           return new ingenias.editor.cell.BRandomTaskView(v);
   }

   if (userObject.getClass().equals(SymptomChangedEvent.class)){
           return new ingenias.editor.cell.SymptomChangedEventView(v);
   }

   if (userObject.getClass().equals(Crutch.class)){
           return new ingenias.editor.cell.CrutchView(v);
   }

   if (userObject.getClass().equals(MedsTakenEvent.class)){
           return new ingenias.editor.cell.MedsTakenEventView(v);
   }

   if (userObject.getClass().equals(EMedicine.class)){
           return new ingenias.editor.cell.EMedicineView(v);
   }

   if (userObject.getClass().equals(Shoes.class)){
           return new ingenias.editor.cell.ShoesView(v);
   }

   if (userObject.getClass().equals(FOWashbasin.class)){
           return new ingenias.editor.cell.FOWashbasinView(v);
   }

   if (userObject.getClass().equals(FOSink.class)){
           return new ingenias.editor.cell.FOSinkView(v);
   }

   if (userObject.getClass().equals(Lift.class)){
           return new ingenias.editor.cell.LiftView(v);
   }

   if (userObject.getClass().equals(Shirt.class)){
           return new ingenias.editor.cell.ShirtView(v);
   }

   if (userObject.getClass().equals(StopBehaviourEvent.class)){
           return new ingenias.editor.cell.StopBehaviourEventView(v);
   }

   if (userObject.getClass().equals(VibrateEvent.class)){
           return new ingenias.editor.cell.VibrateEventView(v);
   }

   if (userObject.getClass().equals(SBathroom.class)){
           return new ingenias.editor.cell.SBathroomView(v);
   }

   if (userObject.getClass().equals(Shower.class)){
           return new ingenias.editor.cell.ShowerView(v);
   }

   if (userObject.getClass().equals(FWardrobe.class)){
           return new ingenias.editor.cell.FWardrobeView(v);
   }

   if (userObject.getClass().equals(ObjDroppedEvent.class)){
           return new ingenias.editor.cell.ObjDroppedEventView(v);
   }

   if (userObject.getClass().equals(Human.class)){
           return new ingenias.editor.cell.HumanView(v);
   }

   if (userObject.getClass().equals(MessageListenedEvent.class)){
           return new ingenias.editor.cell.MessageListenedEventView(v);
   }

   if (userObject.getClass().equals(ERemoteControl.class)){
           return new ingenias.editor.cell.ERemoteControlView(v);
   }

   if (userObject.getClass().equals(StartBehaviourEvent.class)){
           return new ingenias.editor.cell.StartBehaviourEventView(v);
   }

   if (userObject.getClass().equals(ESleepers.class)){
           return new ingenias.editor.cell.ESleepersView(v);
   }

   if (userObject.getClass().equals(Dishwasher.class)){
           return new ingenias.editor.cell.DishwasherView(v);
   }

   if (userObject.getClass().equals(WashMachine.class)){
           return new ingenias.editor.cell.WashMachineView(v);
   }

   if (userObject.getClass().equals(EatableItem.class)){
           return new ingenias.editor.cell.EatableItemView(v);
   }

   if (userObject.getClass().equals(Walker.class)){
           return new ingenias.editor.cell.WalkerView(v);
   }

   if (userObject.getClass().equals(Cane.class)){
           return new ingenias.editor.cell.CaneView(v);
   }

   if (userObject.getClass().equals(DComputer.class)){
           return new ingenias.editor.cell.DComputerView(v);
   }

   if (userObject.getClass().equals(SCorridor.class)){
           return new ingenias.editor.cell.SCorridorView(v);
   }

   if (userObject.getClass().equals(SArea.class)){
           return new ingenias.editor.cell.SAreaView(v);
   }

   if (userObject.getClass().equals(ESmartPhone.class)){
           return new ingenias.editor.cell.ESmartPhoneView(v);
   }

   if (userObject.getClass().equals(DrinkItem.class)){
           return new ingenias.editor.cell.DrinkItemView(v);
   }

   if (userObject.getClass().equals(FOBath.class)){
           return new ingenias.editor.cell.FOBathView(v);
   }

   if (userObject.getClass().equals(Shocks.class)){
           return new ingenias.editor.cell.ShocksView(v);
   }

   if (userObject.getClass().equals(Bridge.class)){
           return new ingenias.editor.cell.BridgeView(v);
   }

   if (userObject.getClass().equals(EMobileDevice.class)){
           return new ingenias.editor.cell.EMobileDeviceView(v);
   }

   if (userObject.getClass().equals(DTV.class)){
           return new ingenias.editor.cell.DTVView(v);
   }

   if (userObject.getClass().equals(FChair.class)){
           return new ingenias.editor.cell.FChairView(v);
   }

   if (userObject.getClass().equals(Pyjamas.class)){
           return new ingenias.editor.cell.PyjamasView(v);
   }

   if (userObject.getClass().equals(Staircase.class)){
           return new ingenias.editor.cell.StaircaseView(v);
   }

   if (userObject.getClass().equals(Doorbell.class)){
           return new ingenias.editor.cell.DoorbellView(v);
   }

   if (userObject.getClass().equals(Appliance.class)){
           return new ingenias.editor.cell.ApplianceView(v);
   }

   if (userObject.getClass().equals(CallStateEvent.class)){
           return new ingenias.editor.cell.CallStateEventView(v);
   }

   if (userObject.getClass().equals(FallingEvent.class)){
           return new ingenias.editor.cell.FallingEventView(v);
   }

   if (userObject.getClass().equals(SFloor.class)){
           return new ingenias.editor.cell.SFloorView(v);
   }

   if (userObject.getClass().equals(Extractor.class)){
           return new ingenias.editor.cell.ExtractorView(v);
   }

   if (userObject.getClass().equals(BEvent.class)){
           return new ingenias.editor.cell.BEventView(v);
   }

   if (userObject.getClass().equals(SLivingroom.class)){
           return new ingenias.editor.cell.SLivingroomView(v);
   }

   if (userObject.getClass().equals(SKitchen.class)){
           return new ingenias.editor.cell.SKitchenView(v);
   }

   if (userObject.getClass().equals(SBuilding.class)){
           return new ingenias.editor.cell.SBuildingView(v);
   }

   if (userObject.getClass().equals(EPrivateEvent.class)){
           return new ingenias.editor.cell.EPrivateEventView(v);
   }

   if (userObject.getClass().equals(SBedroom.class)){
           return new ingenias.editor.cell.SBedroomView(v);
   }

   if (userObject.getClass().equals(FTable.class)){
           return new ingenias.editor.cell.FTableView(v);
   }

   if (userObject.getClass().equals(Trousers.class)){
           return new ingenias.editor.cell.TrousersView(v);
   }

   if (userObject.getClass().equals(FOWater.class)){
           return new ingenias.editor.cell.FOWaterView(v);
   }

   if (userObject.getClass().equals(EWaterBottle.class)){
           return new ingenias.editor.cell.EWaterBottleView(v);
   }

   if (userObject.getClass().equals(FBed.class)){
           return new ingenias.editor.cell.FBedView(v);
   }

   if (userObject.getClass().equals(FSofa.class)){
           return new ingenias.editor.cell.FSofaView(v);
   }


   // Diagram Relationships start here

   if (v.getClass().equals(FAlternativeEdge.class)){
           return new ingenias.editor.cell.FAlternativeView(v);
   }

   if (v.getClass().equals(NextFilterEdge.class)){
           return new ingenias.editor.cell.NextFilterView(v);
   }

   if (v.getClass().equals(ProducesEventEdge.class)){
           return new ingenias.editor.cell.ProducesEventView(v);
   }

   if (v.getClass().equals(condEdge.class)){
           return new ingenias.editor.cell.condView(v);
   }

   if (v.getClass().equals(ProfileOfEdge.class)){
           return new ingenias.editor.cell.ProfileOfView(v);
   }

   if (v.getClass().equals(TIStartTimeEdge.class)){
           return new ingenias.editor.cell.TIStartTimeView(v);
   }

   if (v.getClass().equals(medEdge.class)){
           return new ingenias.editor.cell.medView(v);
   }

   if (v.getClass().equals(socialRelationsEdge.class)){
           return new ingenias.editor.cell.socialRelationsView(v);
   }

   if (v.getClass().equals(WorkAsEdge.class)){
           return new ingenias.editor.cell.WorkAsView(v);
   }

   if (v.getClass().equals(LiveInEdge.class)){
           return new ingenias.editor.cell.LiveInView(v);
   }

   if (v.getClass().equals(RelatedEventEdge.class)){
           return new ingenias.editor.cell.RelatedEventView(v);
   }

   if (v.getClass().equals(ActivityAttachedEdge.class)){
           return new ingenias.editor.cell.ActivityAttachedView(v);
   }

   if (v.getClass().equals(ConditionNeededEdge.class)){
           return new ingenias.editor.cell.ConditionNeededView(v);
   }

   if (v.getClass().equals(ConnectsEdge.class)){
           return new ingenias.editor.cell.ConnectsView(v);
   }

   if (v.getClass().equals(SBhasFloorEdge.class)){
           return new ingenias.editor.cell.SBhasFloorView(v);
   }

   if (v.getClass().equals(toolEdge.class)){
           return new ingenias.editor.cell.toolView(v);
   }

   if (v.getClass().equals(FPreconditionEdge.class)){
           return new ingenias.editor.cell.FPreconditionView(v);
   }

   if (v.getClass().equals(AllowedTaskEdge.class)){
           return new ingenias.editor.cell.AllowedTaskView(v);
   }

   if (v.getClass().equals(relatedConditionEdge.class)){
           return new ingenias.editor.cell.relatedConditionView(v);
   }

   if (v.getClass().equals(aeinv_opEdge.class)){
           return new ingenias.editor.cell.aeinv_opView(v);
   }

   if (v.getClass().equals(aemd_op2Edge.class)){
           return new ingenias.editor.cell.aemd_op2View(v);
   }

   if (v.getClass().equals(aeas_op2Edge.class)){
           return new ingenias.editor.cell.aeas_op2View(v);
   }

   if (v.getClass().equals(aeas_op1Edge.class)){
           return new ingenias.editor.cell.aeas_op1View(v);
   }

   if (v.getClass().equals(aemd_op1Edge.class)){
           return new ingenias.editor.cell.aemd_op1View(v);
   }

   if (v.getClass().equals(RelatedHumanEdge.class)){
           return new ingenias.editor.cell.RelatedHumanView(v);
   }

   if (v.getClass().equals(InitialLocationEdge.class)){
           return new ingenias.editor.cell.InitialLocationView(v);
   }

   if (v.getClass().equals(InitialActivityEdge.class)){
           return new ingenias.editor.cell.InitialActivityView(v);
   }

   if (v.getClass().equals(InitialDateEdge.class)){
           return new ingenias.editor.cell.InitialDateView(v);
   }

   if (v.getClass().equals(deviceEdge.class)){
           return new ingenias.editor.cell.deviceView(v);
   }

   if (v.getClass().equals(CameraFaceToHumanEdge.class)){
           return new ingenias.editor.cell.CameraFaceToHumanView(v);
   }

   if (v.getClass().equals(InitializedSymptomEdge.class)){
           return new ingenias.editor.cell.InitializedSymptomView(v);
   }

   if (v.getClass().equals(InitializesSymptomEdge.class)){
           return new ingenias.editor.cell.InitializesSymptomView(v);
   }

   if (v.getClass().equals(RoleEdge.class)){
           return new ingenias.editor.cell.RoleView(v);
   }

   if (v.getClass().equals(DeonticAssignementEdge.class)){
           return new ingenias.editor.cell.DeonticAssignementView(v);
   }

   if (v.getClass().equals(ActionResponsibleEdge.class)){
           return new ingenias.editor.cell.ActionResponsibleView(v);
   }

   if (v.getClass().equals(ActionHappeningAfterwardsEdge.class)){
           return new ingenias.editor.cell.ActionHappeningAfterwardsView(v);
   }

   if (v.getClass().equals(AffectedActionEdge.class)){
           return new ingenias.editor.cell.AffectedActionView(v);
   }

   if (v.getClass().equals(goToBodySpeedVarEdge.class)){
           return new ingenias.editor.cell.goToBodySpeedVarView(v);
   }

   if (v.getClass().equals(leaveObjVarEdge.class)){
           return new ingenias.editor.cell.leaveObjVarView(v);
   }

   if (v.getClass().equals(closeObjVarEdge.class)){
           return new ingenias.editor.cell.closeObjVarView(v);
   }

   if (v.getClass().equals(pickUpObjVarEdge.class)){
           return new ingenias.editor.cell.pickUpObjVarView(v);
   }

   if (v.getClass().equals(waitForHumanVarEdge.class)){
           return new ingenias.editor.cell.waitForHumanVarView(v);
   }

   if (v.getClass().equals(durationVarEdge.class)){
           return new ingenias.editor.cell.durationVarView(v);
   }

   if (v.getClass().equals(goToSpeedVarEdge.class)){
           return new ingenias.editor.cell.goToSpeedVarView(v);
   }

   if (v.getClass().equals(messageVarEdge.class)){
           return new ingenias.editor.cell.messageVarView(v);
   }

   if (v.getClass().equals(tapXVarEdge.class)){
           return new ingenias.editor.cell.tapXVarView(v);
   }

   if (v.getClass().equals(sitDownOnSeatVarEdge.class)){
           return new ingenias.editor.cell.sitDownOnSeatVarView(v);
   }

   if (v.getClass().equals(putOnWearableVarEdge.class)){
           return new ingenias.editor.cell.putOnWearableVarView(v);
   }

   if (v.getClass().equals(goToPlaceVarEdge.class)){
           return new ingenias.editor.cell.goToPlaceVarView(v);
   }

   if (v.getClass().equals(tapDeviceVarEdge.class)){
           return new ingenias.editor.cell.tapDeviceVarView(v);
   }

   if (v.getClass().equals(openObjVarEdge.class)){
           return new ingenias.editor.cell.openObjVarView(v);
   }

   if (v.getClass().equals(animVarEdge.class)){
           return new ingenias.editor.cell.animVarView(v);
   }

   if (v.getClass().equals(useObjVarEdge.class)){
           return new ingenias.editor.cell.useObjVarView(v);
   }

   if (v.getClass().equals(goToBodyVarEdge.class)){
           return new ingenias.editor.cell.goToBodyVarView(v);
   }

   if (v.getClass().equals(leaveObjDestinyVarEdge.class)){
           return new ingenias.editor.cell.leaveObjDestinyVarView(v);
   }

   if (v.getClass().equals(tapYVarEdge.class)){
           return new ingenias.editor.cell.tapYVarView(v);
   }

   if (v.getClass().equals(switchRoomVarEdge.class)){
           return new ingenias.editor.cell.switchRoomVarView(v);
   }

   if (v.getClass().equals(putOffWearableVarEdge.class)){
           return new ingenias.editor.cell.putOffWearableVarView(v);
   }

   if (v.getClass().equals(dropObjVarEdge.class)){
           return new ingenias.editor.cell.dropObjVarView(v);
   }


    return null;
  }

  protected org.jgraph.graph.EdgeView createEdgeView(Object v) {
  return new org.jgraph.graph.EdgeView(v);

//         if (v instanceof ExecuteEdge){
//           return new ExecuteView(v,this,cm);
//         }

  }

 


}
