

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.cellfactories;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;

public class SimulationDiagramCellViewFactory implements CellViewFactory {

public SimulationDiagramCellViewFactory() {}
 

 	public org.jgraph.graph.CellView createView(GraphModel model, Object cell) {
		
			org.jgraph.graph.CellView view = null;
			if (model.isPort(cell))
				view = new PortView(cell);
			else if (model.isEdge(cell))
				view = createEdgeView(cell);
			else
				view = createVertexView(cell);
			return view;
		}

  // Modificar agregando nuevas clases VIEW segun se vayan a?endo

  protected org.jgraph.graph.VertexView createVertexView(Object v) {
    Object userObject = ( (DefaultGraphCell) v).getUserObject();

   // Diagram Objects start here


   if (userObject.getClass().equals(PartOfBody.class)){
           return new ingenias.editor.cell.PartOfBodyView(v);
   }

   if (userObject.getClass().equals(InitProgramPool.class)){
           return new ingenias.editor.cell.InitProgramPoolView(v);
   }

   if (userObject.getClass().equals(SymptomInitialization.class)){
           return new ingenias.editor.cell.SymptomInitializationView(v);
   }

   if (userObject.getClass().equals(AndroidApplication.class)){
           return new ingenias.editor.cell.AndroidApplicationView(v);
   }

   if (userObject.getClass().equals(SDate.class)){
           return new ingenias.editor.cell.SDateView(v);
   }

   if (userObject.getClass().equals(AndroidEmulator.class)){
           return new ingenias.editor.cell.AndroidEmulatorView(v);
   }

   if (userObject.getClass().equals(SBathroom.class)){
           return new ingenias.editor.cell.SBathroomView(v);
   }

   if (userObject.getClass().equals(Human.class)){
           return new ingenias.editor.cell.HumanView(v);
   }

   if (userObject.getClass().equals(FlyCamInit.class)){
           return new ingenias.editor.cell.FlyCamInitView(v);
   }

   if (userObject.getClass().equals(SKitchen.class)){
           return new ingenias.editor.cell.SKitchenView(v);
   }

   if (userObject.getClass().equals(SLivingroom.class)){
           return new ingenias.editor.cell.SLivingroomView(v);
   }

   if (userObject.getClass().equals(SBedroom.class)){
           return new ingenias.editor.cell.SBedroomView(v);
   }

   if (userObject.getClass().equals(FTable.class)){
           return new ingenias.editor.cell.FTableView(v);
   }

   if (userObject.getClass().equals(CameraInit.class)){
           return new ingenias.editor.cell.CameraInitView(v);
   }

   if (userObject.getClass().equals(SCorridor.class)){
           return new ingenias.editor.cell.SCorridorView(v);
   }

   if (userObject.getClass().equals(SArea.class)){
           return new ingenias.editor.cell.SAreaView(v);
   }

   if (userObject.getClass().equals(ESmartPhone.class)){
           return new ingenias.editor.cell.ESmartPhoneView(v);
   }

   if (userObject.getClass().equals(InitialPreDefPos.class)){
           return new ingenias.editor.cell.InitialPreDefPosView(v);
   }

   if (userObject.getClass().equals(HumanInitialization.class)){
           return new ingenias.editor.cell.HumanInitializationView(v);
   }

   if (userObject.getClass().equals(DeviceParam.class)){
           return new ingenias.editor.cell.DeviceParamView(v);
   }

   if (userObject.getClass().equals(SeatParam.class)){
           return new ingenias.editor.cell.SeatParamView(v);
   }

   if (userObject.getClass().equals(ObjectParam.class)){
           return new ingenias.editor.cell.ObjectParamView(v);
   }

   if (userObject.getClass().equals(HumanParam.class)){
           return new ingenias.editor.cell.HumanParamView(v);
   }

   if (userObject.getClass().equals(PrimitiveParam.class)){
           return new ingenias.editor.cell.PrimitiveParamView(v);
   }

   if (userObject.getClass().equals(PlaceParam.class)){
           return new ingenias.editor.cell.PlaceParamView(v);
   }

   if (userObject.getClass().equals(WearableParam.class)){
           return new ingenias.editor.cell.WearableParamView(v);
   }

   if (userObject.getClass().equals(PDSymtom.class)){
           return new ingenias.editor.cell.PDSymtomView(v);
   }

   if (userObject.getClass().equals(BActivity.class)){
           return new ingenias.editor.cell.BActivityView(v);
   }

   if (userObject.getClass().equals(WorldInitialization.class)){
           return new ingenias.editor.cell.WorldInitializationView(v);
   }

   if (userObject.getClass().equals(Crutch.class)){
           return new ingenias.editor.cell.CrutchView(v);
   }

   if (userObject.getClass().equals(EMedicine.class)){
           return new ingenias.editor.cell.EMedicineView(v);
   }

   if (userObject.getClass().equals(Shoes.class)){
           return new ingenias.editor.cell.ShoesView(v);
   }

   if (userObject.getClass().equals(FOWashbasin.class)){
           return new ingenias.editor.cell.FOWashbasinView(v);
   }

   if (userObject.getClass().equals(FOSink.class)){
           return new ingenias.editor.cell.FOSinkView(v);
   }

   if (userObject.getClass().equals(Lift.class)){
           return new ingenias.editor.cell.LiftView(v);
   }

   if (userObject.getClass().equals(WearableVar.class)){
           return new ingenias.editor.cell.WearableVarView(v);
   }

   if (userObject.getClass().equals(Shirt.class)){
           return new ingenias.editor.cell.ShirtView(v);
   }

   if (userObject.getClass().equals(Shower.class)){
           return new ingenias.editor.cell.ShowerView(v);
   }

   if (userObject.getClass().equals(FWardrobe.class)){
           return new ingenias.editor.cell.FWardrobeView(v);
   }

   if (userObject.getClass().equals(ERemoteControl.class)){
           return new ingenias.editor.cell.ERemoteControlView(v);
   }

   if (userObject.getClass().equals(ESleepers.class)){
           return new ingenias.editor.cell.ESleepersView(v);
   }

   if (userObject.getClass().equals(Dishwasher.class)){
           return new ingenias.editor.cell.DishwasherView(v);
   }

   if (userObject.getClass().equals(WashMachine.class)){
           return new ingenias.editor.cell.WashMachineView(v);
   }

   if (userObject.getClass().equals(EatableItem.class)){
           return new ingenias.editor.cell.EatableItemView(v);
   }

   if (userObject.getClass().equals(Walker.class)){
           return new ingenias.editor.cell.WalkerView(v);
   }

   if (userObject.getClass().equals(Cane.class)){
           return new ingenias.editor.cell.CaneView(v);
   }

   if (userObject.getClass().equals(DComputer.class)){
           return new ingenias.editor.cell.DComputerView(v);
   }

   if (userObject.getClass().equals(DrinkItem.class)){
           return new ingenias.editor.cell.DrinkItemView(v);
   }

   if (userObject.getClass().equals(FOBath.class)){
           return new ingenias.editor.cell.FOBathView(v);
   }

   if (userObject.getClass().equals(SpatialVar.class)){
           return new ingenias.editor.cell.SpatialVarView(v);
   }

   if (userObject.getClass().equals(Shocks.class)){
           return new ingenias.editor.cell.ShocksView(v);
   }

   if (userObject.getClass().equals(Bridge.class)){
           return new ingenias.editor.cell.BridgeView(v);
   }

   if (userObject.getClass().equals(EMobileDevice.class)){
           return new ingenias.editor.cell.EMobileDeviceView(v);
   }

   if (userObject.getClass().equals(HumanVar.class)){
           return new ingenias.editor.cell.HumanVarView(v);
   }

   if (userObject.getClass().equals(DTV.class)){
           return new ingenias.editor.cell.DTVView(v);
   }

   if (userObject.getClass().equals(PrimitiveVar.class)){
           return new ingenias.editor.cell.PrimitiveVarView(v);
   }

   if (userObject.getClass().equals(SeatVar.class)){
           return new ingenias.editor.cell.SeatVarView(v);
   }

   if (userObject.getClass().equals(FChair.class)){
           return new ingenias.editor.cell.FChairView(v);
   }

   if (userObject.getClass().equals(Pyjamas.class)){
           return new ingenias.editor.cell.PyjamasView(v);
   }

   if (userObject.getClass().equals(Staircase.class)){
           return new ingenias.editor.cell.StaircaseView(v);
   }

   if (userObject.getClass().equals(Doorbell.class)){
           return new ingenias.editor.cell.DoorbellView(v);
   }

   if (userObject.getClass().equals(Appliance.class)){
           return new ingenias.editor.cell.ApplianceView(v);
   }

   if (userObject.getClass().equals(SFloor.class)){
           return new ingenias.editor.cell.SFloorView(v);
   }

   if (userObject.getClass().equals(Extractor.class)){
           return new ingenias.editor.cell.ExtractorView(v);
   }

   if (userObject.getClass().equals(ObjectVar.class)){
           return new ingenias.editor.cell.ObjectVarView(v);
   }

   if (userObject.getClass().equals(SBuilding.class)){
           return new ingenias.editor.cell.SBuildingView(v);
   }

   if (userObject.getClass().equals(Trousers.class)){
           return new ingenias.editor.cell.TrousersView(v);
   }

   if (userObject.getClass().equals(FOWater.class)){
           return new ingenias.editor.cell.FOWaterView(v);
   }

   if (userObject.getClass().equals(EWaterBottle.class)){
           return new ingenias.editor.cell.EWaterBottleView(v);
   }

   if (userObject.getClass().equals(FBed.class)){
           return new ingenias.editor.cell.FBedView(v);
   }

   if (userObject.getClass().equals(FSofa.class)){
           return new ingenias.editor.cell.FSofaView(v);
   }


   // Diagram Relationships start here

   if (v.getClass().equals(EmulatorPeerEdge.class)){
           return new ingenias.editor.cell.EmulatorPeerView(v);
   }

   if (v.getClass().equals(ParamsSetEdge.class)){
           return new ingenias.editor.cell.ParamsSetView(v);
   }

   if (v.getClass().equals(RunAndroidAppEdge.class)){
           return new ingenias.editor.cell.RunAndroidAppView(v);
   }

   if (v.getClass().equals(InitialDeviceLocationEdge.class)){
           return new ingenias.editor.cell.InitialDeviceLocationView(v);
   }

   if (v.getClass().equals(ProducesEventEdge.class)){
           return new ingenias.editor.cell.ProducesEventView(v);
   }

   if (v.getClass().equals(condEdge.class)){
           return new ingenias.editor.cell.condView(v);
   }

   if (v.getClass().equals(ProfileOfEdge.class)){
           return new ingenias.editor.cell.ProfileOfView(v);
   }

   if (v.getClass().equals(TIStartTimeEdge.class)){
           return new ingenias.editor.cell.TIStartTimeView(v);
   }

   if (v.getClass().equals(medEdge.class)){
           return new ingenias.editor.cell.medView(v);
   }

   if (v.getClass().equals(socialRelationsEdge.class)){
           return new ingenias.editor.cell.socialRelationsView(v);
   }

   if (v.getClass().equals(WorkAsEdge.class)){
           return new ingenias.editor.cell.WorkAsView(v);
   }

   if (v.getClass().equals(LiveInEdge.class)){
           return new ingenias.editor.cell.LiveInView(v);
   }

   if (v.getClass().equals(RelatedEventEdge.class)){
           return new ingenias.editor.cell.RelatedEventView(v);
   }

   if (v.getClass().equals(ActivityAttachedEdge.class)){
           return new ingenias.editor.cell.ActivityAttachedView(v);
   }

   if (v.getClass().equals(ConditionNeededEdge.class)){
           return new ingenias.editor.cell.ConditionNeededView(v);
   }

   if (v.getClass().equals(ConnectsEdge.class)){
           return new ingenias.editor.cell.ConnectsView(v);
   }

   if (v.getClass().equals(SBhasFloorEdge.class)){
           return new ingenias.editor.cell.SBhasFloorView(v);
   }

   if (v.getClass().equals(toolEdge.class)){
           return new ingenias.editor.cell.toolView(v);
   }

   if (v.getClass().equals(FPreconditionEdge.class)){
           return new ingenias.editor.cell.FPreconditionView(v);
   }

   if (v.getClass().equals(AllowedTaskEdge.class)){
           return new ingenias.editor.cell.AllowedTaskView(v);
   }

   if (v.getClass().equals(relatedConditionEdge.class)){
           return new ingenias.editor.cell.relatedConditionView(v);
   }

   if (v.getClass().equals(aeinv_opEdge.class)){
           return new ingenias.editor.cell.aeinv_opView(v);
   }

   if (v.getClass().equals(aemd_op2Edge.class)){
           return new ingenias.editor.cell.aemd_op2View(v);
   }

   if (v.getClass().equals(aeas_op2Edge.class)){
           return new ingenias.editor.cell.aeas_op2View(v);
   }

   if (v.getClass().equals(aeas_op1Edge.class)){
           return new ingenias.editor.cell.aeas_op1View(v);
   }

   if (v.getClass().equals(aemd_op1Edge.class)){
           return new ingenias.editor.cell.aemd_op1View(v);
   }

   if (v.getClass().equals(RelatedHumanEdge.class)){
           return new ingenias.editor.cell.RelatedHumanView(v);
   }

   if (v.getClass().equals(InitialLocationEdge.class)){
           return new ingenias.editor.cell.InitialLocationView(v);
   }

   if (v.getClass().equals(InitialActivityEdge.class)){
           return new ingenias.editor.cell.InitialActivityView(v);
   }

   if (v.getClass().equals(InitialDateEdge.class)){
           return new ingenias.editor.cell.InitialDateView(v);
   }

   if (v.getClass().equals(deviceEdge.class)){
           return new ingenias.editor.cell.deviceView(v);
   }

   if (v.getClass().equals(CameraFaceToHumanEdge.class)){
           return new ingenias.editor.cell.CameraFaceToHumanView(v);
   }

   if (v.getClass().equals(InitializedSymptomEdge.class)){
           return new ingenias.editor.cell.InitializedSymptomView(v);
   }

   if (v.getClass().equals(InitializesSymptomEdge.class)){
           return new ingenias.editor.cell.InitializesSymptomView(v);
   }

   if (v.getClass().equals(RoleEdge.class)){
           return new ingenias.editor.cell.RoleView(v);
   }

   if (v.getClass().equals(DeonticAssignementEdge.class)){
           return new ingenias.editor.cell.DeonticAssignementView(v);
   }

   if (v.getClass().equals(ActionResponsibleEdge.class)){
           return new ingenias.editor.cell.ActionResponsibleView(v);
   }

   if (v.getClass().equals(ActionHappeningAfterwardsEdge.class)){
           return new ingenias.editor.cell.ActionHappeningAfterwardsView(v);
   }

   if (v.getClass().equals(AffectedActionEdge.class)){
           return new ingenias.editor.cell.AffectedActionView(v);
   }

   if (v.getClass().equals(goToBodySpeedVarEdge.class)){
           return new ingenias.editor.cell.goToBodySpeedVarView(v);
   }

   if (v.getClass().equals(leaveObjVarEdge.class)){
           return new ingenias.editor.cell.leaveObjVarView(v);
   }

   if (v.getClass().equals(closeObjVarEdge.class)){
           return new ingenias.editor.cell.closeObjVarView(v);
   }

   if (v.getClass().equals(pickUpObjVarEdge.class)){
           return new ingenias.editor.cell.pickUpObjVarView(v);
   }

   if (v.getClass().equals(waitForHumanVarEdge.class)){
           return new ingenias.editor.cell.waitForHumanVarView(v);
   }

   if (v.getClass().equals(durationVarEdge.class)){
           return new ingenias.editor.cell.durationVarView(v);
   }

   if (v.getClass().equals(goToSpeedVarEdge.class)){
           return new ingenias.editor.cell.goToSpeedVarView(v);
   }

   if (v.getClass().equals(messageVarEdge.class)){
           return new ingenias.editor.cell.messageVarView(v);
   }

   if (v.getClass().equals(tapXVarEdge.class)){
           return new ingenias.editor.cell.tapXVarView(v);
   }

   if (v.getClass().equals(sitDownOnSeatVarEdge.class)){
           return new ingenias.editor.cell.sitDownOnSeatVarView(v);
   }

   if (v.getClass().equals(putOnWearableVarEdge.class)){
           return new ingenias.editor.cell.putOnWearableVarView(v);
   }

   if (v.getClass().equals(goToPlaceVarEdge.class)){
           return new ingenias.editor.cell.goToPlaceVarView(v);
   }

   if (v.getClass().equals(tapDeviceVarEdge.class)){
           return new ingenias.editor.cell.tapDeviceVarView(v);
   }

   if (v.getClass().equals(openObjVarEdge.class)){
           return new ingenias.editor.cell.openObjVarView(v);
   }

   if (v.getClass().equals(animVarEdge.class)){
           return new ingenias.editor.cell.animVarView(v);
   }

   if (v.getClass().equals(useObjVarEdge.class)){
           return new ingenias.editor.cell.useObjVarView(v);
   }

   if (v.getClass().equals(goToBodyVarEdge.class)){
           return new ingenias.editor.cell.goToBodyVarView(v);
   }

   if (v.getClass().equals(leaveObjDestinyVarEdge.class)){
           return new ingenias.editor.cell.leaveObjDestinyVarView(v);
   }

   if (v.getClass().equals(tapYVarEdge.class)){
           return new ingenias.editor.cell.tapYVarView(v);
   }

   if (v.getClass().equals(switchRoomVarEdge.class)){
           return new ingenias.editor.cell.switchRoomVarView(v);
   }

   if (v.getClass().equals(putOffWearableVarEdge.class)){
           return new ingenias.editor.cell.putOffWearableVarView(v);
   }

   if (v.getClass().equals(dropObjVarEdge.class)){
           return new ingenias.editor.cell.dropObjVarView(v);
   }


    return null;
  }

  protected org.jgraph.graph.EdgeView createEdgeView(Object v) {
  return new org.jgraph.graph.EdgeView(v);

//         if (v instanceof ExecuteEdge){
//           return new ExecuteView(v,this,cm);
//         }

  }

 


}
