
/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/

package ingenias.editor.entities;

import java.util.*;
import ingenias.editor.TypedVector;

public class AndroidEmulator extends Entity {


  public java.lang.String ApkFile;

  public java.lang.String AvdSerialNumber;

  public java.lang.String AvdScreenFeed;

  public java.lang.String AvdName;

  public java.lang.String Description;





  public AndroidEmulator(String id) {
    super(id);
    this.setHelpDesc("");
    this.setHelpRecom("");
  }


      public java.lang.String getApkFile(){
        return ApkFile;
      }
       public void setApkFile(java.lang.String
					ApkFile){
        this.ApkFile=ApkFile;
      }


      public java.lang.String getAvdSerialNumber(){
        return AvdSerialNumber;
      }
       public void setAvdSerialNumber(java.lang.String
					AvdSerialNumber){
        this.AvdSerialNumber=AvdSerialNumber;
      }


      public java.lang.String getAvdScreenFeed(){
        return AvdScreenFeed;
      }
       public void setAvdScreenFeed(java.lang.String
					AvdScreenFeed){
        this.AvdScreenFeed=AvdScreenFeed;
      }


      public java.lang.String getAvdName(){
        return AvdName;
      }
       public void setAvdName(java.lang.String
					AvdName){
        this.AvdName=AvdName;
      }


      public java.lang.String getDescription(){
        return Description;
      }
       public void setDescription(java.lang.String
					Description){
        this.Description=Description;
      }





public void fromMap(Map ht){
super.fromMap(ht);

 if (ht.get("ApkFile")!=null && ht.get("ApkFile").equals(""))
  this.setApkFile(null);
 else
  if (ht.get("ApkFile")!=null)
   this.setApkFile(new java.lang.String(ht.get("ApkFile").toString()));

 if (ht.get("AvdSerialNumber")!=null && ht.get("AvdSerialNumber").equals(""))
  this.setAvdSerialNumber(null);
 else
  if (ht.get("AvdSerialNumber")!=null)
   this.setAvdSerialNumber(new java.lang.String(ht.get("AvdSerialNumber").toString()));

 if (ht.get("AvdScreenFeed")!=null && ht.get("AvdScreenFeed").equals(""))
  this.setAvdScreenFeed(null);
 else
  if (ht.get("AvdScreenFeed")!=null)
   this.setAvdScreenFeed(new java.lang.String(ht.get("AvdScreenFeed").toString()));

 if (ht.get("AvdName")!=null && ht.get("AvdName").equals(""))
  this.setAvdName(null);
 else
  if (ht.get("AvdName")!=null)
   this.setAvdName(new java.lang.String(ht.get("AvdName").toString()));

 if (ht.get("Description")!=null && ht.get("Description").equals(""))
  this.setDescription(null);
 else
  if (ht.get("Description")!=null)
   this.setDescription(new java.lang.String(ht.get("Description").toString()));



}
public void toMap(Map ht){
super.toMap(ht);

//if (this.getApkFile() instanceof String)
 if (this.getApkFile()!=null)
 	ht.put("ApkFile",this.getApkFile().toString());
 else	
 	ht.put("ApkFile","");

//if (this.getAvdSerialNumber() instanceof String)
 if (this.getAvdSerialNumber()!=null)
 	ht.put("AvdSerialNumber",this.getAvdSerialNumber().toString());
 else	
 	ht.put("AvdSerialNumber","");

//if (this.getAvdScreenFeed() instanceof String)
 if (this.getAvdScreenFeed()!=null)
 	ht.put("AvdScreenFeed",this.getAvdScreenFeed().toString());
 else	
 	ht.put("AvdScreenFeed","");

//if (this.getAvdName() instanceof String)
 if (this.getAvdName()!=null)
 	ht.put("AvdName",this.getAvdName().toString());
 else	
 	ht.put("AvdName","");

//if (this.getDescription() instanceof String)
 if (this.getDescription()!=null)
 	ht.put("Description",this.getDescription().toString());
 else	
 	ht.put("Description","");


}

public String toString(){
/*if (this.getId()==null ||
    this.getId().toString().equals(""))
 return "Please, define the value of field Id";
else
 return this.getId().toString();*/
return ""+getId();
}

}
