
/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/

package ingenias.editor.entities;

import java.util.*;
import ingenias.editor.TypedVector;

public class CSymptom extends Condition {


  public java.lang.String PDSymptomTypeField;

  public ingenias.editor.entities.Human HumanTarget;

  public java.lang.String IntensityLevelField;

  public java.lang.String Description;





  public CSymptom(String id) {
    super(id);
    this.setHelpDesc("<br>Checks the level of a symptom.<br><br>- **PDSymptomTypeField:** Symptom name<br>- **IntensityLevelField:** Level of the symptom");
    this.setHelpRecom("");
  }


      public java.lang.String getPDSymptomTypeField(){
        return PDSymptomTypeField;
      }
       public void setPDSymptomTypeField(java.lang.String
					PDSymptomTypeField){
        this.PDSymptomTypeField=PDSymptomTypeField;
      }


      public ingenias.editor.entities.Human getHumanTarget(){
        return HumanTarget;
      }
       public void setHumanTarget(ingenias.editor.entities.Human
					HumanTarget){
        this.HumanTarget=HumanTarget;
      }


      public java.lang.String getIntensityLevelField(){
        return IntensityLevelField;
      }
       public void setIntensityLevelField(java.lang.String
					IntensityLevelField){
        this.IntensityLevelField=IntensityLevelField;
      }


      public java.lang.String getDescription(){
        return Description;
      }
       public void setDescription(java.lang.String
					Description){
        this.Description=Description;
      }





public void fromMap(Map ht){
super.fromMap(ht);

 if (ht.get("PDSymptomTypeField")!=null && ht.get("PDSymptomTypeField").equals(""))
  this.setPDSymptomTypeField(null);
 else
  if (ht.get("PDSymptomTypeField")!=null)
   this.setPDSymptomTypeField(new java.lang.String(ht.get("PDSymptomTypeField").toString()));

 if (ht.get("IntensityLevelField")!=null && ht.get("IntensityLevelField").equals(""))
  this.setIntensityLevelField(null);
 else
  if (ht.get("IntensityLevelField")!=null)
   this.setIntensityLevelField(new java.lang.String(ht.get("IntensityLevelField").toString()));

 if (ht.get("Description")!=null && ht.get("Description").equals(""))
  this.setDescription(null);
 else
  if (ht.get("Description")!=null)
   this.setDescription(new java.lang.String(ht.get("Description").toString()));



}
public void toMap(Map ht){
super.toMap(ht);

//if (this.getPDSymptomTypeField() instanceof String)
 if (this.getPDSymptomTypeField()!=null)
 	ht.put("PDSymptomTypeField",this.getPDSymptomTypeField().toString());
 else	
 	ht.put("PDSymptomTypeField","");

//if (this.getIntensityLevelField() instanceof String)
 if (this.getIntensityLevelField()!=null)
 	ht.put("IntensityLevelField",this.getIntensityLevelField().toString());
 else	
 	ht.put("IntensityLevelField","");

//if (this.getDescription() instanceof String)
 if (this.getDescription()!=null)
 	ht.put("Description",this.getDescription().toString());
 else	
 	ht.put("Description","");


}

public String toString(){
/*if (this.getId()==null ||
    this.getId().toString().equals(""))
 return "Please, define the value of field Id";
else
 return this.getId().toString();*/
return ""+getId();
}

}
