
/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/

package ingenias.editor.entities;

import java.util.*;
import ingenias.editor.TypedVector;

public class CameraInit extends Entity {


  public java.lang.String IsInFrontOfHuman;

  public java.lang.String DistanceToTarget;

  public java.lang.String Elevation;

  public java.lang.String Description;





  public CameraInit(String id) {
    super(id);
    this.setHelpDesc("");
    this.setHelpRecom("");
  }


      public java.lang.String getIsInFrontOfHuman(){
        return IsInFrontOfHuman;
      }
       public void setIsInFrontOfHuman(java.lang.String
					IsInFrontOfHuman){
        this.IsInFrontOfHuman=IsInFrontOfHuman;
      }


      public java.lang.String getDistanceToTarget(){
        return DistanceToTarget;
      }
       public void setDistanceToTarget(java.lang.String
					DistanceToTarget){
        this.DistanceToTarget=DistanceToTarget;
      }


      public java.lang.String getElevation(){
        return Elevation;
      }
       public void setElevation(java.lang.String
					Elevation){
        this.Elevation=Elevation;
      }


      public java.lang.String getDescription(){
        return Description;
      }
       public void setDescription(java.lang.String
					Description){
        this.Description=Description;
      }





public void fromMap(Map ht){
super.fromMap(ht);

 if (ht.get("IsInFrontOfHuman")!=null && ht.get("IsInFrontOfHuman").equals(""))
  this.setIsInFrontOfHuman(null);
 else
  if (ht.get("IsInFrontOfHuman")!=null)
   this.setIsInFrontOfHuman(new java.lang.String(ht.get("IsInFrontOfHuman").toString()));

 if (ht.get("DistanceToTarget")!=null && ht.get("DistanceToTarget").equals(""))
  this.setDistanceToTarget(null);
 else
  if (ht.get("DistanceToTarget")!=null)
   this.setDistanceToTarget(new java.lang.String(ht.get("DistanceToTarget").toString()));

 if (ht.get("Elevation")!=null && ht.get("Elevation").equals(""))
  this.setElevation(null);
 else
  if (ht.get("Elevation")!=null)
   this.setElevation(new java.lang.String(ht.get("Elevation").toString()));

 if (ht.get("Description")!=null && ht.get("Description").equals(""))
  this.setDescription(null);
 else
  if (ht.get("Description")!=null)
   this.setDescription(new java.lang.String(ht.get("Description").toString()));



}
public void toMap(Map ht){
super.toMap(ht);

//if (this.getIsInFrontOfHuman() instanceof String)
 if (this.getIsInFrontOfHuman()!=null)
 	ht.put("IsInFrontOfHuman",this.getIsInFrontOfHuman().toString());
 else	
 	ht.put("IsInFrontOfHuman","");

//if (this.getDistanceToTarget() instanceof String)
 if (this.getDistanceToTarget()!=null)
 	ht.put("DistanceToTarget",this.getDistanceToTarget().toString());
 else	
 	ht.put("DistanceToTarget","");

//if (this.getElevation() instanceof String)
 if (this.getElevation()!=null)
 	ht.put("Elevation",this.getElevation().toString());
 else	
 	ht.put("Elevation","");

//if (this.getDescription() instanceof String)
 if (this.getDescription()!=null)
 	ht.put("Description",this.getDescription().toString());
 else	
 	ht.put("Description","");


}

public String toString(){
/*if (this.getId()==null ||
    this.getId().toString().equals(""))
 return "Please, define the value of field Id";
else
 return this.getId().toString();*/
return ""+getId();
}

}
