
/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/

package ingenias.editor.entities;

import java.util.*;
import ingenias.editor.TypedVector;

public class MessageListenedEvent extends PerceptionEvent {


  public java.lang.String Message;

  public java.lang.String Description;





  public MessageListenedEvent(String id) {
    super(id);
    this.setHelpDesc("");
    this.setHelpRecom("");
  }


      public java.lang.String getMessage(){
        return Message;
      }
       public void setMessage(java.lang.String
					Message){
        this.Message=Message;
      }


      public java.lang.String getDescription(){
        return Description;
      }
       public void setDescription(java.lang.String
					Description){
        this.Description=Description;
      }





public void fromMap(Map ht){
super.fromMap(ht);

 if (ht.get("Message")!=null && ht.get("Message").equals(""))
  this.setMessage(null);
 else
  if (ht.get("Message")!=null)
   this.setMessage(new java.lang.String(ht.get("Message").toString()));

 if (ht.get("Description")!=null && ht.get("Description").equals(""))
  this.setDescription(null);
 else
  if (ht.get("Description")!=null)
   this.setDescription(new java.lang.String(ht.get("Description").toString()));



}
public void toMap(Map ht){
super.toMap(ht);

//if (this.getMessage() instanceof String)
 if (this.getMessage()!=null)
 	ht.put("Message",this.getMessage().toString());
 else	
 	ht.put("Message","");

//if (this.getDescription() instanceof String)
 if (this.getDescription()!=null)
 	ht.put("Description",this.getDescription().toString());
 else	
 	ht.put("Description","");


}

public String toString(){
/*if (this.getId()==null ||
    this.getId().toString().equals(""))
 return "Please, define the value of field Id";
else
 return this.getId().toString();*/
return ""+getId();
}

}
