
/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/

package ingenias.editor.entities;

import java.util.*;
import ingenias.editor.TypedVector;

public class SwitchLightAction extends BDeviceAction {


  public java.lang.String ONOFFStateField;

  public java.lang.String Description;



  public TypedVector RoomField=new TypedVector(ingenias.editor.entities.SRoom.class);



  public SwitchLightAction(String id) {
    super(id);
    this.setHelpDesc("");
    this.setHelpRecom("");
  }


      public java.lang.String getONOFFStateField(){
        return ONOFFStateField;
      }
       public void setONOFFStateField(java.lang.String
					ONOFFStateField){
        this.ONOFFStateField=ONOFFStateField;
      }


      public java.lang.String getDescription(){
        return Description;
      }
       public void setDescription(java.lang.String
					Description){
        this.Description=Description;
      }




  public void setRoomField(TypedVector tv){
    this.RoomField=tv;
  }

  public String getRoomField(){
   return RoomField.toString();
  }

  public Class getRoomFieldType(){
   return RoomField.getType();
  }
  public void addRoomField(ingenias.editor.entities.SRoom element){
   this.RoomField.add(element);
  }

  public void insertRoomFieldAt(int pos,ingenias.editor.entities.SRoom element){
   this.RoomField.insert(element,pos);
  }

  public int containsRoomField(ingenias.editor.entities.SRoom element){
   return this.RoomField.indexOf(element);
  }


  public Enumeration getRoomFieldElements(){
   return this.RoomField.elements();
  }

  public void removeRoomFieldElement(String id){
    Enumeration enumeration=this.getRoomFieldElements();
    ingenias.editor.entities.Entity found=null;
    while (enumeration.hasMoreElements() && found==null){
     ingenias.editor.entities.Entity ent=(ingenias.editor.entities.Entity)enumeration.nextElement();
     if (ent.getId().equalsIgnoreCase(id))
      found=ent;
    }
    if (found!=null)
     this.RoomField.remove(found);
  }



public void fromMap(Map ht){
super.fromMap(ht);

 if (ht.get("ONOFFStateField")!=null && ht.get("ONOFFStateField").equals(""))
  this.setONOFFStateField(null);
 else
  if (ht.get("ONOFFStateField")!=null)
   this.setONOFFStateField(new java.lang.String(ht.get("ONOFFStateField").toString()));

 if (ht.get("Description")!=null && ht.get("Description").equals(""))
  this.setDescription(null);
 else
  if (ht.get("Description")!=null)
   this.setDescription(new java.lang.String(ht.get("Description").toString()));



}
public void toMap(Map ht){
super.toMap(ht);

//if (this.getONOFFStateField() instanceof String)
 if (this.getONOFFStateField()!=null)
 	ht.put("ONOFFStateField",this.getONOFFStateField().toString());
 else	
 	ht.put("ONOFFStateField","");

//if (this.getDescription() instanceof String)
 if (this.getDescription()!=null)
 	ht.put("Description",this.getDescription().toString());
 else	
 	ht.put("Description","");


}

public String toString(){
/*if (this.getId()==null ||
    this.getId().toString().equals(""))
 return "Please, define the value of field Id";
else
 return this.getId().toString();*/
return ""+getId();
}

}
