

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 

package ingenias.editor.models;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;


import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.*;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.rendererxml.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;
import java.util.concurrent.TimeUnit;

public class ADLSpecDiagramModelJGraph extends ModelJGraph {

  private Preferences prefs;
  
 

  public ADLSpecDiagramModelJGraph(ADLSpecDiagramDataEntity mde, 
                               String nombre, ObjectManager om, Model
                               m, BasicMarqueeHandler mh, Preferences prefs) {
    super(mde, nombre, m, mh,om);
    this.prefs=prefs;
    ToolTipManager.sharedInstance().registerComponent(this);
this.getModel().addGraphModelListener(new ChangeNARYEdgeLocation(this));
this.getModel().addGraphModelListener(new ChangeEntityLocation(this));

    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.ADLSpecDiagramCellViewFactory());

  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }





  public JToolBar getPaleta() {
    return toolbar;

  }

  protected void creaToolBar() {
    if (toolbar==null){
    toolbar = new FilteredJToolBar("ADLSpecDiagram");
    toolbar.setFloatable(false);
    ImageIcon undoIcon = null;
    JButton jb = null;


   if (true){
    Image img_TimeInterval =
        ImageLoader.getImage("images/profiles/ADLProfile/timeInterval16.png");
    undoIcon = new ImageIcon(img_TimeInterval);
    Action TimeInterval=
        new AbstractAction("TimeInterval", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "TimeInterval");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    TimeInterval.setEnabled(true);
    jb = new JButton(TimeInterval){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("TimeInterval");	
    jb.setToolTipText("TimeInterval:"+new TimeInterval("").getHelpDesc()+"\n\n"+new TimeInterval("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_ClockTime =
        ImageLoader.getImage("images/time/ClockTime16.png");
    undoIcon = new ImageIcon(img_ClockTime);
    Action ClockTime=
        new AbstractAction("ClockTime", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ClockTime");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ClockTime.setEnabled(true);
    jb = new JButton(ClockTime){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ClockTime");	
    jb.setToolTipText("ClockTime:"+new ClockTime("").getHelpDesc()+"\n\n"+new ClockTime("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

    }

  }

  public Vector<String> getAllowedRelationships(){
   Vector<String> relationships=new   Vector<String>();


          relationships.add("NextTI");

          relationships.add("ProducesEvent");

          relationships.add("cond");

          relationships.add("ProfileOf");

          relationships.add("TIStartTime");

          relationships.add("med");

          relationships.add("socialRelations");

          relationships.add("WorkAs");

          relationships.add("LiveIn");

          relationships.add("RelatedEvent");

          relationships.add("ActivityAttached");

          relationships.add("ConditionNeeded");

          relationships.add("Connects");

          relationships.add("SBhasFloor");

          relationships.add("tool");

          relationships.add("FPrecondition");

          relationships.add("AllowedTask");

          relationships.add("relatedCondition");

          relationships.add("aeinv_op");

          relationships.add("aemd_op2");

          relationships.add("aeas_op2");

          relationships.add("aeas_op1");

          relationships.add("aemd_op1");

          relationships.add("RelatedHuman");

          relationships.add("InitialLocation");

          relationships.add("InitialActivity");

          relationships.add("InitialDate");

          relationships.add("device");

          relationships.add("CameraFaceToHuman");

          relationships.add("InitializedSymptom");

          relationships.add("InitializesSymptom");

          relationships.add("Role");

          relationships.add("DeonticAssignement");

          relationships.add("ActionResponsible");

          relationships.add("ActionHappeningAfterwards");

          relationships.add("AffectedAction");

          relationships.add("goToBodySpeedVar");

          relationships.add("leaveObjVar");

          relationships.add("closeObjVar");

          relationships.add("pickUpObjVar");

          relationships.add("waitForHumanVar");

          relationships.add("durationVar");

          relationships.add("goToSpeedVar");

          relationships.add("messageVar");

          relationships.add("tapXVar");

          relationships.add("sitDownOnSeatVar");

          relationships.add("putOnWearableVar");

          relationships.add("goToPlaceVar");

          relationships.add("tapDeviceVar");

          relationships.add("openObjVar");

          relationships.add("animVar");

          relationships.add("useObjVar");

          relationships.add("goToBodyVar");

          relationships.add("leaveObjDestinyVar");

          relationships.add("tapYVar");

          relationships.add("switchRoomVar");

          relationships.add("putOffWearableVar");

          relationships.add("dropObjVar");

   return relationships;
  }

  public  Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("TimeInterval");

 entities.add("ClockTime");

   return entities;
  }

  // Gets the name of the possible relationships for the selected GraphCells.
  // A relationship can be binary (DefaultEdge) or n-ary (NAryEdge).
  // The requested action is slightly different depending on selected items.
  // According to the number of Edges in selected, the action can be:
  // 0 => Propose a relationship between selected according included classes.
  // 1 and it is NAryEdge => The class of that NAryEdge if it is possible according implements java.io.Serializable
  //      current cardinality and included classes..
  // other cases => Error, no relationships are allowed.
  public Object[] getPossibleRelationships(GraphCell[] selected) {
    // Possible relationships initialization.
    Vector v = new Vector();

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

        // Connections are only possible with two or more elements and without binary edges.
      }
    }
    if (selected.length >= 2 && edgesNum == 0) {

      // The number of NAryEdges is considered.
      if (nAryEdgesNum == 0) {
        // acceptConnection methods only admits vertex parameters.
        // Binary relationships.

        // N-ary relationships. Sometimes they can be also binary.
        if (NextTIEdge.acceptConnection(this.getModel(), selected)) {
          v.add("NextTI");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ProducesEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProducesEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (condEdge.acceptConnection(this.getModel(), selected)) {
          v.add("cond");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ProfileOfEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProfileOf");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (TIStartTimeEdge.acceptConnection(this.getModel(), selected)) {
          v.add("TIStartTime");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (medEdge.acceptConnection(this.getModel(), selected)) {
          v.add("med");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (socialRelationsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("socialRelations");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (WorkAsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("WorkAs");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (LiveInEdge.acceptConnection(this.getModel(), selected)) {
          v.add("LiveIn");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActivityAttachedEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActivityAttached");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConditionNeededEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ConditionNeeded");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConnectsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Connects");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (SBhasFloorEdge.acceptConnection(this.getModel(), selected)) {
          v.add("SBhasFloor");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (toolEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tool");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (FPreconditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("FPrecondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AllowedTaskEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AllowedTask");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (relatedConditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("relatedCondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeinv_opEdge.acceptConnection(this.getModel(), selected)) {
          v.add("aeinv_op");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialLocationEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialLocation");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialActivityEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialActivity");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialDateEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialDate");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (deviceEdge.acceptConnection(this.getModel(), selected)) {
          v.add("device");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("CameraFaceToHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializedSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializedSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializesSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializesSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RoleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Role");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (DeonticAssignementEdge.acceptConnection(this.getModel(), selected)) {
          v.add("DeonticAssignement");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionResponsibleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionResponsible");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionHappeningAfterwards");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AffectedActionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AffectedAction");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodySpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (closeObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("closeObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (pickUpObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("pickUpObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (waitForHumanVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("waitForHumanVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (durationVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("durationVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToSpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToSpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (messageVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("messageVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapXVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapXVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("sitDownOnSeatVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOnWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOnWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToPlaceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToPlaceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapDeviceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapDeviceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (openObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("openObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (animVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("animVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (useObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("useObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjDestinyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapYVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapYVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (switchRoomVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("switchRoomVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOffWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOffWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (dropObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("dropObjVar");
	  }

      }
      else if (nAryEdgesNum == 1) {

        if (selectedEdge instanceof NextTIEdge &&
        (NextTIEdge.acceptConnection(this.getModel(), selected))) {
          v.add("NextTI");
        }

        if (selectedEdge instanceof ProducesEventEdge &&
        (ProducesEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProducesEvent");
        }

        if (selectedEdge instanceof condEdge &&
        (condEdge.acceptConnection(this.getModel(), selected))) {
          v.add("cond");
        }

        if (selectedEdge instanceof ProfileOfEdge &&
        (ProfileOfEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProfileOf");
        }

        if (selectedEdge instanceof TIStartTimeEdge &&
        (TIStartTimeEdge.acceptConnection(this.getModel(), selected))) {
          v.add("TIStartTime");
        }

        if (selectedEdge instanceof medEdge &&
        (medEdge.acceptConnection(this.getModel(), selected))) {
          v.add("med");
        }

        if (selectedEdge instanceof socialRelationsEdge &&
        (socialRelationsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("socialRelations");
        }

        if (selectedEdge instanceof WorkAsEdge &&
        (WorkAsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("WorkAs");
        }

        if (selectedEdge instanceof LiveInEdge &&
        (LiveInEdge.acceptConnection(this.getModel(), selected))) {
          v.add("LiveIn");
        }

        if (selectedEdge instanceof RelatedEventEdge &&
        (RelatedEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedEvent");
        }

        if (selectedEdge instanceof ActivityAttachedEdge &&
        (ActivityAttachedEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActivityAttached");
        }

        if (selectedEdge instanceof ConditionNeededEdge &&
        (ConditionNeededEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ConditionNeeded");
        }

        if (selectedEdge instanceof ConnectsEdge &&
        (ConnectsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Connects");
        }

        if (selectedEdge instanceof SBhasFloorEdge &&
        (SBhasFloorEdge.acceptConnection(this.getModel(), selected))) {
          v.add("SBhasFloor");
        }

        if (selectedEdge instanceof toolEdge &&
        (toolEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tool");
        }

        if (selectedEdge instanceof FPreconditionEdge &&
        (FPreconditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("FPrecondition");
        }

        if (selectedEdge instanceof AllowedTaskEdge &&
        (AllowedTaskEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AllowedTask");
        }

        if (selectedEdge instanceof relatedConditionEdge &&
        (relatedConditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("relatedCondition");
        }

        if (selectedEdge instanceof aeinv_opEdge &&
        (aeinv_opEdge.acceptConnection(this.getModel(), selected))) {
          v.add("aeinv_op");
        }

        if (selectedEdge instanceof aemd_op2Edge &&
        (aemd_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op2");
        }

        if (selectedEdge instanceof aeas_op2Edge &&
        (aeas_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op2");
        }

        if (selectedEdge instanceof aeas_op1Edge &&
        (aeas_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op1");
        }

        if (selectedEdge instanceof aemd_op1Edge &&
        (aemd_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op1");
        }

        if (selectedEdge instanceof RelatedHumanEdge &&
        (RelatedHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedHuman");
        }

        if (selectedEdge instanceof InitialLocationEdge &&
        (InitialLocationEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialLocation");
        }

        if (selectedEdge instanceof InitialActivityEdge &&
        (InitialActivityEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialActivity");
        }

        if (selectedEdge instanceof InitialDateEdge &&
        (InitialDateEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialDate");
        }

        if (selectedEdge instanceof deviceEdge &&
        (deviceEdge.acceptConnection(this.getModel(), selected))) {
          v.add("device");
        }

        if (selectedEdge instanceof CameraFaceToHumanEdge &&
        (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("CameraFaceToHuman");
        }

        if (selectedEdge instanceof InitializedSymptomEdge &&
        (InitializedSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializedSymptom");
        }

        if (selectedEdge instanceof InitializesSymptomEdge &&
        (InitializesSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializesSymptom");
        }

        if (selectedEdge instanceof RoleEdge &&
        (RoleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Role");
        }

        if (selectedEdge instanceof DeonticAssignementEdge &&
        (DeonticAssignementEdge.acceptConnection(this.getModel(), selected))) {
          v.add("DeonticAssignement");
        }

        if (selectedEdge instanceof ActionResponsibleEdge &&
        (ActionResponsibleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionResponsible");
        }

        if (selectedEdge instanceof ActionHappeningAfterwardsEdge &&
        (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionHappeningAfterwards");
        }

        if (selectedEdge instanceof AffectedActionEdge &&
        (AffectedActionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AffectedAction");
        }

        if (selectedEdge instanceof goToBodySpeedVarEdge &&
        (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodySpeedVar");
        }

        if (selectedEdge instanceof leaveObjVarEdge &&
        (leaveObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjVar");
        }

        if (selectedEdge instanceof closeObjVarEdge &&
        (closeObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("closeObjVar");
        }

        if (selectedEdge instanceof pickUpObjVarEdge &&
        (pickUpObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("pickUpObjVar");
        }

        if (selectedEdge instanceof waitForHumanVarEdge &&
        (waitForHumanVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("waitForHumanVar");
        }

        if (selectedEdge instanceof durationVarEdge &&
        (durationVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("durationVar");
        }

        if (selectedEdge instanceof goToSpeedVarEdge &&
        (goToSpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToSpeedVar");
        }

        if (selectedEdge instanceof messageVarEdge &&
        (messageVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("messageVar");
        }

        if (selectedEdge instanceof tapXVarEdge &&
        (tapXVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapXVar");
        }

        if (selectedEdge instanceof sitDownOnSeatVarEdge &&
        (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("sitDownOnSeatVar");
        }

        if (selectedEdge instanceof putOnWearableVarEdge &&
        (putOnWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOnWearableVar");
        }

        if (selectedEdge instanceof goToPlaceVarEdge &&
        (goToPlaceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToPlaceVar");
        }

        if (selectedEdge instanceof tapDeviceVarEdge &&
        (tapDeviceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapDeviceVar");
        }

        if (selectedEdge instanceof openObjVarEdge &&
        (openObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("openObjVar");
        }

        if (selectedEdge instanceof animVarEdge &&
        (animVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("animVar");
        }

        if (selectedEdge instanceof useObjVarEdge &&
        (useObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("useObjVar");
        }

        if (selectedEdge instanceof goToBodyVarEdge &&
        (goToBodyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodyVar");
        }

        if (selectedEdge instanceof leaveObjDestinyVarEdge &&
        (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjDestinyVar");
        }

        if (selectedEdge instanceof tapYVarEdge &&
        (tapYVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapYVar");
        }

        if (selectedEdge instanceof switchRoomVarEdge &&
        (switchRoomVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("switchRoomVar");
        }

        if (selectedEdge instanceof putOffWearableVarEdge &&
        (putOffWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOffWearableVar");
        }

        if (selectedEdge instanceof dropObjVarEdge &&
        (dropObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("dropObjVar");
        }

      }
    }

    return v.toArray();
  }

  public DefaultGraphCell getInstanciaNRelacion(String relacion,
                                                GraphCell[] selected) {

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

      }
    }
    if (nAryEdgesNum <= 1 && edgesNum == 0) {

      if (relacion.equalsIgnoreCase("NextTI")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof NextTIEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new NextTIEdge(new ingenias.editor.entities.NextTI(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ProducesEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProducesEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProducesEventEdge(new ingenias.editor.entities.ProducesEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("cond")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof condEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new condEdge(new ingenias.editor.entities.cond(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ProfileOf")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProfileOfEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProfileOfEdge(new ingenias.editor.entities.ProfileOf(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("TIStartTime")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof TIStartTimeEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new TIStartTimeEdge(new ingenias.editor.entities.TIStartTime(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("med")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof medEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new medEdge(new ingenias.editor.entities.med(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("socialRelations")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof socialRelationsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new socialRelationsEdge(new ingenias.editor.entities.socialRelations(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("WorkAs")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof WorkAsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new WorkAsEdge(new ingenias.editor.entities.WorkAs(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("LiveIn")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof LiveInEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new LiveInEdge(new ingenias.editor.entities.LiveIn(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedEventEdge(new ingenias.editor.entities.RelatedEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActivityAttached")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActivityAttachedEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActivityAttachedEdge(new ingenias.editor.entities.ActivityAttached(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ConditionNeeded")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConditionNeededEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConditionNeededEdge(new ingenias.editor.entities.ConditionNeeded(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Connects")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConnectsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConnectsEdge(new ingenias.editor.entities.Connects(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("SBhasFloor")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof SBhasFloorEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new SBhasFloorEdge(new ingenias.editor.entities.SBhasFloor(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tool")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof toolEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new toolEdge(new ingenias.editor.entities.tool(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("FPrecondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof FPreconditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new FPreconditionEdge(new ingenias.editor.entities.FPrecondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AllowedTask")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AllowedTaskEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AllowedTaskEdge(new ingenias.editor.entities.AllowedTask(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("relatedCondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof relatedConditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new relatedConditionEdge(new ingenias.editor.entities.relatedCondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeinv_op")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeinv_opEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeinv_opEdge(new ingenias.editor.entities.aeinv_op(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op2Edge(new ingenias.editor.entities.aemd_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op2Edge(new ingenias.editor.entities.aeas_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op1Edge(new ingenias.editor.entities.aeas_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op1Edge(new ingenias.editor.entities.aemd_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedHumanEdge(new ingenias.editor.entities.RelatedHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialLocation")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialLocationEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialLocationEdge(new ingenias.editor.entities.InitialLocation(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialActivity")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialActivityEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialActivityEdge(new ingenias.editor.entities.InitialActivity(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialDate")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialDateEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialDateEdge(new ingenias.editor.entities.InitialDate(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("device")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof deviceEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new deviceEdge(new ingenias.editor.entities.device(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("CameraFaceToHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof CameraFaceToHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new CameraFaceToHumanEdge(new ingenias.editor.entities.CameraFaceToHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializedSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializedSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializedSymptomEdge(new ingenias.editor.entities.InitializedSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializesSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializesSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializesSymptomEdge(new ingenias.editor.entities.InitializesSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Role")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RoleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RoleEdge(new ingenias.editor.entities.Role(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("DeonticAssignement")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof DeonticAssignementEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new DeonticAssignementEdge(new ingenias.editor.entities.DeonticAssignement(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionResponsible")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionResponsibleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionResponsibleEdge(new ingenias.editor.entities.ActionResponsible(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionHappeningAfterwards")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionHappeningAfterwardsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionHappeningAfterwardsEdge(new ingenias.editor.entities.ActionHappeningAfterwards(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AffectedAction")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AffectedActionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AffectedActionEdge(new ingenias.editor.entities.AffectedAction(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodySpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodySpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodySpeedVarEdge(new ingenias.editor.entities.goToBodySpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjVarEdge(new ingenias.editor.entities.leaveObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("closeObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof closeObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new closeObjVarEdge(new ingenias.editor.entities.closeObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("pickUpObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof pickUpObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new pickUpObjVarEdge(new ingenias.editor.entities.pickUpObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("waitForHumanVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof waitForHumanVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new waitForHumanVarEdge(new ingenias.editor.entities.waitForHumanVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("durationVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof durationVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new durationVarEdge(new ingenias.editor.entities.durationVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToSpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToSpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToSpeedVarEdge(new ingenias.editor.entities.goToSpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("messageVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof messageVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new messageVarEdge(new ingenias.editor.entities.messageVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapXVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapXVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapXVarEdge(new ingenias.editor.entities.tapXVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("sitDownOnSeatVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof sitDownOnSeatVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new sitDownOnSeatVarEdge(new ingenias.editor.entities.sitDownOnSeatVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOnWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOnWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOnWearableVarEdge(new ingenias.editor.entities.putOnWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToPlaceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToPlaceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToPlaceVarEdge(new ingenias.editor.entities.goToPlaceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapDeviceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapDeviceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapDeviceVarEdge(new ingenias.editor.entities.tapDeviceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("openObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof openObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new openObjVarEdge(new ingenias.editor.entities.openObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("animVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof animVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new animVarEdge(new ingenias.editor.entities.animVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("useObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof useObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new useObjVarEdge(new ingenias.editor.entities.useObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodyVarEdge(new ingenias.editor.entities.goToBodyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjDestinyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjDestinyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjDestinyVarEdge(new ingenias.editor.entities.leaveObjDestinyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapYVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapYVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapYVarEdge(new ingenias.editor.entities.tapYVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("switchRoomVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof switchRoomVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new switchRoomVarEdge(new ingenias.editor.entities.switchRoomVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOffWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOffWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOffWearableVarEdge(new ingenias.editor.entities.putOffWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("dropObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof dropObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new dropObjVarEdge(new ingenias.editor.entities.dropObjVar(getMJGraph().getNewId()));
        }
      }

    }

    return null;
  }
  
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("TimeInterval")) {
    TimeInterval nentity=getOM().createTimeInterval(getMJGraph().getNewId("TimeInterval"));
      DefaultGraphCell vertex = new
          TimeIntervalCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ClockTime")) {
    ClockTime nentity=getOM().createClockTime(getMJGraph().getNewId("ClockTime"));
      DefaultGraphCell vertex = new
          ClockTimeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("TimeInterval")) {
      return TimeIntervalView.getSize((ingenias.editor.entities.TimeInterval)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ClockTime")) {
      return ClockTimeView.getSize((ingenias.editor.entities.ClockTime)entity);      
    }
    else


      if (entity.getType().equalsIgnoreCase("NextTI")) {
      	return NextTIView.getSize((ingenias.editor.entities.NextTI)entity);
      }

      if (entity.getType().equalsIgnoreCase("ProducesEvent")) {
      	return ProducesEventView.getSize((ingenias.editor.entities.ProducesEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("cond")) {
      	return condView.getSize((ingenias.editor.entities.cond)entity);
      }

      if (entity.getType().equalsIgnoreCase("ProfileOf")) {
      	return ProfileOfView.getSize((ingenias.editor.entities.ProfileOf)entity);
      }

      if (entity.getType().equalsIgnoreCase("TIStartTime")) {
      	return TIStartTimeView.getSize((ingenias.editor.entities.TIStartTime)entity);
      }

      if (entity.getType().equalsIgnoreCase("med")) {
      	return medView.getSize((ingenias.editor.entities.med)entity);
      }

      if (entity.getType().equalsIgnoreCase("socialRelations")) {
      	return socialRelationsView.getSize((ingenias.editor.entities.socialRelations)entity);
      }

      if (entity.getType().equalsIgnoreCase("WorkAs")) {
      	return WorkAsView.getSize((ingenias.editor.entities.WorkAs)entity);
      }

      if (entity.getType().equalsIgnoreCase("LiveIn")) {
      	return LiveInView.getSize((ingenias.editor.entities.LiveIn)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedEvent")) {
      	return RelatedEventView.getSize((ingenias.editor.entities.RelatedEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActivityAttached")) {
      	return ActivityAttachedView.getSize((ingenias.editor.entities.ActivityAttached)entity);
      }

      if (entity.getType().equalsIgnoreCase("ConditionNeeded")) {
      	return ConditionNeededView.getSize((ingenias.editor.entities.ConditionNeeded)entity);
      }

      if (entity.getType().equalsIgnoreCase("Connects")) {
      	return ConnectsView.getSize((ingenias.editor.entities.Connects)entity);
      }

      if (entity.getType().equalsIgnoreCase("SBhasFloor")) {
      	return SBhasFloorView.getSize((ingenias.editor.entities.SBhasFloor)entity);
      }

      if (entity.getType().equalsIgnoreCase("tool")) {
      	return toolView.getSize((ingenias.editor.entities.tool)entity);
      }

      if (entity.getType().equalsIgnoreCase("FPrecondition")) {
      	return FPreconditionView.getSize((ingenias.editor.entities.FPrecondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("AllowedTask")) {
      	return AllowedTaskView.getSize((ingenias.editor.entities.AllowedTask)entity);
      }

      if (entity.getType().equalsIgnoreCase("relatedCondition")) {
      	return relatedConditionView.getSize((ingenias.editor.entities.relatedCondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeinv_op")) {
      	return aeinv_opView.getSize((ingenias.editor.entities.aeinv_op)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op2")) {
      	return aemd_op2View.getSize((ingenias.editor.entities.aemd_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op2")) {
      	return aeas_op2View.getSize((ingenias.editor.entities.aeas_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op1")) {
      	return aeas_op1View.getSize((ingenias.editor.entities.aeas_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op1")) {
      	return aemd_op1View.getSize((ingenias.editor.entities.aemd_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedHuman")) {
      	return RelatedHumanView.getSize((ingenias.editor.entities.RelatedHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialLocation")) {
      	return InitialLocationView.getSize((ingenias.editor.entities.InitialLocation)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialActivity")) {
      	return InitialActivityView.getSize((ingenias.editor.entities.InitialActivity)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialDate")) {
      	return InitialDateView.getSize((ingenias.editor.entities.InitialDate)entity);
      }

      if (entity.getType().equalsIgnoreCase("device")) {
      	return deviceView.getSize((ingenias.editor.entities.device)entity);
      }

      if (entity.getType().equalsIgnoreCase("CameraFaceToHuman")) {
      	return CameraFaceToHumanView.getSize((ingenias.editor.entities.CameraFaceToHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializedSymptom")) {
      	return InitializedSymptomView.getSize((ingenias.editor.entities.InitializedSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializesSymptom")) {
      	return InitializesSymptomView.getSize((ingenias.editor.entities.InitializesSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("Role")) {
      	return RoleView.getSize((ingenias.editor.entities.Role)entity);
      }

      if (entity.getType().equalsIgnoreCase("DeonticAssignement")) {
      	return DeonticAssignementView.getSize((ingenias.editor.entities.DeonticAssignement)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionResponsible")) {
      	return ActionResponsibleView.getSize((ingenias.editor.entities.ActionResponsible)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionHappeningAfterwards")) {
      	return ActionHappeningAfterwardsView.getSize((ingenias.editor.entities.ActionHappeningAfterwards)entity);
      }

      if (entity.getType().equalsIgnoreCase("AffectedAction")) {
      	return AffectedActionView.getSize((ingenias.editor.entities.AffectedAction)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodySpeedVar")) {
      	return goToBodySpeedVarView.getSize((ingenias.editor.entities.goToBodySpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjVar")) {
      	return leaveObjVarView.getSize((ingenias.editor.entities.leaveObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("closeObjVar")) {
      	return closeObjVarView.getSize((ingenias.editor.entities.closeObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("pickUpObjVar")) {
      	return pickUpObjVarView.getSize((ingenias.editor.entities.pickUpObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("waitForHumanVar")) {
      	return waitForHumanVarView.getSize((ingenias.editor.entities.waitForHumanVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("durationVar")) {
      	return durationVarView.getSize((ingenias.editor.entities.durationVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToSpeedVar")) {
      	return goToSpeedVarView.getSize((ingenias.editor.entities.goToSpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("messageVar")) {
      	return messageVarView.getSize((ingenias.editor.entities.messageVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapXVar")) {
      	return tapXVarView.getSize((ingenias.editor.entities.tapXVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("sitDownOnSeatVar")) {
      	return sitDownOnSeatVarView.getSize((ingenias.editor.entities.sitDownOnSeatVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOnWearableVar")) {
      	return putOnWearableVarView.getSize((ingenias.editor.entities.putOnWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToPlaceVar")) {
      	return goToPlaceVarView.getSize((ingenias.editor.entities.goToPlaceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapDeviceVar")) {
      	return tapDeviceVarView.getSize((ingenias.editor.entities.tapDeviceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("openObjVar")) {
      	return openObjVarView.getSize((ingenias.editor.entities.openObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("animVar")) {
      	return animVarView.getSize((ingenias.editor.entities.animVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("useObjVar")) {
      	return useObjVarView.getSize((ingenias.editor.entities.useObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodyVar")) {
      	return goToBodyVarView.getSize((ingenias.editor.entities.goToBodyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjDestinyVar")) {
      	return leaveObjDestinyVarView.getSize((ingenias.editor.entities.leaveObjDestinyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapYVar")) {
      	return tapYVarView.getSize((ingenias.editor.entities.tapYVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("switchRoomVar")) {
      	return switchRoomVarView.getSize((ingenias.editor.entities.switchRoomVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOffWearableVar")) {
      	return putOffWearableVarView.getSize((ingenias.editor.entities.putOffWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("dropObjVar")) {
      	return dropObjVarView.getSize((ingenias.editor.entities.dropObjVar)entity);
      }

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));

    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);

	Entity newEntity=(Entity) vertex.getUserObject();
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.UML)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.UML);
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.INGENIAS)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.INGENIAS);

	getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true

    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));
   

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(TimeInterval.class)) {
      vertex = new TimeIntervalCell( (TimeInterval) entity);
      // Default Size for the new Vertex with the new entity within
      size = TimeIntervalView.getSize((TimeInterval) entity);
      
    }
    else

    if (entity.getClass().equals(ClockTime.class)) {
      vertex = new ClockTimeCell( (ClockTime) entity);
      // Default Size for the new Vertex with the new entity within
      size = ClockTimeView.getSize((ClockTime) entity);
      
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
JOptionPane.showMessageDialog(this,
		 "Object not allowed in this diagram "+this.getID()+":"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName(),"Warning", JOptionPane.WARNING_MESSAGE);    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
      getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true  
        // waits for the cellview to be created
		boolean created=false;
		VertexView vv=null;
		while (!created){
			CellView[] cellviews = this.getGraphLayoutCache().getCellViews();
			for (CellView cv:cellviews){
				if (cv.getCell()==vertex){
					// created!
					created=true;
					vv=(VertexView)cv;
				}
			}
			try {
				Thread.currentThread().sleep(10);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		// This should be used when the corresponding view for the entity has containers!
		// It can be known by inspecting its renderer. To get it, a cellview is needed,
		// but the cellview is created after a while via succesive callbacks to
		// the view factories

		if (!ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null).isEmpty()){
			// there are container renderers that need new cells corresponding to children to
			// be inserted

						Hashtable<String, CollectionPanel> renderers = ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null);
			for (String field:renderers.keySet()){
				Method obtainenumeration;
				try {
					obtainenumeration = entity.getClass().getMethod("get"+field+"Elements");
					Enumeration<ingenias.editor.entities.Entity>  enom=(Enumeration<ingenias.editor.entities.Entity>) obtainenumeration.invoke(entity,new Object[]{});
					while (enom.hasMoreElements()){
						DefaultGraphCell child=this.insertDuplicated(new Point(40,10), enom.nextElement());
						try {
							getListenerContainer().setParent(child,vertex);
						} catch (WrongParent e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} 
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				}
							
		}
		
                             
    }
   return vertex;

  }


 public synchronized JGraph cloneJGraph(IDEState ids){

		

		 ADLSpecDiagramModelJGraph jg=new  ADLSpecDiagramModelJGraph(
				(ADLSpecDiagramDataEntity) this.mde,name, ids.om,
				new Model(ids),new BasicMarqueeHandler(),ids.prefs); 

		this.setSelectionCells(getGraphLayoutCache().getCells(false,true,false,false));
		Action copyaction =new EventRedirectorForGraphCopy(this,this.getTransferHandler().getCopyAction(),null	); 			
		Action pasteaction =new EventRedirectorPasteForGraphCopy(jg,jg.getTransferHandler().getPasteAction(),null	);
		copyaction.actionPerformed(new ActionEvent(this,0,"hello"));		
		pasteaction.actionPerformed(new ActionEvent(this,0,"hello"));
		jg.invalidate();
		jg.doLayout();
		
		return jg;

	}


  public String toString() {
    return this.getID();
  }

}
