

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 

package ingenias.editor.models;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;


import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.*;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.rendererxml.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;
import java.util.concurrent.TimeUnit;

public class FilterDiagramModelJGraph extends ModelJGraph {

  private Preferences prefs;
  
 

  public FilterDiagramModelJGraph(FilterDiagramDataEntity mde, 
                               String nombre, ObjectManager om, Model
                               m, BasicMarqueeHandler mh, Preferences prefs) {
    super(mde, nombre, m, mh,om);
    this.prefs=prefs;
    ToolTipManager.sharedInstance().registerComponent(this);
this.getModel().addGraphModelListener(new ChangeNARYEdgeLocation(this));
this.getModel().addGraphModelListener(new ChangeEntityLocation(this));

    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.FilterDiagramCellViewFactory());

  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }





  public JToolBar getPaleta() {
    return toolbar;

  }

  protected void creaToolBar() {
    if (toolbar==null){
    toolbar = new FilteredJToolBar("FilterDiagram");
    toolbar.setFloatable(false);
    ImageIcon undoIcon = null;
    JButton jb = null;


   if (true){
    Image img_IsThingInRoomCondition =
        ImageLoader.getImage("images/conditions/ObjLoc16.png");
    undoIcon = new ImageIcon(img_IsThingInRoomCondition);
    Action IsThingInRoomCondition=
        new AbstractAction("IsThingInRoomCondition", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "IsThingInRoomCondition");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    IsThingInRoomCondition.setEnabled(true);
    jb = new JButton(IsThingInRoomCondition){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("IsThingInRoomCondition");	
    jb.setToolTipText("IsThingInRoomCondition:"+new IsThingInRoomCondition("").getHelpDesc()+"\n\n"+new IsThingInRoomCondition("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CReceiveHelp =
        ImageLoader.getImage("images/conditions/ReceiveHelp16.png");
    undoIcon = new ImageIcon(img_CReceiveHelp);
    Action CReceiveHelp=
        new AbstractAction("CReceiveHelp", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CReceiveHelp");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CReceiveHelp.setEnabled(true);
    jb = new JButton(CReceiveHelp){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CReceiveHelp");	
    jb.setToolTipText("CReceiveHelp:"+new CReceiveHelp("").getHelpDesc()+"\n\n"+new CReceiveHelp("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CAlways =
        ImageLoader.getImage("images/conditions/CAlways16.png");
    undoIcon = new ImageIcon(img_CAlways);
    Action CAlways=
        new AbstractAction("CAlways", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CAlways");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CAlways.setEnabled(true);
    jb = new JButton(CAlways){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CAlways");	
    jb.setToolTipText("CAlways:"+new CAlways("").getHelpDesc()+"\n\n"+new CAlways("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CSymptom =
        ImageLoader.getImage("images/profiles/DiseaseProfile/CSymptom16.png");
    undoIcon = new ImageIcon(img_CSymptom);
    Action CSymptom=
        new AbstractAction("CSymptom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CSymptom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CSymptom.setEnabled(true);
    jb = new JButton(CSymptom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CSymptom");	
    jb.setToolTipText("CSymptom:"+new CSymptom("").getHelpDesc()+"\n\n"+new CSymptom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CTimer =
        ImageLoader.getImage("images/conditions/CTimer16.png");
    undoIcon = new ImageIcon(img_CTimer);
    Action CTimer=
        new AbstractAction("CTimer", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CTimer");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CTimer.setEnabled(true);
    jb = new JButton(CTimer){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CTimer");	
    jb.setToolTipText("CTimer:"+new CTimer("").getHelpDesc()+"\n\n"+new CTimer("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CTime =
        ImageLoader.getImage("images/conditions/CTime16.png");
    undoIcon = new ImageIcon(img_CTime);
    Action CTime=
        new AbstractAction("CTime", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CTime");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CTime.setEnabled(true);
    jb = new JButton(CTime){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CTime");	
    jb.setToolTipText("CTime:"+new CTime("").getHelpDesc()+"\n\n"+new CTime("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CInside =
        ImageLoader.getImage("images/conditions/inside16.png");
    undoIcon = new ImageIcon(img_CInside);
    Action CInside=
        new AbstractAction("CInside", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CInside");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CInside.setEnabled(true);
    jb = new JButton(CInside){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CInside");	
    jb.setToolTipText("CInside:"+new CInside("").getHelpDesc()+"\n\n"+new CInside("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BodyStateCondition =
        ImageLoader.getImage("images/conditions/BodyState16.png");
    undoIcon = new ImageIcon(img_BodyStateCondition);
    Action BodyStateCondition=
        new AbstractAction("BodyStateCondition", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BodyStateCondition");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BodyStateCondition.setEnabled(true);
    jb = new JButton(BodyStateCondition){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BodyStateCondition");	
    jb.setToolTipText("BodyStateCondition:"+new BodyStateCondition("").getHelpDesc()+"\n\n"+new BodyStateCondition("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CProb =
        ImageLoader.getImage("images/conditions/CProb16.png");
    undoIcon = new ImageIcon(img_CProb);
    Action CProb=
        new AbstractAction("CProb", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CProb");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CProb.setEnabled(true);
    jb = new JButton(CProb){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CProb");	
    jb.setToolTipText("CProb:"+new CProb("").getHelpDesc()+"\n\n"+new CProb("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CEvent =
        ImageLoader.getImage("images/conditions/CEvent16.png");
    undoIcon = new ImageIcon(img_CEvent);
    Action CEvent=
        new AbstractAction("CEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CEvent.setEnabled(true);
    jb = new JButton(CEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CEvent");	
    jb.setToolTipText("CEvent:"+new CEvent("").getHelpDesc()+"\n\n"+new CEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_DoorStateCondition =
        ImageLoader.getImage("images/conditions/DoorState16.png");
    undoIcon = new ImageIcon(img_DoorStateCondition);
    Action DoorStateCondition=
        new AbstractAction("DoorStateCondition", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DoorStateCondition");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DoorStateCondition.setEnabled(true);
    jb = new JButton(DoorStateCondition){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DoorStateCondition");	
    jb.setToolTipText("DoorStateCondition:"+new DoorStateCondition("").getHelpDesc()+"\n\n"+new DoorStateCondition("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_PresenceSensorStateCondition =
        ImageLoader.getImage("images/conditions/PresenceSensorState16.png");
    undoIcon = new ImageIcon(img_PresenceSensorStateCondition);
    Action PresenceSensorStateCondition=
        new AbstractAction("PresenceSensorStateCondition", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PresenceSensorStateCondition");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PresenceSensorStateCondition.setEnabled(true);
    jb = new JButton(PresenceSensorStateCondition){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PresenceSensorStateCondition");	
    jb.setToolTipText("PresenceSensorStateCondition:"+new PresenceSensorStateCondition("").getHelpDesc()+"\n\n"+new PresenceSensorStateCondition("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CSay =
        ImageLoader.getImage("images/conditions/CSay16.png");
    undoIcon = new ImageIcon(img_CSay);
    Action CSay=
        new AbstractAction("CSay", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CSay");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CSay.setEnabled(true);
    jb = new JButton(CSay){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CSay");	
    jb.setToolTipText("CSay:"+new CSay("").getHelpDesc()+"\n\n"+new CSay("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_COutside =
        ImageLoader.getImage("images/conditions/outside16.png");
    undoIcon = new ImageIcon(img_COutside);
    Action COutside=
        new AbstractAction("COutside", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "COutside");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    COutside.setEnabled(true);
    jb = new JButton(COutside){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("COutside");	
    jb.setToolTipText("COutside:"+new COutside("").getHelpDesc()+"\n\n"+new COutside("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CObjWeight =
        ImageLoader.getImage("images/conditions/CObjWeight16.png");
    undoIcon = new ImageIcon(img_CObjWeight);
    Action CObjWeight=
        new AbstractAction("CObjWeight", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CObjWeight");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CObjWeight.setEnabled(true);
    jb = new JButton(CObjWeight){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CObjWeight");	
    jb.setToolTipText("CObjWeight:"+new CObjWeight("").getHelpDesc()+"\n\n"+new CObjWeight("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_LightStateCondition =
        ImageLoader.getImage("images/conditions/LightState16.png");
    undoIcon = new ImageIcon(img_LightStateCondition);
    Action LightStateCondition=
        new AbstractAction("LightStateCondition", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "LightStateCondition");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    LightStateCondition.setEnabled(true);
    jb = new JButton(LightStateCondition){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("LightStateCondition");	
    jb.setToolTipText("LightStateCondition:"+new LightStateCondition("").getHelpDesc()+"\n\n"+new LightStateCondition("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CDayOfTheWeek =
        ImageLoader.getImage("images/conditions/CDayOfTheDay16.png");
    undoIcon = new ImageIcon(img_CDayOfTheWeek);
    Action CDayOfTheWeek=
        new AbstractAction("CDayOfTheWeek", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CDayOfTheWeek");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CDayOfTheWeek.setEnabled(true);
    jb = new JButton(CDayOfTheWeek){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CDayOfTheWeek");	
    jb.setToolTipText("CDayOfTheWeek:"+new CDayOfTheWeek("").getHelpDesc()+"\n\n"+new CDayOfTheWeek("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_NotCondition =
        ImageLoader.getImage("images/conditions/NotCondition16.png");
    undoIcon = new ImageIcon(img_NotCondition);
    Action NotCondition=
        new AbstractAction("NotCondition", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "NotCondition");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    NotCondition.setEnabled(true);
    jb = new JButton(NotCondition){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("NotCondition");	
    jb.setToolTipText("NotCondition:"+new NotCondition("").getHelpDesc()+"\n\n"+new NotCondition("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CSymptom =
        ImageLoader.getImage("images/profiles/DiseaseProfile/CSymptom16.png");
    undoIcon = new ImageIcon(img_CSymptom);
    Action CSymptom=
        new AbstractAction("CSymptom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CSymptom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CSymptom.setEnabled(true);
    jb = new JButton(CSymptom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CSymptom");	
    jb.setToolTipText("CSymptom:"+new CSymptom("").getHelpDesc()+"\n\n"+new CSymptom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SwipeTask =
        ImageLoader.getImage("images/behaviour/tasks/Swipe16.png");
    undoIcon = new ImageIcon(img_SwipeTask);
    Action SwipeTask=
        new AbstractAction("SwipeTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SwipeTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SwipeTask.setEnabled(true);
    jb = new JButton(SwipeTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SwipeTask");	
    jb.setToolTipText("SwipeTask:"+new SwipeTask("").getHelpDesc()+"\n\n"+new SwipeTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_GoToBodyLoc =
        ImageLoader.getImage("images/behaviour/tasks/GoToBodyLoc16.png");
    undoIcon = new ImageIcon(img_GoToBodyLoc);
    Action GoToBodyLoc=
        new AbstractAction("GoToBodyLoc", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "GoToBodyLoc");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    GoToBodyLoc.setEnabled(true);
    jb = new JButton(GoToBodyLoc){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("GoToBodyLoc");	
    jb.setToolTipText("GoToBodyLoc:"+new GoToBodyLoc("").getHelpDesc()+"\n\n"+new GoToBodyLoc("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_DropObj =
        ImageLoader.getImage("images/behaviour/tasks/ObjDropped16.png");
    undoIcon = new ImageIcon(img_DropObj);
    Action DropObj=
        new AbstractAction("DropObj", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DropObj");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DropObj.setEnabled(true);
    jb = new JButton(DropObj){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DropObj");	
    jb.setToolTipText("DropObj:"+new DropObj("").getHelpDesc()+"\n\n"+new DropObj("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_OpenTask =
        ImageLoader.getImage("images/behaviour/tasks/Open16.png");
    undoIcon = new ImageIcon(img_OpenTask);
    Action OpenTask=
        new AbstractAction("OpenTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "OpenTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    OpenTask.setEnabled(true);
    jb = new JButton(OpenTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("OpenTask");	
    jb.setToolTipText("OpenTask:"+new OpenTask("").getHelpDesc()+"\n\n"+new OpenTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BGoToTask =
        ImageLoader.getImage("images/behaviour/tasks/GoToTask16.png");
    undoIcon = new ImageIcon(img_BGoToTask);
    Action BGoToTask=
        new AbstractAction("BGoToTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BGoToTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BGoToTask.setEnabled(true);
    jb = new JButton(BGoToTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BGoToTask");	
    jb.setToolTipText("BGoToTask:"+new BGoToTask("").getHelpDesc()+"\n\n"+new BGoToTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SayTask =
        ImageLoader.getImage("images/behaviour/tasks/Say16.png");
    undoIcon = new ImageIcon(img_SayTask);
    Action SayTask=
        new AbstractAction("SayTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SayTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SayTask.setEnabled(true);
    jb = new JButton(SayTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SayTask");	
    jb.setToolTipText("SayTask:"+new SayTask("").getHelpDesc()+"\n\n"+new SayTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_TapXYTask =
        ImageLoader.getImage("images/behaviour/tasks/TapXY16.png");
    undoIcon = new ImageIcon(img_TapXYTask);
    Action TapXYTask=
        new AbstractAction("TapXYTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "TapXYTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    TapXYTask.setEnabled(true);
    jb = new JButton(TapXYTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("TapXYTask");	
    jb.setToolTipText("TapXYTask:"+new TapXYTask("").getHelpDesc()+"\n\n"+new TapXYTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_WaitForBodyClose =
        ImageLoader.getImage("images/behaviour/tasks/WaitForBodyClose16.png");
    undoIcon = new ImageIcon(img_WaitForBodyClose);
    Action WaitForBodyClose=
        new AbstractAction("WaitForBodyClose", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WaitForBodyClose");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WaitForBodyClose.setEnabled(true);
    jb = new JButton(WaitForBodyClose){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WaitForBodyClose");	
    jb.setToolTipText("WaitForBodyClose:"+new WaitForBodyClose("").getHelpDesc()+"\n\n"+new WaitForBodyClose("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CloseTask =
        ImageLoader.getImage("images/behaviour/tasks/Close16.png");
    undoIcon = new ImageIcon(img_CloseTask);
    Action CloseTask=
        new AbstractAction("CloseTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CloseTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CloseTask.setEnabled(true);
    jb = new JButton(CloseTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CloseTask");	
    jb.setToolTipText("CloseTask:"+new CloseTask("").getHelpDesc()+"\n\n"+new CloseTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FallTask =
        ImageLoader.getImage("images/behaviour/tasks/Fall16.png");
    undoIcon = new ImageIcon(img_FallTask);
    Action FallTask=
        new AbstractAction("FallTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FallTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FallTask.setEnabled(true);
    jb = new JButton(FallTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FallTask");	
    jb.setToolTipText("FallTask:"+new FallTask("").getHelpDesc()+"\n\n"+new FallTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SwitchLightTask =
        ImageLoader.getImage("images/behaviour/tasks/PressSwitch16.png");
    undoIcon = new ImageIcon(img_SwitchLightTask);
    Action SwitchLightTask=
        new AbstractAction("SwitchLightTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SwitchLightTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SwitchLightTask.setEnabled(true);
    jb = new JButton(SwitchLightTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SwitchLightTask");	
    jb.setToolTipText("SwitchLightTask:"+new SwitchLightTask("").getHelpDesc()+"\n\n"+new SwitchLightTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FTaskSelectorFilter =
        ImageLoader.getImage("images/profiles/filter/TaskSelectorFilter16.png");
    undoIcon = new ImageIcon(img_FTaskSelectorFilter);
    Action FTaskSelectorFilter=
        new AbstractAction("FTaskSelectorFilter", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FTaskSelectorFilter");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FTaskSelectorFilter.setEnabled(true);
    jb = new JButton(FTaskSelectorFilter){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FTaskSelectorFilter");	
    jb.setToolTipText("FTaskSelectorFilter:"+new FTaskSelectorFilter("").getHelpDesc()+"\n\n"+new FTaskSelectorFilter("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FReplaceTaskFilter =
        ImageLoader.getImage("images/profiles/filter/ReplaceTaskFilter16.png");
    undoIcon = new ImageIcon(img_FReplaceTaskFilter);
    Action FReplaceTaskFilter=
        new AbstractAction("FReplaceTaskFilter", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FReplaceTaskFilter");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FReplaceTaskFilter.setEnabled(true);
    jb = new JButton(FReplaceTaskFilter){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FReplaceTaskFilter");	
    jb.setToolTipText("FReplaceTaskFilter:"+new FReplaceTaskFilter("").getHelpDesc()+"\n\n"+new FReplaceTaskFilter("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FUnableFilter =
        ImageLoader.getImage("images/profiles/filter/FUnableFilter16.png");
    undoIcon = new ImageIcon(img_FUnableFilter);
    Action FUnableFilter=
        new AbstractAction("FUnableFilter", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FUnableFilter");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FUnableFilter.setEnabled(true);
    jb = new JButton(FUnableFilter){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FUnableFilter");	
    jb.setToolTipText("FUnableFilter:"+new FUnableFilter("").getHelpDesc()+"\n\n"+new FUnableFilter("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FChangeTargetObjFilter =
        ImageLoader.getImage("images/profiles/filter/ChangeTargetObj16.png");
    undoIcon = new ImageIcon(img_FChangeTargetObjFilter);
    Action FChangeTargetObjFilter=
        new AbstractAction("FChangeTargetObjFilter", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FChangeTargetObjFilter");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FChangeTargetObjFilter.setEnabled(true);
    jb = new JButton(FChangeTargetObjFilter){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FChangeTargetObjFilter");	
    jb.setToolTipText("FChangeTargetObjFilter:"+new FChangeTargetObjFilter("").getHelpDesc()+"\n\n"+new FChangeTargetObjFilter("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FModifyPlaceFilter =
        ImageLoader.getImage("images/profiles/filter/ChangePlace16.png");
    undoIcon = new ImageIcon(img_FModifyPlaceFilter);
    Action FModifyPlaceFilter=
        new AbstractAction("FModifyPlaceFilter", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FModifyPlaceFilter");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FModifyPlaceFilter.setEnabled(true);
    jb = new JButton(FModifyPlaceFilter){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FModifyPlaceFilter");	
    jb.setToolTipText("FModifyPlaceFilter:"+new FModifyPlaceFilter("").getHelpDesc()+"\n\n"+new FModifyPlaceFilter("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FChangeToolFilter =
        ImageLoader.getImage("images/profiles/filter/ChangeToolFilter16.png");
    undoIcon = new ImageIcon(img_FChangeToolFilter);
    Action FChangeToolFilter=
        new AbstractAction("FChangeToolFilter", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FChangeToolFilter");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FChangeToolFilter.setEnabled(true);
    jb = new JButton(FChangeToolFilter){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FChangeToolFilter");	
    jb.setToolTipText("FChangeToolFilter:"+new FChangeToolFilter("").getHelpDesc()+"\n\n"+new FChangeToolFilter("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FDelayFilter =
        ImageLoader.getImage("images/profiles/filter/DelayFilter16.png");
    undoIcon = new ImageIcon(img_FDelayFilter);
    Action FDelayFilter=
        new AbstractAction("FDelayFilter", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FDelayFilter");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FDelayFilter.setEnabled(true);
    jb = new JButton(FDelayFilter){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FDelayFilter");	
    jb.setToolTipText("FDelayFilter:"+new FDelayFilter("").getHelpDesc()+"\n\n"+new FDelayFilter("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_TakeOffTask =
        ImageLoader.getImage("images/behaviour/tasks/TakeOff16.png");
    undoIcon = new ImageIcon(img_TakeOffTask);
    Action TakeOffTask=
        new AbstractAction("TakeOffTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "TakeOffTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    TakeOffTask.setEnabled(true);
    jb = new JButton(TakeOffTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("TakeOffTask");	
    jb.setToolTipText("TakeOffTask:"+new TakeOffTask("").getHelpDesc()+"\n\n"+new TakeOffTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_WaitTask =
        ImageLoader.getImage("images/behaviour/tasks/Wait16.png");
    undoIcon = new ImageIcon(img_WaitTask);
    Action WaitTask=
        new AbstractAction("WaitTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WaitTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WaitTask.setEnabled(true);
    jb = new JButton(WaitTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WaitTask");	
    jb.setToolTipText("WaitTask:"+new WaitTask("").getHelpDesc()+"\n\n"+new WaitTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BPickUpTask =
        ImageLoader.getImage("images/behaviour/tasks/PickUp16.png");
    undoIcon = new ImageIcon(img_BPickUpTask);
    Action BPickUpTask=
        new AbstractAction("BPickUpTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BPickUpTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BPickUpTask.setEnabled(true);
    jb = new JButton(BPickUpTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BPickUpTask");	
    jb.setToolTipText("BPickUpTask:"+new BPickUpTask("").getHelpDesc()+"\n\n"+new BPickUpTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FallSleep =
        ImageLoader.getImage("images/behaviour/tasks/FallSleepTask16.png");
    undoIcon = new ImageIcon(img_FallSleep);
    Action FallSleep=
        new AbstractAction("FallSleep", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FallSleep");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FallSleep.setEnabled(true);
    jb = new JButton(FallSleep){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FallSleep");	
    jb.setToolTipText("FallSleep:"+new FallSleep("").getHelpDesc()+"\n\n"+new FallSleep("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_Drink =
        ImageLoader.getImage("images/behaviour/tasks/Drink16.png");
    undoIcon = new ImageIcon(img_Drink);
    Action Drink=
        new AbstractAction("Drink", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Drink");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Drink.setEnabled(true);
    jb = new JButton(Drink){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Drink");	
    jb.setToolTipText("Drink:"+new Drink("").getHelpDesc()+"\n\n"+new Drink("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BWakeUpTask =
        ImageLoader.getImage("images/behaviour/tasks/WakeUp16.png");
    undoIcon = new ImageIcon(img_BWakeUpTask);
    Action BWakeUpTask=
        new AbstractAction("BWakeUpTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BWakeUpTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BWakeUpTask.setEnabled(true);
    jb = new JButton(BWakeUpTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BWakeUpTask");	
    jb.setToolTipText("BWakeUpTask:"+new BWakeUpTask("").getHelpDesc()+"\n\n"+new BWakeUpTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_PutOnTask =
        ImageLoader.getImage("images/behaviour/tasks/PutOn16.png");
    undoIcon = new ImageIcon(img_PutOnTask);
    Action PutOnTask=
        new AbstractAction("PutOnTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PutOnTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PutOnTask.setEnabled(true);
    jb = new JButton(PutOnTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PutOnTask");	
    jb.setToolTipText("PutOnTask:"+new PutOnTask("").getHelpDesc()+"\n\n"+new PutOnTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_StandUp =
        ImageLoader.getImage("images/behaviour/tasks/StandUp16.png");
    undoIcon = new ImageIcon(img_StandUp);
    Action StandUp=
        new AbstractAction("StandUp", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "StandUp");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    StandUp.setEnabled(true);
    jb = new JButton(StandUp){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("StandUp");	
    jb.setToolTipText("StandUp:"+new StandUp("").getHelpDesc()+"\n\n"+new StandUp("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_PlayAnimationTask =
        ImageLoader.getImage("images/behaviour/tasks/PlayAnim16.png");
    undoIcon = new ImageIcon(img_PlayAnimationTask);
    Action PlayAnimationTask=
        new AbstractAction("PlayAnimationTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PlayAnimationTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PlayAnimationTask.setEnabled(true);
    jb = new JButton(PlayAnimationTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PlayAnimationTask");	
    jb.setToolTipText("PlayAnimationTask:"+new PlayAnimationTask("").getHelpDesc()+"\n\n"+new PlayAnimationTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SitDown =
        ImageLoader.getImage("images/behaviour/tasks/SitDown16.png");
    undoIcon = new ImageIcon(img_SitDown);
    Action SitDown=
        new AbstractAction("SitDown", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SitDown");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SitDown.setEnabled(true);
    jb = new JButton(SitDown){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SitDown");	
    jb.setToolTipText("SitDown:"+new SitDown("").getHelpDesc()+"\n\n"+new SitDown("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_GoIntoBed =
        ImageLoader.getImage("images/behaviour/tasks/GoIntoBed16.png");
    undoIcon = new ImageIcon(img_GoIntoBed);
    Action GoIntoBed=
        new AbstractAction("GoIntoBed", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "GoIntoBed");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    GoIntoBed.setEnabled(true);
    jb = new JButton(GoIntoBed){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("GoIntoBed");	
    jb.setToolTipText("GoIntoBed:"+new GoIntoBed("").getHelpDesc()+"\n\n"+new GoIntoBed("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_Eat =
        ImageLoader.getImage("images/behaviour/tasks/Eat16.png");
    undoIcon = new ImageIcon(img_Eat);
    Action Eat=
        new AbstractAction("Eat", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Eat");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Eat.setEnabled(true);
    jb = new JButton(Eat){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Eat");	
    jb.setToolTipText("Eat:"+new Eat("").getHelpDesc()+"\n\n"+new Eat("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BUseTask =
        ImageLoader.getImage("images/behaviour/tasks/UseTask16.png");
    undoIcon = new ImageIcon(img_BUseTask);
    Action BUseTask=
        new AbstractAction("BUseTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BUseTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BUseTask.setEnabled(true);
    jb = new JButton(BUseTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BUseTask");	
    jb.setToolTipText("BUseTask:"+new BUseTask("").getHelpDesc()+"\n\n"+new BUseTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BLeaveTask =
        ImageLoader.getImage("images/behaviour/tasks/Leave16.png");
    undoIcon = new ImageIcon(img_BLeaveTask);
    Action BLeaveTask=
        new AbstractAction("BLeaveTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BLeaveTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BLeaveTask.setEnabled(true);
    jb = new JButton(BLeaveTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BLeaveTask");	
    jb.setToolTipText("BLeaveTask:"+new BLeaveTask("").getHelpDesc()+"\n\n"+new BLeaveTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BGetUpFromBed =
        ImageLoader.getImage("images/behaviour/tasks/GetUpFromBed16.png");
    undoIcon = new ImageIcon(img_BGetUpFromBed);
    Action BGetUpFromBed=
        new AbstractAction("BGetUpFromBed", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BGetUpFromBed");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BGetUpFromBed.setEnabled(true);
    jb = new JButton(BGetUpFromBed){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BGetUpFromBed");	
    jb.setToolTipText("BGetUpFromBed:"+new BGetUpFromBed("").getHelpDesc()+"\n\n"+new BGetUpFromBed("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BSequentialTask =
        ImageLoader.getImage("images/behaviour/tasks/CTSequential16.png");
    undoIcon = new ImageIcon(img_BSequentialTask);
    Action BSequentialTask=
        new AbstractAction("BSequentialTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BSequentialTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BSequentialTask.setEnabled(true);
    jb = new JButton(BSequentialTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BSequentialTask");	
    jb.setToolTipText("BSequentialTask:"+new BSequentialTask("").getHelpDesc()+"\n\n"+new BSequentialTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BRandomTask =
        ImageLoader.getImage("images/behaviour/tasks/CTRandom16.png");
    undoIcon = new ImageIcon(img_BRandomTask);
    Action BRandomTask=
        new AbstractAction("BRandomTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BRandomTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BRandomTask.setEnabled(true);
    jb = new JButton(BRandomTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BRandomTask");	
    jb.setToolTipText("BRandomTask:"+new BRandomTask("").getHelpDesc()+"\n\n"+new BRandomTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SymptomChangedEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SymptomChangedEvent);
    Action SymptomChangedEvent=
        new AbstractAction("SymptomChangedEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SymptomChangedEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SymptomChangedEvent.setEnabled(true);
    jb = new JButton(SymptomChangedEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SymptomChangedEvent");	
    jb.setToolTipText("SymptomChangedEvent:"+new SymptomChangedEvent("").getHelpDesc()+"\n\n"+new SymptomChangedEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Crutch =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Crutch);
    Action Crutch=
        new AbstractAction("Crutch", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Crutch");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Crutch.setEnabled(true);
    jb = new JButton(Crutch){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Crutch");	
    jb.setToolTipText("Crutch:"+new Crutch("").getHelpDesc()+"\n\n"+new Crutch("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_MedsTakenEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_MedsTakenEvent);
    Action MedsTakenEvent=
        new AbstractAction("MedsTakenEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "MedsTakenEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    MedsTakenEvent.setEnabled(true);
    jb = new JButton(MedsTakenEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("MedsTakenEvent");	
    jb.setToolTipText("MedsTakenEvent:"+new MedsTakenEvent("").getHelpDesc()+"\n\n"+new MedsTakenEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EMedicine =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EMedicine);
    Action EMedicine=
        new AbstractAction("EMedicine", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EMedicine");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EMedicine.setEnabled(true);
    jb = new JButton(EMedicine){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EMedicine");	
    jb.setToolTipText("EMedicine:"+new EMedicine("").getHelpDesc()+"\n\n"+new EMedicine("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shoes =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shoes);
    Action Shoes=
        new AbstractAction("Shoes", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shoes");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shoes.setEnabled(true);
    jb = new JButton(Shoes){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shoes");	
    jb.setToolTipText("Shoes:"+new Shoes("").getHelpDesc()+"\n\n"+new Shoes("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOWashbasin =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOWashbasin);
    Action FOWashbasin=
        new AbstractAction("FOWashbasin", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOWashbasin");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOWashbasin.setEnabled(true);
    jb = new JButton(FOWashbasin){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOWashbasin");	
    jb.setToolTipText("FOWashbasin:"+new FOWashbasin("").getHelpDesc()+"\n\n"+new FOWashbasin("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOSink =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOSink);
    Action FOSink=
        new AbstractAction("FOSink", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOSink");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOSink.setEnabled(true);
    jb = new JButton(FOSink){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOSink");	
    jb.setToolTipText("FOSink:"+new FOSink("").getHelpDesc()+"\n\n"+new FOSink("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Lift =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Lift);
    Action Lift=
        new AbstractAction("Lift", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Lift");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Lift.setEnabled(true);
    jb = new JButton(Lift){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Lift");	
    jb.setToolTipText("Lift:"+new Lift("").getHelpDesc()+"\n\n"+new Lift("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shirt =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shirt);
    Action Shirt=
        new AbstractAction("Shirt", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shirt");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shirt.setEnabled(true);
    jb = new JButton(Shirt){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shirt");	
    jb.setToolTipText("Shirt:"+new Shirt("").getHelpDesc()+"\n\n"+new Shirt("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_StopBehaviourEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_StopBehaviourEvent);
    Action StopBehaviourEvent=
        new AbstractAction("StopBehaviourEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "StopBehaviourEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    StopBehaviourEvent.setEnabled(true);
    jb = new JButton(StopBehaviourEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("StopBehaviourEvent");	
    jb.setToolTipText("StopBehaviourEvent:"+new StopBehaviourEvent("").getHelpDesc()+"\n\n"+new StopBehaviourEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_VibrateEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_VibrateEvent);
    Action VibrateEvent=
        new AbstractAction("VibrateEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "VibrateEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    VibrateEvent.setEnabled(true);
    jb = new JButton(VibrateEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("VibrateEvent");	
    jb.setToolTipText("VibrateEvent:"+new VibrateEvent("").getHelpDesc()+"\n\n"+new VibrateEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SBathroom =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SBathroom);
    Action SBathroom=
        new AbstractAction("SBathroom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SBathroom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SBathroom.setEnabled(true);
    jb = new JButton(SBathroom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SBathroom");	
    jb.setToolTipText("SBathroom:"+new SBathroom("").getHelpDesc()+"\n\n"+new SBathroom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shower =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shower);
    Action Shower=
        new AbstractAction("Shower", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shower");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shower.setEnabled(true);
    jb = new JButton(Shower){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shower");	
    jb.setToolTipText("Shower:"+new Shower("").getHelpDesc()+"\n\n"+new Shower("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FWardrobe =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FWardrobe);
    Action FWardrobe=
        new AbstractAction("FWardrobe", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FWardrobe");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FWardrobe.setEnabled(true);
    jb = new JButton(FWardrobe){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FWardrobe");	
    jb.setToolTipText("FWardrobe:"+new FWardrobe("").getHelpDesc()+"\n\n"+new FWardrobe("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_ObjDroppedEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_ObjDroppedEvent);
    Action ObjDroppedEvent=
        new AbstractAction("ObjDroppedEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ObjDroppedEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ObjDroppedEvent.setEnabled(true);
    jb = new JButton(ObjDroppedEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ObjDroppedEvent");	
    jb.setToolTipText("ObjDroppedEvent:"+new ObjDroppedEvent("").getHelpDesc()+"\n\n"+new ObjDroppedEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Human =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Human);
    Action Human=
        new AbstractAction("Human", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Human");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Human.setEnabled(true);
    jb = new JButton(Human){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Human");	
    jb.setToolTipText("Human:"+new Human("").getHelpDesc()+"\n\n"+new Human("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_MessageListenedEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_MessageListenedEvent);
    Action MessageListenedEvent=
        new AbstractAction("MessageListenedEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "MessageListenedEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    MessageListenedEvent.setEnabled(true);
    jb = new JButton(MessageListenedEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("MessageListenedEvent");	
    jb.setToolTipText("MessageListenedEvent:"+new MessageListenedEvent("").getHelpDesc()+"\n\n"+new MessageListenedEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_ERemoteControl =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_ERemoteControl);
    Action ERemoteControl=
        new AbstractAction("ERemoteControl", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ERemoteControl");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ERemoteControl.setEnabled(true);
    jb = new JButton(ERemoteControl){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ERemoteControl");	
    jb.setToolTipText("ERemoteControl:"+new ERemoteControl("").getHelpDesc()+"\n\n"+new ERemoteControl("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_StartBehaviourEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_StartBehaviourEvent);
    Action StartBehaviourEvent=
        new AbstractAction("StartBehaviourEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "StartBehaviourEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    StartBehaviourEvent.setEnabled(true);
    jb = new JButton(StartBehaviourEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("StartBehaviourEvent");	
    jb.setToolTipText("StartBehaviourEvent:"+new StartBehaviourEvent("").getHelpDesc()+"\n\n"+new StartBehaviourEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_ESleepers =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_ESleepers);
    Action ESleepers=
        new AbstractAction("ESleepers", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ESleepers");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ESleepers.setEnabled(true);
    jb = new JButton(ESleepers){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ESleepers");	
    jb.setToolTipText("ESleepers:"+new ESleepers("").getHelpDesc()+"\n\n"+new ESleepers("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Dishwasher =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Dishwasher);
    Action Dishwasher=
        new AbstractAction("Dishwasher", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Dishwasher");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Dishwasher.setEnabled(true);
    jb = new JButton(Dishwasher){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Dishwasher");	
    jb.setToolTipText("Dishwasher:"+new Dishwasher("").getHelpDesc()+"\n\n"+new Dishwasher("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_WashMachine =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_WashMachine);
    Action WashMachine=
        new AbstractAction("WashMachine", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WashMachine");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WashMachine.setEnabled(true);
    jb = new JButton(WashMachine){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WashMachine");	
    jb.setToolTipText("WashMachine:"+new WashMachine("").getHelpDesc()+"\n\n"+new WashMachine("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EatableItem =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EatableItem);
    Action EatableItem=
        new AbstractAction("EatableItem", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EatableItem");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EatableItem.setEnabled(true);
    jb = new JButton(EatableItem){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EatableItem");	
    jb.setToolTipText("EatableItem:"+new EatableItem("").getHelpDesc()+"\n\n"+new EatableItem("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Walker =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Walker);
    Action Walker=
        new AbstractAction("Walker", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Walker");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Walker.setEnabled(true);
    jb = new JButton(Walker){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Walker");	
    jb.setToolTipText("Walker:"+new Walker("").getHelpDesc()+"\n\n"+new Walker("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Cane =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Cane);
    Action Cane=
        new AbstractAction("Cane", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Cane");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Cane.setEnabled(true);
    jb = new JButton(Cane){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Cane");	
    jb.setToolTipText("Cane:"+new Cane("").getHelpDesc()+"\n\n"+new Cane("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_DComputer =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_DComputer);
    Action DComputer=
        new AbstractAction("DComputer", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DComputer");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DComputer.setEnabled(true);
    jb = new JButton(DComputer){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DComputer");	
    jb.setToolTipText("DComputer:"+new DComputer("").getHelpDesc()+"\n\n"+new DComputer("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SCorridor =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SCorridor);
    Action SCorridor=
        new AbstractAction("SCorridor", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SCorridor");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SCorridor.setEnabled(true);
    jb = new JButton(SCorridor){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SCorridor");	
    jb.setToolTipText("SCorridor:"+new SCorridor("").getHelpDesc()+"\n\n"+new SCorridor("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SArea =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SArea);
    Action SArea=
        new AbstractAction("SArea", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SArea");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SArea.setEnabled(true);
    jb = new JButton(SArea){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SArea");	
    jb.setToolTipText("SArea:"+new SArea("").getHelpDesc()+"\n\n"+new SArea("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_ESmartPhone =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_ESmartPhone);
    Action ESmartPhone=
        new AbstractAction("ESmartPhone", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ESmartPhone");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ESmartPhone.setEnabled(true);
    jb = new JButton(ESmartPhone){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ESmartPhone");	
    jb.setToolTipText("ESmartPhone:"+new ESmartPhone("").getHelpDesc()+"\n\n"+new ESmartPhone("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_DrinkItem =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_DrinkItem);
    Action DrinkItem=
        new AbstractAction("DrinkItem", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DrinkItem");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DrinkItem.setEnabled(true);
    jb = new JButton(DrinkItem){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DrinkItem");	
    jb.setToolTipText("DrinkItem:"+new DrinkItem("").getHelpDesc()+"\n\n"+new DrinkItem("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOBath =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOBath);
    Action FOBath=
        new AbstractAction("FOBath", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOBath");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOBath.setEnabled(true);
    jb = new JButton(FOBath){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOBath");	
    jb.setToolTipText("FOBath:"+new FOBath("").getHelpDesc()+"\n\n"+new FOBath("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shocks =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shocks);
    Action Shocks=
        new AbstractAction("Shocks", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shocks");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shocks.setEnabled(true);
    jb = new JButton(Shocks){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shocks");	
    jb.setToolTipText("Shocks:"+new Shocks("").getHelpDesc()+"\n\n"+new Shocks("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Bridge =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Bridge);
    Action Bridge=
        new AbstractAction("Bridge", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Bridge");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Bridge.setEnabled(true);
    jb = new JButton(Bridge){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Bridge");	
    jb.setToolTipText("Bridge:"+new Bridge("").getHelpDesc()+"\n\n"+new Bridge("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EMobileDevice =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EMobileDevice);
    Action EMobileDevice=
        new AbstractAction("EMobileDevice", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EMobileDevice");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EMobileDevice.setEnabled(true);
    jb = new JButton(EMobileDevice){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EMobileDevice");	
    jb.setToolTipText("EMobileDevice:"+new EMobileDevice("").getHelpDesc()+"\n\n"+new EMobileDevice("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_DTV =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_DTV);
    Action DTV=
        new AbstractAction("DTV", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DTV");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DTV.setEnabled(true);
    jb = new JButton(DTV){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DTV");	
    jb.setToolTipText("DTV:"+new DTV("").getHelpDesc()+"\n\n"+new DTV("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FChair =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FChair);
    Action FChair=
        new AbstractAction("FChair", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FChair");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FChair.setEnabled(true);
    jb = new JButton(FChair){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FChair");	
    jb.setToolTipText("FChair:"+new FChair("").getHelpDesc()+"\n\n"+new FChair("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Pyjamas =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Pyjamas);
    Action Pyjamas=
        new AbstractAction("Pyjamas", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Pyjamas");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Pyjamas.setEnabled(true);
    jb = new JButton(Pyjamas){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Pyjamas");	
    jb.setToolTipText("Pyjamas:"+new Pyjamas("").getHelpDesc()+"\n\n"+new Pyjamas("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Staircase =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Staircase);
    Action Staircase=
        new AbstractAction("Staircase", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Staircase");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Staircase.setEnabled(true);
    jb = new JButton(Staircase){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Staircase");	
    jb.setToolTipText("Staircase:"+new Staircase("").getHelpDesc()+"\n\n"+new Staircase("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Doorbell =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Doorbell);
    Action Doorbell=
        new AbstractAction("Doorbell", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Doorbell");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Doorbell.setEnabled(true);
    jb = new JButton(Doorbell){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Doorbell");	
    jb.setToolTipText("Doorbell:"+new Doorbell("").getHelpDesc()+"\n\n"+new Doorbell("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Appliance =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Appliance);
    Action Appliance=
        new AbstractAction("Appliance", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Appliance");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Appliance.setEnabled(true);
    jb = new JButton(Appliance){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Appliance");	
    jb.setToolTipText("Appliance:"+new Appliance("").getHelpDesc()+"\n\n"+new Appliance("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_CallStateEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_CallStateEvent);
    Action CallStateEvent=
        new AbstractAction("CallStateEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CallStateEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CallStateEvent.setEnabled(true);
    jb = new JButton(CallStateEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CallStateEvent");	
    jb.setToolTipText("CallStateEvent:"+new CallStateEvent("").getHelpDesc()+"\n\n"+new CallStateEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FallingEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FallingEvent);
    Action FallingEvent=
        new AbstractAction("FallingEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FallingEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FallingEvent.setEnabled(true);
    jb = new JButton(FallingEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FallingEvent");	
    jb.setToolTipText("FallingEvent:"+new FallingEvent("").getHelpDesc()+"\n\n"+new FallingEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SFloor =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SFloor);
    Action SFloor=
        new AbstractAction("SFloor", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SFloor");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SFloor.setEnabled(true);
    jb = new JButton(SFloor){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SFloor");	
    jb.setToolTipText("SFloor:"+new SFloor("").getHelpDesc()+"\n\n"+new SFloor("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Extractor =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Extractor);
    Action Extractor=
        new AbstractAction("Extractor", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Extractor");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Extractor.setEnabled(true);
    jb = new JButton(Extractor){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Extractor");	
    jb.setToolTipText("Extractor:"+new Extractor("").getHelpDesc()+"\n\n"+new Extractor("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BEvent);
    Action BEvent=
        new AbstractAction("BEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BEvent.setEnabled(true);
    jb = new JButton(BEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BEvent");	
    jb.setToolTipText("BEvent:"+new BEvent("").getHelpDesc()+"\n\n"+new BEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SLivingroom =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SLivingroom);
    Action SLivingroom=
        new AbstractAction("SLivingroom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SLivingroom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SLivingroom.setEnabled(true);
    jb = new JButton(SLivingroom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SLivingroom");	
    jb.setToolTipText("SLivingroom:"+new SLivingroom("").getHelpDesc()+"\n\n"+new SLivingroom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SKitchen =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SKitchen);
    Action SKitchen=
        new AbstractAction("SKitchen", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SKitchen");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SKitchen.setEnabled(true);
    jb = new JButton(SKitchen){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SKitchen");	
    jb.setToolTipText("SKitchen:"+new SKitchen("").getHelpDesc()+"\n\n"+new SKitchen("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SBuilding =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SBuilding);
    Action SBuilding=
        new AbstractAction("SBuilding", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SBuilding");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SBuilding.setEnabled(true);
    jb = new JButton(SBuilding){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SBuilding");	
    jb.setToolTipText("SBuilding:"+new SBuilding("").getHelpDesc()+"\n\n"+new SBuilding("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EPrivateEvent =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EPrivateEvent);
    Action EPrivateEvent=
        new AbstractAction("EPrivateEvent", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EPrivateEvent");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EPrivateEvent.setEnabled(true);
    jb = new JButton(EPrivateEvent){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EPrivateEvent");	
    jb.setToolTipText("EPrivateEvent:"+new EPrivateEvent("").getHelpDesc()+"\n\n"+new EPrivateEvent("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SBedroom =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SBedroom);
    Action SBedroom=
        new AbstractAction("SBedroom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SBedroom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SBedroom.setEnabled(true);
    jb = new JButton(SBedroom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SBedroom");	
    jb.setToolTipText("SBedroom:"+new SBedroom("").getHelpDesc()+"\n\n"+new SBedroom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FTable =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FTable);
    Action FTable=
        new AbstractAction("FTable", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FTable");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FTable.setEnabled(true);
    jb = new JButton(FTable){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FTable");	
    jb.setToolTipText("FTable:"+new FTable("").getHelpDesc()+"\n\n"+new FTable("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Trousers =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Trousers);
    Action Trousers=
        new AbstractAction("Trousers", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Trousers");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Trousers.setEnabled(true);
    jb = new JButton(Trousers){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Trousers");	
    jb.setToolTipText("Trousers:"+new Trousers("").getHelpDesc()+"\n\n"+new Trousers("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOWater =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOWater);
    Action FOWater=
        new AbstractAction("FOWater", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOWater");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOWater.setEnabled(true);
    jb = new JButton(FOWater){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOWater");	
    jb.setToolTipText("FOWater:"+new FOWater("").getHelpDesc()+"\n\n"+new FOWater("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EWaterBottle =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EWaterBottle);
    Action EWaterBottle=
        new AbstractAction("EWaterBottle", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EWaterBottle");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EWaterBottle.setEnabled(true);
    jb = new JButton(EWaterBottle){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EWaterBottle");	
    jb.setToolTipText("EWaterBottle:"+new EWaterBottle("").getHelpDesc()+"\n\n"+new EWaterBottle("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FBed =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FBed);
    Action FBed=
        new AbstractAction("FBed", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FBed");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FBed.setEnabled(true);
    jb = new JButton(FBed){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FBed");	
    jb.setToolTipText("FBed:"+new FBed("").getHelpDesc()+"\n\n"+new FBed("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FSofa =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FSofa);
    Action FSofa=
        new AbstractAction("FSofa", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FSofa");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FSofa.setEnabled(true);
    jb = new JButton(FSofa){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FSofa");	
    jb.setToolTipText("FSofa:"+new FSofa("").getHelpDesc()+"\n\n"+new FSofa("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

    }

  }

  public Vector<String> getAllowedRelationships(){
   Vector<String> relationships=new   Vector<String>();


          relationships.add("FAlternative");

          relationships.add("NextFilter");

          relationships.add("ProducesEvent");

          relationships.add("cond");

          relationships.add("ProfileOf");

          relationships.add("TIStartTime");

          relationships.add("med");

          relationships.add("socialRelations");

          relationships.add("WorkAs");

          relationships.add("LiveIn");

          relationships.add("RelatedEvent");

          relationships.add("ActivityAttached");

          relationships.add("ConditionNeeded");

          relationships.add("Connects");

          relationships.add("SBhasFloor");

          relationships.add("tool");

          relationships.add("FPrecondition");

          relationships.add("AllowedTask");

          relationships.add("relatedCondition");

          relationships.add("aeinv_op");

          relationships.add("aemd_op2");

          relationships.add("aeas_op2");

          relationships.add("aeas_op1");

          relationships.add("aemd_op1");

          relationships.add("RelatedHuman");

          relationships.add("InitialLocation");

          relationships.add("InitialActivity");

          relationships.add("InitialDate");

          relationships.add("device");

          relationships.add("CameraFaceToHuman");

          relationships.add("InitializedSymptom");

          relationships.add("InitializesSymptom");

          relationships.add("Role");

          relationships.add("DeonticAssignement");

          relationships.add("ActionResponsible");

          relationships.add("ActionHappeningAfterwards");

          relationships.add("AffectedAction");

          relationships.add("goToBodySpeedVar");

          relationships.add("leaveObjVar");

          relationships.add("closeObjVar");

          relationships.add("pickUpObjVar");

          relationships.add("waitForHumanVar");

          relationships.add("durationVar");

          relationships.add("goToSpeedVar");

          relationships.add("messageVar");

          relationships.add("tapXVar");

          relationships.add("sitDownOnSeatVar");

          relationships.add("putOnWearableVar");

          relationships.add("goToPlaceVar");

          relationships.add("tapDeviceVar");

          relationships.add("openObjVar");

          relationships.add("animVar");

          relationships.add("useObjVar");

          relationships.add("goToBodyVar");

          relationships.add("leaveObjDestinyVar");

          relationships.add("tapYVar");

          relationships.add("switchRoomVar");

          relationships.add("putOffWearableVar");

          relationships.add("dropObjVar");

   return relationships;
  }

  public  Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("IsThingInRoomCondition");

 entities.add("CReceiveHelp");

 entities.add("CAlways");

 entities.add("CSymptom");

 entities.add("CTimer");

 entities.add("CTime");

 entities.add("CInside");

 entities.add("BodyStateCondition");

 entities.add("CProb");

 entities.add("CEvent");

 entities.add("DoorStateCondition");

 entities.add("PresenceSensorStateCondition");

 entities.add("CSay");

 entities.add("COutside");

 entities.add("CObjWeight");

 entities.add("LightStateCondition");

 entities.add("CDayOfTheWeek");

 entities.add("NotCondition");

 entities.add("CSymptom");

 entities.add("SwipeTask");

 entities.add("GoToBodyLoc");

 entities.add("DropObj");

 entities.add("OpenTask");

 entities.add("BGoToTask");

 entities.add("SayTask");

 entities.add("TapXYTask");

 entities.add("WaitForBodyClose");

 entities.add("CloseTask");

 entities.add("FallTask");

 entities.add("SwitchLightTask");

 entities.add("FTaskSelectorFilter");

 entities.add("FReplaceTaskFilter");

 entities.add("FUnableFilter");

 entities.add("FChangeTargetObjFilter");

 entities.add("FModifyPlaceFilter");

 entities.add("FChangeToolFilter");

 entities.add("FDelayFilter");

 entities.add("TakeOffTask");

 entities.add("WaitTask");

 entities.add("BPickUpTask");

 entities.add("FallSleep");

 entities.add("Drink");

 entities.add("BWakeUpTask");

 entities.add("PutOnTask");

 entities.add("StandUp");

 entities.add("PlayAnimationTask");

 entities.add("SitDown");

 entities.add("GoIntoBed");

 entities.add("Eat");

 entities.add("BUseTask");

 entities.add("BLeaveTask");

 entities.add("BGetUpFromBed");

 entities.add("BSequentialTask");

 entities.add("BRandomTask");

 entities.add("SymptomChangedEvent");

 entities.add("Crutch");

 entities.add("MedsTakenEvent");

 entities.add("EMedicine");

 entities.add("Shoes");

 entities.add("FOWashbasin");

 entities.add("FOSink");

 entities.add("Lift");

 entities.add("Shirt");

 entities.add("StopBehaviourEvent");

 entities.add("VibrateEvent");

 entities.add("SBathroom");

 entities.add("Shower");

 entities.add("FWardrobe");

 entities.add("ObjDroppedEvent");

 entities.add("Human");

 entities.add("MessageListenedEvent");

 entities.add("ERemoteControl");

 entities.add("StartBehaviourEvent");

 entities.add("ESleepers");

 entities.add("Dishwasher");

 entities.add("WashMachine");

 entities.add("EatableItem");

 entities.add("Walker");

 entities.add("Cane");

 entities.add("DComputer");

 entities.add("SCorridor");

 entities.add("SArea");

 entities.add("ESmartPhone");

 entities.add("DrinkItem");

 entities.add("FOBath");

 entities.add("Shocks");

 entities.add("Bridge");

 entities.add("EMobileDevice");

 entities.add("DTV");

 entities.add("FChair");

 entities.add("Pyjamas");

 entities.add("Staircase");

 entities.add("Doorbell");

 entities.add("Appliance");

 entities.add("CallStateEvent");

 entities.add("FallingEvent");

 entities.add("SFloor");

 entities.add("Extractor");

 entities.add("BEvent");

 entities.add("SLivingroom");

 entities.add("SKitchen");

 entities.add("SBuilding");

 entities.add("EPrivateEvent");

 entities.add("SBedroom");

 entities.add("FTable");

 entities.add("Trousers");

 entities.add("FOWater");

 entities.add("EWaterBottle");

 entities.add("FBed");

 entities.add("FSofa");

   return entities;
  }

  // Gets the name of the possible relationships for the selected GraphCells.
  // A relationship can be binary (DefaultEdge) or n-ary (NAryEdge).
  // The requested action is slightly different depending on selected items.
  // According to the number of Edges in selected, the action can be:
  // 0 => Propose a relationship between selected according included classes.
  // 1 and it is NAryEdge => The class of that NAryEdge if it is possible according implements java.io.Serializable
  //      current cardinality and included classes..
  // other cases => Error, no relationships are allowed.
  public Object[] getPossibleRelationships(GraphCell[] selected) {
    // Possible relationships initialization.
    Vector v = new Vector();

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

        // Connections are only possible with two or more elements and without binary edges.
      }
    }
    if (selected.length >= 2 && edgesNum == 0) {

      // The number of NAryEdges is considered.
      if (nAryEdgesNum == 0) {
        // acceptConnection methods only admits vertex parameters.
        // Binary relationships.

        // N-ary relationships. Sometimes they can be also binary.
        if (FAlternativeEdge.acceptConnection(this.getModel(), selected)) {
          v.add("FAlternative");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (NextFilterEdge.acceptConnection(this.getModel(), selected)) {
          v.add("NextFilter");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ProducesEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProducesEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (condEdge.acceptConnection(this.getModel(), selected)) {
          v.add("cond");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ProfileOfEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProfileOf");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (TIStartTimeEdge.acceptConnection(this.getModel(), selected)) {
          v.add("TIStartTime");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (medEdge.acceptConnection(this.getModel(), selected)) {
          v.add("med");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (socialRelationsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("socialRelations");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (WorkAsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("WorkAs");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (LiveInEdge.acceptConnection(this.getModel(), selected)) {
          v.add("LiveIn");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActivityAttachedEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActivityAttached");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConditionNeededEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ConditionNeeded");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConnectsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Connects");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (SBhasFloorEdge.acceptConnection(this.getModel(), selected)) {
          v.add("SBhasFloor");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (toolEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tool");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (FPreconditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("FPrecondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AllowedTaskEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AllowedTask");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (relatedConditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("relatedCondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeinv_opEdge.acceptConnection(this.getModel(), selected)) {
          v.add("aeinv_op");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialLocationEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialLocation");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialActivityEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialActivity");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialDateEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialDate");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (deviceEdge.acceptConnection(this.getModel(), selected)) {
          v.add("device");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("CameraFaceToHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializedSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializedSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializesSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializesSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RoleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Role");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (DeonticAssignementEdge.acceptConnection(this.getModel(), selected)) {
          v.add("DeonticAssignement");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionResponsibleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionResponsible");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionHappeningAfterwards");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AffectedActionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AffectedAction");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodySpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (closeObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("closeObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (pickUpObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("pickUpObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (waitForHumanVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("waitForHumanVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (durationVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("durationVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToSpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToSpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (messageVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("messageVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapXVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapXVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("sitDownOnSeatVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOnWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOnWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToPlaceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToPlaceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapDeviceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapDeviceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (openObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("openObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (animVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("animVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (useObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("useObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjDestinyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapYVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapYVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (switchRoomVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("switchRoomVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOffWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOffWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (dropObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("dropObjVar");
	  }

      }
      else if (nAryEdgesNum == 1) {

        if (selectedEdge instanceof FAlternativeEdge &&
        (FAlternativeEdge.acceptConnection(this.getModel(), selected))) {
          v.add("FAlternative");
        }

        if (selectedEdge instanceof NextFilterEdge &&
        (NextFilterEdge.acceptConnection(this.getModel(), selected))) {
          v.add("NextFilter");
        }

        if (selectedEdge instanceof ProducesEventEdge &&
        (ProducesEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProducesEvent");
        }

        if (selectedEdge instanceof condEdge &&
        (condEdge.acceptConnection(this.getModel(), selected))) {
          v.add("cond");
        }

        if (selectedEdge instanceof ProfileOfEdge &&
        (ProfileOfEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProfileOf");
        }

        if (selectedEdge instanceof TIStartTimeEdge &&
        (TIStartTimeEdge.acceptConnection(this.getModel(), selected))) {
          v.add("TIStartTime");
        }

        if (selectedEdge instanceof medEdge &&
        (medEdge.acceptConnection(this.getModel(), selected))) {
          v.add("med");
        }

        if (selectedEdge instanceof socialRelationsEdge &&
        (socialRelationsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("socialRelations");
        }

        if (selectedEdge instanceof WorkAsEdge &&
        (WorkAsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("WorkAs");
        }

        if (selectedEdge instanceof LiveInEdge &&
        (LiveInEdge.acceptConnection(this.getModel(), selected))) {
          v.add("LiveIn");
        }

        if (selectedEdge instanceof RelatedEventEdge &&
        (RelatedEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedEvent");
        }

        if (selectedEdge instanceof ActivityAttachedEdge &&
        (ActivityAttachedEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActivityAttached");
        }

        if (selectedEdge instanceof ConditionNeededEdge &&
        (ConditionNeededEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ConditionNeeded");
        }

        if (selectedEdge instanceof ConnectsEdge &&
        (ConnectsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Connects");
        }

        if (selectedEdge instanceof SBhasFloorEdge &&
        (SBhasFloorEdge.acceptConnection(this.getModel(), selected))) {
          v.add("SBhasFloor");
        }

        if (selectedEdge instanceof toolEdge &&
        (toolEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tool");
        }

        if (selectedEdge instanceof FPreconditionEdge &&
        (FPreconditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("FPrecondition");
        }

        if (selectedEdge instanceof AllowedTaskEdge &&
        (AllowedTaskEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AllowedTask");
        }

        if (selectedEdge instanceof relatedConditionEdge &&
        (relatedConditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("relatedCondition");
        }

        if (selectedEdge instanceof aeinv_opEdge &&
        (aeinv_opEdge.acceptConnection(this.getModel(), selected))) {
          v.add("aeinv_op");
        }

        if (selectedEdge instanceof aemd_op2Edge &&
        (aemd_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op2");
        }

        if (selectedEdge instanceof aeas_op2Edge &&
        (aeas_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op2");
        }

        if (selectedEdge instanceof aeas_op1Edge &&
        (aeas_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op1");
        }

        if (selectedEdge instanceof aemd_op1Edge &&
        (aemd_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op1");
        }

        if (selectedEdge instanceof RelatedHumanEdge &&
        (RelatedHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedHuman");
        }

        if (selectedEdge instanceof InitialLocationEdge &&
        (InitialLocationEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialLocation");
        }

        if (selectedEdge instanceof InitialActivityEdge &&
        (InitialActivityEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialActivity");
        }

        if (selectedEdge instanceof InitialDateEdge &&
        (InitialDateEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialDate");
        }

        if (selectedEdge instanceof deviceEdge &&
        (deviceEdge.acceptConnection(this.getModel(), selected))) {
          v.add("device");
        }

        if (selectedEdge instanceof CameraFaceToHumanEdge &&
        (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("CameraFaceToHuman");
        }

        if (selectedEdge instanceof InitializedSymptomEdge &&
        (InitializedSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializedSymptom");
        }

        if (selectedEdge instanceof InitializesSymptomEdge &&
        (InitializesSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializesSymptom");
        }

        if (selectedEdge instanceof RoleEdge &&
        (RoleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Role");
        }

        if (selectedEdge instanceof DeonticAssignementEdge &&
        (DeonticAssignementEdge.acceptConnection(this.getModel(), selected))) {
          v.add("DeonticAssignement");
        }

        if (selectedEdge instanceof ActionResponsibleEdge &&
        (ActionResponsibleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionResponsible");
        }

        if (selectedEdge instanceof ActionHappeningAfterwardsEdge &&
        (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionHappeningAfterwards");
        }

        if (selectedEdge instanceof AffectedActionEdge &&
        (AffectedActionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AffectedAction");
        }

        if (selectedEdge instanceof goToBodySpeedVarEdge &&
        (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodySpeedVar");
        }

        if (selectedEdge instanceof leaveObjVarEdge &&
        (leaveObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjVar");
        }

        if (selectedEdge instanceof closeObjVarEdge &&
        (closeObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("closeObjVar");
        }

        if (selectedEdge instanceof pickUpObjVarEdge &&
        (pickUpObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("pickUpObjVar");
        }

        if (selectedEdge instanceof waitForHumanVarEdge &&
        (waitForHumanVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("waitForHumanVar");
        }

        if (selectedEdge instanceof durationVarEdge &&
        (durationVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("durationVar");
        }

        if (selectedEdge instanceof goToSpeedVarEdge &&
        (goToSpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToSpeedVar");
        }

        if (selectedEdge instanceof messageVarEdge &&
        (messageVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("messageVar");
        }

        if (selectedEdge instanceof tapXVarEdge &&
        (tapXVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapXVar");
        }

        if (selectedEdge instanceof sitDownOnSeatVarEdge &&
        (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("sitDownOnSeatVar");
        }

        if (selectedEdge instanceof putOnWearableVarEdge &&
        (putOnWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOnWearableVar");
        }

        if (selectedEdge instanceof goToPlaceVarEdge &&
        (goToPlaceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToPlaceVar");
        }

        if (selectedEdge instanceof tapDeviceVarEdge &&
        (tapDeviceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapDeviceVar");
        }

        if (selectedEdge instanceof openObjVarEdge &&
        (openObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("openObjVar");
        }

        if (selectedEdge instanceof animVarEdge &&
        (animVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("animVar");
        }

        if (selectedEdge instanceof useObjVarEdge &&
        (useObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("useObjVar");
        }

        if (selectedEdge instanceof goToBodyVarEdge &&
        (goToBodyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodyVar");
        }

        if (selectedEdge instanceof leaveObjDestinyVarEdge &&
        (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjDestinyVar");
        }

        if (selectedEdge instanceof tapYVarEdge &&
        (tapYVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapYVar");
        }

        if (selectedEdge instanceof switchRoomVarEdge &&
        (switchRoomVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("switchRoomVar");
        }

        if (selectedEdge instanceof putOffWearableVarEdge &&
        (putOffWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOffWearableVar");
        }

        if (selectedEdge instanceof dropObjVarEdge &&
        (dropObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("dropObjVar");
        }

      }
    }

    return v.toArray();
  }

  public DefaultGraphCell getInstanciaNRelacion(String relacion,
                                                GraphCell[] selected) {

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

      }
    }
    if (nAryEdgesNum <= 1 && edgesNum == 0) {

      if (relacion.equalsIgnoreCase("FAlternative")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof FAlternativeEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new FAlternativeEdge(new ingenias.editor.entities.FAlternative(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("NextFilter")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof NextFilterEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new NextFilterEdge(new ingenias.editor.entities.NextFilter(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ProducesEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProducesEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProducesEventEdge(new ingenias.editor.entities.ProducesEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("cond")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof condEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new condEdge(new ingenias.editor.entities.cond(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ProfileOf")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProfileOfEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProfileOfEdge(new ingenias.editor.entities.ProfileOf(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("TIStartTime")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof TIStartTimeEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new TIStartTimeEdge(new ingenias.editor.entities.TIStartTime(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("med")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof medEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new medEdge(new ingenias.editor.entities.med(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("socialRelations")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof socialRelationsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new socialRelationsEdge(new ingenias.editor.entities.socialRelations(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("WorkAs")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof WorkAsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new WorkAsEdge(new ingenias.editor.entities.WorkAs(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("LiveIn")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof LiveInEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new LiveInEdge(new ingenias.editor.entities.LiveIn(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedEventEdge(new ingenias.editor.entities.RelatedEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActivityAttached")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActivityAttachedEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActivityAttachedEdge(new ingenias.editor.entities.ActivityAttached(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ConditionNeeded")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConditionNeededEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConditionNeededEdge(new ingenias.editor.entities.ConditionNeeded(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Connects")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConnectsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConnectsEdge(new ingenias.editor.entities.Connects(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("SBhasFloor")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof SBhasFloorEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new SBhasFloorEdge(new ingenias.editor.entities.SBhasFloor(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tool")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof toolEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new toolEdge(new ingenias.editor.entities.tool(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("FPrecondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof FPreconditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new FPreconditionEdge(new ingenias.editor.entities.FPrecondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AllowedTask")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AllowedTaskEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AllowedTaskEdge(new ingenias.editor.entities.AllowedTask(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("relatedCondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof relatedConditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new relatedConditionEdge(new ingenias.editor.entities.relatedCondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeinv_op")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeinv_opEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeinv_opEdge(new ingenias.editor.entities.aeinv_op(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op2Edge(new ingenias.editor.entities.aemd_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op2Edge(new ingenias.editor.entities.aeas_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op1Edge(new ingenias.editor.entities.aeas_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op1Edge(new ingenias.editor.entities.aemd_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedHumanEdge(new ingenias.editor.entities.RelatedHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialLocation")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialLocationEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialLocationEdge(new ingenias.editor.entities.InitialLocation(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialActivity")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialActivityEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialActivityEdge(new ingenias.editor.entities.InitialActivity(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialDate")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialDateEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialDateEdge(new ingenias.editor.entities.InitialDate(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("device")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof deviceEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new deviceEdge(new ingenias.editor.entities.device(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("CameraFaceToHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof CameraFaceToHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new CameraFaceToHumanEdge(new ingenias.editor.entities.CameraFaceToHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializedSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializedSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializedSymptomEdge(new ingenias.editor.entities.InitializedSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializesSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializesSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializesSymptomEdge(new ingenias.editor.entities.InitializesSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Role")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RoleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RoleEdge(new ingenias.editor.entities.Role(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("DeonticAssignement")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof DeonticAssignementEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new DeonticAssignementEdge(new ingenias.editor.entities.DeonticAssignement(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionResponsible")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionResponsibleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionResponsibleEdge(new ingenias.editor.entities.ActionResponsible(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionHappeningAfterwards")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionHappeningAfterwardsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionHappeningAfterwardsEdge(new ingenias.editor.entities.ActionHappeningAfterwards(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AffectedAction")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AffectedActionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AffectedActionEdge(new ingenias.editor.entities.AffectedAction(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodySpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodySpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodySpeedVarEdge(new ingenias.editor.entities.goToBodySpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjVarEdge(new ingenias.editor.entities.leaveObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("closeObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof closeObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new closeObjVarEdge(new ingenias.editor.entities.closeObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("pickUpObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof pickUpObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new pickUpObjVarEdge(new ingenias.editor.entities.pickUpObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("waitForHumanVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof waitForHumanVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new waitForHumanVarEdge(new ingenias.editor.entities.waitForHumanVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("durationVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof durationVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new durationVarEdge(new ingenias.editor.entities.durationVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToSpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToSpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToSpeedVarEdge(new ingenias.editor.entities.goToSpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("messageVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof messageVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new messageVarEdge(new ingenias.editor.entities.messageVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapXVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapXVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapXVarEdge(new ingenias.editor.entities.tapXVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("sitDownOnSeatVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof sitDownOnSeatVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new sitDownOnSeatVarEdge(new ingenias.editor.entities.sitDownOnSeatVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOnWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOnWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOnWearableVarEdge(new ingenias.editor.entities.putOnWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToPlaceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToPlaceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToPlaceVarEdge(new ingenias.editor.entities.goToPlaceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapDeviceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapDeviceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapDeviceVarEdge(new ingenias.editor.entities.tapDeviceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("openObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof openObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new openObjVarEdge(new ingenias.editor.entities.openObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("animVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof animVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new animVarEdge(new ingenias.editor.entities.animVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("useObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof useObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new useObjVarEdge(new ingenias.editor.entities.useObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodyVarEdge(new ingenias.editor.entities.goToBodyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjDestinyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjDestinyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjDestinyVarEdge(new ingenias.editor.entities.leaveObjDestinyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapYVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapYVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapYVarEdge(new ingenias.editor.entities.tapYVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("switchRoomVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof switchRoomVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new switchRoomVarEdge(new ingenias.editor.entities.switchRoomVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOffWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOffWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOffWearableVarEdge(new ingenias.editor.entities.putOffWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("dropObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof dropObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new dropObjVarEdge(new ingenias.editor.entities.dropObjVar(getMJGraph().getNewId()));
        }
      }

    }

    return null;
  }
  
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("IsThingInRoomCondition")) {
    IsThingInRoomCondition nentity=getOM().createIsThingInRoomCondition(getMJGraph().getNewId("IsThingInRoomCondition"));
      DefaultGraphCell vertex = new
          IsThingInRoomConditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CReceiveHelp")) {
    CReceiveHelp nentity=getOM().createCReceiveHelp(getMJGraph().getNewId("CReceiveHelp"));
      DefaultGraphCell vertex = new
          CReceiveHelpCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CAlways")) {
    CAlways nentity=getOM().createCAlways(getMJGraph().getNewId("CAlways"));
      DefaultGraphCell vertex = new
          CAlwaysCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CSymptom")) {
    CSymptom nentity=getOM().createCSymptom(getMJGraph().getNewId("CSymptom"));
      DefaultGraphCell vertex = new
          CSymptomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CTimer")) {
    CTimer nentity=getOM().createCTimer(getMJGraph().getNewId("CTimer"));
      DefaultGraphCell vertex = new
          CTimerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CTime")) {
    CTime nentity=getOM().createCTime(getMJGraph().getNewId("CTime"));
      DefaultGraphCell vertex = new
          CTimeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CInside")) {
    CInside nentity=getOM().createCInside(getMJGraph().getNewId("CInside"));
      DefaultGraphCell vertex = new
          CInsideCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BodyStateCondition")) {
    BodyStateCondition nentity=getOM().createBodyStateCondition(getMJGraph().getNewId("BodyStateCondition"));
      DefaultGraphCell vertex = new
          BodyStateConditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CProb")) {
    CProb nentity=getOM().createCProb(getMJGraph().getNewId("CProb"));
      DefaultGraphCell vertex = new
          CProbCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CEvent")) {
    CEvent nentity=getOM().createCEvent(getMJGraph().getNewId("CEvent"));
      DefaultGraphCell vertex = new
          CEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DoorStateCondition")) {
    DoorStateCondition nentity=getOM().createDoorStateCondition(getMJGraph().getNewId("DoorStateCondition"));
      DefaultGraphCell vertex = new
          DoorStateConditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PresenceSensorStateCondition")) {
    PresenceSensorStateCondition nentity=getOM().createPresenceSensorStateCondition(getMJGraph().getNewId("PresenceSensorStateCondition"));
      DefaultGraphCell vertex = new
          PresenceSensorStateConditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CSay")) {
    CSay nentity=getOM().createCSay(getMJGraph().getNewId("CSay"));
      DefaultGraphCell vertex = new
          CSayCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("COutside")) {
    COutside nentity=getOM().createCOutside(getMJGraph().getNewId("COutside"));
      DefaultGraphCell vertex = new
          COutsideCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CObjWeight")) {
    CObjWeight nentity=getOM().createCObjWeight(getMJGraph().getNewId("CObjWeight"));
      DefaultGraphCell vertex = new
          CObjWeightCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("LightStateCondition")) {
    LightStateCondition nentity=getOM().createLightStateCondition(getMJGraph().getNewId("LightStateCondition"));
      DefaultGraphCell vertex = new
          LightStateConditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CDayOfTheWeek")) {
    CDayOfTheWeek nentity=getOM().createCDayOfTheWeek(getMJGraph().getNewId("CDayOfTheWeek"));
      DefaultGraphCell vertex = new
          CDayOfTheWeekCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("NotCondition")) {
    NotCondition nentity=getOM().createNotCondition(getMJGraph().getNewId("NotCondition"));
      DefaultGraphCell vertex = new
          NotConditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CSymptom")) {
    CSymptom nentity=getOM().createCSymptom(getMJGraph().getNewId("CSymptom"));
      DefaultGraphCell vertex = new
          CSymptomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwipeTask")) {
    SwipeTask nentity=getOM().createSwipeTask(getMJGraph().getNewId("SwipeTask"));
      DefaultGraphCell vertex = new
          SwipeTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoToBodyLoc")) {
    GoToBodyLoc nentity=getOM().createGoToBodyLoc(getMJGraph().getNewId("GoToBodyLoc"));
      DefaultGraphCell vertex = new
          GoToBodyLocCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DropObj")) {
    DropObj nentity=getOM().createDropObj(getMJGraph().getNewId("DropObj"));
      DefaultGraphCell vertex = new
          DropObjCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("OpenTask")) {
    OpenTask nentity=getOM().createOpenTask(getMJGraph().getNewId("OpenTask"));
      DefaultGraphCell vertex = new
          OpenTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGoToTask")) {
    BGoToTask nentity=getOM().createBGoToTask(getMJGraph().getNewId("BGoToTask"));
      DefaultGraphCell vertex = new
          BGoToTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SayTask")) {
    SayTask nentity=getOM().createSayTask(getMJGraph().getNewId("SayTask"));
      DefaultGraphCell vertex = new
          SayTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TapXYTask")) {
    TapXYTask nentity=getOM().createTapXYTask(getMJGraph().getNewId("TapXYTask"));
      DefaultGraphCell vertex = new
          TapXYTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitForBodyClose")) {
    WaitForBodyClose nentity=getOM().createWaitForBodyClose(getMJGraph().getNewId("WaitForBodyClose"));
      DefaultGraphCell vertex = new
          WaitForBodyCloseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CloseTask")) {
    CloseTask nentity=getOM().createCloseTask(getMJGraph().getNewId("CloseTask"));
      DefaultGraphCell vertex = new
          CloseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallTask")) {
    FallTask nentity=getOM().createFallTask(getMJGraph().getNewId("FallTask"));
      DefaultGraphCell vertex = new
          FallTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwitchLightTask")) {
    SwitchLightTask nentity=getOM().createSwitchLightTask(getMJGraph().getNewId("SwitchLightTask"));
      DefaultGraphCell vertex = new
          SwitchLightTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FTaskSelectorFilter")) {
    FTaskSelectorFilter nentity=getOM().createFTaskSelectorFilter(getMJGraph().getNewId("FTaskSelectorFilter"));
      DefaultGraphCell vertex = new
          FTaskSelectorFilterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FReplaceTaskFilter")) {
    FReplaceTaskFilter nentity=getOM().createFReplaceTaskFilter(getMJGraph().getNewId("FReplaceTaskFilter"));
      DefaultGraphCell vertex = new
          FReplaceTaskFilterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FUnableFilter")) {
    FUnableFilter nentity=getOM().createFUnableFilter(getMJGraph().getNewId("FUnableFilter"));
      DefaultGraphCell vertex = new
          FUnableFilterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FChangeTargetObjFilter")) {
    FChangeTargetObjFilter nentity=getOM().createFChangeTargetObjFilter(getMJGraph().getNewId("FChangeTargetObjFilter"));
      DefaultGraphCell vertex = new
          FChangeTargetObjFilterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FModifyPlaceFilter")) {
    FModifyPlaceFilter nentity=getOM().createFModifyPlaceFilter(getMJGraph().getNewId("FModifyPlaceFilter"));
      DefaultGraphCell vertex = new
          FModifyPlaceFilterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FChangeToolFilter")) {
    FChangeToolFilter nentity=getOM().createFChangeToolFilter(getMJGraph().getNewId("FChangeToolFilter"));
      DefaultGraphCell vertex = new
          FChangeToolFilterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FDelayFilter")) {
    FDelayFilter nentity=getOM().createFDelayFilter(getMJGraph().getNewId("FDelayFilter"));
      DefaultGraphCell vertex = new
          FDelayFilterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TakeOffTask")) {
    TakeOffTask nentity=getOM().createTakeOffTask(getMJGraph().getNewId("TakeOffTask"));
      DefaultGraphCell vertex = new
          TakeOffTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitTask")) {
    WaitTask nentity=getOM().createWaitTask(getMJGraph().getNewId("WaitTask"));
      DefaultGraphCell vertex = new
          WaitTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BPickUpTask")) {
    BPickUpTask nentity=getOM().createBPickUpTask(getMJGraph().getNewId("BPickUpTask"));
      DefaultGraphCell vertex = new
          BPickUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallSleep")) {
    FallSleep nentity=getOM().createFallSleep(getMJGraph().getNewId("FallSleep"));
      DefaultGraphCell vertex = new
          FallSleepCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Drink")) {
    Drink nentity=getOM().createDrink(getMJGraph().getNewId("Drink"));
      DefaultGraphCell vertex = new
          DrinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BWakeUpTask")) {
    BWakeUpTask nentity=getOM().createBWakeUpTask(getMJGraph().getNewId("BWakeUpTask"));
      DefaultGraphCell vertex = new
          BWakeUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PutOnTask")) {
    PutOnTask nentity=getOM().createPutOnTask(getMJGraph().getNewId("PutOnTask"));
      DefaultGraphCell vertex = new
          PutOnTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StandUp")) {
    StandUp nentity=getOM().createStandUp(getMJGraph().getNewId("StandUp"));
      DefaultGraphCell vertex = new
          StandUpCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PlayAnimationTask")) {
    PlayAnimationTask nentity=getOM().createPlayAnimationTask(getMJGraph().getNewId("PlayAnimationTask"));
      DefaultGraphCell vertex = new
          PlayAnimationTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SitDown")) {
    SitDown nentity=getOM().createSitDown(getMJGraph().getNewId("SitDown"));
      DefaultGraphCell vertex = new
          SitDownCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoIntoBed")) {
    GoIntoBed nentity=getOM().createGoIntoBed(getMJGraph().getNewId("GoIntoBed"));
      DefaultGraphCell vertex = new
          GoIntoBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Eat")) {
    Eat nentity=getOM().createEat(getMJGraph().getNewId("Eat"));
      DefaultGraphCell vertex = new
          EatCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BUseTask")) {
    BUseTask nentity=getOM().createBUseTask(getMJGraph().getNewId("BUseTask"));
      DefaultGraphCell vertex = new
          BUseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BLeaveTask")) {
    BLeaveTask nentity=getOM().createBLeaveTask(getMJGraph().getNewId("BLeaveTask"));
      DefaultGraphCell vertex = new
          BLeaveTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGetUpFromBed")) {
    BGetUpFromBed nentity=getOM().createBGetUpFromBed(getMJGraph().getNewId("BGetUpFromBed"));
      DefaultGraphCell vertex = new
          BGetUpFromBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BSequentialTask")) {
    BSequentialTask nentity=getOM().createBSequentialTask(getMJGraph().getNewId("BSequentialTask"));
      DefaultGraphCell vertex = new
          BSequentialTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BRandomTask")) {
    BRandomTask nentity=getOM().createBRandomTask(getMJGraph().getNewId("BRandomTask"));
      DefaultGraphCell vertex = new
          BRandomTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SymptomChangedEvent")) {
    SymptomChangedEvent nentity=getOM().createSymptomChangedEvent(getMJGraph().getNewId("SymptomChangedEvent"));
      DefaultGraphCell vertex = new
          SymptomChangedEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Crutch")) {
    Crutch nentity=getOM().createCrutch(getMJGraph().getNewId("Crutch"));
      DefaultGraphCell vertex = new
          CrutchCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("MedsTakenEvent")) {
    MedsTakenEvent nentity=getOM().createMedsTakenEvent(getMJGraph().getNewId("MedsTakenEvent"));
      DefaultGraphCell vertex = new
          MedsTakenEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMedicine")) {
    EMedicine nentity=getOM().createEMedicine(getMJGraph().getNewId("EMedicine"));
      DefaultGraphCell vertex = new
          EMedicineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shoes")) {
    Shoes nentity=getOM().createShoes(getMJGraph().getNewId("Shoes"));
      DefaultGraphCell vertex = new
          ShoesCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWashbasin")) {
    FOWashbasin nentity=getOM().createFOWashbasin(getMJGraph().getNewId("FOWashbasin"));
      DefaultGraphCell vertex = new
          FOWashbasinCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOSink")) {
    FOSink nentity=getOM().createFOSink(getMJGraph().getNewId("FOSink"));
      DefaultGraphCell vertex = new
          FOSinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Lift")) {
    Lift nentity=getOM().createLift(getMJGraph().getNewId("Lift"));
      DefaultGraphCell vertex = new
          LiftCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shirt")) {
    Shirt nentity=getOM().createShirt(getMJGraph().getNewId("Shirt"));
      DefaultGraphCell vertex = new
          ShirtCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StopBehaviourEvent")) {
    StopBehaviourEvent nentity=getOM().createStopBehaviourEvent(getMJGraph().getNewId("StopBehaviourEvent"));
      DefaultGraphCell vertex = new
          StopBehaviourEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("VibrateEvent")) {
    VibrateEvent nentity=getOM().createVibrateEvent(getMJGraph().getNewId("VibrateEvent"));
      DefaultGraphCell vertex = new
          VibrateEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBathroom")) {
    SBathroom nentity=getOM().createSBathroom(getMJGraph().getNewId("SBathroom"));
      DefaultGraphCell vertex = new
          SBathroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shower")) {
    Shower nentity=getOM().createShower(getMJGraph().getNewId("Shower"));
      DefaultGraphCell vertex = new
          ShowerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FWardrobe")) {
    FWardrobe nentity=getOM().createFWardrobe(getMJGraph().getNewId("FWardrobe"));
      DefaultGraphCell vertex = new
          FWardrobeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ObjDroppedEvent")) {
    ObjDroppedEvent nentity=getOM().createObjDroppedEvent(getMJGraph().getNewId("ObjDroppedEvent"));
      DefaultGraphCell vertex = new
          ObjDroppedEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=getOM().createHuman(getMJGraph().getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("MessageListenedEvent")) {
    MessageListenedEvent nentity=getOM().createMessageListenedEvent(getMJGraph().getNewId("MessageListenedEvent"));
      DefaultGraphCell vertex = new
          MessageListenedEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ERemoteControl")) {
    ERemoteControl nentity=getOM().createERemoteControl(getMJGraph().getNewId("ERemoteControl"));
      DefaultGraphCell vertex = new
          ERemoteControlCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StartBehaviourEvent")) {
    StartBehaviourEvent nentity=getOM().createStartBehaviourEvent(getMJGraph().getNewId("StartBehaviourEvent"));
      DefaultGraphCell vertex = new
          StartBehaviourEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESleepers")) {
    ESleepers nentity=getOM().createESleepers(getMJGraph().getNewId("ESleepers"));
      DefaultGraphCell vertex = new
          ESleepersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Dishwasher")) {
    Dishwasher nentity=getOM().createDishwasher(getMJGraph().getNewId("Dishwasher"));
      DefaultGraphCell vertex = new
          DishwasherCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WashMachine")) {
    WashMachine nentity=getOM().createWashMachine(getMJGraph().getNewId("WashMachine"));
      DefaultGraphCell vertex = new
          WashMachineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EatableItem")) {
    EatableItem nentity=getOM().createEatableItem(getMJGraph().getNewId("EatableItem"));
      DefaultGraphCell vertex = new
          EatableItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Walker")) {
    Walker nentity=getOM().createWalker(getMJGraph().getNewId("Walker"));
      DefaultGraphCell vertex = new
          WalkerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Cane")) {
    Cane nentity=getOM().createCane(getMJGraph().getNewId("Cane"));
      DefaultGraphCell vertex = new
          CaneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DComputer")) {
    DComputer nentity=getOM().createDComputer(getMJGraph().getNewId("DComputer"));
      DefaultGraphCell vertex = new
          DComputerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SCorridor")) {
    SCorridor nentity=getOM().createSCorridor(getMJGraph().getNewId("SCorridor"));
      DefaultGraphCell vertex = new
          SCorridorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SArea")) {
    SArea nentity=getOM().createSArea(getMJGraph().getNewId("SArea"));
      DefaultGraphCell vertex = new
          SAreaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESmartPhone")) {
    ESmartPhone nentity=getOM().createESmartPhone(getMJGraph().getNewId("ESmartPhone"));
      DefaultGraphCell vertex = new
          ESmartPhoneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DrinkItem")) {
    DrinkItem nentity=getOM().createDrinkItem(getMJGraph().getNewId("DrinkItem"));
      DefaultGraphCell vertex = new
          DrinkItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOBath")) {
    FOBath nentity=getOM().createFOBath(getMJGraph().getNewId("FOBath"));
      DefaultGraphCell vertex = new
          FOBathCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shocks")) {
    Shocks nentity=getOM().createShocks(getMJGraph().getNewId("Shocks"));
      DefaultGraphCell vertex = new
          ShocksCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Bridge")) {
    Bridge nentity=getOM().createBridge(getMJGraph().getNewId("Bridge"));
      DefaultGraphCell vertex = new
          BridgeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMobileDevice")) {
    EMobileDevice nentity=getOM().createEMobileDevice(getMJGraph().getNewId("EMobileDevice"));
      DefaultGraphCell vertex = new
          EMobileDeviceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DTV")) {
    DTV nentity=getOM().createDTV(getMJGraph().getNewId("DTV"));
      DefaultGraphCell vertex = new
          DTVCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FChair")) {
    FChair nentity=getOM().createFChair(getMJGraph().getNewId("FChair"));
      DefaultGraphCell vertex = new
          FChairCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Pyjamas")) {
    Pyjamas nentity=getOM().createPyjamas(getMJGraph().getNewId("Pyjamas"));
      DefaultGraphCell vertex = new
          PyjamasCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Staircase")) {
    Staircase nentity=getOM().createStaircase(getMJGraph().getNewId("Staircase"));
      DefaultGraphCell vertex = new
          StaircaseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Doorbell")) {
    Doorbell nentity=getOM().createDoorbell(getMJGraph().getNewId("Doorbell"));
      DefaultGraphCell vertex = new
          DoorbellCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Appliance")) {
    Appliance nentity=getOM().createAppliance(getMJGraph().getNewId("Appliance"));
      DefaultGraphCell vertex = new
          ApplianceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CallStateEvent")) {
    CallStateEvent nentity=getOM().createCallStateEvent(getMJGraph().getNewId("CallStateEvent"));
      DefaultGraphCell vertex = new
          CallStateEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallingEvent")) {
    FallingEvent nentity=getOM().createFallingEvent(getMJGraph().getNewId("FallingEvent"));
      DefaultGraphCell vertex = new
          FallingEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SFloor")) {
    SFloor nentity=getOM().createSFloor(getMJGraph().getNewId("SFloor"));
      DefaultGraphCell vertex = new
          SFloorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Extractor")) {
    Extractor nentity=getOM().createExtractor(getMJGraph().getNewId("Extractor"));
      DefaultGraphCell vertex = new
          ExtractorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BEvent")) {
    BEvent nentity=getOM().createBEvent(getMJGraph().getNewId("BEvent"));
      DefaultGraphCell vertex = new
          BEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SLivingroom")) {
    SLivingroom nentity=getOM().createSLivingroom(getMJGraph().getNewId("SLivingroom"));
      DefaultGraphCell vertex = new
          SLivingroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SKitchen")) {
    SKitchen nentity=getOM().createSKitchen(getMJGraph().getNewId("SKitchen"));
      DefaultGraphCell vertex = new
          SKitchenCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBuilding")) {
    SBuilding nentity=getOM().createSBuilding(getMJGraph().getNewId("SBuilding"));
      DefaultGraphCell vertex = new
          SBuildingCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EPrivateEvent")) {
    EPrivateEvent nentity=getOM().createEPrivateEvent(getMJGraph().getNewId("EPrivateEvent"));
      DefaultGraphCell vertex = new
          EPrivateEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBedroom")) {
    SBedroom nentity=getOM().createSBedroom(getMJGraph().getNewId("SBedroom"));
      DefaultGraphCell vertex = new
          SBedroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FTable")) {
    FTable nentity=getOM().createFTable(getMJGraph().getNewId("FTable"));
      DefaultGraphCell vertex = new
          FTableCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Trousers")) {
    Trousers nentity=getOM().createTrousers(getMJGraph().getNewId("Trousers"));
      DefaultGraphCell vertex = new
          TrousersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWater")) {
    FOWater nentity=getOM().createFOWater(getMJGraph().getNewId("FOWater"));
      DefaultGraphCell vertex = new
          FOWaterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EWaterBottle")) {
    EWaterBottle nentity=getOM().createEWaterBottle(getMJGraph().getNewId("EWaterBottle"));
      DefaultGraphCell vertex = new
          EWaterBottleCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FBed")) {
    FBed nentity=getOM().createFBed(getMJGraph().getNewId("FBed"));
      DefaultGraphCell vertex = new
          FBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FSofa")) {
    FSofa nentity=getOM().createFSofa(getMJGraph().getNewId("FSofa"));
      DefaultGraphCell vertex = new
          FSofaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("IsThingInRoomCondition")) {
      return IsThingInRoomConditionView.getSize((ingenias.editor.entities.IsThingInRoomCondition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CReceiveHelp")) {
      return CReceiveHelpView.getSize((ingenias.editor.entities.CReceiveHelp)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CAlways")) {
      return CAlwaysView.getSize((ingenias.editor.entities.CAlways)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CSymptom")) {
      return CSymptomView.getSize((ingenias.editor.entities.CSymptom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CTimer")) {
      return CTimerView.getSize((ingenias.editor.entities.CTimer)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CTime")) {
      return CTimeView.getSize((ingenias.editor.entities.CTime)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CInside")) {
      return CInsideView.getSize((ingenias.editor.entities.CInside)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BodyStateCondition")) {
      return BodyStateConditionView.getSize((ingenias.editor.entities.BodyStateCondition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CProb")) {
      return CProbView.getSize((ingenias.editor.entities.CProb)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CEvent")) {
      return CEventView.getSize((ingenias.editor.entities.CEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DoorStateCondition")) {
      return DoorStateConditionView.getSize((ingenias.editor.entities.DoorStateCondition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PresenceSensorStateCondition")) {
      return PresenceSensorStateConditionView.getSize((ingenias.editor.entities.PresenceSensorStateCondition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CSay")) {
      return CSayView.getSize((ingenias.editor.entities.CSay)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("COutside")) {
      return COutsideView.getSize((ingenias.editor.entities.COutside)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CObjWeight")) {
      return CObjWeightView.getSize((ingenias.editor.entities.CObjWeight)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("LightStateCondition")) {
      return LightStateConditionView.getSize((ingenias.editor.entities.LightStateCondition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CDayOfTheWeek")) {
      return CDayOfTheWeekView.getSize((ingenias.editor.entities.CDayOfTheWeek)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("NotCondition")) {
      return NotConditionView.getSize((ingenias.editor.entities.NotCondition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CSymptom")) {
      return CSymptomView.getSize((ingenias.editor.entities.CSymptom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwipeTask")) {
      return SwipeTaskView.getSize((ingenias.editor.entities.SwipeTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoToBodyLoc")) {
      return GoToBodyLocView.getSize((ingenias.editor.entities.GoToBodyLoc)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DropObj")) {
      return DropObjView.getSize((ingenias.editor.entities.DropObj)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("OpenTask")) {
      return OpenTaskView.getSize((ingenias.editor.entities.OpenTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGoToTask")) {
      return BGoToTaskView.getSize((ingenias.editor.entities.BGoToTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SayTask")) {
      return SayTaskView.getSize((ingenias.editor.entities.SayTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TapXYTask")) {
      return TapXYTaskView.getSize((ingenias.editor.entities.TapXYTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitForBodyClose")) {
      return WaitForBodyCloseView.getSize((ingenias.editor.entities.WaitForBodyClose)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CloseTask")) {
      return CloseTaskView.getSize((ingenias.editor.entities.CloseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallTask")) {
      return FallTaskView.getSize((ingenias.editor.entities.FallTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwitchLightTask")) {
      return SwitchLightTaskView.getSize((ingenias.editor.entities.SwitchLightTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FTaskSelectorFilter")) {
      return FTaskSelectorFilterView.getSize((ingenias.editor.entities.FTaskSelectorFilter)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FReplaceTaskFilter")) {
      return FReplaceTaskFilterView.getSize((ingenias.editor.entities.FReplaceTaskFilter)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FUnableFilter")) {
      return FUnableFilterView.getSize((ingenias.editor.entities.FUnableFilter)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FChangeTargetObjFilter")) {
      return FChangeTargetObjFilterView.getSize((ingenias.editor.entities.FChangeTargetObjFilter)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FModifyPlaceFilter")) {
      return FModifyPlaceFilterView.getSize((ingenias.editor.entities.FModifyPlaceFilter)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FChangeToolFilter")) {
      return FChangeToolFilterView.getSize((ingenias.editor.entities.FChangeToolFilter)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FDelayFilter")) {
      return FDelayFilterView.getSize((ingenias.editor.entities.FDelayFilter)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TakeOffTask")) {
      return TakeOffTaskView.getSize((ingenias.editor.entities.TakeOffTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitTask")) {
      return WaitTaskView.getSize((ingenias.editor.entities.WaitTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BPickUpTask")) {
      return BPickUpTaskView.getSize((ingenias.editor.entities.BPickUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallSleep")) {
      return FallSleepView.getSize((ingenias.editor.entities.FallSleep)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Drink")) {
      return DrinkView.getSize((ingenias.editor.entities.Drink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BWakeUpTask")) {
      return BWakeUpTaskView.getSize((ingenias.editor.entities.BWakeUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PutOnTask")) {
      return PutOnTaskView.getSize((ingenias.editor.entities.PutOnTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StandUp")) {
      return StandUpView.getSize((ingenias.editor.entities.StandUp)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PlayAnimationTask")) {
      return PlayAnimationTaskView.getSize((ingenias.editor.entities.PlayAnimationTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SitDown")) {
      return SitDownView.getSize((ingenias.editor.entities.SitDown)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoIntoBed")) {
      return GoIntoBedView.getSize((ingenias.editor.entities.GoIntoBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Eat")) {
      return EatView.getSize((ingenias.editor.entities.Eat)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BUseTask")) {
      return BUseTaskView.getSize((ingenias.editor.entities.BUseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BLeaveTask")) {
      return BLeaveTaskView.getSize((ingenias.editor.entities.BLeaveTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGetUpFromBed")) {
      return BGetUpFromBedView.getSize((ingenias.editor.entities.BGetUpFromBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BSequentialTask")) {
      return BSequentialTaskView.getSize((ingenias.editor.entities.BSequentialTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BRandomTask")) {
      return BRandomTaskView.getSize((ingenias.editor.entities.BRandomTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SymptomChangedEvent")) {
      return SymptomChangedEventView.getSize((ingenias.editor.entities.SymptomChangedEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Crutch")) {
      return CrutchView.getSize((ingenias.editor.entities.Crutch)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("MedsTakenEvent")) {
      return MedsTakenEventView.getSize((ingenias.editor.entities.MedsTakenEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMedicine")) {
      return EMedicineView.getSize((ingenias.editor.entities.EMedicine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shoes")) {
      return ShoesView.getSize((ingenias.editor.entities.Shoes)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWashbasin")) {
      return FOWashbasinView.getSize((ingenias.editor.entities.FOWashbasin)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOSink")) {
      return FOSinkView.getSize((ingenias.editor.entities.FOSink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Lift")) {
      return LiftView.getSize((ingenias.editor.entities.Lift)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shirt")) {
      return ShirtView.getSize((ingenias.editor.entities.Shirt)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StopBehaviourEvent")) {
      return StopBehaviourEventView.getSize((ingenias.editor.entities.StopBehaviourEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("VibrateEvent")) {
      return VibrateEventView.getSize((ingenias.editor.entities.VibrateEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBathroom")) {
      return SBathroomView.getSize((ingenias.editor.entities.SBathroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shower")) {
      return ShowerView.getSize((ingenias.editor.entities.Shower)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FWardrobe")) {
      return FWardrobeView.getSize((ingenias.editor.entities.FWardrobe)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ObjDroppedEvent")) {
      return ObjDroppedEventView.getSize((ingenias.editor.entities.ObjDroppedEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((ingenias.editor.entities.Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("MessageListenedEvent")) {
      return MessageListenedEventView.getSize((ingenias.editor.entities.MessageListenedEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ERemoteControl")) {
      return ERemoteControlView.getSize((ingenias.editor.entities.ERemoteControl)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StartBehaviourEvent")) {
      return StartBehaviourEventView.getSize((ingenias.editor.entities.StartBehaviourEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESleepers")) {
      return ESleepersView.getSize((ingenias.editor.entities.ESleepers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Dishwasher")) {
      return DishwasherView.getSize((ingenias.editor.entities.Dishwasher)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WashMachine")) {
      return WashMachineView.getSize((ingenias.editor.entities.WashMachine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EatableItem")) {
      return EatableItemView.getSize((ingenias.editor.entities.EatableItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Walker")) {
      return WalkerView.getSize((ingenias.editor.entities.Walker)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Cane")) {
      return CaneView.getSize((ingenias.editor.entities.Cane)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DComputer")) {
      return DComputerView.getSize((ingenias.editor.entities.DComputer)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SCorridor")) {
      return SCorridorView.getSize((ingenias.editor.entities.SCorridor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SArea")) {
      return SAreaView.getSize((ingenias.editor.entities.SArea)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESmartPhone")) {
      return ESmartPhoneView.getSize((ingenias.editor.entities.ESmartPhone)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DrinkItem")) {
      return DrinkItemView.getSize((ingenias.editor.entities.DrinkItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOBath")) {
      return FOBathView.getSize((ingenias.editor.entities.FOBath)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shocks")) {
      return ShocksView.getSize((ingenias.editor.entities.Shocks)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Bridge")) {
      return BridgeView.getSize((ingenias.editor.entities.Bridge)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMobileDevice")) {
      return EMobileDeviceView.getSize((ingenias.editor.entities.EMobileDevice)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DTV")) {
      return DTVView.getSize((ingenias.editor.entities.DTV)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FChair")) {
      return FChairView.getSize((ingenias.editor.entities.FChair)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Pyjamas")) {
      return PyjamasView.getSize((ingenias.editor.entities.Pyjamas)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Staircase")) {
      return StaircaseView.getSize((ingenias.editor.entities.Staircase)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Doorbell")) {
      return DoorbellView.getSize((ingenias.editor.entities.Doorbell)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Appliance")) {
      return ApplianceView.getSize((ingenias.editor.entities.Appliance)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CallStateEvent")) {
      return CallStateEventView.getSize((ingenias.editor.entities.CallStateEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallingEvent")) {
      return FallingEventView.getSize((ingenias.editor.entities.FallingEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SFloor")) {
      return SFloorView.getSize((ingenias.editor.entities.SFloor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Extractor")) {
      return ExtractorView.getSize((ingenias.editor.entities.Extractor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BEvent")) {
      return BEventView.getSize((ingenias.editor.entities.BEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SLivingroom")) {
      return SLivingroomView.getSize((ingenias.editor.entities.SLivingroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SKitchen")) {
      return SKitchenView.getSize((ingenias.editor.entities.SKitchen)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBuilding")) {
      return SBuildingView.getSize((ingenias.editor.entities.SBuilding)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EPrivateEvent")) {
      return EPrivateEventView.getSize((ingenias.editor.entities.EPrivateEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBedroom")) {
      return SBedroomView.getSize((ingenias.editor.entities.SBedroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FTable")) {
      return FTableView.getSize((ingenias.editor.entities.FTable)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Trousers")) {
      return TrousersView.getSize((ingenias.editor.entities.Trousers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWater")) {
      return FOWaterView.getSize((ingenias.editor.entities.FOWater)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EWaterBottle")) {
      return EWaterBottleView.getSize((ingenias.editor.entities.EWaterBottle)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FBed")) {
      return FBedView.getSize((ingenias.editor.entities.FBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FSofa")) {
      return FSofaView.getSize((ingenias.editor.entities.FSofa)entity);      
    }
    else


      if (entity.getType().equalsIgnoreCase("FAlternative")) {
      	return FAlternativeView.getSize((ingenias.editor.entities.FAlternative)entity);
      }

      if (entity.getType().equalsIgnoreCase("NextFilter")) {
      	return NextFilterView.getSize((ingenias.editor.entities.NextFilter)entity);
      }

      if (entity.getType().equalsIgnoreCase("ProducesEvent")) {
      	return ProducesEventView.getSize((ingenias.editor.entities.ProducesEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("cond")) {
      	return condView.getSize((ingenias.editor.entities.cond)entity);
      }

      if (entity.getType().equalsIgnoreCase("ProfileOf")) {
      	return ProfileOfView.getSize((ingenias.editor.entities.ProfileOf)entity);
      }

      if (entity.getType().equalsIgnoreCase("TIStartTime")) {
      	return TIStartTimeView.getSize((ingenias.editor.entities.TIStartTime)entity);
      }

      if (entity.getType().equalsIgnoreCase("med")) {
      	return medView.getSize((ingenias.editor.entities.med)entity);
      }

      if (entity.getType().equalsIgnoreCase("socialRelations")) {
      	return socialRelationsView.getSize((ingenias.editor.entities.socialRelations)entity);
      }

      if (entity.getType().equalsIgnoreCase("WorkAs")) {
      	return WorkAsView.getSize((ingenias.editor.entities.WorkAs)entity);
      }

      if (entity.getType().equalsIgnoreCase("LiveIn")) {
      	return LiveInView.getSize((ingenias.editor.entities.LiveIn)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedEvent")) {
      	return RelatedEventView.getSize((ingenias.editor.entities.RelatedEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActivityAttached")) {
      	return ActivityAttachedView.getSize((ingenias.editor.entities.ActivityAttached)entity);
      }

      if (entity.getType().equalsIgnoreCase("ConditionNeeded")) {
      	return ConditionNeededView.getSize((ingenias.editor.entities.ConditionNeeded)entity);
      }

      if (entity.getType().equalsIgnoreCase("Connects")) {
      	return ConnectsView.getSize((ingenias.editor.entities.Connects)entity);
      }

      if (entity.getType().equalsIgnoreCase("SBhasFloor")) {
      	return SBhasFloorView.getSize((ingenias.editor.entities.SBhasFloor)entity);
      }

      if (entity.getType().equalsIgnoreCase("tool")) {
      	return toolView.getSize((ingenias.editor.entities.tool)entity);
      }

      if (entity.getType().equalsIgnoreCase("FPrecondition")) {
      	return FPreconditionView.getSize((ingenias.editor.entities.FPrecondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("AllowedTask")) {
      	return AllowedTaskView.getSize((ingenias.editor.entities.AllowedTask)entity);
      }

      if (entity.getType().equalsIgnoreCase("relatedCondition")) {
      	return relatedConditionView.getSize((ingenias.editor.entities.relatedCondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeinv_op")) {
      	return aeinv_opView.getSize((ingenias.editor.entities.aeinv_op)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op2")) {
      	return aemd_op2View.getSize((ingenias.editor.entities.aemd_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op2")) {
      	return aeas_op2View.getSize((ingenias.editor.entities.aeas_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op1")) {
      	return aeas_op1View.getSize((ingenias.editor.entities.aeas_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op1")) {
      	return aemd_op1View.getSize((ingenias.editor.entities.aemd_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedHuman")) {
      	return RelatedHumanView.getSize((ingenias.editor.entities.RelatedHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialLocation")) {
      	return InitialLocationView.getSize((ingenias.editor.entities.InitialLocation)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialActivity")) {
      	return InitialActivityView.getSize((ingenias.editor.entities.InitialActivity)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialDate")) {
      	return InitialDateView.getSize((ingenias.editor.entities.InitialDate)entity);
      }

      if (entity.getType().equalsIgnoreCase("device")) {
      	return deviceView.getSize((ingenias.editor.entities.device)entity);
      }

      if (entity.getType().equalsIgnoreCase("CameraFaceToHuman")) {
      	return CameraFaceToHumanView.getSize((ingenias.editor.entities.CameraFaceToHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializedSymptom")) {
      	return InitializedSymptomView.getSize((ingenias.editor.entities.InitializedSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializesSymptom")) {
      	return InitializesSymptomView.getSize((ingenias.editor.entities.InitializesSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("Role")) {
      	return RoleView.getSize((ingenias.editor.entities.Role)entity);
      }

      if (entity.getType().equalsIgnoreCase("DeonticAssignement")) {
      	return DeonticAssignementView.getSize((ingenias.editor.entities.DeonticAssignement)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionResponsible")) {
      	return ActionResponsibleView.getSize((ingenias.editor.entities.ActionResponsible)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionHappeningAfterwards")) {
      	return ActionHappeningAfterwardsView.getSize((ingenias.editor.entities.ActionHappeningAfterwards)entity);
      }

      if (entity.getType().equalsIgnoreCase("AffectedAction")) {
      	return AffectedActionView.getSize((ingenias.editor.entities.AffectedAction)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodySpeedVar")) {
      	return goToBodySpeedVarView.getSize((ingenias.editor.entities.goToBodySpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjVar")) {
      	return leaveObjVarView.getSize((ingenias.editor.entities.leaveObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("closeObjVar")) {
      	return closeObjVarView.getSize((ingenias.editor.entities.closeObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("pickUpObjVar")) {
      	return pickUpObjVarView.getSize((ingenias.editor.entities.pickUpObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("waitForHumanVar")) {
      	return waitForHumanVarView.getSize((ingenias.editor.entities.waitForHumanVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("durationVar")) {
      	return durationVarView.getSize((ingenias.editor.entities.durationVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToSpeedVar")) {
      	return goToSpeedVarView.getSize((ingenias.editor.entities.goToSpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("messageVar")) {
      	return messageVarView.getSize((ingenias.editor.entities.messageVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapXVar")) {
      	return tapXVarView.getSize((ingenias.editor.entities.tapXVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("sitDownOnSeatVar")) {
      	return sitDownOnSeatVarView.getSize((ingenias.editor.entities.sitDownOnSeatVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOnWearableVar")) {
      	return putOnWearableVarView.getSize((ingenias.editor.entities.putOnWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToPlaceVar")) {
      	return goToPlaceVarView.getSize((ingenias.editor.entities.goToPlaceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapDeviceVar")) {
      	return tapDeviceVarView.getSize((ingenias.editor.entities.tapDeviceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("openObjVar")) {
      	return openObjVarView.getSize((ingenias.editor.entities.openObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("animVar")) {
      	return animVarView.getSize((ingenias.editor.entities.animVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("useObjVar")) {
      	return useObjVarView.getSize((ingenias.editor.entities.useObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodyVar")) {
      	return goToBodyVarView.getSize((ingenias.editor.entities.goToBodyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjDestinyVar")) {
      	return leaveObjDestinyVarView.getSize((ingenias.editor.entities.leaveObjDestinyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapYVar")) {
      	return tapYVarView.getSize((ingenias.editor.entities.tapYVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("switchRoomVar")) {
      	return switchRoomVarView.getSize((ingenias.editor.entities.switchRoomVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOffWearableVar")) {
      	return putOffWearableVarView.getSize((ingenias.editor.entities.putOffWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("dropObjVar")) {
      	return dropObjVarView.getSize((ingenias.editor.entities.dropObjVar)entity);
      }

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));

    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);

	Entity newEntity=(Entity) vertex.getUserObject();
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.UML)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.UML);
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.INGENIAS)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.INGENIAS);

	getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true

    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));
   

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(IsThingInRoomCondition.class)) {
      vertex = new IsThingInRoomConditionCell( (IsThingInRoomCondition) entity);
      // Default Size for the new Vertex with the new entity within
      size = IsThingInRoomConditionView.getSize((IsThingInRoomCondition) entity);
      
    }
    else

    if (entity.getClass().equals(CReceiveHelp.class)) {
      vertex = new CReceiveHelpCell( (CReceiveHelp) entity);
      // Default Size for the new Vertex with the new entity within
      size = CReceiveHelpView.getSize((CReceiveHelp) entity);
      
    }
    else

    if (entity.getClass().equals(CAlways.class)) {
      vertex = new CAlwaysCell( (CAlways) entity);
      // Default Size for the new Vertex with the new entity within
      size = CAlwaysView.getSize((CAlways) entity);
      
    }
    else

    if (entity.getClass().equals(CSymptom.class)) {
      vertex = new CSymptomCell( (CSymptom) entity);
      // Default Size for the new Vertex with the new entity within
      size = CSymptomView.getSize((CSymptom) entity);
      
    }
    else

    if (entity.getClass().equals(CTimer.class)) {
      vertex = new CTimerCell( (CTimer) entity);
      // Default Size for the new Vertex with the new entity within
      size = CTimerView.getSize((CTimer) entity);
      
    }
    else

    if (entity.getClass().equals(CTime.class)) {
      vertex = new CTimeCell( (CTime) entity);
      // Default Size for the new Vertex with the new entity within
      size = CTimeView.getSize((CTime) entity);
      
    }
    else

    if (entity.getClass().equals(CInside.class)) {
      vertex = new CInsideCell( (CInside) entity);
      // Default Size for the new Vertex with the new entity within
      size = CInsideView.getSize((CInside) entity);
      
    }
    else

    if (entity.getClass().equals(BodyStateCondition.class)) {
      vertex = new BodyStateConditionCell( (BodyStateCondition) entity);
      // Default Size for the new Vertex with the new entity within
      size = BodyStateConditionView.getSize((BodyStateCondition) entity);
      
    }
    else

    if (entity.getClass().equals(CProb.class)) {
      vertex = new CProbCell( (CProb) entity);
      // Default Size for the new Vertex with the new entity within
      size = CProbView.getSize((CProb) entity);
      
    }
    else

    if (entity.getClass().equals(CEvent.class)) {
      vertex = new CEventCell( (CEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = CEventView.getSize((CEvent) entity);
      
    }
    else

    if (entity.getClass().equals(DoorStateCondition.class)) {
      vertex = new DoorStateConditionCell( (DoorStateCondition) entity);
      // Default Size for the new Vertex with the new entity within
      size = DoorStateConditionView.getSize((DoorStateCondition) entity);
      
    }
    else

    if (entity.getClass().equals(PresenceSensorStateCondition.class)) {
      vertex = new PresenceSensorStateConditionCell( (PresenceSensorStateCondition) entity);
      // Default Size for the new Vertex with the new entity within
      size = PresenceSensorStateConditionView.getSize((PresenceSensorStateCondition) entity);
      
    }
    else

    if (entity.getClass().equals(CSay.class)) {
      vertex = new CSayCell( (CSay) entity);
      // Default Size for the new Vertex with the new entity within
      size = CSayView.getSize((CSay) entity);
      
    }
    else

    if (entity.getClass().equals(COutside.class)) {
      vertex = new COutsideCell( (COutside) entity);
      // Default Size for the new Vertex with the new entity within
      size = COutsideView.getSize((COutside) entity);
      
    }
    else

    if (entity.getClass().equals(CObjWeight.class)) {
      vertex = new CObjWeightCell( (CObjWeight) entity);
      // Default Size for the new Vertex with the new entity within
      size = CObjWeightView.getSize((CObjWeight) entity);
      
    }
    else

    if (entity.getClass().equals(LightStateCondition.class)) {
      vertex = new LightStateConditionCell( (LightStateCondition) entity);
      // Default Size for the new Vertex with the new entity within
      size = LightStateConditionView.getSize((LightStateCondition) entity);
      
    }
    else

    if (entity.getClass().equals(CDayOfTheWeek.class)) {
      vertex = new CDayOfTheWeekCell( (CDayOfTheWeek) entity);
      // Default Size for the new Vertex with the new entity within
      size = CDayOfTheWeekView.getSize((CDayOfTheWeek) entity);
      
    }
    else

    if (entity.getClass().equals(NotCondition.class)) {
      vertex = new NotConditionCell( (NotCondition) entity);
      // Default Size for the new Vertex with the new entity within
      size = NotConditionView.getSize((NotCondition) entity);
      
    }
    else

    if (entity.getClass().equals(CSymptom.class)) {
      vertex = new CSymptomCell( (CSymptom) entity);
      // Default Size for the new Vertex with the new entity within
      size = CSymptomView.getSize((CSymptom) entity);
      
    }
    else

    if (entity.getClass().equals(SwipeTask.class)) {
      vertex = new SwipeTaskCell( (SwipeTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwipeTaskView.getSize((SwipeTask) entity);
      
    }
    else

    if (entity.getClass().equals(GoToBodyLoc.class)) {
      vertex = new GoToBodyLocCell( (GoToBodyLoc) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoToBodyLocView.getSize((GoToBodyLoc) entity);
      
    }
    else

    if (entity.getClass().equals(DropObj.class)) {
      vertex = new DropObjCell( (DropObj) entity);
      // Default Size for the new Vertex with the new entity within
      size = DropObjView.getSize((DropObj) entity);
      
    }
    else

    if (entity.getClass().equals(OpenTask.class)) {
      vertex = new OpenTaskCell( (OpenTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = OpenTaskView.getSize((OpenTask) entity);
      
    }
    else

    if (entity.getClass().equals(BGoToTask.class)) {
      vertex = new BGoToTaskCell( (BGoToTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGoToTaskView.getSize((BGoToTask) entity);
      
    }
    else

    if (entity.getClass().equals(SayTask.class)) {
      vertex = new SayTaskCell( (SayTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SayTaskView.getSize((SayTask) entity);
      
    }
    else

    if (entity.getClass().equals(TapXYTask.class)) {
      vertex = new TapXYTaskCell( (TapXYTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TapXYTaskView.getSize((TapXYTask) entity);
      
    }
    else

    if (entity.getClass().equals(WaitForBodyClose.class)) {
      vertex = new WaitForBodyCloseCell( (WaitForBodyClose) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitForBodyCloseView.getSize((WaitForBodyClose) entity);
      
    }
    else

    if (entity.getClass().equals(CloseTask.class)) {
      vertex = new CloseTaskCell( (CloseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = CloseTaskView.getSize((CloseTask) entity);
      
    }
    else

    if (entity.getClass().equals(FallTask.class)) {
      vertex = new FallTaskCell( (FallTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallTaskView.getSize((FallTask) entity);
      
    }
    else

    if (entity.getClass().equals(SwitchLightTask.class)) {
      vertex = new SwitchLightTaskCell( (SwitchLightTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwitchLightTaskView.getSize((SwitchLightTask) entity);
      
    }
    else

    if (entity.getClass().equals(FTaskSelectorFilter.class)) {
      vertex = new FTaskSelectorFilterCell( (FTaskSelectorFilter) entity);
      // Default Size for the new Vertex with the new entity within
      size = FTaskSelectorFilterView.getSize((FTaskSelectorFilter) entity);
      
    }
    else

    if (entity.getClass().equals(FReplaceTaskFilter.class)) {
      vertex = new FReplaceTaskFilterCell( (FReplaceTaskFilter) entity);
      // Default Size for the new Vertex with the new entity within
      size = FReplaceTaskFilterView.getSize((FReplaceTaskFilter) entity);
      
    }
    else

    if (entity.getClass().equals(FUnableFilter.class)) {
      vertex = new FUnableFilterCell( (FUnableFilter) entity);
      // Default Size for the new Vertex with the new entity within
      size = FUnableFilterView.getSize((FUnableFilter) entity);
      
    }
    else

    if (entity.getClass().equals(FChangeTargetObjFilter.class)) {
      vertex = new FChangeTargetObjFilterCell( (FChangeTargetObjFilter) entity);
      // Default Size for the new Vertex with the new entity within
      size = FChangeTargetObjFilterView.getSize((FChangeTargetObjFilter) entity);
      
    }
    else

    if (entity.getClass().equals(FModifyPlaceFilter.class)) {
      vertex = new FModifyPlaceFilterCell( (FModifyPlaceFilter) entity);
      // Default Size for the new Vertex with the new entity within
      size = FModifyPlaceFilterView.getSize((FModifyPlaceFilter) entity);
      
    }
    else

    if (entity.getClass().equals(FChangeToolFilter.class)) {
      vertex = new FChangeToolFilterCell( (FChangeToolFilter) entity);
      // Default Size for the new Vertex with the new entity within
      size = FChangeToolFilterView.getSize((FChangeToolFilter) entity);
      
    }
    else

    if (entity.getClass().equals(FDelayFilter.class)) {
      vertex = new FDelayFilterCell( (FDelayFilter) entity);
      // Default Size for the new Vertex with the new entity within
      size = FDelayFilterView.getSize((FDelayFilter) entity);
      
    }
    else

    if (entity.getClass().equals(TakeOffTask.class)) {
      vertex = new TakeOffTaskCell( (TakeOffTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TakeOffTaskView.getSize((TakeOffTask) entity);
      
    }
    else

    if (entity.getClass().equals(WaitTask.class)) {
      vertex = new WaitTaskCell( (WaitTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitTaskView.getSize((WaitTask) entity);
      
    }
    else

    if (entity.getClass().equals(BPickUpTask.class)) {
      vertex = new BPickUpTaskCell( (BPickUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BPickUpTaskView.getSize((BPickUpTask) entity);
      
    }
    else

    if (entity.getClass().equals(FallSleep.class)) {
      vertex = new FallSleepCell( (FallSleep) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallSleepView.getSize((FallSleep) entity);
      
    }
    else

    if (entity.getClass().equals(Drink.class)) {
      vertex = new DrinkCell( (Drink) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkView.getSize((Drink) entity);
      
    }
    else

    if (entity.getClass().equals(BWakeUpTask.class)) {
      vertex = new BWakeUpTaskCell( (BWakeUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BWakeUpTaskView.getSize((BWakeUpTask) entity);
      
    }
    else

    if (entity.getClass().equals(PutOnTask.class)) {
      vertex = new PutOnTaskCell( (PutOnTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PutOnTaskView.getSize((PutOnTask) entity);
      
    }
    else

    if (entity.getClass().equals(StandUp.class)) {
      vertex = new StandUpCell( (StandUp) entity);
      // Default Size for the new Vertex with the new entity within
      size = StandUpView.getSize((StandUp) entity);
      
    }
    else

    if (entity.getClass().equals(PlayAnimationTask.class)) {
      vertex = new PlayAnimationTaskCell( (PlayAnimationTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PlayAnimationTaskView.getSize((PlayAnimationTask) entity);
      
    }
    else

    if (entity.getClass().equals(SitDown.class)) {
      vertex = new SitDownCell( (SitDown) entity);
      // Default Size for the new Vertex with the new entity within
      size = SitDownView.getSize((SitDown) entity);
      
    }
    else

    if (entity.getClass().equals(GoIntoBed.class)) {
      vertex = new GoIntoBedCell( (GoIntoBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoIntoBedView.getSize((GoIntoBed) entity);
      
    }
    else

    if (entity.getClass().equals(Eat.class)) {
      vertex = new EatCell( (Eat) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatView.getSize((Eat) entity);
      
    }
    else

    if (entity.getClass().equals(BUseTask.class)) {
      vertex = new BUseTaskCell( (BUseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BUseTaskView.getSize((BUseTask) entity);
      
    }
    else

    if (entity.getClass().equals(BLeaveTask.class)) {
      vertex = new BLeaveTaskCell( (BLeaveTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BLeaveTaskView.getSize((BLeaveTask) entity);
      
    }
    else

    if (entity.getClass().equals(BGetUpFromBed.class)) {
      vertex = new BGetUpFromBedCell( (BGetUpFromBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGetUpFromBedView.getSize((BGetUpFromBed) entity);
      
    }
    else

    if (entity.getClass().equals(BSequentialTask.class)) {
      vertex = new BSequentialTaskCell( (BSequentialTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BSequentialTaskView.getSize((BSequentialTask) entity);
      
    }
    else

    if (entity.getClass().equals(BRandomTask.class)) {
      vertex = new BRandomTaskCell( (BRandomTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BRandomTaskView.getSize((BRandomTask) entity);
      
    }
    else

    if (entity.getClass().equals(SymptomChangedEvent.class)) {
      vertex = new SymptomChangedEventCell( (SymptomChangedEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = SymptomChangedEventView.getSize((SymptomChangedEvent) entity);
      
    }
    else

    if (entity.getClass().equals(Crutch.class)) {
      vertex = new CrutchCell( (Crutch) entity);
      // Default Size for the new Vertex with the new entity within
      size = CrutchView.getSize((Crutch) entity);
      
    }
    else

    if (entity.getClass().equals(MedsTakenEvent.class)) {
      vertex = new MedsTakenEventCell( (MedsTakenEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = MedsTakenEventView.getSize((MedsTakenEvent) entity);
      
    }
    else

    if (entity.getClass().equals(EMedicine.class)) {
      vertex = new EMedicineCell( (EMedicine) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMedicineView.getSize((EMedicine) entity);
      
    }
    else

    if (entity.getClass().equals(Shoes.class)) {
      vertex = new ShoesCell( (Shoes) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShoesView.getSize((Shoes) entity);
      
    }
    else

    if (entity.getClass().equals(FOWashbasin.class)) {
      vertex = new FOWashbasinCell( (FOWashbasin) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWashbasinView.getSize((FOWashbasin) entity);
      
    }
    else

    if (entity.getClass().equals(FOSink.class)) {
      vertex = new FOSinkCell( (FOSink) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOSinkView.getSize((FOSink) entity);
      
    }
    else

    if (entity.getClass().equals(Lift.class)) {
      vertex = new LiftCell( (Lift) entity);
      // Default Size for the new Vertex with the new entity within
      size = LiftView.getSize((Lift) entity);
      
    }
    else

    if (entity.getClass().equals(Shirt.class)) {
      vertex = new ShirtCell( (Shirt) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShirtView.getSize((Shirt) entity);
      
    }
    else

    if (entity.getClass().equals(StopBehaviourEvent.class)) {
      vertex = new StopBehaviourEventCell( (StopBehaviourEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = StopBehaviourEventView.getSize((StopBehaviourEvent) entity);
      
    }
    else

    if (entity.getClass().equals(VibrateEvent.class)) {
      vertex = new VibrateEventCell( (VibrateEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = VibrateEventView.getSize((VibrateEvent) entity);
      
    }
    else

    if (entity.getClass().equals(SBathroom.class)) {
      vertex = new SBathroomCell( (SBathroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBathroomView.getSize((SBathroom) entity);
      
    }
    else

    if (entity.getClass().equals(Shower.class)) {
      vertex = new ShowerCell( (Shower) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShowerView.getSize((Shower) entity);
      
    }
    else

    if (entity.getClass().equals(FWardrobe.class)) {
      vertex = new FWardrobeCell( (FWardrobe) entity);
      // Default Size for the new Vertex with the new entity within
      size = FWardrobeView.getSize((FWardrobe) entity);
      
    }
    else

    if (entity.getClass().equals(ObjDroppedEvent.class)) {
      vertex = new ObjDroppedEventCell( (ObjDroppedEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjDroppedEventView.getSize((ObjDroppedEvent) entity);
      
    }
    else

    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
      
    }
    else

    if (entity.getClass().equals(MessageListenedEvent.class)) {
      vertex = new MessageListenedEventCell( (MessageListenedEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = MessageListenedEventView.getSize((MessageListenedEvent) entity);
      
    }
    else

    if (entity.getClass().equals(ERemoteControl.class)) {
      vertex = new ERemoteControlCell( (ERemoteControl) entity);
      // Default Size for the new Vertex with the new entity within
      size = ERemoteControlView.getSize((ERemoteControl) entity);
      
    }
    else

    if (entity.getClass().equals(StartBehaviourEvent.class)) {
      vertex = new StartBehaviourEventCell( (StartBehaviourEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = StartBehaviourEventView.getSize((StartBehaviourEvent) entity);
      
    }
    else

    if (entity.getClass().equals(ESleepers.class)) {
      vertex = new ESleepersCell( (ESleepers) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESleepersView.getSize((ESleepers) entity);
      
    }
    else

    if (entity.getClass().equals(Dishwasher.class)) {
      vertex = new DishwasherCell( (Dishwasher) entity);
      // Default Size for the new Vertex with the new entity within
      size = DishwasherView.getSize((Dishwasher) entity);
      
    }
    else

    if (entity.getClass().equals(WashMachine.class)) {
      vertex = new WashMachineCell( (WashMachine) entity);
      // Default Size for the new Vertex with the new entity within
      size = WashMachineView.getSize((WashMachine) entity);
      
    }
    else

    if (entity.getClass().equals(EatableItem.class)) {
      vertex = new EatableItemCell( (EatableItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatableItemView.getSize((EatableItem) entity);
      
    }
    else

    if (entity.getClass().equals(Walker.class)) {
      vertex = new WalkerCell( (Walker) entity);
      // Default Size for the new Vertex with the new entity within
      size = WalkerView.getSize((Walker) entity);
      
    }
    else

    if (entity.getClass().equals(Cane.class)) {
      vertex = new CaneCell( (Cane) entity);
      // Default Size for the new Vertex with the new entity within
      size = CaneView.getSize((Cane) entity);
      
    }
    else

    if (entity.getClass().equals(DComputer.class)) {
      vertex = new DComputerCell( (DComputer) entity);
      // Default Size for the new Vertex with the new entity within
      size = DComputerView.getSize((DComputer) entity);
      
    }
    else

    if (entity.getClass().equals(SCorridor.class)) {
      vertex = new SCorridorCell( (SCorridor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SCorridorView.getSize((SCorridor) entity);
      
    }
    else

    if (entity.getClass().equals(SArea.class)) {
      vertex = new SAreaCell( (SArea) entity);
      // Default Size for the new Vertex with the new entity within
      size = SAreaView.getSize((SArea) entity);
      
    }
    else

    if (entity.getClass().equals(ESmartPhone.class)) {
      vertex = new ESmartPhoneCell( (ESmartPhone) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESmartPhoneView.getSize((ESmartPhone) entity);
      
    }
    else

    if (entity.getClass().equals(DrinkItem.class)) {
      vertex = new DrinkItemCell( (DrinkItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkItemView.getSize((DrinkItem) entity);
      
    }
    else

    if (entity.getClass().equals(FOBath.class)) {
      vertex = new FOBathCell( (FOBath) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOBathView.getSize((FOBath) entity);
      
    }
    else

    if (entity.getClass().equals(Shocks.class)) {
      vertex = new ShocksCell( (Shocks) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShocksView.getSize((Shocks) entity);
      
    }
    else

    if (entity.getClass().equals(Bridge.class)) {
      vertex = new BridgeCell( (Bridge) entity);
      // Default Size for the new Vertex with the new entity within
      size = BridgeView.getSize((Bridge) entity);
      
    }
    else

    if (entity.getClass().equals(EMobileDevice.class)) {
      vertex = new EMobileDeviceCell( (EMobileDevice) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMobileDeviceView.getSize((EMobileDevice) entity);
      
    }
    else

    if (entity.getClass().equals(DTV.class)) {
      vertex = new DTVCell( (DTV) entity);
      // Default Size for the new Vertex with the new entity within
      size = DTVView.getSize((DTV) entity);
      
    }
    else

    if (entity.getClass().equals(FChair.class)) {
      vertex = new FChairCell( (FChair) entity);
      // Default Size for the new Vertex with the new entity within
      size = FChairView.getSize((FChair) entity);
      
    }
    else

    if (entity.getClass().equals(Pyjamas.class)) {
      vertex = new PyjamasCell( (Pyjamas) entity);
      // Default Size for the new Vertex with the new entity within
      size = PyjamasView.getSize((Pyjamas) entity);
      
    }
    else

    if (entity.getClass().equals(Staircase.class)) {
      vertex = new StaircaseCell( (Staircase) entity);
      // Default Size for the new Vertex with the new entity within
      size = StaircaseView.getSize((Staircase) entity);
      
    }
    else

    if (entity.getClass().equals(Doorbell.class)) {
      vertex = new DoorbellCell( (Doorbell) entity);
      // Default Size for the new Vertex with the new entity within
      size = DoorbellView.getSize((Doorbell) entity);
      
    }
    else

    if (entity.getClass().equals(Appliance.class)) {
      vertex = new ApplianceCell( (Appliance) entity);
      // Default Size for the new Vertex with the new entity within
      size = ApplianceView.getSize((Appliance) entity);
      
    }
    else

    if (entity.getClass().equals(CallStateEvent.class)) {
      vertex = new CallStateEventCell( (CallStateEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = CallStateEventView.getSize((CallStateEvent) entity);
      
    }
    else

    if (entity.getClass().equals(FallingEvent.class)) {
      vertex = new FallingEventCell( (FallingEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallingEventView.getSize((FallingEvent) entity);
      
    }
    else

    if (entity.getClass().equals(SFloor.class)) {
      vertex = new SFloorCell( (SFloor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SFloorView.getSize((SFloor) entity);
      
    }
    else

    if (entity.getClass().equals(Extractor.class)) {
      vertex = new ExtractorCell( (Extractor) entity);
      // Default Size for the new Vertex with the new entity within
      size = ExtractorView.getSize((Extractor) entity);
      
    }
    else

    if (entity.getClass().equals(BEvent.class)) {
      vertex = new BEventCell( (BEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = BEventView.getSize((BEvent) entity);
      
    }
    else

    if (entity.getClass().equals(SLivingroom.class)) {
      vertex = new SLivingroomCell( (SLivingroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SLivingroomView.getSize((SLivingroom) entity);
      
    }
    else

    if (entity.getClass().equals(SKitchen.class)) {
      vertex = new SKitchenCell( (SKitchen) entity);
      // Default Size for the new Vertex with the new entity within
      size = SKitchenView.getSize((SKitchen) entity);
      
    }
    else

    if (entity.getClass().equals(SBuilding.class)) {
      vertex = new SBuildingCell( (SBuilding) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBuildingView.getSize((SBuilding) entity);
      
    }
    else

    if (entity.getClass().equals(EPrivateEvent.class)) {
      vertex = new EPrivateEventCell( (EPrivateEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = EPrivateEventView.getSize((EPrivateEvent) entity);
      
    }
    else

    if (entity.getClass().equals(SBedroom.class)) {
      vertex = new SBedroomCell( (SBedroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBedroomView.getSize((SBedroom) entity);
      
    }
    else

    if (entity.getClass().equals(FTable.class)) {
      vertex = new FTableCell( (FTable) entity);
      // Default Size for the new Vertex with the new entity within
      size = FTableView.getSize((FTable) entity);
      
    }
    else

    if (entity.getClass().equals(Trousers.class)) {
      vertex = new TrousersCell( (Trousers) entity);
      // Default Size for the new Vertex with the new entity within
      size = TrousersView.getSize((Trousers) entity);
      
    }
    else

    if (entity.getClass().equals(FOWater.class)) {
      vertex = new FOWaterCell( (FOWater) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWaterView.getSize((FOWater) entity);
      
    }
    else

    if (entity.getClass().equals(EWaterBottle.class)) {
      vertex = new EWaterBottleCell( (EWaterBottle) entity);
      // Default Size for the new Vertex with the new entity within
      size = EWaterBottleView.getSize((EWaterBottle) entity);
      
    }
    else

    if (entity.getClass().equals(FBed.class)) {
      vertex = new FBedCell( (FBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = FBedView.getSize((FBed) entity);
      
    }
    else

    if (entity.getClass().equals(FSofa.class)) {
      vertex = new FSofaCell( (FSofa) entity);
      // Default Size for the new Vertex with the new entity within
      size = FSofaView.getSize((FSofa) entity);
      
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
JOptionPane.showMessageDialog(this,
		 "Object not allowed in this diagram "+this.getID()+":"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName(),"Warning", JOptionPane.WARNING_MESSAGE);    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
      getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true  
        // waits for the cellview to be created
		boolean created=false;
		VertexView vv=null;
		while (!created){
			CellView[] cellviews = this.getGraphLayoutCache().getCellViews();
			for (CellView cv:cellviews){
				if (cv.getCell()==vertex){
					// created!
					created=true;
					vv=(VertexView)cv;
				}
			}
			try {
				Thread.currentThread().sleep(10);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		// This should be used when the corresponding view for the entity has containers!
		// It can be known by inspecting its renderer. To get it, a cellview is needed,
		// but the cellview is created after a while via succesive callbacks to
		// the view factories

		if (!ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null).isEmpty()){
			// there are container renderers that need new cells corresponding to children to
			// be inserted

						Hashtable<String, CollectionPanel> renderers = ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null);
			for (String field:renderers.keySet()){
				Method obtainenumeration;
				try {
					obtainenumeration = entity.getClass().getMethod("get"+field+"Elements");
					Enumeration<ingenias.editor.entities.Entity>  enom=(Enumeration<ingenias.editor.entities.Entity>) obtainenumeration.invoke(entity,new Object[]{});
					while (enom.hasMoreElements()){
						DefaultGraphCell child=this.insertDuplicated(new Point(40,10), enom.nextElement());
						try {
							getListenerContainer().setParent(child,vertex);
						} catch (WrongParent e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} 
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				}
							
		}
		
                             
    }
   return vertex;

  }


 public synchronized JGraph cloneJGraph(IDEState ids){

		

		 FilterDiagramModelJGraph jg=new  FilterDiagramModelJGraph(
				(FilterDiagramDataEntity) this.mde,name, ids.om,
				new Model(ids),new BasicMarqueeHandler(),ids.prefs); 

		this.setSelectionCells(getGraphLayoutCache().getCells(false,true,false,false));
		Action copyaction =new EventRedirectorForGraphCopy(this,this.getTransferHandler().getCopyAction(),null	); 			
		Action pasteaction =new EventRedirectorPasteForGraphCopy(jg,jg.getTransferHandler().getPasteAction(),null	);
		copyaction.actionPerformed(new ActionEvent(this,0,"hello"));		
		pasteaction.actionPerformed(new ActionEvent(this,0,"hello"));
		jg.invalidate();
		jg.doLayout();
		
		return jg;

	}


  public String toString() {
    return this.getID();
  }

}
