

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 

package ingenias.editor.models;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;


import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.*;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.rendererxml.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;
import java.util.concurrent.TimeUnit;

public class NormDefinitionModelJGraph extends ModelJGraph {

  private Preferences prefs;
  
 

  public NormDefinitionModelJGraph(NormDefinitionDataEntity mde, 
                               String nombre, ObjectManager om, Model
                               m, BasicMarqueeHandler mh, Preferences prefs) {
    super(mde, nombre, m, mh,om);
    this.prefs=prefs;
    ToolTipManager.sharedInstance().registerComponent(this);
this.getModel().addGraphModelListener(new ChangeNARYEdgeLocation(this));
this.getModel().addGraphModelListener(new ChangeEntityLocation(this));

    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.NormDefinitionCellViewFactory());

  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }





  public JToolBar getPaleta() {
    return toolbar;

  }

  protected void creaToolBar() {
    if (toolbar==null){
    toolbar = new FilteredJToolBar("NormDefinition");
    toolbar.setFloatable(false);
    ImageIcon undoIcon = null;
    JButton jb = null;


   if (true){
    Image img_AnotherActionHappens =
        ImageLoader.getImage("images/mAnotherActionHappens.png");
    undoIcon = new ImageIcon(img_AnotherActionHappens);
    Action AnotherActionHappens=
        new AbstractAction("AnotherActionHappens", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "AnotherActionHappens");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    AnotherActionHappens.setEnabled(true);
    jb = new JButton(AnotherActionHappens){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("AnotherActionHappens");	
    jb.setToolTipText("AnotherActionHappens:"+new AnotherActionHappens("").getHelpDesc()+"\n\n"+new AnotherActionHappens("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_Human =
        ImageLoader.getImage("images/entities/Human16.png");
    undoIcon = new ImageIcon(img_Human);
    Action Human=
        new AbstractAction("Human", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Human");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Human.setEnabled(true);
    jb = new JButton(Human){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Human");	
    jb.setToolTipText("Human:"+new Human("").getHelpDesc()+"\n\n"+new Human("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SArea =
        ImageLoader.getImage("images/space/area16.png");
    undoIcon = new ImageIcon(img_SArea);
    Action SArea=
        new AbstractAction("SArea", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SArea");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SArea.setEnabled(true);
    jb = new JButton(SArea){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SArea");	
    jb.setToolTipText("SArea:"+new SArea("").getHelpDesc()+"\n\n"+new SArea("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SBuilding =
        ImageLoader.getImage("images/space/building16.png");
    undoIcon = new ImageIcon(img_SBuilding);
    Action SBuilding=
        new AbstractAction("SBuilding", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SBuilding");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SBuilding.setEnabled(true);
    jb = new JButton(SBuilding){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SBuilding");	
    jb.setToolTipText("SBuilding:"+new SBuilding("").getHelpDesc()+"\n\n"+new SBuilding("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SFloor =
        ImageLoader.getImage("images/space/floor16.png");
    undoIcon = new ImageIcon(img_SFloor);
    Action SFloor=
        new AbstractAction("SFloor", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SFloor");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SFloor.setEnabled(true);
    jb = new JButton(SFloor){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SFloor");	
    jb.setToolTipText("SFloor:"+new SFloor("").getHelpDesc()+"\n\n"+new SFloor("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_ConsecutiveActions =
        ImageLoader.getImage("images/mConsecutiveActions.png");
    undoIcon = new ImageIcon(img_ConsecutiveActions);
    Action ConsecutiveActions=
        new AbstractAction("ConsecutiveActions", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ConsecutiveActions");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ConsecutiveActions.setEnabled(true);
    jb = new JButton(ConsecutiveActions){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ConsecutiveActions");	
    jb.setToolTipText("ConsecutiveActions:"+new ConsecutiveActions("").getHelpDesc()+"\n\n"+new ConsecutiveActions("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_GoToBodyLoc =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_GoToBodyLoc);
    Action GoToBodyLoc=
        new AbstractAction("GoToBodyLoc", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "GoToBodyLoc");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    GoToBodyLoc.setEnabled(true);
    jb = new JButton(GoToBodyLoc){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("GoToBodyLoc");	
    jb.setToolTipText("GoToBodyLoc:"+new GoToBodyLoc("").getHelpDesc()+"\n\n"+new GoToBodyLoc("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_TakeOffTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_TakeOffTask);
    Action TakeOffTask=
        new AbstractAction("TakeOffTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "TakeOffTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    TakeOffTask.setEnabled(true);
    jb = new JButton(TakeOffTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("TakeOffTask");	
    jb.setToolTipText("TakeOffTask:"+new TakeOffTask("").getHelpDesc()+"\n\n"+new TakeOffTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_WaitTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_WaitTask);
    Action WaitTask=
        new AbstractAction("WaitTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WaitTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WaitTask.setEnabled(true);
    jb = new JButton(WaitTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WaitTask");	
    jb.setToolTipText("WaitTask:"+new WaitTask("").getHelpDesc()+"\n\n"+new WaitTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BPickUpTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BPickUpTask);
    Action BPickUpTask=
        new AbstractAction("BPickUpTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BPickUpTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BPickUpTask.setEnabled(true);
    jb = new JButton(BPickUpTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BPickUpTask");	
    jb.setToolTipText("BPickUpTask:"+new BPickUpTask("").getHelpDesc()+"\n\n"+new BPickUpTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FallSleep =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FallSleep);
    Action FallSleep=
        new AbstractAction("FallSleep", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FallSleep");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FallSleep.setEnabled(true);
    jb = new JButton(FallSleep){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FallSleep");	
    jb.setToolTipText("FallSleep:"+new FallSleep("").getHelpDesc()+"\n\n"+new FallSleep("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_OpenTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_OpenTask);
    Action OpenTask=
        new AbstractAction("OpenTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "OpenTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    OpenTask.setEnabled(true);
    jb = new JButton(OpenTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("OpenTask");	
    jb.setToolTipText("OpenTask:"+new OpenTask("").getHelpDesc()+"\n\n"+new OpenTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Drink =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Drink);
    Action Drink=
        new AbstractAction("Drink", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Drink");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Drink.setEnabled(true);
    jb = new JButton(Drink){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Drink");	
    jb.setToolTipText("Drink:"+new Drink("").getHelpDesc()+"\n\n"+new Drink("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SayTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SayTask);
    Action SayTask=
        new AbstractAction("SayTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SayTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SayTask.setEnabled(true);
    jb = new JButton(SayTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SayTask");	
    jb.setToolTipText("SayTask:"+new SayTask("").getHelpDesc()+"\n\n"+new SayTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BWakeUpTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BWakeUpTask);
    Action BWakeUpTask=
        new AbstractAction("BWakeUpTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BWakeUpTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BWakeUpTask.setEnabled(true);
    jb = new JButton(BWakeUpTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BWakeUpTask");	
    jb.setToolTipText("BWakeUpTask:"+new BWakeUpTask("").getHelpDesc()+"\n\n"+new BWakeUpTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BGoToTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BGoToTask);
    Action BGoToTask=
        new AbstractAction("BGoToTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BGoToTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BGoToTask.setEnabled(true);
    jb = new JButton(BGoToTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BGoToTask");	
    jb.setToolTipText("BGoToTask:"+new BGoToTask("").getHelpDesc()+"\n\n"+new BGoToTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_StandUp =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_StandUp);
    Action StandUp=
        new AbstractAction("StandUp", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "StandUp");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    StandUp.setEnabled(true);
    jb = new JButton(StandUp){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("StandUp");	
    jb.setToolTipText("StandUp:"+new StandUp("").getHelpDesc()+"\n\n"+new StandUp("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_TapXYTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_TapXYTask);
    Action TapXYTask=
        new AbstractAction("TapXYTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "TapXYTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    TapXYTask.setEnabled(true);
    jb = new JButton(TapXYTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("TapXYTask");	
    jb.setToolTipText("TapXYTask:"+new TapXYTask("").getHelpDesc()+"\n\n"+new TapXYTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_CloseTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_CloseTask);
    Action CloseTask=
        new AbstractAction("CloseTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CloseTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CloseTask.setEnabled(true);
    jb = new JButton(CloseTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CloseTask");	
    jb.setToolTipText("CloseTask:"+new CloseTask("").getHelpDesc()+"\n\n"+new CloseTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BSequentialTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BSequentialTask);
    Action BSequentialTask=
        new AbstractAction("BSequentialTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BSequentialTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BSequentialTask.setEnabled(true);
    jb = new JButton(BSequentialTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BSequentialTask");	
    jb.setToolTipText("BSequentialTask:"+new BSequentialTask("").getHelpDesc()+"\n\n"+new BSequentialTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SitDown =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SitDown);
    Action SitDown=
        new AbstractAction("SitDown", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SitDown");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SitDown.setEnabled(true);
    jb = new JButton(SitDown){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SitDown");	
    jb.setToolTipText("SitDown:"+new SitDown("").getHelpDesc()+"\n\n"+new SitDown("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_GoIntoBed =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_GoIntoBed);
    Action GoIntoBed=
        new AbstractAction("GoIntoBed", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "GoIntoBed");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    GoIntoBed.setEnabled(true);
    jb = new JButton(GoIntoBed){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("GoIntoBed");	
    jb.setToolTipText("GoIntoBed:"+new GoIntoBed("").getHelpDesc()+"\n\n"+new GoIntoBed("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SwitchLightTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SwitchLightTask);
    Action SwitchLightTask=
        new AbstractAction("SwitchLightTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SwitchLightTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SwitchLightTask.setEnabled(true);
    jb = new JButton(SwitchLightTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SwitchLightTask");	
    jb.setToolTipText("SwitchLightTask:"+new SwitchLightTask("").getHelpDesc()+"\n\n"+new SwitchLightTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BLeaveTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BLeaveTask);
    Action BLeaveTask=
        new AbstractAction("BLeaveTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BLeaveTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BLeaveTask.setEnabled(true);
    jb = new JButton(BLeaveTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BLeaveTask");	
    jb.setToolTipText("BLeaveTask:"+new BLeaveTask("").getHelpDesc()+"\n\n"+new BLeaveTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BGetUpFromBed =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BGetUpFromBed);
    Action BGetUpFromBed=
        new AbstractAction("BGetUpFromBed", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BGetUpFromBed");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BGetUpFromBed.setEnabled(true);
    jb = new JButton(BGetUpFromBed){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BGetUpFromBed");	
    jb.setToolTipText("BGetUpFromBed:"+new BGetUpFromBed("").getHelpDesc()+"\n\n"+new BGetUpFromBed("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SwipeTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SwipeTask);
    Action SwipeTask=
        new AbstractAction("SwipeTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SwipeTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SwipeTask.setEnabled(true);
    jb = new JButton(SwipeTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SwipeTask");	
    jb.setToolTipText("SwipeTask:"+new SwipeTask("").getHelpDesc()+"\n\n"+new SwipeTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BRandomTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BRandomTask);
    Action BRandomTask=
        new AbstractAction("BRandomTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BRandomTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BRandomTask.setEnabled(true);
    jb = new JButton(BRandomTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BRandomTask");	
    jb.setToolTipText("BRandomTask:"+new BRandomTask("").getHelpDesc()+"\n\n"+new BRandomTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_DropObj =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_DropObj);
    Action DropObj=
        new AbstractAction("DropObj", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DropObj");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DropObj.setEnabled(true);
    jb = new JButton(DropObj){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DropObj");	
    jb.setToolTipText("DropObj:"+new DropObj("").getHelpDesc()+"\n\n"+new DropObj("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_PutOnTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_PutOnTask);
    Action PutOnTask=
        new AbstractAction("PutOnTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PutOnTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PutOnTask.setEnabled(true);
    jb = new JButton(PutOnTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PutOnTask");	
    jb.setToolTipText("PutOnTask:"+new PutOnTask("").getHelpDesc()+"\n\n"+new PutOnTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_WaitForBodyClose =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_WaitForBodyClose);
    Action WaitForBodyClose=
        new AbstractAction("WaitForBodyClose", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WaitForBodyClose");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WaitForBodyClose.setEnabled(true);
    jb = new JButton(WaitForBodyClose){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WaitForBodyClose");	
    jb.setToolTipText("WaitForBodyClose:"+new WaitForBodyClose("").getHelpDesc()+"\n\n"+new WaitForBodyClose("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_PlayAnimationTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_PlayAnimationTask);
    Action PlayAnimationTask=
        new AbstractAction("PlayAnimationTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PlayAnimationTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PlayAnimationTask.setEnabled(true);
    jb = new JButton(PlayAnimationTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PlayAnimationTask");	
    jb.setToolTipText("PlayAnimationTask:"+new PlayAnimationTask("").getHelpDesc()+"\n\n"+new PlayAnimationTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FallTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FallTask);
    Action FallTask=
        new AbstractAction("FallTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FallTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FallTask.setEnabled(true);
    jb = new JButton(FallTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FallTask");	
    jb.setToolTipText("FallTask:"+new FallTask("").getHelpDesc()+"\n\n"+new FallTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_BUseTask =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_BUseTask);
    Action BUseTask=
        new AbstractAction("BUseTask", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BUseTask");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BUseTask.setEnabled(true);
    jb = new JButton(BUseTask){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BUseTask");	
    jb.setToolTipText("BUseTask:"+new BUseTask("").getHelpDesc()+"\n\n"+new BUseTask("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Eat =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Eat);
    Action Eat=
        new AbstractAction("Eat", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Eat");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Eat.setEnabled(true);
    jb = new JButton(Eat){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Eat");	
    jb.setToolTipText("Eat:"+new Eat("").getHelpDesc()+"\n\n"+new Eat("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

    }

  }

  public Vector<String> getAllowedRelationships(){
   Vector<String> relationships=new   Vector<String>();


          relationships.add("ProducesEvent");

          relationships.add("cond");

          relationships.add("ProfileOf");

          relationships.add("TIStartTime");

          relationships.add("med");

          relationships.add("socialRelations");

          relationships.add("WorkAs");

          relationships.add("LiveIn");

          relationships.add("RelatedEvent");

          relationships.add("ActivityAttached");

          relationships.add("ConditionNeeded");

          relationships.add("Connects");

          relationships.add("SBhasFloor");

          relationships.add("tool");

          relationships.add("FPrecondition");

          relationships.add("AllowedTask");

          relationships.add("relatedCondition");

          relationships.add("aeinv_op");

          relationships.add("aemd_op2");

          relationships.add("aeas_op2");

          relationships.add("aeas_op1");

          relationships.add("aemd_op1");

          relationships.add("RelatedHuman");

          relationships.add("InitialLocation");

          relationships.add("InitialActivity");

          relationships.add("InitialDate");

          relationships.add("device");

          relationships.add("CameraFaceToHuman");

          relationships.add("InitializedSymptom");

          relationships.add("InitializesSymptom");

          relationships.add("Role");

          relationships.add("DeonticAssignement");

          relationships.add("ActionResponsible");

          relationships.add("ActionHappeningAfterwards");

          relationships.add("AffectedAction");

          relationships.add("goToBodySpeedVar");

          relationships.add("leaveObjVar");

          relationships.add("closeObjVar");

          relationships.add("pickUpObjVar");

          relationships.add("waitForHumanVar");

          relationships.add("durationVar");

          relationships.add("goToSpeedVar");

          relationships.add("messageVar");

          relationships.add("tapXVar");

          relationships.add("sitDownOnSeatVar");

          relationships.add("putOnWearableVar");

          relationships.add("goToPlaceVar");

          relationships.add("tapDeviceVar");

          relationships.add("openObjVar");

          relationships.add("animVar");

          relationships.add("useObjVar");

          relationships.add("goToBodyVar");

          relationships.add("leaveObjDestinyVar");

          relationships.add("tapYVar");

          relationships.add("switchRoomVar");

          relationships.add("putOffWearableVar");

          relationships.add("dropObjVar");

   return relationships;
  }

  public  Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("AnotherActionHappens");

 entities.add("Human");

 entities.add("SArea");

 entities.add("SBuilding");

 entities.add("SFloor");

 entities.add("ConsecutiveActions");

 entities.add("GoToBodyLoc");

 entities.add("TakeOffTask");

 entities.add("WaitTask");

 entities.add("BPickUpTask");

 entities.add("FallSleep");

 entities.add("OpenTask");

 entities.add("Drink");

 entities.add("SayTask");

 entities.add("BWakeUpTask");

 entities.add("BGoToTask");

 entities.add("StandUp");

 entities.add("TapXYTask");

 entities.add("CloseTask");

 entities.add("BSequentialTask");

 entities.add("SitDown");

 entities.add("GoIntoBed");

 entities.add("SwitchLightTask");

 entities.add("BLeaveTask");

 entities.add("BGetUpFromBed");

 entities.add("SwipeTask");

 entities.add("BRandomTask");

 entities.add("DropObj");

 entities.add("PutOnTask");

 entities.add("WaitForBodyClose");

 entities.add("PlayAnimationTask");

 entities.add("FallTask");

 entities.add("BUseTask");

 entities.add("Eat");

   return entities;
  }

  // Gets the name of the possible relationships for the selected GraphCells.
  // A relationship can be binary (DefaultEdge) or n-ary (NAryEdge).
  // The requested action is slightly different depending on selected items.
  // According to the number of Edges in selected, the action can be:
  // 0 => Propose a relationship between selected according included classes.
  // 1 and it is NAryEdge => The class of that NAryEdge if it is possible according implements java.io.Serializable
  //      current cardinality and included classes..
  // other cases => Error, no relationships are allowed.
  public Object[] getPossibleRelationships(GraphCell[] selected) {
    // Possible relationships initialization.
    Vector v = new Vector();

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

        // Connections are only possible with two or more elements and without binary edges.
      }
    }
    if (selected.length >= 2 && edgesNum == 0) {

      // The number of NAryEdges is considered.
      if (nAryEdgesNum == 0) {
        // acceptConnection methods only admits vertex parameters.
        // Binary relationships.

        // N-ary relationships. Sometimes they can be also binary.
        if (ProducesEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProducesEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (condEdge.acceptConnection(this.getModel(), selected)) {
          v.add("cond");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ProfileOfEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProfileOf");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (TIStartTimeEdge.acceptConnection(this.getModel(), selected)) {
          v.add("TIStartTime");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (medEdge.acceptConnection(this.getModel(), selected)) {
          v.add("med");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (socialRelationsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("socialRelations");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (WorkAsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("WorkAs");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (LiveInEdge.acceptConnection(this.getModel(), selected)) {
          v.add("LiveIn");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActivityAttachedEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActivityAttached");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConditionNeededEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ConditionNeeded");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConnectsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Connects");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (SBhasFloorEdge.acceptConnection(this.getModel(), selected)) {
          v.add("SBhasFloor");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (toolEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tool");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (FPreconditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("FPrecondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AllowedTaskEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AllowedTask");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (relatedConditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("relatedCondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeinv_opEdge.acceptConnection(this.getModel(), selected)) {
          v.add("aeinv_op");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialLocationEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialLocation");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialActivityEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialActivity");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialDateEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialDate");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (deviceEdge.acceptConnection(this.getModel(), selected)) {
          v.add("device");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("CameraFaceToHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializedSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializedSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializesSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializesSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RoleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Role");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (DeonticAssignementEdge.acceptConnection(this.getModel(), selected)) {
          v.add("DeonticAssignement");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionResponsibleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionResponsible");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionHappeningAfterwards");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AffectedActionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AffectedAction");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodySpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (closeObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("closeObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (pickUpObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("pickUpObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (waitForHumanVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("waitForHumanVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (durationVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("durationVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToSpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToSpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (messageVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("messageVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapXVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapXVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("sitDownOnSeatVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOnWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOnWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToPlaceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToPlaceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapDeviceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapDeviceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (openObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("openObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (animVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("animVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (useObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("useObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjDestinyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapYVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapYVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (switchRoomVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("switchRoomVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOffWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOffWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (dropObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("dropObjVar");
	  }

      }
      else if (nAryEdgesNum == 1) {

        if (selectedEdge instanceof ProducesEventEdge &&
        (ProducesEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProducesEvent");
        }

        if (selectedEdge instanceof condEdge &&
        (condEdge.acceptConnection(this.getModel(), selected))) {
          v.add("cond");
        }

        if (selectedEdge instanceof ProfileOfEdge &&
        (ProfileOfEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProfileOf");
        }

        if (selectedEdge instanceof TIStartTimeEdge &&
        (TIStartTimeEdge.acceptConnection(this.getModel(), selected))) {
          v.add("TIStartTime");
        }

        if (selectedEdge instanceof medEdge &&
        (medEdge.acceptConnection(this.getModel(), selected))) {
          v.add("med");
        }

        if (selectedEdge instanceof socialRelationsEdge &&
        (socialRelationsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("socialRelations");
        }

        if (selectedEdge instanceof WorkAsEdge &&
        (WorkAsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("WorkAs");
        }

        if (selectedEdge instanceof LiveInEdge &&
        (LiveInEdge.acceptConnection(this.getModel(), selected))) {
          v.add("LiveIn");
        }

        if (selectedEdge instanceof RelatedEventEdge &&
        (RelatedEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedEvent");
        }

        if (selectedEdge instanceof ActivityAttachedEdge &&
        (ActivityAttachedEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActivityAttached");
        }

        if (selectedEdge instanceof ConditionNeededEdge &&
        (ConditionNeededEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ConditionNeeded");
        }

        if (selectedEdge instanceof ConnectsEdge &&
        (ConnectsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Connects");
        }

        if (selectedEdge instanceof SBhasFloorEdge &&
        (SBhasFloorEdge.acceptConnection(this.getModel(), selected))) {
          v.add("SBhasFloor");
        }

        if (selectedEdge instanceof toolEdge &&
        (toolEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tool");
        }

        if (selectedEdge instanceof FPreconditionEdge &&
        (FPreconditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("FPrecondition");
        }

        if (selectedEdge instanceof AllowedTaskEdge &&
        (AllowedTaskEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AllowedTask");
        }

        if (selectedEdge instanceof relatedConditionEdge &&
        (relatedConditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("relatedCondition");
        }

        if (selectedEdge instanceof aeinv_opEdge &&
        (aeinv_opEdge.acceptConnection(this.getModel(), selected))) {
          v.add("aeinv_op");
        }

        if (selectedEdge instanceof aemd_op2Edge &&
        (aemd_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op2");
        }

        if (selectedEdge instanceof aeas_op2Edge &&
        (aeas_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op2");
        }

        if (selectedEdge instanceof aeas_op1Edge &&
        (aeas_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op1");
        }

        if (selectedEdge instanceof aemd_op1Edge &&
        (aemd_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op1");
        }

        if (selectedEdge instanceof RelatedHumanEdge &&
        (RelatedHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedHuman");
        }

        if (selectedEdge instanceof InitialLocationEdge &&
        (InitialLocationEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialLocation");
        }

        if (selectedEdge instanceof InitialActivityEdge &&
        (InitialActivityEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialActivity");
        }

        if (selectedEdge instanceof InitialDateEdge &&
        (InitialDateEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialDate");
        }

        if (selectedEdge instanceof deviceEdge &&
        (deviceEdge.acceptConnection(this.getModel(), selected))) {
          v.add("device");
        }

        if (selectedEdge instanceof CameraFaceToHumanEdge &&
        (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("CameraFaceToHuman");
        }

        if (selectedEdge instanceof InitializedSymptomEdge &&
        (InitializedSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializedSymptom");
        }

        if (selectedEdge instanceof InitializesSymptomEdge &&
        (InitializesSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializesSymptom");
        }

        if (selectedEdge instanceof RoleEdge &&
        (RoleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Role");
        }

        if (selectedEdge instanceof DeonticAssignementEdge &&
        (DeonticAssignementEdge.acceptConnection(this.getModel(), selected))) {
          v.add("DeonticAssignement");
        }

        if (selectedEdge instanceof ActionResponsibleEdge &&
        (ActionResponsibleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionResponsible");
        }

        if (selectedEdge instanceof ActionHappeningAfterwardsEdge &&
        (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionHappeningAfterwards");
        }

        if (selectedEdge instanceof AffectedActionEdge &&
        (AffectedActionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AffectedAction");
        }

        if (selectedEdge instanceof goToBodySpeedVarEdge &&
        (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodySpeedVar");
        }

        if (selectedEdge instanceof leaveObjVarEdge &&
        (leaveObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjVar");
        }

        if (selectedEdge instanceof closeObjVarEdge &&
        (closeObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("closeObjVar");
        }

        if (selectedEdge instanceof pickUpObjVarEdge &&
        (pickUpObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("pickUpObjVar");
        }

        if (selectedEdge instanceof waitForHumanVarEdge &&
        (waitForHumanVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("waitForHumanVar");
        }

        if (selectedEdge instanceof durationVarEdge &&
        (durationVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("durationVar");
        }

        if (selectedEdge instanceof goToSpeedVarEdge &&
        (goToSpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToSpeedVar");
        }

        if (selectedEdge instanceof messageVarEdge &&
        (messageVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("messageVar");
        }

        if (selectedEdge instanceof tapXVarEdge &&
        (tapXVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapXVar");
        }

        if (selectedEdge instanceof sitDownOnSeatVarEdge &&
        (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("sitDownOnSeatVar");
        }

        if (selectedEdge instanceof putOnWearableVarEdge &&
        (putOnWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOnWearableVar");
        }

        if (selectedEdge instanceof goToPlaceVarEdge &&
        (goToPlaceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToPlaceVar");
        }

        if (selectedEdge instanceof tapDeviceVarEdge &&
        (tapDeviceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapDeviceVar");
        }

        if (selectedEdge instanceof openObjVarEdge &&
        (openObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("openObjVar");
        }

        if (selectedEdge instanceof animVarEdge &&
        (animVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("animVar");
        }

        if (selectedEdge instanceof useObjVarEdge &&
        (useObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("useObjVar");
        }

        if (selectedEdge instanceof goToBodyVarEdge &&
        (goToBodyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodyVar");
        }

        if (selectedEdge instanceof leaveObjDestinyVarEdge &&
        (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjDestinyVar");
        }

        if (selectedEdge instanceof tapYVarEdge &&
        (tapYVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapYVar");
        }

        if (selectedEdge instanceof switchRoomVarEdge &&
        (switchRoomVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("switchRoomVar");
        }

        if (selectedEdge instanceof putOffWearableVarEdge &&
        (putOffWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOffWearableVar");
        }

        if (selectedEdge instanceof dropObjVarEdge &&
        (dropObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("dropObjVar");
        }

      }
    }

    return v.toArray();
  }

  public DefaultGraphCell getInstanciaNRelacion(String relacion,
                                                GraphCell[] selected) {

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

      }
    }
    if (nAryEdgesNum <= 1 && edgesNum == 0) {

      if (relacion.equalsIgnoreCase("ProducesEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProducesEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProducesEventEdge(new ingenias.editor.entities.ProducesEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("cond")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof condEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new condEdge(new ingenias.editor.entities.cond(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ProfileOf")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProfileOfEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProfileOfEdge(new ingenias.editor.entities.ProfileOf(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("TIStartTime")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof TIStartTimeEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new TIStartTimeEdge(new ingenias.editor.entities.TIStartTime(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("med")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof medEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new medEdge(new ingenias.editor.entities.med(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("socialRelations")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof socialRelationsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new socialRelationsEdge(new ingenias.editor.entities.socialRelations(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("WorkAs")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof WorkAsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new WorkAsEdge(new ingenias.editor.entities.WorkAs(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("LiveIn")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof LiveInEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new LiveInEdge(new ingenias.editor.entities.LiveIn(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedEventEdge(new ingenias.editor.entities.RelatedEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActivityAttached")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActivityAttachedEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActivityAttachedEdge(new ingenias.editor.entities.ActivityAttached(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ConditionNeeded")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConditionNeededEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConditionNeededEdge(new ingenias.editor.entities.ConditionNeeded(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Connects")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConnectsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConnectsEdge(new ingenias.editor.entities.Connects(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("SBhasFloor")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof SBhasFloorEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new SBhasFloorEdge(new ingenias.editor.entities.SBhasFloor(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tool")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof toolEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new toolEdge(new ingenias.editor.entities.tool(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("FPrecondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof FPreconditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new FPreconditionEdge(new ingenias.editor.entities.FPrecondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AllowedTask")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AllowedTaskEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AllowedTaskEdge(new ingenias.editor.entities.AllowedTask(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("relatedCondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof relatedConditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new relatedConditionEdge(new ingenias.editor.entities.relatedCondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeinv_op")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeinv_opEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeinv_opEdge(new ingenias.editor.entities.aeinv_op(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op2Edge(new ingenias.editor.entities.aemd_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op2Edge(new ingenias.editor.entities.aeas_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op1Edge(new ingenias.editor.entities.aeas_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op1Edge(new ingenias.editor.entities.aemd_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedHumanEdge(new ingenias.editor.entities.RelatedHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialLocation")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialLocationEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialLocationEdge(new ingenias.editor.entities.InitialLocation(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialActivity")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialActivityEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialActivityEdge(new ingenias.editor.entities.InitialActivity(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialDate")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialDateEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialDateEdge(new ingenias.editor.entities.InitialDate(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("device")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof deviceEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new deviceEdge(new ingenias.editor.entities.device(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("CameraFaceToHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof CameraFaceToHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new CameraFaceToHumanEdge(new ingenias.editor.entities.CameraFaceToHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializedSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializedSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializedSymptomEdge(new ingenias.editor.entities.InitializedSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializesSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializesSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializesSymptomEdge(new ingenias.editor.entities.InitializesSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Role")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RoleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RoleEdge(new ingenias.editor.entities.Role(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("DeonticAssignement")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof DeonticAssignementEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new DeonticAssignementEdge(new ingenias.editor.entities.DeonticAssignement(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionResponsible")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionResponsibleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionResponsibleEdge(new ingenias.editor.entities.ActionResponsible(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionHappeningAfterwards")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionHappeningAfterwardsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionHappeningAfterwardsEdge(new ingenias.editor.entities.ActionHappeningAfterwards(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AffectedAction")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AffectedActionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AffectedActionEdge(new ingenias.editor.entities.AffectedAction(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodySpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodySpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodySpeedVarEdge(new ingenias.editor.entities.goToBodySpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjVarEdge(new ingenias.editor.entities.leaveObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("closeObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof closeObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new closeObjVarEdge(new ingenias.editor.entities.closeObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("pickUpObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof pickUpObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new pickUpObjVarEdge(new ingenias.editor.entities.pickUpObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("waitForHumanVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof waitForHumanVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new waitForHumanVarEdge(new ingenias.editor.entities.waitForHumanVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("durationVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof durationVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new durationVarEdge(new ingenias.editor.entities.durationVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToSpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToSpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToSpeedVarEdge(new ingenias.editor.entities.goToSpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("messageVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof messageVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new messageVarEdge(new ingenias.editor.entities.messageVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapXVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapXVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapXVarEdge(new ingenias.editor.entities.tapXVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("sitDownOnSeatVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof sitDownOnSeatVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new sitDownOnSeatVarEdge(new ingenias.editor.entities.sitDownOnSeatVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOnWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOnWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOnWearableVarEdge(new ingenias.editor.entities.putOnWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToPlaceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToPlaceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToPlaceVarEdge(new ingenias.editor.entities.goToPlaceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapDeviceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapDeviceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapDeviceVarEdge(new ingenias.editor.entities.tapDeviceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("openObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof openObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new openObjVarEdge(new ingenias.editor.entities.openObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("animVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof animVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new animVarEdge(new ingenias.editor.entities.animVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("useObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof useObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new useObjVarEdge(new ingenias.editor.entities.useObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodyVarEdge(new ingenias.editor.entities.goToBodyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjDestinyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjDestinyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjDestinyVarEdge(new ingenias.editor.entities.leaveObjDestinyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapYVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapYVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapYVarEdge(new ingenias.editor.entities.tapYVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("switchRoomVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof switchRoomVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new switchRoomVarEdge(new ingenias.editor.entities.switchRoomVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOffWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOffWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOffWearableVarEdge(new ingenias.editor.entities.putOffWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("dropObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof dropObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new dropObjVarEdge(new ingenias.editor.entities.dropObjVar(getMJGraph().getNewId()));
        }
      }

    }

    return null;
  }
  
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("AnotherActionHappens")) {
    AnotherActionHappens nentity=getOM().createAnotherActionHappens(getMJGraph().getNewId("AnotherActionHappens"));
      DefaultGraphCell vertex = new
          AnotherActionHappensCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=getOM().createHuman(getMJGraph().getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SArea")) {
    SArea nentity=getOM().createSArea(getMJGraph().getNewId("SArea"));
      DefaultGraphCell vertex = new
          SAreaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBuilding")) {
    SBuilding nentity=getOM().createSBuilding(getMJGraph().getNewId("SBuilding"));
      DefaultGraphCell vertex = new
          SBuildingCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SFloor")) {
    SFloor nentity=getOM().createSFloor(getMJGraph().getNewId("SFloor"));
      DefaultGraphCell vertex = new
          SFloorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ConsecutiveActions")) {
    ConsecutiveActions nentity=getOM().createConsecutiveActions(getMJGraph().getNewId("ConsecutiveActions"));
      DefaultGraphCell vertex = new
          ConsecutiveActionsCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoToBodyLoc")) {
    GoToBodyLoc nentity=getOM().createGoToBodyLoc(getMJGraph().getNewId("GoToBodyLoc"));
      DefaultGraphCell vertex = new
          GoToBodyLocCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TakeOffTask")) {
    TakeOffTask nentity=getOM().createTakeOffTask(getMJGraph().getNewId("TakeOffTask"));
      DefaultGraphCell vertex = new
          TakeOffTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitTask")) {
    WaitTask nentity=getOM().createWaitTask(getMJGraph().getNewId("WaitTask"));
      DefaultGraphCell vertex = new
          WaitTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BPickUpTask")) {
    BPickUpTask nentity=getOM().createBPickUpTask(getMJGraph().getNewId("BPickUpTask"));
      DefaultGraphCell vertex = new
          BPickUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallSleep")) {
    FallSleep nentity=getOM().createFallSleep(getMJGraph().getNewId("FallSleep"));
      DefaultGraphCell vertex = new
          FallSleepCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("OpenTask")) {
    OpenTask nentity=getOM().createOpenTask(getMJGraph().getNewId("OpenTask"));
      DefaultGraphCell vertex = new
          OpenTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Drink")) {
    Drink nentity=getOM().createDrink(getMJGraph().getNewId("Drink"));
      DefaultGraphCell vertex = new
          DrinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SayTask")) {
    SayTask nentity=getOM().createSayTask(getMJGraph().getNewId("SayTask"));
      DefaultGraphCell vertex = new
          SayTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BWakeUpTask")) {
    BWakeUpTask nentity=getOM().createBWakeUpTask(getMJGraph().getNewId("BWakeUpTask"));
      DefaultGraphCell vertex = new
          BWakeUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGoToTask")) {
    BGoToTask nentity=getOM().createBGoToTask(getMJGraph().getNewId("BGoToTask"));
      DefaultGraphCell vertex = new
          BGoToTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StandUp")) {
    StandUp nentity=getOM().createStandUp(getMJGraph().getNewId("StandUp"));
      DefaultGraphCell vertex = new
          StandUpCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TapXYTask")) {
    TapXYTask nentity=getOM().createTapXYTask(getMJGraph().getNewId("TapXYTask"));
      DefaultGraphCell vertex = new
          TapXYTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CloseTask")) {
    CloseTask nentity=getOM().createCloseTask(getMJGraph().getNewId("CloseTask"));
      DefaultGraphCell vertex = new
          CloseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BSequentialTask")) {
    BSequentialTask nentity=getOM().createBSequentialTask(getMJGraph().getNewId("BSequentialTask"));
      DefaultGraphCell vertex = new
          BSequentialTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SitDown")) {
    SitDown nentity=getOM().createSitDown(getMJGraph().getNewId("SitDown"));
      DefaultGraphCell vertex = new
          SitDownCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoIntoBed")) {
    GoIntoBed nentity=getOM().createGoIntoBed(getMJGraph().getNewId("GoIntoBed"));
      DefaultGraphCell vertex = new
          GoIntoBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwitchLightTask")) {
    SwitchLightTask nentity=getOM().createSwitchLightTask(getMJGraph().getNewId("SwitchLightTask"));
      DefaultGraphCell vertex = new
          SwitchLightTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BLeaveTask")) {
    BLeaveTask nentity=getOM().createBLeaveTask(getMJGraph().getNewId("BLeaveTask"));
      DefaultGraphCell vertex = new
          BLeaveTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGetUpFromBed")) {
    BGetUpFromBed nentity=getOM().createBGetUpFromBed(getMJGraph().getNewId("BGetUpFromBed"));
      DefaultGraphCell vertex = new
          BGetUpFromBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwipeTask")) {
    SwipeTask nentity=getOM().createSwipeTask(getMJGraph().getNewId("SwipeTask"));
      DefaultGraphCell vertex = new
          SwipeTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BRandomTask")) {
    BRandomTask nentity=getOM().createBRandomTask(getMJGraph().getNewId("BRandomTask"));
      DefaultGraphCell vertex = new
          BRandomTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DropObj")) {
    DropObj nentity=getOM().createDropObj(getMJGraph().getNewId("DropObj"));
      DefaultGraphCell vertex = new
          DropObjCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PutOnTask")) {
    PutOnTask nentity=getOM().createPutOnTask(getMJGraph().getNewId("PutOnTask"));
      DefaultGraphCell vertex = new
          PutOnTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitForBodyClose")) {
    WaitForBodyClose nentity=getOM().createWaitForBodyClose(getMJGraph().getNewId("WaitForBodyClose"));
      DefaultGraphCell vertex = new
          WaitForBodyCloseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PlayAnimationTask")) {
    PlayAnimationTask nentity=getOM().createPlayAnimationTask(getMJGraph().getNewId("PlayAnimationTask"));
      DefaultGraphCell vertex = new
          PlayAnimationTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallTask")) {
    FallTask nentity=getOM().createFallTask(getMJGraph().getNewId("FallTask"));
      DefaultGraphCell vertex = new
          FallTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BUseTask")) {
    BUseTask nentity=getOM().createBUseTask(getMJGraph().getNewId("BUseTask"));
      DefaultGraphCell vertex = new
          BUseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Eat")) {
    Eat nentity=getOM().createEat(getMJGraph().getNewId("Eat"));
      DefaultGraphCell vertex = new
          EatCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("AnotherActionHappens")) {
      return AnotherActionHappensView.getSize((ingenias.editor.entities.AnotherActionHappens)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((ingenias.editor.entities.Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SArea")) {
      return SAreaView.getSize((ingenias.editor.entities.SArea)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBuilding")) {
      return SBuildingView.getSize((ingenias.editor.entities.SBuilding)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SFloor")) {
      return SFloorView.getSize((ingenias.editor.entities.SFloor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ConsecutiveActions")) {
      return ConsecutiveActionsView.getSize((ingenias.editor.entities.ConsecutiveActions)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoToBodyLoc")) {
      return GoToBodyLocView.getSize((ingenias.editor.entities.GoToBodyLoc)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TakeOffTask")) {
      return TakeOffTaskView.getSize((ingenias.editor.entities.TakeOffTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitTask")) {
      return WaitTaskView.getSize((ingenias.editor.entities.WaitTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BPickUpTask")) {
      return BPickUpTaskView.getSize((ingenias.editor.entities.BPickUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallSleep")) {
      return FallSleepView.getSize((ingenias.editor.entities.FallSleep)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("OpenTask")) {
      return OpenTaskView.getSize((ingenias.editor.entities.OpenTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Drink")) {
      return DrinkView.getSize((ingenias.editor.entities.Drink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SayTask")) {
      return SayTaskView.getSize((ingenias.editor.entities.SayTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BWakeUpTask")) {
      return BWakeUpTaskView.getSize((ingenias.editor.entities.BWakeUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGoToTask")) {
      return BGoToTaskView.getSize((ingenias.editor.entities.BGoToTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StandUp")) {
      return StandUpView.getSize((ingenias.editor.entities.StandUp)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TapXYTask")) {
      return TapXYTaskView.getSize((ingenias.editor.entities.TapXYTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CloseTask")) {
      return CloseTaskView.getSize((ingenias.editor.entities.CloseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BSequentialTask")) {
      return BSequentialTaskView.getSize((ingenias.editor.entities.BSequentialTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SitDown")) {
      return SitDownView.getSize((ingenias.editor.entities.SitDown)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoIntoBed")) {
      return GoIntoBedView.getSize((ingenias.editor.entities.GoIntoBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwitchLightTask")) {
      return SwitchLightTaskView.getSize((ingenias.editor.entities.SwitchLightTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BLeaveTask")) {
      return BLeaveTaskView.getSize((ingenias.editor.entities.BLeaveTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGetUpFromBed")) {
      return BGetUpFromBedView.getSize((ingenias.editor.entities.BGetUpFromBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwipeTask")) {
      return SwipeTaskView.getSize((ingenias.editor.entities.SwipeTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BRandomTask")) {
      return BRandomTaskView.getSize((ingenias.editor.entities.BRandomTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DropObj")) {
      return DropObjView.getSize((ingenias.editor.entities.DropObj)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PutOnTask")) {
      return PutOnTaskView.getSize((ingenias.editor.entities.PutOnTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitForBodyClose")) {
      return WaitForBodyCloseView.getSize((ingenias.editor.entities.WaitForBodyClose)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PlayAnimationTask")) {
      return PlayAnimationTaskView.getSize((ingenias.editor.entities.PlayAnimationTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallTask")) {
      return FallTaskView.getSize((ingenias.editor.entities.FallTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BUseTask")) {
      return BUseTaskView.getSize((ingenias.editor.entities.BUseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Eat")) {
      return EatView.getSize((ingenias.editor.entities.Eat)entity);      
    }
    else


      if (entity.getType().equalsIgnoreCase("ProducesEvent")) {
      	return ProducesEventView.getSize((ingenias.editor.entities.ProducesEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("cond")) {
      	return condView.getSize((ingenias.editor.entities.cond)entity);
      }

      if (entity.getType().equalsIgnoreCase("ProfileOf")) {
      	return ProfileOfView.getSize((ingenias.editor.entities.ProfileOf)entity);
      }

      if (entity.getType().equalsIgnoreCase("TIStartTime")) {
      	return TIStartTimeView.getSize((ingenias.editor.entities.TIStartTime)entity);
      }

      if (entity.getType().equalsIgnoreCase("med")) {
      	return medView.getSize((ingenias.editor.entities.med)entity);
      }

      if (entity.getType().equalsIgnoreCase("socialRelations")) {
      	return socialRelationsView.getSize((ingenias.editor.entities.socialRelations)entity);
      }

      if (entity.getType().equalsIgnoreCase("WorkAs")) {
      	return WorkAsView.getSize((ingenias.editor.entities.WorkAs)entity);
      }

      if (entity.getType().equalsIgnoreCase("LiveIn")) {
      	return LiveInView.getSize((ingenias.editor.entities.LiveIn)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedEvent")) {
      	return RelatedEventView.getSize((ingenias.editor.entities.RelatedEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActivityAttached")) {
      	return ActivityAttachedView.getSize((ingenias.editor.entities.ActivityAttached)entity);
      }

      if (entity.getType().equalsIgnoreCase("ConditionNeeded")) {
      	return ConditionNeededView.getSize((ingenias.editor.entities.ConditionNeeded)entity);
      }

      if (entity.getType().equalsIgnoreCase("Connects")) {
      	return ConnectsView.getSize((ingenias.editor.entities.Connects)entity);
      }

      if (entity.getType().equalsIgnoreCase("SBhasFloor")) {
      	return SBhasFloorView.getSize((ingenias.editor.entities.SBhasFloor)entity);
      }

      if (entity.getType().equalsIgnoreCase("tool")) {
      	return toolView.getSize((ingenias.editor.entities.tool)entity);
      }

      if (entity.getType().equalsIgnoreCase("FPrecondition")) {
      	return FPreconditionView.getSize((ingenias.editor.entities.FPrecondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("AllowedTask")) {
      	return AllowedTaskView.getSize((ingenias.editor.entities.AllowedTask)entity);
      }

      if (entity.getType().equalsIgnoreCase("relatedCondition")) {
      	return relatedConditionView.getSize((ingenias.editor.entities.relatedCondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeinv_op")) {
      	return aeinv_opView.getSize((ingenias.editor.entities.aeinv_op)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op2")) {
      	return aemd_op2View.getSize((ingenias.editor.entities.aemd_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op2")) {
      	return aeas_op2View.getSize((ingenias.editor.entities.aeas_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op1")) {
      	return aeas_op1View.getSize((ingenias.editor.entities.aeas_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op1")) {
      	return aemd_op1View.getSize((ingenias.editor.entities.aemd_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedHuman")) {
      	return RelatedHumanView.getSize((ingenias.editor.entities.RelatedHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialLocation")) {
      	return InitialLocationView.getSize((ingenias.editor.entities.InitialLocation)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialActivity")) {
      	return InitialActivityView.getSize((ingenias.editor.entities.InitialActivity)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialDate")) {
      	return InitialDateView.getSize((ingenias.editor.entities.InitialDate)entity);
      }

      if (entity.getType().equalsIgnoreCase("device")) {
      	return deviceView.getSize((ingenias.editor.entities.device)entity);
      }

      if (entity.getType().equalsIgnoreCase("CameraFaceToHuman")) {
      	return CameraFaceToHumanView.getSize((ingenias.editor.entities.CameraFaceToHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializedSymptom")) {
      	return InitializedSymptomView.getSize((ingenias.editor.entities.InitializedSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializesSymptom")) {
      	return InitializesSymptomView.getSize((ingenias.editor.entities.InitializesSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("Role")) {
      	return RoleView.getSize((ingenias.editor.entities.Role)entity);
      }

      if (entity.getType().equalsIgnoreCase("DeonticAssignement")) {
      	return DeonticAssignementView.getSize((ingenias.editor.entities.DeonticAssignement)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionResponsible")) {
      	return ActionResponsibleView.getSize((ingenias.editor.entities.ActionResponsible)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionHappeningAfterwards")) {
      	return ActionHappeningAfterwardsView.getSize((ingenias.editor.entities.ActionHappeningAfterwards)entity);
      }

      if (entity.getType().equalsIgnoreCase("AffectedAction")) {
      	return AffectedActionView.getSize((ingenias.editor.entities.AffectedAction)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodySpeedVar")) {
      	return goToBodySpeedVarView.getSize((ingenias.editor.entities.goToBodySpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjVar")) {
      	return leaveObjVarView.getSize((ingenias.editor.entities.leaveObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("closeObjVar")) {
      	return closeObjVarView.getSize((ingenias.editor.entities.closeObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("pickUpObjVar")) {
      	return pickUpObjVarView.getSize((ingenias.editor.entities.pickUpObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("waitForHumanVar")) {
      	return waitForHumanVarView.getSize((ingenias.editor.entities.waitForHumanVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("durationVar")) {
      	return durationVarView.getSize((ingenias.editor.entities.durationVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToSpeedVar")) {
      	return goToSpeedVarView.getSize((ingenias.editor.entities.goToSpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("messageVar")) {
      	return messageVarView.getSize((ingenias.editor.entities.messageVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapXVar")) {
      	return tapXVarView.getSize((ingenias.editor.entities.tapXVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("sitDownOnSeatVar")) {
      	return sitDownOnSeatVarView.getSize((ingenias.editor.entities.sitDownOnSeatVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOnWearableVar")) {
      	return putOnWearableVarView.getSize((ingenias.editor.entities.putOnWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToPlaceVar")) {
      	return goToPlaceVarView.getSize((ingenias.editor.entities.goToPlaceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapDeviceVar")) {
      	return tapDeviceVarView.getSize((ingenias.editor.entities.tapDeviceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("openObjVar")) {
      	return openObjVarView.getSize((ingenias.editor.entities.openObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("animVar")) {
      	return animVarView.getSize((ingenias.editor.entities.animVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("useObjVar")) {
      	return useObjVarView.getSize((ingenias.editor.entities.useObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodyVar")) {
      	return goToBodyVarView.getSize((ingenias.editor.entities.goToBodyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjDestinyVar")) {
      	return leaveObjDestinyVarView.getSize((ingenias.editor.entities.leaveObjDestinyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapYVar")) {
      	return tapYVarView.getSize((ingenias.editor.entities.tapYVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("switchRoomVar")) {
      	return switchRoomVarView.getSize((ingenias.editor.entities.switchRoomVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOffWearableVar")) {
      	return putOffWearableVarView.getSize((ingenias.editor.entities.putOffWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("dropObjVar")) {
      	return dropObjVarView.getSize((ingenias.editor.entities.dropObjVar)entity);
      }

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));

    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);

	Entity newEntity=(Entity) vertex.getUserObject();
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.UML)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.UML);
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.INGENIAS)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.INGENIAS);

	getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true

    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));
   

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(AnotherActionHappens.class)) {
      vertex = new AnotherActionHappensCell( (AnotherActionHappens) entity);
      // Default Size for the new Vertex with the new entity within
      size = AnotherActionHappensView.getSize((AnotherActionHappens) entity);
      
    }
    else

    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
      
    }
    else

    if (entity.getClass().equals(SArea.class)) {
      vertex = new SAreaCell( (SArea) entity);
      // Default Size for the new Vertex with the new entity within
      size = SAreaView.getSize((SArea) entity);
      
    }
    else

    if (entity.getClass().equals(SBuilding.class)) {
      vertex = new SBuildingCell( (SBuilding) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBuildingView.getSize((SBuilding) entity);
      
    }
    else

    if (entity.getClass().equals(SFloor.class)) {
      vertex = new SFloorCell( (SFloor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SFloorView.getSize((SFloor) entity);
      
    }
    else

    if (entity.getClass().equals(ConsecutiveActions.class)) {
      vertex = new ConsecutiveActionsCell( (ConsecutiveActions) entity);
      // Default Size for the new Vertex with the new entity within
      size = ConsecutiveActionsView.getSize((ConsecutiveActions) entity);
      
    }
    else

    if (entity.getClass().equals(GoToBodyLoc.class)) {
      vertex = new GoToBodyLocCell( (GoToBodyLoc) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoToBodyLocView.getSize((GoToBodyLoc) entity);
      
    }
    else

    if (entity.getClass().equals(TakeOffTask.class)) {
      vertex = new TakeOffTaskCell( (TakeOffTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TakeOffTaskView.getSize((TakeOffTask) entity);
      
    }
    else

    if (entity.getClass().equals(WaitTask.class)) {
      vertex = new WaitTaskCell( (WaitTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitTaskView.getSize((WaitTask) entity);
      
    }
    else

    if (entity.getClass().equals(BPickUpTask.class)) {
      vertex = new BPickUpTaskCell( (BPickUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BPickUpTaskView.getSize((BPickUpTask) entity);
      
    }
    else

    if (entity.getClass().equals(FallSleep.class)) {
      vertex = new FallSleepCell( (FallSleep) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallSleepView.getSize((FallSleep) entity);
      
    }
    else

    if (entity.getClass().equals(OpenTask.class)) {
      vertex = new OpenTaskCell( (OpenTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = OpenTaskView.getSize((OpenTask) entity);
      
    }
    else

    if (entity.getClass().equals(Drink.class)) {
      vertex = new DrinkCell( (Drink) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkView.getSize((Drink) entity);
      
    }
    else

    if (entity.getClass().equals(SayTask.class)) {
      vertex = new SayTaskCell( (SayTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SayTaskView.getSize((SayTask) entity);
      
    }
    else

    if (entity.getClass().equals(BWakeUpTask.class)) {
      vertex = new BWakeUpTaskCell( (BWakeUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BWakeUpTaskView.getSize((BWakeUpTask) entity);
      
    }
    else

    if (entity.getClass().equals(BGoToTask.class)) {
      vertex = new BGoToTaskCell( (BGoToTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGoToTaskView.getSize((BGoToTask) entity);
      
    }
    else

    if (entity.getClass().equals(StandUp.class)) {
      vertex = new StandUpCell( (StandUp) entity);
      // Default Size for the new Vertex with the new entity within
      size = StandUpView.getSize((StandUp) entity);
      
    }
    else

    if (entity.getClass().equals(TapXYTask.class)) {
      vertex = new TapXYTaskCell( (TapXYTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TapXYTaskView.getSize((TapXYTask) entity);
      
    }
    else

    if (entity.getClass().equals(CloseTask.class)) {
      vertex = new CloseTaskCell( (CloseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = CloseTaskView.getSize((CloseTask) entity);
      
    }
    else

    if (entity.getClass().equals(BSequentialTask.class)) {
      vertex = new BSequentialTaskCell( (BSequentialTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BSequentialTaskView.getSize((BSequentialTask) entity);
      
    }
    else

    if (entity.getClass().equals(SitDown.class)) {
      vertex = new SitDownCell( (SitDown) entity);
      // Default Size for the new Vertex with the new entity within
      size = SitDownView.getSize((SitDown) entity);
      
    }
    else

    if (entity.getClass().equals(GoIntoBed.class)) {
      vertex = new GoIntoBedCell( (GoIntoBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoIntoBedView.getSize((GoIntoBed) entity);
      
    }
    else

    if (entity.getClass().equals(SwitchLightTask.class)) {
      vertex = new SwitchLightTaskCell( (SwitchLightTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwitchLightTaskView.getSize((SwitchLightTask) entity);
      
    }
    else

    if (entity.getClass().equals(BLeaveTask.class)) {
      vertex = new BLeaveTaskCell( (BLeaveTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BLeaveTaskView.getSize((BLeaveTask) entity);
      
    }
    else

    if (entity.getClass().equals(BGetUpFromBed.class)) {
      vertex = new BGetUpFromBedCell( (BGetUpFromBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGetUpFromBedView.getSize((BGetUpFromBed) entity);
      
    }
    else

    if (entity.getClass().equals(SwipeTask.class)) {
      vertex = new SwipeTaskCell( (SwipeTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwipeTaskView.getSize((SwipeTask) entity);
      
    }
    else

    if (entity.getClass().equals(BRandomTask.class)) {
      vertex = new BRandomTaskCell( (BRandomTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BRandomTaskView.getSize((BRandomTask) entity);
      
    }
    else

    if (entity.getClass().equals(DropObj.class)) {
      vertex = new DropObjCell( (DropObj) entity);
      // Default Size for the new Vertex with the new entity within
      size = DropObjView.getSize((DropObj) entity);
      
    }
    else

    if (entity.getClass().equals(PutOnTask.class)) {
      vertex = new PutOnTaskCell( (PutOnTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PutOnTaskView.getSize((PutOnTask) entity);
      
    }
    else

    if (entity.getClass().equals(WaitForBodyClose.class)) {
      vertex = new WaitForBodyCloseCell( (WaitForBodyClose) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitForBodyCloseView.getSize((WaitForBodyClose) entity);
      
    }
    else

    if (entity.getClass().equals(PlayAnimationTask.class)) {
      vertex = new PlayAnimationTaskCell( (PlayAnimationTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PlayAnimationTaskView.getSize((PlayAnimationTask) entity);
      
    }
    else

    if (entity.getClass().equals(FallTask.class)) {
      vertex = new FallTaskCell( (FallTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallTaskView.getSize((FallTask) entity);
      
    }
    else

    if (entity.getClass().equals(BUseTask.class)) {
      vertex = new BUseTaskCell( (BUseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BUseTaskView.getSize((BUseTask) entity);
      
    }
    else

    if (entity.getClass().equals(Eat.class)) {
      vertex = new EatCell( (Eat) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatView.getSize((Eat) entity);
      
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
JOptionPane.showMessageDialog(this,
		 "Object not allowed in this diagram "+this.getID()+":"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName(),"Warning", JOptionPane.WARNING_MESSAGE);    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
      getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true  
        // waits for the cellview to be created
		boolean created=false;
		VertexView vv=null;
		while (!created){
			CellView[] cellviews = this.getGraphLayoutCache().getCellViews();
			for (CellView cv:cellviews){
				if (cv.getCell()==vertex){
					// created!
					created=true;
					vv=(VertexView)cv;
				}
			}
			try {
				Thread.currentThread().sleep(10);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		// This should be used when the corresponding view for the entity has containers!
		// It can be known by inspecting its renderer. To get it, a cellview is needed,
		// but the cellview is created after a while via succesive callbacks to
		// the view factories

		if (!ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null).isEmpty()){
			// there are container renderers that need new cells corresponding to children to
			// be inserted

						Hashtable<String, CollectionPanel> renderers = ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null);
			for (String field:renderers.keySet()){
				Method obtainenumeration;
				try {
					obtainenumeration = entity.getClass().getMethod("get"+field+"Elements");
					Enumeration<ingenias.editor.entities.Entity>  enom=(Enumeration<ingenias.editor.entities.Entity>) obtainenumeration.invoke(entity,new Object[]{});
					while (enom.hasMoreElements()){
						DefaultGraphCell child=this.insertDuplicated(new Point(40,10), enom.nextElement());
						try {
							getListenerContainer().setParent(child,vertex);
						} catch (WrongParent e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} 
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				}
							
		}
		
                             
    }
   return vertex;

  }


 public synchronized JGraph cloneJGraph(IDEState ids){

		

		 NormDefinitionModelJGraph jg=new  NormDefinitionModelJGraph(
				(NormDefinitionDataEntity) this.mde,name, ids.om,
				new Model(ids),new BasicMarqueeHandler(),ids.prefs); 

		this.setSelectionCells(getGraphLayoutCache().getCells(false,true,false,false));
		Action copyaction =new EventRedirectorForGraphCopy(this,this.getTransferHandler().getCopyAction(),null	); 			
		Action pasteaction =new EventRedirectorPasteForGraphCopy(jg,jg.getTransferHandler().getPasteAction(),null	);
		copyaction.actionPerformed(new ActionEvent(this,0,"hello"));		
		pasteaction.actionPerformed(new ActionEvent(this,0,"hello"));
		jg.invalidate();
		jg.doLayout();
		
		return jg;

	}


  public String toString() {
    return this.getID();
  }

}
