

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 

package ingenias.editor.models;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;


import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.*;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.rendererxml.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;
import java.util.concurrent.TimeUnit;

public class SimulationDiagramModelJGraph extends ModelJGraph {

  private Preferences prefs;
  
 

  public SimulationDiagramModelJGraph(SimulationDiagramDataEntity mde, 
                               String nombre, ObjectManager om, Model
                               m, BasicMarqueeHandler mh, Preferences prefs) {
    super(mde, nombre, m, mh,om);
    this.prefs=prefs;
    ToolTipManager.sharedInstance().registerComponent(this);
this.getModel().addGraphModelListener(new ChangeNARYEdgeLocation(this));
this.getModel().addGraphModelListener(new ChangeEntityLocation(this));

    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.SimulationDiagramCellViewFactory());

  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }





  public JToolBar getPaleta() {
    return toolbar;

  }

  protected void creaToolBar() {
    if (toolbar==null){
    toolbar = new FilteredJToolBar("SimulationDiagram");
    toolbar.setFloatable(false);
    ImageIcon undoIcon = null;
    JButton jb = null;


   if (true){
    Image img_PartOfBody =
        ImageLoader.getImage("images/entities/PartsOfBody16.png");
    undoIcon = new ImageIcon(img_PartOfBody);
    Action PartOfBody=
        new AbstractAction("PartOfBody", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PartOfBody");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PartOfBody.setEnabled(true);
    jb = new JButton(PartOfBody){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PartOfBody");	
    jb.setToolTipText("PartOfBody:"+new PartOfBody("").getHelpDesc()+"\n\n"+new PartOfBody("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_InitProgramPool =
        ImageLoader.getImage("images/sim/ProgramDeviceInitialization16.png");
    undoIcon = new ImageIcon(img_InitProgramPool);
    Action InitProgramPool=
        new AbstractAction("InitProgramPool", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "InitProgramPool");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    InitProgramPool.setEnabled(true);
    jb = new JButton(InitProgramPool){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("InitProgramPool");	
    jb.setToolTipText("InitProgramPool:"+new InitProgramPool("").getHelpDesc()+"\n\n"+new InitProgramPool("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SymptomInitialization =
        ImageLoader.getImage("images/profiles/DiseaseProfile/SymptomInitialization16.png");
    undoIcon = new ImageIcon(img_SymptomInitialization);
    Action SymptomInitialization=
        new AbstractAction("SymptomInitialization", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SymptomInitialization");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SymptomInitialization.setEnabled(true);
    jb = new JButton(SymptomInitialization){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SymptomInitialization");	
    jb.setToolTipText("SymptomInitialization:"+new SymptomInitialization("").getHelpDesc()+"\n\n"+new SymptomInitialization("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_AndroidApplication =
        ImageLoader.getImage("images/devices/AndroidApp16.png");
    undoIcon = new ImageIcon(img_AndroidApplication);
    Action AndroidApplication=
        new AbstractAction("AndroidApplication", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "AndroidApplication");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    AndroidApplication.setEnabled(true);
    jb = new JButton(AndroidApplication){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("AndroidApplication");	
    jb.setToolTipText("AndroidApplication:"+new AndroidApplication("").getHelpDesc()+"\n\n"+new AndroidApplication("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SDate =
        ImageLoader.getImage("images/time/Date16.png");
    undoIcon = new ImageIcon(img_SDate);
    Action SDate=
        new AbstractAction("SDate", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SDate");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SDate.setEnabled(true);
    jb = new JButton(SDate){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SDate");	
    jb.setToolTipText("SDate:"+new SDate("").getHelpDesc()+"\n\n"+new SDate("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_AndroidEmulator =
        ImageLoader.getImage("images/devices/Emulator16.png");
    undoIcon = new ImageIcon(img_AndroidEmulator);
    Action AndroidEmulator=
        new AbstractAction("AndroidEmulator", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "AndroidEmulator");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    AndroidEmulator.setEnabled(true);
    jb = new JButton(AndroidEmulator){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("AndroidEmulator");	
    jb.setToolTipText("AndroidEmulator:"+new AndroidEmulator("").getHelpDesc()+"\n\n"+new AndroidEmulator("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SBathroom =
        ImageLoader.getImage("images/space/bathroom16.png");
    undoIcon = new ImageIcon(img_SBathroom);
    Action SBathroom=
        new AbstractAction("SBathroom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SBathroom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SBathroom.setEnabled(true);
    jb = new JButton(SBathroom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SBathroom");	
    jb.setToolTipText("SBathroom:"+new SBathroom("").getHelpDesc()+"\n\n"+new SBathroom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_Human =
        ImageLoader.getImage("images/entities/Human16.png");
    undoIcon = new ImageIcon(img_Human);
    Action Human=
        new AbstractAction("Human", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Human");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Human.setEnabled(true);
    jb = new JButton(Human){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Human");	
    jb.setToolTipText("Human:"+new Human("").getHelpDesc()+"\n\n"+new Human("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FlyCamInit =
        ImageLoader.getImage("images/sim/ScreenAndCamPos16.png");
    undoIcon = new ImageIcon(img_FlyCamInit);
    Action FlyCamInit=
        new AbstractAction("FlyCamInit", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FlyCamInit");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FlyCamInit.setEnabled(true);
    jb = new JButton(FlyCamInit){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FlyCamInit");	
    jb.setToolTipText("FlyCamInit:"+new FlyCamInit("").getHelpDesc()+"\n\n"+new FlyCamInit("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SKitchen =
        ImageLoader.getImage("images/space/kitchen16.png");
    undoIcon = new ImageIcon(img_SKitchen);
    Action SKitchen=
        new AbstractAction("SKitchen", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SKitchen");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SKitchen.setEnabled(true);
    jb = new JButton(SKitchen){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SKitchen");	
    jb.setToolTipText("SKitchen:"+new SKitchen("").getHelpDesc()+"\n\n"+new SKitchen("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SLivingroom =
        ImageLoader.getImage("images/space/livingroom16.png");
    undoIcon = new ImageIcon(img_SLivingroom);
    Action SLivingroom=
        new AbstractAction("SLivingroom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SLivingroom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SLivingroom.setEnabled(true);
    jb = new JButton(SLivingroom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SLivingroom");	
    jb.setToolTipText("SLivingroom:"+new SLivingroom("").getHelpDesc()+"\n\n"+new SLivingroom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SBedroom =
        ImageLoader.getImage("images/space/bedroom16.png");
    undoIcon = new ImageIcon(img_SBedroom);
    Action SBedroom=
        new AbstractAction("SBedroom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SBedroom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SBedroom.setEnabled(true);
    jb = new JButton(SBedroom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SBedroom");	
    jb.setToolTipText("SBedroom:"+new SBedroom("").getHelpDesc()+"\n\n"+new SBedroom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_FTable =
        ImageLoader.getImage("images/objects/Table16.png");
    undoIcon = new ImageIcon(img_FTable);
    Action FTable=
        new AbstractAction("FTable", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FTable");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FTable.setEnabled(true);
    jb = new JButton(FTable){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FTable");	
    jb.setToolTipText("FTable:"+new FTable("").getHelpDesc()+"\n\n"+new FTable("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_CameraInit =
        ImageLoader.getImage("images/sim/VideoCameraInit16.png");
    undoIcon = new ImageIcon(img_CameraInit);
    Action CameraInit=
        new AbstractAction("CameraInit", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "CameraInit");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    CameraInit.setEnabled(true);
    jb = new JButton(CameraInit){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("CameraInit");	
    jb.setToolTipText("CameraInit:"+new CameraInit("").getHelpDesc()+"\n\n"+new CameraInit("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SCorridor =
        ImageLoader.getImage("images/space/corridor16.png");
    undoIcon = new ImageIcon(img_SCorridor);
    Action SCorridor=
        new AbstractAction("SCorridor", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SCorridor");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SCorridor.setEnabled(true);
    jb = new JButton(SCorridor){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SCorridor");	
    jb.setToolTipText("SCorridor:"+new SCorridor("").getHelpDesc()+"\n\n"+new SCorridor("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SArea =
        ImageLoader.getImage("images/space/area16.png");
    undoIcon = new ImageIcon(img_SArea);
    Action SArea=
        new AbstractAction("SArea", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SArea");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SArea.setEnabled(true);
    jb = new JButton(SArea){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SArea");	
    jb.setToolTipText("SArea:"+new SArea("").getHelpDesc()+"\n\n"+new SArea("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_ESmartPhone =
        ImageLoader.getImage("images/devices/Smartphone16.png");
    undoIcon = new ImageIcon(img_ESmartPhone);
    Action ESmartPhone=
        new AbstractAction("ESmartPhone", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ESmartPhone");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ESmartPhone.setEnabled(true);
    jb = new JButton(ESmartPhone){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ESmartPhone");	
    jb.setToolTipText("ESmartPhone:"+new ESmartPhone("").getHelpDesc()+"\n\n"+new ESmartPhone("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_InitialPreDefPos =
        ImageLoader.getImage("images/sim/PreDefPos16.png");
    undoIcon = new ImageIcon(img_InitialPreDefPos);
    Action InitialPreDefPos=
        new AbstractAction("InitialPreDefPos", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "InitialPreDefPos");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    InitialPreDefPos.setEnabled(true);
    jb = new JButton(InitialPreDefPos){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("InitialPreDefPos");	
    jb.setToolTipText("InitialPreDefPos:"+new InitialPreDefPos("").getHelpDesc()+"\n\n"+new InitialPreDefPos("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_HumanInitialization =
        ImageLoader.getImage("images/sim/HumanInitialization16.png");
    undoIcon = new ImageIcon(img_HumanInitialization);
    Action HumanInitialization=
        new AbstractAction("HumanInitialization", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "HumanInitialization");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    HumanInitialization.setEnabled(true);
    jb = new JButton(HumanInitialization){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("HumanInitialization");	
    jb.setToolTipText("HumanInitialization:"+new HumanInitialization("").getHelpDesc()+"\n\n"+new HumanInitialization("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_DeviceParam =
        ImageLoader.getImage("images/params/DeviceParam16.png");
    undoIcon = new ImageIcon(img_DeviceParam);
    Action DeviceParam=
        new AbstractAction("DeviceParam", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DeviceParam");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DeviceParam.setEnabled(true);
    jb = new JButton(DeviceParam){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DeviceParam");	
    jb.setToolTipText("DeviceParam:"+new DeviceParam("").getHelpDesc()+"\n\n"+new DeviceParam("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_SeatParam =
        ImageLoader.getImage("images/params/SeatParam16.png");
    undoIcon = new ImageIcon(img_SeatParam);
    Action SeatParam=
        new AbstractAction("SeatParam", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SeatParam");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SeatParam.setEnabled(true);
    jb = new JButton(SeatParam){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SeatParam");	
    jb.setToolTipText("SeatParam:"+new SeatParam("").getHelpDesc()+"\n\n"+new SeatParam("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_ObjectParam =
        ImageLoader.getImage("images/params/ObjectParam16.png");
    undoIcon = new ImageIcon(img_ObjectParam);
    Action ObjectParam=
        new AbstractAction("ObjectParam", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ObjectParam");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ObjectParam.setEnabled(true);
    jb = new JButton(ObjectParam){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ObjectParam");	
    jb.setToolTipText("ObjectParam:"+new ObjectParam("").getHelpDesc()+"\n\n"+new ObjectParam("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_HumanParam =
        ImageLoader.getImage("images/params/HumanParam16.png");
    undoIcon = new ImageIcon(img_HumanParam);
    Action HumanParam=
        new AbstractAction("HumanParam", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "HumanParam");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    HumanParam.setEnabled(true);
    jb = new JButton(HumanParam){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("HumanParam");	
    jb.setToolTipText("HumanParam:"+new HumanParam("").getHelpDesc()+"\n\n"+new HumanParam("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_PrimitiveParam =
        ImageLoader.getImage("images/params/PrimitiveParam16.png");
    undoIcon = new ImageIcon(img_PrimitiveParam);
    Action PrimitiveParam=
        new AbstractAction("PrimitiveParam", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PrimitiveParam");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PrimitiveParam.setEnabled(true);
    jb = new JButton(PrimitiveParam){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PrimitiveParam");	
    jb.setToolTipText("PrimitiveParam:"+new PrimitiveParam("").getHelpDesc()+"\n\n"+new PrimitiveParam("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_PlaceParam =
        ImageLoader.getImage("images/params/PlaceParam16.png");
    undoIcon = new ImageIcon(img_PlaceParam);
    Action PlaceParam=
        new AbstractAction("PlaceParam", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PlaceParam");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PlaceParam.setEnabled(true);
    jb = new JButton(PlaceParam){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PlaceParam");	
    jb.setToolTipText("PlaceParam:"+new PlaceParam("").getHelpDesc()+"\n\n"+new PlaceParam("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_WearableParam =
        ImageLoader.getImage("images/params/WearableParam16.png");
    undoIcon = new ImageIcon(img_WearableParam);
    Action WearableParam=
        new AbstractAction("WearableParam", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WearableParam");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WearableParam.setEnabled(true);
    jb = new JButton(WearableParam){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WearableParam");	
    jb.setToolTipText("WearableParam:"+new WearableParam("").getHelpDesc()+"\n\n"+new WearableParam("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_PDSymtom =
        ImageLoader.getImage("images/profiles/DiseaseProfile/Symptom16.png");
    undoIcon = new ImageIcon(img_PDSymtom);
    Action PDSymtom=
        new AbstractAction("PDSymtom", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PDSymtom");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PDSymtom.setEnabled(true);
    jb = new JButton(PDSymtom){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PDSymtom");	
    jb.setToolTipText("PDSymtom:"+new PDSymtom("").getHelpDesc()+"\n\n"+new PDSymtom("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_BActivity =
        ImageLoader.getImage("images/behaviour/activities/Activity16.png");
    undoIcon = new ImageIcon(img_BActivity);
    Action BActivity=
        new AbstractAction("BActivity", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "BActivity");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    BActivity.setEnabled(true);
    jb = new JButton(BActivity){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("BActivity");	
    jb.setToolTipText("BActivity:"+new BActivity("").getHelpDesc()+"\n\n"+new BActivity("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (true){
    Image img_WorldInitialization =
        ImageLoader.getImage("images/sim/WorldInitialization16.png");
    undoIcon = new ImageIcon(img_WorldInitialization);
    Action WorldInitialization=
        new AbstractAction("WorldInitialization", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WorldInitialization");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WorldInitialization.setEnabled(true);
    jb = new JButton(WorldInitialization){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WorldInitialization");	
    jb.setToolTipText("WorldInitialization:"+new WorldInitialization("").getHelpDesc()+"\n\n"+new WorldInitialization("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Crutch =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Crutch);
    Action Crutch=
        new AbstractAction("Crutch", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Crutch");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Crutch.setEnabled(true);
    jb = new JButton(Crutch){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Crutch");	
    jb.setToolTipText("Crutch:"+new Crutch("").getHelpDesc()+"\n\n"+new Crutch("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EMedicine =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EMedicine);
    Action EMedicine=
        new AbstractAction("EMedicine", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EMedicine");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EMedicine.setEnabled(true);
    jb = new JButton(EMedicine){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EMedicine");	
    jb.setToolTipText("EMedicine:"+new EMedicine("").getHelpDesc()+"\n\n"+new EMedicine("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shoes =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shoes);
    Action Shoes=
        new AbstractAction("Shoes", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shoes");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shoes.setEnabled(true);
    jb = new JButton(Shoes){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shoes");	
    jb.setToolTipText("Shoes:"+new Shoes("").getHelpDesc()+"\n\n"+new Shoes("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOWashbasin =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOWashbasin);
    Action FOWashbasin=
        new AbstractAction("FOWashbasin", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOWashbasin");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOWashbasin.setEnabled(true);
    jb = new JButton(FOWashbasin){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOWashbasin");	
    jb.setToolTipText("FOWashbasin:"+new FOWashbasin("").getHelpDesc()+"\n\n"+new FOWashbasin("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOSink =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOSink);
    Action FOSink=
        new AbstractAction("FOSink", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOSink");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOSink.setEnabled(true);
    jb = new JButton(FOSink){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOSink");	
    jb.setToolTipText("FOSink:"+new FOSink("").getHelpDesc()+"\n\n"+new FOSink("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Lift =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Lift);
    Action Lift=
        new AbstractAction("Lift", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Lift");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Lift.setEnabled(true);
    jb = new JButton(Lift){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Lift");	
    jb.setToolTipText("Lift:"+new Lift("").getHelpDesc()+"\n\n"+new Lift("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_WearableVar =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_WearableVar);
    Action WearableVar=
        new AbstractAction("WearableVar", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WearableVar");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WearableVar.setEnabled(true);
    jb = new JButton(WearableVar){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WearableVar");	
    jb.setToolTipText("WearableVar:"+new WearableVar("").getHelpDesc()+"\n\n"+new WearableVar("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shirt =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shirt);
    Action Shirt=
        new AbstractAction("Shirt", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shirt");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shirt.setEnabled(true);
    jb = new JButton(Shirt){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shirt");	
    jb.setToolTipText("Shirt:"+new Shirt("").getHelpDesc()+"\n\n"+new Shirt("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shower =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shower);
    Action Shower=
        new AbstractAction("Shower", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shower");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shower.setEnabled(true);
    jb = new JButton(Shower){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shower");	
    jb.setToolTipText("Shower:"+new Shower("").getHelpDesc()+"\n\n"+new Shower("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FWardrobe =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FWardrobe);
    Action FWardrobe=
        new AbstractAction("FWardrobe", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FWardrobe");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FWardrobe.setEnabled(true);
    jb = new JButton(FWardrobe){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FWardrobe");	
    jb.setToolTipText("FWardrobe:"+new FWardrobe("").getHelpDesc()+"\n\n"+new FWardrobe("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_ERemoteControl =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_ERemoteControl);
    Action ERemoteControl=
        new AbstractAction("ERemoteControl", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ERemoteControl");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ERemoteControl.setEnabled(true);
    jb = new JButton(ERemoteControl){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ERemoteControl");	
    jb.setToolTipText("ERemoteControl:"+new ERemoteControl("").getHelpDesc()+"\n\n"+new ERemoteControl("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_ESleepers =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_ESleepers);
    Action ESleepers=
        new AbstractAction("ESleepers", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ESleepers");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ESleepers.setEnabled(true);
    jb = new JButton(ESleepers){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ESleepers");	
    jb.setToolTipText("ESleepers:"+new ESleepers("").getHelpDesc()+"\n\n"+new ESleepers("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Dishwasher =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Dishwasher);
    Action Dishwasher=
        new AbstractAction("Dishwasher", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Dishwasher");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Dishwasher.setEnabled(true);
    jb = new JButton(Dishwasher){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Dishwasher");	
    jb.setToolTipText("Dishwasher:"+new Dishwasher("").getHelpDesc()+"\n\n"+new Dishwasher("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_WashMachine =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_WashMachine);
    Action WashMachine=
        new AbstractAction("WashMachine", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "WashMachine");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    WashMachine.setEnabled(true);
    jb = new JButton(WashMachine){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("WashMachine");	
    jb.setToolTipText("WashMachine:"+new WashMachine("").getHelpDesc()+"\n\n"+new WashMachine("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EatableItem =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EatableItem);
    Action EatableItem=
        new AbstractAction("EatableItem", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EatableItem");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EatableItem.setEnabled(true);
    jb = new JButton(EatableItem){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EatableItem");	
    jb.setToolTipText("EatableItem:"+new EatableItem("").getHelpDesc()+"\n\n"+new EatableItem("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Walker =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Walker);
    Action Walker=
        new AbstractAction("Walker", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Walker");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Walker.setEnabled(true);
    jb = new JButton(Walker){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Walker");	
    jb.setToolTipText("Walker:"+new Walker("").getHelpDesc()+"\n\n"+new Walker("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Cane =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Cane);
    Action Cane=
        new AbstractAction("Cane", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Cane");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Cane.setEnabled(true);
    jb = new JButton(Cane){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Cane");	
    jb.setToolTipText("Cane:"+new Cane("").getHelpDesc()+"\n\n"+new Cane("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_DComputer =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_DComputer);
    Action DComputer=
        new AbstractAction("DComputer", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DComputer");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DComputer.setEnabled(true);
    jb = new JButton(DComputer){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DComputer");	
    jb.setToolTipText("DComputer:"+new DComputer("").getHelpDesc()+"\n\n"+new DComputer("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_DrinkItem =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_DrinkItem);
    Action DrinkItem=
        new AbstractAction("DrinkItem", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DrinkItem");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DrinkItem.setEnabled(true);
    jb = new JButton(DrinkItem){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DrinkItem");	
    jb.setToolTipText("DrinkItem:"+new DrinkItem("").getHelpDesc()+"\n\n"+new DrinkItem("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOBath =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOBath);
    Action FOBath=
        new AbstractAction("FOBath", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOBath");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOBath.setEnabled(true);
    jb = new JButton(FOBath){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOBath");	
    jb.setToolTipText("FOBath:"+new FOBath("").getHelpDesc()+"\n\n"+new FOBath("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SpatialVar =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SpatialVar);
    Action SpatialVar=
        new AbstractAction("SpatialVar", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SpatialVar");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SpatialVar.setEnabled(true);
    jb = new JButton(SpatialVar){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SpatialVar");	
    jb.setToolTipText("SpatialVar:"+new SpatialVar("").getHelpDesc()+"\n\n"+new SpatialVar("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Shocks =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Shocks);
    Action Shocks=
        new AbstractAction("Shocks", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Shocks");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Shocks.setEnabled(true);
    jb = new JButton(Shocks){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Shocks");	
    jb.setToolTipText("Shocks:"+new Shocks("").getHelpDesc()+"\n\n"+new Shocks("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Bridge =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Bridge);
    Action Bridge=
        new AbstractAction("Bridge", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Bridge");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Bridge.setEnabled(true);
    jb = new JButton(Bridge){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Bridge");	
    jb.setToolTipText("Bridge:"+new Bridge("").getHelpDesc()+"\n\n"+new Bridge("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EMobileDevice =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EMobileDevice);
    Action EMobileDevice=
        new AbstractAction("EMobileDevice", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EMobileDevice");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EMobileDevice.setEnabled(true);
    jb = new JButton(EMobileDevice){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EMobileDevice");	
    jb.setToolTipText("EMobileDevice:"+new EMobileDevice("").getHelpDesc()+"\n\n"+new EMobileDevice("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_HumanVar =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_HumanVar);
    Action HumanVar=
        new AbstractAction("HumanVar", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "HumanVar");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    HumanVar.setEnabled(true);
    jb = new JButton(HumanVar){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("HumanVar");	
    jb.setToolTipText("HumanVar:"+new HumanVar("").getHelpDesc()+"\n\n"+new HumanVar("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_DTV =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_DTV);
    Action DTV=
        new AbstractAction("DTV", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "DTV");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    DTV.setEnabled(true);
    jb = new JButton(DTV){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("DTV");	
    jb.setToolTipText("DTV:"+new DTV("").getHelpDesc()+"\n\n"+new DTV("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_PrimitiveVar =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_PrimitiveVar);
    Action PrimitiveVar=
        new AbstractAction("PrimitiveVar", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "PrimitiveVar");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    PrimitiveVar.setEnabled(true);
    jb = new JButton(PrimitiveVar){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("PrimitiveVar");	
    jb.setToolTipText("PrimitiveVar:"+new PrimitiveVar("").getHelpDesc()+"\n\n"+new PrimitiveVar("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SeatVar =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SeatVar);
    Action SeatVar=
        new AbstractAction("SeatVar", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SeatVar");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SeatVar.setEnabled(true);
    jb = new JButton(SeatVar){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SeatVar");	
    jb.setToolTipText("SeatVar:"+new SeatVar("").getHelpDesc()+"\n\n"+new SeatVar("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FChair =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FChair);
    Action FChair=
        new AbstractAction("FChair", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FChair");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FChair.setEnabled(true);
    jb = new JButton(FChair){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FChair");	
    jb.setToolTipText("FChair:"+new FChair("").getHelpDesc()+"\n\n"+new FChair("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Pyjamas =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Pyjamas);
    Action Pyjamas=
        new AbstractAction("Pyjamas", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Pyjamas");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Pyjamas.setEnabled(true);
    jb = new JButton(Pyjamas){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Pyjamas");	
    jb.setToolTipText("Pyjamas:"+new Pyjamas("").getHelpDesc()+"\n\n"+new Pyjamas("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Staircase =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Staircase);
    Action Staircase=
        new AbstractAction("Staircase", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Staircase");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Staircase.setEnabled(true);
    jb = new JButton(Staircase){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Staircase");	
    jb.setToolTipText("Staircase:"+new Staircase("").getHelpDesc()+"\n\n"+new Staircase("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Doorbell =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Doorbell);
    Action Doorbell=
        new AbstractAction("Doorbell", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Doorbell");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Doorbell.setEnabled(true);
    jb = new JButton(Doorbell){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Doorbell");	
    jb.setToolTipText("Doorbell:"+new Doorbell("").getHelpDesc()+"\n\n"+new Doorbell("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Appliance =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Appliance);
    Action Appliance=
        new AbstractAction("Appliance", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Appliance");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Appliance.setEnabled(true);
    jb = new JButton(Appliance){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Appliance");	
    jb.setToolTipText("Appliance:"+new Appliance("").getHelpDesc()+"\n\n"+new Appliance("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SFloor =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SFloor);
    Action SFloor=
        new AbstractAction("SFloor", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SFloor");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SFloor.setEnabled(true);
    jb = new JButton(SFloor){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SFloor");	
    jb.setToolTipText("SFloor:"+new SFloor("").getHelpDesc()+"\n\n"+new SFloor("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Extractor =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Extractor);
    Action Extractor=
        new AbstractAction("Extractor", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Extractor");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Extractor.setEnabled(true);
    jb = new JButton(Extractor){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Extractor");	
    jb.setToolTipText("Extractor:"+new Extractor("").getHelpDesc()+"\n\n"+new Extractor("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_ObjectVar =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_ObjectVar);
    Action ObjectVar=
        new AbstractAction("ObjectVar", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "ObjectVar");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    ObjectVar.setEnabled(true);
    jb = new JButton(ObjectVar){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("ObjectVar");	
    jb.setToolTipText("ObjectVar:"+new ObjectVar("").getHelpDesc()+"\n\n"+new ObjectVar("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_SBuilding =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_SBuilding);
    Action SBuilding=
        new AbstractAction("SBuilding", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "SBuilding");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    SBuilding.setEnabled(true);
    jb = new JButton(SBuilding){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("SBuilding");	
    jb.setToolTipText("SBuilding:"+new SBuilding("").getHelpDesc()+"\n\n"+new SBuilding("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_Trousers =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_Trousers);
    Action Trousers=
        new AbstractAction("Trousers", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "Trousers");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    Trousers.setEnabled(true);
    jb = new JButton(Trousers){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("Trousers");	
    jb.setToolTipText("Trousers:"+new Trousers("").getHelpDesc()+"\n\n"+new Trousers("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FOWater =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FOWater);
    Action FOWater=
        new AbstractAction("FOWater", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FOWater");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FOWater.setEnabled(true);
    jb = new JButton(FOWater){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FOWater");	
    jb.setToolTipText("FOWater:"+new FOWater("").getHelpDesc()+"\n\n"+new FOWater("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_EWaterBottle =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_EWaterBottle);
    Action EWaterBottle=
        new AbstractAction("EWaterBottle", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "EWaterBottle");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    EWaterBottle.setEnabled(true);
    jb = new JButton(EWaterBottle){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("EWaterBottle");	
    jb.setToolTipText("EWaterBottle:"+new EWaterBottle("").getHelpDesc()+"\n\n"+new EWaterBottle("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FBed =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FBed);
    Action FBed=
        new AbstractAction("FBed", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FBed");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FBed.setEnabled(true);
    jb = new JButton(FBed){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FBed");	
    jb.setToolTipText("FBed:"+new FBed("").getHelpDesc()+"\n\n"+new FBed("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

   if (false){
    Image img_FSofa =
        ImageLoader.getImage("");
    undoIcon = new ImageIcon(img_FSofa);
    Action FSofa=
        new AbstractAction("FSofa", undoIcon) {
      public void actionPerformed(ActionEvent e) {
       try{
        insert(new Point(getVisibleRect().x,getVisibleRect().y), "FSofa");
	} catch (InvalidEntity e1) {			
		e1.printStackTrace();
	}
      }
    };
    FSofa.setEnabled(true);
    jb = new JButton(FSofa){
					@Override
					public JToolTip createToolTip() {
						return new ingenias.editor.editiondialog.JMultiLineToolTip();
					}
				};
    jb.setText("");
    jb.setName("FSofa");	
    jb.setToolTipText("FSofa:"+new FSofa("").getHelpDesc()+"\n\n"+new FSofa("").getHelpRecom());
    jb.addMouseListener(new MouseAdapter() {
				    final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
				    final int dismissDelayMinutes = (int) TimeUnit.MINUTES.toMillis(10); // 10 minutes
				    @Override
				    public void mouseEntered(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(dismissDelayMinutes);
				    }
				 
				    @Override
				    public void mouseExited(MouseEvent me) {
				        ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
				    }
				});
    toolbar.add(jb);
    }

    }

  }

  public Vector<String> getAllowedRelationships(){
   Vector<String> relationships=new   Vector<String>();


          relationships.add("EmulatorPeer");

          relationships.add("ParamsSet");

          relationships.add("RunAndroidApp");

          relationships.add("InitialDeviceLocation");

          relationships.add("ProducesEvent");

          relationships.add("cond");

          relationships.add("ProfileOf");

          relationships.add("TIStartTime");

          relationships.add("med");

          relationships.add("socialRelations");

          relationships.add("WorkAs");

          relationships.add("LiveIn");

          relationships.add("RelatedEvent");

          relationships.add("ActivityAttached");

          relationships.add("ConditionNeeded");

          relationships.add("Connects");

          relationships.add("SBhasFloor");

          relationships.add("tool");

          relationships.add("FPrecondition");

          relationships.add("AllowedTask");

          relationships.add("relatedCondition");

          relationships.add("aeinv_op");

          relationships.add("aemd_op2");

          relationships.add("aeas_op2");

          relationships.add("aeas_op1");

          relationships.add("aemd_op1");

          relationships.add("RelatedHuman");

          relationships.add("InitialLocation");

          relationships.add("InitialActivity");

          relationships.add("InitialDate");

          relationships.add("device");

          relationships.add("CameraFaceToHuman");

          relationships.add("InitializedSymptom");

          relationships.add("InitializesSymptom");

          relationships.add("Role");

          relationships.add("DeonticAssignement");

          relationships.add("ActionResponsible");

          relationships.add("ActionHappeningAfterwards");

          relationships.add("AffectedAction");

          relationships.add("goToBodySpeedVar");

          relationships.add("leaveObjVar");

          relationships.add("closeObjVar");

          relationships.add("pickUpObjVar");

          relationships.add("waitForHumanVar");

          relationships.add("durationVar");

          relationships.add("goToSpeedVar");

          relationships.add("messageVar");

          relationships.add("tapXVar");

          relationships.add("sitDownOnSeatVar");

          relationships.add("putOnWearableVar");

          relationships.add("goToPlaceVar");

          relationships.add("tapDeviceVar");

          relationships.add("openObjVar");

          relationships.add("animVar");

          relationships.add("useObjVar");

          relationships.add("goToBodyVar");

          relationships.add("leaveObjDestinyVar");

          relationships.add("tapYVar");

          relationships.add("switchRoomVar");

          relationships.add("putOffWearableVar");

          relationships.add("dropObjVar");

   return relationships;
  }

  public  Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("PartOfBody");

 entities.add("InitProgramPool");

 entities.add("SymptomInitialization");

 entities.add("AndroidApplication");

 entities.add("SDate");

 entities.add("AndroidEmulator");

 entities.add("SBathroom");

 entities.add("Human");

 entities.add("FlyCamInit");

 entities.add("SKitchen");

 entities.add("SLivingroom");

 entities.add("SBedroom");

 entities.add("FTable");

 entities.add("CameraInit");

 entities.add("SCorridor");

 entities.add("SArea");

 entities.add("ESmartPhone");

 entities.add("InitialPreDefPos");

 entities.add("HumanInitialization");

 entities.add("DeviceParam");

 entities.add("SeatParam");

 entities.add("ObjectParam");

 entities.add("HumanParam");

 entities.add("PrimitiveParam");

 entities.add("PlaceParam");

 entities.add("WearableParam");

 entities.add("PDSymtom");

 entities.add("BActivity");

 entities.add("WorldInitialization");

 entities.add("Crutch");

 entities.add("EMedicine");

 entities.add("Shoes");

 entities.add("FOWashbasin");

 entities.add("FOSink");

 entities.add("Lift");

 entities.add("WearableVar");

 entities.add("Shirt");

 entities.add("Shower");

 entities.add("FWardrobe");

 entities.add("ERemoteControl");

 entities.add("ESleepers");

 entities.add("Dishwasher");

 entities.add("WashMachine");

 entities.add("EatableItem");

 entities.add("Walker");

 entities.add("Cane");

 entities.add("DComputer");

 entities.add("DrinkItem");

 entities.add("FOBath");

 entities.add("SpatialVar");

 entities.add("Shocks");

 entities.add("Bridge");

 entities.add("EMobileDevice");

 entities.add("HumanVar");

 entities.add("DTV");

 entities.add("PrimitiveVar");

 entities.add("SeatVar");

 entities.add("FChair");

 entities.add("Pyjamas");

 entities.add("Staircase");

 entities.add("Doorbell");

 entities.add("Appliance");

 entities.add("SFloor");

 entities.add("Extractor");

 entities.add("ObjectVar");

 entities.add("SBuilding");

 entities.add("Trousers");

 entities.add("FOWater");

 entities.add("EWaterBottle");

 entities.add("FBed");

 entities.add("FSofa");

   return entities;
  }

  // Gets the name of the possible relationships for the selected GraphCells.
  // A relationship can be binary (DefaultEdge) or n-ary (NAryEdge).
  // The requested action is slightly different depending on selected items.
  // According to the number of Edges in selected, the action can be:
  // 0 => Propose a relationship between selected according included classes.
  // 1 and it is NAryEdge => The class of that NAryEdge if it is possible according implements java.io.Serializable
  //      current cardinality and included classes..
  // other cases => Error, no relationships are allowed.
  public Object[] getPossibleRelationships(GraphCell[] selected) {
    // Possible relationships initialization.
    Vector v = new Vector();

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

        // Connections are only possible with two or more elements and without binary edges.
      }
    }
    if (selected.length >= 2 && edgesNum == 0) {

      // The number of NAryEdges is considered.
      if (nAryEdgesNum == 0) {
        // acceptConnection methods only admits vertex parameters.
        // Binary relationships.

        // N-ary relationships. Sometimes they can be also binary.
        if (EmulatorPeerEdge.acceptConnection(this.getModel(), selected)) {
          v.add("EmulatorPeer");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ParamsSetEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ParamsSet");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RunAndroidAppEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RunAndroidApp");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialDeviceLocationEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialDeviceLocation");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ProducesEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProducesEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (condEdge.acceptConnection(this.getModel(), selected)) {
          v.add("cond");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ProfileOfEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ProfileOf");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (TIStartTimeEdge.acceptConnection(this.getModel(), selected)) {
          v.add("TIStartTime");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (medEdge.acceptConnection(this.getModel(), selected)) {
          v.add("med");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (socialRelationsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("socialRelations");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (WorkAsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("WorkAs");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (LiveInEdge.acceptConnection(this.getModel(), selected)) {
          v.add("LiveIn");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedEventEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedEvent");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActivityAttachedEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActivityAttached");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConditionNeededEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ConditionNeeded");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ConnectsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Connects");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (SBhasFloorEdge.acceptConnection(this.getModel(), selected)) {
          v.add("SBhasFloor");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (toolEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tool");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (FPreconditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("FPrecondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AllowedTaskEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AllowedTask");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (relatedConditionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("relatedCondition");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeinv_opEdge.acceptConnection(this.getModel(), selected)) {
          v.add("aeinv_op");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op2Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op2");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aeas_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aeas_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (aemd_op1Edge.acceptConnection(this.getModel(), selected)) {
          v.add("aemd_op1");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RelatedHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("RelatedHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialLocationEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialLocation");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialActivityEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialActivity");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitialDateEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitialDate");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (deviceEdge.acceptConnection(this.getModel(), selected)) {
          v.add("device");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected)) {
          v.add("CameraFaceToHuman");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializedSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializedSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (InitializesSymptomEdge.acceptConnection(this.getModel(), selected)) {
          v.add("InitializesSymptom");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (RoleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("Role");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (DeonticAssignementEdge.acceptConnection(this.getModel(), selected)) {
          v.add("DeonticAssignement");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionResponsibleEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionResponsible");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected)) {
          v.add("ActionHappeningAfterwards");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (AffectedActionEdge.acceptConnection(this.getModel(), selected)) {
          v.add("AffectedAction");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodySpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (closeObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("closeObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (pickUpObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("pickUpObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (waitForHumanVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("waitForHumanVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (durationVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("durationVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToSpeedVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToSpeedVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (messageVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("messageVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapXVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapXVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("sitDownOnSeatVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOnWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOnWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToPlaceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToPlaceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapDeviceVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapDeviceVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (openObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("openObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (animVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("animVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (useObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("useObjVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (goToBodyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("goToBodyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("leaveObjDestinyVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (tapYVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("tapYVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (switchRoomVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("switchRoomVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (putOffWearableVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("putOffWearableVar");
	  }

        // N-ary relationships. Sometimes they can be also binary.
        if (dropObjVarEdge.acceptConnection(this.getModel(), selected)) {
          v.add("dropObjVar");
	  }

      }
      else if (nAryEdgesNum == 1) {

        if (selectedEdge instanceof EmulatorPeerEdge &&
        (EmulatorPeerEdge.acceptConnection(this.getModel(), selected))) {
          v.add("EmulatorPeer");
        }

        if (selectedEdge instanceof ParamsSetEdge &&
        (ParamsSetEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ParamsSet");
        }

        if (selectedEdge instanceof RunAndroidAppEdge &&
        (RunAndroidAppEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RunAndroidApp");
        }

        if (selectedEdge instanceof InitialDeviceLocationEdge &&
        (InitialDeviceLocationEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialDeviceLocation");
        }

        if (selectedEdge instanceof ProducesEventEdge &&
        (ProducesEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProducesEvent");
        }

        if (selectedEdge instanceof condEdge &&
        (condEdge.acceptConnection(this.getModel(), selected))) {
          v.add("cond");
        }

        if (selectedEdge instanceof ProfileOfEdge &&
        (ProfileOfEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ProfileOf");
        }

        if (selectedEdge instanceof TIStartTimeEdge &&
        (TIStartTimeEdge.acceptConnection(this.getModel(), selected))) {
          v.add("TIStartTime");
        }

        if (selectedEdge instanceof medEdge &&
        (medEdge.acceptConnection(this.getModel(), selected))) {
          v.add("med");
        }

        if (selectedEdge instanceof socialRelationsEdge &&
        (socialRelationsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("socialRelations");
        }

        if (selectedEdge instanceof WorkAsEdge &&
        (WorkAsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("WorkAs");
        }

        if (selectedEdge instanceof LiveInEdge &&
        (LiveInEdge.acceptConnection(this.getModel(), selected))) {
          v.add("LiveIn");
        }

        if (selectedEdge instanceof RelatedEventEdge &&
        (RelatedEventEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedEvent");
        }

        if (selectedEdge instanceof ActivityAttachedEdge &&
        (ActivityAttachedEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActivityAttached");
        }

        if (selectedEdge instanceof ConditionNeededEdge &&
        (ConditionNeededEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ConditionNeeded");
        }

        if (selectedEdge instanceof ConnectsEdge &&
        (ConnectsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Connects");
        }

        if (selectedEdge instanceof SBhasFloorEdge &&
        (SBhasFloorEdge.acceptConnection(this.getModel(), selected))) {
          v.add("SBhasFloor");
        }

        if (selectedEdge instanceof toolEdge &&
        (toolEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tool");
        }

        if (selectedEdge instanceof FPreconditionEdge &&
        (FPreconditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("FPrecondition");
        }

        if (selectedEdge instanceof AllowedTaskEdge &&
        (AllowedTaskEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AllowedTask");
        }

        if (selectedEdge instanceof relatedConditionEdge &&
        (relatedConditionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("relatedCondition");
        }

        if (selectedEdge instanceof aeinv_opEdge &&
        (aeinv_opEdge.acceptConnection(this.getModel(), selected))) {
          v.add("aeinv_op");
        }

        if (selectedEdge instanceof aemd_op2Edge &&
        (aemd_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op2");
        }

        if (selectedEdge instanceof aeas_op2Edge &&
        (aeas_op2Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op2");
        }

        if (selectedEdge instanceof aeas_op1Edge &&
        (aeas_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aeas_op1");
        }

        if (selectedEdge instanceof aemd_op1Edge &&
        (aemd_op1Edge.acceptConnection(this.getModel(), selected))) {
          v.add("aemd_op1");
        }

        if (selectedEdge instanceof RelatedHumanEdge &&
        (RelatedHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("RelatedHuman");
        }

        if (selectedEdge instanceof InitialLocationEdge &&
        (InitialLocationEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialLocation");
        }

        if (selectedEdge instanceof InitialActivityEdge &&
        (InitialActivityEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialActivity");
        }

        if (selectedEdge instanceof InitialDateEdge &&
        (InitialDateEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitialDate");
        }

        if (selectedEdge instanceof deviceEdge &&
        (deviceEdge.acceptConnection(this.getModel(), selected))) {
          v.add("device");
        }

        if (selectedEdge instanceof CameraFaceToHumanEdge &&
        (CameraFaceToHumanEdge.acceptConnection(this.getModel(), selected))) {
          v.add("CameraFaceToHuman");
        }

        if (selectedEdge instanceof InitializedSymptomEdge &&
        (InitializedSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializedSymptom");
        }

        if (selectedEdge instanceof InitializesSymptomEdge &&
        (InitializesSymptomEdge.acceptConnection(this.getModel(), selected))) {
          v.add("InitializesSymptom");
        }

        if (selectedEdge instanceof RoleEdge &&
        (RoleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("Role");
        }

        if (selectedEdge instanceof DeonticAssignementEdge &&
        (DeonticAssignementEdge.acceptConnection(this.getModel(), selected))) {
          v.add("DeonticAssignement");
        }

        if (selectedEdge instanceof ActionResponsibleEdge &&
        (ActionResponsibleEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionResponsible");
        }

        if (selectedEdge instanceof ActionHappeningAfterwardsEdge &&
        (ActionHappeningAfterwardsEdge.acceptConnection(this.getModel(), selected))) {
          v.add("ActionHappeningAfterwards");
        }

        if (selectedEdge instanceof AffectedActionEdge &&
        (AffectedActionEdge.acceptConnection(this.getModel(), selected))) {
          v.add("AffectedAction");
        }

        if (selectedEdge instanceof goToBodySpeedVarEdge &&
        (goToBodySpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodySpeedVar");
        }

        if (selectedEdge instanceof leaveObjVarEdge &&
        (leaveObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjVar");
        }

        if (selectedEdge instanceof closeObjVarEdge &&
        (closeObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("closeObjVar");
        }

        if (selectedEdge instanceof pickUpObjVarEdge &&
        (pickUpObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("pickUpObjVar");
        }

        if (selectedEdge instanceof waitForHumanVarEdge &&
        (waitForHumanVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("waitForHumanVar");
        }

        if (selectedEdge instanceof durationVarEdge &&
        (durationVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("durationVar");
        }

        if (selectedEdge instanceof goToSpeedVarEdge &&
        (goToSpeedVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToSpeedVar");
        }

        if (selectedEdge instanceof messageVarEdge &&
        (messageVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("messageVar");
        }

        if (selectedEdge instanceof tapXVarEdge &&
        (tapXVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapXVar");
        }

        if (selectedEdge instanceof sitDownOnSeatVarEdge &&
        (sitDownOnSeatVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("sitDownOnSeatVar");
        }

        if (selectedEdge instanceof putOnWearableVarEdge &&
        (putOnWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOnWearableVar");
        }

        if (selectedEdge instanceof goToPlaceVarEdge &&
        (goToPlaceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToPlaceVar");
        }

        if (selectedEdge instanceof tapDeviceVarEdge &&
        (tapDeviceVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapDeviceVar");
        }

        if (selectedEdge instanceof openObjVarEdge &&
        (openObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("openObjVar");
        }

        if (selectedEdge instanceof animVarEdge &&
        (animVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("animVar");
        }

        if (selectedEdge instanceof useObjVarEdge &&
        (useObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("useObjVar");
        }

        if (selectedEdge instanceof goToBodyVarEdge &&
        (goToBodyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("goToBodyVar");
        }

        if (selectedEdge instanceof leaveObjDestinyVarEdge &&
        (leaveObjDestinyVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("leaveObjDestinyVar");
        }

        if (selectedEdge instanceof tapYVarEdge &&
        (tapYVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("tapYVar");
        }

        if (selectedEdge instanceof switchRoomVarEdge &&
        (switchRoomVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("switchRoomVar");
        }

        if (selectedEdge instanceof putOffWearableVarEdge &&
        (putOffWearableVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("putOffWearableVar");
        }

        if (selectedEdge instanceof dropObjVarEdge &&
        (dropObjVarEdge.acceptConnection(this.getModel(), selected))) {
          v.add("dropObjVar");
        }

      }
    }

    return v.toArray();
  }

  public DefaultGraphCell getInstanciaNRelacion(String relacion,
                                                GraphCell[] selected) {

    // Search for NAryEdges in selected.
    int nAryEdgesNum = 0;
    int edgesNum = 0;
    NAryEdge selectedEdge = null;
    for (int i = 0; i < selected.length; i++) {
      if (selected[i] instanceof NAryEdge) {
        nAryEdgesNum++;
        selectedEdge = (NAryEdge) selected[i];
      }
      else if (selected[i] instanceof DefaultEdge) {
        edgesNum++;

      }
    }
    if (nAryEdgesNum <= 1 && edgesNum == 0) {

      if (relacion.equalsIgnoreCase("EmulatorPeer")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof EmulatorPeerEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new EmulatorPeerEdge(new ingenias.editor.entities.EmulatorPeer(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ParamsSet")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ParamsSetEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ParamsSetEdge(new ingenias.editor.entities.ParamsSet(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RunAndroidApp")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RunAndroidAppEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RunAndroidAppEdge(new ingenias.editor.entities.RunAndroidApp(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialDeviceLocation")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialDeviceLocationEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialDeviceLocationEdge(new ingenias.editor.entities.InitialDeviceLocation(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ProducesEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProducesEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProducesEventEdge(new ingenias.editor.entities.ProducesEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("cond")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof condEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new condEdge(new ingenias.editor.entities.cond(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ProfileOf")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ProfileOfEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ProfileOfEdge(new ingenias.editor.entities.ProfileOf(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("TIStartTime")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof TIStartTimeEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new TIStartTimeEdge(new ingenias.editor.entities.TIStartTime(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("med")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof medEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new medEdge(new ingenias.editor.entities.med(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("socialRelations")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof socialRelationsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new socialRelationsEdge(new ingenias.editor.entities.socialRelations(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("WorkAs")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof WorkAsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new WorkAsEdge(new ingenias.editor.entities.WorkAs(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("LiveIn")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof LiveInEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new LiveInEdge(new ingenias.editor.entities.LiveIn(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedEvent")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedEventEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedEventEdge(new ingenias.editor.entities.RelatedEvent(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActivityAttached")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActivityAttachedEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActivityAttachedEdge(new ingenias.editor.entities.ActivityAttached(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ConditionNeeded")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConditionNeededEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConditionNeededEdge(new ingenias.editor.entities.ConditionNeeded(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Connects")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ConnectsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ConnectsEdge(new ingenias.editor.entities.Connects(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("SBhasFloor")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof SBhasFloorEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new SBhasFloorEdge(new ingenias.editor.entities.SBhasFloor(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tool")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof toolEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new toolEdge(new ingenias.editor.entities.tool(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("FPrecondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof FPreconditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new FPreconditionEdge(new ingenias.editor.entities.FPrecondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AllowedTask")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AllowedTaskEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AllowedTaskEdge(new ingenias.editor.entities.AllowedTask(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("relatedCondition")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof relatedConditionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new relatedConditionEdge(new ingenias.editor.entities.relatedCondition(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeinv_op")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeinv_opEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeinv_opEdge(new ingenias.editor.entities.aeinv_op(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op2Edge(new ingenias.editor.entities.aemd_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op2")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op2Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op2Edge(new ingenias.editor.entities.aeas_op2(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aeas_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aeas_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aeas_op1Edge(new ingenias.editor.entities.aeas_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("aemd_op1")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof aemd_op1Edge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new aemd_op1Edge(new ingenias.editor.entities.aemd_op1(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("RelatedHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RelatedHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RelatedHumanEdge(new ingenias.editor.entities.RelatedHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialLocation")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialLocationEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialLocationEdge(new ingenias.editor.entities.InitialLocation(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialActivity")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialActivityEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialActivityEdge(new ingenias.editor.entities.InitialActivity(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitialDate")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitialDateEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitialDateEdge(new ingenias.editor.entities.InitialDate(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("device")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof deviceEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new deviceEdge(new ingenias.editor.entities.device(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("CameraFaceToHuman")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof CameraFaceToHumanEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new CameraFaceToHumanEdge(new ingenias.editor.entities.CameraFaceToHuman(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializedSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializedSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializedSymptomEdge(new ingenias.editor.entities.InitializedSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("InitializesSymptom")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof InitializesSymptomEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new InitializesSymptomEdge(new ingenias.editor.entities.InitializesSymptom(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("Role")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof RoleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new RoleEdge(new ingenias.editor.entities.Role(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("DeonticAssignement")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof DeonticAssignementEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new DeonticAssignementEdge(new ingenias.editor.entities.DeonticAssignement(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionResponsible")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionResponsibleEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionResponsibleEdge(new ingenias.editor.entities.ActionResponsible(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("ActionHappeningAfterwards")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof ActionHappeningAfterwardsEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new ActionHappeningAfterwardsEdge(new ingenias.editor.entities.ActionHappeningAfterwards(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("AffectedAction")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof AffectedActionEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new AffectedActionEdge(new ingenias.editor.entities.AffectedAction(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodySpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodySpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodySpeedVarEdge(new ingenias.editor.entities.goToBodySpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjVarEdge(new ingenias.editor.entities.leaveObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("closeObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof closeObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new closeObjVarEdge(new ingenias.editor.entities.closeObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("pickUpObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof pickUpObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new pickUpObjVarEdge(new ingenias.editor.entities.pickUpObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("waitForHumanVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof waitForHumanVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new waitForHumanVarEdge(new ingenias.editor.entities.waitForHumanVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("durationVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof durationVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new durationVarEdge(new ingenias.editor.entities.durationVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToSpeedVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToSpeedVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToSpeedVarEdge(new ingenias.editor.entities.goToSpeedVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("messageVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof messageVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new messageVarEdge(new ingenias.editor.entities.messageVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapXVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapXVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapXVarEdge(new ingenias.editor.entities.tapXVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("sitDownOnSeatVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof sitDownOnSeatVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new sitDownOnSeatVarEdge(new ingenias.editor.entities.sitDownOnSeatVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOnWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOnWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOnWearableVarEdge(new ingenias.editor.entities.putOnWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToPlaceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToPlaceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToPlaceVarEdge(new ingenias.editor.entities.goToPlaceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapDeviceVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapDeviceVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapDeviceVarEdge(new ingenias.editor.entities.tapDeviceVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("openObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof openObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new openObjVarEdge(new ingenias.editor.entities.openObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("animVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof animVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new animVarEdge(new ingenias.editor.entities.animVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("useObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof useObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new useObjVarEdge(new ingenias.editor.entities.useObjVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("goToBodyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof goToBodyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new goToBodyVarEdge(new ingenias.editor.entities.goToBodyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("leaveObjDestinyVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof leaveObjDestinyVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new leaveObjDestinyVarEdge(new ingenias.editor.entities.leaveObjDestinyVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("tapYVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof tapYVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new tapYVarEdge(new ingenias.editor.entities.tapYVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("switchRoomVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof switchRoomVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new switchRoomVarEdge(new ingenias.editor.entities.switchRoomVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("putOffWearableVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof putOffWearableVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new putOffWearableVarEdge(new ingenias.editor.entities.putOffWearableVar(getMJGraph().getNewId()));
        }
      }

      if (relacion.equalsIgnoreCase("dropObjVar")) {
        // ResponsibleNEdge already exists.
        if (nAryEdgesNum == 1 && selectedEdge instanceof dropObjVarEdge) {
          return selectedEdge;
        }
        // There is no NAryEdges in selected.
        else if (nAryEdgesNum == 0) {
          return new dropObjVarEdge(new ingenias.editor.entities.dropObjVar(getMJGraph().getNewId()));
        }
      }

    }

    return null;
  }
  
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("PartOfBody")) {
    PartOfBody nentity=getOM().createPartOfBody(getMJGraph().getNewId("PartOfBody"));
      DefaultGraphCell vertex = new
          PartOfBodyCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("InitProgramPool")) {
    InitProgramPool nentity=getOM().createInitProgramPool(getMJGraph().getNewId("InitProgramPool"));
      DefaultGraphCell vertex = new
          InitProgramPoolCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SymptomInitialization")) {
    SymptomInitialization nentity=getOM().createSymptomInitialization(getMJGraph().getNewId("SymptomInitialization"));
      DefaultGraphCell vertex = new
          SymptomInitializationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AndroidApplication")) {
    AndroidApplication nentity=getOM().createAndroidApplication(getMJGraph().getNewId("AndroidApplication"));
      DefaultGraphCell vertex = new
          AndroidApplicationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SDate")) {
    SDate nentity=getOM().createSDate(getMJGraph().getNewId("SDate"));
      DefaultGraphCell vertex = new
          SDateCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AndroidEmulator")) {
    AndroidEmulator nentity=getOM().createAndroidEmulator(getMJGraph().getNewId("AndroidEmulator"));
      DefaultGraphCell vertex = new
          AndroidEmulatorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBathroom")) {
    SBathroom nentity=getOM().createSBathroom(getMJGraph().getNewId("SBathroom"));
      DefaultGraphCell vertex = new
          SBathroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=getOM().createHuman(getMJGraph().getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FlyCamInit")) {
    FlyCamInit nentity=getOM().createFlyCamInit(getMJGraph().getNewId("FlyCamInit"));
      DefaultGraphCell vertex = new
          FlyCamInitCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SKitchen")) {
    SKitchen nentity=getOM().createSKitchen(getMJGraph().getNewId("SKitchen"));
      DefaultGraphCell vertex = new
          SKitchenCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SLivingroom")) {
    SLivingroom nentity=getOM().createSLivingroom(getMJGraph().getNewId("SLivingroom"));
      DefaultGraphCell vertex = new
          SLivingroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBedroom")) {
    SBedroom nentity=getOM().createSBedroom(getMJGraph().getNewId("SBedroom"));
      DefaultGraphCell vertex = new
          SBedroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FTable")) {
    FTable nentity=getOM().createFTable(getMJGraph().getNewId("FTable"));
      DefaultGraphCell vertex = new
          FTableCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CameraInit")) {
    CameraInit nentity=getOM().createCameraInit(getMJGraph().getNewId("CameraInit"));
      DefaultGraphCell vertex = new
          CameraInitCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SCorridor")) {
    SCorridor nentity=getOM().createSCorridor(getMJGraph().getNewId("SCorridor"));
      DefaultGraphCell vertex = new
          SCorridorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SArea")) {
    SArea nentity=getOM().createSArea(getMJGraph().getNewId("SArea"));
      DefaultGraphCell vertex = new
          SAreaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESmartPhone")) {
    ESmartPhone nentity=getOM().createESmartPhone(getMJGraph().getNewId("ESmartPhone"));
      DefaultGraphCell vertex = new
          ESmartPhoneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("InitialPreDefPos")) {
    InitialPreDefPos nentity=getOM().createInitialPreDefPos(getMJGraph().getNewId("InitialPreDefPos"));
      DefaultGraphCell vertex = new
          InitialPreDefPosCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanInitialization")) {
    HumanInitialization nentity=getOM().createHumanInitialization(getMJGraph().getNewId("HumanInitialization"));
      DefaultGraphCell vertex = new
          HumanInitializationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DeviceParam")) {
    DeviceParam nentity=getOM().createDeviceParam(getMJGraph().getNewId("DeviceParam"));
      DefaultGraphCell vertex = new
          DeviceParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SeatParam")) {
    SeatParam nentity=getOM().createSeatParam(getMJGraph().getNewId("SeatParam"));
      DefaultGraphCell vertex = new
          SeatParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ObjectParam")) {
    ObjectParam nentity=getOM().createObjectParam(getMJGraph().getNewId("ObjectParam"));
      DefaultGraphCell vertex = new
          ObjectParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanParam")) {
    HumanParam nentity=getOM().createHumanParam(getMJGraph().getNewId("HumanParam"));
      DefaultGraphCell vertex = new
          HumanParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PrimitiveParam")) {
    PrimitiveParam nentity=getOM().createPrimitiveParam(getMJGraph().getNewId("PrimitiveParam"));
      DefaultGraphCell vertex = new
          PrimitiveParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PlaceParam")) {
    PlaceParam nentity=getOM().createPlaceParam(getMJGraph().getNewId("PlaceParam"));
      DefaultGraphCell vertex = new
          PlaceParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WearableParam")) {
    WearableParam nentity=getOM().createWearableParam(getMJGraph().getNewId("WearableParam"));
      DefaultGraphCell vertex = new
          WearableParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PDSymtom")) {
    PDSymtom nentity=getOM().createPDSymtom(getMJGraph().getNewId("PDSymtom"));
      DefaultGraphCell vertex = new
          PDSymtomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BActivity")) {
    BActivity nentity=getOM().createBActivity(getMJGraph().getNewId("BActivity"));
      DefaultGraphCell vertex = new
          BActivityCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WorldInitialization")) {
    WorldInitialization nentity=getOM().createWorldInitialization(getMJGraph().getNewId("WorldInitialization"));
      DefaultGraphCell vertex = new
          WorldInitializationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Crutch")) {
    Crutch nentity=getOM().createCrutch(getMJGraph().getNewId("Crutch"));
      DefaultGraphCell vertex = new
          CrutchCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMedicine")) {
    EMedicine nentity=getOM().createEMedicine(getMJGraph().getNewId("EMedicine"));
      DefaultGraphCell vertex = new
          EMedicineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shoes")) {
    Shoes nentity=getOM().createShoes(getMJGraph().getNewId("Shoes"));
      DefaultGraphCell vertex = new
          ShoesCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWashbasin")) {
    FOWashbasin nentity=getOM().createFOWashbasin(getMJGraph().getNewId("FOWashbasin"));
      DefaultGraphCell vertex = new
          FOWashbasinCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOSink")) {
    FOSink nentity=getOM().createFOSink(getMJGraph().getNewId("FOSink"));
      DefaultGraphCell vertex = new
          FOSinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Lift")) {
    Lift nentity=getOM().createLift(getMJGraph().getNewId("Lift"));
      DefaultGraphCell vertex = new
          LiftCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WearableVar")) {
    WearableVar nentity=getOM().createWearableVar(getMJGraph().getNewId("WearableVar"));
      DefaultGraphCell vertex = new
          WearableVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shirt")) {
    Shirt nentity=getOM().createShirt(getMJGraph().getNewId("Shirt"));
      DefaultGraphCell vertex = new
          ShirtCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shower")) {
    Shower nentity=getOM().createShower(getMJGraph().getNewId("Shower"));
      DefaultGraphCell vertex = new
          ShowerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FWardrobe")) {
    FWardrobe nentity=getOM().createFWardrobe(getMJGraph().getNewId("FWardrobe"));
      DefaultGraphCell vertex = new
          FWardrobeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ERemoteControl")) {
    ERemoteControl nentity=getOM().createERemoteControl(getMJGraph().getNewId("ERemoteControl"));
      DefaultGraphCell vertex = new
          ERemoteControlCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESleepers")) {
    ESleepers nentity=getOM().createESleepers(getMJGraph().getNewId("ESleepers"));
      DefaultGraphCell vertex = new
          ESleepersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Dishwasher")) {
    Dishwasher nentity=getOM().createDishwasher(getMJGraph().getNewId("Dishwasher"));
      DefaultGraphCell vertex = new
          DishwasherCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WashMachine")) {
    WashMachine nentity=getOM().createWashMachine(getMJGraph().getNewId("WashMachine"));
      DefaultGraphCell vertex = new
          WashMachineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EatableItem")) {
    EatableItem nentity=getOM().createEatableItem(getMJGraph().getNewId("EatableItem"));
      DefaultGraphCell vertex = new
          EatableItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Walker")) {
    Walker nentity=getOM().createWalker(getMJGraph().getNewId("Walker"));
      DefaultGraphCell vertex = new
          WalkerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Cane")) {
    Cane nentity=getOM().createCane(getMJGraph().getNewId("Cane"));
      DefaultGraphCell vertex = new
          CaneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DComputer")) {
    DComputer nentity=getOM().createDComputer(getMJGraph().getNewId("DComputer"));
      DefaultGraphCell vertex = new
          DComputerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DrinkItem")) {
    DrinkItem nentity=getOM().createDrinkItem(getMJGraph().getNewId("DrinkItem"));
      DefaultGraphCell vertex = new
          DrinkItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOBath")) {
    FOBath nentity=getOM().createFOBath(getMJGraph().getNewId("FOBath"));
      DefaultGraphCell vertex = new
          FOBathCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SpatialVar")) {
    SpatialVar nentity=getOM().createSpatialVar(getMJGraph().getNewId("SpatialVar"));
      DefaultGraphCell vertex = new
          SpatialVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shocks")) {
    Shocks nentity=getOM().createShocks(getMJGraph().getNewId("Shocks"));
      DefaultGraphCell vertex = new
          ShocksCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Bridge")) {
    Bridge nentity=getOM().createBridge(getMJGraph().getNewId("Bridge"));
      DefaultGraphCell vertex = new
          BridgeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMobileDevice")) {
    EMobileDevice nentity=getOM().createEMobileDevice(getMJGraph().getNewId("EMobileDevice"));
      DefaultGraphCell vertex = new
          EMobileDeviceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanVar")) {
    HumanVar nentity=getOM().createHumanVar(getMJGraph().getNewId("HumanVar"));
      DefaultGraphCell vertex = new
          HumanVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DTV")) {
    DTV nentity=getOM().createDTV(getMJGraph().getNewId("DTV"));
      DefaultGraphCell vertex = new
          DTVCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PrimitiveVar")) {
    PrimitiveVar nentity=getOM().createPrimitiveVar(getMJGraph().getNewId("PrimitiveVar"));
      DefaultGraphCell vertex = new
          PrimitiveVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SeatVar")) {
    SeatVar nentity=getOM().createSeatVar(getMJGraph().getNewId("SeatVar"));
      DefaultGraphCell vertex = new
          SeatVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FChair")) {
    FChair nentity=getOM().createFChair(getMJGraph().getNewId("FChair"));
      DefaultGraphCell vertex = new
          FChairCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Pyjamas")) {
    Pyjamas nentity=getOM().createPyjamas(getMJGraph().getNewId("Pyjamas"));
      DefaultGraphCell vertex = new
          PyjamasCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Staircase")) {
    Staircase nentity=getOM().createStaircase(getMJGraph().getNewId("Staircase"));
      DefaultGraphCell vertex = new
          StaircaseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Doorbell")) {
    Doorbell nentity=getOM().createDoorbell(getMJGraph().getNewId("Doorbell"));
      DefaultGraphCell vertex = new
          DoorbellCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Appliance")) {
    Appliance nentity=getOM().createAppliance(getMJGraph().getNewId("Appliance"));
      DefaultGraphCell vertex = new
          ApplianceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SFloor")) {
    SFloor nentity=getOM().createSFloor(getMJGraph().getNewId("SFloor"));
      DefaultGraphCell vertex = new
          SFloorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Extractor")) {
    Extractor nentity=getOM().createExtractor(getMJGraph().getNewId("Extractor"));
      DefaultGraphCell vertex = new
          ExtractorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ObjectVar")) {
    ObjectVar nentity=getOM().createObjectVar(getMJGraph().getNewId("ObjectVar"));
      DefaultGraphCell vertex = new
          ObjectVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBuilding")) {
    SBuilding nentity=getOM().createSBuilding(getMJGraph().getNewId("SBuilding"));
      DefaultGraphCell vertex = new
          SBuildingCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Trousers")) {
    Trousers nentity=getOM().createTrousers(getMJGraph().getNewId("Trousers"));
      DefaultGraphCell vertex = new
          TrousersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWater")) {
    FOWater nentity=getOM().createFOWater(getMJGraph().getNewId("FOWater"));
      DefaultGraphCell vertex = new
          FOWaterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EWaterBottle")) {
    EWaterBottle nentity=getOM().createEWaterBottle(getMJGraph().getNewId("EWaterBottle"));
      DefaultGraphCell vertex = new
          EWaterBottleCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FBed")) {
    FBed nentity=getOM().createFBed(getMJGraph().getNewId("FBed"));
      DefaultGraphCell vertex = new
          FBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FSofa")) {
    FSofa nentity=getOM().createFSofa(getMJGraph().getNewId("FSofa"));
      DefaultGraphCell vertex = new
          FSofaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("PartOfBody")) {
      return PartOfBodyView.getSize((ingenias.editor.entities.PartOfBody)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("InitProgramPool")) {
      return InitProgramPoolView.getSize((ingenias.editor.entities.InitProgramPool)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SymptomInitialization")) {
      return SymptomInitializationView.getSize((ingenias.editor.entities.SymptomInitialization)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AndroidApplication")) {
      return AndroidApplicationView.getSize((ingenias.editor.entities.AndroidApplication)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SDate")) {
      return SDateView.getSize((ingenias.editor.entities.SDate)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AndroidEmulator")) {
      return AndroidEmulatorView.getSize((ingenias.editor.entities.AndroidEmulator)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBathroom")) {
      return SBathroomView.getSize((ingenias.editor.entities.SBathroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((ingenias.editor.entities.Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FlyCamInit")) {
      return FlyCamInitView.getSize((ingenias.editor.entities.FlyCamInit)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SKitchen")) {
      return SKitchenView.getSize((ingenias.editor.entities.SKitchen)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SLivingroom")) {
      return SLivingroomView.getSize((ingenias.editor.entities.SLivingroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBedroom")) {
      return SBedroomView.getSize((ingenias.editor.entities.SBedroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FTable")) {
      return FTableView.getSize((ingenias.editor.entities.FTable)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CameraInit")) {
      return CameraInitView.getSize((ingenias.editor.entities.CameraInit)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SCorridor")) {
      return SCorridorView.getSize((ingenias.editor.entities.SCorridor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SArea")) {
      return SAreaView.getSize((ingenias.editor.entities.SArea)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESmartPhone")) {
      return ESmartPhoneView.getSize((ingenias.editor.entities.ESmartPhone)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("InitialPreDefPos")) {
      return InitialPreDefPosView.getSize((ingenias.editor.entities.InitialPreDefPos)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanInitialization")) {
      return HumanInitializationView.getSize((ingenias.editor.entities.HumanInitialization)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DeviceParam")) {
      return DeviceParamView.getSize((ingenias.editor.entities.DeviceParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SeatParam")) {
      return SeatParamView.getSize((ingenias.editor.entities.SeatParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ObjectParam")) {
      return ObjectParamView.getSize((ingenias.editor.entities.ObjectParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanParam")) {
      return HumanParamView.getSize((ingenias.editor.entities.HumanParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PrimitiveParam")) {
      return PrimitiveParamView.getSize((ingenias.editor.entities.PrimitiveParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PlaceParam")) {
      return PlaceParamView.getSize((ingenias.editor.entities.PlaceParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WearableParam")) {
      return WearableParamView.getSize((ingenias.editor.entities.WearableParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PDSymtom")) {
      return PDSymtomView.getSize((ingenias.editor.entities.PDSymtom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BActivity")) {
      return BActivityView.getSize((ingenias.editor.entities.BActivity)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WorldInitialization")) {
      return WorldInitializationView.getSize((ingenias.editor.entities.WorldInitialization)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Crutch")) {
      return CrutchView.getSize((ingenias.editor.entities.Crutch)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMedicine")) {
      return EMedicineView.getSize((ingenias.editor.entities.EMedicine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shoes")) {
      return ShoesView.getSize((ingenias.editor.entities.Shoes)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWashbasin")) {
      return FOWashbasinView.getSize((ingenias.editor.entities.FOWashbasin)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOSink")) {
      return FOSinkView.getSize((ingenias.editor.entities.FOSink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Lift")) {
      return LiftView.getSize((ingenias.editor.entities.Lift)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WearableVar")) {
      return WearableVarView.getSize((ingenias.editor.entities.WearableVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shirt")) {
      return ShirtView.getSize((ingenias.editor.entities.Shirt)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shower")) {
      return ShowerView.getSize((ingenias.editor.entities.Shower)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FWardrobe")) {
      return FWardrobeView.getSize((ingenias.editor.entities.FWardrobe)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ERemoteControl")) {
      return ERemoteControlView.getSize((ingenias.editor.entities.ERemoteControl)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESleepers")) {
      return ESleepersView.getSize((ingenias.editor.entities.ESleepers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Dishwasher")) {
      return DishwasherView.getSize((ingenias.editor.entities.Dishwasher)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WashMachine")) {
      return WashMachineView.getSize((ingenias.editor.entities.WashMachine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EatableItem")) {
      return EatableItemView.getSize((ingenias.editor.entities.EatableItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Walker")) {
      return WalkerView.getSize((ingenias.editor.entities.Walker)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Cane")) {
      return CaneView.getSize((ingenias.editor.entities.Cane)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DComputer")) {
      return DComputerView.getSize((ingenias.editor.entities.DComputer)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DrinkItem")) {
      return DrinkItemView.getSize((ingenias.editor.entities.DrinkItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOBath")) {
      return FOBathView.getSize((ingenias.editor.entities.FOBath)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SpatialVar")) {
      return SpatialVarView.getSize((ingenias.editor.entities.SpatialVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shocks")) {
      return ShocksView.getSize((ingenias.editor.entities.Shocks)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Bridge")) {
      return BridgeView.getSize((ingenias.editor.entities.Bridge)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMobileDevice")) {
      return EMobileDeviceView.getSize((ingenias.editor.entities.EMobileDevice)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanVar")) {
      return HumanVarView.getSize((ingenias.editor.entities.HumanVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DTV")) {
      return DTVView.getSize((ingenias.editor.entities.DTV)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PrimitiveVar")) {
      return PrimitiveVarView.getSize((ingenias.editor.entities.PrimitiveVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SeatVar")) {
      return SeatVarView.getSize((ingenias.editor.entities.SeatVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FChair")) {
      return FChairView.getSize((ingenias.editor.entities.FChair)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Pyjamas")) {
      return PyjamasView.getSize((ingenias.editor.entities.Pyjamas)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Staircase")) {
      return StaircaseView.getSize((ingenias.editor.entities.Staircase)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Doorbell")) {
      return DoorbellView.getSize((ingenias.editor.entities.Doorbell)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Appliance")) {
      return ApplianceView.getSize((ingenias.editor.entities.Appliance)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SFloor")) {
      return SFloorView.getSize((ingenias.editor.entities.SFloor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Extractor")) {
      return ExtractorView.getSize((ingenias.editor.entities.Extractor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ObjectVar")) {
      return ObjectVarView.getSize((ingenias.editor.entities.ObjectVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBuilding")) {
      return SBuildingView.getSize((ingenias.editor.entities.SBuilding)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Trousers")) {
      return TrousersView.getSize((ingenias.editor.entities.Trousers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWater")) {
      return FOWaterView.getSize((ingenias.editor.entities.FOWater)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EWaterBottle")) {
      return EWaterBottleView.getSize((ingenias.editor.entities.EWaterBottle)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FBed")) {
      return FBedView.getSize((ingenias.editor.entities.FBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FSofa")) {
      return FSofaView.getSize((ingenias.editor.entities.FSofa)entity);      
    }
    else


      if (entity.getType().equalsIgnoreCase("EmulatorPeer")) {
      	return EmulatorPeerView.getSize((ingenias.editor.entities.EmulatorPeer)entity);
      }

      if (entity.getType().equalsIgnoreCase("ParamsSet")) {
      	return ParamsSetView.getSize((ingenias.editor.entities.ParamsSet)entity);
      }

      if (entity.getType().equalsIgnoreCase("RunAndroidApp")) {
      	return RunAndroidAppView.getSize((ingenias.editor.entities.RunAndroidApp)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialDeviceLocation")) {
      	return InitialDeviceLocationView.getSize((ingenias.editor.entities.InitialDeviceLocation)entity);
      }

      if (entity.getType().equalsIgnoreCase("ProducesEvent")) {
      	return ProducesEventView.getSize((ingenias.editor.entities.ProducesEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("cond")) {
      	return condView.getSize((ingenias.editor.entities.cond)entity);
      }

      if (entity.getType().equalsIgnoreCase("ProfileOf")) {
      	return ProfileOfView.getSize((ingenias.editor.entities.ProfileOf)entity);
      }

      if (entity.getType().equalsIgnoreCase("TIStartTime")) {
      	return TIStartTimeView.getSize((ingenias.editor.entities.TIStartTime)entity);
      }

      if (entity.getType().equalsIgnoreCase("med")) {
      	return medView.getSize((ingenias.editor.entities.med)entity);
      }

      if (entity.getType().equalsIgnoreCase("socialRelations")) {
      	return socialRelationsView.getSize((ingenias.editor.entities.socialRelations)entity);
      }

      if (entity.getType().equalsIgnoreCase("WorkAs")) {
      	return WorkAsView.getSize((ingenias.editor.entities.WorkAs)entity);
      }

      if (entity.getType().equalsIgnoreCase("LiveIn")) {
      	return LiveInView.getSize((ingenias.editor.entities.LiveIn)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedEvent")) {
      	return RelatedEventView.getSize((ingenias.editor.entities.RelatedEvent)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActivityAttached")) {
      	return ActivityAttachedView.getSize((ingenias.editor.entities.ActivityAttached)entity);
      }

      if (entity.getType().equalsIgnoreCase("ConditionNeeded")) {
      	return ConditionNeededView.getSize((ingenias.editor.entities.ConditionNeeded)entity);
      }

      if (entity.getType().equalsIgnoreCase("Connects")) {
      	return ConnectsView.getSize((ingenias.editor.entities.Connects)entity);
      }

      if (entity.getType().equalsIgnoreCase("SBhasFloor")) {
      	return SBhasFloorView.getSize((ingenias.editor.entities.SBhasFloor)entity);
      }

      if (entity.getType().equalsIgnoreCase("tool")) {
      	return toolView.getSize((ingenias.editor.entities.tool)entity);
      }

      if (entity.getType().equalsIgnoreCase("FPrecondition")) {
      	return FPreconditionView.getSize((ingenias.editor.entities.FPrecondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("AllowedTask")) {
      	return AllowedTaskView.getSize((ingenias.editor.entities.AllowedTask)entity);
      }

      if (entity.getType().equalsIgnoreCase("relatedCondition")) {
      	return relatedConditionView.getSize((ingenias.editor.entities.relatedCondition)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeinv_op")) {
      	return aeinv_opView.getSize((ingenias.editor.entities.aeinv_op)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op2")) {
      	return aemd_op2View.getSize((ingenias.editor.entities.aemd_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op2")) {
      	return aeas_op2View.getSize((ingenias.editor.entities.aeas_op2)entity);
      }

      if (entity.getType().equalsIgnoreCase("aeas_op1")) {
      	return aeas_op1View.getSize((ingenias.editor.entities.aeas_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("aemd_op1")) {
      	return aemd_op1View.getSize((ingenias.editor.entities.aemd_op1)entity);
      }

      if (entity.getType().equalsIgnoreCase("RelatedHuman")) {
      	return RelatedHumanView.getSize((ingenias.editor.entities.RelatedHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialLocation")) {
      	return InitialLocationView.getSize((ingenias.editor.entities.InitialLocation)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialActivity")) {
      	return InitialActivityView.getSize((ingenias.editor.entities.InitialActivity)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitialDate")) {
      	return InitialDateView.getSize((ingenias.editor.entities.InitialDate)entity);
      }

      if (entity.getType().equalsIgnoreCase("device")) {
      	return deviceView.getSize((ingenias.editor.entities.device)entity);
      }

      if (entity.getType().equalsIgnoreCase("CameraFaceToHuman")) {
      	return CameraFaceToHumanView.getSize((ingenias.editor.entities.CameraFaceToHuman)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializedSymptom")) {
      	return InitializedSymptomView.getSize((ingenias.editor.entities.InitializedSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("InitializesSymptom")) {
      	return InitializesSymptomView.getSize((ingenias.editor.entities.InitializesSymptom)entity);
      }

      if (entity.getType().equalsIgnoreCase("Role")) {
      	return RoleView.getSize((ingenias.editor.entities.Role)entity);
      }

      if (entity.getType().equalsIgnoreCase("DeonticAssignement")) {
      	return DeonticAssignementView.getSize((ingenias.editor.entities.DeonticAssignement)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionResponsible")) {
      	return ActionResponsibleView.getSize((ingenias.editor.entities.ActionResponsible)entity);
      }

      if (entity.getType().equalsIgnoreCase("ActionHappeningAfterwards")) {
      	return ActionHappeningAfterwardsView.getSize((ingenias.editor.entities.ActionHappeningAfterwards)entity);
      }

      if (entity.getType().equalsIgnoreCase("AffectedAction")) {
      	return AffectedActionView.getSize((ingenias.editor.entities.AffectedAction)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodySpeedVar")) {
      	return goToBodySpeedVarView.getSize((ingenias.editor.entities.goToBodySpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjVar")) {
      	return leaveObjVarView.getSize((ingenias.editor.entities.leaveObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("closeObjVar")) {
      	return closeObjVarView.getSize((ingenias.editor.entities.closeObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("pickUpObjVar")) {
      	return pickUpObjVarView.getSize((ingenias.editor.entities.pickUpObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("waitForHumanVar")) {
      	return waitForHumanVarView.getSize((ingenias.editor.entities.waitForHumanVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("durationVar")) {
      	return durationVarView.getSize((ingenias.editor.entities.durationVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToSpeedVar")) {
      	return goToSpeedVarView.getSize((ingenias.editor.entities.goToSpeedVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("messageVar")) {
      	return messageVarView.getSize((ingenias.editor.entities.messageVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapXVar")) {
      	return tapXVarView.getSize((ingenias.editor.entities.tapXVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("sitDownOnSeatVar")) {
      	return sitDownOnSeatVarView.getSize((ingenias.editor.entities.sitDownOnSeatVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOnWearableVar")) {
      	return putOnWearableVarView.getSize((ingenias.editor.entities.putOnWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToPlaceVar")) {
      	return goToPlaceVarView.getSize((ingenias.editor.entities.goToPlaceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapDeviceVar")) {
      	return tapDeviceVarView.getSize((ingenias.editor.entities.tapDeviceVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("openObjVar")) {
      	return openObjVarView.getSize((ingenias.editor.entities.openObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("animVar")) {
      	return animVarView.getSize((ingenias.editor.entities.animVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("useObjVar")) {
      	return useObjVarView.getSize((ingenias.editor.entities.useObjVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("goToBodyVar")) {
      	return goToBodyVarView.getSize((ingenias.editor.entities.goToBodyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("leaveObjDestinyVar")) {
      	return leaveObjDestinyVarView.getSize((ingenias.editor.entities.leaveObjDestinyVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("tapYVar")) {
      	return tapYVarView.getSize((ingenias.editor.entities.tapYVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("switchRoomVar")) {
      	return switchRoomVarView.getSize((ingenias.editor.entities.switchRoomVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("putOffWearableVar")) {
      	return putOffWearableVarView.getSize((ingenias.editor.entities.putOffWearableVar)entity);
      }

      if (entity.getType().equalsIgnoreCase("dropObjVar")) {
      	return dropObjVarView.getSize((ingenias.editor.entities.dropObjVar)entity);
      }

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));

    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);

	Entity newEntity=(Entity) vertex.getUserObject();
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.UML)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.UML);
	if (prefs.getModelingLanguage()==Preferences.ModelingLanguage.INGENIAS)
		newEntity.getPrefs(null).setView(ViewPreferences.ViewType.INGENIAS);

	getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true

    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
    point = convert(this.snap(new Point(point)));
   

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(PartOfBody.class)) {
      vertex = new PartOfBodyCell( (PartOfBody) entity);
      // Default Size for the new Vertex with the new entity within
      size = PartOfBodyView.getSize((PartOfBody) entity);
      
    }
    else

    if (entity.getClass().equals(InitProgramPool.class)) {
      vertex = new InitProgramPoolCell( (InitProgramPool) entity);
      // Default Size for the new Vertex with the new entity within
      size = InitProgramPoolView.getSize((InitProgramPool) entity);
      
    }
    else

    if (entity.getClass().equals(SymptomInitialization.class)) {
      vertex = new SymptomInitializationCell( (SymptomInitialization) entity);
      // Default Size for the new Vertex with the new entity within
      size = SymptomInitializationView.getSize((SymptomInitialization) entity);
      
    }
    else

    if (entity.getClass().equals(AndroidApplication.class)) {
      vertex = new AndroidApplicationCell( (AndroidApplication) entity);
      // Default Size for the new Vertex with the new entity within
      size = AndroidApplicationView.getSize((AndroidApplication) entity);
      
    }
    else

    if (entity.getClass().equals(SDate.class)) {
      vertex = new SDateCell( (SDate) entity);
      // Default Size for the new Vertex with the new entity within
      size = SDateView.getSize((SDate) entity);
      
    }
    else

    if (entity.getClass().equals(AndroidEmulator.class)) {
      vertex = new AndroidEmulatorCell( (AndroidEmulator) entity);
      // Default Size for the new Vertex with the new entity within
      size = AndroidEmulatorView.getSize((AndroidEmulator) entity);
      
    }
    else

    if (entity.getClass().equals(SBathroom.class)) {
      vertex = new SBathroomCell( (SBathroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBathroomView.getSize((SBathroom) entity);
      
    }
    else

    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
      
    }
    else

    if (entity.getClass().equals(FlyCamInit.class)) {
      vertex = new FlyCamInitCell( (FlyCamInit) entity);
      // Default Size for the new Vertex with the new entity within
      size = FlyCamInitView.getSize((FlyCamInit) entity);
      
    }
    else

    if (entity.getClass().equals(SKitchen.class)) {
      vertex = new SKitchenCell( (SKitchen) entity);
      // Default Size for the new Vertex with the new entity within
      size = SKitchenView.getSize((SKitchen) entity);
      
    }
    else

    if (entity.getClass().equals(SLivingroom.class)) {
      vertex = new SLivingroomCell( (SLivingroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SLivingroomView.getSize((SLivingroom) entity);
      
    }
    else

    if (entity.getClass().equals(SBedroom.class)) {
      vertex = new SBedroomCell( (SBedroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBedroomView.getSize((SBedroom) entity);
      
    }
    else

    if (entity.getClass().equals(FTable.class)) {
      vertex = new FTableCell( (FTable) entity);
      // Default Size for the new Vertex with the new entity within
      size = FTableView.getSize((FTable) entity);
      
    }
    else

    if (entity.getClass().equals(CameraInit.class)) {
      vertex = new CameraInitCell( (CameraInit) entity);
      // Default Size for the new Vertex with the new entity within
      size = CameraInitView.getSize((CameraInit) entity);
      
    }
    else

    if (entity.getClass().equals(SCorridor.class)) {
      vertex = new SCorridorCell( (SCorridor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SCorridorView.getSize((SCorridor) entity);
      
    }
    else

    if (entity.getClass().equals(SArea.class)) {
      vertex = new SAreaCell( (SArea) entity);
      // Default Size for the new Vertex with the new entity within
      size = SAreaView.getSize((SArea) entity);
      
    }
    else

    if (entity.getClass().equals(ESmartPhone.class)) {
      vertex = new ESmartPhoneCell( (ESmartPhone) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESmartPhoneView.getSize((ESmartPhone) entity);
      
    }
    else

    if (entity.getClass().equals(InitialPreDefPos.class)) {
      vertex = new InitialPreDefPosCell( (InitialPreDefPos) entity);
      // Default Size for the new Vertex with the new entity within
      size = InitialPreDefPosView.getSize((InitialPreDefPos) entity);
      
    }
    else

    if (entity.getClass().equals(HumanInitialization.class)) {
      vertex = new HumanInitializationCell( (HumanInitialization) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanInitializationView.getSize((HumanInitialization) entity);
      
    }
    else

    if (entity.getClass().equals(DeviceParam.class)) {
      vertex = new DeviceParamCell( (DeviceParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = DeviceParamView.getSize((DeviceParam) entity);
      
    }
    else

    if (entity.getClass().equals(SeatParam.class)) {
      vertex = new SeatParamCell( (SeatParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = SeatParamView.getSize((SeatParam) entity);
      
    }
    else

    if (entity.getClass().equals(ObjectParam.class)) {
      vertex = new ObjectParamCell( (ObjectParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjectParamView.getSize((ObjectParam) entity);
      
    }
    else

    if (entity.getClass().equals(HumanParam.class)) {
      vertex = new HumanParamCell( (HumanParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanParamView.getSize((HumanParam) entity);
      
    }
    else

    if (entity.getClass().equals(PrimitiveParam.class)) {
      vertex = new PrimitiveParamCell( (PrimitiveParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = PrimitiveParamView.getSize((PrimitiveParam) entity);
      
    }
    else

    if (entity.getClass().equals(PlaceParam.class)) {
      vertex = new PlaceParamCell( (PlaceParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = PlaceParamView.getSize((PlaceParam) entity);
      
    }
    else

    if (entity.getClass().equals(WearableParam.class)) {
      vertex = new WearableParamCell( (WearableParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = WearableParamView.getSize((WearableParam) entity);
      
    }
    else

    if (entity.getClass().equals(PDSymtom.class)) {
      vertex = new PDSymtomCell( (PDSymtom) entity);
      // Default Size for the new Vertex with the new entity within
      size = PDSymtomView.getSize((PDSymtom) entity);
      
    }
    else

    if (entity.getClass().equals(BActivity.class)) {
      vertex = new BActivityCell( (BActivity) entity);
      // Default Size for the new Vertex with the new entity within
      size = BActivityView.getSize((BActivity) entity);
      
    }
    else

    if (entity.getClass().equals(WorldInitialization.class)) {
      vertex = new WorldInitializationCell( (WorldInitialization) entity);
      // Default Size for the new Vertex with the new entity within
      size = WorldInitializationView.getSize((WorldInitialization) entity);
      
    }
    else

    if (entity.getClass().equals(Crutch.class)) {
      vertex = new CrutchCell( (Crutch) entity);
      // Default Size for the new Vertex with the new entity within
      size = CrutchView.getSize((Crutch) entity);
      
    }
    else

    if (entity.getClass().equals(EMedicine.class)) {
      vertex = new EMedicineCell( (EMedicine) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMedicineView.getSize((EMedicine) entity);
      
    }
    else

    if (entity.getClass().equals(Shoes.class)) {
      vertex = new ShoesCell( (Shoes) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShoesView.getSize((Shoes) entity);
      
    }
    else

    if (entity.getClass().equals(FOWashbasin.class)) {
      vertex = new FOWashbasinCell( (FOWashbasin) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWashbasinView.getSize((FOWashbasin) entity);
      
    }
    else

    if (entity.getClass().equals(FOSink.class)) {
      vertex = new FOSinkCell( (FOSink) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOSinkView.getSize((FOSink) entity);
      
    }
    else

    if (entity.getClass().equals(Lift.class)) {
      vertex = new LiftCell( (Lift) entity);
      // Default Size for the new Vertex with the new entity within
      size = LiftView.getSize((Lift) entity);
      
    }
    else

    if (entity.getClass().equals(WearableVar.class)) {
      vertex = new WearableVarCell( (WearableVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = WearableVarView.getSize((WearableVar) entity);
      
    }
    else

    if (entity.getClass().equals(Shirt.class)) {
      vertex = new ShirtCell( (Shirt) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShirtView.getSize((Shirt) entity);
      
    }
    else

    if (entity.getClass().equals(Shower.class)) {
      vertex = new ShowerCell( (Shower) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShowerView.getSize((Shower) entity);
      
    }
    else

    if (entity.getClass().equals(FWardrobe.class)) {
      vertex = new FWardrobeCell( (FWardrobe) entity);
      // Default Size for the new Vertex with the new entity within
      size = FWardrobeView.getSize((FWardrobe) entity);
      
    }
    else

    if (entity.getClass().equals(ERemoteControl.class)) {
      vertex = new ERemoteControlCell( (ERemoteControl) entity);
      // Default Size for the new Vertex with the new entity within
      size = ERemoteControlView.getSize((ERemoteControl) entity);
      
    }
    else

    if (entity.getClass().equals(ESleepers.class)) {
      vertex = new ESleepersCell( (ESleepers) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESleepersView.getSize((ESleepers) entity);
      
    }
    else

    if (entity.getClass().equals(Dishwasher.class)) {
      vertex = new DishwasherCell( (Dishwasher) entity);
      // Default Size for the new Vertex with the new entity within
      size = DishwasherView.getSize((Dishwasher) entity);
      
    }
    else

    if (entity.getClass().equals(WashMachine.class)) {
      vertex = new WashMachineCell( (WashMachine) entity);
      // Default Size for the new Vertex with the new entity within
      size = WashMachineView.getSize((WashMachine) entity);
      
    }
    else

    if (entity.getClass().equals(EatableItem.class)) {
      vertex = new EatableItemCell( (EatableItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatableItemView.getSize((EatableItem) entity);
      
    }
    else

    if (entity.getClass().equals(Walker.class)) {
      vertex = new WalkerCell( (Walker) entity);
      // Default Size for the new Vertex with the new entity within
      size = WalkerView.getSize((Walker) entity);
      
    }
    else

    if (entity.getClass().equals(Cane.class)) {
      vertex = new CaneCell( (Cane) entity);
      // Default Size for the new Vertex with the new entity within
      size = CaneView.getSize((Cane) entity);
      
    }
    else

    if (entity.getClass().equals(DComputer.class)) {
      vertex = new DComputerCell( (DComputer) entity);
      // Default Size for the new Vertex with the new entity within
      size = DComputerView.getSize((DComputer) entity);
      
    }
    else

    if (entity.getClass().equals(DrinkItem.class)) {
      vertex = new DrinkItemCell( (DrinkItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkItemView.getSize((DrinkItem) entity);
      
    }
    else

    if (entity.getClass().equals(FOBath.class)) {
      vertex = new FOBathCell( (FOBath) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOBathView.getSize((FOBath) entity);
      
    }
    else

    if (entity.getClass().equals(SpatialVar.class)) {
      vertex = new SpatialVarCell( (SpatialVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = SpatialVarView.getSize((SpatialVar) entity);
      
    }
    else

    if (entity.getClass().equals(Shocks.class)) {
      vertex = new ShocksCell( (Shocks) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShocksView.getSize((Shocks) entity);
      
    }
    else

    if (entity.getClass().equals(Bridge.class)) {
      vertex = new BridgeCell( (Bridge) entity);
      // Default Size for the new Vertex with the new entity within
      size = BridgeView.getSize((Bridge) entity);
      
    }
    else

    if (entity.getClass().equals(EMobileDevice.class)) {
      vertex = new EMobileDeviceCell( (EMobileDevice) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMobileDeviceView.getSize((EMobileDevice) entity);
      
    }
    else

    if (entity.getClass().equals(HumanVar.class)) {
      vertex = new HumanVarCell( (HumanVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanVarView.getSize((HumanVar) entity);
      
    }
    else

    if (entity.getClass().equals(DTV.class)) {
      vertex = new DTVCell( (DTV) entity);
      // Default Size for the new Vertex with the new entity within
      size = DTVView.getSize((DTV) entity);
      
    }
    else

    if (entity.getClass().equals(PrimitiveVar.class)) {
      vertex = new PrimitiveVarCell( (PrimitiveVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = PrimitiveVarView.getSize((PrimitiveVar) entity);
      
    }
    else

    if (entity.getClass().equals(SeatVar.class)) {
      vertex = new SeatVarCell( (SeatVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = SeatVarView.getSize((SeatVar) entity);
      
    }
    else

    if (entity.getClass().equals(FChair.class)) {
      vertex = new FChairCell( (FChair) entity);
      // Default Size for the new Vertex with the new entity within
      size = FChairView.getSize((FChair) entity);
      
    }
    else

    if (entity.getClass().equals(Pyjamas.class)) {
      vertex = new PyjamasCell( (Pyjamas) entity);
      // Default Size for the new Vertex with the new entity within
      size = PyjamasView.getSize((Pyjamas) entity);
      
    }
    else

    if (entity.getClass().equals(Staircase.class)) {
      vertex = new StaircaseCell( (Staircase) entity);
      // Default Size for the new Vertex with the new entity within
      size = StaircaseView.getSize((Staircase) entity);
      
    }
    else

    if (entity.getClass().equals(Doorbell.class)) {
      vertex = new DoorbellCell( (Doorbell) entity);
      // Default Size for the new Vertex with the new entity within
      size = DoorbellView.getSize((Doorbell) entity);
      
    }
    else

    if (entity.getClass().equals(Appliance.class)) {
      vertex = new ApplianceCell( (Appliance) entity);
      // Default Size for the new Vertex with the new entity within
      size = ApplianceView.getSize((Appliance) entity);
      
    }
    else

    if (entity.getClass().equals(SFloor.class)) {
      vertex = new SFloorCell( (SFloor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SFloorView.getSize((SFloor) entity);
      
    }
    else

    if (entity.getClass().equals(Extractor.class)) {
      vertex = new ExtractorCell( (Extractor) entity);
      // Default Size for the new Vertex with the new entity within
      size = ExtractorView.getSize((Extractor) entity);
      
    }
    else

    if (entity.getClass().equals(ObjectVar.class)) {
      vertex = new ObjectVarCell( (ObjectVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjectVarView.getSize((ObjectVar) entity);
      
    }
    else

    if (entity.getClass().equals(SBuilding.class)) {
      vertex = new SBuildingCell( (SBuilding) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBuildingView.getSize((SBuilding) entity);
      
    }
    else

    if (entity.getClass().equals(Trousers.class)) {
      vertex = new TrousersCell( (Trousers) entity);
      // Default Size for the new Vertex with the new entity within
      size = TrousersView.getSize((Trousers) entity);
      
    }
    else

    if (entity.getClass().equals(FOWater.class)) {
      vertex = new FOWaterCell( (FOWater) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWaterView.getSize((FOWater) entity);
      
    }
    else

    if (entity.getClass().equals(EWaterBottle.class)) {
      vertex = new EWaterBottleCell( (EWaterBottle) entity);
      // Default Size for the new Vertex with the new entity within
      size = EWaterBottleView.getSize((EWaterBottle) entity);
      
    }
    else

    if (entity.getClass().equals(FBed.class)) {
      vertex = new FBedCell( (FBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = FBedView.getSize((FBed) entity);
      
    }
    else

    if (entity.getClass().equals(FSofa.class)) {
      vertex = new FSofaCell( (FSofa) entity);
      // Default Size for the new Vertex with the new entity within
      size = FSofaView.getSize((FSofa) entity);
      
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
JOptionPane.showMessageDialog(this,
		 "Object not allowed in this diagram "+this.getID()+":"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName(),"Warning", JOptionPane.WARNING_MESSAGE);    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
      getGraphLayoutCache().setVisible(vertex,true);// makes the cell visible because
      // the graphlayoutcache has partial set to true  
        // waits for the cellview to be created
		boolean created=false;
		VertexView vv=null;
		while (!created){
			CellView[] cellviews = this.getGraphLayoutCache().getCellViews();
			for (CellView cv:cellviews){
				if (cv.getCell()==vertex){
					// created!
					created=true;
					vv=(VertexView)cv;
				}
			}
			try {
				Thread.currentThread().sleep(10);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		// This should be used when the corresponding view for the entity has containers!
		// It can be known by inspecting its renderer. To get it, a cellview is needed,
		// but the cellview is created after a while via succesive callbacks to
		// the view factories

		if (!ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null).isEmpty()){
			// there are container renderers that need new cells corresponding to children to
			// be inserted

						Hashtable<String, CollectionPanel> renderers = ListenerContainer.evaluate((CompositeRenderer) vv.getRenderer(),entity,null);
			for (String field:renderers.keySet()){
				Method obtainenumeration;
				try {
					obtainenumeration = entity.getClass().getMethod("get"+field+"Elements");
					Enumeration<ingenias.editor.entities.Entity>  enom=(Enumeration<ingenias.editor.entities.Entity>) obtainenumeration.invoke(entity,new Object[]{});
					while (enom.hasMoreElements()){
						DefaultGraphCell child=this.insertDuplicated(new Point(40,10), enom.nextElement());
						try {
							getListenerContainer().setParent(child,vertex);
						} catch (WrongParent e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} 
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				}
							
		}
		
                             
    }
   return vertex;

  }


 public synchronized JGraph cloneJGraph(IDEState ids){

		

		 SimulationDiagramModelJGraph jg=new  SimulationDiagramModelJGraph(
				(SimulationDiagramDataEntity) this.mde,name, ids.om,
				new Model(ids),new BasicMarqueeHandler(),ids.prefs); 

		this.setSelectionCells(getGraphLayoutCache().getCells(false,true,false,false));
		Action copyaction =new EventRedirectorForGraphCopy(this,this.getTransferHandler().getCopyAction(),null	); 			
		Action pasteaction =new EventRedirectorPasteForGraphCopy(jg,jg.getTransferHandler().getPasteAction(),null	);
		copyaction.actionPerformed(new ActionEvent(this,0,"hello"));		
		pasteaction.actionPerformed(new ActionEvent(this,0,"hello"));
		jg.invalidate();
		jg.doLayout();
		
		return jg;

	}


  public String toString() {
    return this.getID();
  }

}
