

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class ArithmeticDiagram1Panel extends JGraph {

  public ArithmeticDiagram1Panel(ArithmeticDiagram1DataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.ArithmeticDiagram1CellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("AENumConst");

 entities.add("AEAddition");

 entities.add("AEVariable");

 entities.add("AEMult");

 entities.add("AEDiv");

 entities.add("AEInv");

 entities.add("AESubtraction");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("AENumConst")) {
    AENumConst nentity=new AENumConst(((Model)getModel()).getNewId("AENumConst"));
      DefaultGraphCell vertex = new
          AENumConstCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AEAddition")) {
    AEAddition nentity=new AEAddition(((Model)getModel()).getNewId("AEAddition"));
      DefaultGraphCell vertex = new
          AEAdditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AEVariable")) {
    AEVariable nentity=new AEVariable(((Model)getModel()).getNewId("AEVariable"));
      DefaultGraphCell vertex = new
          AEVariableCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AEMult")) {
    AEMult nentity=new AEMult(((Model)getModel()).getNewId("AEMult"));
      DefaultGraphCell vertex = new
          AEMultCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AEDiv")) {
    AEDiv nentity=new AEDiv(((Model)getModel()).getNewId("AEDiv"));
      DefaultGraphCell vertex = new
          AEDivCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AEInv")) {
    AEInv nentity=new AEInv(((Model)getModel()).getNewId("AEInv"));
      DefaultGraphCell vertex = new
          AEInvCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AESubtraction")) {
    AESubtraction nentity=new AESubtraction(((Model)getModel()).getNewId("AESubtraction"));
      DefaultGraphCell vertex = new
          AESubtractionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("AENumConst")) {
      return AENumConstView.getSize((AENumConst)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AEAddition")) {
      return AEAdditionView.getSize((AEAddition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AEVariable")) {
      return AEVariableView.getSize((AEVariable)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AEMult")) {
      return AEMultView.getSize((AEMult)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AEDiv")) {
      return AEDivView.getSize((AEDiv)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AEInv")) {
      return AEInvView.getSize((AEInv)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AESubtraction")) {
      return AESubtractionView.getSize((AESubtraction)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(AENumConst.class)) {
      vertex = new AENumConstCell( (AENumConst) entity);
      // Default Size for the new Vertex with the new entity within
      size = AENumConstView.getSize((AENumConst) entity);
    }
    else

    if (entity.getClass().equals(AEAddition.class)) {
      vertex = new AEAdditionCell( (AEAddition) entity);
      // Default Size for the new Vertex with the new entity within
      size = AEAdditionView.getSize((AEAddition) entity);
    }
    else

    if (entity.getClass().equals(AEVariable.class)) {
      vertex = new AEVariableCell( (AEVariable) entity);
      // Default Size for the new Vertex with the new entity within
      size = AEVariableView.getSize((AEVariable) entity);
    }
    else

    if (entity.getClass().equals(AEMult.class)) {
      vertex = new AEMultCell( (AEMult) entity);
      // Default Size for the new Vertex with the new entity within
      size = AEMultView.getSize((AEMult) entity);
    }
    else

    if (entity.getClass().equals(AEDiv.class)) {
      vertex = new AEDivCell( (AEDiv) entity);
      // Default Size for the new Vertex with the new entity within
      size = AEDivView.getSize((AEDiv) entity);
    }
    else

    if (entity.getClass().equals(AEInv.class)) {
      vertex = new AEInvCell( (AEInv) entity);
      // Default Size for the new Vertex with the new entity within
      size = AEInvView.getSize((AEInv) entity);
    }
    else

    if (entity.getClass().equals(AESubtraction.class)) {
      vertex = new AESubtractionCell( (AESubtraction) entity);
      // Default Size for the new Vertex with the new entity within
      size = AESubtractionView.getSize((AESubtraction) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in ArithmeticDiagram1 diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
