

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class DeviceDiagramPanel extends JGraph {

  public DeviceDiagramPanel(DeviceDiagramDataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.DeviceDiagramCellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("Doorbell");

 entities.add("ESmartPhone");

 entities.add("ERemoteControl");

 entities.add("Dishwasher");

 entities.add("WashMachine");

 entities.add("DTV");

 entities.add("Extractor");

 entities.add("Bridge");

 entities.add("DComputer");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("Doorbell")) {
    Doorbell nentity=new Doorbell(((Model)getModel()).getNewId("Doorbell"));
      DefaultGraphCell vertex = new
          DoorbellCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESmartPhone")) {
    ESmartPhone nentity=new ESmartPhone(((Model)getModel()).getNewId("ESmartPhone"));
      DefaultGraphCell vertex = new
          ESmartPhoneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ERemoteControl")) {
    ERemoteControl nentity=new ERemoteControl(((Model)getModel()).getNewId("ERemoteControl"));
      DefaultGraphCell vertex = new
          ERemoteControlCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Dishwasher")) {
    Dishwasher nentity=new Dishwasher(((Model)getModel()).getNewId("Dishwasher"));
      DefaultGraphCell vertex = new
          DishwasherCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WashMachine")) {
    WashMachine nentity=new WashMachine(((Model)getModel()).getNewId("WashMachine"));
      DefaultGraphCell vertex = new
          WashMachineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DTV")) {
    DTV nentity=new DTV(((Model)getModel()).getNewId("DTV"));
      DefaultGraphCell vertex = new
          DTVCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Extractor")) {
    Extractor nentity=new Extractor(((Model)getModel()).getNewId("Extractor"));
      DefaultGraphCell vertex = new
          ExtractorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Bridge")) {
    Bridge nentity=new Bridge(((Model)getModel()).getNewId("Bridge"));
      DefaultGraphCell vertex = new
          BridgeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DComputer")) {
    DComputer nentity=new DComputer(((Model)getModel()).getNewId("DComputer"));
      DefaultGraphCell vertex = new
          DComputerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("Doorbell")) {
      return DoorbellView.getSize((Doorbell)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESmartPhone")) {
      return ESmartPhoneView.getSize((ESmartPhone)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ERemoteControl")) {
      return ERemoteControlView.getSize((ERemoteControl)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Dishwasher")) {
      return DishwasherView.getSize((Dishwasher)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WashMachine")) {
      return WashMachineView.getSize((WashMachine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DTV")) {
      return DTVView.getSize((DTV)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Extractor")) {
      return ExtractorView.getSize((Extractor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Bridge")) {
      return BridgeView.getSize((Bridge)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DComputer")) {
      return DComputerView.getSize((DComputer)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(Doorbell.class)) {
      vertex = new DoorbellCell( (Doorbell) entity);
      // Default Size for the new Vertex with the new entity within
      size = DoorbellView.getSize((Doorbell) entity);
    }
    else

    if (entity.getClass().equals(ESmartPhone.class)) {
      vertex = new ESmartPhoneCell( (ESmartPhone) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESmartPhoneView.getSize((ESmartPhone) entity);
    }
    else

    if (entity.getClass().equals(ERemoteControl.class)) {
      vertex = new ERemoteControlCell( (ERemoteControl) entity);
      // Default Size for the new Vertex with the new entity within
      size = ERemoteControlView.getSize((ERemoteControl) entity);
    }
    else

    if (entity.getClass().equals(Dishwasher.class)) {
      vertex = new DishwasherCell( (Dishwasher) entity);
      // Default Size for the new Vertex with the new entity within
      size = DishwasherView.getSize((Dishwasher) entity);
    }
    else

    if (entity.getClass().equals(WashMachine.class)) {
      vertex = new WashMachineCell( (WashMachine) entity);
      // Default Size for the new Vertex with the new entity within
      size = WashMachineView.getSize((WashMachine) entity);
    }
    else

    if (entity.getClass().equals(DTV.class)) {
      vertex = new DTVCell( (DTV) entity);
      // Default Size for the new Vertex with the new entity within
      size = DTVView.getSize((DTV) entity);
    }
    else

    if (entity.getClass().equals(Extractor.class)) {
      vertex = new ExtractorCell( (Extractor) entity);
      // Default Size for the new Vertex with the new entity within
      size = ExtractorView.getSize((Extractor) entity);
    }
    else

    if (entity.getClass().equals(Bridge.class)) {
      vertex = new BridgeCell( (Bridge) entity);
      // Default Size for the new Vertex with the new entity within
      size = BridgeView.getSize((Bridge) entity);
    }
    else

    if (entity.getClass().equals(DComputer.class)) {
      vertex = new DComputerCell( (DComputer) entity);
      // Default Size for the new Vertex with the new entity within
      size = DComputerView.getSize((DComputer) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in DeviceDiagram diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
