

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class HumanProfileSpecDiagramPanel extends JGraph {

  public HumanProfileSpecDiagramPanel(HumanProfileSpecDiagramDataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.HumanProfileSpecDiagramCellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("Human");

 entities.add("ADLProfile");

 entities.add("GenericDisease");

 entities.add("InteractionProfile");

 entities.add("ParkinsonsProfile");

 entities.add("SocialProfile");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=new Human(((Model)getModel()).getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ADLProfile")) {
    ADLProfile nentity=new ADLProfile(((Model)getModel()).getNewId("ADLProfile"));
      DefaultGraphCell vertex = new
          ADLProfileCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GenericDisease")) {
    GenericDisease nentity=new GenericDisease(((Model)getModel()).getNewId("GenericDisease"));
      DefaultGraphCell vertex = new
          GenericDiseaseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("InteractionProfile")) {
    InteractionProfile nentity=new InteractionProfile(((Model)getModel()).getNewId("InteractionProfile"));
      DefaultGraphCell vertex = new
          InteractionProfileCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ParkinsonsProfile")) {
    ParkinsonsProfile nentity=new ParkinsonsProfile(((Model)getModel()).getNewId("ParkinsonsProfile"));
      DefaultGraphCell vertex = new
          ParkinsonsProfileCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SocialProfile")) {
    SocialProfile nentity=new SocialProfile(((Model)getModel()).getNewId("SocialProfile"));
      DefaultGraphCell vertex = new
          SocialProfileCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ADLProfile")) {
      return ADLProfileView.getSize((ADLProfile)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GenericDisease")) {
      return GenericDiseaseView.getSize((GenericDisease)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("InteractionProfile")) {
      return InteractionProfileView.getSize((InteractionProfile)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ParkinsonsProfile")) {
      return ParkinsonsProfileView.getSize((ParkinsonsProfile)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SocialProfile")) {
      return SocialProfileView.getSize((SocialProfile)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
    }
    else

    if (entity.getClass().equals(ADLProfile.class)) {
      vertex = new ADLProfileCell( (ADLProfile) entity);
      // Default Size for the new Vertex with the new entity within
      size = ADLProfileView.getSize((ADLProfile) entity);
    }
    else

    if (entity.getClass().equals(GenericDisease.class)) {
      vertex = new GenericDiseaseCell( (GenericDisease) entity);
      // Default Size for the new Vertex with the new entity within
      size = GenericDiseaseView.getSize((GenericDisease) entity);
    }
    else

    if (entity.getClass().equals(InteractionProfile.class)) {
      vertex = new InteractionProfileCell( (InteractionProfile) entity);
      // Default Size for the new Vertex with the new entity within
      size = InteractionProfileView.getSize((InteractionProfile) entity);
    }
    else

    if (entity.getClass().equals(ParkinsonsProfile.class)) {
      vertex = new ParkinsonsProfileCell( (ParkinsonsProfile) entity);
      // Default Size for the new Vertex with the new entity within
      size = ParkinsonsProfileView.getSize((ParkinsonsProfile) entity);
    }
    else

    if (entity.getClass().equals(SocialProfile.class)) {
      vertex = new SocialProfileCell( (SocialProfile) entity);
      // Default Size for the new Vertex with the new entity within
      size = SocialProfileView.getSize((SocialProfile) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in HumanProfileSpecDiagram diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
