

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class NormDefinitionPanel extends JGraph {

  public NormDefinitionPanel(NormDefinitionDataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.NormDefinitionCellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("AnotherActionHappens");

 entities.add("Human");

 entities.add("SArea");

 entities.add("SBuilding");

 entities.add("SFloor");

 entities.add("ConsecutiveActions");

 entities.add("GoToBodyLoc");

 entities.add("TakeOffTask");

 entities.add("WaitTask");

 entities.add("BPickUpTask");

 entities.add("FallSleep");

 entities.add("OpenTask");

 entities.add("Drink");

 entities.add("SayTask");

 entities.add("BWakeUpTask");

 entities.add("BGoToTask");

 entities.add("StandUp");

 entities.add("TapXYTask");

 entities.add("CloseTask");

 entities.add("BSequentialTask");

 entities.add("SitDown");

 entities.add("GoIntoBed");

 entities.add("SwitchLightTask");

 entities.add("BLeaveTask");

 entities.add("BGetUpFromBed");

 entities.add("SwipeTask");

 entities.add("BRandomTask");

 entities.add("DropObj");

 entities.add("PutOnTask");

 entities.add("WaitForBodyClose");

 entities.add("PlayAnimationTask");

 entities.add("FallTask");

 entities.add("BUseTask");

 entities.add("Eat");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("AnotherActionHappens")) {
    AnotherActionHappens nentity=new AnotherActionHappens(((Model)getModel()).getNewId("AnotherActionHappens"));
      DefaultGraphCell vertex = new
          AnotherActionHappensCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=new Human(((Model)getModel()).getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SArea")) {
    SArea nentity=new SArea(((Model)getModel()).getNewId("SArea"));
      DefaultGraphCell vertex = new
          SAreaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBuilding")) {
    SBuilding nentity=new SBuilding(((Model)getModel()).getNewId("SBuilding"));
      DefaultGraphCell vertex = new
          SBuildingCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SFloor")) {
    SFloor nentity=new SFloor(((Model)getModel()).getNewId("SFloor"));
      DefaultGraphCell vertex = new
          SFloorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ConsecutiveActions")) {
    ConsecutiveActions nentity=new ConsecutiveActions(((Model)getModel()).getNewId("ConsecutiveActions"));
      DefaultGraphCell vertex = new
          ConsecutiveActionsCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoToBodyLoc")) {
    GoToBodyLoc nentity=new GoToBodyLoc(((Model)getModel()).getNewId("GoToBodyLoc"));
      DefaultGraphCell vertex = new
          GoToBodyLocCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TakeOffTask")) {
    TakeOffTask nentity=new TakeOffTask(((Model)getModel()).getNewId("TakeOffTask"));
      DefaultGraphCell vertex = new
          TakeOffTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitTask")) {
    WaitTask nentity=new WaitTask(((Model)getModel()).getNewId("WaitTask"));
      DefaultGraphCell vertex = new
          WaitTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BPickUpTask")) {
    BPickUpTask nentity=new BPickUpTask(((Model)getModel()).getNewId("BPickUpTask"));
      DefaultGraphCell vertex = new
          BPickUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallSleep")) {
    FallSleep nentity=new FallSleep(((Model)getModel()).getNewId("FallSleep"));
      DefaultGraphCell vertex = new
          FallSleepCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("OpenTask")) {
    OpenTask nentity=new OpenTask(((Model)getModel()).getNewId("OpenTask"));
      DefaultGraphCell vertex = new
          OpenTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Drink")) {
    Drink nentity=new Drink(((Model)getModel()).getNewId("Drink"));
      DefaultGraphCell vertex = new
          DrinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SayTask")) {
    SayTask nentity=new SayTask(((Model)getModel()).getNewId("SayTask"));
      DefaultGraphCell vertex = new
          SayTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BWakeUpTask")) {
    BWakeUpTask nentity=new BWakeUpTask(((Model)getModel()).getNewId("BWakeUpTask"));
      DefaultGraphCell vertex = new
          BWakeUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGoToTask")) {
    BGoToTask nentity=new BGoToTask(((Model)getModel()).getNewId("BGoToTask"));
      DefaultGraphCell vertex = new
          BGoToTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StandUp")) {
    StandUp nentity=new StandUp(((Model)getModel()).getNewId("StandUp"));
      DefaultGraphCell vertex = new
          StandUpCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TapXYTask")) {
    TapXYTask nentity=new TapXYTask(((Model)getModel()).getNewId("TapXYTask"));
      DefaultGraphCell vertex = new
          TapXYTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CloseTask")) {
    CloseTask nentity=new CloseTask(((Model)getModel()).getNewId("CloseTask"));
      DefaultGraphCell vertex = new
          CloseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BSequentialTask")) {
    BSequentialTask nentity=new BSequentialTask(((Model)getModel()).getNewId("BSequentialTask"));
      DefaultGraphCell vertex = new
          BSequentialTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SitDown")) {
    SitDown nentity=new SitDown(((Model)getModel()).getNewId("SitDown"));
      DefaultGraphCell vertex = new
          SitDownCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoIntoBed")) {
    GoIntoBed nentity=new GoIntoBed(((Model)getModel()).getNewId("GoIntoBed"));
      DefaultGraphCell vertex = new
          GoIntoBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwitchLightTask")) {
    SwitchLightTask nentity=new SwitchLightTask(((Model)getModel()).getNewId("SwitchLightTask"));
      DefaultGraphCell vertex = new
          SwitchLightTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BLeaveTask")) {
    BLeaveTask nentity=new BLeaveTask(((Model)getModel()).getNewId("BLeaveTask"));
      DefaultGraphCell vertex = new
          BLeaveTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGetUpFromBed")) {
    BGetUpFromBed nentity=new BGetUpFromBed(((Model)getModel()).getNewId("BGetUpFromBed"));
      DefaultGraphCell vertex = new
          BGetUpFromBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwipeTask")) {
    SwipeTask nentity=new SwipeTask(((Model)getModel()).getNewId("SwipeTask"));
      DefaultGraphCell vertex = new
          SwipeTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BRandomTask")) {
    BRandomTask nentity=new BRandomTask(((Model)getModel()).getNewId("BRandomTask"));
      DefaultGraphCell vertex = new
          BRandomTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DropObj")) {
    DropObj nentity=new DropObj(((Model)getModel()).getNewId("DropObj"));
      DefaultGraphCell vertex = new
          DropObjCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PutOnTask")) {
    PutOnTask nentity=new PutOnTask(((Model)getModel()).getNewId("PutOnTask"));
      DefaultGraphCell vertex = new
          PutOnTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitForBodyClose")) {
    WaitForBodyClose nentity=new WaitForBodyClose(((Model)getModel()).getNewId("WaitForBodyClose"));
      DefaultGraphCell vertex = new
          WaitForBodyCloseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PlayAnimationTask")) {
    PlayAnimationTask nentity=new PlayAnimationTask(((Model)getModel()).getNewId("PlayAnimationTask"));
      DefaultGraphCell vertex = new
          PlayAnimationTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallTask")) {
    FallTask nentity=new FallTask(((Model)getModel()).getNewId("FallTask"));
      DefaultGraphCell vertex = new
          FallTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BUseTask")) {
    BUseTask nentity=new BUseTask(((Model)getModel()).getNewId("BUseTask"));
      DefaultGraphCell vertex = new
          BUseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Eat")) {
    Eat nentity=new Eat(((Model)getModel()).getNewId("Eat"));
      DefaultGraphCell vertex = new
          EatCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("AnotherActionHappens")) {
      return AnotherActionHappensView.getSize((AnotherActionHappens)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SArea")) {
      return SAreaView.getSize((SArea)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBuilding")) {
      return SBuildingView.getSize((SBuilding)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SFloor")) {
      return SFloorView.getSize((SFloor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ConsecutiveActions")) {
      return ConsecutiveActionsView.getSize((ConsecutiveActions)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoToBodyLoc")) {
      return GoToBodyLocView.getSize((GoToBodyLoc)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TakeOffTask")) {
      return TakeOffTaskView.getSize((TakeOffTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitTask")) {
      return WaitTaskView.getSize((WaitTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BPickUpTask")) {
      return BPickUpTaskView.getSize((BPickUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallSleep")) {
      return FallSleepView.getSize((FallSleep)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("OpenTask")) {
      return OpenTaskView.getSize((OpenTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Drink")) {
      return DrinkView.getSize((Drink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SayTask")) {
      return SayTaskView.getSize((SayTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BWakeUpTask")) {
      return BWakeUpTaskView.getSize((BWakeUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGoToTask")) {
      return BGoToTaskView.getSize((BGoToTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StandUp")) {
      return StandUpView.getSize((StandUp)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TapXYTask")) {
      return TapXYTaskView.getSize((TapXYTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CloseTask")) {
      return CloseTaskView.getSize((CloseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BSequentialTask")) {
      return BSequentialTaskView.getSize((BSequentialTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SitDown")) {
      return SitDownView.getSize((SitDown)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoIntoBed")) {
      return GoIntoBedView.getSize((GoIntoBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwitchLightTask")) {
      return SwitchLightTaskView.getSize((SwitchLightTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BLeaveTask")) {
      return BLeaveTaskView.getSize((BLeaveTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGetUpFromBed")) {
      return BGetUpFromBedView.getSize((BGetUpFromBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwipeTask")) {
      return SwipeTaskView.getSize((SwipeTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BRandomTask")) {
      return BRandomTaskView.getSize((BRandomTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DropObj")) {
      return DropObjView.getSize((DropObj)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PutOnTask")) {
      return PutOnTaskView.getSize((PutOnTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitForBodyClose")) {
      return WaitForBodyCloseView.getSize((WaitForBodyClose)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PlayAnimationTask")) {
      return PlayAnimationTaskView.getSize((PlayAnimationTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallTask")) {
      return FallTaskView.getSize((FallTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BUseTask")) {
      return BUseTaskView.getSize((BUseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Eat")) {
      return EatView.getSize((Eat)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(AnotherActionHappens.class)) {
      vertex = new AnotherActionHappensCell( (AnotherActionHappens) entity);
      // Default Size for the new Vertex with the new entity within
      size = AnotherActionHappensView.getSize((AnotherActionHappens) entity);
    }
    else

    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
    }
    else

    if (entity.getClass().equals(SArea.class)) {
      vertex = new SAreaCell( (SArea) entity);
      // Default Size for the new Vertex with the new entity within
      size = SAreaView.getSize((SArea) entity);
    }
    else

    if (entity.getClass().equals(SBuilding.class)) {
      vertex = new SBuildingCell( (SBuilding) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBuildingView.getSize((SBuilding) entity);
    }
    else

    if (entity.getClass().equals(SFloor.class)) {
      vertex = new SFloorCell( (SFloor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SFloorView.getSize((SFloor) entity);
    }
    else

    if (entity.getClass().equals(ConsecutiveActions.class)) {
      vertex = new ConsecutiveActionsCell( (ConsecutiveActions) entity);
      // Default Size for the new Vertex with the new entity within
      size = ConsecutiveActionsView.getSize((ConsecutiveActions) entity);
    }
    else

    if (entity.getClass().equals(GoToBodyLoc.class)) {
      vertex = new GoToBodyLocCell( (GoToBodyLoc) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoToBodyLocView.getSize((GoToBodyLoc) entity);
    }
    else

    if (entity.getClass().equals(TakeOffTask.class)) {
      vertex = new TakeOffTaskCell( (TakeOffTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TakeOffTaskView.getSize((TakeOffTask) entity);
    }
    else

    if (entity.getClass().equals(WaitTask.class)) {
      vertex = new WaitTaskCell( (WaitTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitTaskView.getSize((WaitTask) entity);
    }
    else

    if (entity.getClass().equals(BPickUpTask.class)) {
      vertex = new BPickUpTaskCell( (BPickUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BPickUpTaskView.getSize((BPickUpTask) entity);
    }
    else

    if (entity.getClass().equals(FallSleep.class)) {
      vertex = new FallSleepCell( (FallSleep) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallSleepView.getSize((FallSleep) entity);
    }
    else

    if (entity.getClass().equals(OpenTask.class)) {
      vertex = new OpenTaskCell( (OpenTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = OpenTaskView.getSize((OpenTask) entity);
    }
    else

    if (entity.getClass().equals(Drink.class)) {
      vertex = new DrinkCell( (Drink) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkView.getSize((Drink) entity);
    }
    else

    if (entity.getClass().equals(SayTask.class)) {
      vertex = new SayTaskCell( (SayTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SayTaskView.getSize((SayTask) entity);
    }
    else

    if (entity.getClass().equals(BWakeUpTask.class)) {
      vertex = new BWakeUpTaskCell( (BWakeUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BWakeUpTaskView.getSize((BWakeUpTask) entity);
    }
    else

    if (entity.getClass().equals(BGoToTask.class)) {
      vertex = new BGoToTaskCell( (BGoToTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGoToTaskView.getSize((BGoToTask) entity);
    }
    else

    if (entity.getClass().equals(StandUp.class)) {
      vertex = new StandUpCell( (StandUp) entity);
      // Default Size for the new Vertex with the new entity within
      size = StandUpView.getSize((StandUp) entity);
    }
    else

    if (entity.getClass().equals(TapXYTask.class)) {
      vertex = new TapXYTaskCell( (TapXYTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TapXYTaskView.getSize((TapXYTask) entity);
    }
    else

    if (entity.getClass().equals(CloseTask.class)) {
      vertex = new CloseTaskCell( (CloseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = CloseTaskView.getSize((CloseTask) entity);
    }
    else

    if (entity.getClass().equals(BSequentialTask.class)) {
      vertex = new BSequentialTaskCell( (BSequentialTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BSequentialTaskView.getSize((BSequentialTask) entity);
    }
    else

    if (entity.getClass().equals(SitDown.class)) {
      vertex = new SitDownCell( (SitDown) entity);
      // Default Size for the new Vertex with the new entity within
      size = SitDownView.getSize((SitDown) entity);
    }
    else

    if (entity.getClass().equals(GoIntoBed.class)) {
      vertex = new GoIntoBedCell( (GoIntoBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoIntoBedView.getSize((GoIntoBed) entity);
    }
    else

    if (entity.getClass().equals(SwitchLightTask.class)) {
      vertex = new SwitchLightTaskCell( (SwitchLightTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwitchLightTaskView.getSize((SwitchLightTask) entity);
    }
    else

    if (entity.getClass().equals(BLeaveTask.class)) {
      vertex = new BLeaveTaskCell( (BLeaveTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BLeaveTaskView.getSize((BLeaveTask) entity);
    }
    else

    if (entity.getClass().equals(BGetUpFromBed.class)) {
      vertex = new BGetUpFromBedCell( (BGetUpFromBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGetUpFromBedView.getSize((BGetUpFromBed) entity);
    }
    else

    if (entity.getClass().equals(SwipeTask.class)) {
      vertex = new SwipeTaskCell( (SwipeTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwipeTaskView.getSize((SwipeTask) entity);
    }
    else

    if (entity.getClass().equals(BRandomTask.class)) {
      vertex = new BRandomTaskCell( (BRandomTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BRandomTaskView.getSize((BRandomTask) entity);
    }
    else

    if (entity.getClass().equals(DropObj.class)) {
      vertex = new DropObjCell( (DropObj) entity);
      // Default Size for the new Vertex with the new entity within
      size = DropObjView.getSize((DropObj) entity);
    }
    else

    if (entity.getClass().equals(PutOnTask.class)) {
      vertex = new PutOnTaskCell( (PutOnTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PutOnTaskView.getSize((PutOnTask) entity);
    }
    else

    if (entity.getClass().equals(WaitForBodyClose.class)) {
      vertex = new WaitForBodyCloseCell( (WaitForBodyClose) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitForBodyCloseView.getSize((WaitForBodyClose) entity);
    }
    else

    if (entity.getClass().equals(PlayAnimationTask.class)) {
      vertex = new PlayAnimationTaskCell( (PlayAnimationTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PlayAnimationTaskView.getSize((PlayAnimationTask) entity);
    }
    else

    if (entity.getClass().equals(FallTask.class)) {
      vertex = new FallTaskCell( (FallTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallTaskView.getSize((FallTask) entity);
    }
    else

    if (entity.getClass().equals(BUseTask.class)) {
      vertex = new BUseTaskCell( (BUseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BUseTaskView.getSize((BUseTask) entity);
    }
    else

    if (entity.getClass().equals(Eat.class)) {
      vertex = new EatCell( (Eat) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatView.getSize((Eat) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in NormDefinition diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
