

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class RandomTaskDiagramPanel extends JGraph {

  public RandomTaskDiagramPanel(RandomTaskDiagramDataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.RandomTaskDiagramCellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("ObjectVar");

 entities.add("WearableVar");

 entities.add("HumanVar");

 entities.add("DeviceVar");

 entities.add("PrimitiveVar");

 entities.add("SpatialVar");

 entities.add("SeatVar");

 entities.add("DeviceParam");

 entities.add("SeatParam");

 entities.add("ObjectParam");

 entities.add("HumanParam");

 entities.add("PrimitiveParam");

 entities.add("PlaceParam");

 entities.add("WearableParam");

 entities.add("SwipeTask");

 entities.add("GoToBodyLoc");

 entities.add("DropObj");

 entities.add("OpenTask");

 entities.add("BGoToTask");

 entities.add("SayTask");

 entities.add("TapXYTask");

 entities.add("WaitForBodyClose");

 entities.add("CloseTask");

 entities.add("FallTask");

 entities.add("SwitchLightTask");

 entities.add("BEvent");

 entities.add("TakeOffTask");

 entities.add("WaitTask");

 entities.add("BPickUpTask");

 entities.add("FallSleep");

 entities.add("Drink");

 entities.add("BWakeUpTask");

 entities.add("PutOnTask");

 entities.add("StandUp");

 entities.add("PlayAnimationTask");

 entities.add("SitDown");

 entities.add("GoIntoBed");

 entities.add("Eat");

 entities.add("BUseTask");

 entities.add("BLeaveTask");

 entities.add("BGetUpFromBed");

 entities.add("BSequentialTask");

 entities.add("BRandomTask");

 entities.add("Crutch");

 entities.add("EMedicine");

 entities.add("Shoes");

 entities.add("FOWashbasin");

 entities.add("FOSink");

 entities.add("Lift");

 entities.add("Shirt");

 entities.add("Shower");

 entities.add("FWardrobe");

 entities.add("SBathroom");

 entities.add("Human");

 entities.add("ERemoteControl");

 entities.add("ESleepers");

 entities.add("Dishwasher");

 entities.add("WashMachine");

 entities.add("EatableItem");

 entities.add("Walker");

 entities.add("Cane");

 entities.add("DComputer");

 entities.add("SCorridor");

 entities.add("SArea");

 entities.add("ESmartPhone");

 entities.add("DrinkItem");

 entities.add("FOBath");

 entities.add("Shocks");

 entities.add("Bridge");

 entities.add("EMobileDevice");

 entities.add("DTV");

 entities.add("FChair");

 entities.add("Pyjamas");

 entities.add("Staircase");

 entities.add("Doorbell");

 entities.add("Appliance");

 entities.add("SFloor");

 entities.add("Extractor");

 entities.add("SLivingroom");

 entities.add("SKitchen");

 entities.add("SBuilding");

 entities.add("SBedroom");

 entities.add("FTable");

 entities.add("Trousers");

 entities.add("FOWater");

 entities.add("EWaterBottle");

 entities.add("FBed");

 entities.add("FSofa");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("ObjectVar")) {
    ObjectVar nentity=new ObjectVar(((Model)getModel()).getNewId("ObjectVar"));
      DefaultGraphCell vertex = new
          ObjectVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WearableVar")) {
    WearableVar nentity=new WearableVar(((Model)getModel()).getNewId("WearableVar"));
      DefaultGraphCell vertex = new
          WearableVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanVar")) {
    HumanVar nentity=new HumanVar(((Model)getModel()).getNewId("HumanVar"));
      DefaultGraphCell vertex = new
          HumanVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DeviceVar")) {
    DeviceVar nentity=new DeviceVar(((Model)getModel()).getNewId("DeviceVar"));
      DefaultGraphCell vertex = new
          DeviceVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PrimitiveVar")) {
    PrimitiveVar nentity=new PrimitiveVar(((Model)getModel()).getNewId("PrimitiveVar"));
      DefaultGraphCell vertex = new
          PrimitiveVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SpatialVar")) {
    SpatialVar nentity=new SpatialVar(((Model)getModel()).getNewId("SpatialVar"));
      DefaultGraphCell vertex = new
          SpatialVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SeatVar")) {
    SeatVar nentity=new SeatVar(((Model)getModel()).getNewId("SeatVar"));
      DefaultGraphCell vertex = new
          SeatVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DeviceParam")) {
    DeviceParam nentity=new DeviceParam(((Model)getModel()).getNewId("DeviceParam"));
      DefaultGraphCell vertex = new
          DeviceParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SeatParam")) {
    SeatParam nentity=new SeatParam(((Model)getModel()).getNewId("SeatParam"));
      DefaultGraphCell vertex = new
          SeatParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ObjectParam")) {
    ObjectParam nentity=new ObjectParam(((Model)getModel()).getNewId("ObjectParam"));
      DefaultGraphCell vertex = new
          ObjectParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanParam")) {
    HumanParam nentity=new HumanParam(((Model)getModel()).getNewId("HumanParam"));
      DefaultGraphCell vertex = new
          HumanParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PrimitiveParam")) {
    PrimitiveParam nentity=new PrimitiveParam(((Model)getModel()).getNewId("PrimitiveParam"));
      DefaultGraphCell vertex = new
          PrimitiveParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PlaceParam")) {
    PlaceParam nentity=new PlaceParam(((Model)getModel()).getNewId("PlaceParam"));
      DefaultGraphCell vertex = new
          PlaceParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WearableParam")) {
    WearableParam nentity=new WearableParam(((Model)getModel()).getNewId("WearableParam"));
      DefaultGraphCell vertex = new
          WearableParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwipeTask")) {
    SwipeTask nentity=new SwipeTask(((Model)getModel()).getNewId("SwipeTask"));
      DefaultGraphCell vertex = new
          SwipeTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoToBodyLoc")) {
    GoToBodyLoc nentity=new GoToBodyLoc(((Model)getModel()).getNewId("GoToBodyLoc"));
      DefaultGraphCell vertex = new
          GoToBodyLocCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DropObj")) {
    DropObj nentity=new DropObj(((Model)getModel()).getNewId("DropObj"));
      DefaultGraphCell vertex = new
          DropObjCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("OpenTask")) {
    OpenTask nentity=new OpenTask(((Model)getModel()).getNewId("OpenTask"));
      DefaultGraphCell vertex = new
          OpenTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGoToTask")) {
    BGoToTask nentity=new BGoToTask(((Model)getModel()).getNewId("BGoToTask"));
      DefaultGraphCell vertex = new
          BGoToTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SayTask")) {
    SayTask nentity=new SayTask(((Model)getModel()).getNewId("SayTask"));
      DefaultGraphCell vertex = new
          SayTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TapXYTask")) {
    TapXYTask nentity=new TapXYTask(((Model)getModel()).getNewId("TapXYTask"));
      DefaultGraphCell vertex = new
          TapXYTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitForBodyClose")) {
    WaitForBodyClose nentity=new WaitForBodyClose(((Model)getModel()).getNewId("WaitForBodyClose"));
      DefaultGraphCell vertex = new
          WaitForBodyCloseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CloseTask")) {
    CloseTask nentity=new CloseTask(((Model)getModel()).getNewId("CloseTask"));
      DefaultGraphCell vertex = new
          CloseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallTask")) {
    FallTask nentity=new FallTask(((Model)getModel()).getNewId("FallTask"));
      DefaultGraphCell vertex = new
          FallTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SwitchLightTask")) {
    SwitchLightTask nentity=new SwitchLightTask(((Model)getModel()).getNewId("SwitchLightTask"));
      DefaultGraphCell vertex = new
          SwitchLightTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BEvent")) {
    BEvent nentity=new BEvent(((Model)getModel()).getNewId("BEvent"));
      DefaultGraphCell vertex = new
          BEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("TakeOffTask")) {
    TakeOffTask nentity=new TakeOffTask(((Model)getModel()).getNewId("TakeOffTask"));
      DefaultGraphCell vertex = new
          TakeOffTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WaitTask")) {
    WaitTask nentity=new WaitTask(((Model)getModel()).getNewId("WaitTask"));
      DefaultGraphCell vertex = new
          WaitTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BPickUpTask")) {
    BPickUpTask nentity=new BPickUpTask(((Model)getModel()).getNewId("BPickUpTask"));
      DefaultGraphCell vertex = new
          BPickUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallSleep")) {
    FallSleep nentity=new FallSleep(((Model)getModel()).getNewId("FallSleep"));
      DefaultGraphCell vertex = new
          FallSleepCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Drink")) {
    Drink nentity=new Drink(((Model)getModel()).getNewId("Drink"));
      DefaultGraphCell vertex = new
          DrinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BWakeUpTask")) {
    BWakeUpTask nentity=new BWakeUpTask(((Model)getModel()).getNewId("BWakeUpTask"));
      DefaultGraphCell vertex = new
          BWakeUpTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PutOnTask")) {
    PutOnTask nentity=new PutOnTask(((Model)getModel()).getNewId("PutOnTask"));
      DefaultGraphCell vertex = new
          PutOnTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StandUp")) {
    StandUp nentity=new StandUp(((Model)getModel()).getNewId("StandUp"));
      DefaultGraphCell vertex = new
          StandUpCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PlayAnimationTask")) {
    PlayAnimationTask nentity=new PlayAnimationTask(((Model)getModel()).getNewId("PlayAnimationTask"));
      DefaultGraphCell vertex = new
          PlayAnimationTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SitDown")) {
    SitDown nentity=new SitDown(((Model)getModel()).getNewId("SitDown"));
      DefaultGraphCell vertex = new
          SitDownCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("GoIntoBed")) {
    GoIntoBed nentity=new GoIntoBed(((Model)getModel()).getNewId("GoIntoBed"));
      DefaultGraphCell vertex = new
          GoIntoBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Eat")) {
    Eat nentity=new Eat(((Model)getModel()).getNewId("Eat"));
      DefaultGraphCell vertex = new
          EatCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BUseTask")) {
    BUseTask nentity=new BUseTask(((Model)getModel()).getNewId("BUseTask"));
      DefaultGraphCell vertex = new
          BUseTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BLeaveTask")) {
    BLeaveTask nentity=new BLeaveTask(((Model)getModel()).getNewId("BLeaveTask"));
      DefaultGraphCell vertex = new
          BLeaveTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BGetUpFromBed")) {
    BGetUpFromBed nentity=new BGetUpFromBed(((Model)getModel()).getNewId("BGetUpFromBed"));
      DefaultGraphCell vertex = new
          BGetUpFromBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BSequentialTask")) {
    BSequentialTask nentity=new BSequentialTask(((Model)getModel()).getNewId("BSequentialTask"));
      DefaultGraphCell vertex = new
          BSequentialTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BRandomTask")) {
    BRandomTask nentity=new BRandomTask(((Model)getModel()).getNewId("BRandomTask"));
      DefaultGraphCell vertex = new
          BRandomTaskCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Crutch")) {
    Crutch nentity=new Crutch(((Model)getModel()).getNewId("Crutch"));
      DefaultGraphCell vertex = new
          CrutchCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMedicine")) {
    EMedicine nentity=new EMedicine(((Model)getModel()).getNewId("EMedicine"));
      DefaultGraphCell vertex = new
          EMedicineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shoes")) {
    Shoes nentity=new Shoes(((Model)getModel()).getNewId("Shoes"));
      DefaultGraphCell vertex = new
          ShoesCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWashbasin")) {
    FOWashbasin nentity=new FOWashbasin(((Model)getModel()).getNewId("FOWashbasin"));
      DefaultGraphCell vertex = new
          FOWashbasinCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOSink")) {
    FOSink nentity=new FOSink(((Model)getModel()).getNewId("FOSink"));
      DefaultGraphCell vertex = new
          FOSinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Lift")) {
    Lift nentity=new Lift(((Model)getModel()).getNewId("Lift"));
      DefaultGraphCell vertex = new
          LiftCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shirt")) {
    Shirt nentity=new Shirt(((Model)getModel()).getNewId("Shirt"));
      DefaultGraphCell vertex = new
          ShirtCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shower")) {
    Shower nentity=new Shower(((Model)getModel()).getNewId("Shower"));
      DefaultGraphCell vertex = new
          ShowerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FWardrobe")) {
    FWardrobe nentity=new FWardrobe(((Model)getModel()).getNewId("FWardrobe"));
      DefaultGraphCell vertex = new
          FWardrobeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBathroom")) {
    SBathroom nentity=new SBathroom(((Model)getModel()).getNewId("SBathroom"));
      DefaultGraphCell vertex = new
          SBathroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=new Human(((Model)getModel()).getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ERemoteControl")) {
    ERemoteControl nentity=new ERemoteControl(((Model)getModel()).getNewId("ERemoteControl"));
      DefaultGraphCell vertex = new
          ERemoteControlCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESleepers")) {
    ESleepers nentity=new ESleepers(((Model)getModel()).getNewId("ESleepers"));
      DefaultGraphCell vertex = new
          ESleepersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Dishwasher")) {
    Dishwasher nentity=new Dishwasher(((Model)getModel()).getNewId("Dishwasher"));
      DefaultGraphCell vertex = new
          DishwasherCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WashMachine")) {
    WashMachine nentity=new WashMachine(((Model)getModel()).getNewId("WashMachine"));
      DefaultGraphCell vertex = new
          WashMachineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EatableItem")) {
    EatableItem nentity=new EatableItem(((Model)getModel()).getNewId("EatableItem"));
      DefaultGraphCell vertex = new
          EatableItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Walker")) {
    Walker nentity=new Walker(((Model)getModel()).getNewId("Walker"));
      DefaultGraphCell vertex = new
          WalkerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Cane")) {
    Cane nentity=new Cane(((Model)getModel()).getNewId("Cane"));
      DefaultGraphCell vertex = new
          CaneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DComputer")) {
    DComputer nentity=new DComputer(((Model)getModel()).getNewId("DComputer"));
      DefaultGraphCell vertex = new
          DComputerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SCorridor")) {
    SCorridor nentity=new SCorridor(((Model)getModel()).getNewId("SCorridor"));
      DefaultGraphCell vertex = new
          SCorridorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SArea")) {
    SArea nentity=new SArea(((Model)getModel()).getNewId("SArea"));
      DefaultGraphCell vertex = new
          SAreaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESmartPhone")) {
    ESmartPhone nentity=new ESmartPhone(((Model)getModel()).getNewId("ESmartPhone"));
      DefaultGraphCell vertex = new
          ESmartPhoneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DrinkItem")) {
    DrinkItem nentity=new DrinkItem(((Model)getModel()).getNewId("DrinkItem"));
      DefaultGraphCell vertex = new
          DrinkItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOBath")) {
    FOBath nentity=new FOBath(((Model)getModel()).getNewId("FOBath"));
      DefaultGraphCell vertex = new
          FOBathCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shocks")) {
    Shocks nentity=new Shocks(((Model)getModel()).getNewId("Shocks"));
      DefaultGraphCell vertex = new
          ShocksCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Bridge")) {
    Bridge nentity=new Bridge(((Model)getModel()).getNewId("Bridge"));
      DefaultGraphCell vertex = new
          BridgeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMobileDevice")) {
    EMobileDevice nentity=new EMobileDevice(((Model)getModel()).getNewId("EMobileDevice"));
      DefaultGraphCell vertex = new
          EMobileDeviceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DTV")) {
    DTV nentity=new DTV(((Model)getModel()).getNewId("DTV"));
      DefaultGraphCell vertex = new
          DTVCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FChair")) {
    FChair nentity=new FChair(((Model)getModel()).getNewId("FChair"));
      DefaultGraphCell vertex = new
          FChairCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Pyjamas")) {
    Pyjamas nentity=new Pyjamas(((Model)getModel()).getNewId("Pyjamas"));
      DefaultGraphCell vertex = new
          PyjamasCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Staircase")) {
    Staircase nentity=new Staircase(((Model)getModel()).getNewId("Staircase"));
      DefaultGraphCell vertex = new
          StaircaseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Doorbell")) {
    Doorbell nentity=new Doorbell(((Model)getModel()).getNewId("Doorbell"));
      DefaultGraphCell vertex = new
          DoorbellCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Appliance")) {
    Appliance nentity=new Appliance(((Model)getModel()).getNewId("Appliance"));
      DefaultGraphCell vertex = new
          ApplianceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SFloor")) {
    SFloor nentity=new SFloor(((Model)getModel()).getNewId("SFloor"));
      DefaultGraphCell vertex = new
          SFloorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Extractor")) {
    Extractor nentity=new Extractor(((Model)getModel()).getNewId("Extractor"));
      DefaultGraphCell vertex = new
          ExtractorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SLivingroom")) {
    SLivingroom nentity=new SLivingroom(((Model)getModel()).getNewId("SLivingroom"));
      DefaultGraphCell vertex = new
          SLivingroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SKitchen")) {
    SKitchen nentity=new SKitchen(((Model)getModel()).getNewId("SKitchen"));
      DefaultGraphCell vertex = new
          SKitchenCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBuilding")) {
    SBuilding nentity=new SBuilding(((Model)getModel()).getNewId("SBuilding"));
      DefaultGraphCell vertex = new
          SBuildingCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBedroom")) {
    SBedroom nentity=new SBedroom(((Model)getModel()).getNewId("SBedroom"));
      DefaultGraphCell vertex = new
          SBedroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FTable")) {
    FTable nentity=new FTable(((Model)getModel()).getNewId("FTable"));
      DefaultGraphCell vertex = new
          FTableCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Trousers")) {
    Trousers nentity=new Trousers(((Model)getModel()).getNewId("Trousers"));
      DefaultGraphCell vertex = new
          TrousersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWater")) {
    FOWater nentity=new FOWater(((Model)getModel()).getNewId("FOWater"));
      DefaultGraphCell vertex = new
          FOWaterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EWaterBottle")) {
    EWaterBottle nentity=new EWaterBottle(((Model)getModel()).getNewId("EWaterBottle"));
      DefaultGraphCell vertex = new
          EWaterBottleCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FBed")) {
    FBed nentity=new FBed(((Model)getModel()).getNewId("FBed"));
      DefaultGraphCell vertex = new
          FBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FSofa")) {
    FSofa nentity=new FSofa(((Model)getModel()).getNewId("FSofa"));
      DefaultGraphCell vertex = new
          FSofaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("ObjectVar")) {
      return ObjectVarView.getSize((ObjectVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WearableVar")) {
      return WearableVarView.getSize((WearableVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanVar")) {
      return HumanVarView.getSize((HumanVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DeviceVar")) {
      return DeviceVarView.getSize((DeviceVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PrimitiveVar")) {
      return PrimitiveVarView.getSize((PrimitiveVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SpatialVar")) {
      return SpatialVarView.getSize((SpatialVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SeatVar")) {
      return SeatVarView.getSize((SeatVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DeviceParam")) {
      return DeviceParamView.getSize((DeviceParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SeatParam")) {
      return SeatParamView.getSize((SeatParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ObjectParam")) {
      return ObjectParamView.getSize((ObjectParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanParam")) {
      return HumanParamView.getSize((HumanParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PrimitiveParam")) {
      return PrimitiveParamView.getSize((PrimitiveParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PlaceParam")) {
      return PlaceParamView.getSize((PlaceParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WearableParam")) {
      return WearableParamView.getSize((WearableParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwipeTask")) {
      return SwipeTaskView.getSize((SwipeTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoToBodyLoc")) {
      return GoToBodyLocView.getSize((GoToBodyLoc)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DropObj")) {
      return DropObjView.getSize((DropObj)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("OpenTask")) {
      return OpenTaskView.getSize((OpenTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGoToTask")) {
      return BGoToTaskView.getSize((BGoToTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SayTask")) {
      return SayTaskView.getSize((SayTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TapXYTask")) {
      return TapXYTaskView.getSize((TapXYTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitForBodyClose")) {
      return WaitForBodyCloseView.getSize((WaitForBodyClose)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CloseTask")) {
      return CloseTaskView.getSize((CloseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallTask")) {
      return FallTaskView.getSize((FallTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SwitchLightTask")) {
      return SwitchLightTaskView.getSize((SwitchLightTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BEvent")) {
      return BEventView.getSize((BEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("TakeOffTask")) {
      return TakeOffTaskView.getSize((TakeOffTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WaitTask")) {
      return WaitTaskView.getSize((WaitTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BPickUpTask")) {
      return BPickUpTaskView.getSize((BPickUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallSleep")) {
      return FallSleepView.getSize((FallSleep)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Drink")) {
      return DrinkView.getSize((Drink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BWakeUpTask")) {
      return BWakeUpTaskView.getSize((BWakeUpTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PutOnTask")) {
      return PutOnTaskView.getSize((PutOnTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StandUp")) {
      return StandUpView.getSize((StandUp)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PlayAnimationTask")) {
      return PlayAnimationTaskView.getSize((PlayAnimationTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SitDown")) {
      return SitDownView.getSize((SitDown)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("GoIntoBed")) {
      return GoIntoBedView.getSize((GoIntoBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Eat")) {
      return EatView.getSize((Eat)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BUseTask")) {
      return BUseTaskView.getSize((BUseTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BLeaveTask")) {
      return BLeaveTaskView.getSize((BLeaveTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BGetUpFromBed")) {
      return BGetUpFromBedView.getSize((BGetUpFromBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BSequentialTask")) {
      return BSequentialTaskView.getSize((BSequentialTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BRandomTask")) {
      return BRandomTaskView.getSize((BRandomTask)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Crutch")) {
      return CrutchView.getSize((Crutch)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMedicine")) {
      return EMedicineView.getSize((EMedicine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shoes")) {
      return ShoesView.getSize((Shoes)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWashbasin")) {
      return FOWashbasinView.getSize((FOWashbasin)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOSink")) {
      return FOSinkView.getSize((FOSink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Lift")) {
      return LiftView.getSize((Lift)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shirt")) {
      return ShirtView.getSize((Shirt)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shower")) {
      return ShowerView.getSize((Shower)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FWardrobe")) {
      return FWardrobeView.getSize((FWardrobe)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBathroom")) {
      return SBathroomView.getSize((SBathroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ERemoteControl")) {
      return ERemoteControlView.getSize((ERemoteControl)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESleepers")) {
      return ESleepersView.getSize((ESleepers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Dishwasher")) {
      return DishwasherView.getSize((Dishwasher)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WashMachine")) {
      return WashMachineView.getSize((WashMachine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EatableItem")) {
      return EatableItemView.getSize((EatableItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Walker")) {
      return WalkerView.getSize((Walker)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Cane")) {
      return CaneView.getSize((Cane)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DComputer")) {
      return DComputerView.getSize((DComputer)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SCorridor")) {
      return SCorridorView.getSize((SCorridor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SArea")) {
      return SAreaView.getSize((SArea)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESmartPhone")) {
      return ESmartPhoneView.getSize((ESmartPhone)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DrinkItem")) {
      return DrinkItemView.getSize((DrinkItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOBath")) {
      return FOBathView.getSize((FOBath)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shocks")) {
      return ShocksView.getSize((Shocks)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Bridge")) {
      return BridgeView.getSize((Bridge)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMobileDevice")) {
      return EMobileDeviceView.getSize((EMobileDevice)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DTV")) {
      return DTVView.getSize((DTV)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FChair")) {
      return FChairView.getSize((FChair)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Pyjamas")) {
      return PyjamasView.getSize((Pyjamas)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Staircase")) {
      return StaircaseView.getSize((Staircase)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Doorbell")) {
      return DoorbellView.getSize((Doorbell)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Appliance")) {
      return ApplianceView.getSize((Appliance)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SFloor")) {
      return SFloorView.getSize((SFloor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Extractor")) {
      return ExtractorView.getSize((Extractor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SLivingroom")) {
      return SLivingroomView.getSize((SLivingroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SKitchen")) {
      return SKitchenView.getSize((SKitchen)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBuilding")) {
      return SBuildingView.getSize((SBuilding)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBedroom")) {
      return SBedroomView.getSize((SBedroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FTable")) {
      return FTableView.getSize((FTable)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Trousers")) {
      return TrousersView.getSize((Trousers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWater")) {
      return FOWaterView.getSize((FOWater)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EWaterBottle")) {
      return EWaterBottleView.getSize((EWaterBottle)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FBed")) {
      return FBedView.getSize((FBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FSofa")) {
      return FSofaView.getSize((FSofa)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(ObjectVar.class)) {
      vertex = new ObjectVarCell( (ObjectVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjectVarView.getSize((ObjectVar) entity);
    }
    else

    if (entity.getClass().equals(WearableVar.class)) {
      vertex = new WearableVarCell( (WearableVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = WearableVarView.getSize((WearableVar) entity);
    }
    else

    if (entity.getClass().equals(HumanVar.class)) {
      vertex = new HumanVarCell( (HumanVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanVarView.getSize((HumanVar) entity);
    }
    else

    if (entity.getClass().equals(DeviceVar.class)) {
      vertex = new DeviceVarCell( (DeviceVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = DeviceVarView.getSize((DeviceVar) entity);
    }
    else

    if (entity.getClass().equals(PrimitiveVar.class)) {
      vertex = new PrimitiveVarCell( (PrimitiveVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = PrimitiveVarView.getSize((PrimitiveVar) entity);
    }
    else

    if (entity.getClass().equals(SpatialVar.class)) {
      vertex = new SpatialVarCell( (SpatialVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = SpatialVarView.getSize((SpatialVar) entity);
    }
    else

    if (entity.getClass().equals(SeatVar.class)) {
      vertex = new SeatVarCell( (SeatVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = SeatVarView.getSize((SeatVar) entity);
    }
    else

    if (entity.getClass().equals(DeviceParam.class)) {
      vertex = new DeviceParamCell( (DeviceParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = DeviceParamView.getSize((DeviceParam) entity);
    }
    else

    if (entity.getClass().equals(SeatParam.class)) {
      vertex = new SeatParamCell( (SeatParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = SeatParamView.getSize((SeatParam) entity);
    }
    else

    if (entity.getClass().equals(ObjectParam.class)) {
      vertex = new ObjectParamCell( (ObjectParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjectParamView.getSize((ObjectParam) entity);
    }
    else

    if (entity.getClass().equals(HumanParam.class)) {
      vertex = new HumanParamCell( (HumanParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanParamView.getSize((HumanParam) entity);
    }
    else

    if (entity.getClass().equals(PrimitiveParam.class)) {
      vertex = new PrimitiveParamCell( (PrimitiveParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = PrimitiveParamView.getSize((PrimitiveParam) entity);
    }
    else

    if (entity.getClass().equals(PlaceParam.class)) {
      vertex = new PlaceParamCell( (PlaceParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = PlaceParamView.getSize((PlaceParam) entity);
    }
    else

    if (entity.getClass().equals(WearableParam.class)) {
      vertex = new WearableParamCell( (WearableParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = WearableParamView.getSize((WearableParam) entity);
    }
    else

    if (entity.getClass().equals(SwipeTask.class)) {
      vertex = new SwipeTaskCell( (SwipeTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwipeTaskView.getSize((SwipeTask) entity);
    }
    else

    if (entity.getClass().equals(GoToBodyLoc.class)) {
      vertex = new GoToBodyLocCell( (GoToBodyLoc) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoToBodyLocView.getSize((GoToBodyLoc) entity);
    }
    else

    if (entity.getClass().equals(DropObj.class)) {
      vertex = new DropObjCell( (DropObj) entity);
      // Default Size for the new Vertex with the new entity within
      size = DropObjView.getSize((DropObj) entity);
    }
    else

    if (entity.getClass().equals(OpenTask.class)) {
      vertex = new OpenTaskCell( (OpenTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = OpenTaskView.getSize((OpenTask) entity);
    }
    else

    if (entity.getClass().equals(BGoToTask.class)) {
      vertex = new BGoToTaskCell( (BGoToTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGoToTaskView.getSize((BGoToTask) entity);
    }
    else

    if (entity.getClass().equals(SayTask.class)) {
      vertex = new SayTaskCell( (SayTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SayTaskView.getSize((SayTask) entity);
    }
    else

    if (entity.getClass().equals(TapXYTask.class)) {
      vertex = new TapXYTaskCell( (TapXYTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TapXYTaskView.getSize((TapXYTask) entity);
    }
    else

    if (entity.getClass().equals(WaitForBodyClose.class)) {
      vertex = new WaitForBodyCloseCell( (WaitForBodyClose) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitForBodyCloseView.getSize((WaitForBodyClose) entity);
    }
    else

    if (entity.getClass().equals(CloseTask.class)) {
      vertex = new CloseTaskCell( (CloseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = CloseTaskView.getSize((CloseTask) entity);
    }
    else

    if (entity.getClass().equals(FallTask.class)) {
      vertex = new FallTaskCell( (FallTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallTaskView.getSize((FallTask) entity);
    }
    else

    if (entity.getClass().equals(SwitchLightTask.class)) {
      vertex = new SwitchLightTaskCell( (SwitchLightTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = SwitchLightTaskView.getSize((SwitchLightTask) entity);
    }
    else

    if (entity.getClass().equals(BEvent.class)) {
      vertex = new BEventCell( (BEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = BEventView.getSize((BEvent) entity);
    }
    else

    if (entity.getClass().equals(TakeOffTask.class)) {
      vertex = new TakeOffTaskCell( (TakeOffTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = TakeOffTaskView.getSize((TakeOffTask) entity);
    }
    else

    if (entity.getClass().equals(WaitTask.class)) {
      vertex = new WaitTaskCell( (WaitTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = WaitTaskView.getSize((WaitTask) entity);
    }
    else

    if (entity.getClass().equals(BPickUpTask.class)) {
      vertex = new BPickUpTaskCell( (BPickUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BPickUpTaskView.getSize((BPickUpTask) entity);
    }
    else

    if (entity.getClass().equals(FallSleep.class)) {
      vertex = new FallSleepCell( (FallSleep) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallSleepView.getSize((FallSleep) entity);
    }
    else

    if (entity.getClass().equals(Drink.class)) {
      vertex = new DrinkCell( (Drink) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkView.getSize((Drink) entity);
    }
    else

    if (entity.getClass().equals(BWakeUpTask.class)) {
      vertex = new BWakeUpTaskCell( (BWakeUpTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BWakeUpTaskView.getSize((BWakeUpTask) entity);
    }
    else

    if (entity.getClass().equals(PutOnTask.class)) {
      vertex = new PutOnTaskCell( (PutOnTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PutOnTaskView.getSize((PutOnTask) entity);
    }
    else

    if (entity.getClass().equals(StandUp.class)) {
      vertex = new StandUpCell( (StandUp) entity);
      // Default Size for the new Vertex with the new entity within
      size = StandUpView.getSize((StandUp) entity);
    }
    else

    if (entity.getClass().equals(PlayAnimationTask.class)) {
      vertex = new PlayAnimationTaskCell( (PlayAnimationTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = PlayAnimationTaskView.getSize((PlayAnimationTask) entity);
    }
    else

    if (entity.getClass().equals(SitDown.class)) {
      vertex = new SitDownCell( (SitDown) entity);
      // Default Size for the new Vertex with the new entity within
      size = SitDownView.getSize((SitDown) entity);
    }
    else

    if (entity.getClass().equals(GoIntoBed.class)) {
      vertex = new GoIntoBedCell( (GoIntoBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = GoIntoBedView.getSize((GoIntoBed) entity);
    }
    else

    if (entity.getClass().equals(Eat.class)) {
      vertex = new EatCell( (Eat) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatView.getSize((Eat) entity);
    }
    else

    if (entity.getClass().equals(BUseTask.class)) {
      vertex = new BUseTaskCell( (BUseTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BUseTaskView.getSize((BUseTask) entity);
    }
    else

    if (entity.getClass().equals(BLeaveTask.class)) {
      vertex = new BLeaveTaskCell( (BLeaveTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BLeaveTaskView.getSize((BLeaveTask) entity);
    }
    else

    if (entity.getClass().equals(BGetUpFromBed.class)) {
      vertex = new BGetUpFromBedCell( (BGetUpFromBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = BGetUpFromBedView.getSize((BGetUpFromBed) entity);
    }
    else

    if (entity.getClass().equals(BSequentialTask.class)) {
      vertex = new BSequentialTaskCell( (BSequentialTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BSequentialTaskView.getSize((BSequentialTask) entity);
    }
    else

    if (entity.getClass().equals(BRandomTask.class)) {
      vertex = new BRandomTaskCell( (BRandomTask) entity);
      // Default Size for the new Vertex with the new entity within
      size = BRandomTaskView.getSize((BRandomTask) entity);
    }
    else

    if (entity.getClass().equals(Crutch.class)) {
      vertex = new CrutchCell( (Crutch) entity);
      // Default Size for the new Vertex with the new entity within
      size = CrutchView.getSize((Crutch) entity);
    }
    else

    if (entity.getClass().equals(EMedicine.class)) {
      vertex = new EMedicineCell( (EMedicine) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMedicineView.getSize((EMedicine) entity);
    }
    else

    if (entity.getClass().equals(Shoes.class)) {
      vertex = new ShoesCell( (Shoes) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShoesView.getSize((Shoes) entity);
    }
    else

    if (entity.getClass().equals(FOWashbasin.class)) {
      vertex = new FOWashbasinCell( (FOWashbasin) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWashbasinView.getSize((FOWashbasin) entity);
    }
    else

    if (entity.getClass().equals(FOSink.class)) {
      vertex = new FOSinkCell( (FOSink) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOSinkView.getSize((FOSink) entity);
    }
    else

    if (entity.getClass().equals(Lift.class)) {
      vertex = new LiftCell( (Lift) entity);
      // Default Size for the new Vertex with the new entity within
      size = LiftView.getSize((Lift) entity);
    }
    else

    if (entity.getClass().equals(Shirt.class)) {
      vertex = new ShirtCell( (Shirt) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShirtView.getSize((Shirt) entity);
    }
    else

    if (entity.getClass().equals(Shower.class)) {
      vertex = new ShowerCell( (Shower) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShowerView.getSize((Shower) entity);
    }
    else

    if (entity.getClass().equals(FWardrobe.class)) {
      vertex = new FWardrobeCell( (FWardrobe) entity);
      // Default Size for the new Vertex with the new entity within
      size = FWardrobeView.getSize((FWardrobe) entity);
    }
    else

    if (entity.getClass().equals(SBathroom.class)) {
      vertex = new SBathroomCell( (SBathroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBathroomView.getSize((SBathroom) entity);
    }
    else

    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
    }
    else

    if (entity.getClass().equals(ERemoteControl.class)) {
      vertex = new ERemoteControlCell( (ERemoteControl) entity);
      // Default Size for the new Vertex with the new entity within
      size = ERemoteControlView.getSize((ERemoteControl) entity);
    }
    else

    if (entity.getClass().equals(ESleepers.class)) {
      vertex = new ESleepersCell( (ESleepers) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESleepersView.getSize((ESleepers) entity);
    }
    else

    if (entity.getClass().equals(Dishwasher.class)) {
      vertex = new DishwasherCell( (Dishwasher) entity);
      // Default Size for the new Vertex with the new entity within
      size = DishwasherView.getSize((Dishwasher) entity);
    }
    else

    if (entity.getClass().equals(WashMachine.class)) {
      vertex = new WashMachineCell( (WashMachine) entity);
      // Default Size for the new Vertex with the new entity within
      size = WashMachineView.getSize((WashMachine) entity);
    }
    else

    if (entity.getClass().equals(EatableItem.class)) {
      vertex = new EatableItemCell( (EatableItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatableItemView.getSize((EatableItem) entity);
    }
    else

    if (entity.getClass().equals(Walker.class)) {
      vertex = new WalkerCell( (Walker) entity);
      // Default Size for the new Vertex with the new entity within
      size = WalkerView.getSize((Walker) entity);
    }
    else

    if (entity.getClass().equals(Cane.class)) {
      vertex = new CaneCell( (Cane) entity);
      // Default Size for the new Vertex with the new entity within
      size = CaneView.getSize((Cane) entity);
    }
    else

    if (entity.getClass().equals(DComputer.class)) {
      vertex = new DComputerCell( (DComputer) entity);
      // Default Size for the new Vertex with the new entity within
      size = DComputerView.getSize((DComputer) entity);
    }
    else

    if (entity.getClass().equals(SCorridor.class)) {
      vertex = new SCorridorCell( (SCorridor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SCorridorView.getSize((SCorridor) entity);
    }
    else

    if (entity.getClass().equals(SArea.class)) {
      vertex = new SAreaCell( (SArea) entity);
      // Default Size for the new Vertex with the new entity within
      size = SAreaView.getSize((SArea) entity);
    }
    else

    if (entity.getClass().equals(ESmartPhone.class)) {
      vertex = new ESmartPhoneCell( (ESmartPhone) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESmartPhoneView.getSize((ESmartPhone) entity);
    }
    else

    if (entity.getClass().equals(DrinkItem.class)) {
      vertex = new DrinkItemCell( (DrinkItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkItemView.getSize((DrinkItem) entity);
    }
    else

    if (entity.getClass().equals(FOBath.class)) {
      vertex = new FOBathCell( (FOBath) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOBathView.getSize((FOBath) entity);
    }
    else

    if (entity.getClass().equals(Shocks.class)) {
      vertex = new ShocksCell( (Shocks) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShocksView.getSize((Shocks) entity);
    }
    else

    if (entity.getClass().equals(Bridge.class)) {
      vertex = new BridgeCell( (Bridge) entity);
      // Default Size for the new Vertex with the new entity within
      size = BridgeView.getSize((Bridge) entity);
    }
    else

    if (entity.getClass().equals(EMobileDevice.class)) {
      vertex = new EMobileDeviceCell( (EMobileDevice) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMobileDeviceView.getSize((EMobileDevice) entity);
    }
    else

    if (entity.getClass().equals(DTV.class)) {
      vertex = new DTVCell( (DTV) entity);
      // Default Size for the new Vertex with the new entity within
      size = DTVView.getSize((DTV) entity);
    }
    else

    if (entity.getClass().equals(FChair.class)) {
      vertex = new FChairCell( (FChair) entity);
      // Default Size for the new Vertex with the new entity within
      size = FChairView.getSize((FChair) entity);
    }
    else

    if (entity.getClass().equals(Pyjamas.class)) {
      vertex = new PyjamasCell( (Pyjamas) entity);
      // Default Size for the new Vertex with the new entity within
      size = PyjamasView.getSize((Pyjamas) entity);
    }
    else

    if (entity.getClass().equals(Staircase.class)) {
      vertex = new StaircaseCell( (Staircase) entity);
      // Default Size for the new Vertex with the new entity within
      size = StaircaseView.getSize((Staircase) entity);
    }
    else

    if (entity.getClass().equals(Doorbell.class)) {
      vertex = new DoorbellCell( (Doorbell) entity);
      // Default Size for the new Vertex with the new entity within
      size = DoorbellView.getSize((Doorbell) entity);
    }
    else

    if (entity.getClass().equals(Appliance.class)) {
      vertex = new ApplianceCell( (Appliance) entity);
      // Default Size for the new Vertex with the new entity within
      size = ApplianceView.getSize((Appliance) entity);
    }
    else

    if (entity.getClass().equals(SFloor.class)) {
      vertex = new SFloorCell( (SFloor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SFloorView.getSize((SFloor) entity);
    }
    else

    if (entity.getClass().equals(Extractor.class)) {
      vertex = new ExtractorCell( (Extractor) entity);
      // Default Size for the new Vertex with the new entity within
      size = ExtractorView.getSize((Extractor) entity);
    }
    else

    if (entity.getClass().equals(SLivingroom.class)) {
      vertex = new SLivingroomCell( (SLivingroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SLivingroomView.getSize((SLivingroom) entity);
    }
    else

    if (entity.getClass().equals(SKitchen.class)) {
      vertex = new SKitchenCell( (SKitchen) entity);
      // Default Size for the new Vertex with the new entity within
      size = SKitchenView.getSize((SKitchen) entity);
    }
    else

    if (entity.getClass().equals(SBuilding.class)) {
      vertex = new SBuildingCell( (SBuilding) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBuildingView.getSize((SBuilding) entity);
    }
    else

    if (entity.getClass().equals(SBedroom.class)) {
      vertex = new SBedroomCell( (SBedroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBedroomView.getSize((SBedroom) entity);
    }
    else

    if (entity.getClass().equals(FTable.class)) {
      vertex = new FTableCell( (FTable) entity);
      // Default Size for the new Vertex with the new entity within
      size = FTableView.getSize((FTable) entity);
    }
    else

    if (entity.getClass().equals(Trousers.class)) {
      vertex = new TrousersCell( (Trousers) entity);
      // Default Size for the new Vertex with the new entity within
      size = TrousersView.getSize((Trousers) entity);
    }
    else

    if (entity.getClass().equals(FOWater.class)) {
      vertex = new FOWaterCell( (FOWater) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWaterView.getSize((FOWater) entity);
    }
    else

    if (entity.getClass().equals(EWaterBottle.class)) {
      vertex = new EWaterBottleCell( (EWaterBottle) entity);
      // Default Size for the new Vertex with the new entity within
      size = EWaterBottleView.getSize((EWaterBottle) entity);
    }
    else

    if (entity.getClass().equals(FBed.class)) {
      vertex = new FBedCell( (FBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = FBedView.getSize((FBed) entity);
    }
    else

    if (entity.getClass().equals(FSofa.class)) {
      vertex = new FSofaCell( (FSofa) entity);
      // Default Size for the new Vertex with the new entity within
      size = FSofaView.getSize((FSofa) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in RandomTaskDiagram diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
