

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class RoomSpecDiagramPanel extends JGraph {

  public RoomSpecDiagramPanel(RoomSpecDiagramDataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.RoomSpecDiagramCellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("SArea");

 entities.add("FOWater");

 entities.add("FOBath");

 entities.add("FTable");

 entities.add("FWardrobe");

 entities.add("Shower");

 entities.add("FBed");

 entities.add("FChair");

 entities.add("FOWashbasin");

 entities.add("FSofa");

 entities.add("FOSink");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("SArea")) {
    SArea nentity=new SArea(((Model)getModel()).getNewId("SArea"));
      DefaultGraphCell vertex = new
          SAreaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWater")) {
    FOWater nentity=new FOWater(((Model)getModel()).getNewId("FOWater"));
      DefaultGraphCell vertex = new
          FOWaterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOBath")) {
    FOBath nentity=new FOBath(((Model)getModel()).getNewId("FOBath"));
      DefaultGraphCell vertex = new
          FOBathCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FTable")) {
    FTable nentity=new FTable(((Model)getModel()).getNewId("FTable"));
      DefaultGraphCell vertex = new
          FTableCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FWardrobe")) {
    FWardrobe nentity=new FWardrobe(((Model)getModel()).getNewId("FWardrobe"));
      DefaultGraphCell vertex = new
          FWardrobeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shower")) {
    Shower nentity=new Shower(((Model)getModel()).getNewId("Shower"));
      DefaultGraphCell vertex = new
          ShowerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FBed")) {
    FBed nentity=new FBed(((Model)getModel()).getNewId("FBed"));
      DefaultGraphCell vertex = new
          FBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FChair")) {
    FChair nentity=new FChair(((Model)getModel()).getNewId("FChair"));
      DefaultGraphCell vertex = new
          FChairCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWashbasin")) {
    FOWashbasin nentity=new FOWashbasin(((Model)getModel()).getNewId("FOWashbasin"));
      DefaultGraphCell vertex = new
          FOWashbasinCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FSofa")) {
    FSofa nentity=new FSofa(((Model)getModel()).getNewId("FSofa"));
      DefaultGraphCell vertex = new
          FSofaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOSink")) {
    FOSink nentity=new FOSink(((Model)getModel()).getNewId("FOSink"));
      DefaultGraphCell vertex = new
          FOSinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("SArea")) {
      return SAreaView.getSize((SArea)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWater")) {
      return FOWaterView.getSize((FOWater)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOBath")) {
      return FOBathView.getSize((FOBath)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FTable")) {
      return FTableView.getSize((FTable)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FWardrobe")) {
      return FWardrobeView.getSize((FWardrobe)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shower")) {
      return ShowerView.getSize((Shower)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FBed")) {
      return FBedView.getSize((FBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FChair")) {
      return FChairView.getSize((FChair)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWashbasin")) {
      return FOWashbasinView.getSize((FOWashbasin)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FSofa")) {
      return FSofaView.getSize((FSofa)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOSink")) {
      return FOSinkView.getSize((FOSink)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(SArea.class)) {
      vertex = new SAreaCell( (SArea) entity);
      // Default Size for the new Vertex with the new entity within
      size = SAreaView.getSize((SArea) entity);
    }
    else

    if (entity.getClass().equals(FOWater.class)) {
      vertex = new FOWaterCell( (FOWater) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWaterView.getSize((FOWater) entity);
    }
    else

    if (entity.getClass().equals(FOBath.class)) {
      vertex = new FOBathCell( (FOBath) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOBathView.getSize((FOBath) entity);
    }
    else

    if (entity.getClass().equals(FTable.class)) {
      vertex = new FTableCell( (FTable) entity);
      // Default Size for the new Vertex with the new entity within
      size = FTableView.getSize((FTable) entity);
    }
    else

    if (entity.getClass().equals(FWardrobe.class)) {
      vertex = new FWardrobeCell( (FWardrobe) entity);
      // Default Size for the new Vertex with the new entity within
      size = FWardrobeView.getSize((FWardrobe) entity);
    }
    else

    if (entity.getClass().equals(Shower.class)) {
      vertex = new ShowerCell( (Shower) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShowerView.getSize((Shower) entity);
    }
    else

    if (entity.getClass().equals(FBed.class)) {
      vertex = new FBedCell( (FBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = FBedView.getSize((FBed) entity);
    }
    else

    if (entity.getClass().equals(FChair.class)) {
      vertex = new FChairCell( (FChair) entity);
      // Default Size for the new Vertex with the new entity within
      size = FChairView.getSize((FChair) entity);
    }
    else

    if (entity.getClass().equals(FOWashbasin.class)) {
      vertex = new FOWashbasinCell( (FOWashbasin) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWashbasinView.getSize((FOWashbasin) entity);
    }
    else

    if (entity.getClass().equals(FSofa.class)) {
      vertex = new FSofaCell( (FSofa) entity);
      // Default Size for the new Vertex with the new entity within
      size = FSofaView.getSize((FSofa) entity);
    }
    else

    if (entity.getClass().equals(FOSink.class)) {
      vertex = new FOSinkCell( (FOSink) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOSinkView.getSize((FOSink) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in RoomSpecDiagram diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
