

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class SimulationDiagramPanel extends JGraph {

  public SimulationDiagramPanel(SimulationDiagramDataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.SimulationDiagramCellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("PartOfBody");

 entities.add("InitProgramPool");

 entities.add("SymptomInitialization");

 entities.add("AndroidApplication");

 entities.add("SDate");

 entities.add("AndroidEmulator");

 entities.add("SBathroom");

 entities.add("Human");

 entities.add("FlyCamInit");

 entities.add("SKitchen");

 entities.add("SLivingroom");

 entities.add("SBedroom");

 entities.add("FTable");

 entities.add("CameraInit");

 entities.add("SCorridor");

 entities.add("SArea");

 entities.add("ESmartPhone");

 entities.add("InitialPreDefPos");

 entities.add("HumanInitialization");

 entities.add("DeviceParam");

 entities.add("SeatParam");

 entities.add("ObjectParam");

 entities.add("HumanParam");

 entities.add("PrimitiveParam");

 entities.add("PlaceParam");

 entities.add("WearableParam");

 entities.add("PDSymtom");

 entities.add("BActivity");

 entities.add("WorldInitialization");

 entities.add("Crutch");

 entities.add("EMedicine");

 entities.add("Shoes");

 entities.add("FOWashbasin");

 entities.add("FOSink");

 entities.add("Lift");

 entities.add("WearableVar");

 entities.add("Shirt");

 entities.add("Shower");

 entities.add("FWardrobe");

 entities.add("ERemoteControl");

 entities.add("ESleepers");

 entities.add("Dishwasher");

 entities.add("WashMachine");

 entities.add("EatableItem");

 entities.add("Walker");

 entities.add("Cane");

 entities.add("DComputer");

 entities.add("DrinkItem");

 entities.add("FOBath");

 entities.add("SpatialVar");

 entities.add("Shocks");

 entities.add("Bridge");

 entities.add("EMobileDevice");

 entities.add("HumanVar");

 entities.add("DTV");

 entities.add("PrimitiveVar");

 entities.add("SeatVar");

 entities.add("FChair");

 entities.add("Pyjamas");

 entities.add("Staircase");

 entities.add("Doorbell");

 entities.add("Appliance");

 entities.add("SFloor");

 entities.add("Extractor");

 entities.add("ObjectVar");

 entities.add("SBuilding");

 entities.add("Trousers");

 entities.add("FOWater");

 entities.add("EWaterBottle");

 entities.add("FBed");

 entities.add("FSofa");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("PartOfBody")) {
    PartOfBody nentity=new PartOfBody(((Model)getModel()).getNewId("PartOfBody"));
      DefaultGraphCell vertex = new
          PartOfBodyCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("InitProgramPool")) {
    InitProgramPool nentity=new InitProgramPool(((Model)getModel()).getNewId("InitProgramPool"));
      DefaultGraphCell vertex = new
          InitProgramPoolCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SymptomInitialization")) {
    SymptomInitialization nentity=new SymptomInitialization(((Model)getModel()).getNewId("SymptomInitialization"));
      DefaultGraphCell vertex = new
          SymptomInitializationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AndroidApplication")) {
    AndroidApplication nentity=new AndroidApplication(((Model)getModel()).getNewId("AndroidApplication"));
      DefaultGraphCell vertex = new
          AndroidApplicationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SDate")) {
    SDate nentity=new SDate(((Model)getModel()).getNewId("SDate"));
      DefaultGraphCell vertex = new
          SDateCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("AndroidEmulator")) {
    AndroidEmulator nentity=new AndroidEmulator(((Model)getModel()).getNewId("AndroidEmulator"));
      DefaultGraphCell vertex = new
          AndroidEmulatorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBathroom")) {
    SBathroom nentity=new SBathroom(((Model)getModel()).getNewId("SBathroom"));
      DefaultGraphCell vertex = new
          SBathroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=new Human(((Model)getModel()).getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FlyCamInit")) {
    FlyCamInit nentity=new FlyCamInit(((Model)getModel()).getNewId("FlyCamInit"));
      DefaultGraphCell vertex = new
          FlyCamInitCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SKitchen")) {
    SKitchen nentity=new SKitchen(((Model)getModel()).getNewId("SKitchen"));
      DefaultGraphCell vertex = new
          SKitchenCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SLivingroom")) {
    SLivingroom nentity=new SLivingroom(((Model)getModel()).getNewId("SLivingroom"));
      DefaultGraphCell vertex = new
          SLivingroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBedroom")) {
    SBedroom nentity=new SBedroom(((Model)getModel()).getNewId("SBedroom"));
      DefaultGraphCell vertex = new
          SBedroomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FTable")) {
    FTable nentity=new FTable(((Model)getModel()).getNewId("FTable"));
      DefaultGraphCell vertex = new
          FTableCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CameraInit")) {
    CameraInit nentity=new CameraInit(((Model)getModel()).getNewId("CameraInit"));
      DefaultGraphCell vertex = new
          CameraInitCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SCorridor")) {
    SCorridor nentity=new SCorridor(((Model)getModel()).getNewId("SCorridor"));
      DefaultGraphCell vertex = new
          SCorridorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SArea")) {
    SArea nentity=new SArea(((Model)getModel()).getNewId("SArea"));
      DefaultGraphCell vertex = new
          SAreaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESmartPhone")) {
    ESmartPhone nentity=new ESmartPhone(((Model)getModel()).getNewId("ESmartPhone"));
      DefaultGraphCell vertex = new
          ESmartPhoneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("InitialPreDefPos")) {
    InitialPreDefPos nentity=new InitialPreDefPos(((Model)getModel()).getNewId("InitialPreDefPos"));
      DefaultGraphCell vertex = new
          InitialPreDefPosCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanInitialization")) {
    HumanInitialization nentity=new HumanInitialization(((Model)getModel()).getNewId("HumanInitialization"));
      DefaultGraphCell vertex = new
          HumanInitializationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DeviceParam")) {
    DeviceParam nentity=new DeviceParam(((Model)getModel()).getNewId("DeviceParam"));
      DefaultGraphCell vertex = new
          DeviceParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SeatParam")) {
    SeatParam nentity=new SeatParam(((Model)getModel()).getNewId("SeatParam"));
      DefaultGraphCell vertex = new
          SeatParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ObjectParam")) {
    ObjectParam nentity=new ObjectParam(((Model)getModel()).getNewId("ObjectParam"));
      DefaultGraphCell vertex = new
          ObjectParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanParam")) {
    HumanParam nentity=new HumanParam(((Model)getModel()).getNewId("HumanParam"));
      DefaultGraphCell vertex = new
          HumanParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PrimitiveParam")) {
    PrimitiveParam nentity=new PrimitiveParam(((Model)getModel()).getNewId("PrimitiveParam"));
      DefaultGraphCell vertex = new
          PrimitiveParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PlaceParam")) {
    PlaceParam nentity=new PlaceParam(((Model)getModel()).getNewId("PlaceParam"));
      DefaultGraphCell vertex = new
          PlaceParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WearableParam")) {
    WearableParam nentity=new WearableParam(((Model)getModel()).getNewId("WearableParam"));
      DefaultGraphCell vertex = new
          WearableParamCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PDSymtom")) {
    PDSymtom nentity=new PDSymtom(((Model)getModel()).getNewId("PDSymtom"));
      DefaultGraphCell vertex = new
          PDSymtomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BActivity")) {
    BActivity nentity=new BActivity(((Model)getModel()).getNewId("BActivity"));
      DefaultGraphCell vertex = new
          BActivityCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WorldInitialization")) {
    WorldInitialization nentity=new WorldInitialization(((Model)getModel()).getNewId("WorldInitialization"));
      DefaultGraphCell vertex = new
          WorldInitializationCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Crutch")) {
    Crutch nentity=new Crutch(((Model)getModel()).getNewId("Crutch"));
      DefaultGraphCell vertex = new
          CrutchCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMedicine")) {
    EMedicine nentity=new EMedicine(((Model)getModel()).getNewId("EMedicine"));
      DefaultGraphCell vertex = new
          EMedicineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shoes")) {
    Shoes nentity=new Shoes(((Model)getModel()).getNewId("Shoes"));
      DefaultGraphCell vertex = new
          ShoesCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWashbasin")) {
    FOWashbasin nentity=new FOWashbasin(((Model)getModel()).getNewId("FOWashbasin"));
      DefaultGraphCell vertex = new
          FOWashbasinCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOSink")) {
    FOSink nentity=new FOSink(((Model)getModel()).getNewId("FOSink"));
      DefaultGraphCell vertex = new
          FOSinkCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Lift")) {
    Lift nentity=new Lift(((Model)getModel()).getNewId("Lift"));
      DefaultGraphCell vertex = new
          LiftCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WearableVar")) {
    WearableVar nentity=new WearableVar(((Model)getModel()).getNewId("WearableVar"));
      DefaultGraphCell vertex = new
          WearableVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shirt")) {
    Shirt nentity=new Shirt(((Model)getModel()).getNewId("Shirt"));
      DefaultGraphCell vertex = new
          ShirtCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shower")) {
    Shower nentity=new Shower(((Model)getModel()).getNewId("Shower"));
      DefaultGraphCell vertex = new
          ShowerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FWardrobe")) {
    FWardrobe nentity=new FWardrobe(((Model)getModel()).getNewId("FWardrobe"));
      DefaultGraphCell vertex = new
          FWardrobeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ERemoteControl")) {
    ERemoteControl nentity=new ERemoteControl(((Model)getModel()).getNewId("ERemoteControl"));
      DefaultGraphCell vertex = new
          ERemoteControlCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ESleepers")) {
    ESleepers nentity=new ESleepers(((Model)getModel()).getNewId("ESleepers"));
      DefaultGraphCell vertex = new
          ESleepersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Dishwasher")) {
    Dishwasher nentity=new Dishwasher(((Model)getModel()).getNewId("Dishwasher"));
      DefaultGraphCell vertex = new
          DishwasherCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("WashMachine")) {
    WashMachine nentity=new WashMachine(((Model)getModel()).getNewId("WashMachine"));
      DefaultGraphCell vertex = new
          WashMachineCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EatableItem")) {
    EatableItem nentity=new EatableItem(((Model)getModel()).getNewId("EatableItem"));
      DefaultGraphCell vertex = new
          EatableItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Walker")) {
    Walker nentity=new Walker(((Model)getModel()).getNewId("Walker"));
      DefaultGraphCell vertex = new
          WalkerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Cane")) {
    Cane nentity=new Cane(((Model)getModel()).getNewId("Cane"));
      DefaultGraphCell vertex = new
          CaneCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DComputer")) {
    DComputer nentity=new DComputer(((Model)getModel()).getNewId("DComputer"));
      DefaultGraphCell vertex = new
          DComputerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DrinkItem")) {
    DrinkItem nentity=new DrinkItem(((Model)getModel()).getNewId("DrinkItem"));
      DefaultGraphCell vertex = new
          DrinkItemCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOBath")) {
    FOBath nentity=new FOBath(((Model)getModel()).getNewId("FOBath"));
      DefaultGraphCell vertex = new
          FOBathCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SpatialVar")) {
    SpatialVar nentity=new SpatialVar(((Model)getModel()).getNewId("SpatialVar"));
      DefaultGraphCell vertex = new
          SpatialVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Shocks")) {
    Shocks nentity=new Shocks(((Model)getModel()).getNewId("Shocks"));
      DefaultGraphCell vertex = new
          ShocksCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Bridge")) {
    Bridge nentity=new Bridge(((Model)getModel()).getNewId("Bridge"));
      DefaultGraphCell vertex = new
          BridgeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EMobileDevice")) {
    EMobileDevice nentity=new EMobileDevice(((Model)getModel()).getNewId("EMobileDevice"));
      DefaultGraphCell vertex = new
          EMobileDeviceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HumanVar")) {
    HumanVar nentity=new HumanVar(((Model)getModel()).getNewId("HumanVar"));
      DefaultGraphCell vertex = new
          HumanVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("DTV")) {
    DTV nentity=new DTV(((Model)getModel()).getNewId("DTV"));
      DefaultGraphCell vertex = new
          DTVCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("PrimitiveVar")) {
    PrimitiveVar nentity=new PrimitiveVar(((Model)getModel()).getNewId("PrimitiveVar"));
      DefaultGraphCell vertex = new
          PrimitiveVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SeatVar")) {
    SeatVar nentity=new SeatVar(((Model)getModel()).getNewId("SeatVar"));
      DefaultGraphCell vertex = new
          SeatVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FChair")) {
    FChair nentity=new FChair(((Model)getModel()).getNewId("FChair"));
      DefaultGraphCell vertex = new
          FChairCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Pyjamas")) {
    Pyjamas nentity=new Pyjamas(((Model)getModel()).getNewId("Pyjamas"));
      DefaultGraphCell vertex = new
          PyjamasCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Staircase")) {
    Staircase nentity=new Staircase(((Model)getModel()).getNewId("Staircase"));
      DefaultGraphCell vertex = new
          StaircaseCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Doorbell")) {
    Doorbell nentity=new Doorbell(((Model)getModel()).getNewId("Doorbell"));
      DefaultGraphCell vertex = new
          DoorbellCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Appliance")) {
    Appliance nentity=new Appliance(((Model)getModel()).getNewId("Appliance"));
      DefaultGraphCell vertex = new
          ApplianceCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SFloor")) {
    SFloor nentity=new SFloor(((Model)getModel()).getNewId("SFloor"));
      DefaultGraphCell vertex = new
          SFloorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Extractor")) {
    Extractor nentity=new Extractor(((Model)getModel()).getNewId("Extractor"));
      DefaultGraphCell vertex = new
          ExtractorCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ObjectVar")) {
    ObjectVar nentity=new ObjectVar(((Model)getModel()).getNewId("ObjectVar"));
      DefaultGraphCell vertex = new
          ObjectVarCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SBuilding")) {
    SBuilding nentity=new SBuilding(((Model)getModel()).getNewId("SBuilding"));
      DefaultGraphCell vertex = new
          SBuildingCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Trousers")) {
    Trousers nentity=new Trousers(((Model)getModel()).getNewId("Trousers"));
      DefaultGraphCell vertex = new
          TrousersCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FOWater")) {
    FOWater nentity=new FOWater(((Model)getModel()).getNewId("FOWater"));
      DefaultGraphCell vertex = new
          FOWaterCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EWaterBottle")) {
    EWaterBottle nentity=new EWaterBottle(((Model)getModel()).getNewId("EWaterBottle"));
      DefaultGraphCell vertex = new
          EWaterBottleCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FBed")) {
    FBed nentity=new FBed(((Model)getModel()).getNewId("FBed"));
      DefaultGraphCell vertex = new
          FBedCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FSofa")) {
    FSofa nentity=new FSofa(((Model)getModel()).getNewId("FSofa"));
      DefaultGraphCell vertex = new
          FSofaCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("PartOfBody")) {
      return PartOfBodyView.getSize((PartOfBody)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("InitProgramPool")) {
      return InitProgramPoolView.getSize((InitProgramPool)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SymptomInitialization")) {
      return SymptomInitializationView.getSize((SymptomInitialization)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AndroidApplication")) {
      return AndroidApplicationView.getSize((AndroidApplication)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SDate")) {
      return SDateView.getSize((SDate)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("AndroidEmulator")) {
      return AndroidEmulatorView.getSize((AndroidEmulator)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBathroom")) {
      return SBathroomView.getSize((SBathroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FlyCamInit")) {
      return FlyCamInitView.getSize((FlyCamInit)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SKitchen")) {
      return SKitchenView.getSize((SKitchen)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SLivingroom")) {
      return SLivingroomView.getSize((SLivingroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBedroom")) {
      return SBedroomView.getSize((SBedroom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FTable")) {
      return FTableView.getSize((FTable)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CameraInit")) {
      return CameraInitView.getSize((CameraInit)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SCorridor")) {
      return SCorridorView.getSize((SCorridor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SArea")) {
      return SAreaView.getSize((SArea)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESmartPhone")) {
      return ESmartPhoneView.getSize((ESmartPhone)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("InitialPreDefPos")) {
      return InitialPreDefPosView.getSize((InitialPreDefPos)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanInitialization")) {
      return HumanInitializationView.getSize((HumanInitialization)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DeviceParam")) {
      return DeviceParamView.getSize((DeviceParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SeatParam")) {
      return SeatParamView.getSize((SeatParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ObjectParam")) {
      return ObjectParamView.getSize((ObjectParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanParam")) {
      return HumanParamView.getSize((HumanParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PrimitiveParam")) {
      return PrimitiveParamView.getSize((PrimitiveParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PlaceParam")) {
      return PlaceParamView.getSize((PlaceParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WearableParam")) {
      return WearableParamView.getSize((WearableParam)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PDSymtom")) {
      return PDSymtomView.getSize((PDSymtom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BActivity")) {
      return BActivityView.getSize((BActivity)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WorldInitialization")) {
      return WorldInitializationView.getSize((WorldInitialization)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Crutch")) {
      return CrutchView.getSize((Crutch)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMedicine")) {
      return EMedicineView.getSize((EMedicine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shoes")) {
      return ShoesView.getSize((Shoes)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWashbasin")) {
      return FOWashbasinView.getSize((FOWashbasin)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOSink")) {
      return FOSinkView.getSize((FOSink)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Lift")) {
      return LiftView.getSize((Lift)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WearableVar")) {
      return WearableVarView.getSize((WearableVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shirt")) {
      return ShirtView.getSize((Shirt)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shower")) {
      return ShowerView.getSize((Shower)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FWardrobe")) {
      return FWardrobeView.getSize((FWardrobe)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ERemoteControl")) {
      return ERemoteControlView.getSize((ERemoteControl)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ESleepers")) {
      return ESleepersView.getSize((ESleepers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Dishwasher")) {
      return DishwasherView.getSize((Dishwasher)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("WashMachine")) {
      return WashMachineView.getSize((WashMachine)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EatableItem")) {
      return EatableItemView.getSize((EatableItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Walker")) {
      return WalkerView.getSize((Walker)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Cane")) {
      return CaneView.getSize((Cane)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DComputer")) {
      return DComputerView.getSize((DComputer)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DrinkItem")) {
      return DrinkItemView.getSize((DrinkItem)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOBath")) {
      return FOBathView.getSize((FOBath)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SpatialVar")) {
      return SpatialVarView.getSize((SpatialVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Shocks")) {
      return ShocksView.getSize((Shocks)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Bridge")) {
      return BridgeView.getSize((Bridge)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EMobileDevice")) {
      return EMobileDeviceView.getSize((EMobileDevice)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HumanVar")) {
      return HumanVarView.getSize((HumanVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("DTV")) {
      return DTVView.getSize((DTV)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("PrimitiveVar")) {
      return PrimitiveVarView.getSize((PrimitiveVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SeatVar")) {
      return SeatVarView.getSize((SeatVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FChair")) {
      return FChairView.getSize((FChair)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Pyjamas")) {
      return PyjamasView.getSize((Pyjamas)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Staircase")) {
      return StaircaseView.getSize((Staircase)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Doorbell")) {
      return DoorbellView.getSize((Doorbell)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Appliance")) {
      return ApplianceView.getSize((Appliance)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SFloor")) {
      return SFloorView.getSize((SFloor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Extractor")) {
      return ExtractorView.getSize((Extractor)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ObjectVar")) {
      return ObjectVarView.getSize((ObjectVar)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SBuilding")) {
      return SBuildingView.getSize((SBuilding)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Trousers")) {
      return TrousersView.getSize((Trousers)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FOWater")) {
      return FOWaterView.getSize((FOWater)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EWaterBottle")) {
      return EWaterBottleView.getSize((EWaterBottle)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FBed")) {
      return FBedView.getSize((FBed)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FSofa")) {
      return FSofaView.getSize((FSofa)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(PartOfBody.class)) {
      vertex = new PartOfBodyCell( (PartOfBody) entity);
      // Default Size for the new Vertex with the new entity within
      size = PartOfBodyView.getSize((PartOfBody) entity);
    }
    else

    if (entity.getClass().equals(InitProgramPool.class)) {
      vertex = new InitProgramPoolCell( (InitProgramPool) entity);
      // Default Size for the new Vertex with the new entity within
      size = InitProgramPoolView.getSize((InitProgramPool) entity);
    }
    else

    if (entity.getClass().equals(SymptomInitialization.class)) {
      vertex = new SymptomInitializationCell( (SymptomInitialization) entity);
      // Default Size for the new Vertex with the new entity within
      size = SymptomInitializationView.getSize((SymptomInitialization) entity);
    }
    else

    if (entity.getClass().equals(AndroidApplication.class)) {
      vertex = new AndroidApplicationCell( (AndroidApplication) entity);
      // Default Size for the new Vertex with the new entity within
      size = AndroidApplicationView.getSize((AndroidApplication) entity);
    }
    else

    if (entity.getClass().equals(SDate.class)) {
      vertex = new SDateCell( (SDate) entity);
      // Default Size for the new Vertex with the new entity within
      size = SDateView.getSize((SDate) entity);
    }
    else

    if (entity.getClass().equals(AndroidEmulator.class)) {
      vertex = new AndroidEmulatorCell( (AndroidEmulator) entity);
      // Default Size for the new Vertex with the new entity within
      size = AndroidEmulatorView.getSize((AndroidEmulator) entity);
    }
    else

    if (entity.getClass().equals(SBathroom.class)) {
      vertex = new SBathroomCell( (SBathroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBathroomView.getSize((SBathroom) entity);
    }
    else

    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
    }
    else

    if (entity.getClass().equals(FlyCamInit.class)) {
      vertex = new FlyCamInitCell( (FlyCamInit) entity);
      // Default Size for the new Vertex with the new entity within
      size = FlyCamInitView.getSize((FlyCamInit) entity);
    }
    else

    if (entity.getClass().equals(SKitchen.class)) {
      vertex = new SKitchenCell( (SKitchen) entity);
      // Default Size for the new Vertex with the new entity within
      size = SKitchenView.getSize((SKitchen) entity);
    }
    else

    if (entity.getClass().equals(SLivingroom.class)) {
      vertex = new SLivingroomCell( (SLivingroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SLivingroomView.getSize((SLivingroom) entity);
    }
    else

    if (entity.getClass().equals(SBedroom.class)) {
      vertex = new SBedroomCell( (SBedroom) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBedroomView.getSize((SBedroom) entity);
    }
    else

    if (entity.getClass().equals(FTable.class)) {
      vertex = new FTableCell( (FTable) entity);
      // Default Size for the new Vertex with the new entity within
      size = FTableView.getSize((FTable) entity);
    }
    else

    if (entity.getClass().equals(CameraInit.class)) {
      vertex = new CameraInitCell( (CameraInit) entity);
      // Default Size for the new Vertex with the new entity within
      size = CameraInitView.getSize((CameraInit) entity);
    }
    else

    if (entity.getClass().equals(SCorridor.class)) {
      vertex = new SCorridorCell( (SCorridor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SCorridorView.getSize((SCorridor) entity);
    }
    else

    if (entity.getClass().equals(SArea.class)) {
      vertex = new SAreaCell( (SArea) entity);
      // Default Size for the new Vertex with the new entity within
      size = SAreaView.getSize((SArea) entity);
    }
    else

    if (entity.getClass().equals(ESmartPhone.class)) {
      vertex = new ESmartPhoneCell( (ESmartPhone) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESmartPhoneView.getSize((ESmartPhone) entity);
    }
    else

    if (entity.getClass().equals(InitialPreDefPos.class)) {
      vertex = new InitialPreDefPosCell( (InitialPreDefPos) entity);
      // Default Size for the new Vertex with the new entity within
      size = InitialPreDefPosView.getSize((InitialPreDefPos) entity);
    }
    else

    if (entity.getClass().equals(HumanInitialization.class)) {
      vertex = new HumanInitializationCell( (HumanInitialization) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanInitializationView.getSize((HumanInitialization) entity);
    }
    else

    if (entity.getClass().equals(DeviceParam.class)) {
      vertex = new DeviceParamCell( (DeviceParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = DeviceParamView.getSize((DeviceParam) entity);
    }
    else

    if (entity.getClass().equals(SeatParam.class)) {
      vertex = new SeatParamCell( (SeatParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = SeatParamView.getSize((SeatParam) entity);
    }
    else

    if (entity.getClass().equals(ObjectParam.class)) {
      vertex = new ObjectParamCell( (ObjectParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjectParamView.getSize((ObjectParam) entity);
    }
    else

    if (entity.getClass().equals(HumanParam.class)) {
      vertex = new HumanParamCell( (HumanParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanParamView.getSize((HumanParam) entity);
    }
    else

    if (entity.getClass().equals(PrimitiveParam.class)) {
      vertex = new PrimitiveParamCell( (PrimitiveParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = PrimitiveParamView.getSize((PrimitiveParam) entity);
    }
    else

    if (entity.getClass().equals(PlaceParam.class)) {
      vertex = new PlaceParamCell( (PlaceParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = PlaceParamView.getSize((PlaceParam) entity);
    }
    else

    if (entity.getClass().equals(WearableParam.class)) {
      vertex = new WearableParamCell( (WearableParam) entity);
      // Default Size for the new Vertex with the new entity within
      size = WearableParamView.getSize((WearableParam) entity);
    }
    else

    if (entity.getClass().equals(PDSymtom.class)) {
      vertex = new PDSymtomCell( (PDSymtom) entity);
      // Default Size for the new Vertex with the new entity within
      size = PDSymtomView.getSize((PDSymtom) entity);
    }
    else

    if (entity.getClass().equals(BActivity.class)) {
      vertex = new BActivityCell( (BActivity) entity);
      // Default Size for the new Vertex with the new entity within
      size = BActivityView.getSize((BActivity) entity);
    }
    else

    if (entity.getClass().equals(WorldInitialization.class)) {
      vertex = new WorldInitializationCell( (WorldInitialization) entity);
      // Default Size for the new Vertex with the new entity within
      size = WorldInitializationView.getSize((WorldInitialization) entity);
    }
    else

    if (entity.getClass().equals(Crutch.class)) {
      vertex = new CrutchCell( (Crutch) entity);
      // Default Size for the new Vertex with the new entity within
      size = CrutchView.getSize((Crutch) entity);
    }
    else

    if (entity.getClass().equals(EMedicine.class)) {
      vertex = new EMedicineCell( (EMedicine) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMedicineView.getSize((EMedicine) entity);
    }
    else

    if (entity.getClass().equals(Shoes.class)) {
      vertex = new ShoesCell( (Shoes) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShoesView.getSize((Shoes) entity);
    }
    else

    if (entity.getClass().equals(FOWashbasin.class)) {
      vertex = new FOWashbasinCell( (FOWashbasin) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWashbasinView.getSize((FOWashbasin) entity);
    }
    else

    if (entity.getClass().equals(FOSink.class)) {
      vertex = new FOSinkCell( (FOSink) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOSinkView.getSize((FOSink) entity);
    }
    else

    if (entity.getClass().equals(Lift.class)) {
      vertex = new LiftCell( (Lift) entity);
      // Default Size for the new Vertex with the new entity within
      size = LiftView.getSize((Lift) entity);
    }
    else

    if (entity.getClass().equals(WearableVar.class)) {
      vertex = new WearableVarCell( (WearableVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = WearableVarView.getSize((WearableVar) entity);
    }
    else

    if (entity.getClass().equals(Shirt.class)) {
      vertex = new ShirtCell( (Shirt) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShirtView.getSize((Shirt) entity);
    }
    else

    if (entity.getClass().equals(Shower.class)) {
      vertex = new ShowerCell( (Shower) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShowerView.getSize((Shower) entity);
    }
    else

    if (entity.getClass().equals(FWardrobe.class)) {
      vertex = new FWardrobeCell( (FWardrobe) entity);
      // Default Size for the new Vertex with the new entity within
      size = FWardrobeView.getSize((FWardrobe) entity);
    }
    else

    if (entity.getClass().equals(ERemoteControl.class)) {
      vertex = new ERemoteControlCell( (ERemoteControl) entity);
      // Default Size for the new Vertex with the new entity within
      size = ERemoteControlView.getSize((ERemoteControl) entity);
    }
    else

    if (entity.getClass().equals(ESleepers.class)) {
      vertex = new ESleepersCell( (ESleepers) entity);
      // Default Size for the new Vertex with the new entity within
      size = ESleepersView.getSize((ESleepers) entity);
    }
    else

    if (entity.getClass().equals(Dishwasher.class)) {
      vertex = new DishwasherCell( (Dishwasher) entity);
      // Default Size for the new Vertex with the new entity within
      size = DishwasherView.getSize((Dishwasher) entity);
    }
    else

    if (entity.getClass().equals(WashMachine.class)) {
      vertex = new WashMachineCell( (WashMachine) entity);
      // Default Size for the new Vertex with the new entity within
      size = WashMachineView.getSize((WashMachine) entity);
    }
    else

    if (entity.getClass().equals(EatableItem.class)) {
      vertex = new EatableItemCell( (EatableItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = EatableItemView.getSize((EatableItem) entity);
    }
    else

    if (entity.getClass().equals(Walker.class)) {
      vertex = new WalkerCell( (Walker) entity);
      // Default Size for the new Vertex with the new entity within
      size = WalkerView.getSize((Walker) entity);
    }
    else

    if (entity.getClass().equals(Cane.class)) {
      vertex = new CaneCell( (Cane) entity);
      // Default Size for the new Vertex with the new entity within
      size = CaneView.getSize((Cane) entity);
    }
    else

    if (entity.getClass().equals(DComputer.class)) {
      vertex = new DComputerCell( (DComputer) entity);
      // Default Size for the new Vertex with the new entity within
      size = DComputerView.getSize((DComputer) entity);
    }
    else

    if (entity.getClass().equals(DrinkItem.class)) {
      vertex = new DrinkItemCell( (DrinkItem) entity);
      // Default Size for the new Vertex with the new entity within
      size = DrinkItemView.getSize((DrinkItem) entity);
    }
    else

    if (entity.getClass().equals(FOBath.class)) {
      vertex = new FOBathCell( (FOBath) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOBathView.getSize((FOBath) entity);
    }
    else

    if (entity.getClass().equals(SpatialVar.class)) {
      vertex = new SpatialVarCell( (SpatialVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = SpatialVarView.getSize((SpatialVar) entity);
    }
    else

    if (entity.getClass().equals(Shocks.class)) {
      vertex = new ShocksCell( (Shocks) entity);
      // Default Size for the new Vertex with the new entity within
      size = ShocksView.getSize((Shocks) entity);
    }
    else

    if (entity.getClass().equals(Bridge.class)) {
      vertex = new BridgeCell( (Bridge) entity);
      // Default Size for the new Vertex with the new entity within
      size = BridgeView.getSize((Bridge) entity);
    }
    else

    if (entity.getClass().equals(EMobileDevice.class)) {
      vertex = new EMobileDeviceCell( (EMobileDevice) entity);
      // Default Size for the new Vertex with the new entity within
      size = EMobileDeviceView.getSize((EMobileDevice) entity);
    }
    else

    if (entity.getClass().equals(HumanVar.class)) {
      vertex = new HumanVarCell( (HumanVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanVarView.getSize((HumanVar) entity);
    }
    else

    if (entity.getClass().equals(DTV.class)) {
      vertex = new DTVCell( (DTV) entity);
      // Default Size for the new Vertex with the new entity within
      size = DTVView.getSize((DTV) entity);
    }
    else

    if (entity.getClass().equals(PrimitiveVar.class)) {
      vertex = new PrimitiveVarCell( (PrimitiveVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = PrimitiveVarView.getSize((PrimitiveVar) entity);
    }
    else

    if (entity.getClass().equals(SeatVar.class)) {
      vertex = new SeatVarCell( (SeatVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = SeatVarView.getSize((SeatVar) entity);
    }
    else

    if (entity.getClass().equals(FChair.class)) {
      vertex = new FChairCell( (FChair) entity);
      // Default Size for the new Vertex with the new entity within
      size = FChairView.getSize((FChair) entity);
    }
    else

    if (entity.getClass().equals(Pyjamas.class)) {
      vertex = new PyjamasCell( (Pyjamas) entity);
      // Default Size for the new Vertex with the new entity within
      size = PyjamasView.getSize((Pyjamas) entity);
    }
    else

    if (entity.getClass().equals(Staircase.class)) {
      vertex = new StaircaseCell( (Staircase) entity);
      // Default Size for the new Vertex with the new entity within
      size = StaircaseView.getSize((Staircase) entity);
    }
    else

    if (entity.getClass().equals(Doorbell.class)) {
      vertex = new DoorbellCell( (Doorbell) entity);
      // Default Size for the new Vertex with the new entity within
      size = DoorbellView.getSize((Doorbell) entity);
    }
    else

    if (entity.getClass().equals(Appliance.class)) {
      vertex = new ApplianceCell( (Appliance) entity);
      // Default Size for the new Vertex with the new entity within
      size = ApplianceView.getSize((Appliance) entity);
    }
    else

    if (entity.getClass().equals(SFloor.class)) {
      vertex = new SFloorCell( (SFloor) entity);
      // Default Size for the new Vertex with the new entity within
      size = SFloorView.getSize((SFloor) entity);
    }
    else

    if (entity.getClass().equals(Extractor.class)) {
      vertex = new ExtractorCell( (Extractor) entity);
      // Default Size for the new Vertex with the new entity within
      size = ExtractorView.getSize((Extractor) entity);
    }
    else

    if (entity.getClass().equals(ObjectVar.class)) {
      vertex = new ObjectVarCell( (ObjectVar) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjectVarView.getSize((ObjectVar) entity);
    }
    else

    if (entity.getClass().equals(SBuilding.class)) {
      vertex = new SBuildingCell( (SBuilding) entity);
      // Default Size for the new Vertex with the new entity within
      size = SBuildingView.getSize((SBuilding) entity);
    }
    else

    if (entity.getClass().equals(Trousers.class)) {
      vertex = new TrousersCell( (Trousers) entity);
      // Default Size for the new Vertex with the new entity within
      size = TrousersView.getSize((Trousers) entity);
    }
    else

    if (entity.getClass().equals(FOWater.class)) {
      vertex = new FOWaterCell( (FOWater) entity);
      // Default Size for the new Vertex with the new entity within
      size = FOWaterView.getSize((FOWater) entity);
    }
    else

    if (entity.getClass().equals(EWaterBottle.class)) {
      vertex = new EWaterBottleCell( (EWaterBottle) entity);
      // Default Size for the new Vertex with the new entity within
      size = EWaterBottleView.getSize((EWaterBottle) entity);
    }
    else

    if (entity.getClass().equals(FBed.class)) {
      vertex = new FBedCell( (FBed) entity);
      // Default Size for the new Vertex with the new entity within
      size = FBedView.getSize((FBed) entity);
    }
    else

    if (entity.getClass().equals(FSofa.class)) {
      vertex = new FSofaCell( (FSofa) entity);
      // Default Size for the new Vertex with the new entity within
      size = FSofaView.getSize((FSofa) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in SimulationDiagram diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
