

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes and Juan Pavon
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.panels;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.Map;
import java.util.Hashtable;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.swing.event.UndoableEditEvent;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.jgraph.event.*;
import org.jgraph.plaf.basic.*;
import ingenias.editor.entities.*;
import ingenias.editor.cell.*;
import ingenias.editor.events.*;
import ingenias.exception.InvalidEntity;
import ingenias.editor.*;

public class SymptomEvolutionDiagramPanel extends JGraph {

  public SymptomEvolutionDiagramPanel(SymptomEvolutionDiagramDataEntity mde, 
                               String nombre, Model
                               m, BasicMarqueeHandler mh) {
    super(m, mh);
    
    this.getGraphLayoutCache().setFactory(new ingenias.editor.cellfactories.SymptomEvolutionDiagramCellViewFactory());
  }


  //
  // Adding Tooltips
  //

  // Return Cell Label as a Tooltip
  public String getToolTipText(MouseEvent e) {
    if (e != null) {
      // Fetch Cell under Mousepointer
      Object c = getFirstCellForLocation(e.getX(), e.getY());
      if (c != null) {

        // Convert Cell to String and Return
        return convertValueToString(c);
      }
    }
    return null;
  }

  public static Vector<String> getAllowedEntities(){
   Vector<String> entities=new   Vector<String>();


 entities.add("LOWSympLevelState");

 entities.add("CAlways");

 entities.add("CSymptom");

 entities.add("CTime");

 entities.add("CTimer");

 entities.add("CInside");

 entities.add("MEDIUMSympLevelState");

 entities.add("BodyStateCondition");

 entities.add("CProb");

 entities.add("CEvent");

 entities.add("NONESympLevelState");

 entities.add("HIGHSympLevelState");

 entities.add("COutside");

 entities.add("CDayOfTheWeek");

 entities.add("Human");

 entities.add("SymptomChangedEvent");

 entities.add("MedsTakenEvent");

 entities.add("MessageListenedEvent");

 entities.add("StartBehaviourEvent");

 entities.add("EPrivateEvent");

 entities.add("CallStateEvent");

 entities.add("FallingEvent");

 entities.add("StopBehaviourEvent");

 entities.add("VibrateEvent");

 entities.add("BEvent");

 entities.add("ObjDroppedEvent");

   return entities;
  }

 
   
  public DefaultGraphCell createCell(String entity) throws InvalidEntity{
  
    if (entity.equalsIgnoreCase("LOWSympLevelState")) {
    LOWSympLevelState nentity=new LOWSympLevelState(((Model)getModel()).getNewId("LOWSympLevelState"));
      DefaultGraphCell vertex = new
          LOWSympLevelStateCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CAlways")) {
    CAlways nentity=new CAlways(((Model)getModel()).getNewId("CAlways"));
      DefaultGraphCell vertex = new
          CAlwaysCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CSymptom")) {
    CSymptom nentity=new CSymptom(((Model)getModel()).getNewId("CSymptom"));
      DefaultGraphCell vertex = new
          CSymptomCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CTime")) {
    CTime nentity=new CTime(((Model)getModel()).getNewId("CTime"));
      DefaultGraphCell vertex = new
          CTimeCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CTimer")) {
    CTimer nentity=new CTimer(((Model)getModel()).getNewId("CTimer"));
      DefaultGraphCell vertex = new
          CTimerCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CInside")) {
    CInside nentity=new CInside(((Model)getModel()).getNewId("CInside"));
      DefaultGraphCell vertex = new
          CInsideCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("MEDIUMSympLevelState")) {
    MEDIUMSympLevelState nentity=new MEDIUMSympLevelState(((Model)getModel()).getNewId("MEDIUMSympLevelState"));
      DefaultGraphCell vertex = new
          MEDIUMSympLevelStateCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BodyStateCondition")) {
    BodyStateCondition nentity=new BodyStateCondition(((Model)getModel()).getNewId("BodyStateCondition"));
      DefaultGraphCell vertex = new
          BodyStateConditionCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CProb")) {
    CProb nentity=new CProb(((Model)getModel()).getNewId("CProb"));
      DefaultGraphCell vertex = new
          CProbCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CEvent")) {
    CEvent nentity=new CEvent(((Model)getModel()).getNewId("CEvent"));
      DefaultGraphCell vertex = new
          CEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("NONESympLevelState")) {
    NONESympLevelState nentity=new NONESympLevelState(((Model)getModel()).getNewId("NONESympLevelState"));
      DefaultGraphCell vertex = new
          NONESympLevelStateCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("HIGHSympLevelState")) {
    HIGHSympLevelState nentity=new HIGHSympLevelState(((Model)getModel()).getNewId("HIGHSympLevelState"));
      DefaultGraphCell vertex = new
          HIGHSympLevelStateCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("COutside")) {
    COutside nentity=new COutside(((Model)getModel()).getNewId("COutside"));
      DefaultGraphCell vertex = new
          COutsideCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CDayOfTheWeek")) {
    CDayOfTheWeek nentity=new CDayOfTheWeek(((Model)getModel()).getNewId("CDayOfTheWeek"));
      DefaultGraphCell vertex = new
          CDayOfTheWeekCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("Human")) {
    Human nentity=new Human(((Model)getModel()).getNewId("Human"));
      DefaultGraphCell vertex = new
          HumanCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("SymptomChangedEvent")) {
    SymptomChangedEvent nentity=new SymptomChangedEvent(((Model)getModel()).getNewId("SymptomChangedEvent"));
      DefaultGraphCell vertex = new
          SymptomChangedEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("MedsTakenEvent")) {
    MedsTakenEvent nentity=new MedsTakenEvent(((Model)getModel()).getNewId("MedsTakenEvent"));
      DefaultGraphCell vertex = new
          MedsTakenEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("MessageListenedEvent")) {
    MessageListenedEvent nentity=new MessageListenedEvent(((Model)getModel()).getNewId("MessageListenedEvent"));
      DefaultGraphCell vertex = new
          MessageListenedEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StartBehaviourEvent")) {
    StartBehaviourEvent nentity=new StartBehaviourEvent(((Model)getModel()).getNewId("StartBehaviourEvent"));
      DefaultGraphCell vertex = new
          StartBehaviourEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("EPrivateEvent")) {
    EPrivateEvent nentity=new EPrivateEvent(((Model)getModel()).getNewId("EPrivateEvent"));
      DefaultGraphCell vertex = new
          EPrivateEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("CallStateEvent")) {
    CallStateEvent nentity=new CallStateEvent(((Model)getModel()).getNewId("CallStateEvent"));
      DefaultGraphCell vertex = new
          CallStateEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("FallingEvent")) {
    FallingEvent nentity=new FallingEvent(((Model)getModel()).getNewId("FallingEvent"));
      DefaultGraphCell vertex = new
          FallingEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("StopBehaviourEvent")) {
    StopBehaviourEvent nentity=new StopBehaviourEvent(((Model)getModel()).getNewId("StopBehaviourEvent"));
      DefaultGraphCell vertex = new
          StopBehaviourEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("VibrateEvent")) {
    VibrateEvent nentity=new VibrateEvent(((Model)getModel()).getNewId("VibrateEvent"));
      DefaultGraphCell vertex = new
          VibrateEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("BEvent")) {
    BEvent nentity=new BEvent(((Model)getModel()).getNewId("BEvent"));
      DefaultGraphCell vertex = new
          BEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

    if (entity.equalsIgnoreCase("ObjDroppedEvent")) {
    ObjDroppedEvent nentity=new ObjDroppedEvent(((Model)getModel()).getNewId("ObjDroppedEvent"));
      DefaultGraphCell vertex = new
          ObjDroppedEventCell(nentity);
      // Default Size for the cell with the new entity
     return vertex;
    }
    else

	  throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
  }
  
  public Dimension getDefaultSize(Entity entity) throws InvalidEntity{
    
    if (entity.getType().equalsIgnoreCase("LOWSympLevelState")) {
      return LOWSympLevelStateView.getSize((LOWSympLevelState)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CAlways")) {
      return CAlwaysView.getSize((CAlways)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CSymptom")) {
      return CSymptomView.getSize((CSymptom)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CTime")) {
      return CTimeView.getSize((CTime)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CTimer")) {
      return CTimerView.getSize((CTimer)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CInside")) {
      return CInsideView.getSize((CInside)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("MEDIUMSympLevelState")) {
      return MEDIUMSympLevelStateView.getSize((MEDIUMSympLevelState)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BodyStateCondition")) {
      return BodyStateConditionView.getSize((BodyStateCondition)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CProb")) {
      return CProbView.getSize((CProb)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CEvent")) {
      return CEventView.getSize((CEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("NONESympLevelState")) {
      return NONESympLevelStateView.getSize((NONESympLevelState)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("HIGHSympLevelState")) {
      return HIGHSympLevelStateView.getSize((HIGHSympLevelState)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("COutside")) {
      return COutsideView.getSize((COutside)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CDayOfTheWeek")) {
      return CDayOfTheWeekView.getSize((CDayOfTheWeek)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("Human")) {
      return HumanView.getSize((Human)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("SymptomChangedEvent")) {
      return SymptomChangedEventView.getSize((SymptomChangedEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("MedsTakenEvent")) {
      return MedsTakenEventView.getSize((MedsTakenEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("MessageListenedEvent")) {
      return MessageListenedEventView.getSize((MessageListenedEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StartBehaviourEvent")) {
      return StartBehaviourEventView.getSize((StartBehaviourEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("EPrivateEvent")) {
      return EPrivateEventView.getSize((EPrivateEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("CallStateEvent")) {
      return CallStateEventView.getSize((CallStateEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("FallingEvent")) {
      return FallingEventView.getSize((FallingEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("StopBehaviourEvent")) {
      return StopBehaviourEventView.getSize((StopBehaviourEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("VibrateEvent")) {
      return VibrateEventView.getSize((VibrateEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("BEvent")) {
      return BEventView.getSize((BEvent)entity);      
    }
    else

    if (entity.getType().equalsIgnoreCase("ObjDroppedEvent")) {
      return ObjDroppedEventView.getSize((ObjDroppedEvent)entity);      
    }
    else

    throw new ingenias.exception.InvalidEntity("Entity type "+entity+" is not allowed in this diagram"); 
	    
  }

  public DefaultGraphCell insert(Point point, String entity) throws InvalidEntity {
  // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map = new Hashtable();
    // Snap the Point to the Grid
    
    // Construct Vertex with no Label
    DefaultGraphCell vertex;
    Dimension size;

    vertex=this.createCell(entity);
    size=this.getDefaultSize((Entity)vertex.getUserObject());



    // Add a Bounds Attribute to the Map
    GraphConstants.setBounds(map, new Rectangle(point, size));

    // Construct a Map from cells to Maps (for insert)
    Hashtable attributes = new Hashtable();
    // Associate the Vertex with its Attributes
    attributes.put(vertex, map);
    // Insert the Vertex and its Attributes
    this.getModel().insert(new Object[] {vertex},attributes
                           , null, null, null);
    return vertex;
  }

  


public DefaultGraphCell insertDuplicated(Point point, ingenias.editor.entities.Entity
                               entity) {
    // CellView information is not available after creating the cell.

    // Create a Map that holds the attributes for the Vertex
    Map map =new Hashtable();
    // Snap the Point to the Grid
      

    // Construct Vertex with no Label
    DefaultGraphCell vertex = null;
    Dimension size = null;


    if (entity.getClass().equals(LOWSympLevelState.class)) {
      vertex = new LOWSympLevelStateCell( (LOWSympLevelState) entity);
      // Default Size for the new Vertex with the new entity within
      size = LOWSympLevelStateView.getSize((LOWSympLevelState) entity);
    }
    else

    if (entity.getClass().equals(CAlways.class)) {
      vertex = new CAlwaysCell( (CAlways) entity);
      // Default Size for the new Vertex with the new entity within
      size = CAlwaysView.getSize((CAlways) entity);
    }
    else

    if (entity.getClass().equals(CSymptom.class)) {
      vertex = new CSymptomCell( (CSymptom) entity);
      // Default Size for the new Vertex with the new entity within
      size = CSymptomView.getSize((CSymptom) entity);
    }
    else

    if (entity.getClass().equals(CTime.class)) {
      vertex = new CTimeCell( (CTime) entity);
      // Default Size for the new Vertex with the new entity within
      size = CTimeView.getSize((CTime) entity);
    }
    else

    if (entity.getClass().equals(CTimer.class)) {
      vertex = new CTimerCell( (CTimer) entity);
      // Default Size for the new Vertex with the new entity within
      size = CTimerView.getSize((CTimer) entity);
    }
    else

    if (entity.getClass().equals(CInside.class)) {
      vertex = new CInsideCell( (CInside) entity);
      // Default Size for the new Vertex with the new entity within
      size = CInsideView.getSize((CInside) entity);
    }
    else

    if (entity.getClass().equals(MEDIUMSympLevelState.class)) {
      vertex = new MEDIUMSympLevelStateCell( (MEDIUMSympLevelState) entity);
      // Default Size for the new Vertex with the new entity within
      size = MEDIUMSympLevelStateView.getSize((MEDIUMSympLevelState) entity);
    }
    else

    if (entity.getClass().equals(BodyStateCondition.class)) {
      vertex = new BodyStateConditionCell( (BodyStateCondition) entity);
      // Default Size for the new Vertex with the new entity within
      size = BodyStateConditionView.getSize((BodyStateCondition) entity);
    }
    else

    if (entity.getClass().equals(CProb.class)) {
      vertex = new CProbCell( (CProb) entity);
      // Default Size for the new Vertex with the new entity within
      size = CProbView.getSize((CProb) entity);
    }
    else

    if (entity.getClass().equals(CEvent.class)) {
      vertex = new CEventCell( (CEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = CEventView.getSize((CEvent) entity);
    }
    else

    if (entity.getClass().equals(NONESympLevelState.class)) {
      vertex = new NONESympLevelStateCell( (NONESympLevelState) entity);
      // Default Size for the new Vertex with the new entity within
      size = NONESympLevelStateView.getSize((NONESympLevelState) entity);
    }
    else

    if (entity.getClass().equals(HIGHSympLevelState.class)) {
      vertex = new HIGHSympLevelStateCell( (HIGHSympLevelState) entity);
      // Default Size for the new Vertex with the new entity within
      size = HIGHSympLevelStateView.getSize((HIGHSympLevelState) entity);
    }
    else

    if (entity.getClass().equals(COutside.class)) {
      vertex = new COutsideCell( (COutside) entity);
      // Default Size for the new Vertex with the new entity within
      size = COutsideView.getSize((COutside) entity);
    }
    else

    if (entity.getClass().equals(CDayOfTheWeek.class)) {
      vertex = new CDayOfTheWeekCell( (CDayOfTheWeek) entity);
      // Default Size for the new Vertex with the new entity within
      size = CDayOfTheWeekView.getSize((CDayOfTheWeek) entity);
    }
    else

    if (entity.getClass().equals(Human.class)) {
      vertex = new HumanCell( (Human) entity);
      // Default Size for the new Vertex with the new entity within
      size = HumanView.getSize((Human) entity);
    }
    else

    if (entity.getClass().equals(SymptomChangedEvent.class)) {
      vertex = new SymptomChangedEventCell( (SymptomChangedEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = SymptomChangedEventView.getSize((SymptomChangedEvent) entity);
    }
    else

    if (entity.getClass().equals(MedsTakenEvent.class)) {
      vertex = new MedsTakenEventCell( (MedsTakenEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = MedsTakenEventView.getSize((MedsTakenEvent) entity);
    }
    else

    if (entity.getClass().equals(MessageListenedEvent.class)) {
      vertex = new MessageListenedEventCell( (MessageListenedEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = MessageListenedEventView.getSize((MessageListenedEvent) entity);
    }
    else

    if (entity.getClass().equals(StartBehaviourEvent.class)) {
      vertex = new StartBehaviourEventCell( (StartBehaviourEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = StartBehaviourEventView.getSize((StartBehaviourEvent) entity);
    }
    else

    if (entity.getClass().equals(EPrivateEvent.class)) {
      vertex = new EPrivateEventCell( (EPrivateEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = EPrivateEventView.getSize((EPrivateEvent) entity);
    }
    else

    if (entity.getClass().equals(CallStateEvent.class)) {
      vertex = new CallStateEventCell( (CallStateEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = CallStateEventView.getSize((CallStateEvent) entity);
    }
    else

    if (entity.getClass().equals(FallingEvent.class)) {
      vertex = new FallingEventCell( (FallingEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = FallingEventView.getSize((FallingEvent) entity);
    }
    else

    if (entity.getClass().equals(StopBehaviourEvent.class)) {
      vertex = new StopBehaviourEventCell( (StopBehaviourEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = StopBehaviourEventView.getSize((StopBehaviourEvent) entity);
    }
    else

    if (entity.getClass().equals(VibrateEvent.class)) {
      vertex = new VibrateEventCell( (VibrateEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = VibrateEventView.getSize((VibrateEvent) entity);
    }
    else

    if (entity.getClass().equals(BEvent.class)) {
      vertex = new BEventCell( (BEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = BEventView.getSize((BEvent) entity);
    }
    else

    if (entity.getClass().equals(ObjDroppedEvent.class)) {
      vertex = new ObjDroppedEventCell( (ObjDroppedEvent) entity);
      // Default Size for the new Vertex with the new entity within
      size = ObjDroppedEventView.getSize((ObjDroppedEvent) entity);
    }
    else

   {}; // Just in case there is no allowed entity in the diagram

    if (vertex == null) {
     System.err.println(
		 "Object not allowed in SymptomEvolutionDiagram diagram :"+ 
		 entity.getId()+":"+entity.getClass().getName()+
		 this.getClass().getName());    }
    else {

      // Add a Bounds Attribute to the Map
      GraphConstants.setBounds(map, new Rectangle(point, size));

      // Construct a Map from cells to Maps (for insert)
      Hashtable attributes = new Hashtable();
      // Associate the Vertex with its Attributes
      attributes.put(vertex, map);
      // Insert the Vertex and its Attributes
      this.getModel().insert(new Object[] {vertex},attributes
                             , null, null, null);
    }
   return vertex;

  }


}
