

/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.persistence;

import java.lang.reflect.*;
import javax.swing.tree.*;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.InputSource;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.OutputStreamWriter;
import java.io.*;
import javax.swing.tree.DefaultMutableTreeNode;
import java.util.*;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.xml.parsers.*;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.w3c.dom.*;
import org.w3c.dom.Document;
import org.w3c.dom.DOMImplementation;
import ingenias.editor.entities.*;
import ingenias.exception.*;
import ingenias.editor.cell.*;
import ingenias.editor.*;


public class GraphLoadImp1
    implements GraphLoad {

  /**
   *  Constructor for the GraphLoad object
   */
  public GraphLoadImp1() {}

  
  private ModelJGraph fromGXL(ObjectManager om, RelationshipManager rm,
                              ModelJGraph graph, org.w3c.dom.Node node, org.w3c.dom.Node nodeView) {
    try {

      // Get Graph's Child Nodes (the cells)
      NodeList list = node.getChildNodes();
      // Get Graph's Child Nodes (the views)
      NodeList listView = nodeView.getChildNodes();
      // ConnectionSet for the Insert method
      ConnectionSet cs = new ConnectionSet();
      // Hashtable for the ID lookup (ID to Vertex)
      Hashtable ids = new Hashtable();
      // Hashtable for Attributes (Vertex to Map)
      Hashtable attributes = new Hashtable();
      Vector edges = new Vector();
      Vector edgesAttr = new Vector();
      // Loop Children
      for (int i = 0; i < list.getLength(); i++) {
        // The order is the same in both trees.
        node = list.item(i);
        nodeView = listView.item(i);
        // If Valid Node
        if (node.getAttributes() != null && node.getNodeName() != null) {
          // Fetch Supertype
          String supertype = (String) node.getNodeName();
          // Create Vertex
          if (supertype.equals("node")) {
            String id = node.getAttributes().getNamedItem("id").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").
                getNodeValue();
            DefaultGraphCell vertex = GXLVertex(id, type, graph, om, rm);
            if ( (vertex != null) && ! (vertex instanceof NAryEdge)) {
              // Add ID, Vertex pair to Hashtable
              if (node.getAttributes().getNamedItem("nid") != null) {
                ids.put(node.getAttributes().getNamedItem("nid").getNodeValue(),
                        vertex);
              }
              else {
                ids.put(node.getAttributes().getNamedItem("id").getNodeValue(),
                        vertex);
                // Add Attributes
              }
              Map vertexAttr = GXLCellView(graph, vertex, ids, nodeView);
              attributes.put(vertex, vertexAttr);
              // Add Vertex to new Cells
              graph.getModel().insert(new Object[] {vertex},attributes,
                                       cs, null, null);
//              Log.getInstance().logSYS("loaded " + vertex.getUserObject());
            }
            else {
              if (vertex != null && (vertex instanceof NAryEdge)) {
                edges.add(vertex);
                Vector idscon = getConnectedEntities(node);
                Map vertexAttr = GXLCellView(graph, vertex, ids, nodeView);
                edgesAttr.add(vertexAttr);
                edgesAttr.add(idscon);

              }
            }
            // Create Edge
          }
        }
      }
      Enumeration enumeration = edges.elements();
      Enumeration enumeration1 = edgesAttr.elements();
      while (enumeration.hasMoreElements()) {
        NAryEdge ne = (NAryEdge) enumeration.nextElement();
        NAryEdgeEntity ent = (NAryEdgeEntity) ne.getUserObject();
        Map eas = (Map) enumeration1.nextElement();
        Vector idscon = ( (Vector) enumeration1.nextElement());
        DefaultGraphCell gcs[] = null;
        if (idscon.size() > 0) {
          String[] idEnts = ent.getIds();
          gcs = new DefaultGraphCell[idscon.size()];

          for (int k = 0; k < idscon.size(); k++) {
            String id = idscon.elementAt(k).toString();
            gcs[k] = (DefaultGraphCell) ids.get(id);
            //this.getGraphCell(graph,id);

          }
        }
        else {
          String[] idEnts = ent.getIds();
          gcs = new DefaultGraphCell[idEnts.length];

          for (int k = 0; k < idEnts.length; k++) {
            String id = idEnts[k];
            gcs[k] = this.getGraphCell(graph, id);

          }
        }

        this.connect(graph, gcs, ne, eas);
      }
      return graph;
    }
    catch (Exception e) {
      // Display error message on stderr
      e.printStackTrace();
      return null;
    }
  }

  // Convert an CellView represented by a GXL DOM node in a Map.
  // cell is the GraphCell represented by the returned CellView.
  // ids has a mapping from id to vertex.
  
  private Map GXLCellView(JGraph graph, GraphCell cell, Map ids, org.w3c.dom.Node node) {

    // Fetch Map attributes.
    Hashtable attrMap = getMap(node);
    // The id attribute is not appliable.
    attrMap.remove("id");

    attrMap.remove("icon");

    if (attrMap.containsKey("points")) {
      List points = GraphConstants.getPoints(attrMap);
      ArrayList result = new ArrayList();
      // The ports are removed. They are converted to String's.
      // Ports are added employing cell.
      PortView sourceView = (PortView) graph.getGraphLayoutCache().getMapping( (GraphCell) ( (
          Port) ( (DefaultEdge) cell).getSource()), false);
      PortView targetView = (PortView) graph.getGraphLayoutCache().getMapping( (GraphCell) ( (
          Port) ( (DefaultEdge) cell).getTarget()), false);
      // Add source.
      result.add(sourceView);
      // Other points are represented as Point's.
      Iterator it = points.iterator();
      while (it.hasNext()) {
        Object point = it.next();
        if (point instanceof Point) {
          result.add(point);
        }
      }
      // Add target.
      result.add(targetView);
      GraphConstants.setPoints(attrMap, result);
    }

    if (attrMap.containsKey("lineBegin")) {
      // int values are saved as Strings.
      String lineBegin = (String) attrMap.get("lineBegin");
      GraphConstants.setLineBegin(attrMap, Integer.parseInt(lineBegin));
    }

    if (attrMap.containsKey("lineEnd")) {
      // int values are saved as Strings.
      String lineEnd = (String) attrMap.get("lineEnd");
      GraphConstants.setLineEnd(attrMap, Integer.parseInt(lineEnd));
    }

    return attrMap;
  }

  // Convert a vertex represented by a GXL DOM node in a DefaultGraphCell.
  // ids contains the already processed vertex ids.
  
  private DefaultGraphCell GXLVertex(String id, String type, ModelJGraph graph,
                                     ObjectManager om, RelationshipManager rm) {

    DefaultGraphCell vertex = null;

    ingenias.editor.entities.Entity en = om.getEntity(id, type);
    // if it is registered in the OM, then it is a diagram object
    if (en != null) {



   	if (en instanceof ingenias.editor.entities.Dishwasher)
	  return  new ingenias.editor.cell.DishwasherCell((ingenias.editor.entities.Dishwasher)en);

   	if (en instanceof ingenias.editor.entities.PerceptionEvent)
	  return  new ingenias.editor.cell.PerceptionEventCell((ingenias.editor.entities.PerceptionEvent)en);

   	if (en instanceof ingenias.editor.entities.DeviceVar)
	  return  new ingenias.editor.cell.DeviceVarCell((ingenias.editor.entities.DeviceVar)en);

   	if (en instanceof ingenias.editor.entities.ArithmeticExpression)
	  return  new ingenias.editor.cell.ArithmeticExpressionCell((ingenias.editor.entities.ArithmeticExpression)en);

   	if (en instanceof ingenias.editor.entities.SwitchLightAction)
	  return  new ingenias.editor.cell.SwitchLightActionCell((ingenias.editor.entities.SwitchLightAction)en);

   	if (en instanceof ingenias.editor.entities.SeatVar)
	  return  new ingenias.editor.cell.SeatVarCell((ingenias.editor.entities.SeatVar)en);

   	if (en instanceof ingenias.editor.entities.Shower)
	  return  new ingenias.editor.cell.ShowerCell((ingenias.editor.entities.Shower)en);

   	if (en instanceof ingenias.editor.entities.ProgramState)
	  return  new ingenias.editor.cell.ProgramStateCell((ingenias.editor.entities.ProgramState)en);

   	if (en instanceof ingenias.editor.entities.FOWashbasin)
	  return  new ingenias.editor.cell.FOWashbasinCell((ingenias.editor.entities.FOWashbasin)en);

   	if (en instanceof ingenias.editor.entities.FDelayFilter)
	  return  new ingenias.editor.cell.FDelayFilterCell((ingenias.editor.entities.FDelayFilter)en);

   	if (en instanceof ingenias.editor.entities.CObjWeight)
	  return  new ingenias.editor.cell.CObjWeightCell((ingenias.editor.entities.CObjWeight)en);

   	if (en instanceof ingenias.editor.entities.Var)
	  return  new ingenias.editor.cell.VarCell((ingenias.editor.entities.Var)en);

   	if (en instanceof ingenias.editor.entities.WorldInitialization)
	  return  new ingenias.editor.cell.WorldInitializationCell((ingenias.editor.entities.WorldInitialization)en);

   	if (en instanceof ingenias.editor.entities.HumanProfile)
	  return  new ingenias.editor.cell.HumanProfileCell((ingenias.editor.entities.HumanProfile)en);

   	if (en instanceof ingenias.editor.entities.FOBath)
	  return  new ingenias.editor.cell.FOBathCell((ingenias.editor.entities.FOBath)en);

   	if (en instanceof ingenias.editor.entities.PDSymtom)
	  return  new ingenias.editor.cell.PDSymtomCell((ingenias.editor.entities.PDSymtom)en);

   	if (en instanceof ingenias.editor.entities.HumanNorm)
	  return  new ingenias.editor.cell.HumanNormCell((ingenias.editor.entities.HumanNorm)en);

   	if (en instanceof ingenias.editor.entities.DiseaseProfile)
	  return  new ingenias.editor.cell.DiseaseProfileCell((ingenias.editor.entities.DiseaseProfile)en);

   	if (en instanceof ingenias.editor.entities.BGetUpFromBed)
	  return  new ingenias.editor.cell.BGetUpFromBedCell((ingenias.editor.entities.BGetUpFromBed)en);

   	if (en instanceof ingenias.editor.entities.GenericDisease)
	  return  new ingenias.editor.cell.GenericDiseaseCell((ingenias.editor.entities.GenericDisease)en);

   	if (en instanceof ingenias.editor.entities.CSay)
	  return  new ingenias.editor.cell.CSayCell((ingenias.editor.entities.CSay)en);

   	if (en instanceof ingenias.editor.entities.SwipeTask)
	  return  new ingenias.editor.cell.SwipeTaskCell((ingenias.editor.entities.SwipeTask)en);

   	if (en instanceof ingenias.editor.entities.StopBehaviourEvent)
	  return  new ingenias.editor.cell.StopBehaviourEventCell((ingenias.editor.entities.StopBehaviourEvent)en);

   	if (en instanceof ingenias.editor.entities.SVerticalSpace)
	  return  new ingenias.editor.cell.SVerticalSpaceCell((ingenias.editor.entities.SVerticalSpace)en);

   	if (en instanceof ingenias.editor.entities.PersonalInfo)
	  return  new ingenias.editor.cell.PersonalInfoCell((ingenias.editor.entities.PersonalInfo)en);

   	if (en instanceof ingenias.editor.entities.CAlways)
	  return  new ingenias.editor.cell.CAlwaysCell((ingenias.editor.entities.CAlways)en);

   	if (en instanceof ingenias.editor.entities.ObjectVar)
	  return  new ingenias.editor.cell.ObjectVarCell((ingenias.editor.entities.ObjectVar)en);

   	if (en instanceof ingenias.editor.entities.MedsTakenEvent)
	  return  new ingenias.editor.cell.MedsTakenEventCell((ingenias.editor.entities.MedsTakenEvent)en);

   	if (en instanceof ingenias.editor.entities.Extractor)
	  return  new ingenias.editor.cell.ExtractorCell((ingenias.editor.entities.Extractor)en);

   	if (en instanceof ingenias.editor.entities.SSpatial)
	  return  new ingenias.editor.cell.SSpatialCell((ingenias.editor.entities.SSpatial)en);

   	if (en instanceof ingenias.editor.entities.FBed)
	  return  new ingenias.editor.cell.FBedCell((ingenias.editor.entities.FBed)en);

   	if (en instanceof ingenias.editor.entities.BECollision)
	  return  new ingenias.editor.cell.BECollisionCell((ingenias.editor.entities.BECollision)en);

   	if (en instanceof ingenias.editor.entities.SociAALEntity)
	  return  new ingenias.editor.cell.SociAALEntityCell((ingenias.editor.entities.SociAALEntity)en);

   	if (en instanceof ingenias.editor.entities.DComputer)
	  return  new ingenias.editor.cell.DComputerCell((ingenias.editor.entities.DComputer)en);

   	if (en instanceof ingenias.editor.entities.Shirt)
	  return  new ingenias.editor.cell.ShirtCell((ingenias.editor.entities.Shirt)en);

   	if (en instanceof ingenias.editor.entities.Shoes)
	  return  new ingenias.editor.cell.ShoesCell((ingenias.editor.entities.Shoes)en);

   	if (en instanceof ingenias.editor.entities.AndroidEmulator)
	  return  new ingenias.editor.cell.AndroidEmulatorCell((ingenias.editor.entities.AndroidEmulator)en);

   	if (en instanceof ingenias.editor.entities.PlayAnimationTask)
	  return  new ingenias.editor.cell.PlayAnimationTaskCell((ingenias.editor.entities.PlayAnimationTask)en);

   	if (en instanceof ingenias.editor.entities.SymptomChangedEvent)
	  return  new ingenias.editor.cell.SymptomChangedEventCell((ingenias.editor.entities.SymptomChangedEvent)en);

   	if (en instanceof ingenias.editor.entities.Bridge)
	  return  new ingenias.editor.cell.BridgeCell((ingenias.editor.entities.Bridge)en);

   	if (en instanceof ingenias.editor.entities.EMobileDevice)
	  return  new ingenias.editor.cell.EMobileDeviceCell((ingenias.editor.entities.EMobileDevice)en);

   	if (en instanceof ingenias.editor.entities.FOSink)
	  return  new ingenias.editor.cell.FOSinkCell((ingenias.editor.entities.FOSink)en);

   	if (en instanceof ingenias.editor.entities.CProb)
	  return  new ingenias.editor.cell.CProbCell((ingenias.editor.entities.CProb)en);

   	if (en instanceof ingenias.editor.entities.EWaterBottle)
	  return  new ingenias.editor.cell.EWaterBottleCell((ingenias.editor.entities.EWaterBottle)en);

   	if (en instanceof ingenias.editor.entities.BENewObjInFieldOfVision)
	  return  new ingenias.editor.cell.BENewObjInFieldOfVisionCell((ingenias.editor.entities.BENewObjInFieldOfVision)en);

   	if (en instanceof ingenias.editor.entities.SBathroom)
	  return  new ingenias.editor.cell.SBathroomCell((ingenias.editor.entities.SBathroom)en);

   	if (en instanceof ingenias.editor.entities.Crutch)
	  return  new ingenias.editor.cell.CrutchCell((ingenias.editor.entities.Crutch)en);

   	if (en instanceof ingenias.editor.entities.Staircase)
	  return  new ingenias.editor.cell.StaircaseCell((ingenias.editor.entities.Staircase)en);

   	if (en instanceof ingenias.editor.entities.FChangeTargetObjFilter)
	  return  new ingenias.editor.cell.FChangeTargetObjFilterCell((ingenias.editor.entities.FChangeTargetObjFilter)en);

   	if (en instanceof ingenias.editor.entities.SBedroom)
	  return  new ingenias.editor.cell.SBedroomCell((ingenias.editor.entities.SBedroom)en);

   	if (en instanceof ingenias.editor.entities.AEDiv)
	  return  new ingenias.editor.cell.AEDivCell((ingenias.editor.entities.AEDiv)en);

   	if (en instanceof ingenias.editor.entities.VibrateEvent)
	  return  new ingenias.editor.cell.VibrateEventCell((ingenias.editor.entities.VibrateEvent)en);

   	if (en instanceof ingenias.editor.entities.WearableVar)
	  return  new ingenias.editor.cell.WearableVarCell((ingenias.editor.entities.WearableVar)en);

   	if (en instanceof ingenias.editor.entities.DoorStateCondition)
	  return  new ingenias.editor.cell.DoorStateConditionCell((ingenias.editor.entities.DoorStateCondition)en);

   	if (en instanceof ingenias.editor.entities.WaitForBodyClose)
	  return  new ingenias.editor.cell.WaitForBodyCloseCell((ingenias.editor.entities.WaitForBodyClose)en);

   	if (en instanceof ingenias.editor.entities.BPickUpTask)
	  return  new ingenias.editor.cell.BPickUpTaskCell((ingenias.editor.entities.BPickUpTask)en);

   	if (en instanceof ingenias.editor.entities.Doorbell)
	  return  new ingenias.editor.cell.DoorbellCell((ingenias.editor.entities.Doorbell)en);

   	if (en instanceof ingenias.editor.entities.SArea)
	  return  new ingenias.editor.cell.SAreaCell((ingenias.editor.entities.SArea)en);

   	if (en instanceof ingenias.editor.entities.CloseTask)
	  return  new ingenias.editor.cell.CloseTaskCell((ingenias.editor.entities.CloseTask)en);

   	if (en instanceof ingenias.editor.entities.PartOfBody)
	  return  new ingenias.editor.cell.PartOfBodyCell((ingenias.editor.entities.PartOfBody)en);

   	if (en instanceof ingenias.editor.entities.LightStateCondition)
	  return  new ingenias.editor.cell.LightStateConditionCell((ingenias.editor.entities.LightStateCondition)en);

   	if (en instanceof ingenias.editor.entities.PrimitiveVar)
	  return  new ingenias.editor.cell.PrimitiveVarCell((ingenias.editor.entities.PrimitiveVar)en);

   	if (en instanceof ingenias.editor.entities.AEAddSub)
	  return  new ingenias.editor.cell.AEAddSubCell((ingenias.editor.entities.AEAddSub)en);

   	if (en instanceof ingenias.editor.entities.FSofa)
	  return  new ingenias.editor.cell.FSofaCell((ingenias.editor.entities.FSofa)en);

   	if (en instanceof ingenias.editor.entities.EPublicEvent)
	  return  new ingenias.editor.cell.EPublicEventCell((ingenias.editor.entities.EPublicEvent)en);

   	if (en instanceof ingenias.editor.entities.PutOnTask)
	  return  new ingenias.editor.cell.PutOnTaskCell((ingenias.editor.entities.PutOnTask)en);

   	if (en instanceof ingenias.editor.entities.SFloor)
	  return  new ingenias.editor.cell.SFloorCell((ingenias.editor.entities.SFloor)en);

   	if (en instanceof ingenias.editor.entities.HIGHSympLevelState)
	  return  new ingenias.editor.cell.HIGHSympLevelStateCell((ingenias.editor.entities.HIGHSympLevelState)en);

   	if (en instanceof ingenias.editor.entities.AEInv)
	  return  new ingenias.editor.cell.AEInvCell((ingenias.editor.entities.AEInv)en);

   	if (en instanceof ingenias.editor.entities.EMobileObject)
	  return  new ingenias.editor.cell.EMobileObjectCell((ingenias.editor.entities.EMobileObject)en);

   	if (en instanceof ingenias.editor.entities.SayTask)
	  return  new ingenias.editor.cell.SayTaskCell((ingenias.editor.entities.SayTask)en);

   	if (en instanceof ingenias.editor.entities.HearingEvent)
	  return  new ingenias.editor.cell.HearingEventCell((ingenias.editor.entities.HearingEvent)en);

   	if (en instanceof ingenias.editor.entities.BEObjOutFielOfVision)
	  return  new ingenias.editor.cell.BEObjOutFielOfVisionCell((ingenias.editor.entities.BEObjOutFielOfVision)en);

   	if (en instanceof ingenias.editor.entities.ERemoteControl)
	  return  new ingenias.editor.cell.ERemoteControlCell((ingenias.editor.entities.ERemoteControl)en);

   	if (en instanceof ingenias.editor.entities.SymptomLevelState)
	  return  new ingenias.editor.cell.SymptomLevelStateCell((ingenias.editor.entities.SymptomLevelState)en);

   	if (en instanceof ingenias.editor.entities.EMobileFurniture)
	  return  new ingenias.editor.cell.EMobileFurnitureCell((ingenias.editor.entities.EMobileFurniture)en);

   	if (en instanceof ingenias.editor.entities.Param)
	  return  new ingenias.editor.cell.ParamCell((ingenias.editor.entities.Param)en);

   	if (en instanceof ingenias.editor.entities.MessageListenedEvent)
	  return  new ingenias.editor.cell.MessageListenedEventCell((ingenias.editor.entities.MessageListenedEvent)en);

   	if (en instanceof ingenias.editor.entities.SDate)
	  return  new ingenias.editor.cell.SDateCell((ingenias.editor.entities.SDate)en);

   	if (en instanceof ingenias.editor.entities.BUseTask)
	  return  new ingenias.editor.cell.BUseTaskCell((ingenias.editor.entities.BUseTask)en);

   	if (en instanceof ingenias.editor.entities.BodyEvent)
	  return  new ingenias.editor.cell.BodyEventCell((ingenias.editor.entities.BodyEvent)en);

   	if (en instanceof ingenias.editor.entities.CompCondition)
	  return  new ingenias.editor.cell.CompConditionCell((ingenias.editor.entities.CompCondition)en);

   	if (en instanceof ingenias.editor.entities.Trousers)
	  return  new ingenias.editor.cell.TrousersCell((ingenias.editor.entities.Trousers)en);

   	if (en instanceof ingenias.editor.entities.FallingEvent)
	  return  new ingenias.editor.cell.FallingEventCell((ingenias.editor.entities.FallingEvent)en);

   	if (en instanceof ingenias.editor.entities.EFixedDevice)
	  return  new ingenias.editor.cell.EFixedDeviceCell((ingenias.editor.entities.EFixedDevice)en);

   	if (en instanceof ingenias.editor.entities.Condition)
	  return  new ingenias.editor.cell.ConditionCell((ingenias.editor.entities.Condition)en);

   	if (en instanceof ingenias.editor.entities.CReceiveHelp)
	  return  new ingenias.editor.cell.CReceiveHelpCell((ingenias.editor.entities.CReceiveHelp)en);

   	if (en instanceof ingenias.editor.entities.WearableParam)
	  return  new ingenias.editor.cell.WearableParamCell((ingenias.editor.entities.WearableParam)en);

   	if (en instanceof ingenias.editor.entities.WashMachine)
	  return  new ingenias.editor.cell.WashMachineCell((ingenias.editor.entities.WashMachine)en);

   	if (en instanceof ingenias.editor.entities.FlyCamInit)
	  return  new ingenias.editor.cell.FlyCamInitCell((ingenias.editor.entities.FlyCamInit)en);

   	if (en instanceof ingenias.editor.entities.VibrateDeviceAction)
	  return  new ingenias.editor.cell.VibrateDeviceActionCell((ingenias.editor.entities.VibrateDeviceAction)en);

   	if (en instanceof ingenias.editor.entities.Appliance)
	  return  new ingenias.editor.cell.ApplianceCell((ingenias.editor.entities.Appliance)en);

   	if (en instanceof ingenias.editor.entities.MedInjection)
	  return  new ingenias.editor.cell.MedInjectionCell((ingenias.editor.entities.MedInjection)en);

   	if (en instanceof ingenias.editor.entities.ADLProfile)
	  return  new ingenias.editor.cell.ADLProfileCell((ingenias.editor.entities.ADLProfile)en);

   	if (en instanceof ingenias.editor.entities.DTV)
	  return  new ingenias.editor.cell.DTVCell((ingenias.editor.entities.DTV)en);

   	if (en instanceof ingenias.editor.entities.BSimpleTask)
	  return  new ingenias.editor.cell.BSimpleTaskCell((ingenias.editor.entities.BSimpleTask)en);

   	if (en instanceof ingenias.editor.entities.EWearable)
	  return  new ingenias.editor.cell.EWearableCell((ingenias.editor.entities.EWearable)en);

   	if (en instanceof ingenias.editor.entities.DeviceParam)
	  return  new ingenias.editor.cell.DeviceParamCell((ingenias.editor.entities.DeviceParam)en);

   	if (en instanceof ingenias.editor.entities.EMedicine)
	  return  new ingenias.editor.cell.EMedicineCell((ingenias.editor.entities.EMedicine)en);

   	if (en instanceof ingenias.editor.entities.AENumConst)
	  return  new ingenias.editor.cell.AENumConstCell((ingenias.editor.entities.AENumConst)en);

   	if (en instanceof ingenias.editor.entities.LOWTaskFilterR)
	  return  new ingenias.editor.cell.LOWTaskFilterRCell((ingenias.editor.entities.LOWTaskFilterR)en);

   	if (en instanceof ingenias.editor.entities.TakeOffTask)
	  return  new ingenias.editor.cell.TakeOffTaskCell((ingenias.editor.entities.TakeOffTask)en);

   	if (en instanceof ingenias.editor.entities.EatableItem)
	  return  new ingenias.editor.cell.EatableItemCell((ingenias.editor.entities.EatableItem)en);

   	if (en instanceof ingenias.editor.entities.EPhysicalEntity)
	  return  new ingenias.editor.cell.EPhysicalEntityCell((ingenias.editor.entities.EPhysicalEntity)en);

   	if (en instanceof ingenias.editor.entities.SocialProfile)
	  return  new ingenias.editor.cell.SocialProfileCell((ingenias.editor.entities.SocialProfile)en);

   	if (en instanceof ingenias.editor.entities.NotCondition)
	  return  new ingenias.editor.cell.NotConditionCell((ingenias.editor.entities.NotCondition)en);

   	if (en instanceof ingenias.editor.entities.BEObjectMoving)
	  return  new ingenias.editor.cell.BEObjectMovingCell((ingenias.editor.entities.BEObjectMoving)en);

   	if (en instanceof ingenias.editor.entities.DropObj)
	  return  new ingenias.editor.cell.DropObjCell((ingenias.editor.entities.DropObj)en);

   	if (en instanceof ingenias.editor.entities.EFixedObject)
	  return  new ingenias.editor.cell.EFixedObjectCell((ingenias.editor.entities.EFixedObject)en);

   	if (en instanceof ingenias.editor.entities.IsThingInRoomCondition)
	  return  new ingenias.editor.cell.IsThingInRoomConditionCell((ingenias.editor.entities.IsThingInRoomCondition)en);

   	if (en instanceof ingenias.editor.entities.PlaceParam)
	  return  new ingenias.editor.cell.PlaceParamCell((ingenias.editor.entities.PlaceParam)en);

   	if (en instanceof ingenias.editor.entities.CTimer)
	  return  new ingenias.editor.cell.CTimerCell((ingenias.editor.entities.CTimer)en);

   	if (en instanceof ingenias.editor.entities.Human)
	  return  new ingenias.editor.cell.HumanCell((ingenias.editor.entities.Human)en);

   	if (en instanceof ingenias.editor.entities.CInside)
	  return  new ingenias.editor.cell.CInsideCell((ingenias.editor.entities.CInside)en);

   	if (en instanceof ingenias.editor.entities.AEMult)
	  return  new ingenias.editor.cell.AEMultCell((ingenias.editor.entities.AEMult)en);

   	if (en instanceof ingenias.editor.entities.VisionEvent)
	  return  new ingenias.editor.cell.VisionEventCell((ingenias.editor.entities.VisionEvent)en);

   	if (en instanceof ingenias.editor.entities.SeatParam)
	  return  new ingenias.editor.cell.SeatParamCell((ingenias.editor.entities.SeatParam)en);

   	if (en instanceof ingenias.editor.entities.EASubSubSub)
	  return  new ingenias.editor.cell.EASubSubSubCell((ingenias.editor.entities.EASubSubSub)en);

   	if (en instanceof ingenias.editor.entities.ELivingBeing)
	  return  new ingenias.editor.cell.ELivingBeingCell((ingenias.editor.entities.ELivingBeing)en);

   	if (en instanceof ingenias.editor.entities.SwitchLightTask)
	  return  new ingenias.editor.cell.SwitchLightTaskCell((ingenias.editor.entities.SwitchLightTask)en);

   	if (en instanceof ingenias.editor.entities.SpatialVar)
	  return  new ingenias.editor.cell.SpatialVarCell((ingenias.editor.entities.SpatialVar)en);

   	if (en instanceof ingenias.editor.entities.Lift)
	  return  new ingenias.editor.cell.LiftCell((ingenias.editor.entities.Lift)en);

   	if (en instanceof ingenias.editor.entities.StandUp)
	  return  new ingenias.editor.cell.StandUpCell((ingenias.editor.entities.StandUp)en);

   	if (en instanceof ingenias.editor.entities.FallTask)
	  return  new ingenias.editor.cell.FallTaskCell((ingenias.editor.entities.FallTask)en);

   	if (en instanceof ingenias.editor.entities.EPrivateEvent)
	  return  new ingenias.editor.cell.EPrivateEventCell((ingenias.editor.entities.EPrivateEvent)en);

   	if (en instanceof ingenias.editor.entities.NONESympLevelState)
	  return  new ingenias.editor.cell.NONESympLevelStateCell((ingenias.editor.entities.NONESympLevelState)en);

   	if (en instanceof ingenias.editor.entities.MEDIUMTaskFilterR)
	  return  new ingenias.editor.cell.MEDIUMTaskFilterRCell((ingenias.editor.entities.MEDIUMTaskFilterR)en);

   	if (en instanceof ingenias.editor.entities.GoToBodyLoc)
	  return  new ingenias.editor.cell.GoToBodyLocCell((ingenias.editor.entities.GoToBodyLoc)en);

   	if (en instanceof ingenias.editor.entities.TaskFilterRef)
	  return  new ingenias.editor.cell.TaskFilterRefCell((ingenias.editor.entities.TaskFilterRef)en);

   	if (en instanceof ingenias.editor.entities.GoIntoBed)
	  return  new ingenias.editor.cell.GoIntoBedCell((ingenias.editor.entities.GoIntoBed)en);

   	if (en instanceof ingenias.editor.entities.AEVariable)
	  return  new ingenias.editor.cell.AEVariableCell((ingenias.editor.entities.AEVariable)en);

   	if (en instanceof ingenias.editor.entities.FTaskSelectorFilter)
	  return  new ingenias.editor.cell.FTaskSelectorFilterCell((ingenias.editor.entities.FTaskSelectorFilter)en);

   	if (en instanceof ingenias.editor.entities.BSimpleDurationTask)
	  return  new ingenias.editor.cell.BSimpleDurationTaskCell((ingenias.editor.entities.BSimpleDurationTask)en);

   	if (en instanceof ingenias.editor.entities.Walker)
	  return  new ingenias.editor.cell.WalkerCell((ingenias.editor.entities.Walker)en);

   	if (en instanceof ingenias.editor.entities.OpenTask)
	  return  new ingenias.editor.cell.OpenTaskCell((ingenias.editor.entities.OpenTask)en);

   	if (en instanceof ingenias.editor.entities.SCorridor)
	  return  new ingenias.editor.cell.SCorridorCell((ingenias.editor.entities.SCorridor)en);

   	if (en instanceof ingenias.editor.entities.FModifyPlaceFilter)
	  return  new ingenias.editor.cell.FModifyPlaceFilterCell((ingenias.editor.entities.FModifyPlaceFilter)en);

   	if (en instanceof ingenias.editor.entities.FTable)
	  return  new ingenias.editor.cell.FTableCell((ingenias.editor.entities.FTable)en);

   	if (en instanceof ingenias.editor.entities.DrinkItem)
	  return  new ingenias.editor.cell.DrinkItemCell((ingenias.editor.entities.DrinkItem)en);

   	if (en instanceof ingenias.editor.entities.FallSleep)
	  return  new ingenias.editor.cell.FallSleepCell((ingenias.editor.entities.FallSleep)en);

   	if (en instanceof ingenias.editor.entities.BActivity)
	  return  new ingenias.editor.cell.BActivityCell((ingenias.editor.entities.BActivity)en);

   	if (en instanceof ingenias.editor.entities.AnotherActionHappens)
	  return  new ingenias.editor.cell.AnotherActionHappensCell((ingenias.editor.entities.AnotherActionHappens)en);

   	if (en instanceof ingenias.editor.entities.WaitTask)
	  return  new ingenias.editor.cell.WaitTaskCell((ingenias.editor.entities.WaitTask)en);

   	if (en instanceof ingenias.editor.entities.HumanParam)
	  return  new ingenias.editor.cell.HumanParamCell((ingenias.editor.entities.HumanParam)en);

   	if (en instanceof ingenias.editor.entities.BEvent)
	  return  new ingenias.editor.cell.BEventCell((ingenias.editor.entities.BEvent)en);

   	if (en instanceof ingenias.editor.entities.BDeviceAction)
	  return  new ingenias.editor.cell.BDeviceActionCell((ingenias.editor.entities.BDeviceAction)en);

   	if (en instanceof ingenias.editor.entities.FChair)
	  return  new ingenias.editor.cell.FChairCell((ingenias.editor.entities.FChair)en);

   	if (en instanceof ingenias.editor.entities.SLivingroom)
	  return  new ingenias.editor.cell.SLivingroomCell((ingenias.editor.entities.SLivingroom)en);

   	if (en instanceof ingenias.editor.entities.DeviceEvent)
	  return  new ingenias.editor.cell.DeviceEventCell((ingenias.editor.entities.DeviceEvent)en);

   	if (en instanceof ingenias.editor.entities.TimeInterval)
	  return  new ingenias.editor.cell.TimeIntervalCell((ingenias.editor.entities.TimeInterval)en);

   	if (en instanceof ingenias.editor.entities.IncomingCallAction)
	  return  new ingenias.editor.cell.IncomingCallActionCell((ingenias.editor.entities.IncomingCallAction)en);

   	if (en instanceof ingenias.editor.entities.PresenceSensorStateCondition)
	  return  new ingenias.editor.cell.PresenceSensorStateConditionCell((ingenias.editor.entities.PresenceSensorStateCondition)en);

   	if (en instanceof ingenias.editor.entities.SRoom)
	  return  new ingenias.editor.cell.SRoomCell((ingenias.editor.entities.SRoom)en);

   	if (en instanceof ingenias.editor.entities.MEDIUMSympLevelState)
	  return  new ingenias.editor.cell.MEDIUMSympLevelStateCell((ingenias.editor.entities.MEDIUMSympLevelState)en);

   	if (en instanceof ingenias.editor.entities.BodyStateCondition)
	  return  new ingenias.editor.cell.BodyStateConditionCell((ingenias.editor.entities.BodyStateCondition)en);

   	if (en instanceof ingenias.editor.entities.EBehaviourEvent)
	  return  new ingenias.editor.cell.EBehaviourEventCell((ingenias.editor.entities.EBehaviourEvent)en);

   	if (en instanceof ingenias.editor.entities.FReplaceTaskFilter)
	  return  new ingenias.editor.cell.FReplaceTaskFilterCell((ingenias.editor.entities.FReplaceTaskFilter)en);

   	if (en instanceof ingenias.editor.entities.BTask)
	  return  new ingenias.editor.cell.BTaskCell((ingenias.editor.entities.BTask)en);

   	if (en instanceof ingenias.editor.entities.LOWSympLevelState)
	  return  new ingenias.editor.cell.LOWSympLevelStateCell((ingenias.editor.entities.LOWSympLevelState)en);

   	if (en instanceof ingenias.editor.entities.FUnableFilter)
	  return  new ingenias.editor.cell.FUnableFilterCell((ingenias.editor.entities.FUnableFilter)en);

   	if (en instanceof ingenias.editor.entities.FChangeToolFilter)
	  return  new ingenias.editor.cell.FChangeToolFilterCell((ingenias.editor.entities.FChangeToolFilter)en);

   	if (en instanceof ingenias.editor.entities.AESub)
	  return  new ingenias.editor.cell.AESubCell((ingenias.editor.entities.AESub)en);

   	if (en instanceof ingenias.editor.entities.HumanVar)
	  return  new ingenias.editor.cell.HumanVarCell((ingenias.editor.entities.HumanVar)en);

   	if (en instanceof ingenias.editor.entities.AESubSub)
	  return  new ingenias.editor.cell.AESubSubCell((ingenias.editor.entities.AESubSub)en);

   	if (en instanceof ingenias.editor.entities.CSymptom)
	  return  new ingenias.editor.cell.CSymptomCell((ingenias.editor.entities.CSymptom)en);

   	if (en instanceof ingenias.editor.entities.ParkinsonsProfile)
	  return  new ingenias.editor.cell.ParkinsonsProfileCell((ingenias.editor.entities.ParkinsonsProfile)en);

   	if (en instanceof ingenias.editor.entities.EventProcessor)
	  return  new ingenias.editor.cell.EventProcessorCell((ingenias.editor.entities.EventProcessor)en);

   	if (en instanceof ingenias.editor.entities.ObjectParam)
	  return  new ingenias.editor.cell.ObjectParamCell((ingenias.editor.entities.ObjectParam)en);

   	if (en instanceof ingenias.editor.entities.FSeat)
	  return  new ingenias.editor.cell.FSeatCell((ingenias.editor.entities.FSeat)en);

   	if (en instanceof ingenias.editor.entities.BLeaveTask)
	  return  new ingenias.editor.cell.BLeaveTaskCell((ingenias.editor.entities.BLeaveTask)en);

   	if (en instanceof ingenias.editor.entities.CDayOfTheWeek)
	  return  new ingenias.editor.cell.CDayOfTheWeekCell((ingenias.editor.entities.CDayOfTheWeek)en);

   	if (en instanceof ingenias.editor.entities.PrimitiveParam)
	  return  new ingenias.editor.cell.PrimitiveParamCell((ingenias.editor.entities.PrimitiveParam)en);

   	if (en instanceof ingenias.editor.entities.CallStateEvent)
	  return  new ingenias.editor.cell.CallStateEventCell((ingenias.editor.entities.CallStateEvent)en);

   	if (en instanceof ingenias.editor.entities.SKitchen)
	  return  new ingenias.editor.cell.SKitchenCell((ingenias.editor.entities.SKitchen)en);

   	if (en instanceof ingenias.editor.entities.FOWater)
	  return  new ingenias.editor.cell.FOWaterCell((ingenias.editor.entities.FOWater)en);

   	if (en instanceof ingenias.editor.entities.Eat)
	  return  new ingenias.editor.cell.EatCell((ingenias.editor.entities.Eat)en);

   	if (en instanceof ingenias.editor.entities.TouchEvent)
	  return  new ingenias.editor.cell.TouchEventCell((ingenias.editor.entities.TouchEvent)en);

   	if (en instanceof ingenias.editor.entities.Shocks)
	  return  new ingenias.editor.cell.ShocksCell((ingenias.editor.entities.Shocks)en);

   	if (en instanceof ingenias.editor.entities.BSequentialTask)
	  return  new ingenias.editor.cell.BSequentialTaskCell((ingenias.editor.entities.BSequentialTask)en);

   	if (en instanceof ingenias.editor.entities.InitProgramPool)
	  return  new ingenias.editor.cell.InitProgramPoolCell((ingenias.editor.entities.InitProgramPool)en);

   	if (en instanceof ingenias.editor.entities.StartBehaviourEvent)
	  return  new ingenias.editor.cell.StartBehaviourEventCell((ingenias.editor.entities.StartBehaviourEvent)en);

   	if (en instanceof ingenias.editor.entities.HumanInitialization)
	  return  new ingenias.editor.cell.HumanInitializationCell((ingenias.editor.entities.HumanInitialization)en);

   	if (en instanceof ingenias.editor.entities.Behaviour)
	  return  new ingenias.editor.cell.BehaviourCell((ingenias.editor.entities.Behaviour)en);

   	if (en instanceof ingenias.editor.entities.BEVibration)
	  return  new ingenias.editor.cell.BEVibrationCell((ingenias.editor.entities.BEVibration)en);

   	if (en instanceof ingenias.editor.entities.CTime)
	  return  new ingenias.editor.cell.CTimeCell((ingenias.editor.entities.CTime)en);

   	if (en instanceof ingenias.editor.entities.ConsecutiveActions)
	  return  new ingenias.editor.cell.ConsecutiveActionsCell((ingenias.editor.entities.ConsecutiveActions)en);

   	if (en instanceof ingenias.editor.entities.DiseaseStage)
	  return  new ingenias.editor.cell.DiseaseStageCell((ingenias.editor.entities.DiseaseStage)en);

   	if (en instanceof ingenias.editor.entities.AndroidApplication)
	  return  new ingenias.editor.cell.AndroidApplicationCell((ingenias.editor.entities.AndroidApplication)en);

   	if (en instanceof ingenias.editor.entities.AEAddition)
	  return  new ingenias.editor.cell.AEAdditionCell((ingenias.editor.entities.AEAddition)en);

   	if (en instanceof ingenias.editor.entities.BRandomTask)
	  return  new ingenias.editor.cell.BRandomTaskCell((ingenias.editor.entities.BRandomTask)en);

   	if (en instanceof ingenias.editor.entities.SitDown)
	  return  new ingenias.editor.cell.SitDownCell((ingenias.editor.entities.SitDown)en);

   	if (en instanceof ingenias.editor.entities.SocialNetwork)
	  return  new ingenias.editor.cell.SocialNetworkCell((ingenias.editor.entities.SocialNetwork)en);

   	if (en instanceof ingenias.editor.entities.CEvent)
	  return  new ingenias.editor.cell.CEventCell((ingenias.editor.entities.CEvent)en);

   	if (en instanceof ingenias.editor.entities.InitialPreDefPos)
	  return  new ingenias.editor.cell.InitialPreDefPosCell((ingenias.editor.entities.InitialPreDefPos)en);

   	if (en instanceof ingenias.editor.entities.ClockTime)
	  return  new ingenias.editor.cell.ClockTimeCell((ingenias.editor.entities.ClockTime)en);

   	if (en instanceof ingenias.editor.entities.AEMulDiv)
	  return  new ingenias.editor.cell.AEMulDivCell((ingenias.editor.entities.AEMulDiv)en);

   	if (en instanceof ingenias.editor.entities.FModifyFilter)
	  return  new ingenias.editor.cell.FModifyFilterCell((ingenias.editor.entities.FModifyFilter)en);

   	if (en instanceof ingenias.editor.entities.InteractionProfile)
	  return  new ingenias.editor.cell.InteractionProfileCell((ingenias.editor.entities.InteractionProfile)en);

   	if (en instanceof ingenias.editor.entities.TapXYTask)
	  return  new ingenias.editor.cell.TapXYTaskCell((ingenias.editor.entities.TapXYTask)en);

   	if (en instanceof ingenias.editor.entities.CameraInit)
	  return  new ingenias.editor.cell.CameraInitCell((ingenias.editor.entities.CameraInit)en);

   	if (en instanceof ingenias.editor.entities.MedIntake)
	  return  new ingenias.editor.cell.MedIntakeCell((ingenias.editor.entities.MedIntake)en);

   	if (en instanceof ingenias.editor.entities.BWakeUpTask)
	  return  new ingenias.editor.cell.BWakeUpTaskCell((ingenias.editor.entities.BWakeUpTask)en);

   	if (en instanceof ingenias.editor.entities.HIGHTaskFilterR)
	  return  new ingenias.editor.cell.HIGHTaskFilterRCell((ingenias.editor.entities.HIGHTaskFilterR)en);

   	if (en instanceof ingenias.editor.entities.FTaskFilter)
	  return  new ingenias.editor.cell.FTaskFilterCell((ingenias.editor.entities.FTaskFilter)en);

   	if (en instanceof ingenias.editor.entities.Medication)
	  return  new ingenias.editor.cell.MedicationCell((ingenias.editor.entities.Medication)en);

   	if (en instanceof ingenias.editor.entities.BCompTask)
	  return  new ingenias.editor.cell.BCompTaskCell((ingenias.editor.entities.BCompTask)en);

   	if (en instanceof ingenias.editor.entities.TextToSpeachAction)
	  return  new ingenias.editor.cell.TextToSpeachActionCell((ingenias.editor.entities.TextToSpeachAction)en);

   	if (en instanceof ingenias.editor.entities.ESleepers)
	  return  new ingenias.editor.cell.ESleepersCell((ingenias.editor.entities.ESleepers)en);

   	if (en instanceof ingenias.editor.entities.MedicationTime)
	  return  new ingenias.editor.cell.MedicationTimeCell((ingenias.editor.entities.MedicationTime)en);

   	if (en instanceof ingenias.editor.entities.PDDiseaseStage)
	  return  new ingenias.editor.cell.PDDiseaseStageCell((ingenias.editor.entities.PDDiseaseStage)en);

   	if (en instanceof ingenias.editor.entities.ESmartPhone)
	  return  new ingenias.editor.cell.ESmartPhoneCell((ingenias.editor.entities.ESmartPhone)en);

   	if (en instanceof ingenias.editor.entities.Pyjamas)
	  return  new ingenias.editor.cell.PyjamasCell((ingenias.editor.entities.Pyjamas)en);

   	if (en instanceof ingenias.editor.entities.GSymptom)
	  return  new ingenias.editor.cell.GSymptomCell((ingenias.editor.entities.GSymptom)en);

   	if (en instanceof ingenias.editor.entities.EMobilePhysicalEntity)
	  return  new ingenias.editor.cell.EMobilePhysicalEntityCell((ingenias.editor.entities.EMobilePhysicalEntity)en);

   	if (en instanceof ingenias.editor.entities.Drink)
	  return  new ingenias.editor.cell.DrinkCell((ingenias.editor.entities.Drink)en);

   	if (en instanceof ingenias.editor.entities.WalkingHelper)
	  return  new ingenias.editor.cell.WalkingHelperCell((ingenias.editor.entities.WalkingHelper)en);

   	if (en instanceof ingenias.editor.entities.SBuilding)
	  return  new ingenias.editor.cell.SBuildingCell((ingenias.editor.entities.SBuilding)en);

   	if (en instanceof ingenias.editor.entities.EFixedFurniture)
	  return  new ingenias.editor.cell.EFixedFurnitureCell((ingenias.editor.entities.EFixedFurniture)en);

   	if (en instanceof ingenias.editor.entities.BGoToTask)
	  return  new ingenias.editor.cell.BGoToTaskCell((ingenias.editor.entities.BGoToTask)en);

   	if (en instanceof ingenias.editor.entities.SymptomInitialization)
	  return  new ingenias.editor.cell.SymptomInitializationCell((ingenias.editor.entities.SymptomInitialization)en);

   	if (en instanceof ingenias.editor.entities.AESubtraction)
	  return  new ingenias.editor.cell.AESubtractionCell((ingenias.editor.entities.AESubtraction)en);

   	if (en instanceof ingenias.editor.entities.COutside)
	  return  new ingenias.editor.cell.COutsideCell((ingenias.editor.entities.COutside)en);

   	if (en instanceof ingenias.editor.entities.ObjDroppedEvent)
	  return  new ingenias.editor.cell.ObjDroppedEventCell((ingenias.editor.entities.ObjDroppedEvent)en);

   	if (en instanceof ingenias.editor.entities.FWardrobe)
	  return  new ingenias.editor.cell.FWardrobeCell((ingenias.editor.entities.FWardrobe)en);

   	if (en instanceof ingenias.editor.entities.Profession)
	  return  new ingenias.editor.cell.ProfessionCell((ingenias.editor.entities.Profession)en);

   	if (en instanceof ingenias.editor.entities.IFFlowControl)
	  return  new ingenias.editor.cell.IFFlowControlCell((ingenias.editor.entities.IFFlowControl)en);

   	if (en instanceof ingenias.editor.entities.DFixedSensor)
	  return  new ingenias.editor.cell.DFixedSensorCell((ingenias.editor.entities.DFixedSensor)en);

   	if (en instanceof ingenias.editor.entities.Cane)
	  return  new ingenias.editor.cell.CaneCell((ingenias.editor.entities.Cane)en);

   	if (en instanceof ingenias.editor.entities.ETool)
	  return  new ingenias.editor.cell.EToolCell((ingenias.editor.entities.ETool)en);

   	if (en instanceof ingenias.editor.entities.BEBodyCollision)
	  return  new ingenias.editor.cell.BEBodyCollisionCell((ingenias.editor.entities.BEBodyCollision)en);

   	if (en instanceof ingenias.editor.entities.EClothing)
	  return  new ingenias.editor.cell.EClothingCell((ingenias.editor.entities.EClothing)en);

   	if (en instanceof ingenias.editor.entities.NormHoldingCondition)
	  return  new ingenias.editor.cell.NormHoldingConditionCell((ingenias.editor.entities.NormHoldingCondition)en);

   	if (en instanceof ingenias.editor.entities.EFixedPhysicalEntity)
	  return  new ingenias.editor.cell.EFixedPhysicalEntityCell((ingenias.editor.entities.EFixedPhysicalEntity)en);

    } else {
    // If not, it is a relationship
      en = rm.getRelationship(id);
    if (en==null) return null;

    if (en instanceof ingenias.editor.entities.Limitations)
     return  new LimitationsEdge((ingenias.editor.entities.Limitations)en);

    if (en instanceof ingenias.editor.entities.FPrecondition)
     return  new FPreconditionEdge((ingenias.editor.entities.FPrecondition)en);

    if (en instanceof ingenias.editor.entities.aemd_op2)
     return  new aemd_op2Edge((ingenias.editor.entities.aemd_op2)en);

    if (en instanceof ingenias.editor.entities.aemd_op1)
     return  new aemd_op1Edge((ingenias.editor.entities.aemd_op1)en);

    if (en instanceof ingenias.editor.entities.Connects)
     return  new ConnectsEdge((ingenias.editor.entities.Connects)en);

    if (en instanceof ingenias.editor.entities.SDoor)
     return  new SDoorEdge((ingenias.editor.entities.SDoor)en);

    if (en instanceof ingenias.editor.entities.isParentOf)
     return  new isParentOfEdge((ingenias.editor.entities.isParentOf)en);

    if (en instanceof ingenias.editor.entities.SymptomTransition)
     return  new SymptomTransitionEdge((ingenias.editor.entities.SymptomTransition)en);

    if (en instanceof ingenias.editor.entities.CameraFaceToHuman)
     return  new CameraFaceToHumanEdge((ingenias.editor.entities.CameraFaceToHuman)en);

    if (en instanceof ingenias.editor.entities.WorkAs)
     return  new WorkAsEdge((ingenias.editor.entities.WorkAs)en);

    if (en instanceof ingenias.editor.entities.useObjVar)
     return  new useObjVarEdge((ingenias.editor.entities.useObjVar)en);

    if (en instanceof ingenias.editor.entities.ProgramTransition)
     return  new ProgramTransitionEdge((ingenias.editor.entities.ProgramTransition)en);

    if (en instanceof ingenias.editor.entities.leaveObjVar)
     return  new leaveObjVarEdge((ingenias.editor.entities.leaveObjVar)en);

    if (en instanceof ingenias.editor.entities.NextSeqTask)
     return  new NextSeqTaskEdge((ingenias.editor.entities.NextSeqTask)en);

    if (en instanceof ingenias.editor.entities.TIStartTime)
     return  new TIStartTimeEdge((ingenias.editor.entities.TIStartTime)en);

    if (en instanceof ingenias.editor.entities.RelatedEvent)
     return  new RelatedEventEdge((ingenias.editor.entities.RelatedEvent)en);

    if (en instanceof ingenias.editor.entities.NextFilter)
     return  new NextFilterEdge((ingenias.editor.entities.NextFilter)en);

    if (en instanceof ingenias.editor.entities.putOnWearableVar)
     return  new putOnWearableVarEdge((ingenias.editor.entities.putOnWearableVar)en);

    if (en instanceof ingenias.editor.entities.ActivityAttached)
     return  new ActivityAttachedEdge((ingenias.editor.entities.ActivityAttached)en);

    if (en instanceof ingenias.editor.entities.openObjVar)
     return  new openObjVarEdge((ingenias.editor.entities.openObjVar)en);

    if (en instanceof ingenias.editor.entities.DeonticAssignement)
     return  new DeonticAssignementEdge((ingenias.editor.entities.DeonticAssignement)en);

    if (en instanceof ingenias.editor.entities.InitialLocation)
     return  new InitialLocationEdge((ingenias.editor.entities.InitialLocation)en);

    if (en instanceof ingenias.editor.entities.MedicinesIntakes)
     return  new MedicinesIntakesEdge((ingenias.editor.entities.MedicinesIntakes)en);

    if (en instanceof ingenias.editor.entities.aeas_op2)
     return  new aeas_op2Edge((ingenias.editor.entities.aeas_op2)en);

    if (en instanceof ingenias.editor.entities.ProfileOf)
     return  new ProfileOfEdge((ingenias.editor.entities.ProfileOf)en);

    if (en instanceof ingenias.editor.entities.aeas_op1)
     return  new aeas_op1Edge((ingenias.editor.entities.aeas_op1)en);

    if (en instanceof ingenias.editor.entities.InitializedSymptom)
     return  new InitializedSymptomEdge((ingenias.editor.entities.InitializedSymptom)en);

    if (en instanceof ingenias.editor.entities.InitializesSymptom)
     return  new InitializesSymptomEdge((ingenias.editor.entities.InitializesSymptom)en);

    if (en instanceof ingenias.editor.entities.Symptoms)
     return  new SymptomsEdge((ingenias.editor.entities.Symptoms)en);

    if (en instanceof ingenias.editor.entities.switchRoomVar)
     return  new switchRoomVarEdge((ingenias.editor.entities.switchRoomVar)en);

    if (en instanceof ingenias.editor.entities.EmulatorPeer)
     return  new EmulatorPeerEdge((ingenias.editor.entities.EmulatorPeer)en);

    if (en instanceof ingenias.editor.entities.goToBodyVar)
     return  new goToBodyVarEdge((ingenias.editor.entities.goToBodyVar)en);

    if (en instanceof ingenias.editor.entities.closeObjVar)
     return  new closeObjVarEdge((ingenias.editor.entities.closeObjVar)en);

    if (en instanceof ingenias.editor.entities.ProducesEvent)
     return  new ProducesEventEdge((ingenias.editor.entities.ProducesEvent)en);

    if (en instanceof ingenias.editor.entities.messageVar)
     return  new messageVarEdge((ingenias.editor.entities.messageVar)en);

    if (en instanceof ingenias.editor.entities.aeinv_op)
     return  new aeinv_opEdge((ingenias.editor.entities.aeinv_op)en);

    if (en instanceof ingenias.editor.entities.FalseFlow)
     return  new FalseFlowEdge((ingenias.editor.entities.FalseFlow)en);

    if (en instanceof ingenias.editor.entities.ParamsSet)
     return  new ParamsSetEdge((ingenias.editor.entities.ParamsSet)en);

    if (en instanceof ingenias.editor.entities.ActionResponsible)
     return  new ActionResponsibleEdge((ingenias.editor.entities.ActionResponsible)en);

    if (en instanceof ingenias.editor.entities.putOffWearableVar)
     return  new putOffWearableVarEdge((ingenias.editor.entities.putOffWearableVar)en);

    if (en instanceof ingenias.editor.entities.RelatedHuman)
     return  new RelatedHumanEdge((ingenias.editor.entities.RelatedHuman)en);

    if (en instanceof ingenias.editor.entities.LiveIn)
     return  new LiveInEdge((ingenias.editor.entities.LiveIn)en);

    if (en instanceof ingenias.editor.entities.tapDeviceVar)
     return  new tapDeviceVarEdge((ingenias.editor.entities.tapDeviceVar)en);

    if (en instanceof ingenias.editor.entities.tapXVar)
     return  new tapXVarEdge((ingenias.editor.entities.tapXVar)en);

    if (en instanceof ingenias.editor.entities.SBhasFloor)
     return  new SBhasFloorEdge((ingenias.editor.entities.SBhasFloor)en);

    if (en instanceof ingenias.editor.entities.NextTI)
     return  new NextTIEdge((ingenias.editor.entities.NextTI)en);

    if (en instanceof ingenias.editor.entities.tapYVar)
     return  new tapYVarEdge((ingenias.editor.entities.tapYVar)en);

    if (en instanceof ingenias.editor.entities.Role)
     return  new RoleEdge((ingenias.editor.entities.Role)en);

    if (en instanceof ingenias.editor.entities.AffectedAction)
     return  new AffectedActionEdge((ingenias.editor.entities.AffectedAction)en);

    if (en instanceof ingenias.editor.entities.med)
     return  new medEdge((ingenias.editor.entities.med)en);

    if (en instanceof ingenias.editor.entities.FAlternative)
     return  new FAlternativeEdge((ingenias.editor.entities.FAlternative)en);

    if (en instanceof ingenias.editor.entities.InitialActivity)
     return  new InitialActivityEdge((ingenias.editor.entities.InitialActivity)en);

    if (en instanceof ingenias.editor.entities.durationVar)
     return  new durationVarEdge((ingenias.editor.entities.durationVar)en);

    if (en instanceof ingenias.editor.entities.NextActivity)
     return  new NextActivityEdge((ingenias.editor.entities.NextActivity)en);

    if (en instanceof ingenias.editor.entities.dropObjVar)
     return  new dropObjVarEdge((ingenias.editor.entities.dropObjVar)en);

    if (en instanceof ingenias.editor.entities.relatedCondition)
     return  new relatedConditionEdge((ingenias.editor.entities.relatedCondition)en);

    if (en instanceof ingenias.editor.entities.cond)
     return  new condEdge((ingenias.editor.entities.cond)en);

    if (en instanceof ingenias.editor.entities.isCaregiverOf)
     return  new isCaregiverOfEdge((ingenias.editor.entities.isCaregiverOf)en);

    if (en instanceof ingenias.editor.entities.device)
     return  new deviceEdge((ingenias.editor.entities.device)en);

    if (en instanceof ingenias.editor.entities.InitialDate)
     return  new InitialDateEdge((ingenias.editor.entities.InitialDate)en);

    if (en instanceof ingenias.editor.entities.ActionHappeningAfterwards)
     return  new ActionHappeningAfterwardsEdge((ingenias.editor.entities.ActionHappeningAfterwards)en);

    if (en instanceof ingenias.editor.entities.InitialDeviceLocation)
     return  new InitialDeviceLocationEdge((ingenias.editor.entities.InitialDeviceLocation)en);

    if (en instanceof ingenias.editor.entities.sitDownOnSeatVar)
     return  new sitDownOnSeatVarEdge((ingenias.editor.entities.sitDownOnSeatVar)en);

    if (en instanceof ingenias.editor.entities.DeviceActionsAttached)
     return  new DeviceActionsAttachedEdge((ingenias.editor.entities.DeviceActionsAttached)en);

    if (en instanceof ingenias.editor.entities.AllowedTask)
     return  new AllowedTaskEdge((ingenias.editor.entities.AllowedTask)en);

    if (en instanceof ingenias.editor.entities.RunAndroidApp)
     return  new RunAndroidAppEdge((ingenias.editor.entities.RunAndroidApp)en);

    if (en instanceof ingenias.editor.entities.goToBodySpeedVar)
     return  new goToBodySpeedVarEdge((ingenias.editor.entities.goToBodySpeedVar)en);

    if (en instanceof ingenias.editor.entities.waitForHumanVar)
     return  new waitForHumanVarEdge((ingenias.editor.entities.waitForHumanVar)en);

    if (en instanceof ingenias.editor.entities.animVar)
     return  new animVarEdge((ingenias.editor.entities.animVar)en);

    if (en instanceof ingenias.editor.entities.socialRelations)
     return  new socialRelationsEdge((ingenias.editor.entities.socialRelations)en);

    if (en instanceof ingenias.editor.entities.TrueFlow)
     return  new TrueFlowEdge((ingenias.editor.entities.TrueFlow)en);

    if (en instanceof ingenias.editor.entities.goToSpeedVar)
     return  new goToSpeedVarEdge((ingenias.editor.entities.goToSpeedVar)en);

    if (en instanceof ingenias.editor.entities.ConditionNeeded)
     return  new ConditionNeededEdge((ingenias.editor.entities.ConditionNeeded)en);

    if (en instanceof ingenias.editor.entities.isSpouseOf)
     return  new isSpouseOfEdge((ingenias.editor.entities.isSpouseOf)en);

    if (en instanceof ingenias.editor.entities.tool)
     return  new toolEdge((ingenias.editor.entities.tool)en);

    if (en instanceof ingenias.editor.entities.leaveObjDestinyVar)
     return  new leaveObjDestinyVarEdge((ingenias.editor.entities.leaveObjDestinyVar)en);

    if (en instanceof ingenias.editor.entities.pickUpObjVar)
     return  new pickUpObjVarEdge((ingenias.editor.entities.pickUpObjVar)en);

    if (en instanceof ingenias.editor.entities.goToPlaceVar)
     return  new goToPlaceVarEdge((ingenias.editor.entities.goToPlaceVar)en);


 }

    return null;
  }

  // Convert an edge represented by a GXL DOM node in a DefaultEdge.
  // ids has a mapping from id to vertex.
  
  private DefaultEdge GXLEdge(Map ids, org.w3c.dom.Node node) {

    DefaultEdge edge = new DefaultEdge();

    // Fetch Map attributes.
    Map attrMap = getMap(node);

    // Create Edge with label
    String label = (String) attrMap.get("id");
    // Fetch type
    String type = (String) attrMap.get("type");
    // id and type are not valid JGraph attributes.
    attrMap.remove("id");
    attrMap.remove("type");
    return edge;
  }

  private DefaultGraphCell[]
      getEntitiesAlreadyInsertedInRelationshipAndUpdateDGCIds(Object[] selected,
      ingenias.editor.entities.NAryEdgeEntity nEdgeObject) {
    String[] ids = nEdgeObject.getIds();
    Vector newselectedv=new Vector();


    int i = 0;
//      for (int i = 0; i < ids.length; i++) {
    for (int j = 0; j < selected.length; j++) {
      Object userObject = ( (DefaultGraphCell) selected[j]).getUserObject();
/*      Log.getInstance().logSYS("Processing Relationship" +
                            nEdgeObject.getId() + " of type " +
                            nEdgeObject.getType() +
                            " considering " + userObject);*/

      try {
        if (userObject != null &&
            userObject instanceof ingenias.editor.entities.Entity) {
          nEdgeObject.searchEntityID( ( (ingenias.editor.entities.Entity)
                                       userObject).getId());
          nEdgeObject.updateCell( (DefaultGraphCell) selected[j]);
          newselectedv.add(selected[j]);
          i++;
        }
      }
      catch (NotFound nf) {
/*        Log.getInstance().logSYS("Processing Relationship" +
                              nEdgeObject.getId() + " of type " +
                              nEdgeObject.getType() +
                              " not found " + userObject);*/
      }
    }
    ids = nEdgeObject.getIds();

    // Number of ids in the relationship can be less than initial number
    if (ids.length != i) {
      throw new RuntimeException(
          "INTERNAL ERROR!!! Length of ids connected in " +
          nEdgeObject.getId() + " of type " + nEdgeObject.getType() +
          " a relationship does not match selected default graph cell number. I had " +
          ids.length + " elements to find and I found " + i);
    }
    DefaultGraphCell[] newSelected = new DefaultGraphCell[ids.length];
    for (int k=0;k<newSelected.length;k++){
      newSelected[k]=(DefaultGraphCell)newselectedv.elementAt(k);
    }
/*
    Copyright (C) 2002 Jorge Gomez Sanz, Ruben Fuentes, Juan Pavon

    Modifications over original code from jgraph.sourceforge.net

    This file is part of INGENIAS IDE, a support tool for the INGENIAS
    methodology, availabe at http://grasia.fdi.ucm.es/ingenias or
    http://ingenias.sourceforge.net

    INGENIAS IDE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    INGENIAS IDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with INGENIAS IDE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
    return newSelected;

  }

  private void connect(ModelJGraph graph, DefaultGraphCell[] selected,
                       NAryEdge nEdge,
                       Map eas) throws NotFound {
    ingenias.editor.entities.NAryEdgeEntity ne = (NAryEdgeEntity)
        nEdge.getUserObject();

    DefaultGraphCell[] newSelected = null;
    // N-ary relationship.
    if (nEdge != null) {
      // Role assignations to classes are obtained from NAryEdgeEntity in NAryEdge.
      // NAryEdgeEntity has a list of object ids that have to be in selected.
      // assignations is a Vector of Vectors of Strings where Strings represents roles.
      NAryEdgeEntity nEdgeObject = (NAryEdgeEntity) nEdge.getUserObject();
      // ids of objects connected with nEdge.
//      String[] ids = nEdgeObject.getIds(); // Not valid yet
  /*    {
        String idsres = "";
        for (int k = 0; k < ids.length; k++) {
          idsres = idsres + ids[k] + ",";
        }
        Log.getInstance().logSYS("Processing Relationship" +
                              ne.getId() + " of type " + ne.getType() +
                              " with elems " +
                              idsres +
                              " in graph " + graph.getID());
      }*/

      // Selected objects are reduced to those connected with nEdge
      newSelected = this.
          getEntitiesAlreadyInsertedInRelationshipAndUpdateDGCIds(selected,
          nEdgeObject);

/*      ids = nEdgeObject.getIds(); // Now valid ones, after the update
      {
        String idsres = "";
        for (int k = 0; k < ids.length; k++) {
          idsres = idsres + ids[k] + ",";
        }
        Log.getInstance().logSYS("Processing Relationship" +
                              ne.getId() + " of type " + ne.getType() +
                              " new ids " +
                              idsres +
                              " in graph " + graph.getID());
      }*/

      // Role assignation to objects is obtained.
      String[] selectedAssignation = new String[newSelected.length];
      for (int i = 0; i < newSelected.length; i++) {
        selectedAssignation[i] = nEdgeObject.getRole(""+newSelected[i].hashCode());
        // Auxiliary edges that will be inserted in the Model.
      }
      try {
        DefaultEdge[] auxiliaryEdges = nEdge.connectionsEdges(newSelected,
            selectedAssignation);
        for (int i = 0; i < newSelected.length; i++) {
          RoleEntity re = nEdgeObject.getRoleEntity(""+newSelected[i].hashCode());
          auxiliaryEdges[i].setUserObject(re);
        }

        // Connections that will be inserted into the Model.
        ConnectionSet cs = nEdge.connections(selectedAssignation,
                                             auxiliaryEdges,
                                             getPorts(graph, newSelected));
        // Construct a Map from cells to Maps (for insert).
        Hashtable attributes = new Hashtable();
        // Associate the NAryEdge Vertex with its Attributes.
        attributes.put(nEdge, eas);
//////////-----------------------------------//////////
        Hashtable edgesAttributes = new Hashtable();
        for (int i = 0; i < selectedAssignation.length; i++) {
          // Create a Map that holds the attributes for the edge
          Map attr = ( (RoleEntity) auxiliaryEdges[i].getUserObject()).
              getAttributes();
          // Source
          /*
           *  if (selectedAssignation[i].indexOf("source") >= 0)
           *  / Add a Line Begin Attribute
           *  GraphConstants.setLineBegin(attr, GraphConstants.SIMPLE);
           */
          // Target
          if (selectedAssignation[i].toUpperCase().indexOf("TARGET")>= 0 ||
              selectedAssignation[i].endsWith("T")) {
            // Add a Line End Attribute
            GraphConstants.setLineEnd(attr, GraphConstants.ARROW_CLASSIC);
            // Associate the Edge with its Attributes
          }
      GraphConstants.setDisconnectable(attr,false);

      GraphConstants.setBendable(attr,false);
          edgesAttributes.put(auxiliaryEdges[i], attr);
        }
//////////-----------------------------------//////////
        // Insert the Edge and its Attributes. The order matters.
        if (auxiliaryEdges.length >= 2) {
//        nEdgeObject.updateCells(newSelected);
          graph.getModel().insert(new Object[] {nEdge},attributes
                                  , null, null, null);
          String inserted = "";
          for (int j = 0; j < auxiliaryEdges.length; j++) {
            inserted = inserted + auxiliaryEdges[j];
          }
//          Log.getInstance().logSYS("Inserting " + inserted);
          graph.getModel().insert( (Object[]) auxiliaryEdges,edgesAttributes, cs, null,
                                  null);

        }
        else {
          // There was an error. A relationship was found with less than 2 extremes
          ne = (NAryEdgeEntity)
              nEdge.getUserObject();
          String[] tids = ne.getIds();
          String result = "";
          for (int k = 0; k < tids.length; k++) {
            result = result + tids[k] + ",";
          }
          Log.getInstance().logSYS("WARNING Relationship removed:Relationship " +
                                ne.getId() + " of type " + ne.getType() +
                                " has not been saved properly among objects " +
                                result + " in graph " + graph.getID());
        }
      }
      catch (WrongParameters wp) {
        Log.getInstance().logSYS(
            "WARNING!!! Cannot produce edges for relationship " +
            ne.getId() + " of type " + ne.getType());
        wp.printStackTrace();
      }
    }
  }

  private Object[] getModelPath(org.w3c.dom.Node n, GraphManager gm) {
    Object[] opath = null;
    Vector path = new Vector();
    NodeList packages = n.getChildNodes();
    for (int k = 0; k < packages.getLength(); k++) {
      org.w3c.dom.Node pack = packages.item(k);
      if (pack.getNodeName().equalsIgnoreCase("path")) {
        NodeList packs = pack.getChildNodes();
        for (int j = 0; j < packs.getLength(); j++) {
          org.w3c.dom.Node npack = packs.item(j);
          if (npack.getNodeName().equalsIgnoreCase("package")) {
            String id = npack.getAttributes().getNamedItem("id").getNodeValue().
                toString();
            path.add(id);
          }
        }
        for (int j = 1; j < path.size(); j++) {
          opath = new Object[j];
          for (int l = 0; l < j; l++) {
            opath[l] = path.elementAt(l);
          }
          gm.addPackage(opath, path.elementAt(j).toString());
        }
      }
    }
    return path.toArray();
  }

  
  private DefaultGraphCell getGraphCell(ModelJGraph mj, String id) {
    for (int k = 0; k < mj.getModel().getRootCount(); k++) {

      DefaultGraphCell dgc = (DefaultGraphCell) mj.getModel().getRootAt(k);
      ingenias.editor.entities.Entity ent = (ingenias.editor.entities.Entity)
          dgc.getUserObject();
      if (ent.getId().equalsIgnoreCase(id)) {
        return dgc;
      }

    }

    return null;
  }

  
  private Vector getConnectedEntities(org.w3c.dom.Node n) {
    Vector result = new Vector();
    NodeList nl = n.getChildNodes();
    for (int k = 0; k < nl.getLength(); k++) {
      org.w3c.dom.Node current = nl.item(k);
      if (current.getNodeName().equalsIgnoreCase("connected")) {
        String id = current.getAttributes().getNamedItem("id").getNodeValue();
        result.add(id);
      }
    }
    return result;
  }

  public void restoreModels(IDEState ids,GUIResources resources,
                            Document doc) throws CannotLoadDiagram {
    // For compatibility and in case a future different RM is needed
    RelationshipManager rm = new RelationshipManager();
    NodeList models = doc.getElementsByTagName("models").item(0).getChildNodes();
    boolean allrecovered = true;
    String failureMessage = "";

    for (int k = 0; k < models.getLength(); k++) {
      org.w3c.dom.Node model = models.item(k);
      String id = "";
      String type = "";
      try {
        if (model.getNodeName().equalsIgnoreCase("model")) {
          id = model.getAttributes().getNamedItem("id").getNodeValue().
              toString();
          Log.getInstance().logSYS("Loading model " + id);
          type = model.getAttributes().getNamedItem("type").getNodeValue().
              toString();
          this.restoreModel(ids, rm, model);
        }
      }
      catch (Exception e) {
        allrecovered = false;
        failureMessage = failureMessage + "\n Error loading model " + id +
            " of type " + type + ". Original error message was \n " +
            e.getMessage();
        e.printStackTrace();
      }
    }
    if (!allrecovered) {
      throw new CannotLoadDiagram(failureMessage);
    }
  }

  private void restoreModel(IDEState ids, RelationshipManager rm,
                            org.w3c.dom.Node model) throws ClassNotFoundException,
      IllegalAccessException, InstantiationException, NoSuchMethodException,
      InvocationTargetException {
    String id = model.getAttributes().getNamedItem("id").getNodeValue().
        toString();
    String type = model.getAttributes().getNamedItem("type").getNodeValue().
        toString();

    Object[] path = this.getModelPath(model, ids.gm);

    org.w3c.dom.Node graph = null;
    org.w3c.dom.Node layout = null;
    NodeList children = model.getChildNodes();
    ModelDataEntity mde = null;

    for (int j = 0; j < children.getLength(); j++) {

      org.w3c.dom.Node current = children.item(j);
      if (current.getNodeName().equalsIgnoreCase("object")) {
        mde = (ModelDataEntity) PersistenceManager.getOL().restoreObject(ids.om,
            ids.gm, current);
      }
      if (current.getNodeName().equalsIgnoreCase("gxl")) {
        NodeList gxls = current.getChildNodes();
        for (int l = 0; l < gxls.getLength(); l++) {
          org.w3c.dom.Node currentgxl = gxls.item(l);
          if (currentgxl.getNodeName().equalsIgnoreCase("graph")) {
            graph = currentgxl;
          }
          if (currentgxl.getNodeName().equalsIgnoreCase("layout")) {
            layout = currentgxl;
          }
        }
      }
    }
    ModelJGraph mjg = null;

    if (mde != null) {
        int indmarquee=type.indexOf("ModelJGraph");
        String marqueetype=type.substring(0,indmarquee)+"MarqueeHandler";
        Constructor consmarquee = Class.forName(marqueetype).getConstructor(new Class[]{Editor.class});
        Object marquee=consmarquee.newInstance(new Object[]{ids.editor});
        Class[] conspar = {
                mde.getClass(), ingenias.editor.Editor.class, String.class,ObjectManager.class, Model.class,BasicMarqueeHandler.class};
            Object[] valpar = {
                mde, ids.editor,id,ids.om,new Model(ids),marquee};
              
        Constructor cons= Class.forName(type).getConstructor(conspar);
        mjg = (ModelJGraph) cons.newInstance(valpar);
    }
    else {
      Class[] conspar = {
    		  ids.editor.getClass()};
      Object[] valpar = {
    		  ids.editor};
      Constructor cons = Class.forName(type).getConstructor(conspar);
      mjg = (ModelJGraph) cons.newInstance(valpar);
    }

    //mjg.setEditor(ids.editor);
    //mjg.setOM(ids.om);
    //mjg.setId(id);
    this.fromGXL(ids.om, rm, mjg, graph, layout);
    ids.gm.addModel(path, id, mjg);
    ids.editor.setEnabled(true);

  }

  private Object[] GXL2Array(org.w3c.dom.Node node) throws WrongTypedDOMNode {
    if (node.getNodeName().equals("array")) {
      try {
        Hashtable children = new Hashtable();

        // Obtain children
        NodeList values = node.getChildNodes();
        for (int k = 0; k < values.getLength(); k++) {
          try {
            children.put(new Integer(k), GXL2Object(values.item(k)));
          }
          catch (WrongTypedDOMNode e) {
            // It is not a valid child.
          }
        }

        Object[] array = new Object[children.size()];
        Iterator it = children.keySet().iterator();
        while (it.hasNext()) {
          Integer index = (Integer) it.next();
          array[index.intValue()] = children.get(index);
        }
        // Construct the Array
        return array;
      }
      catch (Exception e) {
        throw new WrongTypedDOMNode(node.toString() +
            "is a malformed representation of an Object[].");
      }
    }
    else {
      throw new WrongTypedDOMNode(node.toString() +
                                  "does not represent an Object[]");
    }
  }

  
  private List GXL2List(org.w3c.dom.Node node) throws WrongTypedDOMNode {
    if (node.getNodeName().equals("list")) {
      try {
        ArrayList children = new ArrayList();

        // Obtain children
        NodeList values = node.getChildNodes();
        int index = 0;
        for (int k = 0; k < values.getLength(); k++) {
          try {
            Object child = GXL2Object(values.item(k));
            children.add(index++, child);
          }
          catch (WrongTypedDOMNode e) {
            // It is not a valid child.
          }
        }
        // Construct the List
        return ( (List) children);
      }
      catch (Exception e) {
        throw new WrongTypedDOMNode(node.toString() +
                                    "is a malformed representation of an List.");
      }
    }
    else {
      throw new WrongTypedDOMNode(node.toString() +
                                  "does not represent an List");
    }
  }

  private Point GXL2Point(org.w3c.dom.Node node) throws WrongTypedDOMNode {
    if (node.getNodeName().equals("point")) {
      try {
        // Obtain attributes
        int x = (new Integer(node.getAttributes().getNamedItem("x").
                             getNodeValue())).intValue();
        int y = (new Integer(node.getAttributes().getNamedItem("y").
                             getNodeValue())).intValue();
        // Construct the Point
        return new Point(x, y);
      }
      catch (Exception e) {
        throw new WrongTypedDOMNode(node.toString() +
            "is a malformed representation of a java.awt.Point.");
      }
    }
    else {
      throw new WrongTypedDOMNode(node.toString() +
                                  "does not represent a java.awt.Point.");
    }
  }

  private Rectangle GXL2Rectangle(org.w3c.dom.Node node) throws WrongTypedDOMNode {
    if (node.getNodeName().equals("rectangle")) {
      try {
        // Obtain attributes
        int x = (new Integer(node.getAttributes().getNamedItem("x").
                             getNodeValue())).intValue();
        int y = (new Integer(node.getAttributes().getNamedItem("y").
                             getNodeValue())).intValue();
        int width = (new Integer(node.getAttributes().getNamedItem("width").
                                 getNodeValue())).intValue();
        int height = (new Integer(node.getAttributes().getNamedItem("height").
                                  getNodeValue())).intValue();
        // Construct the Rectangle
        return new Rectangle(x, y, width, height);
      }
      catch (Exception e) {
        throw new WrongTypedDOMNode(node.toString() +
            "is a malformed representation of a java.awt.Rectangle.");
      }
    }
    else {
      throw new WrongTypedDOMNode(node.toString() +
                                  "does not represent a java.awt.Rectangle.");
    }
  }

  private Object GXL2Object(org.w3c.dom.Node node) throws WrongTypedDOMNode {
    Object object = null;

    if (node.getNodeName().equals("point")) {
      object = GXL2Point(node);
    }
    else if (node.getNodeName().equals("rectangle")) {
      object = GXL2Rectangle(node);
    }
    else if (node.getNodeName().equals("list")) {
      object = GXL2List(node);
    }
    else if (node.getNodeName().equals("array")) {
      object = GXL2Array(node);
    }
    else if (node.getNodeName().equals("string")) {
      org.w3c.dom.Node labelNode = node.getFirstChild();
      if (labelNode != null) {
        object = (String) labelNode.getNodeValue();
      }
    }
    else if (node.getNodeName().equals("attr")) {
      NodeList values = node.getChildNodes();

      for (int k = 0; k < values.getLength(); k++) {
        try {
          Object objectAttr = GXL2Object(values.item(k));
          if (object == null) {
            object = objectAttr;
          }
        }
        catch (WrongTypedDOMNode e) {
        }
      }

      if (object == null) {
        throw new WrongTypedDOMNode(node.toString() +
                                    "does not represent any valid Object.");
      }
//        if (values.item(k).getNodeName().equals("string")) {
//          Node labelNode = values.item(k).getFirstChild();
//          if (labelNode != null)
//            object = (String) labelNode.getNodeValue();
//        }
    }
    else {
      throw new WrongTypedDOMNode(node.toString() +
                                  "does not represent any valid Object.");
    }

    return object;
  }

  // Fetch Cell Map from Node
  protected Hashtable getMap(org.w3c.dom.Node node) {

    Hashtable hashAttr = new Hashtable();

    try {
      // Common attributes
      hashAttr.put(new String("id"),
                   node.getAttributes().getNamedItem("id").getNodeValue());
      hashAttr.put(new String("type"),
                   node.getAttributes().getNamedItem("type").getNodeValue());
      // Edge attributes
      hashAttr.put("from",
                   node.getAttributes().getNamedItem("from").getNodeValue());
      hashAttr.put("to", node.getAttributes().getNamedItem("to").getNodeValue());
    }
    catch (Exception e) {
      // If the node is a vertex there is neither from nor to attributes.
    }
    // Node specific attributes
    NodeList children = node.getChildNodes();
    for (int j = 0; j < children.getLength(); j++) {
      org.w3c.dom.Node attr = children.item(j);
      try {
        Object object = GXL2Object(attr);
        hashAttr.put(attr.getAttributes().getNamedItem("name").getNodeValue(),
                     object);
      }
      catch (Exception e) {
        // The node is not a valid attribute.
      }
    }
//////////    return (lab != null) ? lab : new String("");
    return hashAttr;
  }

  // Gives the ports in the model related with GraphCells in vertexList.
  private Port[] getPorts(ModelJGraph graph, Object[] vertexList) {

    // Ports of argument vertexs.
    Port[] ports = new Port[vertexList.length];
    // Obtain the model.
    GraphModel model = graph.getModel();

    // Iterate over all Objects.
    for (int i = 0; i < vertexList.length; i++) {
      Port objectPort = null;
      // Iterate over all Children
      for (int j = 0; j < model.getChildCount(vertexList[i]); j++) {
        // Fetch the Child of Vertex at Index i
        Object child = model.getChild(vertexList[i], j);
        // Check if Child is a Port
        if (child instanceof Port) {

          // Return the Child as a Port
          objectPort = (Port) child;
        }
      }
      ports[i] = objectPort;
    }

    return ports;
  }

  public static void main(String[] args) {
    GraphLoadImp1 graphLoad1 = new GraphLoadImp1();
  }

}




