




/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz over original code from Ruben Fuentes
 * 
 *   Modifications over original code from jgraph.sourceforge.net
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.persistence;
import java.lang.reflect.*;
import javax.swing.tree.*;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.InputSource;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.OutputStreamWriter;
import java.io.*;
import javax.swing.tree.DefaultMutableTreeNode;
import java.util.*;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.xml.parsers.*;
import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.w3c.dom.*;
import org.w3c.dom.Document;
import org.w3c.dom.DOMImplementation;
import ingenias.editor.entities.*;
import ingenias.exception.*;
import ingenias.editor.cell.*;
import ingenias.editor.*;


public class GraphLoadImp2 extends GraphLoadImp2Abs
    implements GraphLoad {

  /**
   *  Constructor for the GraphLoad object
   */
  public GraphLoadImp2() {}


  // Convert a vertex represented by a GXL DOM node in a DefaultGraphCell.
  // ids contains the already processed vertex ids.

  protected DefaultGraphCell GXLVertex(String id, String type, ModelJGraph graph,
                                    ObjectManager om, RelationshipManager rm) {

    DefaultGraphCell vertex = null;

    ingenias.editor.entities.Entity en = om.getEntity(id, type);
    // if it is registered in the OM, then it is a diagram object
    if (en != null) {


   	if (en.getClass().equals(ingenias.editor.entities.Dishwasher.class))
	  return  new ingenias.editor.cell.DishwasherCell((ingenias.editor.entities.Dishwasher)en);

   	if (en.getClass().equals(ingenias.editor.entities.PerceptionEvent.class))
	  return  new ingenias.editor.cell.PerceptionEventCell((ingenias.editor.entities.PerceptionEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.DeviceVar.class))
	  return  new ingenias.editor.cell.DeviceVarCell((ingenias.editor.entities.DeviceVar)en);

   	if (en.getClass().equals(ingenias.editor.entities.ArithmeticExpression.class))
	  return  new ingenias.editor.cell.ArithmeticExpressionCell((ingenias.editor.entities.ArithmeticExpression)en);

   	if (en.getClass().equals(ingenias.editor.entities.SwitchLightAction.class))
	  return  new ingenias.editor.cell.SwitchLightActionCell((ingenias.editor.entities.SwitchLightAction)en);

   	if (en.getClass().equals(ingenias.editor.entities.SeatVar.class))
	  return  new ingenias.editor.cell.SeatVarCell((ingenias.editor.entities.SeatVar)en);

   	if (en.getClass().equals(ingenias.editor.entities.Shower.class))
	  return  new ingenias.editor.cell.ShowerCell((ingenias.editor.entities.Shower)en);

   	if (en.getClass().equals(ingenias.editor.entities.ProgramState.class))
	  return  new ingenias.editor.cell.ProgramStateCell((ingenias.editor.entities.ProgramState)en);

   	if (en.getClass().equals(ingenias.editor.entities.FOWashbasin.class))
	  return  new ingenias.editor.cell.FOWashbasinCell((ingenias.editor.entities.FOWashbasin)en);

   	if (en.getClass().equals(ingenias.editor.entities.FDelayFilter.class))
	  return  new ingenias.editor.cell.FDelayFilterCell((ingenias.editor.entities.FDelayFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.CObjWeight.class))
	  return  new ingenias.editor.cell.CObjWeightCell((ingenias.editor.entities.CObjWeight)en);

   	if (en.getClass().equals(ingenias.editor.entities.Var.class))
	  return  new ingenias.editor.cell.VarCell((ingenias.editor.entities.Var)en);

   	if (en.getClass().equals(ingenias.editor.entities.WorldInitialization.class))
	  return  new ingenias.editor.cell.WorldInitializationCell((ingenias.editor.entities.WorldInitialization)en);

   	if (en.getClass().equals(ingenias.editor.entities.HumanProfile.class))
	  return  new ingenias.editor.cell.HumanProfileCell((ingenias.editor.entities.HumanProfile)en);

   	if (en.getClass().equals(ingenias.editor.entities.FOBath.class))
	  return  new ingenias.editor.cell.FOBathCell((ingenias.editor.entities.FOBath)en);

   	if (en.getClass().equals(ingenias.editor.entities.PDSymtom.class))
	  return  new ingenias.editor.cell.PDSymtomCell((ingenias.editor.entities.PDSymtom)en);

   	if (en.getClass().equals(ingenias.editor.entities.HumanNorm.class))
	  return  new ingenias.editor.cell.HumanNormCell((ingenias.editor.entities.HumanNorm)en);

   	if (en.getClass().equals(ingenias.editor.entities.DiseaseProfile.class))
	  return  new ingenias.editor.cell.DiseaseProfileCell((ingenias.editor.entities.DiseaseProfile)en);

   	if (en.getClass().equals(ingenias.editor.entities.BGetUpFromBed.class))
	  return  new ingenias.editor.cell.BGetUpFromBedCell((ingenias.editor.entities.BGetUpFromBed)en);

   	if (en.getClass().equals(ingenias.editor.entities.GenericDisease.class))
	  return  new ingenias.editor.cell.GenericDiseaseCell((ingenias.editor.entities.GenericDisease)en);

   	if (en.getClass().equals(ingenias.editor.entities.CSay.class))
	  return  new ingenias.editor.cell.CSayCell((ingenias.editor.entities.CSay)en);

   	if (en.getClass().equals(ingenias.editor.entities.SwipeTask.class))
	  return  new ingenias.editor.cell.SwipeTaskCell((ingenias.editor.entities.SwipeTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.StopBehaviourEvent.class))
	  return  new ingenias.editor.cell.StopBehaviourEventCell((ingenias.editor.entities.StopBehaviourEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.SVerticalSpace.class))
	  return  new ingenias.editor.cell.SVerticalSpaceCell((ingenias.editor.entities.SVerticalSpace)en);

   	if (en.getClass().equals(ingenias.editor.entities.PersonalInfo.class))
	  return  new ingenias.editor.cell.PersonalInfoCell((ingenias.editor.entities.PersonalInfo)en);

   	if (en.getClass().equals(ingenias.editor.entities.CAlways.class))
	  return  new ingenias.editor.cell.CAlwaysCell((ingenias.editor.entities.CAlways)en);

   	if (en.getClass().equals(ingenias.editor.entities.ObjectVar.class))
	  return  new ingenias.editor.cell.ObjectVarCell((ingenias.editor.entities.ObjectVar)en);

   	if (en.getClass().equals(ingenias.editor.entities.MedsTakenEvent.class))
	  return  new ingenias.editor.cell.MedsTakenEventCell((ingenias.editor.entities.MedsTakenEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.Extractor.class))
	  return  new ingenias.editor.cell.ExtractorCell((ingenias.editor.entities.Extractor)en);

   	if (en.getClass().equals(ingenias.editor.entities.SSpatial.class))
	  return  new ingenias.editor.cell.SSpatialCell((ingenias.editor.entities.SSpatial)en);

   	if (en.getClass().equals(ingenias.editor.entities.FBed.class))
	  return  new ingenias.editor.cell.FBedCell((ingenias.editor.entities.FBed)en);

   	if (en.getClass().equals(ingenias.editor.entities.BECollision.class))
	  return  new ingenias.editor.cell.BECollisionCell((ingenias.editor.entities.BECollision)en);

   	if (en.getClass().equals(ingenias.editor.entities.SociAALEntity.class))
	  return  new ingenias.editor.cell.SociAALEntityCell((ingenias.editor.entities.SociAALEntity)en);

   	if (en.getClass().equals(ingenias.editor.entities.DComputer.class))
	  return  new ingenias.editor.cell.DComputerCell((ingenias.editor.entities.DComputer)en);

   	if (en.getClass().equals(ingenias.editor.entities.Shirt.class))
	  return  new ingenias.editor.cell.ShirtCell((ingenias.editor.entities.Shirt)en);

   	if (en.getClass().equals(ingenias.editor.entities.Shoes.class))
	  return  new ingenias.editor.cell.ShoesCell((ingenias.editor.entities.Shoes)en);

   	if (en.getClass().equals(ingenias.editor.entities.AndroidEmulator.class))
	  return  new ingenias.editor.cell.AndroidEmulatorCell((ingenias.editor.entities.AndroidEmulator)en);

   	if (en.getClass().equals(ingenias.editor.entities.PlayAnimationTask.class))
	  return  new ingenias.editor.cell.PlayAnimationTaskCell((ingenias.editor.entities.PlayAnimationTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.SymptomChangedEvent.class))
	  return  new ingenias.editor.cell.SymptomChangedEventCell((ingenias.editor.entities.SymptomChangedEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.Bridge.class))
	  return  new ingenias.editor.cell.BridgeCell((ingenias.editor.entities.Bridge)en);

   	if (en.getClass().equals(ingenias.editor.entities.EMobileDevice.class))
	  return  new ingenias.editor.cell.EMobileDeviceCell((ingenias.editor.entities.EMobileDevice)en);

   	if (en.getClass().equals(ingenias.editor.entities.FOSink.class))
	  return  new ingenias.editor.cell.FOSinkCell((ingenias.editor.entities.FOSink)en);

   	if (en.getClass().equals(ingenias.editor.entities.CProb.class))
	  return  new ingenias.editor.cell.CProbCell((ingenias.editor.entities.CProb)en);

   	if (en.getClass().equals(ingenias.editor.entities.EWaterBottle.class))
	  return  new ingenias.editor.cell.EWaterBottleCell((ingenias.editor.entities.EWaterBottle)en);

   	if (en.getClass().equals(ingenias.editor.entities.BENewObjInFieldOfVision.class))
	  return  new ingenias.editor.cell.BENewObjInFieldOfVisionCell((ingenias.editor.entities.BENewObjInFieldOfVision)en);

   	if (en.getClass().equals(ingenias.editor.entities.SBathroom.class))
	  return  new ingenias.editor.cell.SBathroomCell((ingenias.editor.entities.SBathroom)en);

   	if (en.getClass().equals(ingenias.editor.entities.Crutch.class))
	  return  new ingenias.editor.cell.CrutchCell((ingenias.editor.entities.Crutch)en);

   	if (en.getClass().equals(ingenias.editor.entities.Staircase.class))
	  return  new ingenias.editor.cell.StaircaseCell((ingenias.editor.entities.Staircase)en);

   	if (en.getClass().equals(ingenias.editor.entities.FChangeTargetObjFilter.class))
	  return  new ingenias.editor.cell.FChangeTargetObjFilterCell((ingenias.editor.entities.FChangeTargetObjFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.SBedroom.class))
	  return  new ingenias.editor.cell.SBedroomCell((ingenias.editor.entities.SBedroom)en);

   	if (en.getClass().equals(ingenias.editor.entities.AEDiv.class))
	  return  new ingenias.editor.cell.AEDivCell((ingenias.editor.entities.AEDiv)en);

   	if (en.getClass().equals(ingenias.editor.entities.VibrateEvent.class))
	  return  new ingenias.editor.cell.VibrateEventCell((ingenias.editor.entities.VibrateEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.WearableVar.class))
	  return  new ingenias.editor.cell.WearableVarCell((ingenias.editor.entities.WearableVar)en);

   	if (en.getClass().equals(ingenias.editor.entities.DoorStateCondition.class))
	  return  new ingenias.editor.cell.DoorStateConditionCell((ingenias.editor.entities.DoorStateCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.WaitForBodyClose.class))
	  return  new ingenias.editor.cell.WaitForBodyCloseCell((ingenias.editor.entities.WaitForBodyClose)en);

   	if (en.getClass().equals(ingenias.editor.entities.BPickUpTask.class))
	  return  new ingenias.editor.cell.BPickUpTaskCell((ingenias.editor.entities.BPickUpTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.Doorbell.class))
	  return  new ingenias.editor.cell.DoorbellCell((ingenias.editor.entities.Doorbell)en);

   	if (en.getClass().equals(ingenias.editor.entities.SArea.class))
	  return  new ingenias.editor.cell.SAreaCell((ingenias.editor.entities.SArea)en);

   	if (en.getClass().equals(ingenias.editor.entities.CloseTask.class))
	  return  new ingenias.editor.cell.CloseTaskCell((ingenias.editor.entities.CloseTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.PartOfBody.class))
	  return  new ingenias.editor.cell.PartOfBodyCell((ingenias.editor.entities.PartOfBody)en);

   	if (en.getClass().equals(ingenias.editor.entities.LightStateCondition.class))
	  return  new ingenias.editor.cell.LightStateConditionCell((ingenias.editor.entities.LightStateCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.PrimitiveVar.class))
	  return  new ingenias.editor.cell.PrimitiveVarCell((ingenias.editor.entities.PrimitiveVar)en);

   	if (en.getClass().equals(ingenias.editor.entities.AEAddSub.class))
	  return  new ingenias.editor.cell.AEAddSubCell((ingenias.editor.entities.AEAddSub)en);

   	if (en.getClass().equals(ingenias.editor.entities.FSofa.class))
	  return  new ingenias.editor.cell.FSofaCell((ingenias.editor.entities.FSofa)en);

   	if (en.getClass().equals(ingenias.editor.entities.EPublicEvent.class))
	  return  new ingenias.editor.cell.EPublicEventCell((ingenias.editor.entities.EPublicEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.PutOnTask.class))
	  return  new ingenias.editor.cell.PutOnTaskCell((ingenias.editor.entities.PutOnTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.SFloor.class))
	  return  new ingenias.editor.cell.SFloorCell((ingenias.editor.entities.SFloor)en);

   	if (en.getClass().equals(ingenias.editor.entities.HIGHSympLevelState.class))
	  return  new ingenias.editor.cell.HIGHSympLevelStateCell((ingenias.editor.entities.HIGHSympLevelState)en);

   	if (en.getClass().equals(ingenias.editor.entities.AEInv.class))
	  return  new ingenias.editor.cell.AEInvCell((ingenias.editor.entities.AEInv)en);

   	if (en.getClass().equals(ingenias.editor.entities.EMobileObject.class))
	  return  new ingenias.editor.cell.EMobileObjectCell((ingenias.editor.entities.EMobileObject)en);

   	if (en.getClass().equals(ingenias.editor.entities.SayTask.class))
	  return  new ingenias.editor.cell.SayTaskCell((ingenias.editor.entities.SayTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.HearingEvent.class))
	  return  new ingenias.editor.cell.HearingEventCell((ingenias.editor.entities.HearingEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.BEObjOutFielOfVision.class))
	  return  new ingenias.editor.cell.BEObjOutFielOfVisionCell((ingenias.editor.entities.BEObjOutFielOfVision)en);

   	if (en.getClass().equals(ingenias.editor.entities.ERemoteControl.class))
	  return  new ingenias.editor.cell.ERemoteControlCell((ingenias.editor.entities.ERemoteControl)en);

   	if (en.getClass().equals(ingenias.editor.entities.SymptomLevelState.class))
	  return  new ingenias.editor.cell.SymptomLevelStateCell((ingenias.editor.entities.SymptomLevelState)en);

   	if (en.getClass().equals(ingenias.editor.entities.EMobileFurniture.class))
	  return  new ingenias.editor.cell.EMobileFurnitureCell((ingenias.editor.entities.EMobileFurniture)en);

   	if (en.getClass().equals(ingenias.editor.entities.Param.class))
	  return  new ingenias.editor.cell.ParamCell((ingenias.editor.entities.Param)en);

   	if (en.getClass().equals(ingenias.editor.entities.MessageListenedEvent.class))
	  return  new ingenias.editor.cell.MessageListenedEventCell((ingenias.editor.entities.MessageListenedEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.SDate.class))
	  return  new ingenias.editor.cell.SDateCell((ingenias.editor.entities.SDate)en);

   	if (en.getClass().equals(ingenias.editor.entities.BUseTask.class))
	  return  new ingenias.editor.cell.BUseTaskCell((ingenias.editor.entities.BUseTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.BodyEvent.class))
	  return  new ingenias.editor.cell.BodyEventCell((ingenias.editor.entities.BodyEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.CompCondition.class))
	  return  new ingenias.editor.cell.CompConditionCell((ingenias.editor.entities.CompCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.Trousers.class))
	  return  new ingenias.editor.cell.TrousersCell((ingenias.editor.entities.Trousers)en);

   	if (en.getClass().equals(ingenias.editor.entities.FallingEvent.class))
	  return  new ingenias.editor.cell.FallingEventCell((ingenias.editor.entities.FallingEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.EFixedDevice.class))
	  return  new ingenias.editor.cell.EFixedDeviceCell((ingenias.editor.entities.EFixedDevice)en);

   	if (en.getClass().equals(ingenias.editor.entities.Condition.class))
	  return  new ingenias.editor.cell.ConditionCell((ingenias.editor.entities.Condition)en);

   	if (en.getClass().equals(ingenias.editor.entities.CReceiveHelp.class))
	  return  new ingenias.editor.cell.CReceiveHelpCell((ingenias.editor.entities.CReceiveHelp)en);

   	if (en.getClass().equals(ingenias.editor.entities.WearableParam.class))
	  return  new ingenias.editor.cell.WearableParamCell((ingenias.editor.entities.WearableParam)en);

   	if (en.getClass().equals(ingenias.editor.entities.WashMachine.class))
	  return  new ingenias.editor.cell.WashMachineCell((ingenias.editor.entities.WashMachine)en);

   	if (en.getClass().equals(ingenias.editor.entities.FlyCamInit.class))
	  return  new ingenias.editor.cell.FlyCamInitCell((ingenias.editor.entities.FlyCamInit)en);

   	if (en.getClass().equals(ingenias.editor.entities.VibrateDeviceAction.class))
	  return  new ingenias.editor.cell.VibrateDeviceActionCell((ingenias.editor.entities.VibrateDeviceAction)en);

   	if (en.getClass().equals(ingenias.editor.entities.Appliance.class))
	  return  new ingenias.editor.cell.ApplianceCell((ingenias.editor.entities.Appliance)en);

   	if (en.getClass().equals(ingenias.editor.entities.MedInjection.class))
	  return  new ingenias.editor.cell.MedInjectionCell((ingenias.editor.entities.MedInjection)en);

   	if (en.getClass().equals(ingenias.editor.entities.ADLProfile.class))
	  return  new ingenias.editor.cell.ADLProfileCell((ingenias.editor.entities.ADLProfile)en);

   	if (en.getClass().equals(ingenias.editor.entities.DTV.class))
	  return  new ingenias.editor.cell.DTVCell((ingenias.editor.entities.DTV)en);

   	if (en.getClass().equals(ingenias.editor.entities.BSimpleTask.class))
	  return  new ingenias.editor.cell.BSimpleTaskCell((ingenias.editor.entities.BSimpleTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.EWearable.class))
	  return  new ingenias.editor.cell.EWearableCell((ingenias.editor.entities.EWearable)en);

   	if (en.getClass().equals(ingenias.editor.entities.DeviceParam.class))
	  return  new ingenias.editor.cell.DeviceParamCell((ingenias.editor.entities.DeviceParam)en);

   	if (en.getClass().equals(ingenias.editor.entities.EMedicine.class))
	  return  new ingenias.editor.cell.EMedicineCell((ingenias.editor.entities.EMedicine)en);

   	if (en.getClass().equals(ingenias.editor.entities.AENumConst.class))
	  return  new ingenias.editor.cell.AENumConstCell((ingenias.editor.entities.AENumConst)en);

   	if (en.getClass().equals(ingenias.editor.entities.LOWTaskFilterR.class))
	  return  new ingenias.editor.cell.LOWTaskFilterRCell((ingenias.editor.entities.LOWTaskFilterR)en);

   	if (en.getClass().equals(ingenias.editor.entities.TakeOffTask.class))
	  return  new ingenias.editor.cell.TakeOffTaskCell((ingenias.editor.entities.TakeOffTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.EatableItem.class))
	  return  new ingenias.editor.cell.EatableItemCell((ingenias.editor.entities.EatableItem)en);

   	if (en.getClass().equals(ingenias.editor.entities.EPhysicalEntity.class))
	  return  new ingenias.editor.cell.EPhysicalEntityCell((ingenias.editor.entities.EPhysicalEntity)en);

   	if (en.getClass().equals(ingenias.editor.entities.SocialProfile.class))
	  return  new ingenias.editor.cell.SocialProfileCell((ingenias.editor.entities.SocialProfile)en);

   	if (en.getClass().equals(ingenias.editor.entities.NotCondition.class))
	  return  new ingenias.editor.cell.NotConditionCell((ingenias.editor.entities.NotCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.BEObjectMoving.class))
	  return  new ingenias.editor.cell.BEObjectMovingCell((ingenias.editor.entities.BEObjectMoving)en);

   	if (en.getClass().equals(ingenias.editor.entities.DropObj.class))
	  return  new ingenias.editor.cell.DropObjCell((ingenias.editor.entities.DropObj)en);

   	if (en.getClass().equals(ingenias.editor.entities.EFixedObject.class))
	  return  new ingenias.editor.cell.EFixedObjectCell((ingenias.editor.entities.EFixedObject)en);

   	if (en.getClass().equals(ingenias.editor.entities.IsThingInRoomCondition.class))
	  return  new ingenias.editor.cell.IsThingInRoomConditionCell((ingenias.editor.entities.IsThingInRoomCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.PlaceParam.class))
	  return  new ingenias.editor.cell.PlaceParamCell((ingenias.editor.entities.PlaceParam)en);

   	if (en.getClass().equals(ingenias.editor.entities.CTimer.class))
	  return  new ingenias.editor.cell.CTimerCell((ingenias.editor.entities.CTimer)en);

   	if (en.getClass().equals(ingenias.editor.entities.Human.class))
	  return  new ingenias.editor.cell.HumanCell((ingenias.editor.entities.Human)en);

   	if (en.getClass().equals(ingenias.editor.entities.CInside.class))
	  return  new ingenias.editor.cell.CInsideCell((ingenias.editor.entities.CInside)en);

   	if (en.getClass().equals(ingenias.editor.entities.AEMult.class))
	  return  new ingenias.editor.cell.AEMultCell((ingenias.editor.entities.AEMult)en);

   	if (en.getClass().equals(ingenias.editor.entities.VisionEvent.class))
	  return  new ingenias.editor.cell.VisionEventCell((ingenias.editor.entities.VisionEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.SeatParam.class))
	  return  new ingenias.editor.cell.SeatParamCell((ingenias.editor.entities.SeatParam)en);

   	if (en.getClass().equals(ingenias.editor.entities.EASubSubSub.class))
	  return  new ingenias.editor.cell.EASubSubSubCell((ingenias.editor.entities.EASubSubSub)en);

   	if (en.getClass().equals(ingenias.editor.entities.ELivingBeing.class))
	  return  new ingenias.editor.cell.ELivingBeingCell((ingenias.editor.entities.ELivingBeing)en);

   	if (en.getClass().equals(ingenias.editor.entities.SwitchLightTask.class))
	  return  new ingenias.editor.cell.SwitchLightTaskCell((ingenias.editor.entities.SwitchLightTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.SpatialVar.class))
	  return  new ingenias.editor.cell.SpatialVarCell((ingenias.editor.entities.SpatialVar)en);

   	if (en.getClass().equals(ingenias.editor.entities.Lift.class))
	  return  new ingenias.editor.cell.LiftCell((ingenias.editor.entities.Lift)en);

   	if (en.getClass().equals(ingenias.editor.entities.StandUp.class))
	  return  new ingenias.editor.cell.StandUpCell((ingenias.editor.entities.StandUp)en);

   	if (en.getClass().equals(ingenias.editor.entities.FallTask.class))
	  return  new ingenias.editor.cell.FallTaskCell((ingenias.editor.entities.FallTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.EPrivateEvent.class))
	  return  new ingenias.editor.cell.EPrivateEventCell((ingenias.editor.entities.EPrivateEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.NONESympLevelState.class))
	  return  new ingenias.editor.cell.NONESympLevelStateCell((ingenias.editor.entities.NONESympLevelState)en);

   	if (en.getClass().equals(ingenias.editor.entities.MEDIUMTaskFilterR.class))
	  return  new ingenias.editor.cell.MEDIUMTaskFilterRCell((ingenias.editor.entities.MEDIUMTaskFilterR)en);

   	if (en.getClass().equals(ingenias.editor.entities.GoToBodyLoc.class))
	  return  new ingenias.editor.cell.GoToBodyLocCell((ingenias.editor.entities.GoToBodyLoc)en);

   	if (en.getClass().equals(ingenias.editor.entities.TaskFilterRef.class))
	  return  new ingenias.editor.cell.TaskFilterRefCell((ingenias.editor.entities.TaskFilterRef)en);

   	if (en.getClass().equals(ingenias.editor.entities.GoIntoBed.class))
	  return  new ingenias.editor.cell.GoIntoBedCell((ingenias.editor.entities.GoIntoBed)en);

   	if (en.getClass().equals(ingenias.editor.entities.AEVariable.class))
	  return  new ingenias.editor.cell.AEVariableCell((ingenias.editor.entities.AEVariable)en);

   	if (en.getClass().equals(ingenias.editor.entities.FTaskSelectorFilter.class))
	  return  new ingenias.editor.cell.FTaskSelectorFilterCell((ingenias.editor.entities.FTaskSelectorFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.BSimpleDurationTask.class))
	  return  new ingenias.editor.cell.BSimpleDurationTaskCell((ingenias.editor.entities.BSimpleDurationTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.Walker.class))
	  return  new ingenias.editor.cell.WalkerCell((ingenias.editor.entities.Walker)en);

   	if (en.getClass().equals(ingenias.editor.entities.OpenTask.class))
	  return  new ingenias.editor.cell.OpenTaskCell((ingenias.editor.entities.OpenTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.SCorridor.class))
	  return  new ingenias.editor.cell.SCorridorCell((ingenias.editor.entities.SCorridor)en);

   	if (en.getClass().equals(ingenias.editor.entities.FModifyPlaceFilter.class))
	  return  new ingenias.editor.cell.FModifyPlaceFilterCell((ingenias.editor.entities.FModifyPlaceFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.FTable.class))
	  return  new ingenias.editor.cell.FTableCell((ingenias.editor.entities.FTable)en);

   	if (en.getClass().equals(ingenias.editor.entities.DrinkItem.class))
	  return  new ingenias.editor.cell.DrinkItemCell((ingenias.editor.entities.DrinkItem)en);

   	if (en.getClass().equals(ingenias.editor.entities.FallSleep.class))
	  return  new ingenias.editor.cell.FallSleepCell((ingenias.editor.entities.FallSleep)en);

   	if (en.getClass().equals(ingenias.editor.entities.BActivity.class))
	  return  new ingenias.editor.cell.BActivityCell((ingenias.editor.entities.BActivity)en);

   	if (en.getClass().equals(ingenias.editor.entities.AnotherActionHappens.class))
	  return  new ingenias.editor.cell.AnotherActionHappensCell((ingenias.editor.entities.AnotherActionHappens)en);

   	if (en.getClass().equals(ingenias.editor.entities.WaitTask.class))
	  return  new ingenias.editor.cell.WaitTaskCell((ingenias.editor.entities.WaitTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.HumanParam.class))
	  return  new ingenias.editor.cell.HumanParamCell((ingenias.editor.entities.HumanParam)en);

   	if (en.getClass().equals(ingenias.editor.entities.BEvent.class))
	  return  new ingenias.editor.cell.BEventCell((ingenias.editor.entities.BEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.BDeviceAction.class))
	  return  new ingenias.editor.cell.BDeviceActionCell((ingenias.editor.entities.BDeviceAction)en);

   	if (en.getClass().equals(ingenias.editor.entities.FChair.class))
	  return  new ingenias.editor.cell.FChairCell((ingenias.editor.entities.FChair)en);

   	if (en.getClass().equals(ingenias.editor.entities.SLivingroom.class))
	  return  new ingenias.editor.cell.SLivingroomCell((ingenias.editor.entities.SLivingroom)en);

   	if (en.getClass().equals(ingenias.editor.entities.DeviceEvent.class))
	  return  new ingenias.editor.cell.DeviceEventCell((ingenias.editor.entities.DeviceEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.TimeInterval.class))
	  return  new ingenias.editor.cell.TimeIntervalCell((ingenias.editor.entities.TimeInterval)en);

   	if (en.getClass().equals(ingenias.editor.entities.IncomingCallAction.class))
	  return  new ingenias.editor.cell.IncomingCallActionCell((ingenias.editor.entities.IncomingCallAction)en);

   	if (en.getClass().equals(ingenias.editor.entities.PresenceSensorStateCondition.class))
	  return  new ingenias.editor.cell.PresenceSensorStateConditionCell((ingenias.editor.entities.PresenceSensorStateCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.SRoom.class))
	  return  new ingenias.editor.cell.SRoomCell((ingenias.editor.entities.SRoom)en);

   	if (en.getClass().equals(ingenias.editor.entities.MEDIUMSympLevelState.class))
	  return  new ingenias.editor.cell.MEDIUMSympLevelStateCell((ingenias.editor.entities.MEDIUMSympLevelState)en);

   	if (en.getClass().equals(ingenias.editor.entities.BodyStateCondition.class))
	  return  new ingenias.editor.cell.BodyStateConditionCell((ingenias.editor.entities.BodyStateCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.EBehaviourEvent.class))
	  return  new ingenias.editor.cell.EBehaviourEventCell((ingenias.editor.entities.EBehaviourEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.FReplaceTaskFilter.class))
	  return  new ingenias.editor.cell.FReplaceTaskFilterCell((ingenias.editor.entities.FReplaceTaskFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.BTask.class))
	  return  new ingenias.editor.cell.BTaskCell((ingenias.editor.entities.BTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.LOWSympLevelState.class))
	  return  new ingenias.editor.cell.LOWSympLevelStateCell((ingenias.editor.entities.LOWSympLevelState)en);

   	if (en.getClass().equals(ingenias.editor.entities.FUnableFilter.class))
	  return  new ingenias.editor.cell.FUnableFilterCell((ingenias.editor.entities.FUnableFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.FChangeToolFilter.class))
	  return  new ingenias.editor.cell.FChangeToolFilterCell((ingenias.editor.entities.FChangeToolFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.AESub.class))
	  return  new ingenias.editor.cell.AESubCell((ingenias.editor.entities.AESub)en);

   	if (en.getClass().equals(ingenias.editor.entities.HumanVar.class))
	  return  new ingenias.editor.cell.HumanVarCell((ingenias.editor.entities.HumanVar)en);

   	if (en.getClass().equals(ingenias.editor.entities.AESubSub.class))
	  return  new ingenias.editor.cell.AESubSubCell((ingenias.editor.entities.AESubSub)en);

   	if (en.getClass().equals(ingenias.editor.entities.CSymptom.class))
	  return  new ingenias.editor.cell.CSymptomCell((ingenias.editor.entities.CSymptom)en);

   	if (en.getClass().equals(ingenias.editor.entities.ParkinsonsProfile.class))
	  return  new ingenias.editor.cell.ParkinsonsProfileCell((ingenias.editor.entities.ParkinsonsProfile)en);

   	if (en.getClass().equals(ingenias.editor.entities.EventProcessor.class))
	  return  new ingenias.editor.cell.EventProcessorCell((ingenias.editor.entities.EventProcessor)en);

   	if (en.getClass().equals(ingenias.editor.entities.ObjectParam.class))
	  return  new ingenias.editor.cell.ObjectParamCell((ingenias.editor.entities.ObjectParam)en);

   	if (en.getClass().equals(ingenias.editor.entities.FSeat.class))
	  return  new ingenias.editor.cell.FSeatCell((ingenias.editor.entities.FSeat)en);

   	if (en.getClass().equals(ingenias.editor.entities.BLeaveTask.class))
	  return  new ingenias.editor.cell.BLeaveTaskCell((ingenias.editor.entities.BLeaveTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.CDayOfTheWeek.class))
	  return  new ingenias.editor.cell.CDayOfTheWeekCell((ingenias.editor.entities.CDayOfTheWeek)en);

   	if (en.getClass().equals(ingenias.editor.entities.PrimitiveParam.class))
	  return  new ingenias.editor.cell.PrimitiveParamCell((ingenias.editor.entities.PrimitiveParam)en);

   	if (en.getClass().equals(ingenias.editor.entities.CallStateEvent.class))
	  return  new ingenias.editor.cell.CallStateEventCell((ingenias.editor.entities.CallStateEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.SKitchen.class))
	  return  new ingenias.editor.cell.SKitchenCell((ingenias.editor.entities.SKitchen)en);

   	if (en.getClass().equals(ingenias.editor.entities.FOWater.class))
	  return  new ingenias.editor.cell.FOWaterCell((ingenias.editor.entities.FOWater)en);

   	if (en.getClass().equals(ingenias.editor.entities.Eat.class))
	  return  new ingenias.editor.cell.EatCell((ingenias.editor.entities.Eat)en);

   	if (en.getClass().equals(ingenias.editor.entities.TouchEvent.class))
	  return  new ingenias.editor.cell.TouchEventCell((ingenias.editor.entities.TouchEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.Shocks.class))
	  return  new ingenias.editor.cell.ShocksCell((ingenias.editor.entities.Shocks)en);

   	if (en.getClass().equals(ingenias.editor.entities.BSequentialTask.class))
	  return  new ingenias.editor.cell.BSequentialTaskCell((ingenias.editor.entities.BSequentialTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.InitProgramPool.class))
	  return  new ingenias.editor.cell.InitProgramPoolCell((ingenias.editor.entities.InitProgramPool)en);

   	if (en.getClass().equals(ingenias.editor.entities.StartBehaviourEvent.class))
	  return  new ingenias.editor.cell.StartBehaviourEventCell((ingenias.editor.entities.StartBehaviourEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.HumanInitialization.class))
	  return  new ingenias.editor.cell.HumanInitializationCell((ingenias.editor.entities.HumanInitialization)en);

   	if (en.getClass().equals(ingenias.editor.entities.Behaviour.class))
	  return  new ingenias.editor.cell.BehaviourCell((ingenias.editor.entities.Behaviour)en);

   	if (en.getClass().equals(ingenias.editor.entities.BEVibration.class))
	  return  new ingenias.editor.cell.BEVibrationCell((ingenias.editor.entities.BEVibration)en);

   	if (en.getClass().equals(ingenias.editor.entities.CTime.class))
	  return  new ingenias.editor.cell.CTimeCell((ingenias.editor.entities.CTime)en);

   	if (en.getClass().equals(ingenias.editor.entities.ConsecutiveActions.class))
	  return  new ingenias.editor.cell.ConsecutiveActionsCell((ingenias.editor.entities.ConsecutiveActions)en);

   	if (en.getClass().equals(ingenias.editor.entities.DiseaseStage.class))
	  return  new ingenias.editor.cell.DiseaseStageCell((ingenias.editor.entities.DiseaseStage)en);

   	if (en.getClass().equals(ingenias.editor.entities.AndroidApplication.class))
	  return  new ingenias.editor.cell.AndroidApplicationCell((ingenias.editor.entities.AndroidApplication)en);

   	if (en.getClass().equals(ingenias.editor.entities.AEAddition.class))
	  return  new ingenias.editor.cell.AEAdditionCell((ingenias.editor.entities.AEAddition)en);

   	if (en.getClass().equals(ingenias.editor.entities.BRandomTask.class))
	  return  new ingenias.editor.cell.BRandomTaskCell((ingenias.editor.entities.BRandomTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.SitDown.class))
	  return  new ingenias.editor.cell.SitDownCell((ingenias.editor.entities.SitDown)en);

   	if (en.getClass().equals(ingenias.editor.entities.SocialNetwork.class))
	  return  new ingenias.editor.cell.SocialNetworkCell((ingenias.editor.entities.SocialNetwork)en);

   	if (en.getClass().equals(ingenias.editor.entities.CEvent.class))
	  return  new ingenias.editor.cell.CEventCell((ingenias.editor.entities.CEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.InitialPreDefPos.class))
	  return  new ingenias.editor.cell.InitialPreDefPosCell((ingenias.editor.entities.InitialPreDefPos)en);

   	if (en.getClass().equals(ingenias.editor.entities.ClockTime.class))
	  return  new ingenias.editor.cell.ClockTimeCell((ingenias.editor.entities.ClockTime)en);

   	if (en.getClass().equals(ingenias.editor.entities.AEMulDiv.class))
	  return  new ingenias.editor.cell.AEMulDivCell((ingenias.editor.entities.AEMulDiv)en);

   	if (en.getClass().equals(ingenias.editor.entities.FModifyFilter.class))
	  return  new ingenias.editor.cell.FModifyFilterCell((ingenias.editor.entities.FModifyFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.InteractionProfile.class))
	  return  new ingenias.editor.cell.InteractionProfileCell((ingenias.editor.entities.InteractionProfile)en);

   	if (en.getClass().equals(ingenias.editor.entities.TapXYTask.class))
	  return  new ingenias.editor.cell.TapXYTaskCell((ingenias.editor.entities.TapXYTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.CameraInit.class))
	  return  new ingenias.editor.cell.CameraInitCell((ingenias.editor.entities.CameraInit)en);

   	if (en.getClass().equals(ingenias.editor.entities.MedIntake.class))
	  return  new ingenias.editor.cell.MedIntakeCell((ingenias.editor.entities.MedIntake)en);

   	if (en.getClass().equals(ingenias.editor.entities.BWakeUpTask.class))
	  return  new ingenias.editor.cell.BWakeUpTaskCell((ingenias.editor.entities.BWakeUpTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.HIGHTaskFilterR.class))
	  return  new ingenias.editor.cell.HIGHTaskFilterRCell((ingenias.editor.entities.HIGHTaskFilterR)en);

   	if (en.getClass().equals(ingenias.editor.entities.FTaskFilter.class))
	  return  new ingenias.editor.cell.FTaskFilterCell((ingenias.editor.entities.FTaskFilter)en);

   	if (en.getClass().equals(ingenias.editor.entities.Medication.class))
	  return  new ingenias.editor.cell.MedicationCell((ingenias.editor.entities.Medication)en);

   	if (en.getClass().equals(ingenias.editor.entities.BCompTask.class))
	  return  new ingenias.editor.cell.BCompTaskCell((ingenias.editor.entities.BCompTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.TextToSpeachAction.class))
	  return  new ingenias.editor.cell.TextToSpeachActionCell((ingenias.editor.entities.TextToSpeachAction)en);

   	if (en.getClass().equals(ingenias.editor.entities.ESleepers.class))
	  return  new ingenias.editor.cell.ESleepersCell((ingenias.editor.entities.ESleepers)en);

   	if (en.getClass().equals(ingenias.editor.entities.MedicationTime.class))
	  return  new ingenias.editor.cell.MedicationTimeCell((ingenias.editor.entities.MedicationTime)en);

   	if (en.getClass().equals(ingenias.editor.entities.PDDiseaseStage.class))
	  return  new ingenias.editor.cell.PDDiseaseStageCell((ingenias.editor.entities.PDDiseaseStage)en);

   	if (en.getClass().equals(ingenias.editor.entities.ESmartPhone.class))
	  return  new ingenias.editor.cell.ESmartPhoneCell((ingenias.editor.entities.ESmartPhone)en);

   	if (en.getClass().equals(ingenias.editor.entities.Pyjamas.class))
	  return  new ingenias.editor.cell.PyjamasCell((ingenias.editor.entities.Pyjamas)en);

   	if (en.getClass().equals(ingenias.editor.entities.GSymptom.class))
	  return  new ingenias.editor.cell.GSymptomCell((ingenias.editor.entities.GSymptom)en);

   	if (en.getClass().equals(ingenias.editor.entities.EMobilePhysicalEntity.class))
	  return  new ingenias.editor.cell.EMobilePhysicalEntityCell((ingenias.editor.entities.EMobilePhysicalEntity)en);

   	if (en.getClass().equals(ingenias.editor.entities.Drink.class))
	  return  new ingenias.editor.cell.DrinkCell((ingenias.editor.entities.Drink)en);

   	if (en.getClass().equals(ingenias.editor.entities.WalkingHelper.class))
	  return  new ingenias.editor.cell.WalkingHelperCell((ingenias.editor.entities.WalkingHelper)en);

   	if (en.getClass().equals(ingenias.editor.entities.SBuilding.class))
	  return  new ingenias.editor.cell.SBuildingCell((ingenias.editor.entities.SBuilding)en);

   	if (en.getClass().equals(ingenias.editor.entities.EFixedFurniture.class))
	  return  new ingenias.editor.cell.EFixedFurnitureCell((ingenias.editor.entities.EFixedFurniture)en);

   	if (en.getClass().equals(ingenias.editor.entities.BGoToTask.class))
	  return  new ingenias.editor.cell.BGoToTaskCell((ingenias.editor.entities.BGoToTask)en);

   	if (en.getClass().equals(ingenias.editor.entities.SymptomInitialization.class))
	  return  new ingenias.editor.cell.SymptomInitializationCell((ingenias.editor.entities.SymptomInitialization)en);

   	if (en.getClass().equals(ingenias.editor.entities.AESubtraction.class))
	  return  new ingenias.editor.cell.AESubtractionCell((ingenias.editor.entities.AESubtraction)en);

   	if (en.getClass().equals(ingenias.editor.entities.COutside.class))
	  return  new ingenias.editor.cell.COutsideCell((ingenias.editor.entities.COutside)en);

   	if (en.getClass().equals(ingenias.editor.entities.ObjDroppedEvent.class))
	  return  new ingenias.editor.cell.ObjDroppedEventCell((ingenias.editor.entities.ObjDroppedEvent)en);

   	if (en.getClass().equals(ingenias.editor.entities.FWardrobe.class))
	  return  new ingenias.editor.cell.FWardrobeCell((ingenias.editor.entities.FWardrobe)en);

   	if (en.getClass().equals(ingenias.editor.entities.Profession.class))
	  return  new ingenias.editor.cell.ProfessionCell((ingenias.editor.entities.Profession)en);

   	if (en.getClass().equals(ingenias.editor.entities.IFFlowControl.class))
	  return  new ingenias.editor.cell.IFFlowControlCell((ingenias.editor.entities.IFFlowControl)en);

   	if (en.getClass().equals(ingenias.editor.entities.DFixedSensor.class))
	  return  new ingenias.editor.cell.DFixedSensorCell((ingenias.editor.entities.DFixedSensor)en);

   	if (en.getClass().equals(ingenias.editor.entities.Cane.class))
	  return  new ingenias.editor.cell.CaneCell((ingenias.editor.entities.Cane)en);

   	if (en.getClass().equals(ingenias.editor.entities.ETool.class))
	  return  new ingenias.editor.cell.EToolCell((ingenias.editor.entities.ETool)en);

   	if (en.getClass().equals(ingenias.editor.entities.BEBodyCollision.class))
	  return  new ingenias.editor.cell.BEBodyCollisionCell((ingenias.editor.entities.BEBodyCollision)en);

   	if (en.getClass().equals(ingenias.editor.entities.EClothing.class))
	  return  new ingenias.editor.cell.EClothingCell((ingenias.editor.entities.EClothing)en);

   	if (en.getClass().equals(ingenias.editor.entities.NormHoldingCondition.class))
	  return  new ingenias.editor.cell.NormHoldingConditionCell((ingenias.editor.entities.NormHoldingCondition)en);

   	if (en.getClass().equals(ingenias.editor.entities.EFixedPhysicalEntity.class))
	  return  new ingenias.editor.cell.EFixedPhysicalEntityCell((ingenias.editor.entities.EFixedPhysicalEntity)en);

    } else {
    // If not, it is a relationship
      en = rm.getRelationship(id);
    if (en==null) return null;

    if (en instanceof ingenias.editor.entities.Limitations)
     return  new ingenias.editor.cell.LimitationsEdge((ingenias.editor.entities.Limitations)en);

    if (en instanceof ingenias.editor.entities.FPrecondition)
     return  new ingenias.editor.cell.FPreconditionEdge((ingenias.editor.entities.FPrecondition)en);

    if (en instanceof ingenias.editor.entities.aemd_op2)
     return  new ingenias.editor.cell.aemd_op2Edge((ingenias.editor.entities.aemd_op2)en);

    if (en instanceof ingenias.editor.entities.aemd_op1)
     return  new ingenias.editor.cell.aemd_op1Edge((ingenias.editor.entities.aemd_op1)en);

    if (en instanceof ingenias.editor.entities.Connects)
     return  new ingenias.editor.cell.ConnectsEdge((ingenias.editor.entities.Connects)en);

    if (en instanceof ingenias.editor.entities.SDoor)
     return  new ingenias.editor.cell.SDoorEdge((ingenias.editor.entities.SDoor)en);

    if (en instanceof ingenias.editor.entities.isParentOf)
     return  new ingenias.editor.cell.isParentOfEdge((ingenias.editor.entities.isParentOf)en);

    if (en instanceof ingenias.editor.entities.SymptomTransition)
     return  new ingenias.editor.cell.SymptomTransitionEdge((ingenias.editor.entities.SymptomTransition)en);

    if (en instanceof ingenias.editor.entities.CameraFaceToHuman)
     return  new ingenias.editor.cell.CameraFaceToHumanEdge((ingenias.editor.entities.CameraFaceToHuman)en);

    if (en instanceof ingenias.editor.entities.WorkAs)
     return  new ingenias.editor.cell.WorkAsEdge((ingenias.editor.entities.WorkAs)en);

    if (en instanceof ingenias.editor.entities.useObjVar)
     return  new ingenias.editor.cell.useObjVarEdge((ingenias.editor.entities.useObjVar)en);

    if (en instanceof ingenias.editor.entities.ProgramTransition)
     return  new ingenias.editor.cell.ProgramTransitionEdge((ingenias.editor.entities.ProgramTransition)en);

    if (en instanceof ingenias.editor.entities.leaveObjVar)
     return  new ingenias.editor.cell.leaveObjVarEdge((ingenias.editor.entities.leaveObjVar)en);

    if (en instanceof ingenias.editor.entities.NextSeqTask)
     return  new ingenias.editor.cell.NextSeqTaskEdge((ingenias.editor.entities.NextSeqTask)en);

    if (en instanceof ingenias.editor.entities.TIStartTime)
     return  new ingenias.editor.cell.TIStartTimeEdge((ingenias.editor.entities.TIStartTime)en);

    if (en instanceof ingenias.editor.entities.RelatedEvent)
     return  new ingenias.editor.cell.RelatedEventEdge((ingenias.editor.entities.RelatedEvent)en);

    if (en instanceof ingenias.editor.entities.NextFilter)
     return  new ingenias.editor.cell.NextFilterEdge((ingenias.editor.entities.NextFilter)en);

    if (en instanceof ingenias.editor.entities.putOnWearableVar)
     return  new ingenias.editor.cell.putOnWearableVarEdge((ingenias.editor.entities.putOnWearableVar)en);

    if (en instanceof ingenias.editor.entities.ActivityAttached)
     return  new ingenias.editor.cell.ActivityAttachedEdge((ingenias.editor.entities.ActivityAttached)en);

    if (en instanceof ingenias.editor.entities.openObjVar)
     return  new ingenias.editor.cell.openObjVarEdge((ingenias.editor.entities.openObjVar)en);

    if (en instanceof ingenias.editor.entities.DeonticAssignement)
     return  new ingenias.editor.cell.DeonticAssignementEdge((ingenias.editor.entities.DeonticAssignement)en);

    if (en instanceof ingenias.editor.entities.InitialLocation)
     return  new ingenias.editor.cell.InitialLocationEdge((ingenias.editor.entities.InitialLocation)en);

    if (en instanceof ingenias.editor.entities.MedicinesIntakes)
     return  new ingenias.editor.cell.MedicinesIntakesEdge((ingenias.editor.entities.MedicinesIntakes)en);

    if (en instanceof ingenias.editor.entities.aeas_op2)
     return  new ingenias.editor.cell.aeas_op2Edge((ingenias.editor.entities.aeas_op2)en);

    if (en instanceof ingenias.editor.entities.ProfileOf)
     return  new ingenias.editor.cell.ProfileOfEdge((ingenias.editor.entities.ProfileOf)en);

    if (en instanceof ingenias.editor.entities.aeas_op1)
     return  new ingenias.editor.cell.aeas_op1Edge((ingenias.editor.entities.aeas_op1)en);

    if (en instanceof ingenias.editor.entities.InitializedSymptom)
     return  new ingenias.editor.cell.InitializedSymptomEdge((ingenias.editor.entities.InitializedSymptom)en);

    if (en instanceof ingenias.editor.entities.InitializesSymptom)
     return  new ingenias.editor.cell.InitializesSymptomEdge((ingenias.editor.entities.InitializesSymptom)en);

    if (en instanceof ingenias.editor.entities.Symptoms)
     return  new ingenias.editor.cell.SymptomsEdge((ingenias.editor.entities.Symptoms)en);

    if (en instanceof ingenias.editor.entities.switchRoomVar)
     return  new ingenias.editor.cell.switchRoomVarEdge((ingenias.editor.entities.switchRoomVar)en);

    if (en instanceof ingenias.editor.entities.EmulatorPeer)
     return  new ingenias.editor.cell.EmulatorPeerEdge((ingenias.editor.entities.EmulatorPeer)en);

    if (en instanceof ingenias.editor.entities.goToBodyVar)
     return  new ingenias.editor.cell.goToBodyVarEdge((ingenias.editor.entities.goToBodyVar)en);

    if (en instanceof ingenias.editor.entities.closeObjVar)
     return  new ingenias.editor.cell.closeObjVarEdge((ingenias.editor.entities.closeObjVar)en);

    if (en instanceof ingenias.editor.entities.ProducesEvent)
     return  new ingenias.editor.cell.ProducesEventEdge((ingenias.editor.entities.ProducesEvent)en);

    if (en instanceof ingenias.editor.entities.messageVar)
     return  new ingenias.editor.cell.messageVarEdge((ingenias.editor.entities.messageVar)en);

    if (en instanceof ingenias.editor.entities.aeinv_op)
     return  new ingenias.editor.cell.aeinv_opEdge((ingenias.editor.entities.aeinv_op)en);

    if (en instanceof ingenias.editor.entities.FalseFlow)
     return  new ingenias.editor.cell.FalseFlowEdge((ingenias.editor.entities.FalseFlow)en);

    if (en instanceof ingenias.editor.entities.ParamsSet)
     return  new ingenias.editor.cell.ParamsSetEdge((ingenias.editor.entities.ParamsSet)en);

    if (en instanceof ingenias.editor.entities.ActionResponsible)
     return  new ingenias.editor.cell.ActionResponsibleEdge((ingenias.editor.entities.ActionResponsible)en);

    if (en instanceof ingenias.editor.entities.putOffWearableVar)
     return  new ingenias.editor.cell.putOffWearableVarEdge((ingenias.editor.entities.putOffWearableVar)en);

    if (en instanceof ingenias.editor.entities.RelatedHuman)
     return  new ingenias.editor.cell.RelatedHumanEdge((ingenias.editor.entities.RelatedHuman)en);

    if (en instanceof ingenias.editor.entities.LiveIn)
     return  new ingenias.editor.cell.LiveInEdge((ingenias.editor.entities.LiveIn)en);

    if (en instanceof ingenias.editor.entities.tapDeviceVar)
     return  new ingenias.editor.cell.tapDeviceVarEdge((ingenias.editor.entities.tapDeviceVar)en);

    if (en instanceof ingenias.editor.entities.tapXVar)
     return  new ingenias.editor.cell.tapXVarEdge((ingenias.editor.entities.tapXVar)en);

    if (en instanceof ingenias.editor.entities.SBhasFloor)
     return  new ingenias.editor.cell.SBhasFloorEdge((ingenias.editor.entities.SBhasFloor)en);

    if (en instanceof ingenias.editor.entities.NextTI)
     return  new ingenias.editor.cell.NextTIEdge((ingenias.editor.entities.NextTI)en);

    if (en instanceof ingenias.editor.entities.tapYVar)
     return  new ingenias.editor.cell.tapYVarEdge((ingenias.editor.entities.tapYVar)en);

    if (en instanceof ingenias.editor.entities.Role)
     return  new ingenias.editor.cell.RoleEdge((ingenias.editor.entities.Role)en);

    if (en instanceof ingenias.editor.entities.AffectedAction)
     return  new ingenias.editor.cell.AffectedActionEdge((ingenias.editor.entities.AffectedAction)en);

    if (en instanceof ingenias.editor.entities.med)
     return  new ingenias.editor.cell.medEdge((ingenias.editor.entities.med)en);

    if (en instanceof ingenias.editor.entities.FAlternative)
     return  new ingenias.editor.cell.FAlternativeEdge((ingenias.editor.entities.FAlternative)en);

    if (en instanceof ingenias.editor.entities.InitialActivity)
     return  new ingenias.editor.cell.InitialActivityEdge((ingenias.editor.entities.InitialActivity)en);

    if (en instanceof ingenias.editor.entities.durationVar)
     return  new ingenias.editor.cell.durationVarEdge((ingenias.editor.entities.durationVar)en);

    if (en instanceof ingenias.editor.entities.NextActivity)
     return  new ingenias.editor.cell.NextActivityEdge((ingenias.editor.entities.NextActivity)en);

    if (en instanceof ingenias.editor.entities.dropObjVar)
     return  new ingenias.editor.cell.dropObjVarEdge((ingenias.editor.entities.dropObjVar)en);

    if (en instanceof ingenias.editor.entities.relatedCondition)
     return  new ingenias.editor.cell.relatedConditionEdge((ingenias.editor.entities.relatedCondition)en);

    if (en instanceof ingenias.editor.entities.cond)
     return  new ingenias.editor.cell.condEdge((ingenias.editor.entities.cond)en);

    if (en instanceof ingenias.editor.entities.isCaregiverOf)
     return  new ingenias.editor.cell.isCaregiverOfEdge((ingenias.editor.entities.isCaregiverOf)en);

    if (en instanceof ingenias.editor.entities.device)
     return  new ingenias.editor.cell.deviceEdge((ingenias.editor.entities.device)en);

    if (en instanceof ingenias.editor.entities.InitialDate)
     return  new ingenias.editor.cell.InitialDateEdge((ingenias.editor.entities.InitialDate)en);

    if (en instanceof ingenias.editor.entities.ActionHappeningAfterwards)
     return  new ingenias.editor.cell.ActionHappeningAfterwardsEdge((ingenias.editor.entities.ActionHappeningAfterwards)en);

    if (en instanceof ingenias.editor.entities.InitialDeviceLocation)
     return  new ingenias.editor.cell.InitialDeviceLocationEdge((ingenias.editor.entities.InitialDeviceLocation)en);

    if (en instanceof ingenias.editor.entities.sitDownOnSeatVar)
     return  new ingenias.editor.cell.sitDownOnSeatVarEdge((ingenias.editor.entities.sitDownOnSeatVar)en);

    if (en instanceof ingenias.editor.entities.DeviceActionsAttached)
     return  new ingenias.editor.cell.DeviceActionsAttachedEdge((ingenias.editor.entities.DeviceActionsAttached)en);

    if (en instanceof ingenias.editor.entities.AllowedTask)
     return  new ingenias.editor.cell.AllowedTaskEdge((ingenias.editor.entities.AllowedTask)en);

    if (en instanceof ingenias.editor.entities.RunAndroidApp)
     return  new ingenias.editor.cell.RunAndroidAppEdge((ingenias.editor.entities.RunAndroidApp)en);

    if (en instanceof ingenias.editor.entities.goToBodySpeedVar)
     return  new ingenias.editor.cell.goToBodySpeedVarEdge((ingenias.editor.entities.goToBodySpeedVar)en);

    if (en instanceof ingenias.editor.entities.waitForHumanVar)
     return  new ingenias.editor.cell.waitForHumanVarEdge((ingenias.editor.entities.waitForHumanVar)en);

    if (en instanceof ingenias.editor.entities.animVar)
     return  new ingenias.editor.cell.animVarEdge((ingenias.editor.entities.animVar)en);

    if (en instanceof ingenias.editor.entities.socialRelations)
     return  new ingenias.editor.cell.socialRelationsEdge((ingenias.editor.entities.socialRelations)en);

    if (en instanceof ingenias.editor.entities.TrueFlow)
     return  new ingenias.editor.cell.TrueFlowEdge((ingenias.editor.entities.TrueFlow)en);

    if (en instanceof ingenias.editor.entities.goToSpeedVar)
     return  new ingenias.editor.cell.goToSpeedVarEdge((ingenias.editor.entities.goToSpeedVar)en);

    if (en instanceof ingenias.editor.entities.ConditionNeeded)
     return  new ingenias.editor.cell.ConditionNeededEdge((ingenias.editor.entities.ConditionNeeded)en);

    if (en instanceof ingenias.editor.entities.isSpouseOf)
     return  new ingenias.editor.cell.isSpouseOfEdge((ingenias.editor.entities.isSpouseOf)en);

    if (en instanceof ingenias.editor.entities.tool)
     return  new ingenias.editor.cell.toolEdge((ingenias.editor.entities.tool)en);

    if (en instanceof ingenias.editor.entities.leaveObjDestinyVar)
     return  new ingenias.editor.cell.leaveObjDestinyVarEdge((ingenias.editor.entities.leaveObjDestinyVar)en);

    if (en instanceof ingenias.editor.entities.pickUpObjVar)
     return  new ingenias.editor.cell.pickUpObjVarEdge((ingenias.editor.entities.pickUpObjVar)en);

    if (en instanceof ingenias.editor.entities.goToPlaceVar)
     return  new ingenias.editor.cell.goToPlaceVarEdge((ingenias.editor.entities.goToPlaceVar)en);


    }

    return null;
  }


 
}





