
/** 
 * Copyright (C) 2010  Jorge J. Gomez-Sanz
 * 
 * 
 * This file is part of the INGENME tool. INGENME is an open source meta-editor
 * which produces customized editors for user-defined modeling languages
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 **/
 
package ingenias.editor.persistence;
import java.lang.reflect.*;
import javax.swing.tree.*;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.InputSource;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.OutputStreamWriter;
import java.io.*;
import javax.swing.tree.DefaultMutableTreeNode;
import java.util.*;
import java.util.Map;
import java.util.Hashtable;
import java.util.ArrayList;
import javax.xml.parsers.*;

import org.jgraph.JGraph;
import org.jgraph.graph.*;
import org.w3c.dom.*;
import org.w3c.dom.Document;
import org.w3c.dom.DOMImplementation;

import ingenias.editor.entities.*;
import ingenias.exception.*;
import ingenias.editor.cell.*;
import ingenias.editor.*;

public class ObjectSave extends ObjectSaveAbs{

  public void saveObject(ingenias.editor.entities.Entity en, OutputStreamWriter os) throws
      IOException {
    String _name1 = ingenias.editor.entities.Entity.encodeutf8Text(en.getId());
    os.write( "<object id=\"" + _name1 + "\" type=\"" + en.getClass().getName() +
               "\">\n");
    Enumeration enumeration = null;

    
        if (en instanceof ingenias.editor.entities.Dishwasher){
          ingenias.editor.entities.Dishwasher nen=(ingenias.editor.entities.Dishwasher)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PerceptionEvent){
          ingenias.editor.entities.PerceptionEvent nen=(ingenias.editor.entities.PerceptionEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DeviceVar){
          ingenias.editor.entities.DeviceVar nen=(ingenias.editor.entities.DeviceVar)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ArithmeticExpression){
          ingenias.editor.entities.ArithmeticExpression nen=(ingenias.editor.entities.ArithmeticExpression)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SwitchLightAction){
          ingenias.editor.entities.SwitchLightAction nen=(ingenias.editor.entities.SwitchLightAction)en;
	  String _name;
          
          
          os.write("<objectproperty id=\"RoomField\" collection=\"true\">\n");
             enumeration=nen.getRoomFieldElements();
          while (enumeration.hasMoreElements()){
            ingenias.editor.entities.Entity next=(ingenias.editor.entities.Entity)enumeration.nextElement();
           saveObject(next,os);
          }
          os.write("</objectproperty>\n");
          
        }
        
        if (en instanceof ingenias.editor.entities.SeatVar){
          ingenias.editor.entities.SeatVar nen=(ingenias.editor.entities.SeatVar)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Shower){
          ingenias.editor.entities.Shower nen=(ingenias.editor.entities.Shower)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ProgramState){
          ingenias.editor.entities.ProgramState nen=(ingenias.editor.entities.ProgramState)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FOWashbasin){
          ingenias.editor.entities.FOWashbasin nen=(ingenias.editor.entities.FOWashbasin)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FDelayFilter){
          ingenias.editor.entities.FDelayFilter nen=(ingenias.editor.entities.FDelayFilter)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CObjWeight){
          ingenias.editor.entities.CObjWeight nen=(ingenias.editor.entities.CObjWeight)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Var){
          ingenias.editor.entities.Var nen=(ingenias.editor.entities.Var)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.WorldInitialization){
          ingenias.editor.entities.WorldInitialization nen=(ingenias.editor.entities.WorldInitialization)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HumanProfile){
          ingenias.editor.entities.HumanProfile nen=(ingenias.editor.entities.HumanProfile)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FOBath){
          ingenias.editor.entities.FOBath nen=(ingenias.editor.entities.FOBath)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PDSymtom){
          ingenias.editor.entities.PDSymtom nen=(ingenias.editor.entities.PDSymtom)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SymptomEvoField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSymptomEvoField()!=null)
           saveObject(nen.getSymptomEvoField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HumanNorm){
          ingenias.editor.entities.HumanNorm nen=(ingenias.editor.entities.HumanNorm)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DeonticAssignement");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDeonticAssignement()!=null)
           saveObject(nen.getDeonticAssignement(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HoldingCondition");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHoldingCondition()!=null)
           saveObject(nen.getHoldingCondition(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DiseaseProfile){
          ingenias.editor.entities.DiseaseProfile nen=(ingenias.editor.entities.DiseaseProfile)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("BeginningDateField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getBeginningDateField()!=null)
           saveObject(nen.getBeginningDateField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BGetUpFromBed){
          ingenias.editor.entities.BGetUpFromBed nen=(ingenias.editor.entities.BGetUpFromBed)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.GenericDisease){
          ingenias.editor.entities.GenericDisease nen=(ingenias.editor.entities.GenericDisease)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("GenericDiseaseSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getGenericDiseaseSpecField()!=null)
           saveObject(nen.getGenericDiseaseSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CSay){
          ingenias.editor.entities.CSay nen=(ingenias.editor.entities.CSay)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanTarget");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanTarget()!=null)
           saveObject(nen.getHumanTarget(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SwipeTask){
          ingenias.editor.entities.SwipeTask nen=(ingenias.editor.entities.SwipeTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("TargetSmartphone");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getTargetSmartphone()!=null)
           saveObject(nen.getTargetSmartphone(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.StopBehaviourEvent){
          ingenias.editor.entities.StopBehaviourEvent nen=(ingenias.editor.entities.StopBehaviourEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SVerticalSpace){
          ingenias.editor.entities.SVerticalSpace nen=(ingenias.editor.entities.SVerticalSpace)en;
	  String _name;
          
          
          os.write("<objectproperty id=\"RoomField\" collection=\"true\">\n");
             enumeration=nen.getRoomFieldElements();
          while (enumeration.hasMoreElements()){
            ingenias.editor.entities.Entity next=(ingenias.editor.entities.Entity)enumeration.nextElement();
           saveObject(next,os);
          }
          os.write("</objectproperty>\n");
          
        }
        
        if (en instanceof ingenias.editor.entities.PersonalInfo){
          ingenias.editor.entities.PersonalInfo nen=(ingenias.editor.entities.PersonalInfo)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CAlways){
          ingenias.editor.entities.CAlways nen=(ingenias.editor.entities.CAlways)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ObjectVar){
          ingenias.editor.entities.ObjectVar nen=(ingenias.editor.entities.ObjectVar)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.MedsTakenEvent){
          ingenias.editor.entities.MedsTakenEvent nen=(ingenias.editor.entities.MedsTakenEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Extractor){
          ingenias.editor.entities.Extractor nen=(ingenias.editor.entities.Extractor)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SSpatial){
          ingenias.editor.entities.SSpatial nen=(ingenias.editor.entities.SSpatial)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FBed){
          ingenias.editor.entities.FBed nen=(ingenias.editor.entities.FBed)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BECollision){
          ingenias.editor.entities.BECollision nen=(ingenias.editor.entities.BECollision)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ParticipantObject");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getParticipantObject()!=null)
           saveObject(nen.getParticipantObject(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SociAALEntity){
          ingenias.editor.entities.SociAALEntity nen=(ingenias.editor.entities.SociAALEntity)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DComputer){
          ingenias.editor.entities.DComputer nen=(ingenias.editor.entities.DComputer)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Shirt){
          ingenias.editor.entities.Shirt nen=(ingenias.editor.entities.Shirt)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Shoes){
          ingenias.editor.entities.Shoes nen=(ingenias.editor.entities.Shoes)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AndroidEmulator){
          ingenias.editor.entities.AndroidEmulator nen=(ingenias.editor.entities.AndroidEmulator)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PlayAnimationTask){
          ingenias.editor.entities.PlayAnimationTask nen=(ingenias.editor.entities.PlayAnimationTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SymptomChangedEvent){
          ingenias.editor.entities.SymptomChangedEvent nen=(ingenias.editor.entities.SymptomChangedEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Bridge){
          ingenias.editor.entities.Bridge nen=(ingenias.editor.entities.Bridge)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EMobileDevice){
          ingenias.editor.entities.EMobileDevice nen=(ingenias.editor.entities.EMobileDevice)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FOSink){
          ingenias.editor.entities.FOSink nen=(ingenias.editor.entities.FOSink)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CProb){
          ingenias.editor.entities.CProb nen=(ingenias.editor.entities.CProb)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EWaterBottle){
          ingenias.editor.entities.EWaterBottle nen=(ingenias.editor.entities.EWaterBottle)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BENewObjInFieldOfVision){
          ingenias.editor.entities.BENewObjInFieldOfVision nen=(ingenias.editor.entities.BENewObjInFieldOfVision)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ParticipantObject");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getParticipantObject()!=null)
           saveObject(nen.getParticipantObject(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SBathroom){
          ingenias.editor.entities.SBathroom nen=(ingenias.editor.entities.SBathroom)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RoomSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRoomSpecField()!=null)
           saveObject(nen.getRoomSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Crutch){
          ingenias.editor.entities.Crutch nen=(ingenias.editor.entities.Crutch)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Staircase){
          ingenias.editor.entities.Staircase nen=(ingenias.editor.entities.Staircase)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FChangeTargetObjFilter){
          ingenias.editor.entities.FChangeTargetObjFilter nen=(ingenias.editor.entities.FChangeTargetObjFilter)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("BUseObjectField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getBUseObjectField()!=null)
           saveObject(nen.getBUseObjectField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SBedroom){
          ingenias.editor.entities.SBedroom nen=(ingenias.editor.entities.SBedroom)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RoomSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRoomSpecField()!=null)
           saveObject(nen.getRoomSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AEDiv){
          ingenias.editor.entities.AEDiv nen=(ingenias.editor.entities.AEDiv)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.VibrateEvent){
          ingenias.editor.entities.VibrateEvent nen=(ingenias.editor.entities.VibrateEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.WearableVar){
          ingenias.editor.entities.WearableVar nen=(ingenias.editor.entities.WearableVar)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DoorStateCondition){
          ingenias.editor.entities.DoorStateCondition nen=(ingenias.editor.entities.DoorStateCondition)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DeviceIdField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDeviceIdField()!=null)
           saveObject(nen.getDeviceIdField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.WaitForBodyClose){
          ingenias.editor.entities.WaitForBodyClose nen=(ingenias.editor.entities.WaitForBodyClose)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanTarget");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanTarget()!=null)
           saveObject(nen.getHumanTarget(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BPickUpTask){
          ingenias.editor.entities.BPickUpTask nen=(ingenias.editor.entities.BPickUpTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("PysicalMobObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getPysicalMobObjField()!=null)
           saveObject(nen.getPysicalMobObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Doorbell){
          ingenias.editor.entities.Doorbell nen=(ingenias.editor.entities.Doorbell)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SArea){
          ingenias.editor.entities.SArea nen=(ingenias.editor.entities.SArea)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CloseTask){
          ingenias.editor.entities.CloseTask nen=(ingenias.editor.entities.CloseTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("OpenCloseObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getOpenCloseObjField()!=null)
           saveObject(nen.getOpenCloseObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PartOfBody){
          ingenias.editor.entities.PartOfBody nen=(ingenias.editor.entities.PartOfBody)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("BelongsTo");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getBelongsTo()!=null)
           saveObject(nen.getBelongsTo(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.LightStateCondition){
          ingenias.editor.entities.LightStateCondition nen=(ingenias.editor.entities.LightStateCondition)en;
	  String _name;
          
          
          os.write("<objectproperty id=\"RoomField\" collection=\"true\">\n");
             enumeration=nen.getRoomFieldElements();
          while (enumeration.hasMoreElements()){
            ingenias.editor.entities.Entity next=(ingenias.editor.entities.Entity)enumeration.nextElement();
           saveObject(next,os);
          }
          os.write("</objectproperty>\n");
          
        }
        
        if (en instanceof ingenias.editor.entities.PrimitiveVar){
          ingenias.editor.entities.PrimitiveVar nen=(ingenias.editor.entities.PrimitiveVar)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AEAddSub){
          ingenias.editor.entities.AEAddSub nen=(ingenias.editor.entities.AEAddSub)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FSofa){
          ingenias.editor.entities.FSofa nen=(ingenias.editor.entities.FSofa)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EPublicEvent){
          ingenias.editor.entities.EPublicEvent nen=(ingenias.editor.entities.EPublicEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PutOnTask){
          ingenias.editor.entities.PutOnTask nen=(ingenias.editor.entities.PutOnTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("WearableObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getWearableObjField()!=null)
           saveObject(nen.getWearableObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SFloor){
          ingenias.editor.entities.SFloor nen=(ingenias.editor.entities.SFloor)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SFloorSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSFloorSpecField()!=null)
           saveObject(nen.getSFloorSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HIGHSympLevelState){
          ingenias.editor.entities.HIGHSympLevelState nen=(ingenias.editor.entities.HIGHSympLevelState)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AEInv){
          ingenias.editor.entities.AEInv nen=(ingenias.editor.entities.AEInv)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EMobileObject){
          ingenias.editor.entities.EMobileObject nen=(ingenias.editor.entities.EMobileObject)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SayTask){
          ingenias.editor.entities.SayTask nen=(ingenias.editor.entities.SayTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HearingEvent){
          ingenias.editor.entities.HearingEvent nen=(ingenias.editor.entities.HearingEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BEObjOutFielOfVision){
          ingenias.editor.entities.BEObjOutFielOfVision nen=(ingenias.editor.entities.BEObjOutFielOfVision)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ParticipantObject");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getParticipantObject()!=null)
           saveObject(nen.getParticipantObject(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ERemoteControl){
          ingenias.editor.entities.ERemoteControl nen=(ingenias.editor.entities.ERemoteControl)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SymptomLevelState){
          ingenias.editor.entities.SymptomLevelState nen=(ingenias.editor.entities.SymptomLevelState)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EMobileFurniture){
          ingenias.editor.entities.EMobileFurniture nen=(ingenias.editor.entities.EMobileFurniture)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Param){
          ingenias.editor.entities.Param nen=(ingenias.editor.entities.Param)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.MessageListenedEvent){
          ingenias.editor.entities.MessageListenedEvent nen=(ingenias.editor.entities.MessageListenedEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SDate){
          ingenias.editor.entities.SDate nen=(ingenias.editor.entities.SDate)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BUseTask){
          ingenias.editor.entities.BUseTask nen=(ingenias.editor.entities.BUseTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("BUseObjectField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getBUseObjectField()!=null)
           saveObject(nen.getBUseObjectField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BodyEvent){
          ingenias.editor.entities.BodyEvent nen=(ingenias.editor.entities.BodyEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CompCondition){
          ingenias.editor.entities.CompCondition nen=(ingenias.editor.entities.CompCondition)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Trousers){
          ingenias.editor.entities.Trousers nen=(ingenias.editor.entities.Trousers)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FallingEvent){
          ingenias.editor.entities.FallingEvent nen=(ingenias.editor.entities.FallingEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EFixedDevice){
          ingenias.editor.entities.EFixedDevice nen=(ingenias.editor.entities.EFixedDevice)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Condition){
          ingenias.editor.entities.Condition nen=(ingenias.editor.entities.Condition)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CReceiveHelp){
          ingenias.editor.entities.CReceiveHelp nen=(ingenias.editor.entities.CReceiveHelp)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.WearableParam){
          ingenias.editor.entities.WearableParam nen=(ingenias.editor.entities.WearableParam)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("WearableVarField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getWearableVarField()!=null)
           saveObject(nen.getWearableVarField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("WearableObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getWearableObjField()!=null)
           saveObject(nen.getWearableObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.WashMachine){
          ingenias.editor.entities.WashMachine nen=(ingenias.editor.entities.WashMachine)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FlyCamInit){
          ingenias.editor.entities.FlyCamInit nen=(ingenias.editor.entities.FlyCamInit)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.VibrateDeviceAction){
          ingenias.editor.entities.VibrateDeviceAction nen=(ingenias.editor.entities.VibrateDeviceAction)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Appliance){
          ingenias.editor.entities.Appliance nen=(ingenias.editor.entities.Appliance)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.MedInjection){
          ingenias.editor.entities.MedInjection nen=(ingenias.editor.entities.MedInjection)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ADLProfile){
          ingenias.editor.entities.ADLProfile nen=(ingenias.editor.entities.ADLProfile)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ADLSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getADLSpecField()!=null)
           saveObject(nen.getADLSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DTV){
          ingenias.editor.entities.DTV nen=(ingenias.editor.entities.DTV)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BSimpleTask){
          ingenias.editor.entities.BSimpleTask nen=(ingenias.editor.entities.BSimpleTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EWearable){
          ingenias.editor.entities.EWearable nen=(ingenias.editor.entities.EWearable)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DeviceParam){
          ingenias.editor.entities.DeviceParam nen=(ingenias.editor.entities.DeviceParam)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DeviceVarField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDeviceVarField()!=null)
           saveObject(nen.getDeviceVarField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DeviceField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDeviceField()!=null)
           saveObject(nen.getDeviceField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EMedicine){
          ingenias.editor.entities.EMedicine nen=(ingenias.editor.entities.EMedicine)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AENumConst){
          ingenias.editor.entities.AENumConst nen=(ingenias.editor.entities.AENumConst)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.LOWTaskFilterR){
          ingenias.editor.entities.LOWTaskFilterR nen=(ingenias.editor.entities.LOWTaskFilterR)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.TakeOffTask){
          ingenias.editor.entities.TakeOffTask nen=(ingenias.editor.entities.TakeOffTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("WearableObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getWearableObjField()!=null)
           saveObject(nen.getWearableObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EatableItem){
          ingenias.editor.entities.EatableItem nen=(ingenias.editor.entities.EatableItem)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EPhysicalEntity){
          ingenias.editor.entities.EPhysicalEntity nen=(ingenias.editor.entities.EPhysicalEntity)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SocialProfile){
          ingenias.editor.entities.SocialProfile nen=(ingenias.editor.entities.SocialProfile)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SocialSpecDiagField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSocialSpecDiagField()!=null)
           saveObject(nen.getSocialSpecDiagField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.NotCondition){
          ingenias.editor.entities.NotCondition nen=(ingenias.editor.entities.NotCondition)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BEObjectMoving){
          ingenias.editor.entities.BEObjectMoving nen=(ingenias.editor.entities.BEObjectMoving)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("PysicalMobObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getPysicalMobObjField()!=null)
           saveObject(nen.getPysicalMobObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DropObj){
          ingenias.editor.entities.DropObj nen=(ingenias.editor.entities.DropObj)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("PysicalMobObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getPysicalMobObjField()!=null)
           saveObject(nen.getPysicalMobObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EFixedObject){
          ingenias.editor.entities.EFixedObject nen=(ingenias.editor.entities.EFixedObject)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.IsThingInRoomCondition){
          ingenias.editor.entities.IsThingInRoomCondition nen=(ingenias.editor.entities.IsThingInRoomCondition)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RoomIdField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRoomIdField()!=null)
           saveObject(nen.getRoomIdField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ThingField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getThingField()!=null)
           saveObject(nen.getThingField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PlaceParam){
          ingenias.editor.entities.PlaceParam nen=(ingenias.editor.entities.PlaceParam)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SpatialVarField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSpatialVarField()!=null)
           saveObject(nen.getSpatialVarField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SpatialField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSpatialField()!=null)
           saveObject(nen.getSpatialField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CTimer){
          ingenias.editor.entities.CTimer nen=(ingenias.editor.entities.CTimer)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Human){
          ingenias.editor.entities.Human nen=(ingenias.editor.entities.Human)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CInside){
          ingenias.editor.entities.CInside nen=(ingenias.editor.entities.CInside)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanTarget");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanTarget()!=null)
           saveObject(nen.getHumanTarget(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AEMult){
          ingenias.editor.entities.AEMult nen=(ingenias.editor.entities.AEMult)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.VisionEvent){
          ingenias.editor.entities.VisionEvent nen=(ingenias.editor.entities.VisionEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SeatParam){
          ingenias.editor.entities.SeatParam nen=(ingenias.editor.entities.SeatParam)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SeatField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSeatField()!=null)
           saveObject(nen.getSeatField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SeatVarField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSeatVarField()!=null)
           saveObject(nen.getSeatVarField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EASubSubSub){
          ingenias.editor.entities.EASubSubSub nen=(ingenias.editor.entities.EASubSubSub)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ELivingBeing){
          ingenias.editor.entities.ELivingBeing nen=(ingenias.editor.entities.ELivingBeing)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SwitchLightTask){
          ingenias.editor.entities.SwitchLightTask nen=(ingenias.editor.entities.SwitchLightTask)en;
	  String _name;
          
          
          os.write("<objectproperty id=\"RoomField\" collection=\"true\">\n");
             enumeration=nen.getRoomFieldElements();
          while (enumeration.hasMoreElements()){
            ingenias.editor.entities.Entity next=(ingenias.editor.entities.Entity)enumeration.nextElement();
           saveObject(next,os);
          }
          os.write("</objectproperty>\n");
          
        }
        
        if (en instanceof ingenias.editor.entities.SpatialVar){
          ingenias.editor.entities.SpatialVar nen=(ingenias.editor.entities.SpatialVar)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Lift){
          ingenias.editor.entities.Lift nen=(ingenias.editor.entities.Lift)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.StandUp){
          ingenias.editor.entities.StandUp nen=(ingenias.editor.entities.StandUp)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FallTask){
          ingenias.editor.entities.FallTask nen=(ingenias.editor.entities.FallTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EPrivateEvent){
          ingenias.editor.entities.EPrivateEvent nen=(ingenias.editor.entities.EPrivateEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.NONESympLevelState){
          ingenias.editor.entities.NONESympLevelState nen=(ingenias.editor.entities.NONESympLevelState)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.MEDIUMTaskFilterR){
          ingenias.editor.entities.MEDIUMTaskFilterR nen=(ingenias.editor.entities.MEDIUMTaskFilterR)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.GoToBodyLoc){
          ingenias.editor.entities.GoToBodyLoc nen=(ingenias.editor.entities.GoToBodyLoc)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanTarget");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanTarget()!=null)
           saveObject(nen.getHumanTarget(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.TaskFilterRef){
          ingenias.editor.entities.TaskFilterRef nen=(ingenias.editor.entities.TaskFilterRef)en;
	  String _name;
          
          
          os.write("<objectproperty id=\"TaskAllowed\" collection=\"true\">\n");
             enumeration=nen.getTaskAllowedElements();
          while (enumeration.hasMoreElements()){
            ingenias.editor.entities.Entity next=(ingenias.editor.entities.Entity)enumeration.nextElement();
           saveObject(next,os);
          }
          os.write("</objectproperty>\n");
          
        }
        
        if (en instanceof ingenias.editor.entities.GoIntoBed){
          ingenias.editor.entities.GoIntoBed nen=(ingenias.editor.entities.GoIntoBed)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AEVariable){
          ingenias.editor.entities.AEVariable nen=(ingenias.editor.entities.AEVariable)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FTaskSelectorFilter){
          ingenias.editor.entities.FTaskSelectorFilter nen=(ingenias.editor.entities.FTaskSelectorFilter)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BSimpleDurationTask){
          ingenias.editor.entities.BSimpleDurationTask nen=(ingenias.editor.entities.BSimpleDurationTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Walker){
          ingenias.editor.entities.Walker nen=(ingenias.editor.entities.Walker)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.OpenTask){
          ingenias.editor.entities.OpenTask nen=(ingenias.editor.entities.OpenTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("OpenCloseObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getOpenCloseObjField()!=null)
           saveObject(nen.getOpenCloseObjField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SCorridor){
          ingenias.editor.entities.SCorridor nen=(ingenias.editor.entities.SCorridor)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RoomSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRoomSpecField()!=null)
           saveObject(nen.getRoomSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FModifyPlaceFilter){
          ingenias.editor.entities.FModifyPlaceFilter nen=(ingenias.editor.entities.FModifyPlaceFilter)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SpaceToGoField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSpaceToGoField()!=null)
           saveObject(nen.getSpaceToGoField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FTable){
          ingenias.editor.entities.FTable nen=(ingenias.editor.entities.FTable)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DrinkItem){
          ingenias.editor.entities.DrinkItem nen=(ingenias.editor.entities.DrinkItem)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FallSleep){
          ingenias.editor.entities.FallSleep nen=(ingenias.editor.entities.FallSleep)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BActivity){
          ingenias.editor.entities.BActivity nen=(ingenias.editor.entities.BActivity)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SeqTaskDiagramField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSeqTaskDiagramField()!=null)
           saveObject(nen.getSeqTaskDiagramField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AnotherActionHappens){
          ingenias.editor.entities.AnotherActionHappens nen=(ingenias.editor.entities.AnotherActionHappens)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ActionResponsible");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getActionResponsible()!=null)
           saveObject(nen.getActionResponsible(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("AffectedAction");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getAffectedAction()!=null)
           saveObject(nen.getAffectedAction(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.WaitTask){
          ingenias.editor.entities.WaitTask nen=(ingenias.editor.entities.WaitTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HumanParam){
          ingenias.editor.entities.HumanParam nen=(ingenias.editor.entities.HumanParam)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanVarField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanVarField()!=null)
           saveObject(nen.getHumanVarField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanField()!=null)
           saveObject(nen.getHumanField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BEvent){
          ingenias.editor.entities.BEvent nen=(ingenias.editor.entities.BEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BDeviceAction){
          ingenias.editor.entities.BDeviceAction nen=(ingenias.editor.entities.BDeviceAction)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DeviceIdField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDeviceIdField()!=null)
           saveObject(nen.getDeviceIdField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FChair){
          ingenias.editor.entities.FChair nen=(ingenias.editor.entities.FChair)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SLivingroom){
          ingenias.editor.entities.SLivingroom nen=(ingenias.editor.entities.SLivingroom)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RoomSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRoomSpecField()!=null)
           saveObject(nen.getRoomSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DeviceEvent){
          ingenias.editor.entities.DeviceEvent nen=(ingenias.editor.entities.DeviceEvent)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DeviceSource");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDeviceSource()!=null)
           saveObject(nen.getDeviceSource(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.TimeInterval){
          ingenias.editor.entities.TimeInterval nen=(ingenias.editor.entities.TimeInterval)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ActivitySpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getActivitySpecField()!=null)
           saveObject(nen.getActivitySpecField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DefaultActivityField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDefaultActivityField()!=null)
           saveObject(nen.getDefaultActivityField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.IncomingCallAction){
          ingenias.editor.entities.IncomingCallAction nen=(ingenias.editor.entities.IncomingCallAction)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PresenceSensorStateCondition){
          ingenias.editor.entities.PresenceSensorStateCondition nen=(ingenias.editor.entities.PresenceSensorStateCondition)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DeviceIdField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDeviceIdField()!=null)
           saveObject(nen.getDeviceIdField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SRoom){
          ingenias.editor.entities.SRoom nen=(ingenias.editor.entities.SRoom)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RoomSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRoomSpecField()!=null)
           saveObject(nen.getRoomSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.MEDIUMSympLevelState){
          ingenias.editor.entities.MEDIUMSympLevelState nen=(ingenias.editor.entities.MEDIUMSympLevelState)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BodyStateCondition){
          ingenias.editor.entities.BodyStateCondition nen=(ingenias.editor.entities.BodyStateCondition)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanTarget");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanTarget()!=null)
           saveObject(nen.getHumanTarget(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EBehaviourEvent){
          ingenias.editor.entities.EBehaviourEvent nen=(ingenias.editor.entities.EBehaviourEvent)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("BehaviourRefField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getBehaviourRefField()!=null)
           saveObject(nen.getBehaviourRefField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FReplaceTaskFilter){
          ingenias.editor.entities.FReplaceTaskFilter nen=(ingenias.editor.entities.FReplaceTaskFilter)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SeqTaskDiagramField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSeqTaskDiagramField()!=null)
           saveObject(nen.getSeqTaskDiagramField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BTask){
          ingenias.editor.entities.BTask nen=(ingenias.editor.entities.BTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.LOWSympLevelState){
          ingenias.editor.entities.LOWSympLevelState nen=(ingenias.editor.entities.LOWSympLevelState)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FUnableFilter){
          ingenias.editor.entities.FUnableFilter nen=(ingenias.editor.entities.FUnableFilter)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FChangeToolFilter){
          ingenias.editor.entities.FChangeToolFilter nen=(ingenias.editor.entities.FChangeToolFilter)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AESub){
          ingenias.editor.entities.AESub nen=(ingenias.editor.entities.AESub)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HumanVar){
          ingenias.editor.entities.HumanVar nen=(ingenias.editor.entities.HumanVar)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AESubSub){
          ingenias.editor.entities.AESubSub nen=(ingenias.editor.entities.AESubSub)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CSymptom){
          ingenias.editor.entities.CSymptom nen=(ingenias.editor.entities.CSymptom)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanTarget");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanTarget()!=null)
           saveObject(nen.getHumanTarget(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ParkinsonsProfile){
          ingenias.editor.entities.ParkinsonsProfile nen=(ingenias.editor.entities.ParkinsonsProfile)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ParkinsonSpecDiag");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getParkinsonSpecDiag()!=null)
           saveObject(nen.getParkinsonSpecDiag(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EventProcessor){
          ingenias.editor.entities.EventProcessor nen=(ingenias.editor.entities.EventProcessor)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ObjectParam){
          ingenias.editor.entities.ObjectParam nen=(ingenias.editor.entities.ObjectParam)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ObjectVarField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getObjectVarField()!=null)
           saveObject(nen.getObjectVarField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ObjectField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getObjectField()!=null)
           saveObject(nen.getObjectField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FSeat){
          ingenias.editor.entities.FSeat nen=(ingenias.editor.entities.FSeat)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BLeaveTask){
          ingenias.editor.entities.BLeaveTask nen=(ingenias.editor.entities.BLeaveTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("PysicalMobObjField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getPysicalMobObjField()!=null)
           saveObject(nen.getPysicalMobObjField(),os);
          os.write("</objectproperty>\n");
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DestinyField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDestinyField()!=null)
           saveObject(nen.getDestinyField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CDayOfTheWeek){
          ingenias.editor.entities.CDayOfTheWeek nen=(ingenias.editor.entities.CDayOfTheWeek)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PrimitiveParam){
          ingenias.editor.entities.PrimitiveParam nen=(ingenias.editor.entities.PrimitiveParam)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("PrimitiveVarField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getPrimitiveVarField()!=null)
           saveObject(nen.getPrimitiveVarField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CallStateEvent){
          ingenias.editor.entities.CallStateEvent nen=(ingenias.editor.entities.CallStateEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SKitchen){
          ingenias.editor.entities.SKitchen nen=(ingenias.editor.entities.SKitchen)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RoomSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRoomSpecField()!=null)
           saveObject(nen.getRoomSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FOWater){
          ingenias.editor.entities.FOWater nen=(ingenias.editor.entities.FOWater)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Eat){
          ingenias.editor.entities.Eat nen=(ingenias.editor.entities.Eat)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("EatableItemField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getEatableItemField()!=null)
           saveObject(nen.getEatableItemField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.TouchEvent){
          ingenias.editor.entities.TouchEvent nen=(ingenias.editor.entities.TouchEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Shocks){
          ingenias.editor.entities.Shocks nen=(ingenias.editor.entities.Shocks)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BSequentialTask){
          ingenias.editor.entities.BSequentialTask nen=(ingenias.editor.entities.BSequentialTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SeqTaskDiagramField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSeqTaskDiagramField()!=null)
           saveObject(nen.getSeqTaskDiagramField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.InitProgramPool){
          ingenias.editor.entities.InitProgramPool nen=(ingenias.editor.entities.InitProgramPool)en;
	  String _name;
          
          
          os.write("<objectproperty id=\"ProgramPoolField\" collection=\"true\">\n");
             enumeration=nen.getProgramPoolFieldElements();
          while (enumeration.hasMoreElements()){
            ingenias.editor.entities.Entity next=(ingenias.editor.entities.Entity)enumeration.nextElement();
           saveObject(next,os);
          }
          os.write("</objectproperty>\n");
          
        }
        
        if (en instanceof ingenias.editor.entities.StartBehaviourEvent){
          ingenias.editor.entities.StartBehaviourEvent nen=(ingenias.editor.entities.StartBehaviourEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HumanInitialization){
          ingenias.editor.entities.HumanInitialization nen=(ingenias.editor.entities.HumanInitialization)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Behaviour){
          ingenias.editor.entities.Behaviour nen=(ingenias.editor.entities.Behaviour)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BEVibration){
          ingenias.editor.entities.BEVibration nen=(ingenias.editor.entities.BEVibration)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ParticipantObject");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getParticipantObject()!=null)
           saveObject(nen.getParticipantObject(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CTime){
          ingenias.editor.entities.CTime nen=(ingenias.editor.entities.CTime)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ConsecutiveActions){
          ingenias.editor.entities.ConsecutiveActions nen=(ingenias.editor.entities.ConsecutiveActions)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ActionHappeningAfterwards");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getActionHappeningAfterwards()!=null)
           saveObject(nen.getActionHappeningAfterwards(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DiseaseStage){
          ingenias.editor.entities.DiseaseStage nen=(ingenias.editor.entities.DiseaseStage)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("MedicationTimeSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getMedicationTimeSpecField()!=null)
           saveObject(nen.getMedicationTimeSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AndroidApplication){
          ingenias.editor.entities.AndroidApplication nen=(ingenias.editor.entities.AndroidApplication)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AEAddition){
          ingenias.editor.entities.AEAddition nen=(ingenias.editor.entities.AEAddition)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BRandomTask){
          ingenias.editor.entities.BRandomTask nen=(ingenias.editor.entities.BRandomTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("RandTaskDiagramField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getRandTaskDiagramField()!=null)
           saveObject(nen.getRandTaskDiagramField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SitDown){
          ingenias.editor.entities.SitDown nen=(ingenias.editor.entities.SitDown)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SeatField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSeatField()!=null)
           saveObject(nen.getSeatField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SocialNetwork){
          ingenias.editor.entities.SocialNetwork nen=(ingenias.editor.entities.SocialNetwork)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CEvent){
          ingenias.editor.entities.CEvent nen=(ingenias.editor.entities.CEvent)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("EventField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getEventField()!=null)
           saveObject(nen.getEventField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.InitialPreDefPos){
          ingenias.editor.entities.InitialPreDefPos nen=(ingenias.editor.entities.InitialPreDefPos)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ClockTime){
          ingenias.editor.entities.ClockTime nen=(ingenias.editor.entities.ClockTime)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AEMulDiv){
          ingenias.editor.entities.AEMulDiv nen=(ingenias.editor.entities.AEMulDiv)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FModifyFilter){
          ingenias.editor.entities.FModifyFilter nen=(ingenias.editor.entities.FModifyFilter)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.InteractionProfile){
          ingenias.editor.entities.InteractionProfile nen=(ingenias.editor.entities.InteractionProfile)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("InteractionSpecDiagField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getInteractionSpecDiagField()!=null)
           saveObject(nen.getInteractionSpecDiagField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.TapXYTask){
          ingenias.editor.entities.TapXYTask nen=(ingenias.editor.entities.TapXYTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("TargetSmartphone");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getTargetSmartphone()!=null)
           saveObject(nen.getTargetSmartphone(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.CameraInit){
          ingenias.editor.entities.CameraInit nen=(ingenias.editor.entities.CameraInit)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.MedIntake){
          ingenias.editor.entities.MedIntake nen=(ingenias.editor.entities.MedIntake)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BWakeUpTask){
          ingenias.editor.entities.BWakeUpTask nen=(ingenias.editor.entities.BWakeUpTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.HIGHTaskFilterR){
          ingenias.editor.entities.HIGHTaskFilterR nen=(ingenias.editor.entities.HIGHTaskFilterR)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FTaskFilter){
          ingenias.editor.entities.FTaskFilter nen=(ingenias.editor.entities.FTaskFilter)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Medication){
          ingenias.editor.entities.Medication nen=(ingenias.editor.entities.Medication)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BCompTask){
          ingenias.editor.entities.BCompTask nen=(ingenias.editor.entities.BCompTask)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.TextToSpeachAction){
          ingenias.editor.entities.TextToSpeachAction nen=(ingenias.editor.entities.TextToSpeachAction)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ESleepers){
          ingenias.editor.entities.ESleepers nen=(ingenias.editor.entities.ESleepers)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.MedicationTime){
          ingenias.editor.entities.MedicationTime nen=(ingenias.editor.entities.MedicationTime)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ClockTimeField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getClockTimeField()!=null)
           saveObject(nen.getClockTimeField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.PDDiseaseStage){
          ingenias.editor.entities.PDDiseaseStage nen=(ingenias.editor.entities.PDDiseaseStage)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("MedicationTimeSpecField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getMedicationTimeSpecField()!=null)
           saveObject(nen.getMedicationTimeSpecField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ESmartPhone){
          ingenias.editor.entities.ESmartPhone nen=(ingenias.editor.entities.ESmartPhone)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Pyjamas){
          ingenias.editor.entities.Pyjamas nen=(ingenias.editor.entities.Pyjamas)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.GSymptom){
          ingenias.editor.entities.GSymptom nen=(ingenias.editor.entities.GSymptom)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SymptomEvoField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSymptomEvoField()!=null)
           saveObject(nen.getSymptomEvoField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EMobilePhysicalEntity){
          ingenias.editor.entities.EMobilePhysicalEntity nen=(ingenias.editor.entities.EMobilePhysicalEntity)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Drink){
          ingenias.editor.entities.Drink nen=(ingenias.editor.entities.Drink)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("DrinkItemField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getDrinkItemField()!=null)
           saveObject(nen.getDrinkItemField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.WalkingHelper){
          ingenias.editor.entities.WalkingHelper nen=(ingenias.editor.entities.WalkingHelper)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SBuilding){
          ingenias.editor.entities.SBuilding nen=(ingenias.editor.entities.SBuilding)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EFixedFurniture){
          ingenias.editor.entities.EFixedFurniture nen=(ingenias.editor.entities.EFixedFurniture)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BGoToTask){
          ingenias.editor.entities.BGoToTask nen=(ingenias.editor.entities.BGoToTask)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("SpaceToGoField");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getSpaceToGoField()!=null)
           saveObject(nen.getSpaceToGoField(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.SymptomInitialization){
          ingenias.editor.entities.SymptomInitialization nen=(ingenias.editor.entities.SymptomInitialization)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.AESubtraction){
          ingenias.editor.entities.AESubtraction nen=(ingenias.editor.entities.AESubtraction)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.COutside){
          ingenias.editor.entities.COutside nen=(ingenias.editor.entities.COutside)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("HumanTarget");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getHumanTarget()!=null)
           saveObject(nen.getHumanTarget(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ObjDroppedEvent){
          ingenias.editor.entities.ObjDroppedEvent nen=(ingenias.editor.entities.ObjDroppedEvent)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.FWardrobe){
          ingenias.editor.entities.FWardrobe nen=(ingenias.editor.entities.FWardrobe)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Profession){
          ingenias.editor.entities.Profession nen=(ingenias.editor.entities.Profession)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.IFFlowControl){
          ingenias.editor.entities.IFFlowControl nen=(ingenias.editor.entities.IFFlowControl)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.DFixedSensor){
          ingenias.editor.entities.DFixedSensor nen=(ingenias.editor.entities.DFixedSensor)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.Cane){
          ingenias.editor.entities.Cane nen=(ingenias.editor.entities.Cane)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.ETool){
          ingenias.editor.entities.ETool nen=(ingenias.editor.entities.ETool)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.BEBodyCollision){
          ingenias.editor.entities.BEBodyCollision nen=(ingenias.editor.entities.BEBodyCollision)en;
	  String _name;
          
          _name=ingenias.editor.entities.Entity.encodeutf8Text("ParticipantObject");
          os.write("<objectproperty id=\""+_name+"\">\n");
          if (nen.getParticipantObject()!=null)
           saveObject(nen.getParticipantObject(),os);
          os.write("</objectproperty>\n");
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EClothing){
          ingenias.editor.entities.EClothing nen=(ingenias.editor.entities.EClothing)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.NormHoldingCondition){
          ingenias.editor.entities.NormHoldingCondition nen=(ingenias.editor.entities.NormHoldingCondition)en;
	  String _name;
          
          
        }
        
        if (en instanceof ingenias.editor.entities.EFixedPhysicalEntity){
          ingenias.editor.entities.EFixedPhysicalEntity nen=(ingenias.editor.entities.EFixedPhysicalEntity)en;
	  String _name;
          
          
        }
        

        
         if (en.getClass().equals(ingenias.editor.entities.FilterDiagramDataEntity.class)){
          ingenias.editor.entities.FilterDiagramDataEntity nen=(ingenias.editor.entities.FilterDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.GenericDiseaseSpecDiagDataEntity.class)){
          ingenias.editor.entities.GenericDiseaseSpecDiagDataEntity nen=(ingenias.editor.entities.GenericDiseaseSpecDiagDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.BuildingDiagramDataEntity.class)){
          ingenias.editor.entities.BuildingDiagramDataEntity nen=(ingenias.editor.entities.BuildingDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ActivityDiagramDataEntity.class)){
          ingenias.editor.entities.ActivityDiagramDataEntity nen=(ingenias.editor.entities.ActivityDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ADLSpecDiagramDataEntity.class)){
          ingenias.editor.entities.ADLSpecDiagramDataEntity nen=(ingenias.editor.entities.ADLSpecDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.DeviceBehavoirDiagramDataEntity.class)){
          ingenias.editor.entities.DeviceBehavoirDiagramDataEntity nen=(ingenias.editor.entities.DeviceBehavoirDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.InteractionDiagramDataEntity.class)){
          ingenias.editor.entities.InteractionDiagramDataEntity nen=(ingenias.editor.entities.InteractionDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.SimulationDiagramDataEntity.class)){
          ingenias.editor.entities.SimulationDiagramDataEntity nen=(ingenias.editor.entities.SimulationDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.SymptomEvolutionDiagramDataEntity.class)){
          ingenias.editor.entities.SymptomEvolutionDiagramDataEntity nen=(ingenias.editor.entities.SymptomEvolutionDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.FloorSpecDiagramDataEntity.class)){
          ingenias.editor.entities.FloorSpecDiagramDataEntity nen=(ingenias.editor.entities.FloorSpecDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.DeviceDiagramDataEntity.class)){
          ingenias.editor.entities.DeviceDiagramDataEntity nen=(ingenias.editor.entities.DeviceDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.SocialSpecDiagramDataEntity.class)){
          ingenias.editor.entities.SocialSpecDiagramDataEntity nen=(ingenias.editor.entities.SocialSpecDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.RandomTaskDiagramDataEntity.class)){
          ingenias.editor.entities.RandomTaskDiagramDataEntity nen=(ingenias.editor.entities.RandomTaskDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ParkinsonSpecDiagramDataEntity.class)){
          ingenias.editor.entities.ParkinsonSpecDiagramDataEntity nen=(ingenias.editor.entities.ParkinsonSpecDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ArithmeticDiagram1DataEntity.class)){
          ingenias.editor.entities.ArithmeticDiagram1DataEntity nen=(ingenias.editor.entities.ArithmeticDiagram1DataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.HumanProfileSpecDiagramDataEntity.class)){
          ingenias.editor.entities.HumanProfileSpecDiagramDataEntity nen=(ingenias.editor.entities.HumanProfileSpecDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.MedicationTimeDiagramDataEntity.class)){
          ingenias.editor.entities.MedicationTimeDiagramDataEntity nen=(ingenias.editor.entities.MedicationTimeDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.RoomSpecDiagramDataEntity.class)){
          ingenias.editor.entities.RoomSpecDiagramDataEntity nen=(ingenias.editor.entities.RoomSpecDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.SequentialTaskDiagramDataEntity.class)){
          ingenias.editor.entities.SequentialTaskDiagramDataEntity nen=(ingenias.editor.entities.SequentialTaskDiagramDataEntity)en;
	 String _name;
	
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.NormDefinitionDataEntity.class)){
          ingenias.editor.entities.NormDefinitionDataEntity nen=(ingenias.editor.entities.NormDefinitionDataEntity)en;
	 String _name;
	
          
        }
        

        
         if (en.getClass().equals(ingenias.editor.entities.Limitations.class)){
          ingenias.editor.entities.Limitations nen=(ingenias.editor.entities.Limitations)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.FPrecondition.class)){
          ingenias.editor.entities.FPrecondition nen=(ingenias.editor.entities.FPrecondition)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.aemd_op2.class)){
          ingenias.editor.entities.aemd_op2 nen=(ingenias.editor.entities.aemd_op2)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.aemd_op1.class)){
          ingenias.editor.entities.aemd_op1 nen=(ingenias.editor.entities.aemd_op1)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.Connects.class)){
          ingenias.editor.entities.Connects nen=(ingenias.editor.entities.Connects)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.SDoor.class)){
          ingenias.editor.entities.SDoor nen=(ingenias.editor.entities.SDoor)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.isParentOf.class)){
          ingenias.editor.entities.isParentOf nen=(ingenias.editor.entities.isParentOf)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.SymptomTransition.class)){
          ingenias.editor.entities.SymptomTransition nen=(ingenias.editor.entities.SymptomTransition)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.CameraFaceToHuman.class)){
          ingenias.editor.entities.CameraFaceToHuman nen=(ingenias.editor.entities.CameraFaceToHuman)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.WorkAs.class)){
          ingenias.editor.entities.WorkAs nen=(ingenias.editor.entities.WorkAs)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.useObjVar.class)){
          ingenias.editor.entities.useObjVar nen=(ingenias.editor.entities.useObjVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ProgramTransition.class)){
          ingenias.editor.entities.ProgramTransition nen=(ingenias.editor.entities.ProgramTransition)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.leaveObjVar.class)){
          ingenias.editor.entities.leaveObjVar nen=(ingenias.editor.entities.leaveObjVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.NextSeqTask.class)){
          ingenias.editor.entities.NextSeqTask nen=(ingenias.editor.entities.NextSeqTask)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.TIStartTime.class)){
          ingenias.editor.entities.TIStartTime nen=(ingenias.editor.entities.TIStartTime)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.RelatedEvent.class)){
          ingenias.editor.entities.RelatedEvent nen=(ingenias.editor.entities.RelatedEvent)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.NextFilter.class)){
          ingenias.editor.entities.NextFilter nen=(ingenias.editor.entities.NextFilter)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.putOnWearableVar.class)){
          ingenias.editor.entities.putOnWearableVar nen=(ingenias.editor.entities.putOnWearableVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ActivityAttached.class)){
          ingenias.editor.entities.ActivityAttached nen=(ingenias.editor.entities.ActivityAttached)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.openObjVar.class)){
          ingenias.editor.entities.openObjVar nen=(ingenias.editor.entities.openObjVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.DeonticAssignement.class)){
          ingenias.editor.entities.DeonticAssignement nen=(ingenias.editor.entities.DeonticAssignement)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.InitialLocation.class)){
          ingenias.editor.entities.InitialLocation nen=(ingenias.editor.entities.InitialLocation)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.MedicinesIntakes.class)){
          ingenias.editor.entities.MedicinesIntakes nen=(ingenias.editor.entities.MedicinesIntakes)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.aeas_op2.class)){
          ingenias.editor.entities.aeas_op2 nen=(ingenias.editor.entities.aeas_op2)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ProfileOf.class)){
          ingenias.editor.entities.ProfileOf nen=(ingenias.editor.entities.ProfileOf)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.aeas_op1.class)){
          ingenias.editor.entities.aeas_op1 nen=(ingenias.editor.entities.aeas_op1)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.InitializedSymptom.class)){
          ingenias.editor.entities.InitializedSymptom nen=(ingenias.editor.entities.InitializedSymptom)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.InitializesSymptom.class)){
          ingenias.editor.entities.InitializesSymptom nen=(ingenias.editor.entities.InitializesSymptom)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.Symptoms.class)){
          ingenias.editor.entities.Symptoms nen=(ingenias.editor.entities.Symptoms)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.switchRoomVar.class)){
          ingenias.editor.entities.switchRoomVar nen=(ingenias.editor.entities.switchRoomVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.EmulatorPeer.class)){
          ingenias.editor.entities.EmulatorPeer nen=(ingenias.editor.entities.EmulatorPeer)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.goToBodyVar.class)){
          ingenias.editor.entities.goToBodyVar nen=(ingenias.editor.entities.goToBodyVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.closeObjVar.class)){
          ingenias.editor.entities.closeObjVar nen=(ingenias.editor.entities.closeObjVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ProducesEvent.class)){
          ingenias.editor.entities.ProducesEvent nen=(ingenias.editor.entities.ProducesEvent)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.messageVar.class)){
          ingenias.editor.entities.messageVar nen=(ingenias.editor.entities.messageVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.aeinv_op.class)){
          ingenias.editor.entities.aeinv_op nen=(ingenias.editor.entities.aeinv_op)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.FalseFlow.class)){
          ingenias.editor.entities.FalseFlow nen=(ingenias.editor.entities.FalseFlow)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ParamsSet.class)){
          ingenias.editor.entities.ParamsSet nen=(ingenias.editor.entities.ParamsSet)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ActionResponsible.class)){
          ingenias.editor.entities.ActionResponsible nen=(ingenias.editor.entities.ActionResponsible)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.putOffWearableVar.class)){
          ingenias.editor.entities.putOffWearableVar nen=(ingenias.editor.entities.putOffWearableVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.RelatedHuman.class)){
          ingenias.editor.entities.RelatedHuman nen=(ingenias.editor.entities.RelatedHuman)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.LiveIn.class)){
          ingenias.editor.entities.LiveIn nen=(ingenias.editor.entities.LiveIn)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.tapDeviceVar.class)){
          ingenias.editor.entities.tapDeviceVar nen=(ingenias.editor.entities.tapDeviceVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.tapXVar.class)){
          ingenias.editor.entities.tapXVar nen=(ingenias.editor.entities.tapXVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.SBhasFloor.class)){
          ingenias.editor.entities.SBhasFloor nen=(ingenias.editor.entities.SBhasFloor)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.NextTI.class)){
          ingenias.editor.entities.NextTI nen=(ingenias.editor.entities.NextTI)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.tapYVar.class)){
          ingenias.editor.entities.tapYVar nen=(ingenias.editor.entities.tapYVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.Role.class)){
          ingenias.editor.entities.Role nen=(ingenias.editor.entities.Role)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.AffectedAction.class)){
          ingenias.editor.entities.AffectedAction nen=(ingenias.editor.entities.AffectedAction)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.med.class)){
          ingenias.editor.entities.med nen=(ingenias.editor.entities.med)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.FAlternative.class)){
          ingenias.editor.entities.FAlternative nen=(ingenias.editor.entities.FAlternative)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.InitialActivity.class)){
          ingenias.editor.entities.InitialActivity nen=(ingenias.editor.entities.InitialActivity)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.durationVar.class)){
          ingenias.editor.entities.durationVar nen=(ingenias.editor.entities.durationVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.NextActivity.class)){
          ingenias.editor.entities.NextActivity nen=(ingenias.editor.entities.NextActivity)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.dropObjVar.class)){
          ingenias.editor.entities.dropObjVar nen=(ingenias.editor.entities.dropObjVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.relatedCondition.class)){
          ingenias.editor.entities.relatedCondition nen=(ingenias.editor.entities.relatedCondition)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.cond.class)){
          ingenias.editor.entities.cond nen=(ingenias.editor.entities.cond)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.isCaregiverOf.class)){
          ingenias.editor.entities.isCaregiverOf nen=(ingenias.editor.entities.isCaregiverOf)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.device.class)){
          ingenias.editor.entities.device nen=(ingenias.editor.entities.device)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.InitialDate.class)){
          ingenias.editor.entities.InitialDate nen=(ingenias.editor.entities.InitialDate)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ActionHappeningAfterwards.class)){
          ingenias.editor.entities.ActionHappeningAfterwards nen=(ingenias.editor.entities.ActionHappeningAfterwards)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.InitialDeviceLocation.class)){
          ingenias.editor.entities.InitialDeviceLocation nen=(ingenias.editor.entities.InitialDeviceLocation)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.sitDownOnSeatVar.class)){
          ingenias.editor.entities.sitDownOnSeatVar nen=(ingenias.editor.entities.sitDownOnSeatVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.DeviceActionsAttached.class)){
          ingenias.editor.entities.DeviceActionsAttached nen=(ingenias.editor.entities.DeviceActionsAttached)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.AllowedTask.class)){
          ingenias.editor.entities.AllowedTask nen=(ingenias.editor.entities.AllowedTask)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.RunAndroidApp.class)){
          ingenias.editor.entities.RunAndroidApp nen=(ingenias.editor.entities.RunAndroidApp)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.goToBodySpeedVar.class)){
          ingenias.editor.entities.goToBodySpeedVar nen=(ingenias.editor.entities.goToBodySpeedVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.waitForHumanVar.class)){
          ingenias.editor.entities.waitForHumanVar nen=(ingenias.editor.entities.waitForHumanVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.animVar.class)){
          ingenias.editor.entities.animVar nen=(ingenias.editor.entities.animVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.socialRelations.class)){
          ingenias.editor.entities.socialRelations nen=(ingenias.editor.entities.socialRelations)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.TrueFlow.class)){
          ingenias.editor.entities.TrueFlow nen=(ingenias.editor.entities.TrueFlow)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.goToSpeedVar.class)){
          ingenias.editor.entities.goToSpeedVar nen=(ingenias.editor.entities.goToSpeedVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.ConditionNeeded.class)){
          ingenias.editor.entities.ConditionNeeded nen=(ingenias.editor.entities.ConditionNeeded)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.isSpouseOf.class)){
          ingenias.editor.entities.isSpouseOf nen=(ingenias.editor.entities.isSpouseOf)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.tool.class)){
          ingenias.editor.entities.tool nen=(ingenias.editor.entities.tool)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.leaveObjDestinyVar.class)){
          ingenias.editor.entities.leaveObjDestinyVar nen=(ingenias.editor.entities.leaveObjDestinyVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.pickUpObjVar.class)){
          ingenias.editor.entities.pickUpObjVar nen=(ingenias.editor.entities.pickUpObjVar)en;
          
          
        }
        
         if (en.getClass().equals(ingenias.editor.entities.goToPlaceVar.class)){
          ingenias.editor.entities.goToPlaceVar nen=(ingenias.editor.entities.goToPlaceVar)en;
          
          
        }
        



    Hashtable ht = new Hashtable();
    en.toMap(ht);
    saveMap(ht, os);
    os.write( "</object>\n");
  }



 

}
