/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellEditorUsingRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBigDecimal;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBinary;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlob;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBoolean;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeByte;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClob;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDouble;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeFloat;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeGeneral;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeInteger;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeJavaObject;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeLong;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeOther;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeShort;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeString;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTime;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeUnknown;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.FloatingPointBase;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CellComponentFactory {
    static HashMap<ColumnDisplayDefinition, IDataTypeComponent> _colDataTypeObjects = new HashMap();
    static HashMap<String, IDataTypeComponentFactory> _pluginDataTypeFactories = new HashMap();
    static JTable _table = null;
    private static ILogger s_log = LoggerController.createLogger(CellComponentFactory.class);

    public static String getClassName(ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getClassName();
        }
        return "java.lang.Object";
    }

    public static boolean areEqual(ColumnDisplayDefinition colDef, Object newValue, Object oldValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.areEqual(newValue, oldValue);
        }
        return false;
    }

    public static String renderObject(Object value, ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.renderObject(value);
        }
        if (null == value) {
            return "<null>";
        }
        return value.toString();
    }

    public static TableCellRenderer getTableCellRenderer(ColumnDisplayDefinition colDef) {
        return new CellRenderer(CellComponentFactory.getDataTypeObject(null, colDef));
    }

    public static boolean isEditableInCell(ColumnDisplayDefinition colDef, Object originalValue) {
        if (colDef.isAutoIncrement()) {
            return false;
        }
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.isEditableInCell(originalValue);
        }
        return false;
    }

    public static boolean needToReRead(ColumnDisplayDefinition colDef, Object originalValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.needToReRead(originalValue);
        }
        return false;
    }

    public static DefaultCellEditor getInCellEditor(JTable table, ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(table, colDef);
        JTextField textField = dataTypeObject != null ? dataTypeObject.getJTextField() : new RestorableJTextField();
        textField.setBackground(SquirrelConstants.CELL_EDITABLE_COLOR);
        textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        CellEditorUsingRenderer ed = new CellEditorUsingRenderer(textField, dataTypeObject);
        ed.setClickCountToStart(1);
        return ed;
    }

    public static Object validateAndConvert(ColumnDisplayDefinition colDef, Object originalValue, String inputValue, StringBuffer messageBuffer) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.validateAndConvert(inputValue, originalValue, messageBuffer);
        }
        if (inputValue.equals("<null>")) {
            return null;
        }
        return inputValue;
    }

    public static boolean useBinaryEditingPanel(ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.useBinaryEditingPanel();
        }
        return false;
    }

    public static boolean isEditableInPopup(ColumnDisplayDefinition colDef, Object originalValue) {
        if (colDef != null && colDef.isAutoIncrement()) {
            return false;
        }
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.isEditableInPopup(originalValue);
        }
        return false;
    }

    public static JTextArea getJTextArea(ColumnDisplayDefinition colDef, Object value) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getJTextArea(value);
        }
        RestorableJTextArea textArea = new RestorableJTextArea();
        if (value != null) {
            textArea.setText(value.toString());
        } else {
            textArea.setText("");
        }
        return textArea;
    }

    public static Object validateAndConvertInPopup(ColumnDisplayDefinition colDef, Object originalValue, String inputValue, StringBuffer messageBuffer) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.validateAndConvertInPopup(inputValue, originalValue, messageBuffer);
        }
        if (inputValue.equals("<null>")) {
            return null;
        }
        return inputValue;
    }

    public static Object readResultWithPluginRegisteredDataType(ResultSet rs, int sqlType, String sqlTypeName, int index, DialectType dialectType) throws Exception {
        Object result = null;
        String typeNameKey = CellComponentFactory.getRegDataTypeKey(dialectType, sqlType, sqlTypeName);
        if (_pluginDataTypeFactories.containsKey(typeNameKey)) {
            IDataTypeComponentFactory factory = _pluginDataTypeFactories.get(typeNameKey);
            IDataTypeComponent dtComp = factory.constructDataTypeComponent();
            ColumnDisplayDefinition colDef = new ColumnDisplayDefinition(rs, index, factory.getDialectType());
            dtComp.setColumnDisplayDefinition(colDef);
            dtComp.setTable(_table);
            result = dtComp.readResultSet(rs, index, false);
        }
        return result;
    }

    public static Object readResultSet(ColumnDisplayDefinition colDef, ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.readResultSet(rs, index, limitDataRead);
        }
        return rs.getObject(index);
    }

    public static IWhereClausePart getWhereClauseValue(ColumnDisplayDefinition colDef, Object value, ISQLDatabaseMetaData md) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getWhereClauseValue(value, md);
        }
        return null;
    }

    public static void setPreparedStatementValue(ColumnDisplayDefinition colDef, PreparedStatement pstmt, Object value, int position) throws SQLException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            dataTypeObject.setPreparedStatementValue(pstmt, value, position);
        }
    }

    public static Object getDefaultValue(ColumnDisplayDefinition colDef, String dbDefaultValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getDefaultValue(dbDefaultValue);
        }
        return null;
    }

    public static boolean canDoFileIO(ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject == null) {
            return false;
        }
        return dataTypeObject.canDoFileIO();
    }

    public static String importObject(ColumnDisplayDefinition colDef, FileInputStream inStream) throws IOException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject == null) {
            throw new IOException("No internal Data Type class for this column's SQL type");
        }
        return dataTypeObject.importObject(inStream);
    }

    public static void exportObject(ColumnDisplayDefinition colDef, FileOutputStream outStream, String text) throws IOException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject == null) {
            throw new IOException("No internal Data Type class for this column's SQL type");
        }
        dataTypeObject.exportObject(outStream, text);
    }

    private static String getRegDataTypeKey(DialectType dialectType, int sqlType, String sqlTypeName) {
        StringBuilder result = new StringBuilder();
        if (dialectType == null) {
            result.append(DialectType.GENERIC.name());
        } else {
            result.append(dialectType.name());
        }
        result.append(":");
        result.append(sqlType);
        result.append(":");
        result.append(sqlTypeName);
        return result.toString();
    }

    public static void registerDataTypeFactory(IDataTypeComponentFactory factory, int sqlType, String sqlTypeName) {
        String typeName = CellComponentFactory.getRegDataTypeKey(factory.getDialectType(), sqlType, sqlTypeName);
        _pluginDataTypeFactories.put(typeName, factory);
    }

    public static OkJPanel[] getControlPanels() {
        ArrayList<OkJPanel> panelList = new ArrayList<OkJPanel>();
        String[] initialClassNameList = new String[]{DataTypeGeneral.class.getName(), DataTypeBlob.class.getName(), DataTypeClob.class.getName(), DataTypeString.class.getName(), DataTypeOther.class.getName(), DataTypeUnknown.class.getName(), DataTypeDate.class.getName(), DataTypeTime.class.getName(), DataTypeTimestamp.class.getName(), FloatingPointBase.class.getName()};
        ArrayList<String> classNameList = new ArrayList<String>(Arrays.asList(initialClassNameList));
        for (int i = 0; i < classNameList.size(); ++i) {
            String className = classNameList.get(i);
            Class[] parameterTypes = new Class[]{};
            try {
                Method panelMethod = Class.forName(className).getMethod("getControlPanel", parameterTypes);
                OkJPanel panel = (OkJPanel)panelMethod.invoke(null, (Object[])null);
                panelList.add(panel);
                continue;
            }
            catch (Exception e) {
                s_log.error("Unexpected exception: " + e.getMessage(), e);
            }
        }
        return panelList.toArray(new OkJPanel[0]);
    }

    private static IDataTypeComponent getDataTypeObject(JTable table, ColumnDisplayDefinition colDef) {
        if (s_log.isDebugEnabled()) {
            s_log.debug("getDataTypeObject: colDef=" + colDef);
        }
        IDataTypeComponent dataTypeComponent = null;
        if (table != _table) {
            _colDataTypeObjects.clear();
            _table = table;
        }
        if (_colDataTypeObjects.containsKey(colDef)) {
            dataTypeComponent = _colDataTypeObjects.get(colDef);
        } else {
            if (dataTypeComponent == null) {
                dataTypeComponent = CellComponentFactory.getCustomDataType(table, colDef);
            }
            if (dataTypeComponent == null) {
                dataTypeComponent = CellComponentFactory.getGenericDataType(table, colDef);
            }
            _colDataTypeObjects.put(colDef, dataTypeComponent);
        }
        if (s_log.isDebugEnabled() && dataTypeComponent != null) {
            s_log.debug("getDataTypeObject: returning type: " + dataTypeComponent.getClass().getName());
        } else {
            s_log.debug("getDataTypeObject: returning null type");
        }
        return dataTypeComponent;
    }

    private static IDataTypeComponent getCustomDataType(JTable table, ColumnDisplayDefinition colDef) {
        String typeName;
        IDataTypeComponentFactory factory;
        IDataTypeComponent dataTypeComponent = null;
        if (dataTypeComponent == null && !_pluginDataTypeFactories.isEmpty() && colDef.getDialectType() != null && (factory = _pluginDataTypeFactories.get(typeName = CellComponentFactory.getRegDataTypeKey(colDef.getDialectType(), colDef.getSqlType(), colDef.getSqlTypeName()))) != null) {
            dataTypeComponent = factory.constructDataTypeComponent();
            if (colDef != null) {
                dataTypeComponent.setColumnDisplayDefinition(colDef);
            }
            if (table != null) {
                dataTypeComponent.setTable(table);
            } else if (_table != null) {
                dataTypeComponent.setTable(_table);
            }
        }
        return dataTypeComponent;
    }

    private static IDataTypeComponent getGenericDataType(JTable table, ColumnDisplayDefinition colDef) {
        BaseDataTypeComponent dataTypeComponent = null;
        if (dataTypeComponent == null) {
            switch (colDef.getSqlType()) {
                case 0: {
                    if (!s_log.isDebugEnabled()) break;
                    s_log.debug("getGenericDataType: encountered an sql type = Types.NULL for column: " + colDef.getFullTableColumnName() + ". A DataTypeComponent is not available for this type.");
                    break;
                }
                case -7: 
                case 16: {
                    dataTypeComponent = new DataTypeBoolean(table, colDef);
                    break;
                }
                case 92: {
                    dataTypeComponent = new DataTypeTime(table, colDef);
                    break;
                }
                case 91: {
                    if (DataTypeDate.getReadDateAsTimestamp()) {
                        colDef.setSqlType(93);
                        colDef.setSqlTypeName("TIMESTAMP");
                        dataTypeComponent = new DataTypeTimestamp(table, colDef);
                        break;
                    }
                    dataTypeComponent = new DataTypeDate(table, colDef);
                    break;
                }
                case -102: 
                case -101: 
                case 93: {
                    dataTypeComponent = new DataTypeTimestamp(table, colDef);
                    break;
                }
                case -5: {
                    dataTypeComponent = new DataTypeLong(table, colDef);
                    break;
                }
                case 6: 
                case 8: {
                    dataTypeComponent = new DataTypeDouble(table, colDef);
                    break;
                }
                case 7: {
                    dataTypeComponent = new DataTypeFloat(table, colDef);
                    break;
                }
                case 2: 
                case 3: {
                    dataTypeComponent = new DataTypeBigDecimal(table, colDef);
                    break;
                }
                case 4: {
                    dataTypeComponent = new DataTypeInteger(table, colDef);
                    break;
                }
                case 5: {
                    dataTypeComponent = new DataTypeShort(table, colDef);
                    break;
                }
                case -6: {
                    dataTypeComponent = new DataTypeByte(table, colDef);
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    dataTypeComponent = new DataTypeString(table, colDef);
                    break;
                }
                case -8: {
                    dataTypeComponent = new DataTypeString(table, colDef);
                    colDef.setIsAutoIncrement(true);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    dataTypeComponent = new DataTypeBinary(table, colDef);
                    break;
                }
                case 2004: {
                    dataTypeComponent = new DataTypeBlob(table, colDef);
                    break;
                }
                case 2005: {
                    dataTypeComponent = new DataTypeClob(table, colDef);
                    break;
                }
                case 1111: {
                    dataTypeComponent = new DataTypeOther(table, colDef);
                    break;
                }
                case 2000: {
                    dataTypeComponent = new DataTypeJavaObject(table, colDef);
                    break;
                }
                default: {
                    dataTypeComponent = new DataTypeUnknown(table, colDef);
                }
            }
        }
        return dataTypeComponent;
    }
}

