/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause;

import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractWhereClausePart
implements IWhereClausePart {
    private String whereClause;
    private String column;

    protected AbstractWhereClausePart(ColumnDisplayDefinition columnDef, String whereClausePart) {
        this.setColumn(columnDef.getColumnName());
        this.setWhereClause(whereClausePart);
    }

    protected AbstractWhereClausePart(ColumnDisplayDefinition columnDef) {
        if (columnDef == null) {
            throw new IllegalArgumentException("columnDef must not be null");
        }
        this.setColumn(columnDef.getColumnName());
    }

    private void setColumn(String column) {
        if (StringUtils.isEmpty((String)column)) {
            throw new IllegalArgumentException("column must be not empty");
        }
        this.column = column;
    }

    @Override
    public String getWhereClause() {
        if (this.whereClause == null) {
            throw new IllegalStateException("It's not intended, that an part of an where-clause is null!");
        }
        return this.whereClause;
    }

    @Override
    public void appendToClause(StringBuilder whereClause) {
        if (!this.shouldBeUsed()) {
            throw new IllegalStateException("Should append to a whereClause, but this one should not be used!");
        }
        String clause = this.getWhereClause();
        if (whereClause.length() == 0) {
            whereClause.append(" WHERE ");
            whereClause.append(clause);
        } else {
            whereClause.append(" AND ");
            whereClause.append(clause);
        }
    }

    protected void setWhereClause(String clause) {
        if (StringUtils.isBlank((String)clause)) {
            throw new IllegalArgumentException("clause must not be blank.");
        }
        this.whereClause = clause;
    }

    @Override
    public boolean shouldBeUsed() {
        return true;
    }

    public String getColumn() {
        return this.column;
    }
}

