/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopySqlPartCommandBase;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class TableCopyInsertStatementCommand
extends TableCopySqlPartCommandBase
implements ICommand {
    private JTable _table;
    private String _statementSeparator;

    public TableCopyInsertStatementCommand(JTable table, String statementSeparator) {
        this._statementSeparator = statementSeparator;
        if (table == null) {
            throw new IllegalArgumentException("JTable == null");
        }
        this._table = table;
    }

    @Override
    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        if (selRows.length != 0 && selCols.length != 0) {
            StringBuffer buf = new StringBuffer();
            StringBuffer colNames = new StringBuffer();
            StringBuffer vals = new StringBuffer();
            for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
                boolean firstCol = true;
                for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                    TableColumn col = this._table.getColumnModel().getColumn(selCols[colIdx]);
                    ColumnDisplayDefinition colDef = null;
                    if (!(col instanceof ExtTableColumn)) continue;
                    colDef = ((ExtTableColumn)col).getColumnDisplayDefinition();
                    if (firstCol) {
                        firstCol = false;
                        colNames.append("INSERT INTO PressCtrlH (");
                        vals.append("(");
                    } else {
                        colNames.append(",");
                        vals.append(",");
                    }
                    Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    colNames.append(colDef.getColumnName());
                    vals.append(this.getData(colDef, cellObj, TableCopySqlPartCommandBase.StatType.IN));
                }
                colNames.append(")");
                vals.append(")");
                buf.append(colNames).append(" VALUES ").append(vals);
                if (1 < this._statementSeparator.length()) {
                    buf.append(" ").append(this._statementSeparator).append("\n");
                } else {
                    buf.append(this._statementSeparator).append("\n");
                }
                colNames.setLength(0);
                vals.setLength(0);
            }
            StringSelection ss = new StringSelection(buf.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }
}

