/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2003 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * SheetTableModel.java
 *
 * Created on December 13, 2002, 6:14 PM
 */

package org.openide.explorer.propertysheet;
import javax.swing.table.*;
import java.util.Enumeration;
import javax.swing.*;
import javax.swing.event.*;
/** Column model for the property sheet table.  This class primarily exists because
 *  dragging to move the center line of the table is much faster without a 
 *  DefaultTableColumnModel firing spurious change events while dragging.
 *
 * @author  Tim Boudreau
 */
final class SheetColumnModel implements TableColumnModel {
    TableColumn namesColumn;
    TableColumn valuesColumn;
    static final Object NAMES_IDENTIFIER="names"; //NOI18N
    static final Object VALUES_IDENTIFIER="values"; //NOI18N
    
    
    /** Creates a new instance of SheetTableModel */
    public SheetColumnModel() {
        namesColumn = new TableColumn(0);
        namesColumn.setIdentifier (NAMES_IDENTIFIER);
        valuesColumn = new TableColumn(1);
        valuesColumn.setIdentifier (VALUES_IDENTIFIER);
        namesColumn.setMinWidth(60);
        valuesColumn.setMinWidth(30);
    }
    
    public void addColumn(TableColumn aColumn) {
        throw new UnsupportedOperationException (
            "Adding columns not supported"); //NOI18N
    }
    
    public void addColumnModelListener(TableColumnModelListener x) {
        //do nothing - no events wil happen
    }
    
    public TableColumn getColumn(int columnIndex) {
        switch (columnIndex) {
            case 0 : return namesColumn;
            case 1 : return valuesColumn;
        }
        throw new IllegalArgumentException 
        ("Property sheet only has 2 columns - " 
        + Integer.toString(columnIndex)); //NOI18N
        
    }
    
    public int getColumnCount() {
        return 2;
    }
    
    public int getColumnIndex(Object columnIdentifier) {
        if (columnIdentifier instanceof String) {
            if (columnIdentifier.equals (NAMES_IDENTIFIER))
              return 0;
            if (columnIdentifier.equals (VALUES_IDENTIFIER))
              return 1;
        }
        throw new IllegalArgumentException ("Illegal value: " + columnIdentifier);
    }
    
    public int getColumnIndexAtX(int xPosition) {
        int width0 = namesColumn.getWidth();
        if (xPosition < width0)
            return 0;
        if (xPosition < width0 + valuesColumn.getWidth())
            return 1;
        return -1;
    }
    
    public int getColumnMargin() {
        return 1;  //XXX fix
    }
    
    public boolean getColumnSelectionAllowed() {
        return false;
    }
    
    public Enumeration getColumns() {
        return new Enumeration () {
            private boolean done=false;
            private boolean doneOne = false;
            public boolean hasMoreElements() {
                return !done;
            }
            public Object nextElement() {
                if (done) return null;
                if (doneOne) {
                    done=true;
                    return valuesColumn;
                }
                doneOne = true;
                return namesColumn;
            }
        };
    }
    
    public int getSelectedColumnCount() {
        return 0;
    }
    
    public int[] getSelectedColumns() {
        return new int[]{};
    }
    
    ListSelectionModel lsm = new DefaultListSelectionModel();
    public ListSelectionModel getSelectionModel() {
        return lsm;
    }
    
    public int getTotalColumnWidth() {
        return namesColumn.getWidth() + valuesColumn.getWidth();
    }
    
    public void moveColumn(int columnIndex, int newIndex) {
        //do nothing
    }
    
    public void removeColumn(TableColumn column) {
        throw new UnsupportedOperationException (
            "Deleting columns not supported"); //NOI18N
    }
    
    public void removeColumnModelListener(TableColumnModelListener x) {
        //do nothing, columns will not change
    }
    
    public void setColumnMargin(int newMargin) {
        //do nothing, unsupported
    }
    
    public void setColumnSelectionAllowed(boolean flag) {
        //do nothing, unsupported
    }
    
    public void setSelectionModel(ListSelectionModel newModel) {
        //do nothing, unsupported
    }
    
}
