/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import java.lang.reflect.Method;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class SaveAction
extends CookieAction {
    private static Class dataObject;
    private static Method getNodeDelegate;

    public SaveAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected Class[] cookieClasses() {
        return new Class[]{SaveCookie.class};
    }

    protected void performAction(Node[] activatedNodes) {
        SaveCookie sc = (SaveCookie)activatedNodes[0].getCookie(SaveCookie.class);
        if (sc == null) {
            return;
        }
        try {
            sc.save();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SaveAction.class, "MSG_saved", this.getSaveMessage(activatedNodes[0])));
        }
        catch (IOException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, NbBundle.getMessage(SaveAction.class, "EXC_notsaved", this.getSaveMessage(activatedNodes[0])));
            err.notify(e);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getSaveMessage(Node n) {
        Node.Cookie obj;
        if (dataObject == null) {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = this.getClass().getClassLoader();
            }
            try {
                dataObject = Class.forName("org.openide.loaders.DataObject", true, l);
                getNodeDelegate = dataObject.getMethod("getNodeDelegate", new Class[0]);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
        if (getNodeDelegate != null && (obj = n.getCookie(dataObject)) != null) {
            try {
                n = (Node)getNodeDelegate.invoke((Object)obj, new Object[0]);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
        return n.getDisplayName();
    }

    protected int mode() {
        return 8;
    }

    public String getName() {
        return NbBundle.getMessage(SaveAction.class, "Save");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/save.png";
    }
}

