/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.modules.openide.explorer.PsSettings;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.Boolean3WayEditor;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CleanComboUI;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.IconPanel;
import org.openide.explorer.propertysheet.IndexedPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class PropUtils {
    static boolean noCustomButtons = Boolean.getBoolean("netbeans.ps.noCustomButtons");
    static boolean forceRadioButtons = Boolean.getBoolean("netbeans.ps.forceRadioButtons");
    static final boolean noCheckboxCaption = !Boolean.getBoolean("netbeans.ps.checkboxCaption");
    static final boolean hideSingleExpansion = Boolean.getBoolean("netbeans.ps.hideSingleExpansion");
    static final boolean neverMargin = Boolean.getBoolean("netbeans.ps.neverMargin");
    static final boolean psCommitOnFocusLoss = !Boolean.getBoolean("netbeans.ps.NoCommitOnFocusLoss");
    private static final String KEY_ALTBG = "Tree.altbackground";
    private static final String KEY_SETBG = "PropSheet.setBackground";
    private static final String KEY_SELSETBG = "PropSheet.selectedSetBackground";
    private static final String KEY_SETFG = "PropSheet.setForeground";
    private static final String KEY_SELSETFG = "PropSheet.selectedSetForeground";
    private static final String KEY_ICONMARGIN = "netbeans.ps.iconmargin";
    static final String KEY_ROWHEIGHT = "netbeans.ps.rowheight";
    private static final String PREF_KEY_SHOWDESCRIPTION = "showDescriptionArea";
    private static final String PREF_KEY_CLOSEDSETNAMES = "closedSetNames";
    private static final String PREF_KEY_SORTORDER = "sortOrder";
    static BufferedImage scratch = null;
    static Color disFg = null;
    static float fsfactor = -1.0f;
    static int minW = -1;
    static int minH = -1;
    private static Color tfFg = null;
    private static Color tfBg = null;
    static Boolean noAltBg = null;
    private static Icon bpIcon = null;
    static int marginWidth = -1;
    private static int iconMargin = -1;
    static Color selectedSetRendererColor = null;
    static Color setRendererColor = null;
    static Icon collapsedIcon = null;
    static Icon expandedIcon = null;
    static int spinnerHeight = -1;
    static Color controlColor = null;
    static Color shadowColor = null;
    static Color altBg = null;
    private static String bptn = null;
    private static Comparator comp = null;
    private static int textMargin = -1;
    private static Color setForegroundColor = null;
    private static Color selectedSetForegroundColor = null;
    private static Boolean useOptimizedCustomButtonPainting = null;
    static boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static Graphics scratchGraphics = null;
    private static final String CAN_COMPARE_STRING = "Can compare only Node.Property instances.";
    private static final Comparator SORTER_TYPE = new Comparator(){

        public int compare(Object l, Object r) {
            Class t2;
            String s2;
            if (!(l instanceof Node.Property)) {
                throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
            }
            if (!(r instanceof Node.Property)) {
                throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
            }
            Class t1 = ((Node.Property)l).getValueType();
            String s1 = t1 != null ? t1.getName() : "";
            int s = s1.compareToIgnoreCase(s2 = (t2 = ((Node.Property)r).getValueType()) != null ? t2.getName() : "");
            if (s != 0) {
                return s;
            }
            s1 = ((Node.Property)l).getDisplayName();
            s2 = ((Node.Property)r).getDisplayName();
            return s1.compareToIgnoreCase(s2);
        }

        public String toString() {
            return "Type comparator";
        }
    };
    private static final Comparator SORTER_NAME = new Comparator(){

        public int compare(Object l, Object r) {
            if (!(l instanceof Node.Property)) {
                throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
            }
            if (!(r instanceof Node.Property)) {
                throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
            }
            String s1 = ((Node.Property)l).getDisplayName();
            String s2 = ((Node.Property)r).getDisplayName();
            return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
        }

        public String toString() {
            return "Name comparator";
        }
    };
    private static List missing = null;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheet;

    private PropUtils() {
    }

    static boolean useOptimizedCustomButtonPainting() {
        if (useOptimizedCustomButtonPainting == null) {
            useOptimizedCustomButtonPainting = "com.sun.java.swing.plaf.WindowsLookAndFeel".equals(UIManager.getLookAndFeel()) ? (PropUtils.isXPTheme() ? Boolean.TRUE : Boolean.FALSE) : ("Aqua".equals(UIManager.getLookAndFeel().getID()) ? Boolean.TRUE : Boolean.FALSE);
        }
        return useOptimizedCustomButtonPainting;
    }

    static void log(Class clazz, String msg, boolean dumpstack) {
        PropUtils.log(clazz, msg);
        if (dumpstack) {
            PropUtils.dumpStack(clazz);
        }
    }

    static void log(Class clazz, String msg) {
        if (PropUtils.isLoggable(clazz)) {
            ErrorManager.getDefault().getInstance(clazz.getName()).log(msg);
        }
    }

    static void log(Class clazz, FocusEvent fe) {
        if (PropUtils.isLoggable(clazz)) {
            StringBuffer sb = new StringBuffer(30);
            PropUtils.focusEventToString(fe, sb);
            PropUtils.log(clazz, sb.toString());
        }
    }

    static boolean isLoggable(Class clazz) {
        if (System.getProperty(clazz.getName()) == null) {
            return false;
        }
        boolean result = ErrorManager.getDefault().getInstance(clazz.getName()).isLoggable(1);
        return result;
    }

    static void logFocusOwner(Class clazz, String where) {
        if (PropUtils.isLoggable(clazz)) {
            StringBuffer sb = new StringBuffer(where);
            sb.append(" focus owner: ");
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            PropUtils.compToString(owner, sb);
        }
    }

    static void focusEventToString(FocusEvent fe, StringBuffer sb) {
        Component target = (Component)fe.getSource();
        Component opposite = fe.getOppositeComponent();
        sb.append(" focus ");
        sb.append(fe.getID() == 1004 ? " gained by " : " lost by ");
        PropUtils.compToString(target, sb);
        sb.append(fe.getID() == 1004 ? " from " : " to ");
        PropUtils.compToString(opposite, sb);
        sb.append(" isTemporary: ");
        sb.append(fe.isTemporary());
    }

    static void compToString(Component c, StringBuffer sb) {
        if (c == null) {
            sb.append(" null ");
            return;
        }
        String name = c.getName();
        Class<?> clazz = c.getClass();
        String classname = clazz.getName();
        int i = classname.lastIndexOf(46);
        if (i != -1 && i != classname.length() - 1) {
            classname = classname.substring(i + 1);
        }
        if (name != null) {
            sb.append("\"");
            sb.append(name);
            sb.append("\" (");
            sb.append(classname);
            sb.append(") ");
        } else {
            sb.append(' ');
            sb.append(classname);
            sb.append(' ');
        }
        if (!c.isVisible()) {
            sb.append(" [NOT VISIBLE] ");
        }
        if (!c.isDisplayable()) {
            sb.append(" [HAS NO PARENT COMPONENT] ");
        }
    }

    public static void dumpStack(Class clazz) {
        if (ErrorManager.getDefault().getInstance(clazz.getName()).isLoggable(1)) {
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            PropUtils.log(clazz, sw.getBuffer().toString());
        }
    }

    static Color getButtonColor() {
        return UIManager.getColor("netbeans.ps.buttonColor");
    }

    static int getCustomButtonWidth() {
        Icon ic = PropUtils.getCustomButtonIcon();
        return ic.getIconWidth() + (isAqua ? 5 : 3);
    }

    static boolean checkEnabled(Component c, PropertyEditor editor, PropertyEnv env) {
        if (editor instanceof NoPropertyEditorEditor) {
            return false;
        }
        return env == null || env.isEditable();
    }

    static Graphics getScratchGraphics(Component c) {
        if (scratchGraphics == null) {
            scratchGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        return scratchGraphics;
    }

    static Color getErrorColor() {
        Color result = UIManager.getColor("nb.errorColor");
        if (result == null) {
            result = Color.RED;
        }
        return result;
    }

    static Color getDisabledForeground() {
        if (disFg == null && (disFg = UIManager.getColor("textInactiveText")) == null) {
            disFg = Color.GRAY;
        }
        return disFg;
    }

    static float getFontSizeFactor() {
        if (fsfactor == -1.0f) {
            Font f = UIManager.getFont("controlFont");
            if (f == null) {
                JLabel jl = new JLabel();
                f = jl.getFont();
            }
            int baseSize = 12;
            fsfactor = baseSize / f.getSize();
        }
        return fsfactor;
    }

    static int getMinimumPropPanelWidth() {
        if (minW == -1) {
            int base = 50;
            minW = Math.round((float)base * PropUtils.getFontSizeFactor());
        }
        return minW;
    }

    static int getMinimumPropPanelHeight() {
        if (minH == -1) {
            int base = 18;
            minH = Math.round((float)base * PropUtils.getFontSizeFactor());
        }
        return minH;
    }

    static Dimension getMinimumPanelSize() {
        return new Dimension(PropUtils.getMinimumPropPanelWidth(), PropUtils.getMinimumPropPanelHeight());
    }

    static boolean updateProp(PropertyModel mdl, PropertyEditor ed, String title) {
        Object newValue = ed.getValue();
        Object o = PropUtils.noDlgUpdateProp(mdl, ed);
        if (o instanceof Exception) {
            PropUtils.processThrowable((Exception)o, title, newValue);
        }
        boolean result = o instanceof Boolean ? (Boolean)o : false;
        return result;
    }

    static Object noDlgUpdateProp(PropertyModel mdl, PropertyEditor ed) {
        Object newValue = ed.getValue();
        Serializable result = Boolean.FALSE;
        try {
            try {
                Object oldValue = mdl.getValue();
                if (newValue != null && !newValue.equals(oldValue) || newValue == null && oldValue != null) {
                    mdl.setValue(newValue);
                    result = Boolean.TRUE;
                }
            }
            catch (ProxyNode.DifferentValuesException dve) {
                mdl.setValue(newValue);
                result = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            result = e;
        }
        return result;
    }

    static Exception updatePropertyEditor(PropertyEditor ed, Object value) {
        Exception result = null;
        try {
            if (value instanceof String) {
                ed.setAsText((String)value);
            } else {
                ed.setValue(value);
            }
        }
        catch (Exception e) {
            result = e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean updateProp(InplaceEditor ine) {
        JComponent c = ine.getComponent();
        Cursor oldCursor = c.getCursor();
        try {
            boolean result;
            String newValString;
            c.setCursor(Cursor.getPredefinedCursor(3));
            Object o = ine.getValue();
            Exception e = PropUtils.updatePropertyEditor(ine.getPropertyEditor(), o);
            String string = o == null ? NbBundle.getMessage(PropUtils.class, "NULL") : (newValString = o.toString());
            if (e != null) {
                String propName;
                PropertyModel pm = ine.getPropertyModel();
                if (pm instanceof NodePropertyModel) {
                    Node.Property p = ((NodePropertyModel)pm).getProperty();
                    propName = p.getDisplayName();
                } else {
                    propName = pm instanceof DefaultPropertyModel ? ((DefaultPropertyModel)pm).propertyName : NbBundle.getMessage(PropUtils.class, "MSG_unknown_property_name");
                }
                PropUtils.processThrowable(e, propName, newValString);
            }
            boolean bl = result = e == null ? PropUtils.updateProp(ine.getPropertyModel(), ine.getPropertyEditor(), newValString) : false;
            return bl;
        }
        finally {
            c.setCursor(oldCursor);
        }
    }

    private static void processThrowable(Throwable throwable, String title, Object newValue) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        ErrorManager em = ErrorManager.getDefault();
        ErrorManager.Annotation[] anns = em.findAnnotations(throwable);
        if ((anns == null || anns.length == 0) && throwable.getLocalizedMessage() != throwable.getMessage()) {
            String msg = MessageFormat.format(NbBundle.getMessage(PropUtils.class, "FMT_ErrorSettingProperty"), newValue, title);
            em.annotate(throwable, 256, msg, throwable.getLocalizedMessage(), throwable, new Date());
        } else if (throwable instanceof NumberFormatException) {
            em.annotate(throwable, 256, throwable.getMessage(), MessageFormat.format(NbBundle.getMessage(PropUtils.class, "FMT_BAD_NUMBER_FORMAT"), newValue), null, null);
        }
        em.notify(throwable);
    }

    static synchronized String findLocalizedMessage(Throwable throwable, Object newValue, String title) {
        try {
            if (throwable == null) {
                return null;
            }
            ErrorManager em = ErrorManager.getDefault();
            if (throwable.getLocalizedMessage() != throwable.getMessage()) {
                return throwable.getLocalizedMessage();
            }
            ErrorManager.Annotation[] anns = em.findAnnotations(throwable);
            if (throwable instanceof NumberFormatException) {
                return MessageFormat.format(NbBundle.getMessage(PropUtils.class, "FMT_BAD_NUMBER_FORMAT"), newValue);
            }
            if (anns != null) {
                for (int i = 0; i < anns.length; ++i) {
                    if (anns[i].getLocalizedMessage() == null || anns[i].getSeverity() != 256) continue;
                    return anns[i].getLocalizedMessage();
                }
            }
            ErrorManager.getDefault().annotate(throwable, 16, null, null, null, null);
            return MessageFormat.format(NbBundle.getMessage(PropUtils.class, "FMT_CannotUpdateProperty"), newValue, title);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            return null;
        }
    }

    static Comparator getComparator(int sortingMode) {
        switch (sortingMode) {
            case 0: {
                return null;
            }
            case 1: {
                return SORTER_NAME;
            }
            case 2: {
                return SORTER_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown sorting mode: " + Integer.toString(sortingMode));
    }

    public static ComboBoxUI createComboUI(JComboBox box, boolean tableUI) {
        return new CleanComboUI(tableUI);
    }

    private static List getMissing() {
        if (missing == null) {
            missing = new ArrayList();
        }
        return missing;
    }

    static PropertyEditor getPropertyEditor(Class c) {
        PropertyEditor result = PropertyEditorManager.findEditor(c);
        if (result == null) {
            result = new NoPropertyEditorEditor();
        }
        return result;
    }

    static PropertyEditor getPropertyEditor(Node.Property p) {
        PropertyEditor result;
        block14: {
            result = p.getPropertyEditor();
            if (p instanceof Node.IndexedProperty && result == null) {
                result = new IndexedPropertyEditor();
                p.setValue("changeImmediate", Boolean.FALSE);
            }
            if (result == null) {
                result = PropUtils.getPropertyEditor(p.getValueType());
            }
            if (result == null) {
                String type;
                List missing = PropUtils.getMissing();
                if (!missing.contains(type = p.getValueType().getName())) {
                    ErrorManager.getDefault().log(1, "No property editor registered for type " + type);
                    missing.add(type);
                }
                result = new NoPropertyEditorEditor();
            } else if (p.canRead()) {
                try {
                    try {
                        try {
                            if ((p.getValueType() == Boolean.class || p.getValueType() == Boolean.TYPE) && p.getValue() == null) {
                                result = new Boolean3WayEditor();
                            }
                            PropUtils.updateEdFromProp(p, result, p.getDisplayName());
                        }
                        catch (ProxyNode.DifferentValuesException dve) {
                            if (p.getValueType() == Boolean.class || p.getValueType() == Boolean.TYPE) {
                                result = new Boolean3WayEditor();
                                break block14;
                            }
                            result = new DifferentValuesEditor(result);
                        }
                    }
                    catch (IllegalAccessException iae) {
                        IllegalStateException ise = new IllegalStateException("Error getting property value");
                        ErrorManager.getDefault().annotate((Throwable)ise, iae);
                        throw ise;
                    }
                }
                catch (InvocationTargetException ite) {
                    IllegalStateException ise = new IllegalStateException("Error getting property value");
                    ErrorManager.getDefault().annotate((Throwable)ise, ite);
                    throw ise;
                }
            }
        }
        return result;
    }

    static void updateEdFromProp(Node.Property p, PropertyEditor ed, String title) throws ProxyNode.DifferentValuesException, IllegalAccessException, InvocationTargetException {
        Object newValue = p.getValue();
        if (newValue instanceof String && ((String)newValue).length() > 2048) {
            ed.setValue(newValue);
            return;
        }
        Object oldValue = ed.getValue();
        if (newValue == null && oldValue == null) {
            return;
        }
        if (newValue != null && !newValue.equals(oldValue) || newValue == null && oldValue != null) {
            if (oldValue instanceof Object[] && newValue instanceof Object[] && Arrays.equals((Object[])oldValue, (Object[])newValue)) {
                return;
            }
            ed.setValue(newValue);
        }
    }

    static Color getControlColor() {
        if (controlColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return controlColor;
    }

    static Color getShadowColor() {
        if (shadowColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return shadowColor;
    }

    static Color getAltBg() {
        if (altBg == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return altBg;
    }

    static boolean noAltBg() {
        if (noAltBg == null) {
            noAltBg = UIManager.getColor(KEY_ALTBG) == null ? Boolean.TRUE : Boolean.FALSE;
        }
        return noAltBg;
    }

    static Color getTextFieldBackground() {
        if (tfBg == null) {
            tfBg = UIManager.getColor("TextField.background");
            if (tfBg == null) {
                tfBg = UIManager.getColor("text");
            }
            if (tfBg == null) {
                tfBg = Color.WHITE;
            }
        }
        return tfBg;
    }

    static Color getTextFieldForeground() {
        if (tfFg == null) {
            tfFg = UIManager.getColor("TextField.foreground");
            if (tfFg == null) {
                tfFg = UIManager.getColor("textText");
            }
            if (tfFg == null) {
                tfFg = Color.BLACK;
            }
        }
        return tfFg;
    }

    private static void deriveColorsAndMargin() {
        int blue;
        int green;
        int red;
        controlColor = UIManager.getColor("control");
        if (controlColor == null) {
            controlColor = Color.LIGHT_GRAY;
        }
        boolean windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
        boolean aqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        setRendererColor = UIManager.getColor(KEY_SETBG);
        selectedSetRendererColor = UIManager.getColor(KEY_SELSETBG);
        if (setRendererColor == null) {
            if (aqua) {
                setRendererColor = new Color(225, 235, 240);
            } else if (setRendererColor == null) {
                red = PropUtils.adjustColorComponent(controlColor.getRed(), -25, -25);
                green = PropUtils.adjustColorComponent(controlColor.getGreen(), -25, -25);
                blue = PropUtils.adjustColorComponent(controlColor.getBlue(), -25, -25);
                setRendererColor = new Color(red, green, blue);
            }
        }
        if (aqua) {
            selectedSetRendererColor = UIManager.getColor("Table.selectionBackground");
        }
        if (selectedSetRendererColor == null) {
            Color col;
            Color color = col = windows ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("activeCaptionBorder");
            if (col == null) {
                col = Color.BLUE;
            }
            red = PropUtils.adjustColorComponent(col.getRed(), -25, -25);
            green = PropUtils.adjustColorComponent(col.getGreen(), -25, -25);
            blue = PropUtils.adjustColorComponent(col.getBlue(), -25, -25);
            selectedSetRendererColor = new Color(red, green, blue);
        }
        if ((shadowColor = UIManager.getColor("controlShadow")) == null) {
            shadowColor = Color.GRAY;
        }
        if ((setForegroundColor = UIManager.getColor(KEY_SETFG)) == null && (setForegroundColor = UIManager.getColor("Table.foreground")) == null && (setForegroundColor = UIManager.getColor("textText")) == null) {
            setForegroundColor = Color.BLACK;
        }
        if ((selectedSetForegroundColor = UIManager.getColor(KEY_SELSETFG)) == null && (selectedSetForegroundColor = UIManager.getColor("Table.selectionForeground")) == null) {
            selectedSetForegroundColor = Color.WHITE;
        }
        if ((altBg = UIManager.getColor(KEY_ALTBG)) == null) {
            altBg = UIManager.getColor("Tree.background");
            if (altBg == null) {
                altBg = Color.WHITE;
            }
            noAltBg = Boolean.TRUE;
        } else {
            noAltBg = Boolean.FALSE;
        }
        collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        if (collapsedIcon == null) {
            collapsedIcon = new Icon(){

                public int getIconHeight() {
                    return 7;
                }

                public int getIconWidth() {
                    return 7;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            };
        }
        if ((expandedIcon = UIManager.getIcon("Tree.expandedIcon")) == null) {
            expandedIcon = collapsedIcon;
        }
        if (expandedIcon != null && expandedIcon.getIconHeight() <= 0 || expandedIcon.getIconHeight() <= 0) {
            expandedIcon = new WrapperSizeIcon(expandedIcon);
        }
        if (collapsedIcon != null && collapsedIcon.getIconHeight() <= 0 || collapsedIcon.getIconHeight() <= 0) {
            collapsedIcon = new WrapperSizeIcon(collapsedIcon);
        }
        marginWidth = collapsedIcon != null ? Math.max(14, collapsedIcon.getIconWidth() - 2) : 13;
        Integer i = (Integer)UIManager.get(KEY_ICONMARGIN);
        iconMargin = i != null ? i : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName()) ? 4 : 0);
        i = (Integer)UIManager.get(KEY_ROWHEIGHT);
        spinnerHeight = i != null ? i.intValue() : expandedIcon.getIconHeight();
    }

    static Icon getExpandedIcon() {
        if (expandedIcon == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return expandedIcon;
    }

    static Icon getCollapsedIcon() {
        if (collapsedIcon == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return collapsedIcon;
    }

    static Color getSetRendererColor() {
        if (setRendererColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return setRendererColor;
    }

    static Color getSelectedSetRendererColor() {
        if (selectedSetRendererColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return selectedSetRendererColor;
    }

    static Color getSetForegroundColor() {
        if (setForegroundColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return setForegroundColor;
    }

    static Color getSelectedSetForegroundColor() {
        if (selectedSetForegroundColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return selectedSetForegroundColor;
    }

    static int getMarginWidth() {
        if (marginWidth == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return marginWidth;
    }

    static int getSpinnerHeight() {
        if (spinnerHeight == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return spinnerHeight;
    }

    static int getIconMargin() {
        if (iconMargin == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return iconMargin;
    }

    static Icon getCustomButtonIcon() {
        if (bpIcon == null) {
            bpIcon = new BpIcon();
        }
        return bpIcon;
    }

    private static int adjustColorComponent(int base, int adjBright, int adjDark) {
        base = base > 128 ? (base -= adjBright) : (base += adjDark);
        if (base < 0) {
            base = 0;
        }
        if (base > 255) {
            base = 255;
        }
        return base;
    }

    static String basicPropsTabName() {
        if (bptn == null) {
            bptn = NbBundle.getMessage(PropUtils.class, "LBL_BasicTab");
        }
        return bptn;
    }

    static Comparator getTabListComparator() {
        if (comp == null) {
            comp = new TabListComparator();
        }
        return comp;
    }

    static SplitPaneUI createSplitPaneUI() {
        return new CleanSplitPaneUI();
    }

    static boolean shouldShowDescription() {
        return PsSettings.getDefault().getBoolean(PREF_KEY_SHOWDESCRIPTION, true);
    }

    static void saveShowDescription(boolean b) {
        PsSettings.getDefault().putBoolean(PREF_KEY_SHOWDESCRIPTION, b);
    }

    static String[] getSavedClosedSetNames() {
        String s = PsSettings.getDefault().get(PREF_KEY_CLOSEDSETNAMES, null);
        if (s != null) {
            StringTokenizer tok = new StringTokenizer(s, ",");
            String[] result = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreElements()) {
                result[i] = tok.nextToken();
                ++i;
            }
            return result;
        }
        return new String[0];
    }

    static void putSavedClosedSetNames(Set s) {
        if (s.size() > 0) {
            StringBuffer sb = new StringBuffer(s.size() * 20);
            Iterator i = s.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            PsSettings.getDefault().put(PREF_KEY_CLOSEDSETNAMES, sb.toString());
        } else {
            PsSettings.getDefault().put(PREF_KEY_CLOSEDSETNAMES, "");
        }
    }

    static void putSortOrder(int i) {
        PsSettings.getDefault().putInt(PREF_KEY_SORTORDER, i);
    }

    static int getSavedSortOrder() {
        return PsSettings.getDefault().getInt(PREF_KEY_SORTORDER, 0);
    }

    static int getTextMargin() {
        if ("apple.laf.AquaLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
            return 0;
        }
        if (textMargin == -1) {
            Object o = UIManager.get("netbeans.ps.textMargin");
            textMargin = o instanceof Integer ? (Integer)o : 2;
        }
        return textMargin;
    }

    static String createHtmlTooltip(String title, String s) {
        if (s.indexOf("<") != -1) {
            Utilities.replaceString(s, "<", "&lt;");
        }
        if (s.indexOf(">") != -1) {
            Utilities.replaceString(s, ">", "&gt;");
        }
        String token = null;
        if (s.indexOf(" ") != -1) {
            token = " ";
        } else if (s.indexOf(",") != -1) {
            token = ",";
        } else if (s.indexOf(";") != -1) {
            token = ";";
        } else if (s.indexOf("/") != -1) {
            token = "/";
        } else if (s.indexOf("\\") != -1) {
            token = "\\";
        } else {
            return s;
        }
        StringTokenizer tk = new StringTokenizer(s, token);
        StringBuffer sb = new StringBuffer(s.length() + 20);
        sb.append("<html>");
        sb.append("<b><u>");
        sb.append(title);
        sb.append("</u></b><br>");
        int charCount = 0;
        int lineCount = 0;
        while (tk.hasMoreTokens()) {
            String a = tk.nextToken();
            a = Utilities.replaceString(a, "<", "&lt;");
            a = Utilities.replaceString(a, ">", "&gt;");
            charCount += a.length();
            sb.append(a);
            if (tk.hasMoreTokens()) {
                ++charCount;
            }
            if (charCount > 80) {
                sb.append("<br>");
                charCount = 0;
                if (++lineCount <= 10) continue;
                sb.append(NbBundle.getMessage(PropUtils.class, "MSG_ELLIPSIS"));
                return sb.toString();
            }
            sb.append(token);
        }
        sb.append("</html>");
        return sb.toString();
    }

    static InplaceEditor findInnermostInplaceEditor(InplaceEditor ine) {
        while (ine instanceof IconPanel || ine instanceof ButtonPanel) {
            if (ine instanceof IconPanel) {
                ine = ((IconPanel)ine).getInplaceEditor();
                continue;
            }
            ine = ((ButtonPanel)ine).getInplaceEditor();
        }
        return ine;
    }

    static boolean shouldDrawMargin(PropertySetModel psm) {
        if (neverMargin) {
            return false;
        }
        int setCount = psm.getSetCount();
        if (psm.getComparator() != null) {
            return false;
        }
        boolean includeMargin = setCount > 1 || setCount != 1 || !hideSingleExpansion;
        return includeMargin;
    }

    private static final Color getIconForeground() {
        return UIManager.getColor("PropSheet.customButtonForeground");
    }

    public static boolean isXPTheme() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return isXP == null ? false : isXP;
    }

    private static final class WrapperSizeIcon
    implements Icon {
        private Icon wrapped;

        public WrapperSizeIcon(Icon wrapped) {
            this.wrapped = wrapped;
        }

        public int getIconWidth() {
            int result = this.wrapped.getIconWidth();
            if (result <= 0) {
                result = 11;
            }
            return result;
        }

        public int getIconHeight() {
            int result = this.wrapped.getIconHeight();
            if (result <= 0) {
                result = 11;
            }
            return result;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.wrapped.paintIcon(c, g, x, y);
        }
    }

    static class BpIcon
    implements Icon {
        boolean larger;

        public BpIcon() {
            Font f = UIManager.getFont("Table.font");
            this.larger = f != null ? f.getSize() > 13 : false;
        }

        public int getIconHeight() {
            return 12;
        }

        public int getIconWidth() {
            return this.larger ? 16 : 12;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = c.getWidth();
            int h = c.getHeight();
            int ybase = h - 5;
            int pos2 = w / 2;
            int pos1 = pos2 - 4;
            int pos3 = pos2 + 4;
            g.setColor(PropUtils.getIconForeground() == null ? c.getForeground() : PropUtils.getIconForeground());
            this.drawDot(g, pos1 + 1, ybase, this.larger);
            this.drawDot(g, pos2, ybase, this.larger);
            this.drawDot(g, pos3 - 1, ybase, this.larger);
        }

        private void drawDot(Graphics g, int x, int y, boolean larger) {
            if (!larger) {
                g.drawLine(x, y, x, y);
            } else {
                g.drawLine(x - 1, y, x + 1, y);
                g.drawLine(x, y - 1, x, y + 1);
            }
        }
    }

    private static class SplitBorder
    implements Border {
        private SplitBorder() {
        }

        public Insets getBorderInsets(Component c) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                return new Insets(2, 0, 1, 0);
            }
            return new Insets(1, 0, 1, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(x, y, x + width, y);
                g.setColor(UIManager.getColor("controlHighlight"));
                g.drawLine(x, y + 1, x + width, y + 1);
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(x, y + height - 2, x + width, y + height - 2);
            } else {
                g.setColor(UIManager.getColor("controlHighlight"));
                g.drawLine(x, y, x + width, y);
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
        }
    }

    private static class CleanSplitPaneUI
    extends BasicSplitPaneUI {
        private CleanSplitPaneUI() {
        }

        protected void installDefaults() {
            super.installDefaults();
            this.divider.setBorder(new SplitBorder());
        }
    }

    private static class TabListComparator
    implements Comparator {
        private TabListComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s1 == s2) {
                return 0;
            }
            String bn = PropUtils.basicPropsTabName();
            if (bn.equals(s1)) {
                return -1;
            }
            if (bn.equals(s2)) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    static final class NoPropertyEditorEditor
    implements PropertyEditor {
        NoPropertyEditorEditor() {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public String getAsText() {
            return NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropUtils.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet, "CTL_NoPropertyEditor");
        }

        public Component getCustomEditor() {
            return null;
        }

        public String getJavaInitializationString() {
            return "";
        }

        public String[] getTags() {
            return null;
        }

        public Object getValue() {
            return this.getAsText();
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics gfx, Rectangle box) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public void setAsText(String text) throws IllegalArgumentException {
        }

        public void setValue(Object value) {
        }

        public boolean supportsCustomEditor() {
            return false;
        }
    }

    static final class DifferentValuesEditor
    implements PropertyEditor {
        private PropertyEditor ed;
        private boolean notSet = true;

        public DifferentValuesEditor(PropertyEditor ed) {
            this.ed = ed;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.ed.addPropertyChangeListener(listener);
        }

        public String getAsText() {
            String result = this.notSet ? NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropUtils == null ? (class$org$openide$explorer$propertysheet$PropUtils = PropUtils.class$("org.openide.explorer.propertysheet.PropUtils")) : class$org$openide$explorer$propertysheet$PropUtils, "CTL_Different_Values") : this.ed.getAsText();
            return result;
        }

        public Component getCustomEditor() {
            return null;
        }

        public String getJavaInitializationString() {
            return this.ed.getJavaInitializationString();
        }

        public String[] getTags() {
            return this.ed.getTags();
        }

        public Object getValue() {
            Object result = this.notSet ? null : this.ed.getValue();
            return result;
        }

        public boolean isPaintable() {
            return this.notSet ? false : this.ed.isPaintable();
        }

        public void paintValue(Graphics gfx, Rectangle box) {
            if (this.isPaintable()) {
                this.ed.paintValue(gfx, box);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.ed.removePropertyChangeListener(listener);
        }

        public void setAsText(String text) throws IllegalArgumentException {
            this.ed.setAsText(text);
            this.notSet = false;
        }

        public void setValue(Object value) {
            this.ed.setValue(value);
            this.notSet = false;
        }

        public boolean supportsCustomEditor() {
            return false;
        }
    }
}

