/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openide.ErrorManager;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.propertysheet.BaseTable;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CustomEditorAction;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.PropertySetModelEvent;
import org.openide.explorer.propertysheet.PropertySetModelImpl;
import org.openide.explorer.propertysheet.PropertySetModelListener;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.explorer.propertysheet.SheetCellEditor;
import org.openide.explorer.propertysheet.SheetCellRenderer;
import org.openide.explorer.propertysheet.SheetColumnModel;
import org.openide.explorer.propertysheet.SheetTableModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class SheetTable
extends BaseTable
implements PropertySetModelListener,
CustomEditorAction.Invoker {
    private static final String ACTION_EXPAND = "expandSet";
    private static final String ACTION_COLLAPSE = "collapseSet";
    private static final String ACTION_CUSTOM_EDITOR = "invokeCustomEditor";
    private static final String ACTION_EDCLASS = "edclass";
    private transient boolean initialized = false;
    private FeatureDescriptor storedFd = null;
    private boolean wasEditing = false;
    private Object partialValue = null;
    private int lastSelectedRow = -1;
    private SheetCellRenderer renderer = null;
    private SheetCellEditor cellEditor = null;
    private static int instanceCount;
    private Action customEditorAction = null;
    private Action expandAction;
    private Action collapseAction;
    private Action edClassAction;
    private String beanName;
    private boolean customEditorIsOpen = false;
    private ReusablePropertyEnv reusableEnv = new ReusablePropertyEnv();
    private ReusablePropertyModel reusableModel = new ReusablePropertyModel(this.reusableEnv);
    boolean lastIncludeMargin = false;
    private HtmlRenderer.Renderer htmlrenderer = null;
    int countDown = -1;
    boolean lastFailed = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SheetTable() {
        super(new SheetTableModel(), new SheetColumnModel(), new DefaultListSelectionModel());
        this.setPropertySetModel(new PropertySetModelImpl());
        this.setRowHeight(16);
        this.setShowGrid(PropUtils.noAltBg());
        this.setShowVerticalLines(PropUtils.noAltBg());
        this.setShowHorizontalLines(PropUtils.noAltBg());
        this.setAutoResizeMode(1);
        if (!PropUtils.noAltBg()) {
            this.setIntercellSpacing(new Dimension(0, 0));
        }
        this.setGridColor(PropUtils.getSetRendererColor());
        Color c = UIManager.getColor("PropSheet.selectionBackground");
        if (c != null) {
            this.setSelectionBackground(c);
        }
        if ((c = UIManager.getColor("PropSheet.selectionForeground")) != null) {
            this.setSelectionForeground(c);
        }
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SheetTable.class, "ACSN_SHEET_TABLE"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SheetTable.class, "ACSD_SHEET_TABLE"));
        Color col = UIManager.getColor("netbeans.ps.background");
        if (col != null) {
            this.setBackground(col);
        }
        this.setFocusTraversalPolicy(new STPolicy());
        ++instanceCount;
    }

    protected void finalize() {
        if (--instanceCount == 0) {
            this.renderer = null;
            this.cellEditor = null;
            SheetTable.cleanup();
        }
    }

    SheetCellRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new SheetCellRenderer(true, this.reusableEnv, this.reusableModel);
        }
        return this.renderer;
    }

    SheetCellEditor getEditor() {
        if (this.cellEditor == null) {
            this.cellEditor = new SheetCellEditor(this.getReusablePropertyEnv());
        }
        return this.cellEditor;
    }

    void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        return this.getEditor();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.getRenderer();
    }

    public void setModel(TableModel model) {
        if (this.initialized) {
            throw new UnsupportedOperationException("Changing the model of a property sheet table is not supported.  If you want to change the set of properties, ordering or other characteristings, see setPropertySetModel().");
        }
        super.setModel(model);
    }

    public void setColumnModel(TableColumnModel model) {
        if (this.initialized) {
            throw new UnsupportedOperationException("Changing the column model of a property sheet table is not supported.  If you want to change the set of properties, ordering or other characteristings, see setPropertySetModel().");
        }
        super.setColumnModel(model);
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (this.initialized) {
            throw new UnsupportedOperationException("Changing the selection model of a property sheet table is not supported.  If you want to change the set of properties, ordering or other characteristings, see setPropertySetModel().");
        }
        super.setSelectionModel(model);
    }

    public void setPropertySetModel(PropertySetModel psm) {
        PropertySetModel old = this.getSheetModel().getPropertySetModel();
        if (old == psm) {
            return;
        }
        if (old != null) {
            old.removePropertySetModelListener(this);
        }
        this.getSheetModel().setPropertySetModel(psm);
        psm.addPropertySetModelListener(this);
    }

    PropertySetModel getPropertySetModel() {
        return this.getSheetModel().getPropertySetModel();
    }

    SheetTableModel getSheetModel() {
        return (SheetTableModel)this.getModel();
    }

    public JTableHeader getTableHeader() {
        return null;
    }

    protected void initKeysAndActions() {
        super.initKeysAndActions();
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        this.expandAction = new ExpandAction();
        this.collapseAction = new CollapseAction();
        this.edClassAction = new EditorClassAction();
        InputMap imp = this.getInputMap();
        InputMap impAncestor = this.getInputMap(1);
        ActionMap am = this.getActionMap();
        imp.put(KeyStroke.getKeyStroke(37, 0), ACTION_EXPAND);
        imp.put(KeyStroke.getKeyStroke(39, 0), ACTION_COLLAPSE);
        imp.put(KeyStroke.getKeyStroke(36, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), ACTION_EDCLASS);
        imp.put(KeyStroke.getKeyStroke(9, 0), "next");
        imp.put(KeyStroke.getKeyStroke(9, 64), "prev");
        impAncestor.put(KeyStroke.getKeyStroke(32, 128), ACTION_CUSTOM_EDITOR);
        impAncestor.remove(KeyStroke.getKeyStroke(39, 0));
        impAncestor.remove(KeyStroke.getKeyStroke(37, 0));
        am.put(ACTION_EXPAND, this.expandAction);
        am.put(ACTION_COLLAPSE, this.collapseAction);
        am.put(ACTION_CUSTOM_EDITOR, this.getCustomEditorAction());
        am.put(ACTION_EDCLASS, this.edClassAction);
    }

    Action getCustomEditorAction() {
        if (this.customEditorAction == null) {
            this.customEditorAction = new CustomEditorAction(this);
        }
        return this.customEditorAction;
    }

    protected boolean matchText(Object value, String text) {
        if (value instanceof FeatureDescriptor) {
            return ((FeatureDescriptor)value).getDisplayName().toUpperCase().startsWith(text.toUpperCase());
        }
        return false;
    }

    public void paintComponent(Graphics g) {
        boolean includeMargin = PropUtils.shouldDrawMargin(this.getPropertySetModel());
        this.getRenderer().setIncludeMargin(includeMargin);
        super.paintComponent(g);
        if (!PropUtils.noAltBg()) {
            this.paintCenterLine(g);
        }
        if (includeMargin) {
            this.paintMargin(g);
        }
        this.paintExpandableSets(g);
        this.lastIncludeMargin = includeMargin;
    }

    private void paintComponent(Graphics g, Component c, int x, int y, int w, int h) {
        c.setBounds(x, y, w, h);
        g.translate(x, y);
        c.paint(g);
        g.translate(-x, -y);
        c.setBounds(-w, -h, 0, 0);
    }

    private void paintCenterLine(Graphics g) {
        Color c = PropUtils.getAltBg();
        g.setColor(c);
        int xpos = this.getColumn(SheetColumnModel.NAMES_IDENTIFIER).getWidth() - 1;
        g.drawLine(xpos, 0, xpos, this.getHeight());
    }

    void repaintProperty(String name) {
        if (!this.isShowing()) {
            return;
        }
        if (PropUtils.isLoggable(SheetTable.class)) {
            PropUtils.log(SheetTable.class, "RepaintProperty: " + name);
        }
        PropertySetModel psm = this.getPropertySetModel();
        int min = this.getFirstVisibleRow();
        if (min == -1) {
            return;
        }
        int max = min + this.getVisibleRowCount();
        for (int i = min; i < max; ++i) {
            FeatureDescriptor fd = psm.getFeatureDescriptor(i);
            if (!fd.getName().equals(name)) continue;
            Rectangle r = this.getCellRect(i, 1, true);
            if (PropUtils.isLoggable(SheetTable.class)) {
                PropUtils.log(SheetTable.class, "Repainting " + r + " for property " + name);
            }
            this.repaint(r.x, r.y, r.width, r.height);
            return;
        }
        if (PropUtils.isLoggable(SheetTable.class)) {
            PropUtils.log(SheetTable.class, "Property is either scrolled offscreen or property name is bogus: " + name);
        }
    }

    private void paintMargin(Graphics g) {
        g.setColor(PropUtils.getSetRendererColor());
        int w = PropUtils.getMarginWidth();
        int h = this.getHeight();
        if (g.hitClip(0, 0, w, h)) {
            g.fillRect(0, 0, w, h);
        }
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
        Component result = super.prepareRenderer(renderer, row, col);
        if (row < 0 || row >= this.getRowCount()) {
            return result;
        }
        Object value = this.getValueAt(row, col);
        if (result != null && value instanceof Node.Property && col == 1) {
            result.setEnabled(((Node.Property)value).canWrite());
        }
        return result;
    }

    private void paintExpandableSets(Graphics g) {
        int start = 0;
        int end = this.getRowCount();
        Insets ins = this.getInsets();
        boolean canBeSelected = this.isKnownComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner());
        for (int i = 0; i < end; ++i) {
            boolean selected;
            boolean isHtml;
            int idx = start + i;
            Object value = this.getValueAt(idx, 0);
            if (!(value instanceof Node.PropertySet)) continue;
            Rectangle r = this.getCellRect(idx, 0, false);
            r.x = ins.left;
            r.width = this.getWidth() - (ins.left + ins.right);
            if (!g.hitClip(r.x, r.y, r.width, r.height)) continue;
            Node.PropertySet ps = (Node.PropertySet)value;
            String txt = ps.getHtmlDisplayName();
            boolean bl = isHtml = txt != null;
            if (!isHtml) {
                txt = ps.getDisplayName();
            }
            boolean bl2 = selected = canBeSelected && this.getSelectedRow() == idx;
            if (this.htmlrenderer == null) {
                this.htmlrenderer = HtmlRenderer.createRenderer();
            }
            JComponent painter = (JComponent)this.htmlrenderer.getTableCellRendererComponent(this, txt, selected, false, idx, 0);
            this.htmlrenderer.setHtml(isHtml);
            this.htmlrenderer.setParentFocused(true);
            this.htmlrenderer.setIconTextGap(2);
            this.htmlrenderer.setIcon(this.getPropertySetModel().isExpanded(ps) ? PropUtils.getExpandedIcon() : PropUtils.getCollapsedIcon());
            if (!selected) {
                painter.setBackground(PropUtils.getSetRendererColor());
                painter.setForeground(PropUtils.getSetForegroundColor());
            } else {
                painter.setBackground(PropUtils.getSelectedSetRendererColor());
                painter.setForeground(PropUtils.getSelectedSetForegroundColor());
            }
            painter.setOpaque(true);
            this.paintComponent(g, painter, r.x, r.y, r.width, r.height);
        }
    }

    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        if (!PropUtils.psCommitOnFocusLoss && !this.getEditor().isLastUpdateSuccessful()) {
            this.countDown = 2;
        }
    }

    private void autoEdit() {
        this.editCellAt(this.getSelectedRow(), this.getSelectedColumn(), null);
        if (this.editorComp != null) {
            this.editorComp.requestFocus();
        }
        this.countDown = -1;
    }

    public void changeSelection(int row, int col, boolean a, boolean b) {
        this.countDown = -1;
        super.changeSelection(row, col, a, b);
    }

    public void processFocusEvent(FocusEvent fe) {
        block6: {
            block5: {
                super.processFocusEvent(fe);
                if (fe.getID() == 1004) {
                    --this.countDown;
                    if (this.countDown == 0) {
                        this.autoEdit();
                    }
                }
                if (fe.getID() == 1004) break block5;
                if (fe.getOppositeComponent() == null) break block6;
                if (fe.getID() != 1005 || this.isAncestorOf(fe.getOppositeComponent())) break block6;
            }
            this.fireChange();
        }
    }

    protected void focusLostCancel() {
        if (PropUtils.psCommitOnFocusLoss && this.isEditing()) {
            this.getEditor().stopCellEditing();
        } else {
            super.focusLostCancel();
        }
    }

    public void processMouseEvent(MouseEvent me) {
        if (me.getID() == 501 && this.onCustomEditorButton(me) && !this.hasFocus()) {
            if (PropUtils.psCommitOnFocusLoss && this.isEditing()) {
                this.getEditor().stopCellEditing();
            }
            int row = this.rowAtPoint(me.getPoint());
            int col = this.columnAtPoint(me.getPoint());
            if (row != -1 && col != -1) {
                this.changeSelection(row, col, false, false);
                this.getCustomEditorAction().actionPerformed(new ActionEvent(this, 1001, ACTION_CUSTOM_EDITOR));
                me.consume();
                return;
            }
        }
        super.processMouseEvent(me);
    }

    public void setValueAt(Object o, int row, int column) {
    }

    protected boolean isKnownComponent(Component c) {
        boolean result = super.isKnownComponent(c);
        if (result) {
            return result;
        }
        if (c == null) {
            return false;
        }
        if (c instanceof ButtonPanel) {
            return true;
        }
        InplaceEditor ie = this.getEditor().getInplaceEditor();
        if (ie != null) {
            JComponent comp = ie.getComponent();
            if (comp == c) {
                return true;
            }
            if (comp.isAncestorOf(c)) {
                return true;
            }
        }
        if (c.getParent() instanceof ButtonPanel) {
            return true;
        }
        if (this.getParent() != null && this.getParent().isAncestorOf(c)) {
            return true;
        }
        Container par = this.getParent();
        if (par != null && par.isAncestorOf(c)) {
            return true;
        }
        if (c instanceof InplaceEditor) {
            return true;
        }
        InplaceEditor ine = this.getEditor().getInplaceEditor();
        if (ine != null) {
            return ine.isKnownComponent(c);
        }
        return false;
    }

    private boolean onCustomEditorButton(MouseEvent e) {
        PropertyEditor pe;
        boolean success;
        Point pt = e.getPoint();
        int row = this.rowAtPoint(pt);
        int col = this.columnAtPoint(pt);
        FeatureDescriptor fd = this.getSheetModel().getPropertySetModel().getFeatureDescriptor(row);
        if (PropUtils.noCustomButtons) {
            success = false;
        } else {
            boolean bl = success = e.getX() > this.getWidth() - PropUtils.getCustomButtonWidth();
        }
        if ((e.getID() == 501 || e.getID() == 502 || e.getID() == 500) && !(success |= Boolean.FALSE.equals(fd.getValue("canEditAsText"))) && fd instanceof Node.Property && (pe = PropUtils.getPropertyEditor((Node.Property)fd)) != null && pe.supportsCustomEditor()) {
            success |= pe.isPaintable() && pe.getAsText() == null && pe.getTags() == null;
        }
        try {
            if (success && fd instanceof Node.Property && col == 1) {
                boolean supp = PropUtils.getPropertyEditor((Node.Property)fd).supportsCustomEditor();
                return supp;
            }
        }
        catch (IllegalStateException ise) {
            ErrorManager.getDefault().notify(16, ise);
        }
        return false;
    }

    public String getToolTipText(MouseEvent e) {
        String result;
        if (this.customEditorIsOpen) {
            return null;
        }
        Point pt = e.getPoint();
        int row = this.rowAtPoint(pt);
        int col = this.columnAtPoint(pt);
        if (col == 1 && this.onCustomEditorButton(e)) {
            result = NbBundle.getMessage(SheetTable.class, "CTL_EDBUTTON_TIP");
        } else {
            result = this.getSheetModel().getDescriptionFor(row, col);
            if (col == 1 && result != null && result.length() > 100) {
                result = PropUtils.createHtmlTooltip(this.getPropertySetModel().getFeatureDescriptor(row).getDisplayName(), result);
            }
        }
        return result;
    }

    public final FeatureDescriptor getSelection() {
        return this._getSelection();
    }

    public final FeatureDescriptor _getSelection() {
        int i = this.getSelectedRow();
        FeatureDescriptor result = i < this.getPropertySetModel().getCount() ? this.getSheetModel().getPropertySetModel().getFeatureDescriptor(this.getSelectedRow()) : null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean useRadioButtons;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.enterEditRequest();
        if (this.editingRow == row && this.isEditing() && column == 0) {
            this.removeEditor();
            this.exitEditRequest();
            return false;
        }
        if (this.editingRow == row && this.isEditing()) {
            this.exitEditRequest();
            return false;
        }
        if (PropUtils.psCommitOnFocusLoss && this.isEditing()) {
            this.getEditor().stopCellEditing();
        }
        if (e instanceof MouseEvent && this.onCenterLine((MouseEvent)e)) {
            this.exitEditRequest();
            return false;
        }
        if (e instanceof MouseEvent && this.onCustomEditorButton((MouseEvent)e)) {
            if (PropUtils.isLoggable(SheetTable.class)) {
                PropUtils.log(SheetTable.class, "Got a mouse click on the custom editor button");
            }
            if (this.isEditing() && this.editingRow != row) {
                this.removeEditor();
            }
            int prevSel = this.getSelectedRow();
            this.changeSelection(row, column, false, false);
            if (prevSel != -1) {
                this.paintRow(prevSel);
            }
            this.paintSelectionRow();
            this.getCustomEditorAction().actionPerformed(new ActionEvent(this, 0, null));
            this.exitEditRequest();
            return false;
        }
        FeatureDescriptor fd = this.getPropertySetModel().getFeatureDescriptor(row);
        if (fd instanceof Node.PropertySet) {
            if (this.isEditing()) {
                this.removeEditor();
                this.changeSelection(row, column, false, false);
            }
            this.maybeToggleExpanded(row, e);
            this.exitEditRequest();
            return false;
        }
        boolean bl = useRadioButtons = e instanceof MouseEvent && PropUtils.forceRadioButtons || fd != null && fd.getValue("stringValues") != null;
        if (!useRadioButtons && (column == 1 || e instanceof KeyEvent) && this.checkEditBoolean(row)) {
            this.exitEditRequest();
            return false;
        }
        boolean result = false;
        try {
            result = super.editCellAt(row, column, e);
        }
        finally {
            this.exitEditRequest();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEditor() {
        this.enterEditorRemoveRequest();
        try {
            super.removeEditor();
            this.getEditor().setInplaceEditor(null);
        }
        finally {
            this.exitEditorRemoveRequest();
        }
    }

    public boolean isCellEditable(int row, int column) {
        boolean result;
        if (column == 0) {
            return false;
        }
        FeatureDescriptor fd = this.getPropertySetModel().getFeatureDescriptor(row);
        if (fd instanceof Node.PropertySet) {
            result = false;
        } else {
            Object val;
            Node.Property p = (Node.Property)fd;
            result = p.canWrite();
            if (result && (val = p.getValue("canEditAsText")) != null) {
                result &= Boolean.TRUE.equals(val);
            }
        }
        return result;
    }

    private void maybeToggleExpanded(int row, EventObject e) {
        boolean doExpand = true;
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            boolean bl = doExpand = me.getClickCount() > 1;
            if (!doExpand) {
                boolean bl2 = doExpand = me.getPoint().x <= PropUtils.getMarginWidth();
            }
        }
        if (doExpand) {
            this.toggleExpanded(row);
        }
    }

    private void toggleExpanded(int index) {
        if (this.isEditing()) {
            this.getEditor().cancelCellEditing();
        }
        PropertySetModel psm = this.getSheetModel().getPropertySetModel();
        psm.toggleExpanded(index);
    }

    boolean checkEditBoolean(int row) {
        Class c;
        Node.Property p;
        FeatureDescriptor fd = this.getSheetModel().getPropertySetModel().getFeatureDescriptor(row);
        if (fd.getValue("stringValues") != null) {
            return false;
        }
        Node.Property property = p = fd instanceof Node.Property ? (Node.Property)fd : null;
        if (p != null && ((c = p.getValueType()) == Boolean.class || c == Boolean.TYPE)) {
            if (!this.isCellEditable(row, 1)) {
                return true;
            }
            try {
                Boolean b = null;
                try {
                    b = (Boolean)p.getValue();
                }
                catch (ProxyNode.DifferentValuesException dve) {
                    b = Boolean.FALSE;
                }
                if (this.isEditing()) {
                    this.removeEditor();
                }
                this.changeSelection(row, 1, false, false);
                Boolean newValue = b == null || Boolean.FALSE.equals(b) ? Boolean.TRUE : Boolean.FALSE;
                p.setValue(newValue);
                this.paintRow(row);
                return true;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
        return false;
    }

    public Component prepareEditor(TableCellEditor editor, int row, int col) {
        if (editor == null) {
            return null;
        }
        Component result = super.prepareEditor(editor, row, col);
        if (result == null) {
            return null;
        }
        InplaceEditor ine = this.getEditor().getInplaceEditor();
        if (ine.supportsTextEntry()) {
            result.setBackground(PropUtils.getTextFieldBackground());
            result.setForeground(PropUtils.getTextFieldForeground());
        }
        if (result instanceof JComponent) {
            ((JComponent)result).setBorder(BorderFactory.createEmptyBorder(0, PropUtils.getTextMargin(), 0, 0));
        }
        return result;
    }

    public void tableChanged(TableModelEvent e) {
        boolean ed = this.isEditing();
        int n = this.lastSelectedRow = ed ? this.getEditingRow() : this.getSelectionModel().getAnchorSelectionIndex();
        if (ed) {
            this.getEditor().cancelCellEditing();
        }
        super.tableChanged(e);
        this.restoreEditingState();
    }

    void saveEditingState() {
        InplaceEditor ine;
        this.storedFd = this._getSelection();
        if (this.isEditing() && (ine = this.getEditor().getInplaceEditor()) != null) {
            this.partialValue = ine.getValue();
        }
    }

    void restoreEditingState() {
        boolean canResumeEditing;
        int idx = this.indexOfLastSelected();
        boolean bl = canResumeEditing = idx != -1;
        if (!canResumeEditing) {
            idx = this.lastSelectedRow;
        }
        if (idx == -1) {
            this.clearSavedEditingState();
            return;
        }
        if (idx < this.getRowCount()) {
            this.changeSelection(idx, 1, false, false);
            if (canResumeEditing && this.wasEditing) {
                this.editCellAt(idx, 1);
                InplaceEditor ine = this.getEditor().getInplaceEditor();
                if (ine != null && this.partialValue != null) {
                    ine.setValue(this.partialValue);
                }
            }
        }
        this.clearSavedEditingState();
    }

    private void clearSavedEditingState() {
        this.storedFd = null;
        this.wasEditing = false;
        this.partialValue = null;
    }

    private int indexOfLastSelected() {
        if (this.storedFd == null) {
            return -1;
        }
        PropertySetModel mdl = this.getPropertySetModel();
        int idx = mdl.indexOf(this.storedFd);
        this.storedFd = null;
        return idx;
    }

    public void pendingChange(PropertySetModelEvent e) {
        if (e.isReordering()) {
            this.wasEditing = this.isEditing();
            this.saveEditingState();
        } else {
            this.storedFd = null;
            this.wasEditing = false;
            this.partialValue = null;
        }
    }

    public void boundedChange(PropertySetModelEvent e) {
    }

    public void wholesaleChange(PropertySetModelEvent e) {
    }

    public Component getCursorChangeComponent() {
        Container cont = this.getTopLevelAncestor();
        return cont instanceof JFrame ? ((JFrame)cont).getContentPane() : (cont instanceof JDialog ? ((JDialog)cont).getContentPane() : cont);
    }

    public Object getPartialValue() {
        Object partialValue = null;
        if (this.isEditing() && this.editingRow == this.getSelectedRow()) {
            InplaceEditor ine = this.getEditor().getInplaceEditor();
            if (ine != null) {
                partialValue = ine.getValue();
                ine.reset();
                this.getEditor().cancelCellEditing();
            }
        } else {
            partialValue = null;
            if (this.isEditing()) {
                this.removeEditor();
            }
        }
        return partialValue;
    }

    public void editorClosed() {
        if (this.lastFailed) {
            this.editCellAt(this.getSelectedRow(), 1, null);
        }
        this.repaint();
        this.customEditorIsOpen = false;
    }

    public void editorOpened() {
        this.paintSelectionRow();
        this.customEditorIsOpen = true;
    }

    public void editorOpening() {
        this.lastFailed = false;
        this.customEditorIsOpen = true;
    }

    public void valueChanged(PropertyEditor editor) {
        this.lastFailed = false;
    }

    public boolean allowInvoke() {
        return true;
    }

    public void failed() {
        this.lastFailed = true;
    }

    public boolean wantAllChanges() {
        return false;
    }

    public ReusablePropertyEnv getReusablePropertyEnv() {
        return this.reusableEnv;
    }

    public ReusablePropertyModel getReusablePropertyModel() {
        return this.reusableModel;
    }

    static {
        $assertionsDisabled = !SheetTable.class.desiredAssertionStatus();
        instanceCount = 0;
    }

    private class STPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private STPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (SheetTable.this.inEditorRemoveRequest()) {
                return SheetTable.this;
            }
            Component result = super.getComponentAfter(focusCycleRoot, aComponent);
            return result;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (SheetTable.this.inEditorRemoveRequest()) {
                return SheetTable.this;
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            if (!SheetTable.this.inEditorRemoveRequest() && SheetTable.this.isEditing()) {
                return SheetTable.this.editorComp;
            }
            return SheetTable.this;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            if (!SheetTable.this.inEditorRemoveRequest() && SheetTable.this.isEditing() && SheetTable.this.editorComp.isShowing()) {
                return SheetTable.this.editorComp;
            }
            return SheetTable.this;
        }

        protected boolean accept(Component aComponent) {
            InplaceEditor ine;
            if (SheetTable.this.isEditing() && SheetTable.this.inEditorRemoveRequest() && (ine = SheetTable.this.getEditor().getInplaceEditor()) != null && (aComponent == ine.getComponent() || ine.isKnownComponent(aComponent))) {
                return false;
            }
            return super.accept(aComponent) && aComponent.isShowing();
        }
    }

    private class EditorClassAction
    extends AbstractAction {
        public EditorClassAction() {
            super(SheetTable.ACTION_EDCLASS);
        }

        public void actionPerformed(ActionEvent ae) {
            int i = SheetTable.this.getSelectedRow();
            if (i != -1) {
                FeatureDescriptor fd = SheetTable.this.getPropertySetModel().getFeatureDescriptor(i);
                if (fd instanceof Node.Property) {
                    PropertyEditor ped = PropUtils.getPropertyEditor((Node.Property)fd);
                    System.err.println(ped.getClass().getName());
                } else {
                    System.err.println("PropertySets - no editor");
                }
            } else {
                System.err.println("No selection");
            }
        }

        public boolean isEnabled() {
            return SheetTable.this.getSelectedRow() != -1;
        }
    }

    private class CollapseAction
    extends AbstractAction {
        public CollapseAction() {
            super(SheetTable.ACTION_COLLAPSE);
        }

        public void actionPerformed(ActionEvent ae) {
            FeatureDescriptor fd = SheetTable.this._getSelection();
            if (fd instanceof Node.PropertySet) {
                int row = SheetTable.this.getSelectedRow();
                boolean b = SheetTable.this.getPropertySetModel().isExpanded(fd);
                if (!b) {
                    SheetTable.this.toggleExpanded(row);
                }
            }
        }

        public boolean isEnabled() {
            boolean result = SheetTable.this._getSelection() instanceof Node.PropertySet;
            return result;
        }
    }

    private class ExpandAction
    extends AbstractAction {
        public ExpandAction() {
            super(SheetTable.ACTION_EXPAND);
        }

        public void actionPerformed(ActionEvent ae) {
            FeatureDescriptor fd = SheetTable.this._getSelection();
            if (fd instanceof Node.PropertySet) {
                int row = SheetTable.this.getSelectedRow();
                boolean b = SheetTable.this.getPropertySetModel().isExpanded(fd);
                if (b) {
                    SheetTable.this.toggleExpanded(row);
                }
            }
        }

        public boolean isEnabled() {
            return SheetTable.this._getSelection() instanceof Node.PropertySet;
        }
    }
}

