/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Position;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.explorer.view.TreeViewDragSupport;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public abstract class TreeView
extends JScrollPane {
    static final long serialVersionUID = -1639001987693376168L;
    private static final int TIME_TO_COLLAPSE;
    private static final int MIN_TREEVIEW_WIDTH = 400;
    private static final int MIN_TREEVIEW_HEIGHT = 400;
    protected transient JTree tree;
    transient NodeTreeModel treeModel;
    transient ExplorerManager manager;
    transient PopupSupport defaultActionListener;
    transient boolean defaultActionEnabled;
    transient PopupAdapter popupListener;
    transient TreePropertyListener managerListener = null;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    private transient boolean dragActive = true;
    private transient boolean dropActive = true;
    transient TreeViewDragSupport dragSupport;
    transient TreeViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient Container contentPane;
    private transient List storeSelectedPaths;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    private static boolean isSynth;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeView;
    static /* synthetic */ Class class$java$awt$event$KeyListener;

    public TreeView() {
        this(true, true);
    }

    public TreeView(boolean defaultAction, boolean popupAllowed) {
        this.initializeTree();
        if (DragDropUtilities.dragAndDropEnabled) {
            ExplorerDnDManager.getDefault().addFutureDropTarget(this);
        }
        this.setPopupAllowed(popupAllowed);
        this.setDefaultActionAllowed(defaultAction);
        Dimension dim = null;
        try {
            dim = this.getPreferredSize();
            if (dim == null) {
                dim = new Dimension(400, 400);
            }
        }
        catch (NullPointerException npe) {
            dim = new Dimension(400, 400);
        }
        if (dim.width < 400) {
            dim.width = 400;
        }
        if (dim.height < 400) {
            dim.height = 400;
        }
        this.setPreferredSize(dim);
    }

    public void updateUI() {
        super.updateUI();
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public Border getBorder() {
        if (isSynth) {
            return BorderFactory.createEmptyBorder();
        }
        return super.getBorder();
    }

    void initializeTree() {
        this.treeModel = this.createModel();
        this.tree = new ExplorerTree(this.treeModel);
        NodeRenderer rend = new NodeRenderer();
        this.tree.setCellRenderer(rend);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.setViewportView(this.tree);
        this.tree.setCellEditor(new TreeViewCellEditor(this.tree));
        this.tree.setEditable(true);
        this.setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.managerListener = new TreePropertyListener();
        this.tree.addTreeExpansionListener(this.managerListener);
        this.tree.addTreeWillExpandListener(this.managerListener);
        this.setRequestFocusEnabled(false);
        this.defaultActionListener = new PopupSupport();
        this.getActionMap().put("org.openide.actions.PopupAction", this.defaultActionListener.popup);
        this.tree.addFocusListener(this.defaultActionListener);
        this.tree.addMouseListener(this.defaultActionListener);
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setPopupAllowed(boolean value) {
        if (this.popupListener == null && value) {
            this.popupListener = new PopupAdapter();
            this.tree.addMouseListener(this.popupListener);
            return;
        }
        if (this.popupListener != null && !value) {
            this.tree.removeMouseListener(this.popupListener);
            this.popupListener = null;
            return;
        }
    }

    void setDropTargetPopupAllowed(boolean value) {
        this.dropTargetPopupAllowed = value;
        if (this.dropSupport != null) {
            this.dropSupport.setDropTargetPopupAllowed(value);
        }
    }

    boolean isDropTargetPopupAllowed() {
        return this.dropSupport != null ? this.dropSupport.isDropTargetPopupAllowed() : this.dropTargetPopupAllowed;
    }

    public boolean isDefaultActionEnabled() {
        return this.defaultActionEnabled;
    }

    public void requestFocus() {
        this.tree.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    public void setDefaultActionAllowed(boolean value) {
        this.defaultActionEnabled = value;
        if (value) {
            this.tree.registerKeyboardAction(this.defaultActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
        this.tree.setShowsRootHandles(!visible);
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean state) {
        if (state && this.dragSupport == null) {
            this.dragSupport = new TreeViewDragSupport(this, this.tree);
        }
        this.dragActive = state;
        if (this.dragSupport != null) {
            this.dragSupport.activate(this.dragActive);
        }
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean state) {
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new TreeViewDropSupport(this, this.tree, this.dropTargetPopupAllowed);
        }
        this.dropActive = state;
        if (this.dropSupport != null) {
            this.dropSupport.activate(this.dropActive);
        }
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int actions) {
        this.allowedDragActions = actions;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    public void setAllowedDropActions(int actions) {
        this.allowedDropActions = actions;
    }

    public void collapseNode(Node n) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.tree.collapsePath(treePath);
    }

    public void expandNode(Node n) {
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.tree.expandPath(treePath);
    }

    public boolean isExpanded(Node n) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        return this.tree.isExpanded(treePath);
    }

    public void expandAll() {
        int j;
        int i = 0;
        do {
            j = this.tree.getRowCount();
            this.tree.expandRow(i);
        } while (j != this.tree.getRowCount() || ++i < this.tree.getRowCount());
    }

    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
    }

    private void lookupExplorerManager() {
        ExplorerManager newManager = ExplorerManager.find(this);
        if (newManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = newManager;
            this.wlvc = WeakListeners.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.synchronizeRootContext();
            this.synchronizeExploredContext();
            this.synchronizeSelectedNodes();
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
    }

    protected abstract NodeTreeModel createModel();

    protected abstract void selectionChanged(Node[] var1, ExplorerManager var2) throws PropertyVetoException;

    protected abstract boolean selectionAccept(Node[] var1);

    protected abstract void showPath(TreePath var1);

    protected abstract void showSelection(TreePath[] var1);

    protected boolean useExploredContextMenu() {
        return false;
    }

    private boolean isSelectionModeBroken(Node[] nodes) {
        if (nodes.length <= 1 || this.getSelectionMode() == 4) {
            return false;
        }
        if (this.getSelectionMode() == 1) {
            return true;
        }
        TreePath[] paths = new TreePath[nodes.length];
        RowMapper rowMapper = this.tree.getSelectionModel().getRowMapper();
        if (rowMapper == null) {
            return false;
        }
        ArrayList<Node> toBeExpaned = new ArrayList<Node>(3);
        for (int i = 0; i < nodes.length; ++i) {
            TreePath treePath;
            toBeExpaned.clear();
            Node n = nodes[i];
            while (n.getParentNode() != null) {
                if (!this.isExpanded(n)) {
                    toBeExpaned.add(n);
                }
                n = n.getParentNode();
            }
            for (int j = toBeExpaned.size() - 1; j >= 0; --j) {
                this.expandNode((Node)toBeExpaned.get(j));
            }
            paths[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, nodes[i])));
        }
        int[] rows = rowMapper.getRowsForPaths(paths);
        Arrays.sort(rows);
        for (int i = 1; i < rows.length; ++i) {
            if (rows[i] == rows[i - 1] + 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callSelectionChanged(Node[] nodes) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            try {
                this.selectionChanged(nodes, this.manager);
            }
            catch (PropertyVetoException e) {
                this.synchronizeSelectedNodes();
                Object var4_3 = null;
                this.manager.addPropertyChangeListener(this.wlpc);
                this.manager.addVetoableChangeListener(this.wlvc);
            }
            Object var4_2 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
            throw throwable;
        }
    }

    final void synchronizeRootContext() {
        this.treeModel.setNode(this.manager.getRootContext());
    }

    final void synchronizeExploredContext() {
        Node n = this.manager.getExploredContext();
        if (n != null) {
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
            this.showPath(treePath);
        }
    }

    public void setSelectionMode(int mode) {
        this.tree.getSelectionModel().setSelectionMode(mode);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    private void showWaitCursor() {
        if (this.getRootPane() == null) {
            return;
        }
        this.contentPane = this.getRootPane().getContentPane();
        if (SwingUtilities.isEventDispatchThread()) {
            this.contentPane.setCursor(Utilities.createProgressCursor(this.contentPane));
        } else {
            SwingUtilities.invokeLater(new CursorR(this.contentPane, Utilities.createProgressCursor(this.contentPane)));
        }
    }

    private void showNormalCursor() {
        if (this.contentPane == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.contentPane.setCursor(null);
        } else {
            SwingUtilities.invokeLater(new CursorR(this.contentPane, null));
        }
    }

    private void prepareWaitCursor(final Node node) {
        if (node == null) {
            this.showNormalCursor();
        }
        this.showWaitCursor();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    node.getChildren().getNodes(true);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, e);
                }
                finally {
                    TreeView.this.showNormalCursor();
                }
            }
        });
    }

    final void synchronizeSelectedNodes() {
        VisualizerNode.runQueue();
        Node[] arr = this.manager.getSelectedNodes();
        TreePath[] paths = new TreePath[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            TreePath treePath;
            paths[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, arr[i])));
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.showSelection(paths);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    void scrollTreeToVisible(TreePath path, TreeNode child) {
        Rectangle base = this.tree.getVisibleRect();
        Rectangle b1 = this.tree.getPathBounds(path);
        Rectangle b2 = this.tree.getPathBounds(new TreePath(this.treeModel.getPathToRoot(child)));
        if (base != null && b1 != null && b2 != null) {
            this.tree.scrollRectToVisible(new Rectangle(base.x, b1.y, 1, b2.y - b1.y + b2.height));
        }
    }

    private void createPopup(int xpos, int ypos, JPopupMenu popup) {
        if (popup != null && popup.getSubElements().length > 0) {
            popup.show(this, xpos, ypos);
        }
    }

    void createPopup(int xpos, int ypos) {
        Node[] arr;
        Action[] actions;
        if (this.isPopupAllowed() && (actions = NodeOp.findActions(arr = this.manager.getSelectedNodes())).length > 0) {
            this.createPopup(xpos, ypos, Utilities.actionsToPopup(actions, this));
        }
    }

    void createExtendedPopup(int xpos, int ypos, JMenu newMenu) {
        Node[] ns = this.manager.getSelectedNodes();
        JPopupMenu popup = null;
        if (ns.length > 0) {
            Action[] actions = NodeOp.findActions(ns);
            popup = Utilities.actionsToPopup(actions, this);
        } else if (this.manager.getRootContext() != null) {
            popup = this.manager.getRootContext().getContextMenu();
        }
        boolean cnt = false;
        if (popup == null) {
            popup = SystemAction.createPopupMenu(new SystemAction[0]);
        }
        popup.add(newMenu);
        this.createPopup(xpos, ypos, popup);
    }

    Point getPositionForPopup() {
        int i = this.tree.getLeadSelectionRow();
        if (i < 0) {
            return null;
        }
        Rectangle rect = this.tree.getRowBounds(i);
        if (rect == null) {
            return null;
        }
        Point p = new Point(rect.x, rect.y);
        p = SwingUtilities.convertPoint(this.tree, p, this);
        return p;
    }

    static final TreePath findSiblingTreePath(TreePath parentPath, int[] childIndices) {
        if (childIndices == null) {
            throw new IllegalArgumentException("Indexes of changed children are null.");
        }
        if (parentPath == null) {
            throw new IllegalArgumentException("The tree path to parent is null.");
        }
        if (childIndices.length == 0) {
            return null;
        }
        TreeNode parent = (TreeNode)parentPath.getLastPathComponent();
        Object[] parentPaths = parentPath.getPath();
        TreePath newSelection = null;
        if (parent.getChildCount() > 0) {
            int childPathLength = parentPaths.length + 1;
            Object[] childPath = new Object[childPathLength];
            System.arraycopy(parentPaths, 0, childPath, 0, parentPaths.length);
            int selectedChild = childIndices[0] - 1;
            if (selectedChild < 0) {
                selectedChild = 0;
            }
            childPath[childPathLength - 1] = parent.getChildAt(selectedChild);
            newSelection = new TreePath(childPath);
        } else {
            newSelection = new TreePath(parentPaths);
        }
        return newSelection;
    }

    static {
        UIManager.put("Tree.scrollsHorizontallyAndVertically", Boolean.TRUE);
        TIME_TO_COLLAPSE = System.getProperty("netbeans.debug.heap") != null ? 0 : 15000;
        isSynth = UIManager.getLookAndFeel().getClass().getName().indexOf("com.sun.java.swing.plaf.gtk") != -1;
    }

    private final class ExplorerTree
    extends JTree
    implements Autoscroll {
        AutoscrollSupport support;
        private String maxPrefix;
        int SEARCH_FIELD_PREFERRED_SIZE;
        int SEARCH_FIELD_SPACE;
        private boolean firstPaint;
        private JTextField searchTextField;
        private JPanel searchpanel;
        private final int heightOfTextField;
        private int originalScrollMode;

        ExplorerTree(TreeModel model) {
            super(model);
            this.SEARCH_FIELD_PREFERRED_SIZE = 160;
            this.SEARCH_FIELD_SPACE = 3;
            this.firstPaint = true;
            this.searchTextField = new JTextField(this){
                private final /* synthetic */ ExplorerTree this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isManagingFocus() {
                    return true;
                }

                public void processKeyEvent(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        ExplorerTree.access$1100(this.this$1);
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 4 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                4.access$1200(this.this$2).requestFocus();
                            }
                        });
                    } else {
                        super.processKeyEvent(ke);
                    }
                }

                static /* synthetic */ ExplorerTree access$1200(4 x0) {
                    return x0.this$1;
                }
            };
            this.searchpanel = null;
            this.heightOfTextField = this.searchTextField.getPreferredSize().height;
            this.toggleClickCount = 0;
            this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("COPY"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("PASTE"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("CUT"), "none");
            this.setupSearch();
        }

        public void updateUI() {
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        private void calcRowHeight(Graphics g) {
            int height = g.getFontMetrics(this.getFont()).getHeight();
            String s = System.getProperty("nb.cellrenderer.fixedheight");
            if (s != null) {
                try {
                    height = Integer.parseInt(s);
                    this.setRowHeight(height);
                    this.firstPaint = false;
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.setRowHeight(Math.max(18, height + 2));
            this.firstPaint = false;
        }

        public void paint(Graphics g) {
            Children.MUTEX.readAccess(new Mutex.Action(this, g){
                private final /* synthetic */ Graphics val$g;
                private final /* synthetic */ ExplorerTree this$1;
                {
                    this.this$1 = this$1;
                    this.val$g = val$g;
                }

                public Object run() {
                    if (ExplorerTree.access$800(this.this$1)) {
                        ExplorerTree.access$900(this.this$1, this.val$g);
                        this.val$g.setColor(this.this$1.getBackground());
                        this.val$g.fillRect(0, 0, this.this$1.getWidth(), this.this$1.getHeight());
                        return null;
                    }
                    ExplorerTree.access$1001(this.this$1, this.val$g);
                    return null;
                }
            });
        }

        public void setFont(Font f) {
            if (f != this.getFont()) {
                this.firstPaint = true;
                super.setFont(f);
            }
        }

        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            this.repaintSelection();
        }

        private void repaintSelection() {
            int first = this.getSelectionModel().getMinSelectionRow();
            int last = this.getSelectionModel().getMaxSelectionRow();
            if (first != -1) {
                if (first == last) {
                    Rectangle r = this.getRowBounds(first);
                    this.repaint(r.x, r.y, r.width, r.height);
                } else {
                    Rectangle top = this.getRowBounds(first);
                    Rectangle bottom = this.getRowBounds(last);
                    Rectangle r = new Rectangle();
                    r.x = Math.min(top.x, bottom.x);
                    r.y = top.y;
                    r.width = this.getWidth();
                    r.height = bottom.y + bottom.height - top.y;
                    this.repaint(r.x, r.y, r.width, r.height);
                }
            }
        }

        private void prepareSearchPanel() {
            if (this.searchpanel == null) {
                this.searchpanel = new JPanel();
                JLabel lbl = new JLabel(NbBundle.getMessage(class$org$openide$explorer$view$TreeView == null ? (class$org$openide$explorer$view$TreeView = TreeView.class$("org.openide.explorer.view.TreeView")) : class$org$openide$explorer$view$TreeView, "LBL_QUICKSEARCH"));
                this.searchpanel.setLayout(new BoxLayout(this.searchpanel, 0));
                this.searchpanel.add(lbl);
                this.searchpanel.add(this.searchTextField);
                lbl.setLabelFor(this.searchTextField);
                this.searchpanel.setBorder(BorderFactory.createRaisedBevelBorder());
                lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            }
        }

        private void setupSearch() {
            KeyListener[] keyListeners = (KeyListener[])this.getListeners(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = TreeView.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener);
            for (int i = 0; i < keyListeners.length; ++i) {
                this.removeKeyListener(keyListeners[i]);
            }
            this.addKeyListener(new KeyAdapter(this){
                private boolean armed;
                private final /* synthetic */ ExplorerTree this$1;
                {
                    this.this$1 = this$1;
                    this.armed = false;
                }

                public void keyPressed(KeyEvent e) {
                    int modifiers = e.getModifiers();
                    int keyCode = e.getKeyCode();
                    if (keyCode == 521 || keyCode == 45 || keyCode == 107 || keyCode == 109) {
                        return;
                    }
                    if (modifiers > 0 && modifiers != 1 || e.isActionKey()) {
                        return;
                    }
                    char c = e.getKeyChar();
                    if (!Character.isISOControl(c) && keyCode != 16 && keyCode != 27) {
                        this.armed = true;
                        e.consume();
                    }
                }

                public void keyTyped(KeyEvent e) {
                    if (this.armed) {
                        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                        ExplorerTree.access$1300(this.this$1).setText(String.valueOf(stroke.getKeyChar()));
                        ExplorerTree.access$1400(this.this$1);
                        e.consume();
                        this.armed = false;
                    }
                }
            });
            SearchFieldListener searchFieldListener = new SearchFieldListener();
            this.searchTextField.addKeyListener(searchFieldListener);
            this.searchTextField.addFocusListener(searchFieldListener);
            this.searchTextField.getDocument().addDocumentListener(searchFieldListener);
        }

        private List doSearch(String prefix) {
            TreePath path;
            ArrayList<TreePath> results = new ArrayList<TreePath>();
            int[] rows = this.getSelectionRows();
            int startIndex = rows == null || rows.length == 0 ? 0 : rows[0];
            int size = this.getRowCount();
            if (size == 0) {
                return results;
            }
            while ((path = this.getNextMatch(prefix, startIndex %= size, Position.Bias.Forward)) != null && !results.contains(path)) {
                startIndex = TreeView.this.tree.getRowForPath(path);
                results.add(path);
                String elementName = ((VisualizerNode)path.getLastPathComponent()).getDisplayName();
                if (this.maxPrefix == null) {
                    this.maxPrefix = elementName;
                }
                this.maxPrefix = this.findMaxPrefix(this.maxPrefix, elementName);
                ++startIndex;
            }
            return results;
        }

        private String findMaxPrefix(String str1, String str2) {
            String res = null;
            int i = 0;
            while (str1.regionMatches(true, 0, str2, 0, i)) {
                res = str1.substring(0, i);
                ++i;
            }
            return res;
        }

        private void displaySearchField() {
            if (!this.searchTextField.isDisplayable()) {
                JViewport viewport = TreeView.this.getViewport();
                this.originalScrollMode = viewport.getScrollMode();
                viewport.setScrollMode(0);
                this.searchTextField.setFont(this.getFont());
                this.prepareSearchPanel();
                this.add(this.searchpanel);
                this.doLayout();
                this.searchpanel.repaint();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ExplorerTree this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ExplorerTree.access$1300(this.this$1).requestFocus();
                    }
                });
            }
        }

        public void doLayout() {
            super.doLayout();
            Rectangle visibleRect = this.getVisibleRect();
            if (this.searchpanel != null && this.searchpanel.isDisplayable()) {
                int width = Math.min(this.getPreferredSize().width - this.SEARCH_FIELD_SPACE * 2, this.SEARCH_FIELD_PREFERRED_SIZE - this.SEARCH_FIELD_SPACE);
                this.searchpanel.setBounds(Math.max(this.SEARCH_FIELD_SPACE, visibleRect.x + visibleRect.width - width), visibleRect.y + this.SEARCH_FIELD_SPACE, Math.min(visibleRect.width, width) - this.SEARCH_FIELD_SPACE, this.heightOfTextField);
            }
        }

        private void removeSearchField() {
            if (this.searchpanel.isDisplayable()) {
                this.remove(this.searchpanel);
                TreeView.this.getViewport().setScrollMode(this.originalScrollMode);
                Rectangle r = this.searchpanel.getBounds();
                this.repaint(r);
            }
        }

        public void autoscroll(Point cursorLoc) {
            this.getSupport().autoscroll(cursorLoc);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public String getToolTipText(MouseEvent event) {
            if (event != null) {
                Point p = event.getPoint();
                int selRow = this.getRowForLocation(p.x, p.y);
                if (selRow != -1) {
                    TreePath path = this.getPathForRow(selRow);
                    VisualizerNode v = (VisualizerNode)path.getLastPathComponent();
                    String tooltip = v.getShortDescription();
                    String displayName = v.getDisplayName();
                    if (tooltip != null && !tooltip.equals(displayName)) {
                        return tooltip;
                    }
                }
            }
            return null;
        }

        protected TreeModelListener createTreeModelListener() {
            return new ModelHandler();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerTree();
            }
            return this.accessibleContext;
        }

        static /* synthetic */ boolean access$800(ExplorerTree x0) {
            return x0.firstPaint;
        }

        static /* synthetic */ void access$900(ExplorerTree x0, Graphics x1) {
            x0.calcRowHeight(x1);
        }

        static /* synthetic */ void access$1001(ExplorerTree x0, Graphics x1) {
            super.paint(x1);
        }

        static /* synthetic */ void access$1400(ExplorerTree x0) {
            x0.displaySearchField();
        }

        private class ModelHandler
        extends JTree.TreeModelHandler {
            ModelHandler() {
                super(ExplorerTree.this);
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreePath[] selectionPaths = ExplorerTree.this.getSelectionPaths();
                Enumeration<TreePath> expanded = ExplorerTree.this.getExpandedDescendants(e.getTreePath());
                super.treeStructureChanged(e);
                if (expanded != null) {
                    while (expanded.hasMoreElements()) {
                        ExplorerTree.this.expandPath(expanded.nextElement());
                    }
                }
                if (selectionPaths != null && selectionPaths.length > 0) {
                    boolean wasSelected = ExplorerTree.this.isPathSelected(selectionPaths[0]);
                    ExplorerTree.this.setSelectionPaths(selectionPaths);
                    if (!wasSelected) {
                        ExplorerTree.this.scrollPathToVisible(selectionPaths[0]);
                    }
                }
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                super.treeNodesRemoved(e);
                if (ExplorerDnDManager.getDefault().isDnDActive()) {
                    return;
                }
                if (TreeView.this.storeSelectedPaths == null || TreeView.this.storeSelectedPaths.size() == ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.getSelectionCount()) {
                    return;
                }
                if (((ExplorerTree)ExplorerTree.this).TreeView.this.tree.getSelectionCount() == 0) {
                    TreePath path = TreeView.findSiblingTreePath(e.getTreePath(), e.getChildIndices());
                    if (path == null || path.equals(e.getTreePath())) {
                        return;
                    }
                    if (path.getPathCount() > 0) {
                        ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.setSelectionPath(path);
                    }
                }
            }
        }

        private class AccessibleExplorerTree
        extends JTree.AccessibleJTree {
            AccessibleExplorerTree() {
                super(ExplorerTree.this);
            }

            public String getAccessibleName() {
                return TreeView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return TreeView.this.getAccessibleContext().getAccessibleDescription();
            }
        }

        private class SearchFieldListener
        extends KeyAdapter
        implements DocumentListener,
        FocusListener {
            private List results = new ArrayList();
            private int currentSelectionIndex;

            SearchFieldListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void insertUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void removeUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 27) {
                    ExplorerTree.this.removeSearchField();
                    ExplorerTree.this.requestFocus();
                } else if (keyCode == 38) {
                    --this.currentSelectionIndex;
                    this.displaySearchResult();
                    e.consume();
                } else if (keyCode == 40) {
                    ++this.currentSelectionIndex;
                    this.displaySearchResult();
                    e.consume();
                } else if (keyCode == 9) {
                    if (ExplorerTree.this.maxPrefix != null) {
                        ExplorerTree.this.searchTextField.setText(ExplorerTree.this.maxPrefix);
                    }
                    e.consume();
                } else if (keyCode == 10) {
                    ExplorerTree.this.removeSearchField();
                    TreePath selectedTPath = ExplorerTree.this.getSelectionPath();
                    if (selectedTPath != null) {
                        TreeNode selectedTNode = (TreeNode)selectedTPath.getLastPathComponent();
                        Node selectedNode = Visualizer.findNode(selectedTNode);
                        if (selectedNode.getPreferredAction() != null && selectedNode.getPreferredAction().isEnabled()) {
                            selectedNode.getPreferredAction().actionPerformed(new ActionEvent(this, 1001, ""));
                        } else {
                            ExplorerTree.this.expandPath(ExplorerTree.this.getSelectionPath());
                        }
                    }
                    ExplorerTree.this.requestFocus();
                    ExplorerTree.this.dispatchEvent(e);
                }
            }

            private void searchForNode() {
                this.currentSelectionIndex = 0;
                this.results.clear();
                ExplorerTree.this.maxPrefix = null;
                String text = ExplorerTree.this.searchTextField.getText().toUpperCase();
                if (text.length() > 0) {
                    this.results = ExplorerTree.this.doSearch(text);
                    this.displaySearchResult();
                }
            }

            private void displaySearchResult() {
                int sz = this.results.size();
                if (sz > 0) {
                    if (this.currentSelectionIndex < 0) {
                        this.currentSelectionIndex = sz - 1;
                    } else if (this.currentSelectionIndex >= sz) {
                        this.currentSelectionIndex = 0;
                    }
                    TreePath path = (TreePath)this.results.get(this.currentSelectionIndex);
                    ExplorerTree.this.setSelectionPath(path);
                    ExplorerTree.this.scrollPathToVisible(path);
                } else {
                    ExplorerTree.this.clearSelection();
                }
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ExplorerTree.this.removeSearchField();
            }
        }
    }

    final class PopupSupport
    extends MouseAdapter
    implements Runnable,
    FocusListener,
    ActionListener {
        public final Action popup = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(this);
            }
        };

        PopupSupport() {
        }

        public void run() {
            Point p = TreeView.this.getPositionForPopup();
            if (p == null) {
                return;
            }
            TreeView.this.createPopup(p.x, p.y);
        }

        public void focusGained(FocusEvent ev) {
            ev.getComponent().removeFocusListener(this);
            if (DragDropUtilities.dragAndDropEnabled && TreeView.this.dragActive) {
                TreeView.this.setDragSource(true);
            }
        }

        public void focusLost(FocusEvent ev) {
        }

        public void mouseClicked(MouseEvent e) {
            int selRow = TreeView.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow != -1 && SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick(e)) {
                TreePath selPath;
                Node node;
                Action a;
                if (TreeView.this.defaultActionEnabled && (a = (node = Visualizer.findNode((selPath = TreeView.this.tree.getPathForLocation(e.getX(), e.getY())).getLastPathComponent())).getPreferredAction()) != null) {
                    if (a instanceof ContextAwareAction) {
                        a = ((ContextAwareAction)a).createContextAwareInstance(node.getLookup());
                    }
                    if (a.isEnabled()) {
                        a.actionPerformed(new ActionEvent(node, 1001, ""));
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    e.consume();
                    return;
                }
                if (TreeView.this.tree.isExpanded(selRow)) {
                    TreeView.this.tree.collapseRow(selRow);
                } else {
                    TreeView.this.tree.expandRow(selRow);
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            Action a;
            Node[] nodes = TreeView.this.manager.getSelectedNodes();
            if (nodes.length == 1 && (a = nodes[0].getPreferredAction()) != null) {
                if (a.isEnabled()) {
                    a.actionPerformed(new ActionEvent(nodes[0], 1001, ""));
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = TreeView.this.tree.getRowForLocation(e.getX(), e.getY());
            if (!TreeView.this.tree.isRowSelected(selRow)) {
                TreeView.this.tree.setSelectionRow(selRow);
            }
            if (selRow != -1) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), TreeView.this);
                TreeView.this.createPopup((int)p.getX(), (int)p.getY());
            }
        }
    }

    class TreePropertyListener
    implements VetoableChangeListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeWillExpandListener,
    TreeSelectionListener,
    Runnable {
        private RequestProcessor.Task scheduled;
        private TreePath[] readAccessPaths;

        TreePropertyListener() {
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName().equals("selectedNodes")) {
                Node[] nodes = (Node[])evt.getNewValue();
                if (TreeView.this.isSelectionModeBroken(nodes)) {
                    throw new PropertyVetoException("selection mode " + TreeView.this.getSelectionMode() + " broken by " + Arrays.asList(nodes), evt);
                }
                if (!TreeView.this.selectionAccept(nodes)) {
                    throw new PropertyVetoException("selection " + Arrays.asList(nodes) + " rejected", evt);
                }
            }
        }

        public final void propertyChange(PropertyChangeEvent evt) {
            if (TreeView.this.manager == null) {
                return;
            }
            if (evt.getPropertyName().equals("rootContext")) {
                TreeView.this.synchronizeRootContext();
            }
            if (evt.getPropertyName().equals("exploredContext")) {
                TreeView.this.synchronizeExploredContext();
            }
            if (evt.getPropertyName().equals("selectedNodes")) {
                TreeView.this.synchronizeSelectedNodes();
            }
        }

        public synchronized void treeExpanded(TreeExpansionEvent ev) {
            RequestProcessor.Task t = this.scheduled;
            if (t != null) {
                t.cancel();
            }
            class Request
            implements Runnable {
                private TreePath path;
                private final /* synthetic */ TreePropertyListener this$1;

                public Request(TreePropertyListener this$1, TreePath path) {
                    this.this$1 = this$1;
                    this.path = path;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    try {
                        if (!TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isVisible(this.path)) {
                            return;
                        }
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel == null) {
                            return;
                        }
                        TreeNode myNode = (TreeNode)this.path.getLastPathComponent();
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(myNode)[0] != TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                            return;
                        }
                        int lastChildIndex = myNode.getChildCount() - 1;
                        if (lastChildIndex >= 0) {
                            TreeNode lastChild = myNode.getChildAt(lastChildIndex);
                            Rectangle base = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getVisibleRect();
                            Rectangle b1 = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getPathBounds(this.path);
                            Rectangle b2 = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getPathBounds(new TreePath(TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(lastChild)));
                            if (base != null && b1 != null && b2 != null) {
                                TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.scrollRectToVisible(new Rectangle(base.x, b1.y, 1, b2.y - b1.y + b2.height));
                            }
                        }
                    }
                    finally {
                        this.path = null;
                    }
                }
            }
            this.scheduled = RequestProcessor.getDefault().post(new Request(this, ev.getPath()), 250);
        }

        public synchronized void treeCollapsed(TreeExpansionEvent ev) {
            TreeView.this.showNormalCursor();
            class Request
            implements Runnable {
                private TreePath path;
                private final /* synthetic */ TreePropertyListener this$1;

                public Request(TreePropertyListener this$1, TreePath path) {
                    this.this$1 = this$1;
                    this.path = path;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    try {
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isExpanded(this.path)) {
                            return;
                        }
                        if (!TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isVisible(this.path)) {
                            return;
                        }
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel == null) {
                            return;
                        }
                        TreeNode myNode = (TreeNode)this.path.getLastPathComponent();
                        if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(myNode)[0] != TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                            return;
                        }
                        TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.nodeStructureChanged(myNode);
                    }
                    finally {
                        this.path = null;
                    }
                }
            }
            RequestProcessor.getDefault().post(new Request(this, ev.getPath()), TIME_TO_COLLAPSE);
        }

        public void valueChanged(TreeSelectionEvent ev) {
            TreePath[] paths = TreeView.this.tree.getSelectionPaths();
            TreeView.this.storeSelectedPaths = Arrays.asList(paths == null ? new TreePath[]{} : paths);
            if (paths == null) {
                if (ExplorerDnDManager.getDefault().isDnDActive()) {
                    return;
                }
                TreeView.this.callSelectionChanged(new Node[0]);
            } else {
                this.readAccessPaths = paths;
                Children.MUTEX.postReadRequest(this);
            }
        }

        public void run() {
            if (this.readAccessPaths == null) {
                return;
            }
            TreePath[] paths = this.readAccessPaths;
            this.readAccessPaths = null;
            ArrayList<Node> ll = new ArrayList<Node>(paths.length);
            for (int i = 0; i < paths.length; ++i) {
                Node n = Visualizer.findNode(paths[i].getLastPathComponent());
                if (n != TreeView.this.manager.getRootContext() && n.getParentNode() == null) continue;
                ll.add(n);
            }
            TreeView.this.callSelectionChanged(ll.toArray(new Node[ll.size()]));
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            TreeView.this.prepareWaitCursor(DragDropUtilities.secureFindNode(path.getLastPathComponent()));
        }

        static /* synthetic */ TreeView access$300(TreePropertyListener x0) {
            return x0.TreeView.this;
        }
    }

    private static class CursorR
    implements Runnable {
        private Container contentPane;
        private Cursor c;

        private CursorR(Container cont, Cursor c) {
            this.contentPane = cont;
            this.c = c;
        }

        public void run() {
            this.contentPane.setCursor(this.c);
        }
    }
}

