/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class FilterNode
extends Node {
    private Node original;
    private PropertyChangeListener propL;
    private NodeListener nodeL;
    private int delegateMask;
    protected static final int DELEGATE_SET_NAME = 1;
    protected static final int DELEGATE_GET_NAME = 2;
    protected static final int DELEGATE_SET_DISPLAY_NAME = 4;
    protected static final int DELEGATE_GET_DISPLAY_NAME = 8;
    protected static final int DELEGATE_SET_SHORT_DESCRIPTION = 16;
    protected static final int DELEGATE_GET_SHORT_DESCRIPTION = 32;
    protected static final int DELEGATE_DESTROY = 64;
    protected static final int DELEGATE_GET_ACTIONS = 128;
    protected static final int DELEGATE_GET_CONTEXT_ACTIONS = 256;
    protected static final int DELEGATE_SET_VALUE = 512;
    protected static final int DELEGATE_GET_VALUE = 1024;
    private static final int DELEGATE_ALL = 2047;
    private boolean pchlAttached = false;
    private boolean childrenProvided;
    private static final WeakHashMap overridesGetDisplayNameCache;
    private static final WeakHashMap replaceProvidedLookupCache;
    private static volatile int hashCodeDepth;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$util$LookupListener;

    public FilterNode(Node original) {
        this(original, null);
    }

    public FilterNode(Node original, org.openide.nodes.Children children) {
        this(original, children, new FilterLookup());
    }

    public FilterNode(Node original, org.openide.nodes.Children children, Lookup lookup) {
        super(children == null ? (original.isLeaf() ? org.openide.nodes.Children.LEAF : new Children(original)) : children, lookup);
        this.childrenProvided = children != null;
        this.original = original;
        this.init();
        Lookup lkp = this.internalLookup(false);
        if (lkp instanceof FilterLookup) {
            ((FilterLookup)lkp).ownNode(this);
        } else if (lkp == null) {
            this.getNodeListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Lookup replaceProvidedLookup(Lookup lookup) {
        WeakHashMap weakHashMap = replaceProvidedLookupCache;
        synchronized (weakHashMap) {
            Boolean b = (Boolean)replaceProvidedLookupCache.get(this.getClass());
            if (b == null) {
                b = this.overridesAMethod("getCookie", new Class[]{Class.class}) ? Boolean.FALSE : Boolean.TRUE;
                replaceProvidedLookupCache.put(this.getClass(), b);
            }
            return b != false ? lookup : null;
        }
    }

    private boolean overridesAMethod(String name, Class[] arguments) {
        if (this.getClass() == FilterNode.class) {
            return false;
        }
        try {
            Method m = this.getClass().getMethod(name, arguments);
            if (m.getDeclaringClass() != FilterNode.class) {
                return true;
            }
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().notify(ex);
        }
        return false;
    }

    private void init() {
        this.delegateMask = 2047;
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener l) {
        if (!this.pchlAttached) {
            this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = true;
        }
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener l) {
        if (this.getPropertyChangeListenersCount() == 0) {
            this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = false;
        }
    }

    protected void finalize() {
        this.original.removePropertyChangeListener(this.getPropertyChangeListener());
        this.original.removeNodeListener(this.getNodeListener());
    }

    protected final void enableDelegation(int mask) {
        if ((mask & 0xFFFFF800) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + mask);
        }
        this.delegateMask |= mask;
    }

    protected final void disableDelegation(int mask) {
        if ((mask & 0xFFFFF800) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + mask);
        }
        this.delegateMask &= ~mask;
    }

    private final boolean delegating(int what) {
        return (this.delegateMask & what) != 0;
    }

    public Node cloneNode() {
        if (this.isDefault()) {
            return new FilterNode(this.original);
        }
        return new FilterNode(this);
    }

    private boolean checkIfIamAccessibleFromOriginal(Node original) {
        if (this == original) {
            throw new IllegalArgumentException("Node cannot be its own original (even thru indirect chain)");
        }
        if (original instanceof FilterNode) {
            FilterNode f = (FilterNode)original;
            this.checkIfIamAccessibleFromOriginal(f.original);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeOriginal(Node original, boolean changeChildren) {
        Lookup lkp;
        if (changeChildren && !(this.getChildren() instanceof Children) && this.getChildren() != Children.LEAF) {
            throw new IllegalStateException("Can't change implicitly defined Children on FilterNode");
        }
        if (!$assertionsDisabled && !this.checkIfIamAccessibleFromOriginal(original)) {
            throw new AssertionError((Object)"");
        }
        try {
            Children.PR.enterWriteAccess();
            this.original.removeNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            }
            this.original = original;
            this.original.addNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            }
            if (changeChildren) {
                if (original.isLeaf() && this.getChildren() != Children.LEAF) {
                    this.setChildren(Children.LEAF);
                } else if (!original.isLeaf() && this.getChildren() == Children.LEAF) {
                    this.setChildren(new Children(original));
                } else if (!original.isLeaf() && this.getChildren() != Children.LEAF) {
                    ((Children)this.getChildren()).changeOriginal(original);
                }
            }
        }
        finally {
            Children.PR.exitWriteAccess();
        }
        if ((lkp = this.internalLookup(false)) instanceof FilterLookup) {
            ((FilterLookup)lkp).checkNode();
        }
        this.fireCookieChange();
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireShortDescriptionChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
        this.firePropertySetsChange(null, null);
    }

    public void setValue(String attributeName, Object value) {
        if (this.delegating(512)) {
            this.original.setValue(attributeName, value);
        } else {
            super.setValue(attributeName, value);
        }
    }

    public Object getValue(String attributeName) {
        if (this.delegating(1024)) {
            return this.original.getValue(attributeName);
        }
        return super.getValue(attributeName);
    }

    public void setName(String s) {
        if (this.delegating(1)) {
            this.original.setName(s);
        } else {
            super.setName(s);
        }
    }

    public String getName() {
        if (this.delegating(2)) {
            return this.original.getName();
        }
        return super.getName();
    }

    public void setDisplayName(String s) {
        if (this.delegating(4)) {
            this.original.setDisplayName(s);
        } else {
            super.setDisplayName(s);
        }
    }

    public String getDisplayName() {
        if (this.delegating(8)) {
            return this.original.getDisplayName();
        }
        return super.getDisplayName();
    }

    public void setShortDescription(String s) {
        if (this.delegating(16)) {
            this.original.setShortDescription(s);
        } else {
            super.setShortDescription(s);
        }
    }

    public String getShortDescription() {
        if (this.delegating(32)) {
            return this.original.getShortDescription();
        }
        return super.getShortDescription();
    }

    public Image getIcon(int type) {
        return this.original.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.original.getOpenedIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    public boolean canRename() {
        return this.original.canRename();
    }

    public boolean canDestroy() {
        return this.original.canDestroy();
    }

    public void destroy() throws IOException {
        if (this.delegating(64)) {
            this.original.destroy();
        } else {
            super.destroy();
        }
    }

    private final void originalDestroyed() {
        try {
            super.destroy();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, ex);
        }
    }

    public Node.PropertySet[] getPropertySets() {
        return this.original.getPropertySets();
    }

    public Transferable clipboardCopy() throws IOException {
        return this.original.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        return this.original.clipboardCut();
    }

    public boolean canCopy() {
        return this.original.canCopy();
    }

    public boolean canCut() {
        return this.original.canCut();
    }

    public Transferable drag() throws IOException {
        return this.original.drag();
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return this.original.getDropType(t, action, index);
    }

    public PasteType[] getPasteTypes(Transferable t) {
        return this.original.getPasteTypes(t);
    }

    public NewType[] getNewTypes() {
        return this.original.getNewTypes();
    }

    public SystemAction[] getActions() {
        if (this.delegating(128)) {
            return this.original.getActions();
        }
        return super.getActions();
    }

    public SystemAction[] getContextActions() {
        if (this.delegating(256)) {
            return this.original.getContextActions();
        }
        return super.getContextActions();
    }

    public SystemAction getDefaultAction() {
        return this.original.getDefaultAction();
    }

    public Action[] getActions(boolean context) {
        if (context ? !this.delegating(128) || this.overridesAMethod("getContextActions", new Class[0]) : !this.delegating(256) || this.overridesAMethod("getActions", new Class[0])) {
            return super.getActions(context);
        }
        Action[] retValue = this.original.getActions(context);
        return retValue;
    }

    public Action getPreferredAction() {
        Action retValue = this.overridesAMethod("getDefaultAction", new Class[0]) ? super.getPreferredAction() : this.original.getPreferredAction();
        return retValue;
    }

    public String getHtmlDisplayName() {
        if (this.overridesGetDisplayName()) {
            return null;
        }
        return this.delegating(8) ? this.original.getHtmlDisplayName() : super.getHtmlDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean overridesGetDisplayName() {
        WeakHashMap weakHashMap = overridesGetDisplayNameCache;
        synchronized (weakHashMap) {
            Boolean b = (Boolean)overridesGetDisplayNameCache.get(this.getClass());
            if (b == null) {
                b = this.overridesAMethod("getDisplayName", null) ? Boolean.TRUE : Boolean.FALSE;
                overridesGetDisplayNameCache.put(this.getClass(), b);
            }
            return b != false;
        }
    }

    public boolean hasCustomizer() {
        return this.original.hasCustomizer();
    }

    public Component getCustomizer() {
        return this.original.getCustomizer();
    }

    public Node.Cookie getCookie(Class type) {
        Object o;
        Lookup l = this.internalLookup(true);
        if (l != null && (o = l.lookup(type)) instanceof Node.Cookie) {
            return (Node.Cookie)o;
        }
        return this.original.getCookie(type);
    }

    public Node.Handle getHandle() {
        if (!this.isDefault()) {
            return null;
        }
        Node.Handle original = this.original.getHandle();
        if (original == null) {
            return null;
        }
        return new FilterHandle(original);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Node left = FilterNode.getRepresentation(this);
        Node right = FilterNode.getRepresentation((Node)o);
        if (left instanceof FilterNode || right instanceof FilterNode) {
            return left == right;
        }
        return left.equals(right);
    }

    private static Node getRepresentation(Node n) {
        while (n instanceof FilterNode) {
            FilterNode fn = (FilterNode)n;
            if (!fn.isDefault()) {
                return n;
            }
            n = fn.original;
        }
        return n;
    }

    public int hashCode() {
        try {
            int result;
            if (!$assertionsDisabled && !FilterNode.hashCodeLogging(true)) {
                throw new AssertionError((Object)"");
            }
            int n = result = this.isDefault() ? this.original.hashCode() : System.identityHashCode(this);
            if (!$assertionsDisabled && !FilterNode.hashCodeLogging(false)) {
                throw new AssertionError((Object)"");
            }
            return result;
        }
        catch (StackError err) {
            err.add(this);
            throw err;
        }
    }

    private static boolean hashCodeLogging(boolean enter) {
        if (hashCodeDepth > 1000) {
            hashCodeDepth = 0;
            throw new StackError();
        }
        hashCodeDepth = enter ? ++hashCodeDepth : --hashCodeDepth;
        return true;
    }

    protected Node getOriginal() {
        return this.original;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeAdapter(this);
    }

    protected NodeListener createNodeListener() {
        return new NodeAdapter(this);
    }

    synchronized PropertyChangeListener getPropertyChangeListener() {
        if (this.propL == null) {
            this.propL = this.createPropertyChangeListener();
        }
        return this.propL;
    }

    synchronized NodeListener getNodeListener() {
        if (this.nodeL == null) {
            this.nodeL = this.createNodeListener();
            this.getOriginal().addNodeListener(this.nodeL);
        }
        return this.nodeL;
    }

    final void listenerAdded() {
        this.getNodeListener();
    }

    private boolean isDefault() {
        if (this.getClass() != FilterNode.class) {
            return false;
        }
        return !this.childrenProvided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateChildren() {
        if (this.isDefault()) {
            org.openide.nodes.Children newChildren = null;
            try {
                Children.PR.enterReadAccess();
                if (this.original.hierarchy == Children.LEAF && this.hierarchy != Children.LEAF) {
                    newChildren = Children.LEAF;
                } else if (this.original.hierarchy != Children.LEAF && this.hierarchy == Children.LEAF) {
                    newChildren = new Children(this.original);
                }
            }
            finally {
                Children.PR.exitReadAccess();
            }
            if (newChildren != null) {
                final org.openide.nodes.Children set = newChildren;
                Children.MUTEX.postWriteRequest(new Runnable(){

                    public void run() {
                        FilterNode.this.setChildren(set);
                    }
                });
            }
        }
    }

    static {
        $assertionsDisabled = !FilterNode.class.desiredAssertionStatus();
        overridesGetDisplayNameCache = new WeakHashMap(27);
        replaceProvidedLookupCache = new WeakHashMap(27);
    }

    private static final class FilterLookup
    extends Lookup {
        private FilterNode node;
        private Lookup delegate;
        private WeakSet results;

        FilterLookup() {
        }

        public void ownNode(FilterNode n) {
            this.node = n;
        }

        private Object replaceNodes(Object orig, Class clazz) {
            if (FilterLookup.isNodeQuery(clazz) && orig == this.node.getOriginal() && clazz.isInstance(this.node)) {
                return this.node;
            }
            return orig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup checkNode() {
            Lookup l = this.node.getOriginal().getLookup();
            if (this.delegate == l) {
                return l;
            }
            Iterator<Object> toCheck = null;
            FilterLookup filterLookup = this;
            synchronized (filterLookup) {
                if (l != this.delegate) {
                    this.delegate = l;
                    if (this.results != null) {
                        toCheck = Arrays.asList(this.results.toArray()).iterator();
                    }
                }
            }
            if (toCheck != null) {
                Iterator<Object> it = toCheck;
                while (it.hasNext()) {
                    ProxyResult p = (ProxyResult)it.next();
                    if (!p.updateLookup(l)) continue;
                    p.resultChanged(null);
                }
            }
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup.Result lookup(Lookup.Template template) {
            ProxyResult p = new ProxyResult(template);
            FilterLookup filterLookup = this;
            synchronized (filterLookup) {
                if (this.results == null) {
                    this.results = new WeakSet();
                }
                this.results.add(p);
            }
            return p;
        }

        public Object lookup(Class clazz) {
            return this.replaceNodes(this.checkNode().lookup(clazz), clazz);
        }

        private static boolean isNodeQuery(Class c) {
            return (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FilterNode.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node).isAssignableFrom(c) || c.isAssignableFrom(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = FilterNode.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
        }

        public Lookup.Item lookupItem(Lookup.Template template) {
            Lookup.Item i = this.checkNode().lookupItem(template);
            return FilterLookup.isNodeQuery(template.getType()) ? new FilterItem(i, template.getType()) : i;
        }

        private final class FilterItem
        extends Lookup.Item {
            private Lookup.Item delegate;
            private Class clazz;

            FilterItem(Lookup.Item d, Class clazz) {
                this.delegate = d;
                this.clazz = clazz;
            }

            public String getDisplayName() {
                return this.delegate.getDisplayName();
            }

            public String getId() {
                return this.delegate.getId();
            }

            public Object getInstance() {
                return FilterLookup.this.replaceNodes(this.delegate.getInstance(), this.clazz);
            }

            public Class getType() {
                return this.delegate.getType();
            }
        }

        private final class ProxyResult
        extends Lookup.Result
        implements LookupListener {
            private Lookup.Template template;
            private Lookup.Result delegate;
            private EventListenerList listeners;

            ProxyResult(Lookup.Template template) {
                this.template = template;
            }

            private Lookup.Result checkResult() {
                this.updateLookup(FilterLookup.this.checkNode());
                return this.delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean updateLookup(Lookup l) {
                Collection oldPairs = this.delegate != null ? this.delegate.allItems() : null;
                ProxyResult proxyResult = this;
                synchronized (proxyResult) {
                    if (this.delegate != null) {
                        this.delegate.removeLookupListener(this);
                    }
                    this.delegate = l.lookup(this.template);
                    this.delegate.addLookupListener(this);
                }
                if (oldPairs == null) {
                    return false;
                }
                Collection newPairs = this.delegate.allItems();
                return !((Object)oldPairs).equals(newPairs);
            }

            public synchronized void addLookupListener(LookupListener l) {
                if (this.listeners == null) {
                    this.listeners = new EventListenerList();
                }
                this.listeners.add(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = FilterNode.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, l);
            }

            public synchronized void removeLookupListener(LookupListener l) {
                if (this.listeners != null) {
                    this.listeners.remove(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = FilterNode.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, l);
                }
            }

            public Collection allInstances() {
                Collection c = this.checkResult().allInstances();
                if (FilterLookup.isNodeQuery(this.template.getType())) {
                    ArrayList<Object> ll = new ArrayList<Object>(c.size());
                    Iterator it = c.iterator();
                    while (it.hasNext()) {
                        ll.add(FilterLookup.this.replaceNodes(it.next(), this.template.getType()));
                    }
                    return ll;
                }
                return c;
            }

            public Set allClasses() {
                return this.checkResult().allClasses();
            }

            public Collection allItems() {
                return this.checkResult().allItems();
            }

            public void resultChanged(LookupEvent anEvent) {
                EventListenerList l = this.listeners;
                if (l == null) {
                    return;
                }
                Object[] listeners = l.getListenerList();
                if (listeners.length == 0) {
                    return;
                }
                LookupEvent ev = new LookupEvent(this);
                for (int i = listeners.length - 1; i >= 0; i -= 2) {
                    LookupListener ll = (LookupListener)listeners[i];
                    ll.resultChanged(ev);
                }
            }
        }
    }

    private static final class FilterHandle
    implements Node.Handle {
        private Node.Handle original;
        static final long serialVersionUID = 7928908039428333839L;

        public FilterHandle(Node.Handle original) {
            this.original = original;
        }

        public Node getNode() throws IOException {
            return new FilterNode(this.original.getNode());
        }

        public String toString() {
            return "FilterHandle[" + this.original + "]";
        }
    }

    private static class ChildrenAdapter
    implements NodeListener,
    Runnable {
        private WeakReference children;

        public ChildrenAdapter(Children ch) {
            this.children = new WeakReference<Children>(ch);
        }

        public void run() {
            Children ch = (Children)this.children.get();
            if (ch != null) {
                Object[] arr = ch.original.getChildren().getNodes();
                ch.setKeys(arr);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
        }

        public void childrenAdded(NodeMemberEvent ev) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenAdded(ev);
        }

        public void childrenRemoved(NodeMemberEvent ev) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenRemoved(ev);
        }

        public void childrenReordered(NodeReorderEvent ev) {
            Children children = (Children)this.children.get();
            if (children == null) {
                return;
            }
            children.filterChildrenReordered(ev);
        }

        public void nodeDestroyed(NodeEvent ev) {
        }
    }

    public static class Children
    extends Children.Keys
    implements Cloneable {
        protected Node original;
        private ChildrenAdapter nodeL;

        public Children(Node or) {
            this.original = or;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void changeOriginal(Node original) {
            try {
                boolean wasAttached;
                PR.enterWriteAccess();
                boolean bl = wasAttached = this.nodeL != null;
                if (wasAttached) {
                    this.original.removeNodeListener(this.nodeL);
                    this.nodeL = null;
                }
                this.original = original;
                if (wasAttached) {
                    this.addNotifyImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected void finalize() {
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
            }
            this.nodeL = null;
        }

        public Object clone() {
            return new Children(this.original);
        }

        protected void addNotify() {
            this.addNotifyImpl();
        }

        private void addNotifyImpl() {
            this.nodeL = new ChildrenAdapter(this);
            this.original.addNodeListener(this.nodeL);
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
                this.nodeL = null;
            }
        }

        protected Node copyNode(Node node) {
            return node.cloneNode();
        }

        public Node findChild(String name) {
            this.original.getChildren().findChild(name);
            return super.findChild(name);
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            return new Node[]{this.copyNode(n)};
        }

        public boolean add(Node[] arr) {
            return this.original.getChildren().add(arr);
        }

        public boolean remove(Node[] arr) {
            return this.original.getChildren().remove(arr);
        }

        protected void filterChildrenAdded(NodeMemberEvent ev) {
            this.updateKeys();
        }

        protected void filterChildrenRemoved(NodeMemberEvent ev) {
            this.updateKeys();
        }

        protected void filterChildrenReordered(NodeReorderEvent ev) {
            this.updateKeys();
        }

        private void updateKeys() {
            ChildrenAdapter runnable = this.nodeL;
            if (runnable != null) {
                runnable.run();
            }
        }

        public Node[] getNodes(boolean optimalResult) {
            if (optimalResult) {
                this.setKeys(this.original.getChildren().getNodes(true));
            }
            return this.getNodes();
        }
    }

    protected static class NodeAdapter
    implements NodeListener {
        private WeakReference fn;

        public NodeAdapter(FilterNode fn) {
            this.fn = new WeakReference<FilterNode>(fn);
        }

        public final void propertyChange(PropertyChangeEvent ev) {
            FilterNode fn = (FilterNode)this.fn.get();
            if (fn == null) {
                return;
            }
            this.propertyChange(fn, ev);
        }

        protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
            String n = ev.getPropertyName();
            if (n.equals("parentNode")) {
                return;
            }
            if (n.equals("displayName")) {
                fn.fireOwnPropertyChange("displayName", (String)ev.getOldValue(), (String)ev.getNewValue());
                return;
            }
            if (n.equals("name")) {
                fn.fireOwnPropertyChange("name", (String)ev.getOldValue(), (String)ev.getNewValue());
                return;
            }
            if (n.equals("shortDescription")) {
                fn.fireOwnPropertyChange("shortDescription", (String)ev.getOldValue(), (String)ev.getNewValue());
                return;
            }
            if (n.equals("icon")) {
                fn.fireIconChange();
                return;
            }
            if (n.equals("openedIcon")) {
                fn.fireOpenedIconChange();
                return;
            }
            if (n.equals("propertySets")) {
                fn.firePropertySetsChange((Node.PropertySet[])ev.getOldValue(), (Node.PropertySet[])ev.getNewValue());
                return;
            }
            if (n.equals("cookie")) {
                fn.fireCookieChange();
                return;
            }
            if (n.equals("leaf")) {
                fn.updateChildren();
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public final void nodeDestroyed(NodeEvent ev) {
            FilterNode fn = (FilterNode)this.fn.get();
            if (fn == null) {
                return;
            }
            fn.originalDestroyed();
        }
    }

    protected static class PropertyChangeAdapter
    implements PropertyChangeListener {
        private WeakReference fn;

        public PropertyChangeAdapter(FilterNode fn) {
            this.fn = new WeakReference<FilterNode>(fn);
        }

        public final void propertyChange(PropertyChangeEvent ev) {
            FilterNode fn = (FilterNode)this.fn.get();
            if (fn == null) {
                return;
            }
            this.propertyChange(fn, ev);
        }

        protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
            fn.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }
    }

    private static class StackError
    extends StackOverflowError {
        private IdentityHashMap nodes;

        private StackError() {
        }

        public void add(FilterNode n) {
            if (this.nodes == null) {
                this.nodes = new IdentityHashMap();
            }
            if (this.nodes.get(n) == null) {
                this.nodes.put(n, n);
            }
        }

        public String getMessage() {
            StringBuffer sb = new StringBuffer();
            sb.append("StackOver in FilterNodes:\n");
            Iterator it = this.nodes.keySet().iterator();
            while (it.hasNext()) {
                FilterNode f = (FilterNode)it.next();
                sb.append("  class: ");
                sb.append(f.getClass().getName());
                sb.append(" id: ");
                sb.append(Integer.toString(System.identityHashCode(f), 16));
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

