/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.Line;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

final class EditorSupportLineSet
extends DocumentLine.Set {
    private CloneableEditorSupport support;

    public EditorSupportLineSet(CloneableEditorSupport support, StyledDocument doc) {
        super(doc, support);
        this.support = support;
    }

    WeakHashMap findWeakHashMap() {
        return this.support.findWeakHashMap();
    }

    public Line createLine(int offset) {
        StyledDocument doc = this.support.getDocument();
        if (doc == null) {
            return null;
        }
        PositionRef ref = new PositionRef(this.support.getPositionManager(), offset, Position.Bias.Forward);
        return new SupportLine(this.support.getLookup(), ref, this.support);
    }

    static class Closed
    extends Line.Set
    implements ChangeListener {
        private CloneableEditorSupport support;
        private Line.Set delegate;

        public Closed(CloneableEditorSupport support) {
            this.support = support;
            support.addChangeListener(WeakListeners.change(this, support));
        }

        WeakHashMap findWeakHashMap() {
            return this.support.findWeakHashMap();
        }

        public List getLines() {
            if (this.delegate != null) {
                return this.delegate.getLines();
            }
            return new ArrayList();
        }

        public Line getOriginal(int line) throws IndexOutOfBoundsException {
            if (this.delegate != null) {
                return this.delegate.getOriginal(line);
            }
            return this.getCurrent(line);
        }

        public Line getCurrent(int line) throws IndexOutOfBoundsException {
            PositionRef ref = new PositionRef(this.support.getPositionManager(), line, 0, Position.Bias.Forward);
            Lookup obj = this.support.getLookup();
            return this.registerLine(new SupportLine(obj, ref, this.support));
        }

        public synchronized void stateChanged(ChangeEvent ev) {
            if (this.delegate == null) {
                StyledDocument doc = this.support.getDocument();
                if (doc != null) {
                    this.delegate = new EditorSupportLineSet(this.support, doc);
                }
            } else if (this.support.getDocument() == null) {
                this.delegate = null;
            }
        }
    }

    private static final class SupportLine
    extends DocumentLine {
        static final long serialVersionUID = 7282223299866986051L;

        public SupportLine(Lookup obj, PositionRef ref, CloneableEditorSupport support) {
            super(obj, ref);
        }

        public void show(int kind, int column) {
            CloneableEditorSupport support = this.pos.getCloneableEditorSupport();
            if (kind == 0 && !support.isDocumentLoaded()) {
                return;
            }
            CloneableEditorSupport.Pane editor = support.openAt(this.pos, column);
            if (kind == 2) {
                editor.getComponent().requestActive();
            }
        }

        public Line.Part createPart(int column, int length) {
            DocumentLine.Part part = new DocumentLine.Part(this, new PositionRef(this.pos.getCloneableEditorSupport().getPositionManager(), this.pos.getOffset() + column, Position.Bias.Forward), length);
            this.addLinePart(part);
            return part;
        }

        public String getDisplayName() {
            CloneableEditorSupport support = this.pos.getCloneableEditorSupport();
            return support.messageLine(this);
        }

        public String toString() {
            return "SupportLine@" + Integer.toHexString(System.identityHashCode(this)) + " at line: " + this.getLineNumber();
        }
    }
}

