/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class MoveUpAction
extends NodeAction {
    private static final String PROP_ORDER_LISTENER = "sellistener";
    private Reference curIndexCookie;
    private static ErrorManager err = null;
    private static boolean errInited = false;

    private static final void initErr() {
        if (!errInited) {
            errInited = true;
            ErrorManager master = ErrorManager.getDefault();
            ErrorManager tmp = master.getInstance("org.openide.actions.MoveUpAction");
            if (tmp.isLoggable(1)) {
                err = tmp;
            }
        }
    }

    protected void initialize() {
        MoveUpAction.initErr();
        if (err != null) {
            err.log(1, "initialize");
        }
        super.initialize();
        OrderingListener sl = new OrderingListener();
        this.putProperty(PROP_ORDER_LISTENER, sl);
    }

    private Index getCurIndexCookie() {
        return this.curIndexCookie == null ? null : (Index)this.curIndexCookie.get();
    }

    protected void performAction(Node[] activatedNodes) {
        Index cookie = this.getIndexCookie(activatedNodes);
        if (cookie == null) {
            return;
        }
        int nodeIndex = cookie.indexOf(activatedNodes[0]);
        if (nodeIndex > 0) {
            cookie.moveUp(nodeIndex);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        Index idx;
        MoveUpAction.initErr();
        if (err != null) {
            err.log(1, "enable; activatedNodes=" + (activatedNodes == null ? null : Arrays.asList(activatedNodes)));
        }
        if ((idx = this.getCurIndexCookie()) != null) {
            idx.removeChangeListener((ChangeListener)this.getProperty(PROP_ORDER_LISTENER));
        }
        Index cookie = this.getIndexCookie(activatedNodes);
        if (err != null) {
            err.log(1, "enable; cookie=" + cookie);
        }
        if (cookie == null) {
            return false;
        }
        cookie.addChangeListener((OrderingListener)this.getProperty(PROP_ORDER_LISTENER));
        this.curIndexCookie = new WeakReference<Index>(cookie);
        int index = cookie.indexOf(activatedNodes[0]);
        if (err != null) {
            err.log(1, "enable; index=" + index);
            if (index == -1) {
                Node parent = activatedNodes[0].getParentNode();
                err.log(1, "enable; parent=" + parent + "; parent.children=" + Arrays.asList(parent.getChildren().getNodes()));
            }
        }
        return index > 0;
    }

    public String getName() {
        return NbBundle.getMessage(MoveUpAction.class, "MoveUp");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveUpAction.class);
    }

    private Index getIndexCookie(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return null;
        }
        Node parent = activatedNodes[0].getParentNode();
        if (parent == null) {
            return null;
        }
        return (Index)parent.getCookie(Index.class);
    }

    private final class OrderingListener
    implements ChangeListener {
        OrderingListener() {
        }

        public void stateChanged(ChangeEvent e) {
            MoveUpAction.initErr();
            Node[] activatedNodes = MoveUpAction.this.getActivatedNodes();
            if (err != null) {
                err.log(1, "stateChanged; activatedNodes=" + (activatedNodes == null ? null : Arrays.asList(activatedNodes)));
            }
            Index cookie = MoveUpAction.this.getIndexCookie(activatedNodes);
            if (err != null) {
                err.log(1, "stateChanged; cookie=" + cookie);
            }
            if (cookie == null) {
                MoveUpAction.this.setEnabled(false);
            } else {
                int index = cookie.indexOf(activatedNodes[0]);
                if (err != null) {
                    err.log(1, "stateChanged; index=" + index);
                }
                MoveUpAction.this.setEnabled(index > 0);
            }
        }
    }
}

