/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotUndoException;
import org.openide.ErrorManager;
import org.openide.actions.RedoAction;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class UndoAction
extends CallableSystemAction {
    private static Listener listener;
    private static UndoRedo last;
    private static String SWING_DEFAULT_LABEL;
    private static UndoAction undoAction;
    private static RedoAction redoAction;

    public boolean isEnabled() {
        UndoAction.initializeUndoRedo();
        return super.isEnabled();
    }

    static synchronized void initializeUndoRedo() {
        if (listener != null) {
            return;
        }
        listener = new Listener();
        TopComponent.Registry r = WindowManager.getDefault().getRegistry();
        r.addPropertyChangeListener(WeakListeners.propertyChange(listener, r));
        last = UndoAction.getUndoRedo();
        last.addChangeListener(listener);
        UndoAction.updateStatus();
    }

    static synchronized void updateStatus() {
        if (undoAction == null) {
            undoAction = (UndoAction)UndoAction.findObject(UndoAction.class, false);
        }
        if (redoAction == null) {
            redoAction = (RedoAction)UndoAction.findObject(RedoAction.class, false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UndoRedo ur = UndoAction.getUndoRedo();
                if (undoAction != null) {
                    undoAction.setEnabled(ur.canUndo());
                }
                if (redoAction != null) {
                    redoAction.setEnabled(ur.canRedo());
                }
            }
        });
    }

    static UndoRedo getUndoRedo() {
        TopComponent el = WindowManager.getDefault().getRegistry().getActivated();
        return el == null ? UndoRedo.NONE : el.getUndoRedo();
    }

    public String getName() {
        String undo = UndoAction.getUndoRedo().getUndoPresentationName();
        if (undo != null && SWING_DEFAULT_LABEL != null && undo.startsWith(SWING_DEFAULT_LABEL)) {
            undo = undo.substring(0, SWING_DEFAULT_LABEL.length()).trim();
        }
        return NbBundle.getMessage(UndoAction.class, "Undo", undo);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UndoAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/undo.gif";
    }

    public void performAction() {
        try {
            UndoRedo undoRedo = UndoAction.getUndoRedo();
            if (undoRedo.canUndo()) {
                undoRedo.undo();
            }
        }
        catch (CannotUndoException ex) {
            ErrorManager.getDefault().notify(ex);
        }
        UndoAction.updateStatus();
    }

    protected boolean asynchronous() {
        return false;
    }

    static {
        last = UndoRedo.NONE;
        SWING_DEFAULT_LABEL = UIManager.getString("AbstractUndoableEdit.undoText");
        undoAction = null;
        redoAction = null;
    }

    private static final class Listener
    implements PropertyChangeListener,
    ChangeListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            UndoAction.updateStatus();
            last.removeChangeListener(this);
            last = UndoAction.getUndoRedo();
            last.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent ev) {
            UndoAction.updateStatus();
        }
    }
}

