/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Keymap;
import org.openide.ErrorManager;
import org.openide.awt.JMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public class Actions {
    private static Icon BLANK_ICON = null;
    private static Map menuActionCache;
    private static Object menuActionLock;
    private static RGBImageFilter DISABLED_BUTTON_FILTER;

    private static Icon nonNullIcon(Icon i) {
        if (i != null) {
            return i;
        }
        if (BLANK_ICON == null) {
            BLANK_ICON = new ImageIcon(Utilities.loadImage("org/openide/resources/actions/empty.gif", true));
        }
        return BLANK_ICON;
    }

    public static String findKey(SystemAction action) {
        return Actions.findKey((Action)action);
    }

    private static String findKey(Action action) {
        if (action == null) {
            return null;
        }
        KeyStroke accelerator = (KeyStroke)action.getValue("AcceleratorKey");
        if (accelerator == null) {
            return null;
        }
        int modifiers = accelerator.getModifiers();
        String acceleratorText = "";
        if (modifiers > 0) {
            acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
            acceleratorText = acceleratorText + "+";
        } else if (accelerator.getKeyCode() == 0) {
            return "";
        }
        acceleratorText = acceleratorText + KeyEvent.getKeyText(accelerator.getKeyCode());
        return acceleratorText;
    }

    public static void connect(JMenuItem item, SystemAction action, boolean popup) {
        Actions.connect(item, (Action)action, popup);
    }

    public static void connect(JMenuItem item, Action action, boolean popup) {
        MenuBridge b = new MenuBridge(item, action, popup);
        ((Bridge)b).updateState(null);
        if (!popup) {
            Actions.setMenuActionConnection(item, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMenuActionConnection(JMenuItem menu, Action action) {
        Object object = menuActionLock;
        synchronized (object) {
            if (menuActionCache == null) {
                menuActionCache = new WeakHashMap();
                Keymap map = (Keymap)Lookup.getDefault().lookup(Keymap.class);
                if (map instanceof Observable) {
                    ((Observable)((Object)map)).addObserver(new Observer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void update(Observable o, Object arg) {
                            Object object = menuActionLock;
                            synchronized (object) {
                                Iterator it = menuActionCache.entrySet().iterator();
                                while (it.hasNext()) {
                                    Map.Entry entry = it.next();
                                    Action act = (Action)entry.getKey();
                                    WeakReference ref = (WeakReference)entry.getValue();
                                    JMenuItem mn = (JMenuItem)ref.get();
                                    if (act == null || mn == null) continue;
                                    KeyStroke actKey = (KeyStroke)act.getValue("AcceleratorKey");
                                    KeyStroke mnKey = mn.getAccelerator();
                                    if (!(mnKey == null && actKey != null || mnKey != null && actKey == null) && (mnKey == null || actKey == null || actKey.equals(mnKey))) continue;
                                    mn.setAccelerator(actKey);
                                }
                            }
                        }
                    });
                } else {
                    ErrorManager.getDefault().getInstance(Actions.class.getName()).log("Keymap is not observable, behaviour described in bug #39508 can reappear.");
                }
            }
            menuActionCache.put(action, new WeakReference<JMenuItem>(menu));
        }
    }

    public static void connect(JCheckBoxMenuItem item, BooleanStateAction action, boolean popup) {
        CheckMenuBridge b = new CheckMenuBridge(item, action, popup);
        ((Bridge)b).updateState(null);
    }

    public static void connect(AbstractButton button, SystemAction action) {
        Actions.connect(button, (Action)action);
    }

    public static void connect(AbstractButton button, Action action) {
        ButtonBridge b = new ButtonBridge(button, action);
        ((Bridge)b).updateState(null);
    }

    public static void connect(AbstractButton button, BooleanStateAction action) {
        BooleanButtonBridge b = new BooleanButtonBridge(button, action);
        ((Bridge)b).updateState(null);
    }

    public static void setMenuText(AbstractButton item, String text, boolean useMnemonic) {
        if (useMnemonic) {
            Mnemonics.setLocalizedText(item, text);
        } else {
            item.setText(Actions.cutAmpersand(text));
        }
    }

    public static String cutAmpersand(String text) {
        String result = text;
        int i = text.indexOf("(&");
        result = i >= 0 && i + 3 < text.length() && text.charAt(i + 3) == ')' ? text.substring(0, i) + text.substring(i + 4) : ((i = text.indexOf(38)) < 0 ? text : (i == text.length() - 1 ? text.substring(0, i) : (" ".equals(text.substring(i + 1, i + 2)) ? text : text.substring(0, i) + text.substring(i + 1))));
        return result;
    }

    private static HelpCtx findHelp(Action a) {
        if (a instanceof HelpCtx.Provider) {
            return ((HelpCtx.Provider)((Object)a)).getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    static void prepareMenuBridgeItemsInContainer(Container c) {
        Component[] comps = c.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JComponent cop;
            MenuBridge bridge;
            if (!(comps[i] instanceof JComponent) || (bridge = (MenuBridge)(cop = (JComponent)comps[i]).getClientProperty("menubridgeresizehack")) == null) continue;
            bridge.updateState(null);
        }
    }

    static void prepareMargins(JMenuItem item, Action action) {
        item.setHorizontalTextPosition(4);
        item.setHorizontalAlignment(2);
    }

    static void updateKey(JMenuItem item, Action action) {
        if (item instanceof SubMenu || !(item instanceof JMenu)) {
            if (item instanceof SubMenu && !((SubMenu)item).useAccel()) {
                item.setAccelerator(null);
            } else {
                item.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
            }
        }
    }

    private static Icon createDisabledIcon(Image img) {
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), Actions.disabledButtonFilter());
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
    }

    private static RGBImageFilter disabledButtonFilter() {
        if (DISABLED_BUTTON_FILTER == null) {
            DISABLED_BUTTON_FILTER = new DisabledButtonFilter();
        }
        return DISABLED_BUTTON_FILTER;
    }

    static {
        menuActionLock = new Object();
    }

    private static class DisabledButtonFilter
    extends RGBImageFilter {
        DisabledButtonFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return (rgb & 0xFF000000) + 0x888888 + ((rgb >> 16 & 0xFF) >> 2 << 16) + ((rgb >> 8 & 0xFF) >> 2 << 8) + ((rgb & 0xFF) >> 2);
        }
    }

    public static class SubMenu
    extends JMenuPlus {
        int previousCount = -1;
        ActionListener oneItemListener;
        private KeyStroke accelerator;
        private SubMenuModel subModel;
        private SubMenuBridge bridge;
        static final long serialVersionUID = -4446966671302959091L;

        public SubMenu(SystemAction aAction, SubMenuModel model) {
            this(aAction, model, true);
        }

        public SubMenu(SystemAction aAction, SubMenuModel model, boolean popup) {
            this((Action)aAction, model, popup);
        }

        public SubMenu(Action aAction, SubMenuModel model, boolean popup) {
            this.subModel = model;
            this.bridge = new SubMenuBridge(this, aAction, model, popup);
            this.bridge.updateState("Name");
        }

        public void addNotify() {
            super.addNotify();
            this.bridge.updateState(null);
            if (this.subModel.getCount() == 0) {
                this.setEnabled(false);
            }
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            Component[] cs;
            if (ks.equals(this.accelerator) && (cs = this.getMenuComponents()).length > 0 && cs[0] instanceof JComponent) {
                Action action;
                JComponent comp = (JComponent)cs[0];
                ActionMap am = comp.getActionMap();
                if (am != null && comp.isEnabled() && (action = am.get("doClick")) != null) {
                    return SwingUtilities.notifyAction(action, ks, e, comp, e.getModifiers());
                }
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager m) {
            ActionListener ac;
            if (this.getMenuComponentCount() <= 1 && Arrays.equals(path, MenuSelectionManager.defaultManager().getSelectedPath()) && (e.getKeyCode() == 10 || e.getKeyCode() == 32) && (ac = this.oneItemListener) != null) {
                m.setSelectedPath(new MenuElement[0]);
                ac.actionPerformed(new ActionEvent(e.getSource(), 0, null));
                return;
            }
            super.processKeyEvent(e, path, m);
        }

        public String getUIClassID() {
            if (this.previousCount == 0) {
                return "MenuItemUI";
            }
            return this.previousCount == 1 ? "MenuItemUI" : "MenuUI";
        }

        boolean useAccel() {
            return this.subModel.getCount() <= 1;
        }

        public void setAccelerator(KeyStroke keyStroke) {
            KeyStroke oldAccelerator = this.accelerator;
            this.accelerator = keyStroke;
            this.firePropertyChange("accelerator", oldAccelerator, this.accelerator);
        }

        public KeyStroke getAccelerator() {
            return this.accelerator;
        }

        public void menuSelectionChanged(boolean isIncluded) {
            if (this.previousCount <= 1) {
                this.setArmed(isIncluded);
            } else {
                super.menuSelectionChanged(isIncluded);
            }
        }

        public void setSelected(boolean s) {
            if (this.isEnabled() || !s) {
                super.setSelected(s);
            }
        }

        public void setEnabled(boolean e) {
            super.setEnabled(e);
            if (!e) {
                super.setSelected(false);
            }
        }

        public void doClick(int pressTime) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.oneItemListener != null) {
                this.oneItemListener.actionPerformed(null);
            } else {
                super.doClick(pressTime);
            }
        }
    }

    public static interface SubMenuModel {
        public int getCount();

        public String getLabel(int var1);

        public HelpCtx getHelpCtx(int var1);

        public void performActionAt(int var1);

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    public static class ToolbarToggleButton
    extends org.openide.awt.ToolbarToggleButton {
        static final long serialVersionUID = -4783163952526348942L;

        public ToolbarToggleButton(BooleanStateAction aAction) {
            super((Icon)null, false);
            Actions.connect((AbstractButton)this, aAction);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class ToolbarButton
    extends org.openide.awt.ToolbarButton {
        static final long serialVersionUID = 6564434578524381134L;

        public ToolbarButton(SystemAction aAction) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, aAction);
        }

        public ToolbarButton(Action aAction) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, aAction);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class CheckboxMenuItem
    extends JCheckBoxMenuItem {
        static final long serialVersionUID = 6190621106981774043L;

        public CheckboxMenuItem(BooleanStateAction aAction, boolean useMnemonic) {
            Actions.connect(this, aAction, !useMnemonic);
        }
    }

    public static class MenuItem
    extends JMenuItem {
        static final long serialVersionUID = -21757335363267194L;

        public MenuItem(SystemAction aAction, boolean useMnemonic) {
            Actions.connect((JMenuItem)this, aAction, !useMnemonic);
        }

        public MenuItem(Action aAction, boolean useMnemonic) {
            Actions.connect((JMenuItem)this, aAction, !useMnemonic);
        }
    }

    private static final class SubMenuBridge
    extends MenuBridge
    implements ChangeListener {
        private SubMenuModel model;
        private SubMenu menu;

        public SubMenuBridge(SubMenu item, Action action, SubMenuModel model, boolean popup) {
            super(item, action, popup);
            Actions.prepareMargins(item, action);
            this.menu = item;
            this.model = model;
        }

        public void addNotify() {
            super.addNotify();
            this.model.addChangeListener(this);
            this.generateSubMenu();
        }

        public void removeNotify() {
            this.model.removeChangeListener(this);
            super.removeNotify();
        }

        public void stateChanged(ChangeEvent ev) {
            if (!EventQueue.isDispatchThread()) {
                new IllegalStateException("This must happen in the event thread!").printStackTrace();
            }
            this.generateSubMenu();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateSubMenu() {
            boolean shouldUpdate = false;
            try {
                this.menu.removeAll();
                int cnt = this.model.getCount();
                if (cnt != this.menu.previousCount) {
                    shouldUpdate = true;
                }
                this.menu.previousCount = cnt;
                if (this.menu.oneItemListener != null) {
                    this.menu.removeActionListener(this.menu.oneItemListener);
                }
                if (cnt == 0) {
                    this.menu.setEnabled(false);
                    if (this.menu.oneItemListener != null) {
                        this.menu.removeActionListener(this.menu.oneItemListener);
                        this.menu.oneItemListener = null;
                    }
                    return;
                }
                this.menu.setEnabled(true);
                if (cnt == 1) {
                    this.menu.oneItemListener = new ISubActionListener(0, this.model);
                    this.menu.addActionListener(this.menu.oneItemListener);
                    HelpCtx help = this.model.getHelpCtx(0);
                    this.associateHelp(this.menu, help == null ? Actions.findHelp(this.action) : help);
                } else {
                    boolean addSeparator = false;
                    int count = this.model.getCount();
                    for (int i = 0; i < count; ++i) {
                        String label = this.model.getLabel(i);
                        if (label == null) {
                            addSeparator = this.menu.getItemCount() > 0;
                            continue;
                        }
                        if (addSeparator) {
                            this.menu.addSeparator();
                            addSeparator = false;
                        }
                        JMenuItem item = new JMenuItem();
                        Mnemonics.setLocalizedText(item, label);
                        if (i == 0) {
                            Actions.updateKey(item, this.action);
                        }
                        item.addActionListener(new ISubActionListener(i, this.model));
                        HelpCtx help = this.model.getHelpCtx(i);
                        this.associateHelp(item, help == null ? Actions.findHelp(this.action) : help);
                        this.menu.add(item);
                    }
                    this.associateHelp(this.menu, Actions.findHelp(this.action));
                }
            }
            finally {
                if (shouldUpdate) {
                    this.menu.updateUI();
                }
            }
        }

        private void associateHelp(JComponent comp, HelpCtx help) {
            if (help != null && !help.equals(HelpCtx.DEFAULT_HELP) && help.getHelpID() != null) {
                HelpCtx.setHelpIDString(comp, help.getHelpID());
            } else {
                HelpCtx.setHelpIDString(comp, null);
            }
        }

        private static class ISubActionListener
        implements ActionListener {
            int index;
            SubMenuModel support;

            public ISubActionListener(int index, SubMenuModel support) {
                this.index = index;
                this.support = support;
            }

            public void actionPerformed(ActionEvent e) {
                this.support.performActionAt(this.index);
            }
        }
    }

    private static final class CheckMenuBridge
    extends BooleanButtonBridge {
        private boolean popup;
        private boolean hasOwnIcon = false;

        public CheckMenuBridge(JCheckBoxMenuItem item, BooleanStateAction action, boolean popup) {
            super((AbstractButton)item, action);
            this.popup = popup;
            if (popup) {
                Actions.prepareMargins(item, action);
            }
            Object base = action.getValue("iconBase");
            Object i = null;
            i = action instanceof SystemAction ? action.getValue("icon") : action.getValue("SmallIcon");
            this.hasOwnIcon = base != null || i != null;
        }

        public void updateState(String changedProperty) {
            Object s;
            super.updateState(changedProperty);
            if (changedProperty == null || !changedProperty.equals("AcceleratorKey")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if ((changedProperty == null || changedProperty.equals("Name")) && (s = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)s, !this.popup);
            }
        }

        protected void updateButtonIcon() {
            if (this.hasOwnIcon) {
                super.updateButtonIcon();
                return;
            }
            if (!this.popup) {
                this.button.setIcon(new ImageIcon(Utilities.loadImage("org/openide/resources/actions/gap.gif", true)));
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class MenuBridge
    extends ButtonBridge {
        private boolean popup;

        public MenuBridge(JMenuItem item, Action action, boolean popup) {
            super(item, action);
            this.popup = popup;
            if (popup) {
                Actions.prepareMargins(item, action);
            } else {
                item.putClientProperty("menubridgeresizehack", this);
            }
        }

        public void updateState(String changedProperty) {
            Object s;
            if (changedProperty == null || changedProperty.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (changedProperty == null || !changedProperty.equals("AcceleratorKey")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if (!this.popup && (changedProperty == null || changedProperty.equals("icon") || changedProperty.equals("SmallIcon") || changedProperty.equals("iconBase"))) {
                this.updateButtonIcon();
            }
            if ((changedProperty == null || changedProperty.equals("Name")) && (s = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)s, !this.popup);
            }
        }

        protected void updateButtonIcon() {
            Object i = null;
            Object obj = this.action.getValue("noIconInMenu");
            if (Boolean.TRUE.equals(obj)) {
                this.button.setIcon(Actions.nonNullIcon(null));
                return;
            }
            if (this.action instanceof SystemAction) {
                SystemAction sa = (SystemAction)this.action;
                i = sa.getIcon(this.useTextIcons());
                this.button.setIcon((Icon)i);
                if (i instanceof ImageIcon) {
                    this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)i).getImage()));
                }
            } else {
                i = this.action.getValue("SmallIcon");
                if (i instanceof Icon) {
                    this.button.setIcon((Icon)i);
                    if (i instanceof ImageIcon) {
                        this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)i).getImage()));
                    }
                } else {
                    this.button.setIcon(Actions.nonNullIcon(null));
                }
            }
            Object base = this.action.getValue("iconBase");
            if (base instanceof String) {
                Image dImg;
                Image rImg;
                Image pImg;
                String b = (String)base;
                Image img = null;
                if (i == null && (img = Utilities.loadImage(b, true)) != null) {
                    this.button.setIcon(new ImageIcon(img));
                    this.button.setDisabledIcon(Actions.createDisabledIcon(img));
                }
                if ((pImg = Utilities.loadImage(MenuBridge.insertBeforeSuffix(b, "_pressed"), true)) != null) {
                    this.button.setPressedIcon(new ImageIcon(pImg));
                }
                if ((rImg = Utilities.loadImage(MenuBridge.insertBeforeSuffix(b, "_rollover"), true)) != null) {
                    this.button.setRolloverIcon(new ImageIcon(rImg));
                }
                if ((dImg = Utilities.loadImage(MenuBridge.insertBeforeSuffix(b, "_disabled"), true)) != null) {
                    this.button.setDisabledIcon(new ImageIcon(dImg));
                } else if (img != null) {
                    this.button.setDisabledIcon(Actions.createDisabledIcon(img));
                }
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class BooleanButtonBridge
    extends ButtonBridge {
        public BooleanButtonBridge(AbstractButton button, BooleanStateAction action) {
            super(button, (Action)action);
        }

        public void updateState(String changedProperty) {
            super.updateState(changedProperty);
            if (changedProperty == null || changedProperty.equals("booleanState")) {
                this.button.setSelected(((BooleanStateAction)this.action).getBooleanState());
            }
        }
    }

    private static class ButtonBridge
    extends Bridge {
        protected AbstractButton button;

        public ButtonBridge(AbstractButton button, Action action) {
            super(button, action);
            button.addActionListener(action);
            this.button = button;
        }

        protected void updateButtonIcon() {
            Image img;
            String b;
            Object i = null;
            Object base = this.action.getValue("iconBase");
            boolean useSmallIcon = true;
            Object prop = this.button.getClientProperty("PreferredIconSize");
            if (prop instanceof Integer && (Integer)prop == 24) {
                useSmallIcon = false;
            }
            if (this.action instanceof SystemAction) {
                if (base instanceof String) {
                    b = (String)base;
                    img = null;
                    if (!useSmallIcon) {
                        img = Utilities.loadImage(ButtonBridge.insertBeforeSuffix(b, "24"), true);
                        if (img == null) {
                            img = Utilities.loadImage(b, true);
                        }
                    } else {
                        img = Utilities.loadImage(b, true);
                    }
                    if (img != null) {
                        i = new ImageIcon(img);
                        this.button.setIcon((Icon)i);
                        this.button.setDisabledIcon(Actions.createDisabledIcon(img));
                    } else {
                        SystemAction sa = (SystemAction)this.action;
                        i = sa.getIcon(this.useTextIcons());
                        this.button.setIcon((Icon)i);
                        if (i instanceof ImageIcon) {
                            this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)i).getImage()));
                        }
                    }
                } else {
                    SystemAction sa = (SystemAction)this.action;
                    i = sa.getIcon(this.useTextIcons());
                    this.button.setIcon((Icon)i);
                    if (i instanceof ImageIcon) {
                        this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)i).getImage()));
                    }
                }
            } else if (base instanceof String) {
                b = (String)base;
                img = null;
                if (!useSmallIcon) {
                    img = Utilities.loadImage(ButtonBridge.insertBeforeSuffix(b, "24"), true);
                    if (img == null) {
                        img = Utilities.loadImage(b, true);
                    }
                } else {
                    img = Utilities.loadImage(b, true);
                }
                if (img != null) {
                    i = new ImageIcon(img);
                    this.button.setIcon((Icon)i);
                    this.button.setDisabledIcon(Actions.createDisabledIcon(img));
                } else {
                    i = this.action.getValue("SmallIcon");
                    if (i instanceof Icon) {
                        this.button.setIcon((Icon)i);
                        if (i instanceof ImageIcon) {
                            this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)i).getImage()));
                        }
                    } else {
                        this.button.setIcon(Actions.nonNullIcon(null));
                    }
                }
            } else {
                i = this.action.getValue("SmallIcon");
                if (i instanceof Icon) {
                    this.button.setIcon((Icon)i);
                    if (i instanceof ImageIcon) {
                        this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)i).getImage()));
                    }
                } else {
                    this.button.setIcon(Actions.nonNullIcon(null));
                }
            }
            if (base instanceof String) {
                Image dImg;
                Image rImg;
                Image pImg;
                b = (String)base;
                if (!useSmallIcon) {
                    b = ButtonBridge.insertBeforeSuffix(b, "24");
                }
                img = null;
                if (i == null) {
                    img = Utilities.loadImage(b, true);
                    if (img != null) {
                        this.button.setIcon(new ImageIcon(img));
                    }
                    i = img;
                }
                if ((pImg = Utilities.loadImage(ButtonBridge.insertBeforeSuffix(b, "_pressed"), true)) != null) {
                    this.button.setPressedIcon(new ImageIcon(pImg));
                }
                if ((rImg = Utilities.loadImage(ButtonBridge.insertBeforeSuffix(b, "_rollover"), true)) != null) {
                    this.button.setRolloverIcon(new ImageIcon(rImg));
                }
                if ((dImg = Utilities.loadImage(ButtonBridge.insertBeforeSuffix(b, "_disabled"), true)) != null) {
                    this.button.setDisabledIcon(new ImageIcon(dImg));
                } else if (img != null) {
                    this.button.setDisabledIcon(Actions.createDisabledIcon(img));
                }
            }
        }

        static String insertBeforeSuffix(String path, String toInsert) {
            String withoutSuffix = path;
            String suffix = "";
            if (path.lastIndexOf(46) >= 0) {
                withoutSuffix = path.substring(0, path.lastIndexOf(46));
                suffix = path.substring(path.lastIndexOf(46), path.length());
            }
            return withoutSuffix + toInsert + suffix;
        }

        public void updateState(String changedProperty) {
            String shortDesc;
            boolean didToolTip = false;
            if (changedProperty == null || changedProperty.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (changedProperty == null || changedProperty.equals("icon") || changedProperty.equals("SmallIcon") || changedProperty.equals("iconBase")) {
                this.updateButtonIcon();
            }
            if ((changedProperty == null || changedProperty.equals("ShortDescription")) && (shortDesc = (String)this.action.getValue("ShortDescription")) != null && !shortDesc.equals(this.action.getValue("Name"))) {
                this.button.setToolTipText(shortDesc);
                didToolTip = true;
            }
            if (!didToolTip && (changedProperty == null || changedProperty.equals("AcceleratorKey") || changedProperty.equals("Name"))) {
                String an;
                String tip = Actions.findKey(this.action);
                String nm = (String)this.action.getValue("Name");
                String string = an = nm == null ? "" : Actions.cutAmpersand(nm);
                if (tip == null || tip.equals("")) {
                    this.button.setToolTipText(an);
                } else {
                    this.button.setToolTipText(NbBundle.getMessage(class$org$openide$awt$Actions == null ? (class$org$openide$awt$Actions = Actions.class$("org.openide.awt.Actions")) : class$org$openide$awt$Actions, "FMT_ButtonHint", an, tip));
                }
            }
            if (this.button instanceof Accessible && (changedProperty == null || changedProperty.equals("Name"))) {
                this.button.getAccessibleContext().setAccessibleName((String)this.action.getValue("Name"));
            }
        }

        protected boolean useTextIcons() {
            return true;
        }
    }

    private static abstract class Bridge
    implements PropertyChangeListener {
        protected JComponent comp;
        protected Action action;

        public Bridge(JComponent comp, Action action) {
            HelpCtx help;
            this.comp = comp;
            this.action = action;
            this.comp.addPropertyChangeListener(new VisL());
            if (this.comp.isShowing()) {
                this.addNotify();
            }
            if ((help = Actions.findHelp(action)) != null && !help.equals(HelpCtx.DEFAULT_HELP) && help.getHelpID() != null) {
                HelpCtx.setHelpIDString(comp, help.getHelpID());
            }
        }

        public void addNotify() {
            this.action.addPropertyChangeListener(this);
            this.updateState(null);
        }

        public void removeNotify() {
            this.action.removePropertyChangeListener(this);
        }

        public abstract void updateState(String var1);

        public void propertyChange(PropertyChangeEvent ev) {
            if (!EventQueue.isDispatchThread()) {
                new IllegalStateException("This must happen in the event thread!").printStackTrace();
            }
            this.updateState(ev.getPropertyName());
        }

        private class VisL
        implements PropertyChangeListener {
            VisL() {
            }

            public void propertyChange(PropertyChangeEvent ev) {
                if ("ancestor".equals(ev.getPropertyName())) {
                    if (ev.getNewValue() != null) {
                        Bridge.this.addNotify();
                    } else {
                        Bridge.this.removeNotify();
                    }
                }
            }
        }
    }
}

