/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import org.openide.ErrorManager;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.HtmlRendererImpl;

class HtmlLabelUI
extends LabelUI {
    private static final boolean antialias;
    private static HtmlLabelUI uiInstance;
    private static int FIXED_HEIGHT;
    private static Map hintsMap;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    private static Boolean gtkAA;
    static final /* synthetic */ boolean $assertionsDisabled;

    HtmlLabelUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        if (!$assertionsDisabled && !(c instanceof HtmlRendererImpl)) {
            throw new AssertionError();
        }
        if (uiInstance == null) {
            uiInstance = new HtmlLabelUI();
        }
        return uiInstance;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.calcPreferredSize((HtmlRendererImpl)c);
    }

    private static int textWidth(String text, Graphics g, Font f, boolean html) {
        if (text != null) {
            if (html) {
                return Math.round(Math.round(Math.ceil(HtmlRenderer.renderHTML(text, g, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, f, Color.BLACK, 0, false))));
            }
            return Math.round(Math.round(Math.ceil(HtmlRenderer.renderPlainString(text, g, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, f, Color.BLACK, 0, false))));
        }
        return 0;
    }

    private Dimension calcPreferredSize(HtmlRendererImpl r) {
        Insets ins = r.getInsets();
        Dimension prefSize = new Dimension(ins.left + ins.right, ins.top + ins.bottom);
        String text = r.getText();
        Graphics g = r.getGraphics();
        Icon icon = r.getIcon();
        if (text != null) {
            FontMetrics fm = g.getFontMetrics(r.getFont());
            prefSize.height += fm.getMaxAscent() + fm.getMaxDescent();
        }
        if (icon != null) {
            if (r.isCentered()) {
                prefSize.height += icon.getIconHeight() + r.getIconTextGap();
                prefSize.width += icon.getIconWidth();
            } else {
                prefSize.height = Math.max(icon.getIconHeight() + ins.top + ins.bottom, prefSize.height);
                prefSize.width += icon.getIconWidth() + r.getIconTextGap();
            }
        }
        if (antialias) {
            ((Graphics2D)g).addRenderingHints(HtmlLabelUI.getHints());
        }
        int textwidth = HtmlLabelUI.textWidth(text, g, r.getFont(), r.isHtml()) + 4;
        prefSize.width = r.isCentered() ? Math.max(prefSize.width, textwidth + ins.right + ins.left) : (prefSize.width += textwidth + r.getIndent());
        if (FIXED_HEIGHT > 0) {
            prefSize.height = FIXED_HEIGHT;
        }
        return prefSize;
    }

    static final Map getHints() {
        if (hintsMap == null) {
            hintsMap = new HashMap();
            hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    public void update(Graphics g, JComponent c) {
        Color bg = HtmlLabelUI.getBackgroundFor((HtmlRendererImpl)c);
        HtmlRendererImpl h = (HtmlRendererImpl)c;
        if (bg != null) {
            int x = h.isSelected() ? (h.getIcon() == null ? 0 : h.getIcon().getIconWidth() + h.getIconTextGap()) : 0;
            g.setColor(bg);
            g.fillRect(x += h.getIndent(), 0, c.getWidth() - x, c.getHeight());
        }
        if (h.isLeadSelection()) {
            Color focus = UIManager.getColor("Tree.selectionBorderColor");
            if (focus == null || focus.equals(bg)) {
                focus = Color.BLUE;
            }
            int x = h.getIcon() == null ? 0 : h.getIcon().getIconWidth() + h.getIconTextGap();
            g.setColor(focus);
            g.drawRect(x, 0, c.getWidth() - (x + 1), c.getHeight() - 1);
        }
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        HtmlRendererImpl r;
        if (antialias) {
            ((Graphics2D)g).addRenderingHints(HtmlLabelUI.getHints());
        }
        if ((r = (HtmlRendererImpl)c).isCentered()) {
            this.paintIconAndTextCentered(g, r);
        } else {
            this.paintIconAndText(g, r);
        }
    }

    private void paintIconAndText(Graphics g, HtmlRendererImpl r) {
        Font f = r.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        int txtH = fm.getHeight();
        Insets ins = r.getInsets();
        int availH = r.getHeight() - (ins.top + ins.bottom);
        int txtY = availH >= txtH ? txtH + ins.top + (availH / 2 - txtH / 2) - fm.getMaxDescent() : fm.getMaxAscent();
        int txtX = r.getIndent();
        Icon icon = r.getIcon();
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            int iconY = availH > icon.getIconHeight() ? ins.top + (availH / 2 - icon.getIconHeight() / 2) : (availH == icon.getIconHeight() ? 0 : ins.top);
            int iconX = ins.left + r.getIndent() + 1;
            try {
                icon.paintIcon(r, g, iconX, iconY);
            }
            catch (NullPointerException npe) {
                ErrorManager.getDefault().annotate(npe, 4096, "Probably an ImageIcon with a null source image: " + icon + " - " + r.getText(), null, null, null);
                ErrorManager.getDefault().notify(npe);
            }
            txtX = iconX + icon.getIconWidth() + r.getIconTextGap();
        } else {
            txtX += ins.left;
        }
        String text = r.getText();
        if (text == null) {
            return;
        }
        int txtW = icon != null ? r.getWidth() - (ins.left + ins.right + icon.getIconWidth() + r.getIconTextGap() + r.getIndent()) : r.getWidth() - (ins.left + ins.right + r.getIndent());
        Color foreground = HtmlLabelUI.ensureContrastingColor(HtmlLabelUI.getForegroundFor(r), HtmlLabelUI.getBackgroundFor(r));
        if (r.isHtml()) {
            HtmlRenderer.renderHTML(text, g, txtX, txtY, txtW, txtH, f, foreground, r.getRenderStyle(), true);
        } else {
            HtmlRenderer.renderString(text, g, txtX, txtY, txtW, txtH, f, foreground, r.getRenderStyle(), true);
        }
    }

    private void paintIconAndTextCentered(Graphics g, HtmlRendererImpl r) {
        int txtW;
        Insets ins = r.getInsets();
        Icon ic = r.getIcon();
        int w = r.getWidth() - (ins.left + ins.right);
        int txtX = ins.left;
        int txtY = 0;
        if (ic != null && ic.getIconWidth() > 0 && ic.getIconHeight() > 0) {
            int iconx = w > ic.getIconWidth() ? w / 2 - ic.getIconWidth() / 2 : txtX;
            int icony = 0;
            ic.paintIcon(r, g, iconx, icony);
            txtY += ic.getIconHeight() + r.getIconTextGap();
        }
        txtX = (txtW = r.getPreferredSize().width) < r.getWidth() ? r.getWidth() / 2 - txtW / 2 : 0;
        int txtH = r.getHeight() - txtY;
        Font f = r.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        txtY += fm.getMaxAscent();
        Color background = HtmlLabelUI.getBackgroundFor(r);
        Color foreground = HtmlLabelUI.ensureContrastingColor(HtmlLabelUI.getForegroundFor(r), background);
        if (r.isHtml()) {
            HtmlRenderer._renderHTML(r.getText(), 0, g, txtX, txtY, txtW, txtH, f, foreground, r.getRenderStyle(), true, background);
        } else {
            HtmlRenderer.renderString(r.getText(), g, txtX, txtY, txtW, txtH, r.getFont(), foreground, r.getRenderStyle(), true);
        }
    }

    static Color ensureContrastingColor(Color fg, Color bg) {
        if (bg == null && (bg = UIManager.getColor("text")) == null) {
            bg = Color.WHITE;
        }
        if (Color.BLACK.equals(fg) && Color.WHITE.equals(fg)) {
            return fg;
        }
        boolean replace = fg.equals(bg);
        int dif = 0;
        if (!replace) {
            dif = HtmlLabelUI.difference(fg, bg);
            boolean bl = replace = dif < 80;
        }
        if (replace) {
            int avg = (bg.getRed() + bg.getGreen() + bg.getBlue()) / 3;
            boolean darker = avg >= 128;
            fg = darker ? Color.BLACK : Color.WHITE;
        }
        return fg;
    }

    private static int difference(Color a, Color b) {
        int avg1 = (b.getRed() + b.getGreen() + b.getBlue()) / 3;
        int avg2 = (a.getRed() + a.getGreen() + a.getBlue()) / 3;
        return Math.abs(avg1 - avg2);
    }

    static Color getBackgroundFor(HtmlRendererImpl r) {
        if (r.isOpaque()) {
            return r.getBackground();
        }
        if (r.isSelected() && !r.isParentFocused() && !HtmlLabelUI.isGTK()) {
            return HtmlLabelUI.getUnfocusedSelectionBackground();
        }
        if (HtmlLabelUI.isGTK()) {
            // empty if block
        }
        Color result = null;
        if (r.isSelected()) {
            switch (r.getType()) {
                case 1: {
                    result = UIManager.getColor("List.selectionBackground");
                    if (result != null) break;
                    result = UIManager.getColor("Tree.selectionBackground");
                    break;
                }
                case 2: {
                    result = UIManager.getColor("Table.selectionBackground");
                    break;
                }
                case 0: {
                    return UIManager.getColor("Tree.selectionBackground");
                }
            }
            return result == null ? r.getBackground() : result;
        }
        return null;
    }

    static Color getForegroundFor(HtmlRendererImpl r) {
        if (r.isSelected() && !r.isParentFocused()) {
            return HtmlLabelUI.getUnfocusedSelectionForeground();
        }
        if (!r.isEnabled()) {
            return UIManager.getColor("textInactiveText");
        }
        Color result = null;
        if (r.isSelected()) {
            switch (r.getType()) {
                case 1: {
                    result = UIManager.getColor("List.selectionForeground");
                }
                case 2: {
                    result = UIManager.getColor("Table.selectionForeground");
                }
                case 0: {
                    result = UIManager.getColor("Tree.selectionForeground");
                }
            }
        }
        return result == null ? r.getForeground() : result;
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            unfocusedSelBg = unfocusedSelBg.brighter();
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    public static final boolean gtkShouldAntialias() {
        if (gtkAA == null) {
            Object o = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/Antialias");
            gtkAA = new Integer(1).equals(o) ? Boolean.TRUE : Boolean.FALSE;
        }
        return gtkAA;
    }

    static {
        $assertionsDisabled = !HtmlLabelUI.class.desiredAssertionStatus();
        antialias = Boolean.getBoolean("nb.cellrenderer.antialiasing") || Boolean.getBoolean("swing.aatext") || "GTK".equals(UIManager.getLookAndFeel().getID()) && HtmlLabelUI.gtkShouldAntialias();
        uiInstance = null;
        FIXED_HEIGHT = 0;
        String ht = System.getProperty("nb.cellrenderer.fixedheight");
        if (ht != null) {
            try {
                FIXED_HEIGHT = Integer.parseInt(ht);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hintsMap = null;
        unfocusedSelBg = null;
        unfocusedSelFg = null;
        gtkAA = null;
    }
}

