/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class SwingBrowserImpl
extends HtmlBrowser.Impl
implements Runnable {
    private static final int NO_NAVIGATION = 1;
    private static final int NAVIGATION_BACK = 2;
    private static final int NAVIGATION_FWD = 3;
    private URL url;
    private URL loadingURL;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String statusMessage = "";
    private SwingBrowser swingBrowser = new SwingBrowser();
    private Vector historyList = new Vector(5, 3);
    private int historyIndex = -1;
    private int historyNavigating = 1;
    private static RequestProcessor rp;
    private String title = null;
    boolean fetchingTitle = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    SwingBrowserImpl() {
        this.swingBrowser.addPropertyChangeListener("page", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof URL) {
                    URL old = SwingBrowserImpl.this.url;
                    SwingBrowserImpl.this.url = (URL)evt.getNewValue();
                    SwingBrowserImpl.this.pcs.firePropertyChange("url", old, SwingBrowserImpl.this.url);
                    if (((URL)evt.getNewValue()).equals(SwingBrowserImpl.this.loadingURL)) {
                        SwingBrowserImpl.this.loadingURL = null;
                    }
                    if (SwingBrowserImpl.this.historyNavigating == 2) {
                        int idx = SwingBrowserImpl.this.historyList.lastIndexOf(evt.getNewValue(), SwingBrowserImpl.this.historyIndex - 1);
                        if (idx != -1) {
                            SwingBrowserImpl.this.historyIndex = idx;
                        }
                    } else if (SwingBrowserImpl.this.historyNavigating == 3) {
                        int idx = SwingBrowserImpl.this.historyList.indexOf(evt.getNewValue(), SwingBrowserImpl.this.historyIndex + 1);
                        if (idx != -1) {
                            SwingBrowserImpl.this.historyIndex = idx;
                        }
                    } else {
                        while (SwingBrowserImpl.this.historyList.size() > SwingBrowserImpl.this.historyIndex + 1) {
                            SwingBrowserImpl.this.historyList.remove(SwingBrowserImpl.this.historyList.size() - 1);
                        }
                        SwingBrowserImpl.this.historyList.add(evt.getNewValue());
                        SwingBrowserImpl.this.historyIndex = SwingBrowserImpl.this.historyList.size() - 1;
                    }
                    SwingBrowserImpl.this.historyNavigating = 1;
                    SwingBrowserImpl.this.pcs.firePropertyChange("backward", null, null);
                    SwingBrowserImpl.this.pcs.firePropertyChange("forward", null, null);
                    SwingUtilities.invokeLater(SwingBrowserImpl.this);
                }
            }
        });
    }

    public Component getComponent() {
        return this.swingBrowser;
    }

    public synchronized void reloadDocument() {
        try {
            if (this.url == null || this.loadingURL != null) {
                return;
            }
            Document doc = this.swingBrowser.getDocument();
            if (doc != null) {
                doc.putProperty("stream", null);
            }
            this.loadingURL = this.url;
            if (doc instanceof AbstractDocument) {
                String protocol = this.url.getProtocol();
                if ("ftp".equalsIgnoreCase(protocol) || "http".equalsIgnoreCase(protocol)) {
                    ((AbstractDocument)doc).setAsynchronousLoadPriority(5);
                } else {
                    ((AbstractDocument)doc).setAsynchronousLoadPriority(-1);
                }
            }
            rp.post(this);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, e);
            this.statusMessage = "" + e;
            this.pcs.firePropertyChange("statusMessage", null, this.statusMessage);
        }
    }

    public void stopLoading() {
    }

    public synchronized void setURL(URL url) {
        try {
            if (url == null) {
                return;
            }
            this.loadingURL = url;
            if (this.url != null && this.url.sameFile(url)) {
                if ("nbfs".equals(url.getProtocol())) {
                    boolean sameHosts = true;
                } else {
                    boolean sameHosts = url.getHost() != null && this.url != null && url.getHost().equals(this.url.getHost());
                }
                Document doc = this.swingBrowser.getDocument();
                if (doc != null) {
                    doc.putProperty("stream", null);
                }
            }
            rp.post(this);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, e);
            this.statusMessage = "" + e;
            this.pcs.firePropertyChange("statusMessage", null, this.statusMessage);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getTitle() {
        if (this.title == null) {
            Mutex.EVENT.readAccess(this);
        }
        return this.title == null ? NbBundle.getMessage(SwingBrowserImpl.class, "LBL_Loading") : this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTitle() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.fetchingTitle) {
            return;
        }
        this.fetchingTitle = true;
        String oldTitle = this.getTitle();
        try {
            URL url;
            Document d = this.swingBrowser.getDocument();
            this.title = (String)d.getProperty("title");
            if ((this.title == null || this.title.trim().length() == 0) && (url = this.getURL()) != null) {
                this.title = url.getFile();
                if (this.title.length() == 0) {
                    this.title = NbBundle.getMessage(SwingBrowserImpl.class, "LBL_Untitled");
                } else {
                    int i = this.title.lastIndexOf("/");
                    if (i != -1 && i != this.title.length() - 1) {
                        this.title = this.title.substring(i + 1);
                    }
                }
            }
            if (this.title != null) {
                if (this.title.length() > 60) {
                    this.title = NbBundle.getMessage(SwingBrowserImpl.class, "LBL_Title", new Object[]{this.title.substring(0, 57)});
                }
                if (!oldTitle.equals(this.title)) {
                    this.pcs.firePropertyChange("title", oldTitle, this.title);
                }
            }
        }
        finally {
            this.fetchingTitle = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.title = null;
            this.updateTitle();
        } else {
            SwingBrowserImpl swingBrowserImpl = this;
            synchronized (swingBrowserImpl) {
                try {
                    this.swingBrowser.setPage(this.loadingURL);
                    this.setStatusText(null);
                }
                catch (UnknownHostException uhe) {
                    this.setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, "FMT_UnknownHost", new Object[]{this.loadingURL}));
                }
                catch (NoRouteToHostException nrthe) {
                    this.setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, "FMT_NoRouteToHost", new Object[]{this.loadingURL}));
                }
                catch (IOException ioe) {
                    this.setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, "FMT_InvalidURL", new Object[]{this.loadingURL}));
                }
                SwingUtilities.invokeLater(this);
                this.loadingURL = null;
            }
        }
    }

    void setStatusText(String s) {
        this.statusMessage = s;
        this.pcs.firePropertyChange("statusMessage", null, this.statusMessage);
    }

    public boolean isForward() {
        return this.historyIndex >= 0 && this.historyIndex < this.historyList.size() - 1 && this.historyNavigating == 1;
    }

    public void forward() {
        if (this.isForward()) {
            this.historyNavigating = 3;
            this.setURL((URL)this.historyList.elementAt(this.historyIndex + 1));
        }
    }

    public boolean isBackward() {
        return this.historyIndex > 0 && this.historyIndex < this.historyList.size() && this.historyNavigating == 1;
    }

    public void backward() {
        if (this.isBackward()) {
            this.historyNavigating = 2;
            this.setURL((URL)this.historyList.elementAt(this.historyIndex - 1));
        }
    }

    public boolean isHistory() {
        return false;
    }

    public void showHistory() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    static {
        $assertionsDisabled = !SwingBrowserImpl.class.desiredAssertionStatus();
        rp = new RequestProcessor("Swing Browser");
    }

    private static class FilteredInputStream
    extends FilterInputStream {
        private final URLConnection conn;
        private final SwingBrowserImpl browser;

        FilteredInputStream(URLConnection conn, SwingBrowserImpl browser) {
            super(null);
            this.conn = conn;
            this.browser = browser;
        }

        private synchronized void openStream() throws IOException {
            if (this.in == null) {
                this.in = this.conn.getInputStream();
            }
        }

        public int available() throws IOException {
            this.openStream();
            return super.available();
        }

        public long skip(long n) throws IOException {
            this.openStream();
            return super.skip(n);
        }

        public void reset() throws IOException {
            this.openStream();
            super.reset();
        }

        public void close() throws IOException {
            this.openStream();
            super.close();
            Mutex.EVENT.readAccess(this.browser);
        }

        public int read(byte[] b) throws IOException {
            this.openStream();
            return super.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.openStream();
            return super.read(b, off, len);
        }

        public int read() throws IOException {
            this.openStream();
            return super.read();
        }
    }

    private class SwingBrowser
    extends JEditorPane {
        private boolean lastPaintException = false;

        private SwingBrowser() {
            this.setEditable(false);
            this.setEditorKitForContentType("text/html", new HTMLEditorKit());
            this.addHyperlinkListener(new HyperlinkListener(this, SwingBrowserImpl.this){
                private final /* synthetic */ SwingBrowserImpl val$this$0;
                private final /* synthetic */ SwingBrowser this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (e instanceof HTMLFrameHyperlinkEvent) {
                            HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                            HTMLDocument doc = (HTMLDocument)this.this$1.getDocument();
                            URL old = SwingBrowser.access$700(this.this$1).getURL();
                            doc.processHTMLFrameHyperlinkEvent(evt);
                            SwingBrowserImpl.access$200(SwingBrowser.access$700(this.this$1)).firePropertyChange("url", old, e.getURL());
                        } else {
                            try {
                                SwingBrowser.access$700(this.this$1).setURL(e.getURL());
                            }
                            catch (Exception ex) {
                                ErrorManager.getDefault().notify(1, ex);
                            }
                        }
                    }
                }
            });
        }

        protected InputStream getStream(URL page) throws IOException {
            SwingUtilities.invokeLater(SwingBrowserImpl.this);
            if (Boolean.getBoolean("org.openide.awt.SwingBrowserImpl.do-not-block-awt")) {
                this.setContentType("text/html");
                return new FilteredInputStream(page.openConnection(), SwingBrowserImpl.this);
            }
            return super.getStream(page);
        }

        public Dimension getPreferredSize() {
            try {
                return super.getPreferredSize();
            }
            catch (RuntimeException e) {
                return new Dimension(400, 600);
            }
        }

        public void paint(Graphics g) {
            try {
                super.paint(g);
                this.lastPaintException = false;
            }
            catch (RuntimeException e) {
                if (!this.lastPaintException) {
                    this.repaint();
                }
                this.lastPaintException = true;
            }
        }

        static /* synthetic */ SwingBrowserImpl access$700(SwingBrowser x0) {
            return x0.SwingBrowserImpl.this;
        }
    }
}

