/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.propertysheet.Boolean3WayEditor;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CheckboxInplaceEditor;
import org.openide.explorer.propertysheet.ComboInplaceEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.IconPanel;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.RadioInplaceEditor;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.explorer.propertysheet.StringInplaceEditor;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

class RendererFactory {
    private StringRenderer stringRenderer = null;
    private CheckboxRenderer checkboxRenderer = null;
    private ComboboxRenderer comboboxRenderer = null;
    private RadioRenderer radioRenderer = null;
    private TextFieldRenderer textFieldRenderer = null;
    private ButtonPanel buttonPanel = null;
    private IconPanel iconPanel = null;
    ReusablePropertyModel mdl;
    ReusablePropertyEnv env;
    private boolean tableUI;
    private boolean suppressButton = false;
    private int radioButtonMax = -1;
    private boolean useRadioBoolean = PropUtils.forceRadioButtons;
    private boolean useLabels = false;

    public RendererFactory(boolean tableUI, ReusablePropertyEnv env, ReusablePropertyModel mdl) {
        this.tableUI = tableUI;
        this.env = env;
        this.mdl = mdl;
    }

    public void setRadioButtonMax(int i) {
        this.radioButtonMax = i;
    }

    public void setSuppressButton(boolean val) {
        this.suppressButton = val;
    }

    void setUseRadioBoolean(boolean val) {
        this.useRadioBoolean = val;
    }

    void setUseLabels(boolean val) {
        this.useLabels = val;
    }

    public JComponent getRenderer(Node.Property prop) {
        this.mdl.setProperty(prop);
        this.env.reset();
        PropertyEditor editor = this.preparePropertyEditor(this.mdl, this.env);
        if (editor instanceof ExceptionPropertyEditor) {
            return this.getExceptionRenderer((Exception)editor.getValue());
        }
        JComponent result = null;
        try {
            if (editor.isPaintable()) {
                result = this.prepareString(editor, this.env);
            } else {
                Class c = this.mdl.getPropertyType();
                if (c == Boolean.class || c == Boolean.TYPE) {
                    boolean useRadioRenderer;
                    boolean bl = useRadioRenderer = this.useRadioBoolean || this.env.getFeatureDescriptor().getValue("stringValues") != null;
                    result = useRadioRenderer ? this.prepareRadioButtons(editor, this.env) : this.prepareCheckbox(editor, this.env);
                } else if (editor.getTags() != null) {
                    String[] s = editor.getTags();
                    boolean editAsText = Boolean.TRUE.equals(prop.getValue("canEditAsText"));
                    result = s.length <= this.radioButtonMax && !editAsText ? this.prepareRadioButtons(editor, this.env) : this.prepareCombobox(editor, this.env);
                } else {
                    result = this.prepareString(editor, this.env);
                }
            }
            if (result != this.radioRenderer && result != this.textFieldRenderer) {
                if (result != this.checkboxRenderer && this.tableUI) {
                    result.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
                } else if (!(result instanceof JComboBox) && !(result instanceof JCheckBox)) {
                    result.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
                }
            }
        }
        catch (Exception e) {
            result = this.getExceptionRenderer(e);
            ErrorManager.getDefault().annotate(e, 16, null, null, null, null);
            ErrorManager.getDefault().notify(e);
        }
        result.setEnabled(prop.canWrite());
        boolean propRequestsSuppressButton = Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        if (!(result instanceof JLabel)) {
            if (this.env.getState() == ReusablePropertyEnv.STATE_INVALID || prop.getValue("valueIcon") != null) {
                result = this.prepareIconPanel(editor, this.env, (InplaceEditor)((Object)result));
            }
        }
        if (editor.supportsCustomEditor() && !PropUtils.noCustomButtons && !this.suppressButton && !propRequestsSuppressButton) {
            ButtonPanel bp = this.buttonPanel();
            bp.setInplaceEditor((InplaceEditor)((Object)result));
            result = bp;
        }
        return result;
    }

    private IconPanel prepareIconPanel(PropertyEditor ed, PropertyEnv env, InplaceEditor inner) {
        IconPanel icp = this.iconPanel();
        icp.setInplaceEditor(inner);
        icp.connect(ed, env);
        return icp;
    }

    private PropertyEditor preparePropertyEditor(PropertyModel pm, PropertyEnv env) {
        PropertyEditor result;
        block11: {
            try {
                if (pm instanceof NodePropertyModel) {
                    result = ((NodePropertyModel)pm).getPropertyEditor();
                    break block11;
                }
                if (pm instanceof ReusablePropertyModel) {
                    result = ((ReusablePropertyModel)pm).getPropertyEditor();
                    break block11;
                }
                Class c = pm.getPropertyEditorClass();
                if (c != null) {
                    try {
                        result = (PropertyEditor)c.newInstance();
                        Object mdlValue = pm.getValue();
                        Object edValue = result.getValue();
                        if (edValue != mdlValue) {
                            result.setValue(pm.getValue());
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        result = new ExceptionPropertyEditor(e);
                    }
                    break block11;
                }
                result = PropUtils.getPropertyEditor(pm.getPropertyType());
                try {
                    result.setValue(pm.getValue());
                }
                catch (InvocationTargetException ite) {
                    result = new ExceptionPropertyEditor(ite);
                }
            }
            catch (Exception e) {
                result = new ExceptionPropertyEditor(e);
            }
        }
        if (result instanceof ExPropertyEditor) {
            ((ExPropertyEditor)result).attachEnv(env);
        }
        return result;
    }

    private JComponent getExceptionRenderer(Exception e) {
        ExceptionRenderer lbl = new ExceptionRenderer();
        lbl.setForeground(PropUtils.getErrorColor());
        lbl.setText(e.getMessage());
        return lbl;
    }

    public JComponent getStringRenderer() {
        StringRenderer result = this.stringRenderer();
        result.clear();
        result.setEnabled(true);
        return result;
    }

    private JComponent prepareRadioButtons(PropertyEditor editor, PropertyEnv env) {
        RadioRenderer ren = this.radioRenderer();
        ren.clear();
        ren.setUseTitle(this.useLabels);
        ren.connect(editor, env);
        return ren.getComponent();
    }

    private JComponent prepareCombobox(PropertyEditor editor, PropertyEnv env) {
        ComboboxRenderer ren = this.comboboxRenderer();
        ren.clear();
        ren.setEnabled(true);
        ren.connect(editor, env);
        return ren.getComponent();
    }

    private JComponent prepareString(PropertyEditor editor, PropertyEnv env) {
        StringRenderer ren = this.tableUI || editor.isPaintable() ? this.stringRenderer() : this.textFieldRenderer();
        ren.clear();
        ren.getComponent().setEnabled(true);
        ren.connect(editor, env);
        return ren.getComponent();
    }

    private JComponent prepareCheckbox(PropertyEditor editor, PropertyEnv env) {
        CheckboxRenderer ren = this.checkboxRenderer();
        ren.setUseTitle(this.useLabels);
        ren.clear();
        ren.setEnabled(true);
        ren.connect(editor, env);
        return ren.getComponent();
    }

    private ButtonPanel buttonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new ButtonPanel();
        }
        this.buttonPanel.setEnabled(true);
        return this.buttonPanel;
    }

    private IconPanel iconPanel() {
        if (this.iconPanel == null) {
            this.iconPanel = new IconPanel();
        }
        this.iconPanel.setEnabled(true);
        return this.iconPanel;
    }

    private ComboboxRenderer comboboxRenderer() {
        if (this.comboboxRenderer == null) {
            this.comboboxRenderer = new ComboboxRenderer(this.tableUI);
            this.comboboxRenderer.setName("ComboboxRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.comboboxRenderer;
    }

    private StringRenderer stringRenderer() {
        if (this.stringRenderer == null) {
            this.stringRenderer = new StringRenderer(this.tableUI);
            this.stringRenderer.setName("StringRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.stringRenderer;
    }

    private CheckboxRenderer checkboxRenderer() {
        if (this.checkboxRenderer == null) {
            this.checkboxRenderer = new CheckboxRenderer();
            this.checkboxRenderer.setName("CheckboxRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.checkboxRenderer;
    }

    private RadioRenderer radioRenderer() {
        if (this.radioRenderer == null) {
            this.radioRenderer = new RadioRenderer(this.tableUI);
            this.radioRenderer.setName("RadioRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.radioRenderer;
    }

    private TextFieldRenderer textFieldRenderer() {
        if (this.textFieldRenderer == null) {
            this.textFieldRenderer = new TextFieldRenderer();
        }
        return this.textFieldRenderer;
    }

    private class ExceptionRenderer
    extends JLabel
    implements InplaceEditor {
        private ExceptionRenderer() {
        }

        public void addActionListener(ActionListener al) {
        }

        public Color getForeground() {
            return PropUtils.getErrorColor();
        }

        public void clear() {
        }

        public void connect(PropertyEditor pe, PropertyEnv env) {
        }

        public JComponent getComponent() {
            return this;
        }

        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        public PropertyEditor getPropertyEditor() {
            return null;
        }

        public PropertyModel getPropertyModel() {
            return null;
        }

        public Object getValue() {
            return this.getText();
        }

        public boolean isKnownComponent(Component c) {
            return c == this;
        }

        public void removeActionListener(ActionListener al) {
        }

        public void reset() {
        }

        public void setPropertyModel(PropertyModel pm) {
        }

        public void setValue(Object o) {
        }

        public boolean supportsTextEntry() {
            return false;
        }
    }

    private static final class ExceptionPropertyEditor
    implements PropertyEditor {
        Exception e;

        public ExceptionPropertyEditor(Exception e) {
            this.e = e;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public String getAsText() {
            return this.e.getMessage();
        }

        public Component getCustomEditor() {
            return null;
        }

        public String getJavaInitializationString() {
            return null;
        }

        public String[] getTags() {
            return null;
        }

        public Object getValue() {
            return this.e;
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics gfx, Rectangle box) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public void setAsText(String text) throws IllegalArgumentException {
        }

        public void setValue(Object value) {
        }

        public boolean supportsCustomEditor() {
            return false;
        }
    }

    private static final class RadioRenderer
    extends RadioInplaceEditor {
        private boolean needLayout = true;

        public RadioRenderer(boolean tableUI) {
            super(tableUI);
        }

        public void connect(PropertyEditor pe, PropertyEnv env) {
            super.connect(pe, env);
            this.needLayout = true;
        }

        public void paint(Graphics g) {
            if (this.needLayout) {
                this.getLayout().layoutContainer(this);
                this.needLayout = false;
            }
            super.paint(g);
            this.clear();
        }

        protected RadioInplaceEditor.InvRadioButton createButton() {
            return new NoEventsInvRadioButton();
        }

        protected void configureButton(RadioInplaceEditor.InvRadioButton ire, String txt) {
            if (this.editor.getTags().length == 1) {
                ire.setEnabled(false);
            } else {
                ire.setEnabled(this.isEnabled());
            }
            ire.setText(txt);
            ire.setForeground(this.getForeground());
            ire.setBackground(this.getBackground());
            ire.setFont(this.getFont());
            if (txt.equals(this.editor.getAsText())) {
                ire.setSelected(true);
            } else {
                ire.setSelected(false);
            }
        }

        public void addContainerListener(ContainerListener cl) {
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void addComponentListener(ComponentListener l) {
        }

        public void addHierarchyBoundsListener(HierarchyBoundsListener hbl) {
        }

        public void addHierarchyListener(HierarchyListener hl) {
        }

        protected void firePropertyChange(String name, Object old, Object nue) {
        }

        public void firePropertyChange(String name, boolean old, boolean nue) {
        }

        public void firePropertyChange(String name, int old, int nue) {
        }

        public void firePropertyChange(String name, byte old, byte nue) {
        }

        public void firePropertyChange(String name, char old, char nue) {
        }

        public void firePropertyChange(String name, double old, double nue) {
        }

        public void firePropertyChange(String name, float old, float nue) {
        }

        public void firePropertyChange(String name, short old, short nue) {
        }

        private class NoEventsInvRadioButton
        extends RadioInplaceEditor.InvRadioButton {
            private NoEventsInvRadioButton() {
            }

            public void addActionListener(ActionListener al) {
            }

            public void addContainerListener(ContainerListener cl) {
            }

            public void addChangeListener(ChangeListener cl) {
            }

            public void addComponentListener(ComponentListener l) {
            }

            public void addHierarchyBoundsListener(HierarchyBoundsListener hbl) {
            }

            public void addHierarchyListener(HierarchyListener hl) {
            }

            protected void fireActionPerformed(ActionEvent ae) {
            }

            protected void fireStateChanged() {
            }

            protected void firePropertyChange(String name, Object old, Object nue) {
            }

            public void firePropertyChange(String name, boolean old, boolean nue) {
            }

            public void firePropertyChange(String name, int old, int nue) {
            }

            public void firePropertyChange(String name, byte old, byte nue) {
            }

            public void firePropertyChange(String name, char old, char nue) {
            }

            public void firePropertyChange(String name, double old, double nue) {
            }

            public void firePropertyChange(String name, float old, float nue) {
            }

            public void firePropertyChange(String name, short old, short nue) {
            }
        }
    }

    private static final class TextFieldRenderer
    extends StringInplaceEditor {
        private TextFieldRenderer() {
        }

        public void paintComponent(Graphics g) {
            this.setEnabled(PropUtils.checkEnabled(this, this.editor, this.env));
            super.paintComponent(g);
            this.clear();
        }

        protected void fireActionPerformed(ActionEvent ae) {
        }

        protected void fireStateChanged() {
        }

        protected void firePropertyChange(String name, Object old, Object nue) {
            boolean fire;
            boolean bl = fire = "locale".equals(name) || "document".equals(name);
            if (fire) {
                super.firePropertyChange(name, old, nue);
            }
        }
    }

    private static final class StringRenderer
    extends JLabel
    implements InplaceEditor {
        private PropertyEditor editor = null;
        private PropertyEnv env = null;
        private boolean tableUI = false;
        private boolean enabled = true;
        private JLabel htmlLabel = HtmlRenderer.createLabel();
        private Object value = null;

        public StringRenderer(boolean tableUI) {
            this.tableUI = tableUI;
            this.setOpaque(true);
        }

        public void setEnabled(boolean val) {
            this.enabled = val;
        }

        public void setText(String s) {
            if (s != null) {
                if (s.length() > 512) {
                    super.setText(s.substring(0, 512));
                } else {
                    super.setText(s);
                }
            } else {
                super.setText("");
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        protected void firePropertyChange(String name, Object old, Object nue) {
        }

        public void validate() {
        }

        public void invalidate() {
        }

        public void revalidate() {
        }

        public void repaint() {
        }

        public void repaint(long tm, int x, int y, int w, int h) {
        }

        public Dimension getPreferredSize() {
            if (this.getText().length() > 1024) {
                return new Dimension(4196, PropUtils.getMinimumPropPanelHeight());
            }
            Dimension result = super.getPreferredSize();
            result.width = Math.max(result.width, PropUtils.getMinimumPropPanelWidth());
            result.height = Math.max(result.height, PropUtils.getMinimumPropPanelHeight());
            return result;
        }

        public void paint(Graphics g) {
            if (this.editor != null) {
                this.setEnabled(PropUtils.checkEnabled(this, this.editor, this.env));
            }
            if (this.editor instanceof ExceptionPropertyEditor) {
                this.setForeground(PropUtils.getErrorColor());
            }
            if (this.editor != null && this.editor.isPaintable()) {
                this.delegatedPaint(g);
            } else {
                JLabel lbl = this.htmlLabel;
                String text = this.getText();
                if (text != null && text.length() < 512) {
                    ((HtmlRenderer.Renderer)((Object)this.htmlLabel)).setHtml(text.startsWith("<html") || text.startsWith("<HTML"));
                } else {
                    ((HtmlRenderer.Renderer)((Object)this.htmlLabel)).setHtml(false);
                }
                lbl.setFont(this.getFont());
                lbl.setEnabled(this.isEnabled());
                lbl.setText(text == null ? "" : text);
                lbl.setIcon(this.getIcon());
                lbl.setIconTextGap(this.getIconTextGap());
                lbl.setBounds(this.getBounds());
                lbl.setOpaque(true);
                lbl.setBackground(this.getBackground());
                lbl.setForeground(this.getForeground());
                lbl.paint(g);
            }
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delegatedPaint(Graphics g) {
            Color c = g.getColor();
            try {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(this.getForeground());
                if (!this.tableUI) {
                    Border b = BorderFactory.createBevelBorder(1);
                    b.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
                }
                Rectangle r = this.getBounds();
                r.x = this.getWidth() > 16 ? (this.editor instanceof Boolean3WayEditor ? 0 : 3) : 0;
                r.width = r.width - (this.getWidth() > 16 ? (this.editor instanceof Boolean3WayEditor ? 0 : 3) : 0);
                r.y = 0;
                this.editor.paintValue(g, r);
            }
            finally {
                g.setColor(c);
            }
        }

        public void clear() {
            this.editor = null;
            this.env = null;
            this.setIcon(null);
            this.setOpaque(true);
        }

        public void setValue(Object o) {
            this.value = o;
            this.setText(this.value instanceof String ? (String)this.value : (this.value != null ? this.value.toString() : null));
        }

        public void connect(PropertyEditor p, PropertyEnv env) {
            this.editor = p;
            this.env = env;
            this.reset();
        }

        public JComponent getComponent() {
            return this;
        }

        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        public PropertyModel getPropertyModel() {
            return null;
        }

        public Object getValue() {
            return this.getText();
        }

        public void handleInitialInputEvent(InputEvent e) {
        }

        public boolean isKnownComponent(Component c) {
            return false;
        }

        public void removeActionListener(ActionListener al) {
        }

        public void reset() {
            this.setText(this.editor.getAsText());
            Image i = null;
            if (this.env != null) {
                if (this.env.getState() == PropertyEnv.STATE_INVALID) {
                    this.setForeground(PropUtils.getErrorColor());
                    i = Utilities.loadImage("org/openide/resources/propertysheet/invalid.gif");
                } else {
                    Object o = this.env.getFeatureDescriptor().getValue("valueIcon");
                    if (o instanceof Icon) {
                        this.setIcon((Icon)o);
                    } else if (o instanceof Image) {
                        i = (Image)o;
                    }
                }
            }
            if (i != null) {
                this.setIcon(new ImageIcon(i));
            }
        }

        public void setPropertyModel(PropertyModel pm) {
        }

        public boolean supportsTextEntry() {
            return false;
        }

        protected void fireActionPerformed(ActionEvent ae) {
        }

        protected void fireStateChanged() {
        }

        public void addActionListener(ActionListener al) {
        }
    }

    private static final class CheckboxRenderer
    extends CheckboxInplaceEditor {
        private CheckboxRenderer() {
        }

        public void paintComponent(Graphics g) {
            this.setEnabled(PropUtils.checkEnabled(this, this.editor, this.env));
            super.paintComponent(g);
            this.clear();
        }

        protected void fireActionPerformed(ActionEvent ae) {
        }

        protected void fireStateChanged() {
        }

        protected void firePropertyChange(String name, Object old, Object nue) {
            if ("foreground".equals(name) || "background".equals(name) || "font".equals(name)) {
                super.firePropertyChange(name, old, nue);
            }
        }

        public void firePropertyChange(String name, boolean old, boolean nue) {
        }

        public void firePropertyChange(String name, int old, int nue) {
        }

        public void firePropertyChange(String name, byte old, byte nue) {
        }

        public void firePropertyChange(String name, char old, char nue) {
        }

        public void firePropertyChange(String name, double old, double nue) {
        }

        public void firePropertyChange(String name, float old, float nue) {
        }

        public void firePropertyChange(String name, short old, short nue) {
        }
    }

    static final class ComboboxRenderer
    extends ComboInplaceEditor {
        private Object item = null;
        boolean editable = false;
        private boolean tableUI;

        public ComboboxRenderer(boolean tableUI) {
            super(tableUI);
            this.tableUI = tableUI;
        }

        public boolean isEditable() {
            return false;
        }

        public void paintComponent(Graphics g) {
            this.setEnabled(this.isEnabled() && PropUtils.checkEnabled(this, this.editor, this.env));
            this.doLayout();
            super.paintComponent(g);
            this.clear();
        }

        public void clear() {
            super.clear();
            this.item = null;
        }

        public void setSelectedItem(Object o) {
            this.item = o;
            if (this.item == null && this.editor != null && this.editor.getTags().length > 0) {
                this.item = this.editor.getTags()[0];
            }
            if (this.editable) {
                this.getEditor().setItem(this.getSelectedItem());
            }
        }

        public Object getSelectedItem() {
            return this.item;
        }

        public void installAncestorListener() {
        }

        public void processFocusEvent(FocusEvent fe) {
        }

        public void processMouseEvent(MouseEvent me) {
        }

        public void addActionListener(ActionListener ae) {
        }

        protected void fireActionPerformed(ActionEvent ae) {
        }

        protected void fireStateChanged() {
        }

        protected void firePropertyChange(String name, Object old, Object nue) {
            super.firePropertyChange(name, old, nue);
        }
    }
}

